# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class VirtualPrivateCloudRouteTableCreationParams(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'routes': 'list[VirtualPrivateCloudRouteParams]',
        'vpc_id': 'str',
        'description': 'str',
        'name': 'str'
    }

    attribute_map = {
        'routes': 'routes',
        'vpc_id': 'vpc_id',
        'description': 'description',
        'name': 'name'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """VirtualPrivateCloudRouteTableCreationParams - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._routes = None
        self._vpc_id = None
        self._description = None
        self._name = None
        self.discriminator = None

        if "routes" in kwargs:
            self.routes = kwargs["routes"]
        if "vpc_id" in kwargs:
            self.vpc_id = kwargs["vpc_id"]
        if "description" in kwargs:
            self.description = kwargs["description"]
        if "name" in kwargs:
            self.name = kwargs["name"]

    @property
    def routes(self):
        """Gets the routes of this VirtualPrivateCloudRouteTableCreationParams.  # noqa: E501


        :return: The routes of this VirtualPrivateCloudRouteTableCreationParams.  # noqa: E501
        :rtype: list[VirtualPrivateCloudRouteParams]
        """
        return self._routes

    @routes.setter
    def routes(self, routes):
        """Sets the routes of this VirtualPrivateCloudRouteTableCreationParams.


        :param routes: The routes of this VirtualPrivateCloudRouteTableCreationParams.  # noqa: E501
        :type routes: list[VirtualPrivateCloudRouteParams]
        """

        self._routes = routes

    @property
    def vpc_id(self):
        """Gets the vpc_id of this VirtualPrivateCloudRouteTableCreationParams.  # noqa: E501


        :return: The vpc_id of this VirtualPrivateCloudRouteTableCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._vpc_id

    @vpc_id.setter
    def vpc_id(self, vpc_id):
        """Sets the vpc_id of this VirtualPrivateCloudRouteTableCreationParams.


        :param vpc_id: The vpc_id of this VirtualPrivateCloudRouteTableCreationParams.  # noqa: E501
        :type vpc_id: str
        """
        if self.local_vars_configuration.client_side_validation and vpc_id is None:  # noqa: E501
            raise ValueError("Invalid value for `vpc_id`, must not be `None`")  # noqa: E501

        self._vpc_id = vpc_id

    @property
    def description(self):
        """Gets the description of this VirtualPrivateCloudRouteTableCreationParams.  # noqa: E501


        :return: The description of this VirtualPrivateCloudRouteTableCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this VirtualPrivateCloudRouteTableCreationParams.


        :param description: The description of this VirtualPrivateCloudRouteTableCreationParams.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def name(self):
        """Gets the name of this VirtualPrivateCloudRouteTableCreationParams.  # noqa: E501


        :return: The name of this VirtualPrivateCloudRouteTableCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this VirtualPrivateCloudRouteTableCreationParams.


        :param name: The name of this VirtualPrivateCloudRouteTableCreationParams.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VirtualPrivateCloudRouteTableCreationParams):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VirtualPrivateCloudRouteTableCreationParams):
            return True

        return self.to_dict() != other.to_dict()
