# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class VirtualPrivateCloudRouterGateway(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'associated_subnets': 'list[NestedVirtualPrivateCloudSubnet]',
        'entity_async_status': 'EntityAsyncStatus',
        'external_ip': 'str',
        'external_ips': 'list[NestedVpcGatewaysCommonExternalIpsType]',
        'external_subnet': 'NestedVirtualPrivateCloudExternalSubnet',
        'external_subnet_group': 'NestedVirtualPrivateCloudExternalSubnetGroup',
        'id': 'str',
        'local_id': 'str',
        'name': 'str',
        'nexthop_ip': 'str',
        'rules': 'list[NestedVpcRouterGatewayRuleType]',
        'vpc': 'NestedVirtualPrivateCloud'
    }

    attribute_map = {
        'associated_subnets': 'associated_subnets',
        'entity_async_status': 'entityAsyncStatus',
        'external_ip': 'external_ip',
        'external_ips': 'external_ips',
        'external_subnet': 'external_subnet',
        'external_subnet_group': 'external_subnet_group',
        'id': 'id',
        'local_id': 'local_id',
        'name': 'name',
        'nexthop_ip': 'nexthop_ip',
        'rules': 'rules',
        'vpc': 'vpc'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """VirtualPrivateCloudRouterGateway - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._associated_subnets = None
        self._entity_async_status = None
        self._external_ip = None
        self._external_ips = None
        self._external_subnet = None
        self._external_subnet_group = None
        self._id = None
        self._local_id = None
        self._name = None
        self._nexthop_ip = None
        self._rules = None
        self._vpc = None
        self.discriminator = None

        self.associated_subnets = kwargs.get("associated_subnets", None)
        self.entity_async_status = kwargs.get("entity_async_status", None)
        self.external_ip = kwargs.get("external_ip", None)
        self.external_ips = kwargs.get("external_ips", None)
        self.external_subnet = kwargs.get("external_subnet", None)
        self.external_subnet_group = kwargs.get("external_subnet_group", None)
        if "id" in kwargs:
            self.id = kwargs["id"]
        if "local_id" in kwargs:
            self.local_id = kwargs["local_id"]
        if "name" in kwargs:
            self.name = kwargs["name"]
        self.nexthop_ip = kwargs.get("nexthop_ip", None)
        if "rules" in kwargs:
            self.rules = kwargs["rules"]
        if "vpc" in kwargs:
            self.vpc = kwargs["vpc"]

    @property
    def associated_subnets(self):
        """Gets the associated_subnets of this VirtualPrivateCloudRouterGateway.  # noqa: E501


        :return: The associated_subnets of this VirtualPrivateCloudRouterGateway.  # noqa: E501
        :rtype: list[NestedVirtualPrivateCloudSubnet]
        """
        return self._associated_subnets

    @associated_subnets.setter
    def associated_subnets(self, associated_subnets):
        """Sets the associated_subnets of this VirtualPrivateCloudRouterGateway.


        :param associated_subnets: The associated_subnets of this VirtualPrivateCloudRouterGateway.  # noqa: E501
        :type associated_subnets: list[NestedVirtualPrivateCloudSubnet]
        """

        self._associated_subnets = associated_subnets

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this VirtualPrivateCloudRouterGateway.  # noqa: E501


        :return: The entity_async_status of this VirtualPrivateCloudRouterGateway.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this VirtualPrivateCloudRouterGateway.


        :param entity_async_status: The entity_async_status of this VirtualPrivateCloudRouterGateway.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def external_ip(self):
        """Gets the external_ip of this VirtualPrivateCloudRouterGateway.  # noqa: E501


        :return: The external_ip of this VirtualPrivateCloudRouterGateway.  # noqa: E501
        :rtype: str
        """
        return self._external_ip

    @external_ip.setter
    def external_ip(self, external_ip):
        """Sets the external_ip of this VirtualPrivateCloudRouterGateway.


        :param external_ip: The external_ip of this VirtualPrivateCloudRouterGateway.  # noqa: E501
        :type external_ip: str
        """

        self._external_ip = external_ip

    @property
    def external_ips(self):
        """Gets the external_ips of this VirtualPrivateCloudRouterGateway.  # noqa: E501


        :return: The external_ips of this VirtualPrivateCloudRouterGateway.  # noqa: E501
        :rtype: list[NestedVpcGatewaysCommonExternalIpsType]
        """
        return self._external_ips

    @external_ips.setter
    def external_ips(self, external_ips):
        """Sets the external_ips of this VirtualPrivateCloudRouterGateway.


        :param external_ips: The external_ips of this VirtualPrivateCloudRouterGateway.  # noqa: E501
        :type external_ips: list[NestedVpcGatewaysCommonExternalIpsType]
        """

        self._external_ips = external_ips

    @property
    def external_subnet(self):
        """Gets the external_subnet of this VirtualPrivateCloudRouterGateway.  # noqa: E501


        :return: The external_subnet of this VirtualPrivateCloudRouterGateway.  # noqa: E501
        :rtype: NestedVirtualPrivateCloudExternalSubnet
        """
        return self._external_subnet

    @external_subnet.setter
    def external_subnet(self, external_subnet):
        """Sets the external_subnet of this VirtualPrivateCloudRouterGateway.


        :param external_subnet: The external_subnet of this VirtualPrivateCloudRouterGateway.  # noqa: E501
        :type external_subnet: NestedVirtualPrivateCloudExternalSubnet
        """

        self._external_subnet = external_subnet

    @property
    def external_subnet_group(self):
        """Gets the external_subnet_group of this VirtualPrivateCloudRouterGateway.  # noqa: E501


        :return: The external_subnet_group of this VirtualPrivateCloudRouterGateway.  # noqa: E501
        :rtype: NestedVirtualPrivateCloudExternalSubnetGroup
        """
        return self._external_subnet_group

    @external_subnet_group.setter
    def external_subnet_group(self, external_subnet_group):
        """Sets the external_subnet_group of this VirtualPrivateCloudRouterGateway.


        :param external_subnet_group: The external_subnet_group of this VirtualPrivateCloudRouterGateway.  # noqa: E501
        :type external_subnet_group: NestedVirtualPrivateCloudExternalSubnetGroup
        """

        self._external_subnet_group = external_subnet_group

    @property
    def id(self):
        """Gets the id of this VirtualPrivateCloudRouterGateway.  # noqa: E501


        :return: The id of this VirtualPrivateCloudRouterGateway.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this VirtualPrivateCloudRouterGateway.


        :param id: The id of this VirtualPrivateCloudRouterGateway.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def local_id(self):
        """Gets the local_id of this VirtualPrivateCloudRouterGateway.  # noqa: E501


        :return: The local_id of this VirtualPrivateCloudRouterGateway.  # noqa: E501
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id):
        """Sets the local_id of this VirtualPrivateCloudRouterGateway.


        :param local_id: The local_id of this VirtualPrivateCloudRouterGateway.  # noqa: E501
        :type local_id: str
        """
        if self.local_vars_configuration.client_side_validation and local_id is None:  # noqa: E501
            raise ValueError("Invalid value for `local_id`, must not be `None`")  # noqa: E501

        self._local_id = local_id

    @property
    def name(self):
        """Gets the name of this VirtualPrivateCloudRouterGateway.  # noqa: E501


        :return: The name of this VirtualPrivateCloudRouterGateway.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this VirtualPrivateCloudRouterGateway.


        :param name: The name of this VirtualPrivateCloudRouterGateway.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def nexthop_ip(self):
        """Gets the nexthop_ip of this VirtualPrivateCloudRouterGateway.  # noqa: E501


        :return: The nexthop_ip of this VirtualPrivateCloudRouterGateway.  # noqa: E501
        :rtype: str
        """
        return self._nexthop_ip

    @nexthop_ip.setter
    def nexthop_ip(self, nexthop_ip):
        """Sets the nexthop_ip of this VirtualPrivateCloudRouterGateway.


        :param nexthop_ip: The nexthop_ip of this VirtualPrivateCloudRouterGateway.  # noqa: E501
        :type nexthop_ip: str
        """

        self._nexthop_ip = nexthop_ip

    @property
    def rules(self):
        """Gets the rules of this VirtualPrivateCloudRouterGateway.  # noqa: E501


        :return: The rules of this VirtualPrivateCloudRouterGateway.  # noqa: E501
        :rtype: list[NestedVpcRouterGatewayRuleType]
        """
        return self._rules

    @rules.setter
    def rules(self, rules):
        """Sets the rules of this VirtualPrivateCloudRouterGateway.


        :param rules: The rules of this VirtualPrivateCloudRouterGateway.  # noqa: E501
        :type rules: list[NestedVpcRouterGatewayRuleType]
        """
        if self.local_vars_configuration.client_side_validation and rules is None:  # noqa: E501
            raise ValueError("Invalid value for `rules`, must not be `None`")  # noqa: E501

        self._rules = rules

    @property
    def vpc(self):
        """Gets the vpc of this VirtualPrivateCloudRouterGateway.  # noqa: E501


        :return: The vpc of this VirtualPrivateCloudRouterGateway.  # noqa: E501
        :rtype: NestedVirtualPrivateCloud
        """
        return self._vpc

    @vpc.setter
    def vpc(self, vpc):
        """Sets the vpc of this VirtualPrivateCloudRouterGateway.


        :param vpc: The vpc of this VirtualPrivateCloudRouterGateway.  # noqa: E501
        :type vpc: NestedVirtualPrivateCloud
        """
        if self.local_vars_configuration.client_side_validation and vpc is None:  # noqa: E501
            raise ValueError("Invalid value for `vpc`, must not be `None`")  # noqa: E501

        self._vpc = vpc

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VirtualPrivateCloudRouterGateway):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VirtualPrivateCloudRouterGateway):
            return True

        return self.to_dict() != other.to_dict()
