# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class VirtualPrivateCloudRouterGatewayCreationParams(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'rules': 'list[VirtualPrivateCloudRouterGatewayRuleInputType]',
        'associated_subnets_ids': 'list[str]',
        'external_ips': 'list[VirtualPrivateCloudExternalIpsParams]',
        'external_subnet_group_id': 'str',
        'external_ip': 'str',
        'external_subnet_id': 'str',
        'vpc_id': 'str',
        'name': 'str'
    }

    attribute_map = {
        'rules': 'rules',
        'associated_subnets_ids': 'associated_subnets_ids',
        'external_ips': 'external_ips',
        'external_subnet_group_id': 'external_subnet_group_id',
        'external_ip': 'external_ip',
        'external_subnet_id': 'external_subnet_id',
        'vpc_id': 'vpc_id',
        'name': 'name'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """VirtualPrivateCloudRouterGatewayCreationParams - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._rules = None
        self._associated_subnets_ids = None
        self._external_ips = None
        self._external_subnet_group_id = None
        self._external_ip = None
        self._external_subnet_id = None
        self._vpc_id = None
        self._name = None
        self.discriminator = None

        if "rules" in kwargs:
            self.rules = kwargs["rules"]
        if "associated_subnets_ids" in kwargs:
            self.associated_subnets_ids = kwargs["associated_subnets_ids"]
        if "external_ips" in kwargs:
            self.external_ips = kwargs["external_ips"]
        if "external_subnet_group_id" in kwargs:
            self.external_subnet_group_id = kwargs["external_subnet_group_id"]
        if "external_ip" in kwargs:
            self.external_ip = kwargs["external_ip"]
        if "external_subnet_id" in kwargs:
            self.external_subnet_id = kwargs["external_subnet_id"]
        if "vpc_id" in kwargs:
            self.vpc_id = kwargs["vpc_id"]
        if "name" in kwargs:
            self.name = kwargs["name"]

    @property
    def rules(self):
        """Gets the rules of this VirtualPrivateCloudRouterGatewayCreationParams.  # noqa: E501


        :return: The rules of this VirtualPrivateCloudRouterGatewayCreationParams.  # noqa: E501
        :rtype: list[VirtualPrivateCloudRouterGatewayRuleInputType]
        """
        return self._rules

    @rules.setter
    def rules(self, rules):
        """Sets the rules of this VirtualPrivateCloudRouterGatewayCreationParams.


        :param rules: The rules of this VirtualPrivateCloudRouterGatewayCreationParams.  # noqa: E501
        :type rules: list[VirtualPrivateCloudRouterGatewayRuleInputType]
        """
        if self.local_vars_configuration.client_side_validation and rules is None:  # noqa: E501
            raise ValueError("Invalid value for `rules`, must not be `None`")  # noqa: E501

        self._rules = rules

    @property
    def associated_subnets_ids(self):
        """Gets the associated_subnets_ids of this VirtualPrivateCloudRouterGatewayCreationParams.  # noqa: E501


        :return: The associated_subnets_ids of this VirtualPrivateCloudRouterGatewayCreationParams.  # noqa: E501
        :rtype: list[str]
        """
        return self._associated_subnets_ids

    @associated_subnets_ids.setter
    def associated_subnets_ids(self, associated_subnets_ids):
        """Sets the associated_subnets_ids of this VirtualPrivateCloudRouterGatewayCreationParams.


        :param associated_subnets_ids: The associated_subnets_ids of this VirtualPrivateCloudRouterGatewayCreationParams.  # noqa: E501
        :type associated_subnets_ids: list[str]
        """
        if self.local_vars_configuration.client_side_validation and associated_subnets_ids is None:  # noqa: E501
            raise ValueError("Invalid value for `associated_subnets_ids`, must not be `None`")  # noqa: E501

        self._associated_subnets_ids = associated_subnets_ids

    @property
    def external_ips(self):
        """Gets the external_ips of this VirtualPrivateCloudRouterGatewayCreationParams.  # noqa: E501


        :return: The external_ips of this VirtualPrivateCloudRouterGatewayCreationParams.  # noqa: E501
        :rtype: list[VirtualPrivateCloudExternalIpsParams]
        """
        return self._external_ips

    @external_ips.setter
    def external_ips(self, external_ips):
        """Sets the external_ips of this VirtualPrivateCloudRouterGatewayCreationParams.


        :param external_ips: The external_ips of this VirtualPrivateCloudRouterGatewayCreationParams.  # noqa: E501
        :type external_ips: list[VirtualPrivateCloudExternalIpsParams]
        """

        self._external_ips = external_ips

    @property
    def external_subnet_group_id(self):
        """Gets the external_subnet_group_id of this VirtualPrivateCloudRouterGatewayCreationParams.  # noqa: E501


        :return: The external_subnet_group_id of this VirtualPrivateCloudRouterGatewayCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._external_subnet_group_id

    @external_subnet_group_id.setter
    def external_subnet_group_id(self, external_subnet_group_id):
        """Sets the external_subnet_group_id of this VirtualPrivateCloudRouterGatewayCreationParams.


        :param external_subnet_group_id: The external_subnet_group_id of this VirtualPrivateCloudRouterGatewayCreationParams.  # noqa: E501
        :type external_subnet_group_id: str
        """

        self._external_subnet_group_id = external_subnet_group_id

    @property
    def external_ip(self):
        """Gets the external_ip of this VirtualPrivateCloudRouterGatewayCreationParams.  # noqa: E501


        :return: The external_ip of this VirtualPrivateCloudRouterGatewayCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._external_ip

    @external_ip.setter
    def external_ip(self, external_ip):
        """Sets the external_ip of this VirtualPrivateCloudRouterGatewayCreationParams.


        :param external_ip: The external_ip of this VirtualPrivateCloudRouterGatewayCreationParams.  # noqa: E501
        :type external_ip: str
        """

        self._external_ip = external_ip

    @property
    def external_subnet_id(self):
        """Gets the external_subnet_id of this VirtualPrivateCloudRouterGatewayCreationParams.  # noqa: E501


        :return: The external_subnet_id of this VirtualPrivateCloudRouterGatewayCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._external_subnet_id

    @external_subnet_id.setter
    def external_subnet_id(self, external_subnet_id):
        """Sets the external_subnet_id of this VirtualPrivateCloudRouterGatewayCreationParams.


        :param external_subnet_id: The external_subnet_id of this VirtualPrivateCloudRouterGatewayCreationParams.  # noqa: E501
        :type external_subnet_id: str
        """

        self._external_subnet_id = external_subnet_id

    @property
    def vpc_id(self):
        """Gets the vpc_id of this VirtualPrivateCloudRouterGatewayCreationParams.  # noqa: E501


        :return: The vpc_id of this VirtualPrivateCloudRouterGatewayCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._vpc_id

    @vpc_id.setter
    def vpc_id(self, vpc_id):
        """Sets the vpc_id of this VirtualPrivateCloudRouterGatewayCreationParams.


        :param vpc_id: The vpc_id of this VirtualPrivateCloudRouterGatewayCreationParams.  # noqa: E501
        :type vpc_id: str
        """
        if self.local_vars_configuration.client_side_validation and vpc_id is None:  # noqa: E501
            raise ValueError("Invalid value for `vpc_id`, must not be `None`")  # noqa: E501

        self._vpc_id = vpc_id

    @property
    def name(self):
        """Gets the name of this VirtualPrivateCloudRouterGatewayCreationParams.  # noqa: E501


        :return: The name of this VirtualPrivateCloudRouterGatewayCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this VirtualPrivateCloudRouterGatewayCreationParams.


        :param name: The name of this VirtualPrivateCloudRouterGatewayCreationParams.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VirtualPrivateCloudRouterGatewayCreationParams):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VirtualPrivateCloudRouterGatewayCreationParams):
            return True

        return self.to_dict() != other.to_dict()
