# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class VirtualPrivateCloudRouterGatewayUpdateDataParams(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'rules': 'list[VirtualPrivateCloudRouterGatewayRuleInputType]',
        'associated_subnets_ids': 'list[str]',
        'external_ips': 'list[VirtualPrivateCloudExternalIpsParams]',
        'external_ip': 'str',
        'name': 'str'
    }

    attribute_map = {
        'rules': 'rules',
        'associated_subnets_ids': 'associated_subnets_ids',
        'external_ips': 'external_ips',
        'external_ip': 'external_ip',
        'name': 'name'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """VirtualPrivateCloudRouterGatewayUpdateDataParams - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._rules = None
        self._associated_subnets_ids = None
        self._external_ips = None
        self._external_ip = None
        self._name = None
        self.discriminator = None

        if "rules" in kwargs:
            self.rules = kwargs["rules"]
        if "associated_subnets_ids" in kwargs:
            self.associated_subnets_ids = kwargs["associated_subnets_ids"]
        if "external_ips" in kwargs:
            self.external_ips = kwargs["external_ips"]
        if "external_ip" in kwargs:
            self.external_ip = kwargs["external_ip"]
        if "name" in kwargs:
            self.name = kwargs["name"]

    @property
    def rules(self):
        """Gets the rules of this VirtualPrivateCloudRouterGatewayUpdateDataParams.  # noqa: E501


        :return: The rules of this VirtualPrivateCloudRouterGatewayUpdateDataParams.  # noqa: E501
        :rtype: list[VirtualPrivateCloudRouterGatewayRuleInputType]
        """
        return self._rules

    @rules.setter
    def rules(self, rules):
        """Sets the rules of this VirtualPrivateCloudRouterGatewayUpdateDataParams.


        :param rules: The rules of this VirtualPrivateCloudRouterGatewayUpdateDataParams.  # noqa: E501
        :type rules: list[VirtualPrivateCloudRouterGatewayRuleInputType]
        """

        self._rules = rules

    @property
    def associated_subnets_ids(self):
        """Gets the associated_subnets_ids of this VirtualPrivateCloudRouterGatewayUpdateDataParams.  # noqa: E501


        :return: The associated_subnets_ids of this VirtualPrivateCloudRouterGatewayUpdateDataParams.  # noqa: E501
        :rtype: list[str]
        """
        return self._associated_subnets_ids

    @associated_subnets_ids.setter
    def associated_subnets_ids(self, associated_subnets_ids):
        """Sets the associated_subnets_ids of this VirtualPrivateCloudRouterGatewayUpdateDataParams.


        :param associated_subnets_ids: The associated_subnets_ids of this VirtualPrivateCloudRouterGatewayUpdateDataParams.  # noqa: E501
        :type associated_subnets_ids: list[str]
        """

        self._associated_subnets_ids = associated_subnets_ids

    @property
    def external_ips(self):
        """Gets the external_ips of this VirtualPrivateCloudRouterGatewayUpdateDataParams.  # noqa: E501


        :return: The external_ips of this VirtualPrivateCloudRouterGatewayUpdateDataParams.  # noqa: E501
        :rtype: list[VirtualPrivateCloudExternalIpsParams]
        """
        return self._external_ips

    @external_ips.setter
    def external_ips(self, external_ips):
        """Sets the external_ips of this VirtualPrivateCloudRouterGatewayUpdateDataParams.


        :param external_ips: The external_ips of this VirtualPrivateCloudRouterGatewayUpdateDataParams.  # noqa: E501
        :type external_ips: list[VirtualPrivateCloudExternalIpsParams]
        """

        self._external_ips = external_ips

    @property
    def external_ip(self):
        """Gets the external_ip of this VirtualPrivateCloudRouterGatewayUpdateDataParams.  # noqa: E501


        :return: The external_ip of this VirtualPrivateCloudRouterGatewayUpdateDataParams.  # noqa: E501
        :rtype: str
        """
        return self._external_ip

    @external_ip.setter
    def external_ip(self, external_ip):
        """Sets the external_ip of this VirtualPrivateCloudRouterGatewayUpdateDataParams.


        :param external_ip: The external_ip of this VirtualPrivateCloudRouterGatewayUpdateDataParams.  # noqa: E501
        :type external_ip: str
        """

        self._external_ip = external_ip

    @property
    def name(self):
        """Gets the name of this VirtualPrivateCloudRouterGatewayUpdateDataParams.  # noqa: E501


        :return: The name of this VirtualPrivateCloudRouterGatewayUpdateDataParams.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this VirtualPrivateCloudRouterGatewayUpdateDataParams.


        :param name: The name of this VirtualPrivateCloudRouterGatewayUpdateDataParams.  # noqa: E501
        :type name: str
        """

        self._name = name

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VirtualPrivateCloudRouterGatewayUpdateDataParams):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VirtualPrivateCloudRouterGatewayUpdateDataParams):
            return True

        return self.to_dict() != other.to_dict()
