# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class VirtualPrivateCloudSecurityGroupCreationParams(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'vm_ids': 'list[str]',
        'label_groups': 'list[LabelGroup]',
        'vpc_id': 'str',
        'description': 'str',
        'name': 'str'
    }

    attribute_map = {
        'vm_ids': 'vm_ids',
        'label_groups': 'label_groups',
        'vpc_id': 'vpc_id',
        'description': 'description',
        'name': 'name'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """VirtualPrivateCloudSecurityGroupCreationParams - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._vm_ids = None
        self._label_groups = None
        self._vpc_id = None
        self._description = None
        self._name = None
        self.discriminator = None

        if "vm_ids" in kwargs:
            self.vm_ids = kwargs["vm_ids"]
        if "label_groups" in kwargs:
            self.label_groups = kwargs["label_groups"]
        if "vpc_id" in kwargs:
            self.vpc_id = kwargs["vpc_id"]
        if "description" in kwargs:
            self.description = kwargs["description"]
        if "name" in kwargs:
            self.name = kwargs["name"]

    @property
    def vm_ids(self):
        """Gets the vm_ids of this VirtualPrivateCloudSecurityGroupCreationParams.  # noqa: E501


        :return: The vm_ids of this VirtualPrivateCloudSecurityGroupCreationParams.  # noqa: E501
        :rtype: list[str]
        """
        return self._vm_ids

    @vm_ids.setter
    def vm_ids(self, vm_ids):
        """Sets the vm_ids of this VirtualPrivateCloudSecurityGroupCreationParams.


        :param vm_ids: The vm_ids of this VirtualPrivateCloudSecurityGroupCreationParams.  # noqa: E501
        :type vm_ids: list[str]
        """

        self._vm_ids = vm_ids

    @property
    def label_groups(self):
        """Gets the label_groups of this VirtualPrivateCloudSecurityGroupCreationParams.  # noqa: E501


        :return: The label_groups of this VirtualPrivateCloudSecurityGroupCreationParams.  # noqa: E501
        :rtype: list[LabelGroup]
        """
        return self._label_groups

    @label_groups.setter
    def label_groups(self, label_groups):
        """Sets the label_groups of this VirtualPrivateCloudSecurityGroupCreationParams.


        :param label_groups: The label_groups of this VirtualPrivateCloudSecurityGroupCreationParams.  # noqa: E501
        :type label_groups: list[LabelGroup]
        """

        self._label_groups = label_groups

    @property
    def vpc_id(self):
        """Gets the vpc_id of this VirtualPrivateCloudSecurityGroupCreationParams.  # noqa: E501


        :return: The vpc_id of this VirtualPrivateCloudSecurityGroupCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._vpc_id

    @vpc_id.setter
    def vpc_id(self, vpc_id):
        """Sets the vpc_id of this VirtualPrivateCloudSecurityGroupCreationParams.


        :param vpc_id: The vpc_id of this VirtualPrivateCloudSecurityGroupCreationParams.  # noqa: E501
        :type vpc_id: str
        """
        if self.local_vars_configuration.client_side_validation and vpc_id is None:  # noqa: E501
            raise ValueError("Invalid value for `vpc_id`, must not be `None`")  # noqa: E501

        self._vpc_id = vpc_id

    @property
    def description(self):
        """Gets the description of this VirtualPrivateCloudSecurityGroupCreationParams.  # noqa: E501


        :return: The description of this VirtualPrivateCloudSecurityGroupCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this VirtualPrivateCloudSecurityGroupCreationParams.


        :param description: The description of this VirtualPrivateCloudSecurityGroupCreationParams.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def name(self):
        """Gets the name of this VirtualPrivateCloudSecurityGroupCreationParams.  # noqa: E501


        :return: The name of this VirtualPrivateCloudSecurityGroupCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this VirtualPrivateCloudSecurityGroupCreationParams.


        :param name: The name of this VirtualPrivateCloudSecurityGroupCreationParams.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VirtualPrivateCloudSecurityGroupCreationParams):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VirtualPrivateCloudSecurityGroupCreationParams):
            return True

        return self.to_dict() != other.to_dict()
