# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class VirtualPrivateCloudServiceWhereInput(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        '_and': 'list[VirtualPrivateCloudServiceWhereInput]',
        '_not': 'list[VirtualPrivateCloudServiceWhereInput]',
        '_or': 'list[VirtualPrivateCloudServiceWhereInput]',
        'cluster_bindings_every': 'VirtualPrivateCloudClusterBindingWhereInput',
        'cluster_bindings_none': 'VirtualPrivateCloudClusterBindingWhereInput',
        'cluster_bindings_some': 'VirtualPrivateCloudClusterBindingWhereInput',
        'edge_gateway_groups_every': 'VirtualPrivateCloudEdgeGatewayGroupWhereInput',
        'edge_gateway_groups_none': 'VirtualPrivateCloudEdgeGatewayGroupWhereInput',
        'edge_gateway_groups_some': 'VirtualPrivateCloudEdgeGatewayGroupWhereInput',
        'edge_gateways_every': 'VirtualPrivateCloudEdgeGatewayWhereInput',
        'edge_gateways_none': 'VirtualPrivateCloudEdgeGatewayWhereInput',
        'edge_gateways_some': 'VirtualPrivateCloudEdgeGatewayWhereInput',
        'entity_async_status': 'EntityAsyncStatus',
        'entity_async_status_in': 'list[EntityAsyncStatus]',
        'entity_async_status_not': 'EntityAsyncStatus',
        'entity_async_status_not_in': 'list[EntityAsyncStatus]',
        'everoute_cluster': 'EverouteClusterWhereInput',
        'external_subnets_every': 'VirtualPrivateCloudExternalSubnetWhereInput',
        'external_subnets_none': 'VirtualPrivateCloudExternalSubnetWhereInput',
        'external_subnets_some': 'VirtualPrivateCloudExternalSubnetWhereInput',
        'id': 'str',
        'id_contains': 'str',
        'id_ends_with': 'str',
        'id_gt': 'str',
        'id_gte': 'str',
        'id_in': 'list[str]',
        'id_lt': 'str',
        'id_lte': 'str',
        'id_not': 'str',
        'id_not_contains': 'str',
        'id_not_ends_with': 'str',
        'id_not_in': 'list[str]',
        'id_not_starts_with': 'str',
        'id_starts_with': 'str',
        'internal_cidr': 'str',
        'internal_cidr_contains': 'str',
        'internal_cidr_ends_with': 'str',
        'internal_cidr_gt': 'str',
        'internal_cidr_gte': 'str',
        'internal_cidr_in': 'list[str]',
        'internal_cidr_lt': 'str',
        'internal_cidr_lte': 'str',
        'internal_cidr_not': 'str',
        'internal_cidr_not_contains': 'str',
        'internal_cidr_not_ends_with': 'str',
        'internal_cidr_not_in': 'list[str]',
        'internal_cidr_not_starts_with': 'str',
        'internal_cidr_starts_with': 'str',
        'phase': 'EverouteClusterPhase',
        'phase_in': 'list[EverouteClusterPhase]',
        'phase_not': 'EverouteClusterPhase',
        'phase_not_in': 'list[EverouteClusterPhase]',
        'vpcs_every': 'VirtualPrivateCloudWhereInput',
        'vpcs_none': 'VirtualPrivateCloudWhereInput',
        'vpcs_some': 'VirtualPrivateCloudWhereInput'
    }

    attribute_map = {
        '_and': 'AND',
        '_not': 'NOT',
        '_or': 'OR',
        'cluster_bindings_every': 'cluster_bindings_every',
        'cluster_bindings_none': 'cluster_bindings_none',
        'cluster_bindings_some': 'cluster_bindings_some',
        'edge_gateway_groups_every': 'edge_gateway_groups_every',
        'edge_gateway_groups_none': 'edge_gateway_groups_none',
        'edge_gateway_groups_some': 'edge_gateway_groups_some',
        'edge_gateways_every': 'edge_gateways_every',
        'edge_gateways_none': 'edge_gateways_none',
        'edge_gateways_some': 'edge_gateways_some',
        'entity_async_status': 'entityAsyncStatus',
        'entity_async_status_in': 'entityAsyncStatus_in',
        'entity_async_status_not': 'entityAsyncStatus_not',
        'entity_async_status_not_in': 'entityAsyncStatus_not_in',
        'everoute_cluster': 'everoute_cluster',
        'external_subnets_every': 'external_subnets_every',
        'external_subnets_none': 'external_subnets_none',
        'external_subnets_some': 'external_subnets_some',
        'id': 'id',
        'id_contains': 'id_contains',
        'id_ends_with': 'id_ends_with',
        'id_gt': 'id_gt',
        'id_gte': 'id_gte',
        'id_in': 'id_in',
        'id_lt': 'id_lt',
        'id_lte': 'id_lte',
        'id_not': 'id_not',
        'id_not_contains': 'id_not_contains',
        'id_not_ends_with': 'id_not_ends_with',
        'id_not_in': 'id_not_in',
        'id_not_starts_with': 'id_not_starts_with',
        'id_starts_with': 'id_starts_with',
        'internal_cidr': 'internal_cidr',
        'internal_cidr_contains': 'internal_cidr_contains',
        'internal_cidr_ends_with': 'internal_cidr_ends_with',
        'internal_cidr_gt': 'internal_cidr_gt',
        'internal_cidr_gte': 'internal_cidr_gte',
        'internal_cidr_in': 'internal_cidr_in',
        'internal_cidr_lt': 'internal_cidr_lt',
        'internal_cidr_lte': 'internal_cidr_lte',
        'internal_cidr_not': 'internal_cidr_not',
        'internal_cidr_not_contains': 'internal_cidr_not_contains',
        'internal_cidr_not_ends_with': 'internal_cidr_not_ends_with',
        'internal_cidr_not_in': 'internal_cidr_not_in',
        'internal_cidr_not_starts_with': 'internal_cidr_not_starts_with',
        'internal_cidr_starts_with': 'internal_cidr_starts_with',
        'phase': 'phase',
        'phase_in': 'phase_in',
        'phase_not': 'phase_not',
        'phase_not_in': 'phase_not_in',
        'vpcs_every': 'vpcs_every',
        'vpcs_none': 'vpcs_none',
        'vpcs_some': 'vpcs_some'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """VirtualPrivateCloudServiceWhereInput - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self.__and = None
        self.__not = None
        self.__or = None
        self._cluster_bindings_every = None
        self._cluster_bindings_none = None
        self._cluster_bindings_some = None
        self._edge_gateway_groups_every = None
        self._edge_gateway_groups_none = None
        self._edge_gateway_groups_some = None
        self._edge_gateways_every = None
        self._edge_gateways_none = None
        self._edge_gateways_some = None
        self._entity_async_status = None
        self._entity_async_status_in = None
        self._entity_async_status_not = None
        self._entity_async_status_not_in = None
        self._everoute_cluster = None
        self._external_subnets_every = None
        self._external_subnets_none = None
        self._external_subnets_some = None
        self._id = None
        self._id_contains = None
        self._id_ends_with = None
        self._id_gt = None
        self._id_gte = None
        self._id_in = None
        self._id_lt = None
        self._id_lte = None
        self._id_not = None
        self._id_not_contains = None
        self._id_not_ends_with = None
        self._id_not_in = None
        self._id_not_starts_with = None
        self._id_starts_with = None
        self._internal_cidr = None
        self._internal_cidr_contains = None
        self._internal_cidr_ends_with = None
        self._internal_cidr_gt = None
        self._internal_cidr_gte = None
        self._internal_cidr_in = None
        self._internal_cidr_lt = None
        self._internal_cidr_lte = None
        self._internal_cidr_not = None
        self._internal_cidr_not_contains = None
        self._internal_cidr_not_ends_with = None
        self._internal_cidr_not_in = None
        self._internal_cidr_not_starts_with = None
        self._internal_cidr_starts_with = None
        self._phase = None
        self._phase_in = None
        self._phase_not = None
        self._phase_not_in = None
        self._vpcs_every = None
        self._vpcs_none = None
        self._vpcs_some = None
        self.discriminator = None

        self._and = kwargs.get("_and", None)
        self._not = kwargs.get("_not", None)
        self._or = kwargs.get("_or", None)
        self.cluster_bindings_every = kwargs.get("cluster_bindings_every", None)
        self.cluster_bindings_none = kwargs.get("cluster_bindings_none", None)
        self.cluster_bindings_some = kwargs.get("cluster_bindings_some", None)
        self.edge_gateway_groups_every = kwargs.get("edge_gateway_groups_every", None)
        self.edge_gateway_groups_none = kwargs.get("edge_gateway_groups_none", None)
        self.edge_gateway_groups_some = kwargs.get("edge_gateway_groups_some", None)
        self.edge_gateways_every = kwargs.get("edge_gateways_every", None)
        self.edge_gateways_none = kwargs.get("edge_gateways_none", None)
        self.edge_gateways_some = kwargs.get("edge_gateways_some", None)
        self.entity_async_status = kwargs.get("entity_async_status", None)
        self.entity_async_status_in = kwargs.get("entity_async_status_in", None)
        self.entity_async_status_not = kwargs.get("entity_async_status_not", None)
        self.entity_async_status_not_in = kwargs.get("entity_async_status_not_in", None)
        self.everoute_cluster = kwargs.get("everoute_cluster", None)
        self.external_subnets_every = kwargs.get("external_subnets_every", None)
        self.external_subnets_none = kwargs.get("external_subnets_none", None)
        self.external_subnets_some = kwargs.get("external_subnets_some", None)
        self.id = kwargs.get("id", None)
        self.id_contains = kwargs.get("id_contains", None)
        self.id_ends_with = kwargs.get("id_ends_with", None)
        self.id_gt = kwargs.get("id_gt", None)
        self.id_gte = kwargs.get("id_gte", None)
        self.id_in = kwargs.get("id_in", None)
        self.id_lt = kwargs.get("id_lt", None)
        self.id_lte = kwargs.get("id_lte", None)
        self.id_not = kwargs.get("id_not", None)
        self.id_not_contains = kwargs.get("id_not_contains", None)
        self.id_not_ends_with = kwargs.get("id_not_ends_with", None)
        self.id_not_in = kwargs.get("id_not_in", None)
        self.id_not_starts_with = kwargs.get("id_not_starts_with", None)
        self.id_starts_with = kwargs.get("id_starts_with", None)
        self.internal_cidr = kwargs.get("internal_cidr", None)
        self.internal_cidr_contains = kwargs.get("internal_cidr_contains", None)
        self.internal_cidr_ends_with = kwargs.get("internal_cidr_ends_with", None)
        self.internal_cidr_gt = kwargs.get("internal_cidr_gt", None)
        self.internal_cidr_gte = kwargs.get("internal_cidr_gte", None)
        self.internal_cidr_in = kwargs.get("internal_cidr_in", None)
        self.internal_cidr_lt = kwargs.get("internal_cidr_lt", None)
        self.internal_cidr_lte = kwargs.get("internal_cidr_lte", None)
        self.internal_cidr_not = kwargs.get("internal_cidr_not", None)
        self.internal_cidr_not_contains = kwargs.get("internal_cidr_not_contains", None)
        self.internal_cidr_not_ends_with = kwargs.get("internal_cidr_not_ends_with", None)
        self.internal_cidr_not_in = kwargs.get("internal_cidr_not_in", None)
        self.internal_cidr_not_starts_with = kwargs.get("internal_cidr_not_starts_with", None)
        self.internal_cidr_starts_with = kwargs.get("internal_cidr_starts_with", None)
        self.phase = kwargs.get("phase", None)
        self.phase_in = kwargs.get("phase_in", None)
        self.phase_not = kwargs.get("phase_not", None)
        self.phase_not_in = kwargs.get("phase_not_in", None)
        self.vpcs_every = kwargs.get("vpcs_every", None)
        self.vpcs_none = kwargs.get("vpcs_none", None)
        self.vpcs_some = kwargs.get("vpcs_some", None)

    @property
    def _and(self):
        """Gets the _and of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The _and of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: list[VirtualPrivateCloudServiceWhereInput]
        """
        return self.__and

    @_and.setter
    def _and(self, _and):
        """Sets the _and of this VirtualPrivateCloudServiceWhereInput.


        :param _and: The _and of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type _and: list[VirtualPrivateCloudServiceWhereInput]
        """

        self.__and = _and

    @property
    def _not(self):
        """Gets the _not of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The _not of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: list[VirtualPrivateCloudServiceWhereInput]
        """
        return self.__not

    @_not.setter
    def _not(self, _not):
        """Sets the _not of this VirtualPrivateCloudServiceWhereInput.


        :param _not: The _not of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type _not: list[VirtualPrivateCloudServiceWhereInput]
        """

        self.__not = _not

    @property
    def _or(self):
        """Gets the _or of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The _or of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: list[VirtualPrivateCloudServiceWhereInput]
        """
        return self.__or

    @_or.setter
    def _or(self, _or):
        """Sets the _or of this VirtualPrivateCloudServiceWhereInput.


        :param _or: The _or of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type _or: list[VirtualPrivateCloudServiceWhereInput]
        """

        self.__or = _or

    @property
    def cluster_bindings_every(self):
        """Gets the cluster_bindings_every of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The cluster_bindings_every of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: VirtualPrivateCloudClusterBindingWhereInput
        """
        return self._cluster_bindings_every

    @cluster_bindings_every.setter
    def cluster_bindings_every(self, cluster_bindings_every):
        """Sets the cluster_bindings_every of this VirtualPrivateCloudServiceWhereInput.


        :param cluster_bindings_every: The cluster_bindings_every of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type cluster_bindings_every: VirtualPrivateCloudClusterBindingWhereInput
        """

        self._cluster_bindings_every = cluster_bindings_every

    @property
    def cluster_bindings_none(self):
        """Gets the cluster_bindings_none of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The cluster_bindings_none of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: VirtualPrivateCloudClusterBindingWhereInput
        """
        return self._cluster_bindings_none

    @cluster_bindings_none.setter
    def cluster_bindings_none(self, cluster_bindings_none):
        """Sets the cluster_bindings_none of this VirtualPrivateCloudServiceWhereInput.


        :param cluster_bindings_none: The cluster_bindings_none of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type cluster_bindings_none: VirtualPrivateCloudClusterBindingWhereInput
        """

        self._cluster_bindings_none = cluster_bindings_none

    @property
    def cluster_bindings_some(self):
        """Gets the cluster_bindings_some of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The cluster_bindings_some of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: VirtualPrivateCloudClusterBindingWhereInput
        """
        return self._cluster_bindings_some

    @cluster_bindings_some.setter
    def cluster_bindings_some(self, cluster_bindings_some):
        """Sets the cluster_bindings_some of this VirtualPrivateCloudServiceWhereInput.


        :param cluster_bindings_some: The cluster_bindings_some of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type cluster_bindings_some: VirtualPrivateCloudClusterBindingWhereInput
        """

        self._cluster_bindings_some = cluster_bindings_some

    @property
    def edge_gateway_groups_every(self):
        """Gets the edge_gateway_groups_every of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The edge_gateway_groups_every of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: VirtualPrivateCloudEdgeGatewayGroupWhereInput
        """
        return self._edge_gateway_groups_every

    @edge_gateway_groups_every.setter
    def edge_gateway_groups_every(self, edge_gateway_groups_every):
        """Sets the edge_gateway_groups_every of this VirtualPrivateCloudServiceWhereInput.


        :param edge_gateway_groups_every: The edge_gateway_groups_every of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type edge_gateway_groups_every: VirtualPrivateCloudEdgeGatewayGroupWhereInput
        """

        self._edge_gateway_groups_every = edge_gateway_groups_every

    @property
    def edge_gateway_groups_none(self):
        """Gets the edge_gateway_groups_none of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The edge_gateway_groups_none of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: VirtualPrivateCloudEdgeGatewayGroupWhereInput
        """
        return self._edge_gateway_groups_none

    @edge_gateway_groups_none.setter
    def edge_gateway_groups_none(self, edge_gateway_groups_none):
        """Sets the edge_gateway_groups_none of this VirtualPrivateCloudServiceWhereInput.


        :param edge_gateway_groups_none: The edge_gateway_groups_none of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type edge_gateway_groups_none: VirtualPrivateCloudEdgeGatewayGroupWhereInput
        """

        self._edge_gateway_groups_none = edge_gateway_groups_none

    @property
    def edge_gateway_groups_some(self):
        """Gets the edge_gateway_groups_some of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The edge_gateway_groups_some of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: VirtualPrivateCloudEdgeGatewayGroupWhereInput
        """
        return self._edge_gateway_groups_some

    @edge_gateway_groups_some.setter
    def edge_gateway_groups_some(self, edge_gateway_groups_some):
        """Sets the edge_gateway_groups_some of this VirtualPrivateCloudServiceWhereInput.


        :param edge_gateway_groups_some: The edge_gateway_groups_some of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type edge_gateway_groups_some: VirtualPrivateCloudEdgeGatewayGroupWhereInput
        """

        self._edge_gateway_groups_some = edge_gateway_groups_some

    @property
    def edge_gateways_every(self):
        """Gets the edge_gateways_every of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The edge_gateways_every of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: VirtualPrivateCloudEdgeGatewayWhereInput
        """
        return self._edge_gateways_every

    @edge_gateways_every.setter
    def edge_gateways_every(self, edge_gateways_every):
        """Sets the edge_gateways_every of this VirtualPrivateCloudServiceWhereInput.


        :param edge_gateways_every: The edge_gateways_every of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type edge_gateways_every: VirtualPrivateCloudEdgeGatewayWhereInput
        """

        self._edge_gateways_every = edge_gateways_every

    @property
    def edge_gateways_none(self):
        """Gets the edge_gateways_none of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The edge_gateways_none of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: VirtualPrivateCloudEdgeGatewayWhereInput
        """
        return self._edge_gateways_none

    @edge_gateways_none.setter
    def edge_gateways_none(self, edge_gateways_none):
        """Sets the edge_gateways_none of this VirtualPrivateCloudServiceWhereInput.


        :param edge_gateways_none: The edge_gateways_none of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type edge_gateways_none: VirtualPrivateCloudEdgeGatewayWhereInput
        """

        self._edge_gateways_none = edge_gateways_none

    @property
    def edge_gateways_some(self):
        """Gets the edge_gateways_some of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The edge_gateways_some of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: VirtualPrivateCloudEdgeGatewayWhereInput
        """
        return self._edge_gateways_some

    @edge_gateways_some.setter
    def edge_gateways_some(self, edge_gateways_some):
        """Sets the edge_gateways_some of this VirtualPrivateCloudServiceWhereInput.


        :param edge_gateways_some: The edge_gateways_some of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type edge_gateways_some: VirtualPrivateCloudEdgeGatewayWhereInput
        """

        self._edge_gateways_some = edge_gateways_some

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The entity_async_status of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this VirtualPrivateCloudServiceWhereInput.


        :param entity_async_status: The entity_async_status of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def entity_async_status_in(self):
        """Gets the entity_async_status_in of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The entity_async_status_in of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_in

    @entity_async_status_in.setter
    def entity_async_status_in(self, entity_async_status_in):
        """Sets the entity_async_status_in of this VirtualPrivateCloudServiceWhereInput.


        :param entity_async_status_in: The entity_async_status_in of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type entity_async_status_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_in = entity_async_status_in

    @property
    def entity_async_status_not(self):
        """Gets the entity_async_status_not of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The entity_async_status_not of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status_not

    @entity_async_status_not.setter
    def entity_async_status_not(self, entity_async_status_not):
        """Sets the entity_async_status_not of this VirtualPrivateCloudServiceWhereInput.


        :param entity_async_status_not: The entity_async_status_not of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type entity_async_status_not: EntityAsyncStatus
        """

        self._entity_async_status_not = entity_async_status_not

    @property
    def entity_async_status_not_in(self):
        """Gets the entity_async_status_not_in of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The entity_async_status_not_in of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_not_in

    @entity_async_status_not_in.setter
    def entity_async_status_not_in(self, entity_async_status_not_in):
        """Sets the entity_async_status_not_in of this VirtualPrivateCloudServiceWhereInput.


        :param entity_async_status_not_in: The entity_async_status_not_in of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type entity_async_status_not_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_not_in = entity_async_status_not_in

    @property
    def everoute_cluster(self):
        """Gets the everoute_cluster of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The everoute_cluster of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: EverouteClusterWhereInput
        """
        return self._everoute_cluster

    @everoute_cluster.setter
    def everoute_cluster(self, everoute_cluster):
        """Sets the everoute_cluster of this VirtualPrivateCloudServiceWhereInput.


        :param everoute_cluster: The everoute_cluster of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type everoute_cluster: EverouteClusterWhereInput
        """

        self._everoute_cluster = everoute_cluster

    @property
    def external_subnets_every(self):
        """Gets the external_subnets_every of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The external_subnets_every of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: VirtualPrivateCloudExternalSubnetWhereInput
        """
        return self._external_subnets_every

    @external_subnets_every.setter
    def external_subnets_every(self, external_subnets_every):
        """Sets the external_subnets_every of this VirtualPrivateCloudServiceWhereInput.


        :param external_subnets_every: The external_subnets_every of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type external_subnets_every: VirtualPrivateCloudExternalSubnetWhereInput
        """

        self._external_subnets_every = external_subnets_every

    @property
    def external_subnets_none(self):
        """Gets the external_subnets_none of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The external_subnets_none of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: VirtualPrivateCloudExternalSubnetWhereInput
        """
        return self._external_subnets_none

    @external_subnets_none.setter
    def external_subnets_none(self, external_subnets_none):
        """Sets the external_subnets_none of this VirtualPrivateCloudServiceWhereInput.


        :param external_subnets_none: The external_subnets_none of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type external_subnets_none: VirtualPrivateCloudExternalSubnetWhereInput
        """

        self._external_subnets_none = external_subnets_none

    @property
    def external_subnets_some(self):
        """Gets the external_subnets_some of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The external_subnets_some of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: VirtualPrivateCloudExternalSubnetWhereInput
        """
        return self._external_subnets_some

    @external_subnets_some.setter
    def external_subnets_some(self, external_subnets_some):
        """Sets the external_subnets_some of this VirtualPrivateCloudServiceWhereInput.


        :param external_subnets_some: The external_subnets_some of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type external_subnets_some: VirtualPrivateCloudExternalSubnetWhereInput
        """

        self._external_subnets_some = external_subnets_some

    @property
    def id(self):
        """Gets the id of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The id of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this VirtualPrivateCloudServiceWhereInput.


        :param id: The id of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def id_contains(self):
        """Gets the id_contains of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The id_contains of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_contains

    @id_contains.setter
    def id_contains(self, id_contains):
        """Sets the id_contains of this VirtualPrivateCloudServiceWhereInput.


        :param id_contains: The id_contains of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type id_contains: str
        """

        self._id_contains = id_contains

    @property
    def id_ends_with(self):
        """Gets the id_ends_with of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The id_ends_with of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_ends_with

    @id_ends_with.setter
    def id_ends_with(self, id_ends_with):
        """Sets the id_ends_with of this VirtualPrivateCloudServiceWhereInput.


        :param id_ends_with: The id_ends_with of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type id_ends_with: str
        """

        self._id_ends_with = id_ends_with

    @property
    def id_gt(self):
        """Gets the id_gt of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The id_gt of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gt

    @id_gt.setter
    def id_gt(self, id_gt):
        """Sets the id_gt of this VirtualPrivateCloudServiceWhereInput.


        :param id_gt: The id_gt of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type id_gt: str
        """

        self._id_gt = id_gt

    @property
    def id_gte(self):
        """Gets the id_gte of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The id_gte of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gte

    @id_gte.setter
    def id_gte(self, id_gte):
        """Sets the id_gte of this VirtualPrivateCloudServiceWhereInput.


        :param id_gte: The id_gte of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type id_gte: str
        """

        self._id_gte = id_gte

    @property
    def id_in(self):
        """Gets the id_in of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The id_in of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_in

    @id_in.setter
    def id_in(self, id_in):
        """Sets the id_in of this VirtualPrivateCloudServiceWhereInput.


        :param id_in: The id_in of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type id_in: list[str]
        """

        self._id_in = id_in

    @property
    def id_lt(self):
        """Gets the id_lt of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The id_lt of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lt

    @id_lt.setter
    def id_lt(self, id_lt):
        """Sets the id_lt of this VirtualPrivateCloudServiceWhereInput.


        :param id_lt: The id_lt of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type id_lt: str
        """

        self._id_lt = id_lt

    @property
    def id_lte(self):
        """Gets the id_lte of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The id_lte of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lte

    @id_lte.setter
    def id_lte(self, id_lte):
        """Sets the id_lte of this VirtualPrivateCloudServiceWhereInput.


        :param id_lte: The id_lte of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type id_lte: str
        """

        self._id_lte = id_lte

    @property
    def id_not(self):
        """Gets the id_not of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The id_not of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not

    @id_not.setter
    def id_not(self, id_not):
        """Sets the id_not of this VirtualPrivateCloudServiceWhereInput.


        :param id_not: The id_not of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type id_not: str
        """

        self._id_not = id_not

    @property
    def id_not_contains(self):
        """Gets the id_not_contains of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The id_not_contains of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_contains

    @id_not_contains.setter
    def id_not_contains(self, id_not_contains):
        """Sets the id_not_contains of this VirtualPrivateCloudServiceWhereInput.


        :param id_not_contains: The id_not_contains of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type id_not_contains: str
        """

        self._id_not_contains = id_not_contains

    @property
    def id_not_ends_with(self):
        """Gets the id_not_ends_with of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The id_not_ends_with of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_ends_with

    @id_not_ends_with.setter
    def id_not_ends_with(self, id_not_ends_with):
        """Sets the id_not_ends_with of this VirtualPrivateCloudServiceWhereInput.


        :param id_not_ends_with: The id_not_ends_with of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type id_not_ends_with: str
        """

        self._id_not_ends_with = id_not_ends_with

    @property
    def id_not_in(self):
        """Gets the id_not_in of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The id_not_in of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_not_in

    @id_not_in.setter
    def id_not_in(self, id_not_in):
        """Sets the id_not_in of this VirtualPrivateCloudServiceWhereInput.


        :param id_not_in: The id_not_in of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type id_not_in: list[str]
        """

        self._id_not_in = id_not_in

    @property
    def id_not_starts_with(self):
        """Gets the id_not_starts_with of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The id_not_starts_with of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_starts_with

    @id_not_starts_with.setter
    def id_not_starts_with(self, id_not_starts_with):
        """Sets the id_not_starts_with of this VirtualPrivateCloudServiceWhereInput.


        :param id_not_starts_with: The id_not_starts_with of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type id_not_starts_with: str
        """

        self._id_not_starts_with = id_not_starts_with

    @property
    def id_starts_with(self):
        """Gets the id_starts_with of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The id_starts_with of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_starts_with

    @id_starts_with.setter
    def id_starts_with(self, id_starts_with):
        """Sets the id_starts_with of this VirtualPrivateCloudServiceWhereInput.


        :param id_starts_with: The id_starts_with of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type id_starts_with: str
        """

        self._id_starts_with = id_starts_with

    @property
    def internal_cidr(self):
        """Gets the internal_cidr of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The internal_cidr of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._internal_cidr

    @internal_cidr.setter
    def internal_cidr(self, internal_cidr):
        """Sets the internal_cidr of this VirtualPrivateCloudServiceWhereInput.


        :param internal_cidr: The internal_cidr of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type internal_cidr: str
        """

        self._internal_cidr = internal_cidr

    @property
    def internal_cidr_contains(self):
        """Gets the internal_cidr_contains of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The internal_cidr_contains of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._internal_cidr_contains

    @internal_cidr_contains.setter
    def internal_cidr_contains(self, internal_cidr_contains):
        """Sets the internal_cidr_contains of this VirtualPrivateCloudServiceWhereInput.


        :param internal_cidr_contains: The internal_cidr_contains of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type internal_cidr_contains: str
        """

        self._internal_cidr_contains = internal_cidr_contains

    @property
    def internal_cidr_ends_with(self):
        """Gets the internal_cidr_ends_with of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The internal_cidr_ends_with of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._internal_cidr_ends_with

    @internal_cidr_ends_with.setter
    def internal_cidr_ends_with(self, internal_cidr_ends_with):
        """Sets the internal_cidr_ends_with of this VirtualPrivateCloudServiceWhereInput.


        :param internal_cidr_ends_with: The internal_cidr_ends_with of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type internal_cidr_ends_with: str
        """

        self._internal_cidr_ends_with = internal_cidr_ends_with

    @property
    def internal_cidr_gt(self):
        """Gets the internal_cidr_gt of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The internal_cidr_gt of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._internal_cidr_gt

    @internal_cidr_gt.setter
    def internal_cidr_gt(self, internal_cidr_gt):
        """Sets the internal_cidr_gt of this VirtualPrivateCloudServiceWhereInput.


        :param internal_cidr_gt: The internal_cidr_gt of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type internal_cidr_gt: str
        """

        self._internal_cidr_gt = internal_cidr_gt

    @property
    def internal_cidr_gte(self):
        """Gets the internal_cidr_gte of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The internal_cidr_gte of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._internal_cidr_gte

    @internal_cidr_gte.setter
    def internal_cidr_gte(self, internal_cidr_gte):
        """Sets the internal_cidr_gte of this VirtualPrivateCloudServiceWhereInput.


        :param internal_cidr_gte: The internal_cidr_gte of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type internal_cidr_gte: str
        """

        self._internal_cidr_gte = internal_cidr_gte

    @property
    def internal_cidr_in(self):
        """Gets the internal_cidr_in of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The internal_cidr_in of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._internal_cidr_in

    @internal_cidr_in.setter
    def internal_cidr_in(self, internal_cidr_in):
        """Sets the internal_cidr_in of this VirtualPrivateCloudServiceWhereInput.


        :param internal_cidr_in: The internal_cidr_in of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type internal_cidr_in: list[str]
        """

        self._internal_cidr_in = internal_cidr_in

    @property
    def internal_cidr_lt(self):
        """Gets the internal_cidr_lt of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The internal_cidr_lt of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._internal_cidr_lt

    @internal_cidr_lt.setter
    def internal_cidr_lt(self, internal_cidr_lt):
        """Sets the internal_cidr_lt of this VirtualPrivateCloudServiceWhereInput.


        :param internal_cidr_lt: The internal_cidr_lt of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type internal_cidr_lt: str
        """

        self._internal_cidr_lt = internal_cidr_lt

    @property
    def internal_cidr_lte(self):
        """Gets the internal_cidr_lte of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The internal_cidr_lte of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._internal_cidr_lte

    @internal_cidr_lte.setter
    def internal_cidr_lte(self, internal_cidr_lte):
        """Sets the internal_cidr_lte of this VirtualPrivateCloudServiceWhereInput.


        :param internal_cidr_lte: The internal_cidr_lte of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type internal_cidr_lte: str
        """

        self._internal_cidr_lte = internal_cidr_lte

    @property
    def internal_cidr_not(self):
        """Gets the internal_cidr_not of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The internal_cidr_not of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._internal_cidr_not

    @internal_cidr_not.setter
    def internal_cidr_not(self, internal_cidr_not):
        """Sets the internal_cidr_not of this VirtualPrivateCloudServiceWhereInput.


        :param internal_cidr_not: The internal_cidr_not of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type internal_cidr_not: str
        """

        self._internal_cidr_not = internal_cidr_not

    @property
    def internal_cidr_not_contains(self):
        """Gets the internal_cidr_not_contains of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The internal_cidr_not_contains of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._internal_cidr_not_contains

    @internal_cidr_not_contains.setter
    def internal_cidr_not_contains(self, internal_cidr_not_contains):
        """Sets the internal_cidr_not_contains of this VirtualPrivateCloudServiceWhereInput.


        :param internal_cidr_not_contains: The internal_cidr_not_contains of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type internal_cidr_not_contains: str
        """

        self._internal_cidr_not_contains = internal_cidr_not_contains

    @property
    def internal_cidr_not_ends_with(self):
        """Gets the internal_cidr_not_ends_with of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The internal_cidr_not_ends_with of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._internal_cidr_not_ends_with

    @internal_cidr_not_ends_with.setter
    def internal_cidr_not_ends_with(self, internal_cidr_not_ends_with):
        """Sets the internal_cidr_not_ends_with of this VirtualPrivateCloudServiceWhereInput.


        :param internal_cidr_not_ends_with: The internal_cidr_not_ends_with of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type internal_cidr_not_ends_with: str
        """

        self._internal_cidr_not_ends_with = internal_cidr_not_ends_with

    @property
    def internal_cidr_not_in(self):
        """Gets the internal_cidr_not_in of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The internal_cidr_not_in of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._internal_cidr_not_in

    @internal_cidr_not_in.setter
    def internal_cidr_not_in(self, internal_cidr_not_in):
        """Sets the internal_cidr_not_in of this VirtualPrivateCloudServiceWhereInput.


        :param internal_cidr_not_in: The internal_cidr_not_in of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type internal_cidr_not_in: list[str]
        """

        self._internal_cidr_not_in = internal_cidr_not_in

    @property
    def internal_cidr_not_starts_with(self):
        """Gets the internal_cidr_not_starts_with of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The internal_cidr_not_starts_with of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._internal_cidr_not_starts_with

    @internal_cidr_not_starts_with.setter
    def internal_cidr_not_starts_with(self, internal_cidr_not_starts_with):
        """Sets the internal_cidr_not_starts_with of this VirtualPrivateCloudServiceWhereInput.


        :param internal_cidr_not_starts_with: The internal_cidr_not_starts_with of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type internal_cidr_not_starts_with: str
        """

        self._internal_cidr_not_starts_with = internal_cidr_not_starts_with

    @property
    def internal_cidr_starts_with(self):
        """Gets the internal_cidr_starts_with of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The internal_cidr_starts_with of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._internal_cidr_starts_with

    @internal_cidr_starts_with.setter
    def internal_cidr_starts_with(self, internal_cidr_starts_with):
        """Sets the internal_cidr_starts_with of this VirtualPrivateCloudServiceWhereInput.


        :param internal_cidr_starts_with: The internal_cidr_starts_with of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type internal_cidr_starts_with: str
        """

        self._internal_cidr_starts_with = internal_cidr_starts_with

    @property
    def phase(self):
        """Gets the phase of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The phase of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: EverouteClusterPhase
        """
        return self._phase

    @phase.setter
    def phase(self, phase):
        """Sets the phase of this VirtualPrivateCloudServiceWhereInput.


        :param phase: The phase of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type phase: EverouteClusterPhase
        """

        self._phase = phase

    @property
    def phase_in(self):
        """Gets the phase_in of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The phase_in of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: list[EverouteClusterPhase]
        """
        return self._phase_in

    @phase_in.setter
    def phase_in(self, phase_in):
        """Sets the phase_in of this VirtualPrivateCloudServiceWhereInput.


        :param phase_in: The phase_in of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type phase_in: list[EverouteClusterPhase]
        """

        self._phase_in = phase_in

    @property
    def phase_not(self):
        """Gets the phase_not of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The phase_not of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: EverouteClusterPhase
        """
        return self._phase_not

    @phase_not.setter
    def phase_not(self, phase_not):
        """Sets the phase_not of this VirtualPrivateCloudServiceWhereInput.


        :param phase_not: The phase_not of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type phase_not: EverouteClusterPhase
        """

        self._phase_not = phase_not

    @property
    def phase_not_in(self):
        """Gets the phase_not_in of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The phase_not_in of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: list[EverouteClusterPhase]
        """
        return self._phase_not_in

    @phase_not_in.setter
    def phase_not_in(self, phase_not_in):
        """Sets the phase_not_in of this VirtualPrivateCloudServiceWhereInput.


        :param phase_not_in: The phase_not_in of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type phase_not_in: list[EverouteClusterPhase]
        """

        self._phase_not_in = phase_not_in

    @property
    def vpcs_every(self):
        """Gets the vpcs_every of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The vpcs_every of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: VirtualPrivateCloudWhereInput
        """
        return self._vpcs_every

    @vpcs_every.setter
    def vpcs_every(self, vpcs_every):
        """Sets the vpcs_every of this VirtualPrivateCloudServiceWhereInput.


        :param vpcs_every: The vpcs_every of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type vpcs_every: VirtualPrivateCloudWhereInput
        """

        self._vpcs_every = vpcs_every

    @property
    def vpcs_none(self):
        """Gets the vpcs_none of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The vpcs_none of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: VirtualPrivateCloudWhereInput
        """
        return self._vpcs_none

    @vpcs_none.setter
    def vpcs_none(self, vpcs_none):
        """Sets the vpcs_none of this VirtualPrivateCloudServiceWhereInput.


        :param vpcs_none: The vpcs_none of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type vpcs_none: VirtualPrivateCloudWhereInput
        """

        self._vpcs_none = vpcs_none

    @property
    def vpcs_some(self):
        """Gets the vpcs_some of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501


        :return: The vpcs_some of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :rtype: VirtualPrivateCloudWhereInput
        """
        return self._vpcs_some

    @vpcs_some.setter
    def vpcs_some(self, vpcs_some):
        """Sets the vpcs_some of this VirtualPrivateCloudServiceWhereInput.


        :param vpcs_some: The vpcs_some of this VirtualPrivateCloudServiceWhereInput.  # noqa: E501
        :type vpcs_some: VirtualPrivateCloudWhereInput
        """

        self._vpcs_some = vpcs_some

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VirtualPrivateCloudServiceWhereInput):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VirtualPrivateCloudServiceWhereInput):
            return True

        return self.to_dict() != other.to_dict()
