# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class VirtualPrivateCloudSubnet(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'cidr': 'str',
        'description': 'str',
        'entity_async_status': 'EntityAsyncStatus',
        'gateway': 'str',
        'id': 'str',
        'ip_pools': 'list[NestedVpcSubnetIpPooType]',
        'local_id': 'str',
        'name': 'str',
        'route_table': 'NestedVirtualPrivateCloudRouteTable',
        'total_ip_count': 'int',
        'unused_ip_count': 'int',
        'vpc': 'NestedVirtualPrivateCloud'
    }

    attribute_map = {
        'cidr': 'cidr',
        'description': 'description',
        'entity_async_status': 'entityAsyncStatus',
        'gateway': 'gateway',
        'id': 'id',
        'ip_pools': 'ip_pools',
        'local_id': 'local_id',
        'name': 'name',
        'route_table': 'route_table',
        'total_ip_count': 'total_ip_count',
        'unused_ip_count': 'unused_ip_count',
        'vpc': 'vpc'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """VirtualPrivateCloudSubnet - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._cidr = None
        self._description = None
        self._entity_async_status = None
        self._gateway = None
        self._id = None
        self._ip_pools = None
        self._local_id = None
        self._name = None
        self._route_table = None
        self._total_ip_count = None
        self._unused_ip_count = None
        self._vpc = None
        self.discriminator = None

        if "cidr" in kwargs:
            self.cidr = kwargs["cidr"]
        self.description = kwargs.get("description", None)
        self.entity_async_status = kwargs.get("entity_async_status", None)
        self.gateway = kwargs.get("gateway", None)
        if "id" in kwargs:
            self.id = kwargs["id"]
        self.ip_pools = kwargs.get("ip_pools", None)
        if "local_id" in kwargs:
            self.local_id = kwargs["local_id"]
        if "name" in kwargs:
            self.name = kwargs["name"]
        if "route_table" in kwargs:
            self.route_table = kwargs["route_table"]
        self.total_ip_count = kwargs.get("total_ip_count", None)
        self.unused_ip_count = kwargs.get("unused_ip_count", None)
        if "vpc" in kwargs:
            self.vpc = kwargs["vpc"]

    @property
    def cidr(self):
        """Gets the cidr of this VirtualPrivateCloudSubnet.  # noqa: E501


        :return: The cidr of this VirtualPrivateCloudSubnet.  # noqa: E501
        :rtype: str
        """
        return self._cidr

    @cidr.setter
    def cidr(self, cidr):
        """Sets the cidr of this VirtualPrivateCloudSubnet.


        :param cidr: The cidr of this VirtualPrivateCloudSubnet.  # noqa: E501
        :type cidr: str
        """
        if self.local_vars_configuration.client_side_validation and cidr is None:  # noqa: E501
            raise ValueError("Invalid value for `cidr`, must not be `None`")  # noqa: E501

        self._cidr = cidr

    @property
    def description(self):
        """Gets the description of this VirtualPrivateCloudSubnet.  # noqa: E501


        :return: The description of this VirtualPrivateCloudSubnet.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this VirtualPrivateCloudSubnet.


        :param description: The description of this VirtualPrivateCloudSubnet.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this VirtualPrivateCloudSubnet.  # noqa: E501


        :return: The entity_async_status of this VirtualPrivateCloudSubnet.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this VirtualPrivateCloudSubnet.


        :param entity_async_status: The entity_async_status of this VirtualPrivateCloudSubnet.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def gateway(self):
        """Gets the gateway of this VirtualPrivateCloudSubnet.  # noqa: E501


        :return: The gateway of this VirtualPrivateCloudSubnet.  # noqa: E501
        :rtype: str
        """
        return self._gateway

    @gateway.setter
    def gateway(self, gateway):
        """Sets the gateway of this VirtualPrivateCloudSubnet.


        :param gateway: The gateway of this VirtualPrivateCloudSubnet.  # noqa: E501
        :type gateway: str
        """

        self._gateway = gateway

    @property
    def id(self):
        """Gets the id of this VirtualPrivateCloudSubnet.  # noqa: E501


        :return: The id of this VirtualPrivateCloudSubnet.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this VirtualPrivateCloudSubnet.


        :param id: The id of this VirtualPrivateCloudSubnet.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def ip_pools(self):
        """Gets the ip_pools of this VirtualPrivateCloudSubnet.  # noqa: E501


        :return: The ip_pools of this VirtualPrivateCloudSubnet.  # noqa: E501
        :rtype: list[NestedVpcSubnetIpPooType]
        """
        return self._ip_pools

    @ip_pools.setter
    def ip_pools(self, ip_pools):
        """Sets the ip_pools of this VirtualPrivateCloudSubnet.


        :param ip_pools: The ip_pools of this VirtualPrivateCloudSubnet.  # noqa: E501
        :type ip_pools: list[NestedVpcSubnetIpPooType]
        """

        self._ip_pools = ip_pools

    @property
    def local_id(self):
        """Gets the local_id of this VirtualPrivateCloudSubnet.  # noqa: E501


        :return: The local_id of this VirtualPrivateCloudSubnet.  # noqa: E501
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id):
        """Sets the local_id of this VirtualPrivateCloudSubnet.


        :param local_id: The local_id of this VirtualPrivateCloudSubnet.  # noqa: E501
        :type local_id: str
        """
        if self.local_vars_configuration.client_side_validation and local_id is None:  # noqa: E501
            raise ValueError("Invalid value for `local_id`, must not be `None`")  # noqa: E501

        self._local_id = local_id

    @property
    def name(self):
        """Gets the name of this VirtualPrivateCloudSubnet.  # noqa: E501


        :return: The name of this VirtualPrivateCloudSubnet.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this VirtualPrivateCloudSubnet.


        :param name: The name of this VirtualPrivateCloudSubnet.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def route_table(self):
        """Gets the route_table of this VirtualPrivateCloudSubnet.  # noqa: E501


        :return: The route_table of this VirtualPrivateCloudSubnet.  # noqa: E501
        :rtype: NestedVirtualPrivateCloudRouteTable
        """
        return self._route_table

    @route_table.setter
    def route_table(self, route_table):
        """Sets the route_table of this VirtualPrivateCloudSubnet.


        :param route_table: The route_table of this VirtualPrivateCloudSubnet.  # noqa: E501
        :type route_table: NestedVirtualPrivateCloudRouteTable
        """
        if self.local_vars_configuration.client_side_validation and route_table is None:  # noqa: E501
            raise ValueError("Invalid value for `route_table`, must not be `None`")  # noqa: E501

        self._route_table = route_table

    @property
    def total_ip_count(self):
        """Gets the total_ip_count of this VirtualPrivateCloudSubnet.  # noqa: E501


        :return: The total_ip_count of this VirtualPrivateCloudSubnet.  # noqa: E501
        :rtype: int
        """
        return self._total_ip_count

    @total_ip_count.setter
    def total_ip_count(self, total_ip_count):
        """Sets the total_ip_count of this VirtualPrivateCloudSubnet.


        :param total_ip_count: The total_ip_count of this VirtualPrivateCloudSubnet.  # noqa: E501
        :type total_ip_count: int
        """

        self._total_ip_count = total_ip_count

    @property
    def unused_ip_count(self):
        """Gets the unused_ip_count of this VirtualPrivateCloudSubnet.  # noqa: E501


        :return: The unused_ip_count of this VirtualPrivateCloudSubnet.  # noqa: E501
        :rtype: int
        """
        return self._unused_ip_count

    @unused_ip_count.setter
    def unused_ip_count(self, unused_ip_count):
        """Sets the unused_ip_count of this VirtualPrivateCloudSubnet.


        :param unused_ip_count: The unused_ip_count of this VirtualPrivateCloudSubnet.  # noqa: E501
        :type unused_ip_count: int
        """

        self._unused_ip_count = unused_ip_count

    @property
    def vpc(self):
        """Gets the vpc of this VirtualPrivateCloudSubnet.  # noqa: E501


        :return: The vpc of this VirtualPrivateCloudSubnet.  # noqa: E501
        :rtype: NestedVirtualPrivateCloud
        """
        return self._vpc

    @vpc.setter
    def vpc(self, vpc):
        """Sets the vpc of this VirtualPrivateCloudSubnet.


        :param vpc: The vpc of this VirtualPrivateCloudSubnet.  # noqa: E501
        :type vpc: NestedVirtualPrivateCloud
        """
        if self.local_vars_configuration.client_side_validation and vpc is None:  # noqa: E501
            raise ValueError("Invalid value for `vpc`, must not be `None`")  # noqa: E501

        self._vpc = vpc

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VirtualPrivateCloudSubnet):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VirtualPrivateCloudSubnet):
            return True

        return self.to_dict() != other.to_dict()
