# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class VirtualPrivateCloudSubnetCreationParams(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'route_table_id': 'str',
        'ip_pools': 'list[VirtualPrivateCloudSubnetIpPoolParams]',
        'gateway': 'str',
        'cidr': 'str',
        'vpc_id': 'str',
        'description': 'str',
        'name': 'str'
    }

    attribute_map = {
        'route_table_id': 'route_table_id',
        'ip_pools': 'ip_pools',
        'gateway': 'gateway',
        'cidr': 'cidr',
        'vpc_id': 'vpc_id',
        'description': 'description',
        'name': 'name'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """VirtualPrivateCloudSubnetCreationParams - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._route_table_id = None
        self._ip_pools = None
        self._gateway = None
        self._cidr = None
        self._vpc_id = None
        self._description = None
        self._name = None
        self.discriminator = None

        if "route_table_id" in kwargs:
            self.route_table_id = kwargs["route_table_id"]
        if "ip_pools" in kwargs:
            self.ip_pools = kwargs["ip_pools"]
        if "gateway" in kwargs:
            self.gateway = kwargs["gateway"]
        if "cidr" in kwargs:
            self.cidr = kwargs["cidr"]
        if "vpc_id" in kwargs:
            self.vpc_id = kwargs["vpc_id"]
        if "description" in kwargs:
            self.description = kwargs["description"]
        if "name" in kwargs:
            self.name = kwargs["name"]

    @property
    def route_table_id(self):
        """Gets the route_table_id of this VirtualPrivateCloudSubnetCreationParams.  # noqa: E501


        :return: The route_table_id of this VirtualPrivateCloudSubnetCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._route_table_id

    @route_table_id.setter
    def route_table_id(self, route_table_id):
        """Sets the route_table_id of this VirtualPrivateCloudSubnetCreationParams.


        :param route_table_id: The route_table_id of this VirtualPrivateCloudSubnetCreationParams.  # noqa: E501
        :type route_table_id: str
        """
        if self.local_vars_configuration.client_side_validation and route_table_id is None:  # noqa: E501
            raise ValueError("Invalid value for `route_table_id`, must not be `None`")  # noqa: E501

        self._route_table_id = route_table_id

    @property
    def ip_pools(self):
        """Gets the ip_pools of this VirtualPrivateCloudSubnetCreationParams.  # noqa: E501


        :return: The ip_pools of this VirtualPrivateCloudSubnetCreationParams.  # noqa: E501
        :rtype: list[VirtualPrivateCloudSubnetIpPoolParams]
        """
        return self._ip_pools

    @ip_pools.setter
    def ip_pools(self, ip_pools):
        """Sets the ip_pools of this VirtualPrivateCloudSubnetCreationParams.


        :param ip_pools: The ip_pools of this VirtualPrivateCloudSubnetCreationParams.  # noqa: E501
        :type ip_pools: list[VirtualPrivateCloudSubnetIpPoolParams]
        """

        self._ip_pools = ip_pools

    @property
    def gateway(self):
        """Gets the gateway of this VirtualPrivateCloudSubnetCreationParams.  # noqa: E501


        :return: The gateway of this VirtualPrivateCloudSubnetCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._gateway

    @gateway.setter
    def gateway(self, gateway):
        """Sets the gateway of this VirtualPrivateCloudSubnetCreationParams.


        :param gateway: The gateway of this VirtualPrivateCloudSubnetCreationParams.  # noqa: E501
        :type gateway: str
        """
        if self.local_vars_configuration.client_side_validation and gateway is None:  # noqa: E501
            raise ValueError("Invalid value for `gateway`, must not be `None`")  # noqa: E501

        self._gateway = gateway

    @property
    def cidr(self):
        """Gets the cidr of this VirtualPrivateCloudSubnetCreationParams.  # noqa: E501


        :return: The cidr of this VirtualPrivateCloudSubnetCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._cidr

    @cidr.setter
    def cidr(self, cidr):
        """Sets the cidr of this VirtualPrivateCloudSubnetCreationParams.


        :param cidr: The cidr of this VirtualPrivateCloudSubnetCreationParams.  # noqa: E501
        :type cidr: str
        """
        if self.local_vars_configuration.client_side_validation and cidr is None:  # noqa: E501
            raise ValueError("Invalid value for `cidr`, must not be `None`")  # noqa: E501

        self._cidr = cidr

    @property
    def vpc_id(self):
        """Gets the vpc_id of this VirtualPrivateCloudSubnetCreationParams.  # noqa: E501


        :return: The vpc_id of this VirtualPrivateCloudSubnetCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._vpc_id

    @vpc_id.setter
    def vpc_id(self, vpc_id):
        """Sets the vpc_id of this VirtualPrivateCloudSubnetCreationParams.


        :param vpc_id: The vpc_id of this VirtualPrivateCloudSubnetCreationParams.  # noqa: E501
        :type vpc_id: str
        """
        if self.local_vars_configuration.client_side_validation and vpc_id is None:  # noqa: E501
            raise ValueError("Invalid value for `vpc_id`, must not be `None`")  # noqa: E501

        self._vpc_id = vpc_id

    @property
    def description(self):
        """Gets the description of this VirtualPrivateCloudSubnetCreationParams.  # noqa: E501


        :return: The description of this VirtualPrivateCloudSubnetCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this VirtualPrivateCloudSubnetCreationParams.


        :param description: The description of this VirtualPrivateCloudSubnetCreationParams.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def name(self):
        """Gets the name of this VirtualPrivateCloudSubnetCreationParams.  # noqa: E501


        :return: The name of this VirtualPrivateCloudSubnetCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this VirtualPrivateCloudSubnetCreationParams.


        :param name: The name of this VirtualPrivateCloudSubnetCreationParams.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VirtualPrivateCloudSubnetCreationParams):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VirtualPrivateCloudSubnetCreationParams):
            return True

        return self.to_dict() != other.to_dict()
