# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class VirtualPrivateCloudWhereInput(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        '_and': 'list[VirtualPrivateCloudWhereInput]',
        '_not': 'list[VirtualPrivateCloudWhereInput]',
        '_or': 'list[VirtualPrivateCloudWhereInput]',
        'associate_external_subnet_num': 'int',
        'associate_external_subnet_num_gt': 'int',
        'associate_external_subnet_num_gte': 'int',
        'associate_external_subnet_num_in': 'list[int]',
        'associate_external_subnet_num_lt': 'int',
        'associate_external_subnet_num_lte': 'int',
        'associate_external_subnet_num_not': 'int',
        'associate_external_subnet_num_not_in': 'list[int]',
        'description': 'str',
        'description_contains': 'str',
        'description_ends_with': 'str',
        'description_gt': 'str',
        'description_gte': 'str',
        'description_in': 'list[str]',
        'description_lt': 'str',
        'description_lte': 'str',
        'description_not': 'str',
        'description_not_contains': 'str',
        'description_not_ends_with': 'str',
        'description_not_in': 'list[str]',
        'description_not_starts_with': 'str',
        'description_starts_with': 'str',
        'entity_async_status': 'EntityAsyncStatus',
        'entity_async_status_in': 'list[EntityAsyncStatus]',
        'entity_async_status_not': 'EntityAsyncStatus',
        'entity_async_status_not_in': 'list[EntityAsyncStatus]',
        'id': 'str',
        'id_contains': 'str',
        'id_ends_with': 'str',
        'id_gt': 'str',
        'id_gte': 'str',
        'id_in': 'list[str]',
        'id_lt': 'str',
        'id_lte': 'str',
        'id_not': 'str',
        'id_not_contains': 'str',
        'id_not_ends_with': 'str',
        'id_not_in': 'list[str]',
        'id_not_starts_with': 'str',
        'id_starts_with': 'str',
        'isolation_policies_every': 'VirtualPrivateCloudIsolationPolicyWhereInput',
        'isolation_policies_none': 'VirtualPrivateCloudIsolationPolicyWhereInput',
        'isolation_policies_some': 'VirtualPrivateCloudIsolationPolicyWhereInput',
        'local_id': 'str',
        'local_id_contains': 'str',
        'local_id_ends_with': 'str',
        'local_id_gt': 'str',
        'local_id_gte': 'str',
        'local_id_in': 'list[str]',
        'local_id_lt': 'str',
        'local_id_lte': 'str',
        'local_id_not': 'str',
        'local_id_not_contains': 'str',
        'local_id_not_ends_with': 'str',
        'local_id_not_in': 'list[str]',
        'local_id_not_starts_with': 'str',
        'local_id_starts_with': 'str',
        'mtu': 'int',
        'mtu_gt': 'int',
        'mtu_gte': 'int',
        'mtu_in': 'list[int]',
        'mtu_lt': 'int',
        'mtu_lte': 'int',
        'mtu_not': 'int',
        'mtu_not_in': 'list[int]',
        'name': 'str',
        'name_contains': 'str',
        'name_ends_with': 'str',
        'name_gt': 'str',
        'name_gte': 'str',
        'name_in': 'list[str]',
        'name_lt': 'str',
        'name_lte': 'str',
        'name_not': 'str',
        'name_not_contains': 'str',
        'name_not_ends_with': 'str',
        'name_not_in': 'list[str]',
        'name_not_starts_with': 'str',
        'name_starts_with': 'str',
        'route_tables_every': 'VirtualPrivateCloudRouteTableWhereInput',
        'route_tables_none': 'VirtualPrivateCloudRouteTableWhereInput',
        'route_tables_some': 'VirtualPrivateCloudRouteTableWhereInput',
        'security_groups_every': 'VirtualPrivateCloudSecurityGroupWhereInput',
        'security_groups_none': 'VirtualPrivateCloudSecurityGroupWhereInput',
        'security_groups_some': 'VirtualPrivateCloudSecurityGroupWhereInput',
        'security_policies_every': 'VirtualPrivateCloudSecurityPolicyWhereInput',
        'security_policies_none': 'VirtualPrivateCloudSecurityPolicyWhereInput',
        'security_policies_some': 'VirtualPrivateCloudSecurityPolicyWhereInput',
        'subnets_every': 'VirtualPrivateCloudSubnetWhereInput',
        'subnets_none': 'VirtualPrivateCloudSubnetWhereInput',
        'subnets_some': 'VirtualPrivateCloudSubnetWhereInput',
        'vpc_service': 'VirtualPrivateCloudServiceWhereInput'
    }

    attribute_map = {
        '_and': 'AND',
        '_not': 'NOT',
        '_or': 'OR',
        'associate_external_subnet_num': 'associate_external_subnet_num',
        'associate_external_subnet_num_gt': 'associate_external_subnet_num_gt',
        'associate_external_subnet_num_gte': 'associate_external_subnet_num_gte',
        'associate_external_subnet_num_in': 'associate_external_subnet_num_in',
        'associate_external_subnet_num_lt': 'associate_external_subnet_num_lt',
        'associate_external_subnet_num_lte': 'associate_external_subnet_num_lte',
        'associate_external_subnet_num_not': 'associate_external_subnet_num_not',
        'associate_external_subnet_num_not_in': 'associate_external_subnet_num_not_in',
        'description': 'description',
        'description_contains': 'description_contains',
        'description_ends_with': 'description_ends_with',
        'description_gt': 'description_gt',
        'description_gte': 'description_gte',
        'description_in': 'description_in',
        'description_lt': 'description_lt',
        'description_lte': 'description_lte',
        'description_not': 'description_not',
        'description_not_contains': 'description_not_contains',
        'description_not_ends_with': 'description_not_ends_with',
        'description_not_in': 'description_not_in',
        'description_not_starts_with': 'description_not_starts_with',
        'description_starts_with': 'description_starts_with',
        'entity_async_status': 'entityAsyncStatus',
        'entity_async_status_in': 'entityAsyncStatus_in',
        'entity_async_status_not': 'entityAsyncStatus_not',
        'entity_async_status_not_in': 'entityAsyncStatus_not_in',
        'id': 'id',
        'id_contains': 'id_contains',
        'id_ends_with': 'id_ends_with',
        'id_gt': 'id_gt',
        'id_gte': 'id_gte',
        'id_in': 'id_in',
        'id_lt': 'id_lt',
        'id_lte': 'id_lte',
        'id_not': 'id_not',
        'id_not_contains': 'id_not_contains',
        'id_not_ends_with': 'id_not_ends_with',
        'id_not_in': 'id_not_in',
        'id_not_starts_with': 'id_not_starts_with',
        'id_starts_with': 'id_starts_with',
        'isolation_policies_every': 'isolation_policies_every',
        'isolation_policies_none': 'isolation_policies_none',
        'isolation_policies_some': 'isolation_policies_some',
        'local_id': 'local_id',
        'local_id_contains': 'local_id_contains',
        'local_id_ends_with': 'local_id_ends_with',
        'local_id_gt': 'local_id_gt',
        'local_id_gte': 'local_id_gte',
        'local_id_in': 'local_id_in',
        'local_id_lt': 'local_id_lt',
        'local_id_lte': 'local_id_lte',
        'local_id_not': 'local_id_not',
        'local_id_not_contains': 'local_id_not_contains',
        'local_id_not_ends_with': 'local_id_not_ends_with',
        'local_id_not_in': 'local_id_not_in',
        'local_id_not_starts_with': 'local_id_not_starts_with',
        'local_id_starts_with': 'local_id_starts_with',
        'mtu': 'mtu',
        'mtu_gt': 'mtu_gt',
        'mtu_gte': 'mtu_gte',
        'mtu_in': 'mtu_in',
        'mtu_lt': 'mtu_lt',
        'mtu_lte': 'mtu_lte',
        'mtu_not': 'mtu_not',
        'mtu_not_in': 'mtu_not_in',
        'name': 'name',
        'name_contains': 'name_contains',
        'name_ends_with': 'name_ends_with',
        'name_gt': 'name_gt',
        'name_gte': 'name_gte',
        'name_in': 'name_in',
        'name_lt': 'name_lt',
        'name_lte': 'name_lte',
        'name_not': 'name_not',
        'name_not_contains': 'name_not_contains',
        'name_not_ends_with': 'name_not_ends_with',
        'name_not_in': 'name_not_in',
        'name_not_starts_with': 'name_not_starts_with',
        'name_starts_with': 'name_starts_with',
        'route_tables_every': 'route_tables_every',
        'route_tables_none': 'route_tables_none',
        'route_tables_some': 'route_tables_some',
        'security_groups_every': 'security_groups_every',
        'security_groups_none': 'security_groups_none',
        'security_groups_some': 'security_groups_some',
        'security_policies_every': 'security_policies_every',
        'security_policies_none': 'security_policies_none',
        'security_policies_some': 'security_policies_some',
        'subnets_every': 'subnets_every',
        'subnets_none': 'subnets_none',
        'subnets_some': 'subnets_some',
        'vpc_service': 'vpc_service'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """VirtualPrivateCloudWhereInput - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self.__and = None
        self.__not = None
        self.__or = None
        self._associate_external_subnet_num = None
        self._associate_external_subnet_num_gt = None
        self._associate_external_subnet_num_gte = None
        self._associate_external_subnet_num_in = None
        self._associate_external_subnet_num_lt = None
        self._associate_external_subnet_num_lte = None
        self._associate_external_subnet_num_not = None
        self._associate_external_subnet_num_not_in = None
        self._description = None
        self._description_contains = None
        self._description_ends_with = None
        self._description_gt = None
        self._description_gte = None
        self._description_in = None
        self._description_lt = None
        self._description_lte = None
        self._description_not = None
        self._description_not_contains = None
        self._description_not_ends_with = None
        self._description_not_in = None
        self._description_not_starts_with = None
        self._description_starts_with = None
        self._entity_async_status = None
        self._entity_async_status_in = None
        self._entity_async_status_not = None
        self._entity_async_status_not_in = None
        self._id = None
        self._id_contains = None
        self._id_ends_with = None
        self._id_gt = None
        self._id_gte = None
        self._id_in = None
        self._id_lt = None
        self._id_lte = None
        self._id_not = None
        self._id_not_contains = None
        self._id_not_ends_with = None
        self._id_not_in = None
        self._id_not_starts_with = None
        self._id_starts_with = None
        self._isolation_policies_every = None
        self._isolation_policies_none = None
        self._isolation_policies_some = None
        self._local_id = None
        self._local_id_contains = None
        self._local_id_ends_with = None
        self._local_id_gt = None
        self._local_id_gte = None
        self._local_id_in = None
        self._local_id_lt = None
        self._local_id_lte = None
        self._local_id_not = None
        self._local_id_not_contains = None
        self._local_id_not_ends_with = None
        self._local_id_not_in = None
        self._local_id_not_starts_with = None
        self._local_id_starts_with = None
        self._mtu = None
        self._mtu_gt = None
        self._mtu_gte = None
        self._mtu_in = None
        self._mtu_lt = None
        self._mtu_lte = None
        self._mtu_not = None
        self._mtu_not_in = None
        self._name = None
        self._name_contains = None
        self._name_ends_with = None
        self._name_gt = None
        self._name_gte = None
        self._name_in = None
        self._name_lt = None
        self._name_lte = None
        self._name_not = None
        self._name_not_contains = None
        self._name_not_ends_with = None
        self._name_not_in = None
        self._name_not_starts_with = None
        self._name_starts_with = None
        self._route_tables_every = None
        self._route_tables_none = None
        self._route_tables_some = None
        self._security_groups_every = None
        self._security_groups_none = None
        self._security_groups_some = None
        self._security_policies_every = None
        self._security_policies_none = None
        self._security_policies_some = None
        self._subnets_every = None
        self._subnets_none = None
        self._subnets_some = None
        self._vpc_service = None
        self.discriminator = None

        self._and = kwargs.get("_and", None)
        self._not = kwargs.get("_not", None)
        self._or = kwargs.get("_or", None)
        self.associate_external_subnet_num = kwargs.get("associate_external_subnet_num", None)
        self.associate_external_subnet_num_gt = kwargs.get("associate_external_subnet_num_gt", None)
        self.associate_external_subnet_num_gte = kwargs.get("associate_external_subnet_num_gte", None)
        self.associate_external_subnet_num_in = kwargs.get("associate_external_subnet_num_in", None)
        self.associate_external_subnet_num_lt = kwargs.get("associate_external_subnet_num_lt", None)
        self.associate_external_subnet_num_lte = kwargs.get("associate_external_subnet_num_lte", None)
        self.associate_external_subnet_num_not = kwargs.get("associate_external_subnet_num_not", None)
        self.associate_external_subnet_num_not_in = kwargs.get("associate_external_subnet_num_not_in", None)
        self.description = kwargs.get("description", None)
        self.description_contains = kwargs.get("description_contains", None)
        self.description_ends_with = kwargs.get("description_ends_with", None)
        self.description_gt = kwargs.get("description_gt", None)
        self.description_gte = kwargs.get("description_gte", None)
        self.description_in = kwargs.get("description_in", None)
        self.description_lt = kwargs.get("description_lt", None)
        self.description_lte = kwargs.get("description_lte", None)
        self.description_not = kwargs.get("description_not", None)
        self.description_not_contains = kwargs.get("description_not_contains", None)
        self.description_not_ends_with = kwargs.get("description_not_ends_with", None)
        self.description_not_in = kwargs.get("description_not_in", None)
        self.description_not_starts_with = kwargs.get("description_not_starts_with", None)
        self.description_starts_with = kwargs.get("description_starts_with", None)
        self.entity_async_status = kwargs.get("entity_async_status", None)
        self.entity_async_status_in = kwargs.get("entity_async_status_in", None)
        self.entity_async_status_not = kwargs.get("entity_async_status_not", None)
        self.entity_async_status_not_in = kwargs.get("entity_async_status_not_in", None)
        self.id = kwargs.get("id", None)
        self.id_contains = kwargs.get("id_contains", None)
        self.id_ends_with = kwargs.get("id_ends_with", None)
        self.id_gt = kwargs.get("id_gt", None)
        self.id_gte = kwargs.get("id_gte", None)
        self.id_in = kwargs.get("id_in", None)
        self.id_lt = kwargs.get("id_lt", None)
        self.id_lte = kwargs.get("id_lte", None)
        self.id_not = kwargs.get("id_not", None)
        self.id_not_contains = kwargs.get("id_not_contains", None)
        self.id_not_ends_with = kwargs.get("id_not_ends_with", None)
        self.id_not_in = kwargs.get("id_not_in", None)
        self.id_not_starts_with = kwargs.get("id_not_starts_with", None)
        self.id_starts_with = kwargs.get("id_starts_with", None)
        self.isolation_policies_every = kwargs.get("isolation_policies_every", None)
        self.isolation_policies_none = kwargs.get("isolation_policies_none", None)
        self.isolation_policies_some = kwargs.get("isolation_policies_some", None)
        self.local_id = kwargs.get("local_id", None)
        self.local_id_contains = kwargs.get("local_id_contains", None)
        self.local_id_ends_with = kwargs.get("local_id_ends_with", None)
        self.local_id_gt = kwargs.get("local_id_gt", None)
        self.local_id_gte = kwargs.get("local_id_gte", None)
        self.local_id_in = kwargs.get("local_id_in", None)
        self.local_id_lt = kwargs.get("local_id_lt", None)
        self.local_id_lte = kwargs.get("local_id_lte", None)
        self.local_id_not = kwargs.get("local_id_not", None)
        self.local_id_not_contains = kwargs.get("local_id_not_contains", None)
        self.local_id_not_ends_with = kwargs.get("local_id_not_ends_with", None)
        self.local_id_not_in = kwargs.get("local_id_not_in", None)
        self.local_id_not_starts_with = kwargs.get("local_id_not_starts_with", None)
        self.local_id_starts_with = kwargs.get("local_id_starts_with", None)
        self.mtu = kwargs.get("mtu", None)
        self.mtu_gt = kwargs.get("mtu_gt", None)
        self.mtu_gte = kwargs.get("mtu_gte", None)
        self.mtu_in = kwargs.get("mtu_in", None)
        self.mtu_lt = kwargs.get("mtu_lt", None)
        self.mtu_lte = kwargs.get("mtu_lte", None)
        self.mtu_not = kwargs.get("mtu_not", None)
        self.mtu_not_in = kwargs.get("mtu_not_in", None)
        self.name = kwargs.get("name", None)
        self.name_contains = kwargs.get("name_contains", None)
        self.name_ends_with = kwargs.get("name_ends_with", None)
        self.name_gt = kwargs.get("name_gt", None)
        self.name_gte = kwargs.get("name_gte", None)
        self.name_in = kwargs.get("name_in", None)
        self.name_lt = kwargs.get("name_lt", None)
        self.name_lte = kwargs.get("name_lte", None)
        self.name_not = kwargs.get("name_not", None)
        self.name_not_contains = kwargs.get("name_not_contains", None)
        self.name_not_ends_with = kwargs.get("name_not_ends_with", None)
        self.name_not_in = kwargs.get("name_not_in", None)
        self.name_not_starts_with = kwargs.get("name_not_starts_with", None)
        self.name_starts_with = kwargs.get("name_starts_with", None)
        self.route_tables_every = kwargs.get("route_tables_every", None)
        self.route_tables_none = kwargs.get("route_tables_none", None)
        self.route_tables_some = kwargs.get("route_tables_some", None)
        self.security_groups_every = kwargs.get("security_groups_every", None)
        self.security_groups_none = kwargs.get("security_groups_none", None)
        self.security_groups_some = kwargs.get("security_groups_some", None)
        self.security_policies_every = kwargs.get("security_policies_every", None)
        self.security_policies_none = kwargs.get("security_policies_none", None)
        self.security_policies_some = kwargs.get("security_policies_some", None)
        self.subnets_every = kwargs.get("subnets_every", None)
        self.subnets_none = kwargs.get("subnets_none", None)
        self.subnets_some = kwargs.get("subnets_some", None)
        self.vpc_service = kwargs.get("vpc_service", None)

    @property
    def _and(self):
        """Gets the _and of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The _and of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: list[VirtualPrivateCloudWhereInput]
        """
        return self.__and

    @_and.setter
    def _and(self, _and):
        """Sets the _and of this VirtualPrivateCloudWhereInput.


        :param _and: The _and of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type _and: list[VirtualPrivateCloudWhereInput]
        """

        self.__and = _and

    @property
    def _not(self):
        """Gets the _not of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The _not of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: list[VirtualPrivateCloudWhereInput]
        """
        return self.__not

    @_not.setter
    def _not(self, _not):
        """Sets the _not of this VirtualPrivateCloudWhereInput.


        :param _not: The _not of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type _not: list[VirtualPrivateCloudWhereInput]
        """

        self.__not = _not

    @property
    def _or(self):
        """Gets the _or of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The _or of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: list[VirtualPrivateCloudWhereInput]
        """
        return self.__or

    @_or.setter
    def _or(self, _or):
        """Sets the _or of this VirtualPrivateCloudWhereInput.


        :param _or: The _or of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type _or: list[VirtualPrivateCloudWhereInput]
        """

        self.__or = _or

    @property
    def associate_external_subnet_num(self):
        """Gets the associate_external_subnet_num of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The associate_external_subnet_num of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._associate_external_subnet_num

    @associate_external_subnet_num.setter
    def associate_external_subnet_num(self, associate_external_subnet_num):
        """Sets the associate_external_subnet_num of this VirtualPrivateCloudWhereInput.


        :param associate_external_subnet_num: The associate_external_subnet_num of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type associate_external_subnet_num: int
        """

        self._associate_external_subnet_num = associate_external_subnet_num

    @property
    def associate_external_subnet_num_gt(self):
        """Gets the associate_external_subnet_num_gt of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The associate_external_subnet_num_gt of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._associate_external_subnet_num_gt

    @associate_external_subnet_num_gt.setter
    def associate_external_subnet_num_gt(self, associate_external_subnet_num_gt):
        """Sets the associate_external_subnet_num_gt of this VirtualPrivateCloudWhereInput.


        :param associate_external_subnet_num_gt: The associate_external_subnet_num_gt of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type associate_external_subnet_num_gt: int
        """

        self._associate_external_subnet_num_gt = associate_external_subnet_num_gt

    @property
    def associate_external_subnet_num_gte(self):
        """Gets the associate_external_subnet_num_gte of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The associate_external_subnet_num_gte of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._associate_external_subnet_num_gte

    @associate_external_subnet_num_gte.setter
    def associate_external_subnet_num_gte(self, associate_external_subnet_num_gte):
        """Sets the associate_external_subnet_num_gte of this VirtualPrivateCloudWhereInput.


        :param associate_external_subnet_num_gte: The associate_external_subnet_num_gte of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type associate_external_subnet_num_gte: int
        """

        self._associate_external_subnet_num_gte = associate_external_subnet_num_gte

    @property
    def associate_external_subnet_num_in(self):
        """Gets the associate_external_subnet_num_in of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The associate_external_subnet_num_in of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._associate_external_subnet_num_in

    @associate_external_subnet_num_in.setter
    def associate_external_subnet_num_in(self, associate_external_subnet_num_in):
        """Sets the associate_external_subnet_num_in of this VirtualPrivateCloudWhereInput.


        :param associate_external_subnet_num_in: The associate_external_subnet_num_in of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type associate_external_subnet_num_in: list[int]
        """

        self._associate_external_subnet_num_in = associate_external_subnet_num_in

    @property
    def associate_external_subnet_num_lt(self):
        """Gets the associate_external_subnet_num_lt of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The associate_external_subnet_num_lt of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._associate_external_subnet_num_lt

    @associate_external_subnet_num_lt.setter
    def associate_external_subnet_num_lt(self, associate_external_subnet_num_lt):
        """Sets the associate_external_subnet_num_lt of this VirtualPrivateCloudWhereInput.


        :param associate_external_subnet_num_lt: The associate_external_subnet_num_lt of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type associate_external_subnet_num_lt: int
        """

        self._associate_external_subnet_num_lt = associate_external_subnet_num_lt

    @property
    def associate_external_subnet_num_lte(self):
        """Gets the associate_external_subnet_num_lte of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The associate_external_subnet_num_lte of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._associate_external_subnet_num_lte

    @associate_external_subnet_num_lte.setter
    def associate_external_subnet_num_lte(self, associate_external_subnet_num_lte):
        """Sets the associate_external_subnet_num_lte of this VirtualPrivateCloudWhereInput.


        :param associate_external_subnet_num_lte: The associate_external_subnet_num_lte of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type associate_external_subnet_num_lte: int
        """

        self._associate_external_subnet_num_lte = associate_external_subnet_num_lte

    @property
    def associate_external_subnet_num_not(self):
        """Gets the associate_external_subnet_num_not of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The associate_external_subnet_num_not of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._associate_external_subnet_num_not

    @associate_external_subnet_num_not.setter
    def associate_external_subnet_num_not(self, associate_external_subnet_num_not):
        """Sets the associate_external_subnet_num_not of this VirtualPrivateCloudWhereInput.


        :param associate_external_subnet_num_not: The associate_external_subnet_num_not of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type associate_external_subnet_num_not: int
        """

        self._associate_external_subnet_num_not = associate_external_subnet_num_not

    @property
    def associate_external_subnet_num_not_in(self):
        """Gets the associate_external_subnet_num_not_in of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The associate_external_subnet_num_not_in of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._associate_external_subnet_num_not_in

    @associate_external_subnet_num_not_in.setter
    def associate_external_subnet_num_not_in(self, associate_external_subnet_num_not_in):
        """Sets the associate_external_subnet_num_not_in of this VirtualPrivateCloudWhereInput.


        :param associate_external_subnet_num_not_in: The associate_external_subnet_num_not_in of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type associate_external_subnet_num_not_in: list[int]
        """

        self._associate_external_subnet_num_not_in = associate_external_subnet_num_not_in

    @property
    def description(self):
        """Gets the description of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The description of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this VirtualPrivateCloudWhereInput.


        :param description: The description of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def description_contains(self):
        """Gets the description_contains of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The description_contains of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_contains

    @description_contains.setter
    def description_contains(self, description_contains):
        """Sets the description_contains of this VirtualPrivateCloudWhereInput.


        :param description_contains: The description_contains of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type description_contains: str
        """

        self._description_contains = description_contains

    @property
    def description_ends_with(self):
        """Gets the description_ends_with of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The description_ends_with of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_ends_with

    @description_ends_with.setter
    def description_ends_with(self, description_ends_with):
        """Sets the description_ends_with of this VirtualPrivateCloudWhereInput.


        :param description_ends_with: The description_ends_with of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type description_ends_with: str
        """

        self._description_ends_with = description_ends_with

    @property
    def description_gt(self):
        """Gets the description_gt of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The description_gt of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_gt

    @description_gt.setter
    def description_gt(self, description_gt):
        """Sets the description_gt of this VirtualPrivateCloudWhereInput.


        :param description_gt: The description_gt of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type description_gt: str
        """

        self._description_gt = description_gt

    @property
    def description_gte(self):
        """Gets the description_gte of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The description_gte of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_gte

    @description_gte.setter
    def description_gte(self, description_gte):
        """Sets the description_gte of this VirtualPrivateCloudWhereInput.


        :param description_gte: The description_gte of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type description_gte: str
        """

        self._description_gte = description_gte

    @property
    def description_in(self):
        """Gets the description_in of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The description_in of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._description_in

    @description_in.setter
    def description_in(self, description_in):
        """Sets the description_in of this VirtualPrivateCloudWhereInput.


        :param description_in: The description_in of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type description_in: list[str]
        """

        self._description_in = description_in

    @property
    def description_lt(self):
        """Gets the description_lt of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The description_lt of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_lt

    @description_lt.setter
    def description_lt(self, description_lt):
        """Sets the description_lt of this VirtualPrivateCloudWhereInput.


        :param description_lt: The description_lt of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type description_lt: str
        """

        self._description_lt = description_lt

    @property
    def description_lte(self):
        """Gets the description_lte of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The description_lte of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_lte

    @description_lte.setter
    def description_lte(self, description_lte):
        """Sets the description_lte of this VirtualPrivateCloudWhereInput.


        :param description_lte: The description_lte of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type description_lte: str
        """

        self._description_lte = description_lte

    @property
    def description_not(self):
        """Gets the description_not of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The description_not of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_not

    @description_not.setter
    def description_not(self, description_not):
        """Sets the description_not of this VirtualPrivateCloudWhereInput.


        :param description_not: The description_not of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type description_not: str
        """

        self._description_not = description_not

    @property
    def description_not_contains(self):
        """Gets the description_not_contains of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The description_not_contains of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_not_contains

    @description_not_contains.setter
    def description_not_contains(self, description_not_contains):
        """Sets the description_not_contains of this VirtualPrivateCloudWhereInput.


        :param description_not_contains: The description_not_contains of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type description_not_contains: str
        """

        self._description_not_contains = description_not_contains

    @property
    def description_not_ends_with(self):
        """Gets the description_not_ends_with of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The description_not_ends_with of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_not_ends_with

    @description_not_ends_with.setter
    def description_not_ends_with(self, description_not_ends_with):
        """Sets the description_not_ends_with of this VirtualPrivateCloudWhereInput.


        :param description_not_ends_with: The description_not_ends_with of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type description_not_ends_with: str
        """

        self._description_not_ends_with = description_not_ends_with

    @property
    def description_not_in(self):
        """Gets the description_not_in of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The description_not_in of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._description_not_in

    @description_not_in.setter
    def description_not_in(self, description_not_in):
        """Sets the description_not_in of this VirtualPrivateCloudWhereInput.


        :param description_not_in: The description_not_in of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type description_not_in: list[str]
        """

        self._description_not_in = description_not_in

    @property
    def description_not_starts_with(self):
        """Gets the description_not_starts_with of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The description_not_starts_with of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_not_starts_with

    @description_not_starts_with.setter
    def description_not_starts_with(self, description_not_starts_with):
        """Sets the description_not_starts_with of this VirtualPrivateCloudWhereInput.


        :param description_not_starts_with: The description_not_starts_with of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type description_not_starts_with: str
        """

        self._description_not_starts_with = description_not_starts_with

    @property
    def description_starts_with(self):
        """Gets the description_starts_with of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The description_starts_with of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_starts_with

    @description_starts_with.setter
    def description_starts_with(self, description_starts_with):
        """Sets the description_starts_with of this VirtualPrivateCloudWhereInput.


        :param description_starts_with: The description_starts_with of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type description_starts_with: str
        """

        self._description_starts_with = description_starts_with

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The entity_async_status of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this VirtualPrivateCloudWhereInput.


        :param entity_async_status: The entity_async_status of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def entity_async_status_in(self):
        """Gets the entity_async_status_in of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The entity_async_status_in of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_in

    @entity_async_status_in.setter
    def entity_async_status_in(self, entity_async_status_in):
        """Sets the entity_async_status_in of this VirtualPrivateCloudWhereInput.


        :param entity_async_status_in: The entity_async_status_in of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type entity_async_status_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_in = entity_async_status_in

    @property
    def entity_async_status_not(self):
        """Gets the entity_async_status_not of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The entity_async_status_not of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status_not

    @entity_async_status_not.setter
    def entity_async_status_not(self, entity_async_status_not):
        """Sets the entity_async_status_not of this VirtualPrivateCloudWhereInput.


        :param entity_async_status_not: The entity_async_status_not of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type entity_async_status_not: EntityAsyncStatus
        """

        self._entity_async_status_not = entity_async_status_not

    @property
    def entity_async_status_not_in(self):
        """Gets the entity_async_status_not_in of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The entity_async_status_not_in of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_not_in

    @entity_async_status_not_in.setter
    def entity_async_status_not_in(self, entity_async_status_not_in):
        """Sets the entity_async_status_not_in of this VirtualPrivateCloudWhereInput.


        :param entity_async_status_not_in: The entity_async_status_not_in of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type entity_async_status_not_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_not_in = entity_async_status_not_in

    @property
    def id(self):
        """Gets the id of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The id of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this VirtualPrivateCloudWhereInput.


        :param id: The id of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def id_contains(self):
        """Gets the id_contains of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The id_contains of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_contains

    @id_contains.setter
    def id_contains(self, id_contains):
        """Sets the id_contains of this VirtualPrivateCloudWhereInput.


        :param id_contains: The id_contains of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type id_contains: str
        """

        self._id_contains = id_contains

    @property
    def id_ends_with(self):
        """Gets the id_ends_with of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The id_ends_with of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_ends_with

    @id_ends_with.setter
    def id_ends_with(self, id_ends_with):
        """Sets the id_ends_with of this VirtualPrivateCloudWhereInput.


        :param id_ends_with: The id_ends_with of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type id_ends_with: str
        """

        self._id_ends_with = id_ends_with

    @property
    def id_gt(self):
        """Gets the id_gt of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The id_gt of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gt

    @id_gt.setter
    def id_gt(self, id_gt):
        """Sets the id_gt of this VirtualPrivateCloudWhereInput.


        :param id_gt: The id_gt of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type id_gt: str
        """

        self._id_gt = id_gt

    @property
    def id_gte(self):
        """Gets the id_gte of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The id_gte of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gte

    @id_gte.setter
    def id_gte(self, id_gte):
        """Sets the id_gte of this VirtualPrivateCloudWhereInput.


        :param id_gte: The id_gte of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type id_gte: str
        """

        self._id_gte = id_gte

    @property
    def id_in(self):
        """Gets the id_in of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The id_in of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_in

    @id_in.setter
    def id_in(self, id_in):
        """Sets the id_in of this VirtualPrivateCloudWhereInput.


        :param id_in: The id_in of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type id_in: list[str]
        """

        self._id_in = id_in

    @property
    def id_lt(self):
        """Gets the id_lt of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The id_lt of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lt

    @id_lt.setter
    def id_lt(self, id_lt):
        """Sets the id_lt of this VirtualPrivateCloudWhereInput.


        :param id_lt: The id_lt of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type id_lt: str
        """

        self._id_lt = id_lt

    @property
    def id_lte(self):
        """Gets the id_lte of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The id_lte of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lte

    @id_lte.setter
    def id_lte(self, id_lte):
        """Sets the id_lte of this VirtualPrivateCloudWhereInput.


        :param id_lte: The id_lte of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type id_lte: str
        """

        self._id_lte = id_lte

    @property
    def id_not(self):
        """Gets the id_not of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The id_not of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not

    @id_not.setter
    def id_not(self, id_not):
        """Sets the id_not of this VirtualPrivateCloudWhereInput.


        :param id_not: The id_not of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type id_not: str
        """

        self._id_not = id_not

    @property
    def id_not_contains(self):
        """Gets the id_not_contains of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The id_not_contains of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_contains

    @id_not_contains.setter
    def id_not_contains(self, id_not_contains):
        """Sets the id_not_contains of this VirtualPrivateCloudWhereInput.


        :param id_not_contains: The id_not_contains of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type id_not_contains: str
        """

        self._id_not_contains = id_not_contains

    @property
    def id_not_ends_with(self):
        """Gets the id_not_ends_with of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The id_not_ends_with of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_ends_with

    @id_not_ends_with.setter
    def id_not_ends_with(self, id_not_ends_with):
        """Sets the id_not_ends_with of this VirtualPrivateCloudWhereInput.


        :param id_not_ends_with: The id_not_ends_with of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type id_not_ends_with: str
        """

        self._id_not_ends_with = id_not_ends_with

    @property
    def id_not_in(self):
        """Gets the id_not_in of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The id_not_in of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_not_in

    @id_not_in.setter
    def id_not_in(self, id_not_in):
        """Sets the id_not_in of this VirtualPrivateCloudWhereInput.


        :param id_not_in: The id_not_in of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type id_not_in: list[str]
        """

        self._id_not_in = id_not_in

    @property
    def id_not_starts_with(self):
        """Gets the id_not_starts_with of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The id_not_starts_with of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_starts_with

    @id_not_starts_with.setter
    def id_not_starts_with(self, id_not_starts_with):
        """Sets the id_not_starts_with of this VirtualPrivateCloudWhereInput.


        :param id_not_starts_with: The id_not_starts_with of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type id_not_starts_with: str
        """

        self._id_not_starts_with = id_not_starts_with

    @property
    def id_starts_with(self):
        """Gets the id_starts_with of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The id_starts_with of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_starts_with

    @id_starts_with.setter
    def id_starts_with(self, id_starts_with):
        """Sets the id_starts_with of this VirtualPrivateCloudWhereInput.


        :param id_starts_with: The id_starts_with of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type id_starts_with: str
        """

        self._id_starts_with = id_starts_with

    @property
    def isolation_policies_every(self):
        """Gets the isolation_policies_every of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The isolation_policies_every of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: VirtualPrivateCloudIsolationPolicyWhereInput
        """
        return self._isolation_policies_every

    @isolation_policies_every.setter
    def isolation_policies_every(self, isolation_policies_every):
        """Sets the isolation_policies_every of this VirtualPrivateCloudWhereInput.


        :param isolation_policies_every: The isolation_policies_every of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type isolation_policies_every: VirtualPrivateCloudIsolationPolicyWhereInput
        """

        self._isolation_policies_every = isolation_policies_every

    @property
    def isolation_policies_none(self):
        """Gets the isolation_policies_none of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The isolation_policies_none of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: VirtualPrivateCloudIsolationPolicyWhereInput
        """
        return self._isolation_policies_none

    @isolation_policies_none.setter
    def isolation_policies_none(self, isolation_policies_none):
        """Sets the isolation_policies_none of this VirtualPrivateCloudWhereInput.


        :param isolation_policies_none: The isolation_policies_none of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type isolation_policies_none: VirtualPrivateCloudIsolationPolicyWhereInput
        """

        self._isolation_policies_none = isolation_policies_none

    @property
    def isolation_policies_some(self):
        """Gets the isolation_policies_some of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The isolation_policies_some of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: VirtualPrivateCloudIsolationPolicyWhereInput
        """
        return self._isolation_policies_some

    @isolation_policies_some.setter
    def isolation_policies_some(self, isolation_policies_some):
        """Sets the isolation_policies_some of this VirtualPrivateCloudWhereInput.


        :param isolation_policies_some: The isolation_policies_some of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type isolation_policies_some: VirtualPrivateCloudIsolationPolicyWhereInput
        """

        self._isolation_policies_some = isolation_policies_some

    @property
    def local_id(self):
        """Gets the local_id of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The local_id of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id):
        """Sets the local_id of this VirtualPrivateCloudWhereInput.


        :param local_id: The local_id of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type local_id: str
        """

        self._local_id = local_id

    @property
    def local_id_contains(self):
        """Gets the local_id_contains of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The local_id_contains of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_contains

    @local_id_contains.setter
    def local_id_contains(self, local_id_contains):
        """Sets the local_id_contains of this VirtualPrivateCloudWhereInput.


        :param local_id_contains: The local_id_contains of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type local_id_contains: str
        """

        self._local_id_contains = local_id_contains

    @property
    def local_id_ends_with(self):
        """Gets the local_id_ends_with of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The local_id_ends_with of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_ends_with

    @local_id_ends_with.setter
    def local_id_ends_with(self, local_id_ends_with):
        """Sets the local_id_ends_with of this VirtualPrivateCloudWhereInput.


        :param local_id_ends_with: The local_id_ends_with of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type local_id_ends_with: str
        """

        self._local_id_ends_with = local_id_ends_with

    @property
    def local_id_gt(self):
        """Gets the local_id_gt of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The local_id_gt of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_gt

    @local_id_gt.setter
    def local_id_gt(self, local_id_gt):
        """Sets the local_id_gt of this VirtualPrivateCloudWhereInput.


        :param local_id_gt: The local_id_gt of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type local_id_gt: str
        """

        self._local_id_gt = local_id_gt

    @property
    def local_id_gte(self):
        """Gets the local_id_gte of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The local_id_gte of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_gte

    @local_id_gte.setter
    def local_id_gte(self, local_id_gte):
        """Sets the local_id_gte of this VirtualPrivateCloudWhereInput.


        :param local_id_gte: The local_id_gte of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type local_id_gte: str
        """

        self._local_id_gte = local_id_gte

    @property
    def local_id_in(self):
        """Gets the local_id_in of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The local_id_in of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_id_in

    @local_id_in.setter
    def local_id_in(self, local_id_in):
        """Sets the local_id_in of this VirtualPrivateCloudWhereInput.


        :param local_id_in: The local_id_in of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type local_id_in: list[str]
        """

        self._local_id_in = local_id_in

    @property
    def local_id_lt(self):
        """Gets the local_id_lt of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The local_id_lt of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_lt

    @local_id_lt.setter
    def local_id_lt(self, local_id_lt):
        """Sets the local_id_lt of this VirtualPrivateCloudWhereInput.


        :param local_id_lt: The local_id_lt of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type local_id_lt: str
        """

        self._local_id_lt = local_id_lt

    @property
    def local_id_lte(self):
        """Gets the local_id_lte of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The local_id_lte of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_lte

    @local_id_lte.setter
    def local_id_lte(self, local_id_lte):
        """Sets the local_id_lte of this VirtualPrivateCloudWhereInput.


        :param local_id_lte: The local_id_lte of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type local_id_lte: str
        """

        self._local_id_lte = local_id_lte

    @property
    def local_id_not(self):
        """Gets the local_id_not of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The local_id_not of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not

    @local_id_not.setter
    def local_id_not(self, local_id_not):
        """Sets the local_id_not of this VirtualPrivateCloudWhereInput.


        :param local_id_not: The local_id_not of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type local_id_not: str
        """

        self._local_id_not = local_id_not

    @property
    def local_id_not_contains(self):
        """Gets the local_id_not_contains of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The local_id_not_contains of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_contains

    @local_id_not_contains.setter
    def local_id_not_contains(self, local_id_not_contains):
        """Sets the local_id_not_contains of this VirtualPrivateCloudWhereInput.


        :param local_id_not_contains: The local_id_not_contains of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type local_id_not_contains: str
        """

        self._local_id_not_contains = local_id_not_contains

    @property
    def local_id_not_ends_with(self):
        """Gets the local_id_not_ends_with of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The local_id_not_ends_with of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_ends_with

    @local_id_not_ends_with.setter
    def local_id_not_ends_with(self, local_id_not_ends_with):
        """Sets the local_id_not_ends_with of this VirtualPrivateCloudWhereInput.


        :param local_id_not_ends_with: The local_id_not_ends_with of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type local_id_not_ends_with: str
        """

        self._local_id_not_ends_with = local_id_not_ends_with

    @property
    def local_id_not_in(self):
        """Gets the local_id_not_in of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The local_id_not_in of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_id_not_in

    @local_id_not_in.setter
    def local_id_not_in(self, local_id_not_in):
        """Sets the local_id_not_in of this VirtualPrivateCloudWhereInput.


        :param local_id_not_in: The local_id_not_in of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type local_id_not_in: list[str]
        """

        self._local_id_not_in = local_id_not_in

    @property
    def local_id_not_starts_with(self):
        """Gets the local_id_not_starts_with of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The local_id_not_starts_with of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_starts_with

    @local_id_not_starts_with.setter
    def local_id_not_starts_with(self, local_id_not_starts_with):
        """Sets the local_id_not_starts_with of this VirtualPrivateCloudWhereInput.


        :param local_id_not_starts_with: The local_id_not_starts_with of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type local_id_not_starts_with: str
        """

        self._local_id_not_starts_with = local_id_not_starts_with

    @property
    def local_id_starts_with(self):
        """Gets the local_id_starts_with of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The local_id_starts_with of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_starts_with

    @local_id_starts_with.setter
    def local_id_starts_with(self, local_id_starts_with):
        """Sets the local_id_starts_with of this VirtualPrivateCloudWhereInput.


        :param local_id_starts_with: The local_id_starts_with of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type local_id_starts_with: str
        """

        self._local_id_starts_with = local_id_starts_with

    @property
    def mtu(self):
        """Gets the mtu of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The mtu of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._mtu

    @mtu.setter
    def mtu(self, mtu):
        """Sets the mtu of this VirtualPrivateCloudWhereInput.


        :param mtu: The mtu of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type mtu: int
        """

        self._mtu = mtu

    @property
    def mtu_gt(self):
        """Gets the mtu_gt of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The mtu_gt of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._mtu_gt

    @mtu_gt.setter
    def mtu_gt(self, mtu_gt):
        """Sets the mtu_gt of this VirtualPrivateCloudWhereInput.


        :param mtu_gt: The mtu_gt of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type mtu_gt: int
        """

        self._mtu_gt = mtu_gt

    @property
    def mtu_gte(self):
        """Gets the mtu_gte of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The mtu_gte of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._mtu_gte

    @mtu_gte.setter
    def mtu_gte(self, mtu_gte):
        """Sets the mtu_gte of this VirtualPrivateCloudWhereInput.


        :param mtu_gte: The mtu_gte of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type mtu_gte: int
        """

        self._mtu_gte = mtu_gte

    @property
    def mtu_in(self):
        """Gets the mtu_in of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The mtu_in of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._mtu_in

    @mtu_in.setter
    def mtu_in(self, mtu_in):
        """Sets the mtu_in of this VirtualPrivateCloudWhereInput.


        :param mtu_in: The mtu_in of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type mtu_in: list[int]
        """

        self._mtu_in = mtu_in

    @property
    def mtu_lt(self):
        """Gets the mtu_lt of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The mtu_lt of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._mtu_lt

    @mtu_lt.setter
    def mtu_lt(self, mtu_lt):
        """Sets the mtu_lt of this VirtualPrivateCloudWhereInput.


        :param mtu_lt: The mtu_lt of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type mtu_lt: int
        """

        self._mtu_lt = mtu_lt

    @property
    def mtu_lte(self):
        """Gets the mtu_lte of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The mtu_lte of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._mtu_lte

    @mtu_lte.setter
    def mtu_lte(self, mtu_lte):
        """Sets the mtu_lte of this VirtualPrivateCloudWhereInput.


        :param mtu_lte: The mtu_lte of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type mtu_lte: int
        """

        self._mtu_lte = mtu_lte

    @property
    def mtu_not(self):
        """Gets the mtu_not of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The mtu_not of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._mtu_not

    @mtu_not.setter
    def mtu_not(self, mtu_not):
        """Sets the mtu_not of this VirtualPrivateCloudWhereInput.


        :param mtu_not: The mtu_not of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type mtu_not: int
        """

        self._mtu_not = mtu_not

    @property
    def mtu_not_in(self):
        """Gets the mtu_not_in of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The mtu_not_in of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._mtu_not_in

    @mtu_not_in.setter
    def mtu_not_in(self, mtu_not_in):
        """Sets the mtu_not_in of this VirtualPrivateCloudWhereInput.


        :param mtu_not_in: The mtu_not_in of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type mtu_not_in: list[int]
        """

        self._mtu_not_in = mtu_not_in

    @property
    def name(self):
        """Gets the name of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The name of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this VirtualPrivateCloudWhereInput.


        :param name: The name of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def name_contains(self):
        """Gets the name_contains of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The name_contains of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_contains

    @name_contains.setter
    def name_contains(self, name_contains):
        """Sets the name_contains of this VirtualPrivateCloudWhereInput.


        :param name_contains: The name_contains of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type name_contains: str
        """

        self._name_contains = name_contains

    @property
    def name_ends_with(self):
        """Gets the name_ends_with of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The name_ends_with of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_ends_with

    @name_ends_with.setter
    def name_ends_with(self, name_ends_with):
        """Sets the name_ends_with of this VirtualPrivateCloudWhereInput.


        :param name_ends_with: The name_ends_with of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type name_ends_with: str
        """

        self._name_ends_with = name_ends_with

    @property
    def name_gt(self):
        """Gets the name_gt of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The name_gt of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_gt

    @name_gt.setter
    def name_gt(self, name_gt):
        """Sets the name_gt of this VirtualPrivateCloudWhereInput.


        :param name_gt: The name_gt of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type name_gt: str
        """

        self._name_gt = name_gt

    @property
    def name_gte(self):
        """Gets the name_gte of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The name_gte of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_gte

    @name_gte.setter
    def name_gte(self, name_gte):
        """Sets the name_gte of this VirtualPrivateCloudWhereInput.


        :param name_gte: The name_gte of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type name_gte: str
        """

        self._name_gte = name_gte

    @property
    def name_in(self):
        """Gets the name_in of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The name_in of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._name_in

    @name_in.setter
    def name_in(self, name_in):
        """Sets the name_in of this VirtualPrivateCloudWhereInput.


        :param name_in: The name_in of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type name_in: list[str]
        """

        self._name_in = name_in

    @property
    def name_lt(self):
        """Gets the name_lt of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The name_lt of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_lt

    @name_lt.setter
    def name_lt(self, name_lt):
        """Sets the name_lt of this VirtualPrivateCloudWhereInput.


        :param name_lt: The name_lt of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type name_lt: str
        """

        self._name_lt = name_lt

    @property
    def name_lte(self):
        """Gets the name_lte of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The name_lte of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_lte

    @name_lte.setter
    def name_lte(self, name_lte):
        """Sets the name_lte of this VirtualPrivateCloudWhereInput.


        :param name_lte: The name_lte of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type name_lte: str
        """

        self._name_lte = name_lte

    @property
    def name_not(self):
        """Gets the name_not of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The name_not of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not

    @name_not.setter
    def name_not(self, name_not):
        """Sets the name_not of this VirtualPrivateCloudWhereInput.


        :param name_not: The name_not of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type name_not: str
        """

        self._name_not = name_not

    @property
    def name_not_contains(self):
        """Gets the name_not_contains of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The name_not_contains of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_contains

    @name_not_contains.setter
    def name_not_contains(self, name_not_contains):
        """Sets the name_not_contains of this VirtualPrivateCloudWhereInput.


        :param name_not_contains: The name_not_contains of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type name_not_contains: str
        """

        self._name_not_contains = name_not_contains

    @property
    def name_not_ends_with(self):
        """Gets the name_not_ends_with of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The name_not_ends_with of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_ends_with

    @name_not_ends_with.setter
    def name_not_ends_with(self, name_not_ends_with):
        """Sets the name_not_ends_with of this VirtualPrivateCloudWhereInput.


        :param name_not_ends_with: The name_not_ends_with of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type name_not_ends_with: str
        """

        self._name_not_ends_with = name_not_ends_with

    @property
    def name_not_in(self):
        """Gets the name_not_in of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The name_not_in of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._name_not_in

    @name_not_in.setter
    def name_not_in(self, name_not_in):
        """Sets the name_not_in of this VirtualPrivateCloudWhereInput.


        :param name_not_in: The name_not_in of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type name_not_in: list[str]
        """

        self._name_not_in = name_not_in

    @property
    def name_not_starts_with(self):
        """Gets the name_not_starts_with of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The name_not_starts_with of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_starts_with

    @name_not_starts_with.setter
    def name_not_starts_with(self, name_not_starts_with):
        """Sets the name_not_starts_with of this VirtualPrivateCloudWhereInput.


        :param name_not_starts_with: The name_not_starts_with of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type name_not_starts_with: str
        """

        self._name_not_starts_with = name_not_starts_with

    @property
    def name_starts_with(self):
        """Gets the name_starts_with of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The name_starts_with of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_starts_with

    @name_starts_with.setter
    def name_starts_with(self, name_starts_with):
        """Sets the name_starts_with of this VirtualPrivateCloudWhereInput.


        :param name_starts_with: The name_starts_with of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type name_starts_with: str
        """

        self._name_starts_with = name_starts_with

    @property
    def route_tables_every(self):
        """Gets the route_tables_every of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The route_tables_every of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: VirtualPrivateCloudRouteTableWhereInput
        """
        return self._route_tables_every

    @route_tables_every.setter
    def route_tables_every(self, route_tables_every):
        """Sets the route_tables_every of this VirtualPrivateCloudWhereInput.


        :param route_tables_every: The route_tables_every of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type route_tables_every: VirtualPrivateCloudRouteTableWhereInput
        """

        self._route_tables_every = route_tables_every

    @property
    def route_tables_none(self):
        """Gets the route_tables_none of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The route_tables_none of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: VirtualPrivateCloudRouteTableWhereInput
        """
        return self._route_tables_none

    @route_tables_none.setter
    def route_tables_none(self, route_tables_none):
        """Sets the route_tables_none of this VirtualPrivateCloudWhereInput.


        :param route_tables_none: The route_tables_none of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type route_tables_none: VirtualPrivateCloudRouteTableWhereInput
        """

        self._route_tables_none = route_tables_none

    @property
    def route_tables_some(self):
        """Gets the route_tables_some of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The route_tables_some of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: VirtualPrivateCloudRouteTableWhereInput
        """
        return self._route_tables_some

    @route_tables_some.setter
    def route_tables_some(self, route_tables_some):
        """Sets the route_tables_some of this VirtualPrivateCloudWhereInput.


        :param route_tables_some: The route_tables_some of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type route_tables_some: VirtualPrivateCloudRouteTableWhereInput
        """

        self._route_tables_some = route_tables_some

    @property
    def security_groups_every(self):
        """Gets the security_groups_every of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The security_groups_every of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: VirtualPrivateCloudSecurityGroupWhereInput
        """
        return self._security_groups_every

    @security_groups_every.setter
    def security_groups_every(self, security_groups_every):
        """Sets the security_groups_every of this VirtualPrivateCloudWhereInput.


        :param security_groups_every: The security_groups_every of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type security_groups_every: VirtualPrivateCloudSecurityGroupWhereInput
        """

        self._security_groups_every = security_groups_every

    @property
    def security_groups_none(self):
        """Gets the security_groups_none of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The security_groups_none of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: VirtualPrivateCloudSecurityGroupWhereInput
        """
        return self._security_groups_none

    @security_groups_none.setter
    def security_groups_none(self, security_groups_none):
        """Sets the security_groups_none of this VirtualPrivateCloudWhereInput.


        :param security_groups_none: The security_groups_none of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type security_groups_none: VirtualPrivateCloudSecurityGroupWhereInput
        """

        self._security_groups_none = security_groups_none

    @property
    def security_groups_some(self):
        """Gets the security_groups_some of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The security_groups_some of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: VirtualPrivateCloudSecurityGroupWhereInput
        """
        return self._security_groups_some

    @security_groups_some.setter
    def security_groups_some(self, security_groups_some):
        """Sets the security_groups_some of this VirtualPrivateCloudWhereInput.


        :param security_groups_some: The security_groups_some of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type security_groups_some: VirtualPrivateCloudSecurityGroupWhereInput
        """

        self._security_groups_some = security_groups_some

    @property
    def security_policies_every(self):
        """Gets the security_policies_every of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The security_policies_every of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: VirtualPrivateCloudSecurityPolicyWhereInput
        """
        return self._security_policies_every

    @security_policies_every.setter
    def security_policies_every(self, security_policies_every):
        """Sets the security_policies_every of this VirtualPrivateCloudWhereInput.


        :param security_policies_every: The security_policies_every of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type security_policies_every: VirtualPrivateCloudSecurityPolicyWhereInput
        """

        self._security_policies_every = security_policies_every

    @property
    def security_policies_none(self):
        """Gets the security_policies_none of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The security_policies_none of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: VirtualPrivateCloudSecurityPolicyWhereInput
        """
        return self._security_policies_none

    @security_policies_none.setter
    def security_policies_none(self, security_policies_none):
        """Sets the security_policies_none of this VirtualPrivateCloudWhereInput.


        :param security_policies_none: The security_policies_none of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type security_policies_none: VirtualPrivateCloudSecurityPolicyWhereInput
        """

        self._security_policies_none = security_policies_none

    @property
    def security_policies_some(self):
        """Gets the security_policies_some of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The security_policies_some of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: VirtualPrivateCloudSecurityPolicyWhereInput
        """
        return self._security_policies_some

    @security_policies_some.setter
    def security_policies_some(self, security_policies_some):
        """Sets the security_policies_some of this VirtualPrivateCloudWhereInput.


        :param security_policies_some: The security_policies_some of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type security_policies_some: VirtualPrivateCloudSecurityPolicyWhereInput
        """

        self._security_policies_some = security_policies_some

    @property
    def subnets_every(self):
        """Gets the subnets_every of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The subnets_every of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: VirtualPrivateCloudSubnetWhereInput
        """
        return self._subnets_every

    @subnets_every.setter
    def subnets_every(self, subnets_every):
        """Sets the subnets_every of this VirtualPrivateCloudWhereInput.


        :param subnets_every: The subnets_every of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type subnets_every: VirtualPrivateCloudSubnetWhereInput
        """

        self._subnets_every = subnets_every

    @property
    def subnets_none(self):
        """Gets the subnets_none of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The subnets_none of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: VirtualPrivateCloudSubnetWhereInput
        """
        return self._subnets_none

    @subnets_none.setter
    def subnets_none(self, subnets_none):
        """Sets the subnets_none of this VirtualPrivateCloudWhereInput.


        :param subnets_none: The subnets_none of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type subnets_none: VirtualPrivateCloudSubnetWhereInput
        """

        self._subnets_none = subnets_none

    @property
    def subnets_some(self):
        """Gets the subnets_some of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The subnets_some of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: VirtualPrivateCloudSubnetWhereInput
        """
        return self._subnets_some

    @subnets_some.setter
    def subnets_some(self, subnets_some):
        """Sets the subnets_some of this VirtualPrivateCloudWhereInput.


        :param subnets_some: The subnets_some of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type subnets_some: VirtualPrivateCloudSubnetWhereInput
        """

        self._subnets_some = subnets_some

    @property
    def vpc_service(self):
        """Gets the vpc_service of this VirtualPrivateCloudWhereInput.  # noqa: E501


        :return: The vpc_service of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :rtype: VirtualPrivateCloudServiceWhereInput
        """
        return self._vpc_service

    @vpc_service.setter
    def vpc_service(self, vpc_service):
        """Sets the vpc_service of this VirtualPrivateCloudWhereInput.


        :param vpc_service: The vpc_service of this VirtualPrivateCloudWhereInput.  # noqa: E501
        :type vpc_service: VirtualPrivateCloudServiceWhereInput
        """

        self._vpc_service = vpc_service

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VirtualPrivateCloudWhereInput):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VirtualPrivateCloudWhereInput):
            return True

        return self.to_dict() != other.to_dict()
