# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class Vm(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'backup_plans': 'list[NestedBackupPlan]',
        'bios_uuid': 'str',
        'clock_offset': 'VmClockOffset',
        'cloud_init_supported': 'bool',
        'cluster': 'NestedCluster',
        'cpu': 'NestedCpu',
        'cpu_model': 'str',
        'cpu_usage': 'float',
        'deleted_at': 'str',
        'description': 'str',
        'dns_servers': 'str',
        'entity_async_status': 'EntityAsyncStatus',
        'entity_filter_results': 'list[NestedVmEntityFilterResult]',
        'firmware': 'VmFirmware',
        'folder': 'NestedVmFolder',
        'gpu_devices': 'list[NestedGpuDevice]',
        'guest_cpu_model': 'str',
        'guest_os_type': 'VmGuestsOperationSystem',
        'guest_size_usage': 'float',
        'guest_used_size': 'int',
        'ha': 'bool',
        'ha_priority': 'VmHaPriority',
        'host': 'NestedHost',
        'hostname': 'str',
        'id': 'str',
        'in_recycle_bin': 'bool',
        'internal': 'bool',
        'io_policy': 'VmDiskIoPolicy',
        'ips': 'str',
        'isolation_policy': 'NestedIsolationPolicy',
        'kernel_info': 'str',
        'labels': 'list[NestedLabel]',
        'last_shutdown_time': 'str',
        'local_created_at': 'str',
        'local_id': 'str',
        'logical_size_bytes': 'int',
        'max_bandwidth': 'int',
        'max_bandwidth_policy': 'VmDiskIoRestrictType',
        'max_iops': 'int',
        'max_iops_policy': 'VmDiskIoRestrictType',
        'memory': 'int',
        'memory_usage': 'float',
        'name': 'str',
        'nested_virtualization': 'bool',
        'node_ip': 'str',
        'original_name': 'str',
        'os': 'str',
        'out_uninstall_usb': 'list[str]',
        'pci_nics': 'list[NestedNic]',
        'protected': 'bool',
        'provisioned_size': 'int',
        'size': 'int',
        'snapshot_plan': 'NestedSnapshotPlan',
        'snapshots': 'list[NestedVmSnapshot]',
        'status': 'VmStatus',
        'unique_logical_size': 'float',
        'unique_size': 'int',
        'usb_devices': 'list[NestedUsbDevice]',
        'used_size': 'int',
        'used_size_usage': 'float',
        'vcpu': 'int',
        'video_type': 'VmVideoType',
        'vm_disks': 'list[NestedVmDisk]',
        'vm_nics': 'list[NestedVmNic]',
        'vm_placement_group': 'list[NestedVmPlacementGroup]',
        'vm_tools_status': 'VmToolsStatus',
        'vm_tools_version': 'str',
        'vm_usage': 'VmUsage',
        'win_opt': 'bool'
    }

    attribute_map = {
        'backup_plans': 'backup_plans',
        'bios_uuid': 'bios_uuid',
        'clock_offset': 'clock_offset',
        'cloud_init_supported': 'cloud_init_supported',
        'cluster': 'cluster',
        'cpu': 'cpu',
        'cpu_model': 'cpu_model',
        'cpu_usage': 'cpu_usage',
        'deleted_at': 'deleted_at',
        'description': 'description',
        'dns_servers': 'dns_servers',
        'entity_async_status': 'entityAsyncStatus',
        'entity_filter_results': 'entity_filter_results',
        'firmware': 'firmware',
        'folder': 'folder',
        'gpu_devices': 'gpu_devices',
        'guest_cpu_model': 'guest_cpu_model',
        'guest_os_type': 'guest_os_type',
        'guest_size_usage': 'guest_size_usage',
        'guest_used_size': 'guest_used_size',
        'ha': 'ha',
        'ha_priority': 'ha_priority',
        'host': 'host',
        'hostname': 'hostname',
        'id': 'id',
        'in_recycle_bin': 'in_recycle_bin',
        'internal': 'internal',
        'io_policy': 'io_policy',
        'ips': 'ips',
        'isolation_policy': 'isolation_policy',
        'kernel_info': 'kernel_info',
        'labels': 'labels',
        'last_shutdown_time': 'last_shutdown_time',
        'local_created_at': 'local_created_at',
        'local_id': 'local_id',
        'logical_size_bytes': 'logical_size_bytes',
        'max_bandwidth': 'max_bandwidth',
        'max_bandwidth_policy': 'max_bandwidth_policy',
        'max_iops': 'max_iops',
        'max_iops_policy': 'max_iops_policy',
        'memory': 'memory',
        'memory_usage': 'memory_usage',
        'name': 'name',
        'nested_virtualization': 'nested_virtualization',
        'node_ip': 'node_ip',
        'original_name': 'original_name',
        'os': 'os',
        'out_uninstall_usb': 'out_uninstall_usb',
        'pci_nics': 'pci_nics',
        'protected': 'protected',
        'provisioned_size': 'provisioned_size',
        'size': 'size',
        'snapshot_plan': 'snapshot_plan',
        'snapshots': 'snapshots',
        'status': 'status',
        'unique_logical_size': 'unique_logical_size',
        'unique_size': 'unique_size',
        'usb_devices': 'usb_devices',
        'used_size': 'used_size',
        'used_size_usage': 'used_size_usage',
        'vcpu': 'vcpu',
        'video_type': 'video_type',
        'vm_disks': 'vm_disks',
        'vm_nics': 'vm_nics',
        'vm_placement_group': 'vm_placement_group',
        'vm_tools_status': 'vm_tools_status',
        'vm_tools_version': 'vm_tools_version',
        'vm_usage': 'vm_usage',
        'win_opt': 'win_opt'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """Vm - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._backup_plans = None
        self._bios_uuid = None
        self._clock_offset = None
        self._cloud_init_supported = None
        self._cluster = None
        self._cpu = None
        self._cpu_model = None
        self._cpu_usage = None
        self._deleted_at = None
        self._description = None
        self._dns_servers = None
        self._entity_async_status = None
        self._entity_filter_results = None
        self._firmware = None
        self._folder = None
        self._gpu_devices = None
        self._guest_cpu_model = None
        self._guest_os_type = None
        self._guest_size_usage = None
        self._guest_used_size = None
        self._ha = None
        self._ha_priority = None
        self._host = None
        self._hostname = None
        self._id = None
        self._in_recycle_bin = None
        self._internal = None
        self._io_policy = None
        self._ips = None
        self._isolation_policy = None
        self._kernel_info = None
        self._labels = None
        self._last_shutdown_time = None
        self._local_created_at = None
        self._local_id = None
        self._logical_size_bytes = None
        self._max_bandwidth = None
        self._max_bandwidth_policy = None
        self._max_iops = None
        self._max_iops_policy = None
        self._memory = None
        self._memory_usage = None
        self._name = None
        self._nested_virtualization = None
        self._node_ip = None
        self._original_name = None
        self._os = None
        self._out_uninstall_usb = None
        self._pci_nics = None
        self._protected = None
        self._provisioned_size = None
        self._size = None
        self._snapshot_plan = None
        self._snapshots = None
        self._status = None
        self._unique_logical_size = None
        self._unique_size = None
        self._usb_devices = None
        self._used_size = None
        self._used_size_usage = None
        self._vcpu = None
        self._video_type = None
        self._vm_disks = None
        self._vm_nics = None
        self._vm_placement_group = None
        self._vm_tools_status = None
        self._vm_tools_version = None
        self._vm_usage = None
        self._win_opt = None
        self.discriminator = None

        self.backup_plans = kwargs.get("backup_plans", None)
        self.bios_uuid = kwargs.get("bios_uuid", None)
        if "clock_offset" in kwargs:
            self.clock_offset = kwargs["clock_offset"]
        self.cloud_init_supported = kwargs.get("cloud_init_supported", None)
        self.cluster = kwargs.get("cluster", None)
        if "cpu" in kwargs:
            self.cpu = kwargs["cpu"]
        if "cpu_model" in kwargs:
            self.cpu_model = kwargs["cpu_model"]
        self.cpu_usage = kwargs.get("cpu_usage", None)
        self.deleted_at = kwargs.get("deleted_at", None)
        if "description" in kwargs:
            self.description = kwargs["description"]
        self.dns_servers = kwargs.get("dns_servers", None)
        self.entity_async_status = kwargs.get("entity_async_status", None)
        self.entity_filter_results = kwargs.get("entity_filter_results", None)
        if "firmware" in kwargs:
            self.firmware = kwargs["firmware"]
        self.folder = kwargs.get("folder", None)
        self.gpu_devices = kwargs.get("gpu_devices", None)
        self.guest_cpu_model = kwargs.get("guest_cpu_model", None)
        self.guest_os_type = kwargs.get("guest_os_type", None)
        self.guest_size_usage = kwargs.get("guest_size_usage", None)
        self.guest_used_size = kwargs.get("guest_used_size", None)
        if "ha" in kwargs:
            self.ha = kwargs["ha"]
        self.ha_priority = kwargs.get("ha_priority", None)
        self.host = kwargs.get("host", None)
        self.hostname = kwargs.get("hostname", None)
        if "id" in kwargs:
            self.id = kwargs["id"]
        if "in_recycle_bin" in kwargs:
            self.in_recycle_bin = kwargs["in_recycle_bin"]
        if "internal" in kwargs:
            self.internal = kwargs["internal"]
        self.io_policy = kwargs.get("io_policy", None)
        if "ips" in kwargs:
            self.ips = kwargs["ips"]
        self.isolation_policy = kwargs.get("isolation_policy", None)
        self.kernel_info = kwargs.get("kernel_info", None)
        self.labels = kwargs.get("labels", None)
        self.last_shutdown_time = kwargs.get("last_shutdown_time", None)
        self.local_created_at = kwargs.get("local_created_at", None)
        if "local_id" in kwargs:
            self.local_id = kwargs["local_id"]
        self.logical_size_bytes = kwargs.get("logical_size_bytes", None)
        self.max_bandwidth = kwargs.get("max_bandwidth", None)
        self.max_bandwidth_policy = kwargs.get("max_bandwidth_policy", None)
        self.max_iops = kwargs.get("max_iops", None)
        self.max_iops_policy = kwargs.get("max_iops_policy", None)
        if "memory" in kwargs:
            self.memory = kwargs["memory"]
        self.memory_usage = kwargs.get("memory_usage", None)
        if "name" in kwargs:
            self.name = kwargs["name"]
        if "nested_virtualization" in kwargs:
            self.nested_virtualization = kwargs["nested_virtualization"]
        if "node_ip" in kwargs:
            self.node_ip = kwargs["node_ip"]
        self.original_name = kwargs.get("original_name", None)
        self.os = kwargs.get("os", None)
        if "out_uninstall_usb" in kwargs:
            self.out_uninstall_usb = kwargs["out_uninstall_usb"]
        self.pci_nics = kwargs.get("pci_nics", None)
        if "protected" in kwargs:
            self.protected = kwargs["protected"]
        self.provisioned_size = kwargs.get("provisioned_size", None)
        self.size = kwargs.get("size", None)
        self.snapshot_plan = kwargs.get("snapshot_plan", None)
        self.snapshots = kwargs.get("snapshots", None)
        if "status" in kwargs:
            self.status = kwargs["status"]
        self.unique_logical_size = kwargs.get("unique_logical_size", None)
        self.unique_size = kwargs.get("unique_size", None)
        self.usb_devices = kwargs.get("usb_devices", None)
        self.used_size = kwargs.get("used_size", None)
        self.used_size_usage = kwargs.get("used_size_usage", None)
        if "vcpu" in kwargs:
            self.vcpu = kwargs["vcpu"]
        self.video_type = kwargs.get("video_type", None)
        self.vm_disks = kwargs.get("vm_disks", None)
        self.vm_nics = kwargs.get("vm_nics", None)
        self.vm_placement_group = kwargs.get("vm_placement_group", None)
        if "vm_tools_status" in kwargs:
            self.vm_tools_status = kwargs["vm_tools_status"]
        self.vm_tools_version = kwargs.get("vm_tools_version", None)
        self.vm_usage = kwargs.get("vm_usage", None)
        if "win_opt" in kwargs:
            self.win_opt = kwargs["win_opt"]

    @property
    def backup_plans(self):
        """Gets the backup_plans of this Vm.  # noqa: E501


        :return: The backup_plans of this Vm.  # noqa: E501
        :rtype: list[NestedBackupPlan]
        """
        return self._backup_plans

    @backup_plans.setter
    def backup_plans(self, backup_plans):
        """Sets the backup_plans of this Vm.


        :param backup_plans: The backup_plans of this Vm.  # noqa: E501
        :type backup_plans: list[NestedBackupPlan]
        """

        self._backup_plans = backup_plans

    @property
    def bios_uuid(self):
        """Gets the bios_uuid of this Vm.  # noqa: E501


        :return: The bios_uuid of this Vm.  # noqa: E501
        :rtype: str
        """
        return self._bios_uuid

    @bios_uuid.setter
    def bios_uuid(self, bios_uuid):
        """Sets the bios_uuid of this Vm.


        :param bios_uuid: The bios_uuid of this Vm.  # noqa: E501
        :type bios_uuid: str
        """

        self._bios_uuid = bios_uuid

    @property
    def clock_offset(self):
        """Gets the clock_offset of this Vm.  # noqa: E501


        :return: The clock_offset of this Vm.  # noqa: E501
        :rtype: VmClockOffset
        """
        return self._clock_offset

    @clock_offset.setter
    def clock_offset(self, clock_offset):
        """Sets the clock_offset of this Vm.


        :param clock_offset: The clock_offset of this Vm.  # noqa: E501
        :type clock_offset: VmClockOffset
        """
        if self.local_vars_configuration.client_side_validation and clock_offset is None:  # noqa: E501
            raise ValueError("Invalid value for `clock_offset`, must not be `None`")  # noqa: E501

        self._clock_offset = clock_offset

    @property
    def cloud_init_supported(self):
        """Gets the cloud_init_supported of this Vm.  # noqa: E501


        :return: The cloud_init_supported of this Vm.  # noqa: E501
        :rtype: bool
        """
        return self._cloud_init_supported

    @cloud_init_supported.setter
    def cloud_init_supported(self, cloud_init_supported):
        """Sets the cloud_init_supported of this Vm.


        :param cloud_init_supported: The cloud_init_supported of this Vm.  # noqa: E501
        :type cloud_init_supported: bool
        """

        self._cloud_init_supported = cloud_init_supported

    @property
    def cluster(self):
        """Gets the cluster of this Vm.  # noqa: E501


        :return: The cluster of this Vm.  # noqa: E501
        :rtype: NestedCluster
        """
        return self._cluster

    @cluster.setter
    def cluster(self, cluster):
        """Sets the cluster of this Vm.


        :param cluster: The cluster of this Vm.  # noqa: E501
        :type cluster: NestedCluster
        """

        self._cluster = cluster

    @property
    def cpu(self):
        """Gets the cpu of this Vm.  # noqa: E501


        :return: The cpu of this Vm.  # noqa: E501
        :rtype: NestedCpu
        """
        return self._cpu

    @cpu.setter
    def cpu(self, cpu):
        """Sets the cpu of this Vm.


        :param cpu: The cpu of this Vm.  # noqa: E501
        :type cpu: NestedCpu
        """
        if self.local_vars_configuration.client_side_validation and cpu is None:  # noqa: E501
            raise ValueError("Invalid value for `cpu`, must not be `None`")  # noqa: E501

        self._cpu = cpu

    @property
    def cpu_model(self):
        """Gets the cpu_model of this Vm.  # noqa: E501


        :return: The cpu_model of this Vm.  # noqa: E501
        :rtype: str
        """
        return self._cpu_model

    @cpu_model.setter
    def cpu_model(self, cpu_model):
        """Sets the cpu_model of this Vm.


        :param cpu_model: The cpu_model of this Vm.  # noqa: E501
        :type cpu_model: str
        """
        if self.local_vars_configuration.client_side_validation and cpu_model is None:  # noqa: E501
            raise ValueError("Invalid value for `cpu_model`, must not be `None`")  # noqa: E501

        self._cpu_model = cpu_model

    @property
    def cpu_usage(self):
        """Gets the cpu_usage of this Vm.  # noqa: E501


        :return: The cpu_usage of this Vm.  # noqa: E501
        :rtype: float
        """
        return self._cpu_usage

    @cpu_usage.setter
    def cpu_usage(self, cpu_usage):
        """Sets the cpu_usage of this Vm.


        :param cpu_usage: The cpu_usage of this Vm.  # noqa: E501
        :type cpu_usage: float
        """

        self._cpu_usage = cpu_usage

    @property
    def deleted_at(self):
        """Gets the deleted_at of this Vm.  # noqa: E501


        :return: The deleted_at of this Vm.  # noqa: E501
        :rtype: str
        """
        return self._deleted_at

    @deleted_at.setter
    def deleted_at(self, deleted_at):
        """Sets the deleted_at of this Vm.


        :param deleted_at: The deleted_at of this Vm.  # noqa: E501
        :type deleted_at: str
        """

        self._deleted_at = deleted_at

    @property
    def description(self):
        """Gets the description of this Vm.  # noqa: E501


        :return: The description of this Vm.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Vm.


        :param description: The description of this Vm.  # noqa: E501
        :type description: str
        """
        if self.local_vars_configuration.client_side_validation and description is None:  # noqa: E501
            raise ValueError("Invalid value for `description`, must not be `None`")  # noqa: E501

        self._description = description

    @property
    def dns_servers(self):
        """Gets the dns_servers of this Vm.  # noqa: E501


        :return: The dns_servers of this Vm.  # noqa: E501
        :rtype: str
        """
        return self._dns_servers

    @dns_servers.setter
    def dns_servers(self, dns_servers):
        """Sets the dns_servers of this Vm.


        :param dns_servers: The dns_servers of this Vm.  # noqa: E501
        :type dns_servers: str
        """

        self._dns_servers = dns_servers

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this Vm.  # noqa: E501


        :return: The entity_async_status of this Vm.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this Vm.


        :param entity_async_status: The entity_async_status of this Vm.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def entity_filter_results(self):
        """Gets the entity_filter_results of this Vm.  # noqa: E501


        :return: The entity_filter_results of this Vm.  # noqa: E501
        :rtype: list[NestedVmEntityFilterResult]
        """
        return self._entity_filter_results

    @entity_filter_results.setter
    def entity_filter_results(self, entity_filter_results):
        """Sets the entity_filter_results of this Vm.


        :param entity_filter_results: The entity_filter_results of this Vm.  # noqa: E501
        :type entity_filter_results: list[NestedVmEntityFilterResult]
        """

        self._entity_filter_results = entity_filter_results

    @property
    def firmware(self):
        """Gets the firmware of this Vm.  # noqa: E501


        :return: The firmware of this Vm.  # noqa: E501
        :rtype: VmFirmware
        """
        return self._firmware

    @firmware.setter
    def firmware(self, firmware):
        """Sets the firmware of this Vm.


        :param firmware: The firmware of this Vm.  # noqa: E501
        :type firmware: VmFirmware
        """
        if self.local_vars_configuration.client_side_validation and firmware is None:  # noqa: E501
            raise ValueError("Invalid value for `firmware`, must not be `None`")  # noqa: E501

        self._firmware = firmware

    @property
    def folder(self):
        """Gets the folder of this Vm.  # noqa: E501


        :return: The folder of this Vm.  # noqa: E501
        :rtype: NestedVmFolder
        """
        return self._folder

    @folder.setter
    def folder(self, folder):
        """Sets the folder of this Vm.


        :param folder: The folder of this Vm.  # noqa: E501
        :type folder: NestedVmFolder
        """

        self._folder = folder

    @property
    def gpu_devices(self):
        """Gets the gpu_devices of this Vm.  # noqa: E501


        :return: The gpu_devices of this Vm.  # noqa: E501
        :rtype: list[NestedGpuDevice]
        """
        return self._gpu_devices

    @gpu_devices.setter
    def gpu_devices(self, gpu_devices):
        """Sets the gpu_devices of this Vm.


        :param gpu_devices: The gpu_devices of this Vm.  # noqa: E501
        :type gpu_devices: list[NestedGpuDevice]
        """

        self._gpu_devices = gpu_devices

    @property
    def guest_cpu_model(self):
        """Gets the guest_cpu_model of this Vm.  # noqa: E501


        :return: The guest_cpu_model of this Vm.  # noqa: E501
        :rtype: str
        """
        return self._guest_cpu_model

    @guest_cpu_model.setter
    def guest_cpu_model(self, guest_cpu_model):
        """Sets the guest_cpu_model of this Vm.


        :param guest_cpu_model: The guest_cpu_model of this Vm.  # noqa: E501
        :type guest_cpu_model: str
        """

        self._guest_cpu_model = guest_cpu_model

    @property
    def guest_os_type(self):
        """Gets the guest_os_type of this Vm.  # noqa: E501


        :return: The guest_os_type of this Vm.  # noqa: E501
        :rtype: VmGuestsOperationSystem
        """
        return self._guest_os_type

    @guest_os_type.setter
    def guest_os_type(self, guest_os_type):
        """Sets the guest_os_type of this Vm.


        :param guest_os_type: The guest_os_type of this Vm.  # noqa: E501
        :type guest_os_type: VmGuestsOperationSystem
        """

        self._guest_os_type = guest_os_type

    @property
    def guest_size_usage(self):
        """Gets the guest_size_usage of this Vm.  # noqa: E501


        :return: The guest_size_usage of this Vm.  # noqa: E501
        :rtype: float
        """
        return self._guest_size_usage

    @guest_size_usage.setter
    def guest_size_usage(self, guest_size_usage):
        """Sets the guest_size_usage of this Vm.


        :param guest_size_usage: The guest_size_usage of this Vm.  # noqa: E501
        :type guest_size_usage: float
        """

        self._guest_size_usage = guest_size_usage

    @property
    def guest_used_size(self):
        """Gets the guest_used_size of this Vm.  # noqa: E501


        :return: The guest_used_size of this Vm.  # noqa: E501
        :rtype: int
        """
        return self._guest_used_size

    @guest_used_size.setter
    def guest_used_size(self, guest_used_size):
        """Sets the guest_used_size of this Vm.


        :param guest_used_size: The guest_used_size of this Vm.  # noqa: E501
        :type guest_used_size: int
        """

        self._guest_used_size = guest_used_size

    @property
    def ha(self):
        """Gets the ha of this Vm.  # noqa: E501


        :return: The ha of this Vm.  # noqa: E501
        :rtype: bool
        """
        return self._ha

    @ha.setter
    def ha(self, ha):
        """Sets the ha of this Vm.


        :param ha: The ha of this Vm.  # noqa: E501
        :type ha: bool
        """
        if self.local_vars_configuration.client_side_validation and ha is None:  # noqa: E501
            raise ValueError("Invalid value for `ha`, must not be `None`")  # noqa: E501

        self._ha = ha

    @property
    def ha_priority(self):
        """Gets the ha_priority of this Vm.  # noqa: E501


        :return: The ha_priority of this Vm.  # noqa: E501
        :rtype: VmHaPriority
        """
        return self._ha_priority

    @ha_priority.setter
    def ha_priority(self, ha_priority):
        """Sets the ha_priority of this Vm.


        :param ha_priority: The ha_priority of this Vm.  # noqa: E501
        :type ha_priority: VmHaPriority
        """

        self._ha_priority = ha_priority

    @property
    def host(self):
        """Gets the host of this Vm.  # noqa: E501


        :return: The host of this Vm.  # noqa: E501
        :rtype: NestedHost
        """
        return self._host

    @host.setter
    def host(self, host):
        """Sets the host of this Vm.


        :param host: The host of this Vm.  # noqa: E501
        :type host: NestedHost
        """

        self._host = host

    @property
    def hostname(self):
        """Gets the hostname of this Vm.  # noqa: E501


        :return: The hostname of this Vm.  # noqa: E501
        :rtype: str
        """
        return self._hostname

    @hostname.setter
    def hostname(self, hostname):
        """Sets the hostname of this Vm.


        :param hostname: The hostname of this Vm.  # noqa: E501
        :type hostname: str
        """

        self._hostname = hostname

    @property
    def id(self):
        """Gets the id of this Vm.  # noqa: E501


        :return: The id of this Vm.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Vm.


        :param id: The id of this Vm.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def in_recycle_bin(self):
        """Gets the in_recycle_bin of this Vm.  # noqa: E501


        :return: The in_recycle_bin of this Vm.  # noqa: E501
        :rtype: bool
        """
        return self._in_recycle_bin

    @in_recycle_bin.setter
    def in_recycle_bin(self, in_recycle_bin):
        """Sets the in_recycle_bin of this Vm.


        :param in_recycle_bin: The in_recycle_bin of this Vm.  # noqa: E501
        :type in_recycle_bin: bool
        """
        if self.local_vars_configuration.client_side_validation and in_recycle_bin is None:  # noqa: E501
            raise ValueError("Invalid value for `in_recycle_bin`, must not be `None`")  # noqa: E501

        self._in_recycle_bin = in_recycle_bin

    @property
    def internal(self):
        """Gets the internal of this Vm.  # noqa: E501


        :return: The internal of this Vm.  # noqa: E501
        :rtype: bool
        """
        return self._internal

    @internal.setter
    def internal(self, internal):
        """Sets the internal of this Vm.


        :param internal: The internal of this Vm.  # noqa: E501
        :type internal: bool
        """
        if self.local_vars_configuration.client_side_validation and internal is None:  # noqa: E501
            raise ValueError("Invalid value for `internal`, must not be `None`")  # noqa: E501

        self._internal = internal

    @property
    def io_policy(self):
        """Gets the io_policy of this Vm.  # noqa: E501


        :return: The io_policy of this Vm.  # noqa: E501
        :rtype: VmDiskIoPolicy
        """
        return self._io_policy

    @io_policy.setter
    def io_policy(self, io_policy):
        """Sets the io_policy of this Vm.


        :param io_policy: The io_policy of this Vm.  # noqa: E501
        :type io_policy: VmDiskIoPolicy
        """

        self._io_policy = io_policy

    @property
    def ips(self):
        """Gets the ips of this Vm.  # noqa: E501


        :return: The ips of this Vm.  # noqa: E501
        :rtype: str
        """
        return self._ips

    @ips.setter
    def ips(self, ips):
        """Sets the ips of this Vm.


        :param ips: The ips of this Vm.  # noqa: E501
        :type ips: str
        """
        if self.local_vars_configuration.client_side_validation and ips is None:  # noqa: E501
            raise ValueError("Invalid value for `ips`, must not be `None`")  # noqa: E501

        self._ips = ips

    @property
    def isolation_policy(self):
        """Gets the isolation_policy of this Vm.  # noqa: E501


        :return: The isolation_policy of this Vm.  # noqa: E501
        :rtype: NestedIsolationPolicy
        """
        return self._isolation_policy

    @isolation_policy.setter
    def isolation_policy(self, isolation_policy):
        """Sets the isolation_policy of this Vm.


        :param isolation_policy: The isolation_policy of this Vm.  # noqa: E501
        :type isolation_policy: NestedIsolationPolicy
        """

        self._isolation_policy = isolation_policy

    @property
    def kernel_info(self):
        """Gets the kernel_info of this Vm.  # noqa: E501


        :return: The kernel_info of this Vm.  # noqa: E501
        :rtype: str
        """
        return self._kernel_info

    @kernel_info.setter
    def kernel_info(self, kernel_info):
        """Sets the kernel_info of this Vm.


        :param kernel_info: The kernel_info of this Vm.  # noqa: E501
        :type kernel_info: str
        """

        self._kernel_info = kernel_info

    @property
    def labels(self):
        """Gets the labels of this Vm.  # noqa: E501


        :return: The labels of this Vm.  # noqa: E501
        :rtype: list[NestedLabel]
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this Vm.


        :param labels: The labels of this Vm.  # noqa: E501
        :type labels: list[NestedLabel]
        """

        self._labels = labels

    @property
    def last_shutdown_time(self):
        """Gets the last_shutdown_time of this Vm.  # noqa: E501


        :return: The last_shutdown_time of this Vm.  # noqa: E501
        :rtype: str
        """
        return self._last_shutdown_time

    @last_shutdown_time.setter
    def last_shutdown_time(self, last_shutdown_time):
        """Sets the last_shutdown_time of this Vm.


        :param last_shutdown_time: The last_shutdown_time of this Vm.  # noqa: E501
        :type last_shutdown_time: str
        """

        self._last_shutdown_time = last_shutdown_time

    @property
    def local_created_at(self):
        """Gets the local_created_at of this Vm.  # noqa: E501


        :return: The local_created_at of this Vm.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at

    @local_created_at.setter
    def local_created_at(self, local_created_at):
        """Sets the local_created_at of this Vm.


        :param local_created_at: The local_created_at of this Vm.  # noqa: E501
        :type local_created_at: str
        """

        self._local_created_at = local_created_at

    @property
    def local_id(self):
        """Gets the local_id of this Vm.  # noqa: E501


        :return: The local_id of this Vm.  # noqa: E501
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id):
        """Sets the local_id of this Vm.


        :param local_id: The local_id of this Vm.  # noqa: E501
        :type local_id: str
        """
        if self.local_vars_configuration.client_side_validation and local_id is None:  # noqa: E501
            raise ValueError("Invalid value for `local_id`, must not be `None`")  # noqa: E501

        self._local_id = local_id

    @property
    def logical_size_bytes(self):
        """Gets the logical_size_bytes of this Vm.  # noqa: E501


        :return: The logical_size_bytes of this Vm.  # noqa: E501
        :rtype: int
        """
        return self._logical_size_bytes

    @logical_size_bytes.setter
    def logical_size_bytes(self, logical_size_bytes):
        """Sets the logical_size_bytes of this Vm.


        :param logical_size_bytes: The logical_size_bytes of this Vm.  # noqa: E501
        :type logical_size_bytes: int
        """

        self._logical_size_bytes = logical_size_bytes

    @property
    def max_bandwidth(self):
        """Gets the max_bandwidth of this Vm.  # noqa: E501


        :return: The max_bandwidth of this Vm.  # noqa: E501
        :rtype: int
        """
        return self._max_bandwidth

    @max_bandwidth.setter
    def max_bandwidth(self, max_bandwidth):
        """Sets the max_bandwidth of this Vm.


        :param max_bandwidth: The max_bandwidth of this Vm.  # noqa: E501
        :type max_bandwidth: int
        """

        self._max_bandwidth = max_bandwidth

    @property
    def max_bandwidth_policy(self):
        """Gets the max_bandwidth_policy of this Vm.  # noqa: E501


        :return: The max_bandwidth_policy of this Vm.  # noqa: E501
        :rtype: VmDiskIoRestrictType
        """
        return self._max_bandwidth_policy

    @max_bandwidth_policy.setter
    def max_bandwidth_policy(self, max_bandwidth_policy):
        """Sets the max_bandwidth_policy of this Vm.


        :param max_bandwidth_policy: The max_bandwidth_policy of this Vm.  # noqa: E501
        :type max_bandwidth_policy: VmDiskIoRestrictType
        """

        self._max_bandwidth_policy = max_bandwidth_policy

    @property
    def max_iops(self):
        """Gets the max_iops of this Vm.  # noqa: E501


        :return: The max_iops of this Vm.  # noqa: E501
        :rtype: int
        """
        return self._max_iops

    @max_iops.setter
    def max_iops(self, max_iops):
        """Sets the max_iops of this Vm.


        :param max_iops: The max_iops of this Vm.  # noqa: E501
        :type max_iops: int
        """

        self._max_iops = max_iops

    @property
    def max_iops_policy(self):
        """Gets the max_iops_policy of this Vm.  # noqa: E501


        :return: The max_iops_policy of this Vm.  # noqa: E501
        :rtype: VmDiskIoRestrictType
        """
        return self._max_iops_policy

    @max_iops_policy.setter
    def max_iops_policy(self, max_iops_policy):
        """Sets the max_iops_policy of this Vm.


        :param max_iops_policy: The max_iops_policy of this Vm.  # noqa: E501
        :type max_iops_policy: VmDiskIoRestrictType
        """

        self._max_iops_policy = max_iops_policy

    @property
    def memory(self):
        """Gets the memory of this Vm.  # noqa: E501


        :return: The memory of this Vm.  # noqa: E501
        :rtype: int
        """
        return self._memory

    @memory.setter
    def memory(self, memory):
        """Sets the memory of this Vm.


        :param memory: The memory of this Vm.  # noqa: E501
        :type memory: int
        """
        if self.local_vars_configuration.client_side_validation and memory is None:  # noqa: E501
            raise ValueError("Invalid value for `memory`, must not be `None`")  # noqa: E501

        self._memory = memory

    @property
    def memory_usage(self):
        """Gets the memory_usage of this Vm.  # noqa: E501


        :return: The memory_usage of this Vm.  # noqa: E501
        :rtype: float
        """
        return self._memory_usage

    @memory_usage.setter
    def memory_usage(self, memory_usage):
        """Sets the memory_usage of this Vm.


        :param memory_usage: The memory_usage of this Vm.  # noqa: E501
        :type memory_usage: float
        """

        self._memory_usage = memory_usage

    @property
    def name(self):
        """Gets the name of this Vm.  # noqa: E501


        :return: The name of this Vm.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Vm.


        :param name: The name of this Vm.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def nested_virtualization(self):
        """Gets the nested_virtualization of this Vm.  # noqa: E501


        :return: The nested_virtualization of this Vm.  # noqa: E501
        :rtype: bool
        """
        return self._nested_virtualization

    @nested_virtualization.setter
    def nested_virtualization(self, nested_virtualization):
        """Sets the nested_virtualization of this Vm.


        :param nested_virtualization: The nested_virtualization of this Vm.  # noqa: E501
        :type nested_virtualization: bool
        """
        if self.local_vars_configuration.client_side_validation and nested_virtualization is None:  # noqa: E501
            raise ValueError("Invalid value for `nested_virtualization`, must not be `None`")  # noqa: E501

        self._nested_virtualization = nested_virtualization

    @property
    def node_ip(self):
        """Gets the node_ip of this Vm.  # noqa: E501


        :return: The node_ip of this Vm.  # noqa: E501
        :rtype: str
        """
        return self._node_ip

    @node_ip.setter
    def node_ip(self, node_ip):
        """Sets the node_ip of this Vm.


        :param node_ip: The node_ip of this Vm.  # noqa: E501
        :type node_ip: str
        """
        if self.local_vars_configuration.client_side_validation and node_ip is None:  # noqa: E501
            raise ValueError("Invalid value for `node_ip`, must not be `None`")  # noqa: E501

        self._node_ip = node_ip

    @property
    def original_name(self):
        """Gets the original_name of this Vm.  # noqa: E501


        :return: The original_name of this Vm.  # noqa: E501
        :rtype: str
        """
        return self._original_name

    @original_name.setter
    def original_name(self, original_name):
        """Sets the original_name of this Vm.


        :param original_name: The original_name of this Vm.  # noqa: E501
        :type original_name: str
        """

        self._original_name = original_name

    @property
    def os(self):
        """Gets the os of this Vm.  # noqa: E501


        :return: The os of this Vm.  # noqa: E501
        :rtype: str
        """
        return self._os

    @os.setter
    def os(self, os):
        """Sets the os of this Vm.


        :param os: The os of this Vm.  # noqa: E501
        :type os: str
        """

        self._os = os

    @property
    def out_uninstall_usb(self):
        """Gets the out_uninstall_usb of this Vm.  # noqa: E501


        :return: The out_uninstall_usb of this Vm.  # noqa: E501
        :rtype: list[str]
        """
        return self._out_uninstall_usb

    @out_uninstall_usb.setter
    def out_uninstall_usb(self, out_uninstall_usb):
        """Sets the out_uninstall_usb of this Vm.


        :param out_uninstall_usb: The out_uninstall_usb of this Vm.  # noqa: E501
        :type out_uninstall_usb: list[str]
        """
        if self.local_vars_configuration.client_side_validation and out_uninstall_usb is None:  # noqa: E501
            raise ValueError("Invalid value for `out_uninstall_usb`, must not be `None`")  # noqa: E501

        self._out_uninstall_usb = out_uninstall_usb

    @property
    def pci_nics(self):
        """Gets the pci_nics of this Vm.  # noqa: E501


        :return: The pci_nics of this Vm.  # noqa: E501
        :rtype: list[NestedNic]
        """
        return self._pci_nics

    @pci_nics.setter
    def pci_nics(self, pci_nics):
        """Sets the pci_nics of this Vm.


        :param pci_nics: The pci_nics of this Vm.  # noqa: E501
        :type pci_nics: list[NestedNic]
        """

        self._pci_nics = pci_nics

    @property
    def protected(self):
        """Gets the protected of this Vm.  # noqa: E501


        :return: The protected of this Vm.  # noqa: E501
        :rtype: bool
        """
        return self._protected

    @protected.setter
    def protected(self, protected):
        """Sets the protected of this Vm.


        :param protected: The protected of this Vm.  # noqa: E501
        :type protected: bool
        """
        if self.local_vars_configuration.client_side_validation and protected is None:  # noqa: E501
            raise ValueError("Invalid value for `protected`, must not be `None`")  # noqa: E501

        self._protected = protected

    @property
    def provisioned_size(self):
        """Gets the provisioned_size of this Vm.  # noqa: E501


        :return: The provisioned_size of this Vm.  # noqa: E501
        :rtype: int
        """
        return self._provisioned_size

    @provisioned_size.setter
    def provisioned_size(self, provisioned_size):
        """Sets the provisioned_size of this Vm.


        :param provisioned_size: The provisioned_size of this Vm.  # noqa: E501
        :type provisioned_size: int
        """

        self._provisioned_size = provisioned_size

    @property
    def size(self):
        """Gets the size of this Vm.  # noqa: E501


        :return: The size of this Vm.  # noqa: E501
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size):
        """Sets the size of this Vm.


        :param size: The size of this Vm.  # noqa: E501
        :type size: int
        """

        self._size = size

    @property
    def snapshot_plan(self):
        """Gets the snapshot_plan of this Vm.  # noqa: E501


        :return: The snapshot_plan of this Vm.  # noqa: E501
        :rtype: NestedSnapshotPlan
        """
        return self._snapshot_plan

    @snapshot_plan.setter
    def snapshot_plan(self, snapshot_plan):
        """Sets the snapshot_plan of this Vm.


        :param snapshot_plan: The snapshot_plan of this Vm.  # noqa: E501
        :type snapshot_plan: NestedSnapshotPlan
        """

        self._snapshot_plan = snapshot_plan

    @property
    def snapshots(self):
        """Gets the snapshots of this Vm.  # noqa: E501


        :return: The snapshots of this Vm.  # noqa: E501
        :rtype: list[NestedVmSnapshot]
        """
        return self._snapshots

    @snapshots.setter
    def snapshots(self, snapshots):
        """Sets the snapshots of this Vm.


        :param snapshots: The snapshots of this Vm.  # noqa: E501
        :type snapshots: list[NestedVmSnapshot]
        """

        self._snapshots = snapshots

    @property
    def status(self):
        """Gets the status of this Vm.  # noqa: E501


        :return: The status of this Vm.  # noqa: E501
        :rtype: VmStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this Vm.


        :param status: The status of this Vm.  # noqa: E501
        :type status: VmStatus
        """
        if self.local_vars_configuration.client_side_validation and status is None:  # noqa: E501
            raise ValueError("Invalid value for `status`, must not be `None`")  # noqa: E501

        self._status = status

    @property
    def unique_logical_size(self):
        """Gets the unique_logical_size of this Vm.  # noqa: E501


        :return: The unique_logical_size of this Vm.  # noqa: E501
        :rtype: float
        """
        return self._unique_logical_size

    @unique_logical_size.setter
    def unique_logical_size(self, unique_logical_size):
        """Sets the unique_logical_size of this Vm.


        :param unique_logical_size: The unique_logical_size of this Vm.  # noqa: E501
        :type unique_logical_size: float
        """

        self._unique_logical_size = unique_logical_size

    @property
    def unique_size(self):
        """Gets the unique_size of this Vm.  # noqa: E501


        :return: The unique_size of this Vm.  # noqa: E501
        :rtype: int
        """
        return self._unique_size

    @unique_size.setter
    def unique_size(self, unique_size):
        """Sets the unique_size of this Vm.


        :param unique_size: The unique_size of this Vm.  # noqa: E501
        :type unique_size: int
        """

        self._unique_size = unique_size

    @property
    def usb_devices(self):
        """Gets the usb_devices of this Vm.  # noqa: E501


        :return: The usb_devices of this Vm.  # noqa: E501
        :rtype: list[NestedUsbDevice]
        """
        return self._usb_devices

    @usb_devices.setter
    def usb_devices(self, usb_devices):
        """Sets the usb_devices of this Vm.


        :param usb_devices: The usb_devices of this Vm.  # noqa: E501
        :type usb_devices: list[NestedUsbDevice]
        """

        self._usb_devices = usb_devices

    @property
    def used_size(self):
        """Gets the used_size of this Vm.  # noqa: E501


        :return: The used_size of this Vm.  # noqa: E501
        :rtype: int
        """
        return self._used_size

    @used_size.setter
    def used_size(self, used_size):
        """Sets the used_size of this Vm.


        :param used_size: The used_size of this Vm.  # noqa: E501
        :type used_size: int
        """

        self._used_size = used_size

    @property
    def used_size_usage(self):
        """Gets the used_size_usage of this Vm.  # noqa: E501


        :return: The used_size_usage of this Vm.  # noqa: E501
        :rtype: float
        """
        return self._used_size_usage

    @used_size_usage.setter
    def used_size_usage(self, used_size_usage):
        """Sets the used_size_usage of this Vm.


        :param used_size_usage: The used_size_usage of this Vm.  # noqa: E501
        :type used_size_usage: float
        """

        self._used_size_usage = used_size_usage

    @property
    def vcpu(self):
        """Gets the vcpu of this Vm.  # noqa: E501


        :return: The vcpu of this Vm.  # noqa: E501
        :rtype: int
        """
        return self._vcpu

    @vcpu.setter
    def vcpu(self, vcpu):
        """Sets the vcpu of this Vm.


        :param vcpu: The vcpu of this Vm.  # noqa: E501
        :type vcpu: int
        """
        if self.local_vars_configuration.client_side_validation and vcpu is None:  # noqa: E501
            raise ValueError("Invalid value for `vcpu`, must not be `None`")  # noqa: E501

        self._vcpu = vcpu

    @property
    def video_type(self):
        """Gets the video_type of this Vm.  # noqa: E501


        :return: The video_type of this Vm.  # noqa: E501
        :rtype: VmVideoType
        """
        return self._video_type

    @video_type.setter
    def video_type(self, video_type):
        """Sets the video_type of this Vm.


        :param video_type: The video_type of this Vm.  # noqa: E501
        :type video_type: VmVideoType
        """

        self._video_type = video_type

    @property
    def vm_disks(self):
        """Gets the vm_disks of this Vm.  # noqa: E501


        :return: The vm_disks of this Vm.  # noqa: E501
        :rtype: list[NestedVmDisk]
        """
        return self._vm_disks

    @vm_disks.setter
    def vm_disks(self, vm_disks):
        """Sets the vm_disks of this Vm.


        :param vm_disks: The vm_disks of this Vm.  # noqa: E501
        :type vm_disks: list[NestedVmDisk]
        """

        self._vm_disks = vm_disks

    @property
    def vm_nics(self):
        """Gets the vm_nics of this Vm.  # noqa: E501


        :return: The vm_nics of this Vm.  # noqa: E501
        :rtype: list[NestedVmNic]
        """
        return self._vm_nics

    @vm_nics.setter
    def vm_nics(self, vm_nics):
        """Sets the vm_nics of this Vm.


        :param vm_nics: The vm_nics of this Vm.  # noqa: E501
        :type vm_nics: list[NestedVmNic]
        """

        self._vm_nics = vm_nics

    @property
    def vm_placement_group(self):
        """Gets the vm_placement_group of this Vm.  # noqa: E501


        :return: The vm_placement_group of this Vm.  # noqa: E501
        :rtype: list[NestedVmPlacementGroup]
        """
        return self._vm_placement_group

    @vm_placement_group.setter
    def vm_placement_group(self, vm_placement_group):
        """Sets the vm_placement_group of this Vm.


        :param vm_placement_group: The vm_placement_group of this Vm.  # noqa: E501
        :type vm_placement_group: list[NestedVmPlacementGroup]
        """

        self._vm_placement_group = vm_placement_group

    @property
    def vm_tools_status(self):
        """Gets the vm_tools_status of this Vm.  # noqa: E501


        :return: The vm_tools_status of this Vm.  # noqa: E501
        :rtype: VmToolsStatus
        """
        return self._vm_tools_status

    @vm_tools_status.setter
    def vm_tools_status(self, vm_tools_status):
        """Sets the vm_tools_status of this Vm.


        :param vm_tools_status: The vm_tools_status of this Vm.  # noqa: E501
        :type vm_tools_status: VmToolsStatus
        """
        if self.local_vars_configuration.client_side_validation and vm_tools_status is None:  # noqa: E501
            raise ValueError("Invalid value for `vm_tools_status`, must not be `None`")  # noqa: E501

        self._vm_tools_status = vm_tools_status

    @property
    def vm_tools_version(self):
        """Gets the vm_tools_version of this Vm.  # noqa: E501


        :return: The vm_tools_version of this Vm.  # noqa: E501
        :rtype: str
        """
        return self._vm_tools_version

    @vm_tools_version.setter
    def vm_tools_version(self, vm_tools_version):
        """Sets the vm_tools_version of this Vm.


        :param vm_tools_version: The vm_tools_version of this Vm.  # noqa: E501
        :type vm_tools_version: str
        """

        self._vm_tools_version = vm_tools_version

    @property
    def vm_usage(self):
        """Gets the vm_usage of this Vm.  # noqa: E501


        :return: The vm_usage of this Vm.  # noqa: E501
        :rtype: VmUsage
        """
        return self._vm_usage

    @vm_usage.setter
    def vm_usage(self, vm_usage):
        """Sets the vm_usage of this Vm.


        :param vm_usage: The vm_usage of this Vm.  # noqa: E501
        :type vm_usage: VmUsage
        """

        self._vm_usage = vm_usage

    @property
    def win_opt(self):
        """Gets the win_opt of this Vm.  # noqa: E501


        :return: The win_opt of this Vm.  # noqa: E501
        :rtype: bool
        """
        return self._win_opt

    @win_opt.setter
    def win_opt(self, win_opt):
        """Sets the win_opt of this Vm.


        :param win_opt: The win_opt of this Vm.  # noqa: E501
        :type win_opt: bool
        """
        if self.local_vars_configuration.client_side_validation and win_opt is None:  # noqa: E501
            raise ValueError("Invalid value for `win_opt`, must not be `None`")  # noqa: E501

        self._win_opt = win_opt

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Vm):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Vm):
            return True

        return self.to_dict() != other.to_dict()
