# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class VmDiskMetaData(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'vm_volume_size': 'float',
        'vm_volume_sharing': 'bool',
        'vm_volume_path': 'str',
        'vm_volume_name': 'str',
        'vm_volume_mounting': 'bool',
        'vm_volume_lun_zbs_volume_id': 'str',
        'vm_volume_elf_storage_policy': 'VmVolumeElfStoragePolicyType',
        'type': 'VmDiskType',
        'max_iops_policy': 'VmDiskIoRestrictType',
        'max_iops': 'int',
        'max_bandwidth_policy': 'VmDiskIoRestrictType',
        'max_bandwidth': 'float',
        'disabled': 'bool',
        'bus': 'Bus',
        'boot': 'int'
    }

    attribute_map = {
        'vm_volume_size': 'vm_volume_size',
        'vm_volume_sharing': 'vm_volume_sharing',
        'vm_volume_path': 'vm_volume_path',
        'vm_volume_name': 'vm_volume_name',
        'vm_volume_mounting': 'vm_volume_mounting',
        'vm_volume_lun_zbs_volume_id': 'vm_volume_lun_zbs_volume_id',
        'vm_volume_elf_storage_policy': 'vm_volume_elf_storage_policy',
        'type': 'type',
        'max_iops_policy': 'max_iops_policy',
        'max_iops': 'max_iops',
        'max_bandwidth_policy': 'max_bandwidth_policy',
        'max_bandwidth': 'max_bandwidth',
        'disabled': 'disabled',
        'bus': 'bus',
        'boot': 'boot'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """VmDiskMetaData - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._vm_volume_size = None
        self._vm_volume_sharing = None
        self._vm_volume_path = None
        self._vm_volume_name = None
        self._vm_volume_mounting = None
        self._vm_volume_lun_zbs_volume_id = None
        self._vm_volume_elf_storage_policy = None
        self._type = None
        self._max_iops_policy = None
        self._max_iops = None
        self._max_bandwidth_policy = None
        self._max_bandwidth = None
        self._disabled = None
        self._bus = None
        self._boot = None
        self.discriminator = None

        self.vm_volume_size = kwargs.get("vm_volume_size", None)
        self.vm_volume_sharing = kwargs.get("vm_volume_sharing", None)
        self.vm_volume_path = kwargs.get("vm_volume_path", None)
        self.vm_volume_name = kwargs.get("vm_volume_name", None)
        self.vm_volume_mounting = kwargs.get("vm_volume_mounting", None)
        self.vm_volume_lun_zbs_volume_id = kwargs.get("vm_volume_lun_zbs_volume_id", None)
        self.vm_volume_elf_storage_policy = kwargs.get("vm_volume_elf_storage_policy", None)
        self.type = kwargs.get("type", None)
        self.max_iops_policy = kwargs.get("max_iops_policy", None)
        self.max_iops = kwargs.get("max_iops", None)
        self.max_bandwidth_policy = kwargs.get("max_bandwidth_policy", None)
        self.max_bandwidth = kwargs.get("max_bandwidth", None)
        self.disabled = kwargs.get("disabled", None)
        self.bus = kwargs.get("bus", None)
        self.boot = kwargs.get("boot", None)

    @property
    def vm_volume_size(self):
        """Gets the vm_volume_size of this VmDiskMetaData.  # noqa: E501


        :return: The vm_volume_size of this VmDiskMetaData.  # noqa: E501
        :rtype: float
        """
        return self._vm_volume_size

    @vm_volume_size.setter
    def vm_volume_size(self, vm_volume_size):
        """Sets the vm_volume_size of this VmDiskMetaData.


        :param vm_volume_size: The vm_volume_size of this VmDiskMetaData.  # noqa: E501
        :type vm_volume_size: float
        """

        self._vm_volume_size = vm_volume_size

    @property
    def vm_volume_sharing(self):
        """Gets the vm_volume_sharing of this VmDiskMetaData.  # noqa: E501


        :return: The vm_volume_sharing of this VmDiskMetaData.  # noqa: E501
        :rtype: bool
        """
        return self._vm_volume_sharing

    @vm_volume_sharing.setter
    def vm_volume_sharing(self, vm_volume_sharing):
        """Sets the vm_volume_sharing of this VmDiskMetaData.


        :param vm_volume_sharing: The vm_volume_sharing of this VmDiskMetaData.  # noqa: E501
        :type vm_volume_sharing: bool
        """

        self._vm_volume_sharing = vm_volume_sharing

    @property
    def vm_volume_path(self):
        """Gets the vm_volume_path of this VmDiskMetaData.  # noqa: E501


        :return: The vm_volume_path of this VmDiskMetaData.  # noqa: E501
        :rtype: str
        """
        return self._vm_volume_path

    @vm_volume_path.setter
    def vm_volume_path(self, vm_volume_path):
        """Sets the vm_volume_path of this VmDiskMetaData.


        :param vm_volume_path: The vm_volume_path of this VmDiskMetaData.  # noqa: E501
        :type vm_volume_path: str
        """

        self._vm_volume_path = vm_volume_path

    @property
    def vm_volume_name(self):
        """Gets the vm_volume_name of this VmDiskMetaData.  # noqa: E501


        :return: The vm_volume_name of this VmDiskMetaData.  # noqa: E501
        :rtype: str
        """
        return self._vm_volume_name

    @vm_volume_name.setter
    def vm_volume_name(self, vm_volume_name):
        """Sets the vm_volume_name of this VmDiskMetaData.


        :param vm_volume_name: The vm_volume_name of this VmDiskMetaData.  # noqa: E501
        :type vm_volume_name: str
        """

        self._vm_volume_name = vm_volume_name

    @property
    def vm_volume_mounting(self):
        """Gets the vm_volume_mounting of this VmDiskMetaData.  # noqa: E501


        :return: The vm_volume_mounting of this VmDiskMetaData.  # noqa: E501
        :rtype: bool
        """
        return self._vm_volume_mounting

    @vm_volume_mounting.setter
    def vm_volume_mounting(self, vm_volume_mounting):
        """Sets the vm_volume_mounting of this VmDiskMetaData.


        :param vm_volume_mounting: The vm_volume_mounting of this VmDiskMetaData.  # noqa: E501
        :type vm_volume_mounting: bool
        """

        self._vm_volume_mounting = vm_volume_mounting

    @property
    def vm_volume_lun_zbs_volume_id(self):
        """Gets the vm_volume_lun_zbs_volume_id of this VmDiskMetaData.  # noqa: E501


        :return: The vm_volume_lun_zbs_volume_id of this VmDiskMetaData.  # noqa: E501
        :rtype: str
        """
        return self._vm_volume_lun_zbs_volume_id

    @vm_volume_lun_zbs_volume_id.setter
    def vm_volume_lun_zbs_volume_id(self, vm_volume_lun_zbs_volume_id):
        """Sets the vm_volume_lun_zbs_volume_id of this VmDiskMetaData.


        :param vm_volume_lun_zbs_volume_id: The vm_volume_lun_zbs_volume_id of this VmDiskMetaData.  # noqa: E501
        :type vm_volume_lun_zbs_volume_id: str
        """

        self._vm_volume_lun_zbs_volume_id = vm_volume_lun_zbs_volume_id

    @property
    def vm_volume_elf_storage_policy(self):
        """Gets the vm_volume_elf_storage_policy of this VmDiskMetaData.  # noqa: E501


        :return: The vm_volume_elf_storage_policy of this VmDiskMetaData.  # noqa: E501
        :rtype: VmVolumeElfStoragePolicyType
        """
        return self._vm_volume_elf_storage_policy

    @vm_volume_elf_storage_policy.setter
    def vm_volume_elf_storage_policy(self, vm_volume_elf_storage_policy):
        """Sets the vm_volume_elf_storage_policy of this VmDiskMetaData.


        :param vm_volume_elf_storage_policy: The vm_volume_elf_storage_policy of this VmDiskMetaData.  # noqa: E501
        :type vm_volume_elf_storage_policy: VmVolumeElfStoragePolicyType
        """

        self._vm_volume_elf_storage_policy = vm_volume_elf_storage_policy

    @property
    def type(self):
        """Gets the type of this VmDiskMetaData.  # noqa: E501


        :return: The type of this VmDiskMetaData.  # noqa: E501
        :rtype: VmDiskType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this VmDiskMetaData.


        :param type: The type of this VmDiskMetaData.  # noqa: E501
        :type type: VmDiskType
        """

        self._type = type

    @property
    def max_iops_policy(self):
        """Gets the max_iops_policy of this VmDiskMetaData.  # noqa: E501


        :return: The max_iops_policy of this VmDiskMetaData.  # noqa: E501
        :rtype: VmDiskIoRestrictType
        """
        return self._max_iops_policy

    @max_iops_policy.setter
    def max_iops_policy(self, max_iops_policy):
        """Sets the max_iops_policy of this VmDiskMetaData.


        :param max_iops_policy: The max_iops_policy of this VmDiskMetaData.  # noqa: E501
        :type max_iops_policy: VmDiskIoRestrictType
        """

        self._max_iops_policy = max_iops_policy

    @property
    def max_iops(self):
        """Gets the max_iops of this VmDiskMetaData.  # noqa: E501


        :return: The max_iops of this VmDiskMetaData.  # noqa: E501
        :rtype: int
        """
        return self._max_iops

    @max_iops.setter
    def max_iops(self, max_iops):
        """Sets the max_iops of this VmDiskMetaData.


        :param max_iops: The max_iops of this VmDiskMetaData.  # noqa: E501
        :type max_iops: int
        """

        self._max_iops = max_iops

    @property
    def max_bandwidth_policy(self):
        """Gets the max_bandwidth_policy of this VmDiskMetaData.  # noqa: E501


        :return: The max_bandwidth_policy of this VmDiskMetaData.  # noqa: E501
        :rtype: VmDiskIoRestrictType
        """
        return self._max_bandwidth_policy

    @max_bandwidth_policy.setter
    def max_bandwidth_policy(self, max_bandwidth_policy):
        """Sets the max_bandwidth_policy of this VmDiskMetaData.


        :param max_bandwidth_policy: The max_bandwidth_policy of this VmDiskMetaData.  # noqa: E501
        :type max_bandwidth_policy: VmDiskIoRestrictType
        """

        self._max_bandwidth_policy = max_bandwidth_policy

    @property
    def max_bandwidth(self):
        """Gets the max_bandwidth of this VmDiskMetaData.  # noqa: E501


        :return: The max_bandwidth of this VmDiskMetaData.  # noqa: E501
        :rtype: float
        """
        return self._max_bandwidth

    @max_bandwidth.setter
    def max_bandwidth(self, max_bandwidth):
        """Sets the max_bandwidth of this VmDiskMetaData.


        :param max_bandwidth: The max_bandwidth of this VmDiskMetaData.  # noqa: E501
        :type max_bandwidth: float
        """

        self._max_bandwidth = max_bandwidth

    @property
    def disabled(self):
        """Gets the disabled of this VmDiskMetaData.  # noqa: E501


        :return: The disabled of this VmDiskMetaData.  # noqa: E501
        :rtype: bool
        """
        return self._disabled

    @disabled.setter
    def disabled(self, disabled):
        """Sets the disabled of this VmDiskMetaData.


        :param disabled: The disabled of this VmDiskMetaData.  # noqa: E501
        :type disabled: bool
        """

        self._disabled = disabled

    @property
    def bus(self):
        """Gets the bus of this VmDiskMetaData.  # noqa: E501


        :return: The bus of this VmDiskMetaData.  # noqa: E501
        :rtype: Bus
        """
        return self._bus

    @bus.setter
    def bus(self, bus):
        """Sets the bus of this VmDiskMetaData.


        :param bus: The bus of this VmDiskMetaData.  # noqa: E501
        :type bus: Bus
        """

        self._bus = bus

    @property
    def boot(self):
        """Gets the boot of this VmDiskMetaData.  # noqa: E501


        :return: The boot of this VmDiskMetaData.  # noqa: E501
        :rtype: int
        """
        return self._boot

    @boot.setter
    def boot(self, boot):
        """Sets the boot of this VmDiskMetaData.


        :param boot: The boot of this VmDiskMetaData.  # noqa: E501
        :type boot: int
        """

        self._boot = boot

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VmDiskMetaData):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VmDiskMetaData):
            return True

        return self.to_dict() != other.to_dict()
