# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class VmExportFile(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'content_library_vm_template': 'NestedContentLibraryVmTemplate',
        'created_at': 'str',
        'damaged': 'bool',
        'data_port_id': 'str',
        'entity_async_status': 'EntityAsyncStatus',
        'files': 'list[VmExportFileFile]',
        'id': 'str',
        'storage_cluster_id': 'str',
        'type': 'VmExportFileType',
        'vm': 'NestedVm',
        'vm_volume': 'NestedVmVolume'
    }

    attribute_map = {
        'content_library_vm_template': 'content_library_vm_template',
        'created_at': 'createdAt',
        'damaged': 'damaged',
        'data_port_id': 'data_port_id',
        'entity_async_status': 'entityAsyncStatus',
        'files': 'files',
        'id': 'id',
        'storage_cluster_id': 'storage_cluster_id',
        'type': 'type',
        'vm': 'vm',
        'vm_volume': 'vm_volume'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """VmExportFile - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._content_library_vm_template = None
        self._created_at = None
        self._damaged = None
        self._data_port_id = None
        self._entity_async_status = None
        self._files = None
        self._id = None
        self._storage_cluster_id = None
        self._type = None
        self._vm = None
        self._vm_volume = None
        self.discriminator = None

        self.content_library_vm_template = kwargs.get("content_library_vm_template", None)
        if "created_at" in kwargs:
            self.created_at = kwargs["created_at"]
        if "damaged" in kwargs:
            self.damaged = kwargs["damaged"]
        if "data_port_id" in kwargs:
            self.data_port_id = kwargs["data_port_id"]
        self.entity_async_status = kwargs.get("entity_async_status", None)
        if "files" in kwargs:
            self.files = kwargs["files"]
        if "id" in kwargs:
            self.id = kwargs["id"]
        if "storage_cluster_id" in kwargs:
            self.storage_cluster_id = kwargs["storage_cluster_id"]
        if "type" in kwargs:
            self.type = kwargs["type"]
        self.vm = kwargs.get("vm", None)
        self.vm_volume = kwargs.get("vm_volume", None)

    @property
    def content_library_vm_template(self):
        """Gets the content_library_vm_template of this VmExportFile.  # noqa: E501


        :return: The content_library_vm_template of this VmExportFile.  # noqa: E501
        :rtype: NestedContentLibraryVmTemplate
        """
        return self._content_library_vm_template

    @content_library_vm_template.setter
    def content_library_vm_template(self, content_library_vm_template):
        """Sets the content_library_vm_template of this VmExportFile.


        :param content_library_vm_template: The content_library_vm_template of this VmExportFile.  # noqa: E501
        :type content_library_vm_template: NestedContentLibraryVmTemplate
        """

        self._content_library_vm_template = content_library_vm_template

    @property
    def created_at(self):
        """Gets the created_at of this VmExportFile.  # noqa: E501


        :return: The created_at of this VmExportFile.  # noqa: E501
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this VmExportFile.


        :param created_at: The created_at of this VmExportFile.  # noqa: E501
        :type created_at: str
        """
        if self.local_vars_configuration.client_side_validation and created_at is None:  # noqa: E501
            raise ValueError("Invalid value for `created_at`, must not be `None`")  # noqa: E501

        self._created_at = created_at

    @property
    def damaged(self):
        """Gets the damaged of this VmExportFile.  # noqa: E501


        :return: The damaged of this VmExportFile.  # noqa: E501
        :rtype: bool
        """
        return self._damaged

    @damaged.setter
    def damaged(self, damaged):
        """Sets the damaged of this VmExportFile.


        :param damaged: The damaged of this VmExportFile.  # noqa: E501
        :type damaged: bool
        """
        if self.local_vars_configuration.client_side_validation and damaged is None:  # noqa: E501
            raise ValueError("Invalid value for `damaged`, must not be `None`")  # noqa: E501

        self._damaged = damaged

    @property
    def data_port_id(self):
        """Gets the data_port_id of this VmExportFile.  # noqa: E501


        :return: The data_port_id of this VmExportFile.  # noqa: E501
        :rtype: str
        """
        return self._data_port_id

    @data_port_id.setter
    def data_port_id(self, data_port_id):
        """Sets the data_port_id of this VmExportFile.


        :param data_port_id: The data_port_id of this VmExportFile.  # noqa: E501
        :type data_port_id: str
        """
        if self.local_vars_configuration.client_side_validation and data_port_id is None:  # noqa: E501
            raise ValueError("Invalid value for `data_port_id`, must not be `None`")  # noqa: E501

        self._data_port_id = data_port_id

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this VmExportFile.  # noqa: E501


        :return: The entity_async_status of this VmExportFile.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this VmExportFile.


        :param entity_async_status: The entity_async_status of this VmExportFile.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def files(self):
        """Gets the files of this VmExportFile.  # noqa: E501


        :return: The files of this VmExportFile.  # noqa: E501
        :rtype: list[VmExportFileFile]
        """
        return self._files

    @files.setter
    def files(self, files):
        """Sets the files of this VmExportFile.


        :param files: The files of this VmExportFile.  # noqa: E501
        :type files: list[VmExportFileFile]
        """
        if self.local_vars_configuration.client_side_validation and files is None:  # noqa: E501
            raise ValueError("Invalid value for `files`, must not be `None`")  # noqa: E501

        self._files = files

    @property
    def id(self):
        """Gets the id of this VmExportFile.  # noqa: E501


        :return: The id of this VmExportFile.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this VmExportFile.


        :param id: The id of this VmExportFile.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def storage_cluster_id(self):
        """Gets the storage_cluster_id of this VmExportFile.  # noqa: E501


        :return: The storage_cluster_id of this VmExportFile.  # noqa: E501
        :rtype: str
        """
        return self._storage_cluster_id

    @storage_cluster_id.setter
    def storage_cluster_id(self, storage_cluster_id):
        """Sets the storage_cluster_id of this VmExportFile.


        :param storage_cluster_id: The storage_cluster_id of this VmExportFile.  # noqa: E501
        :type storage_cluster_id: str
        """
        if self.local_vars_configuration.client_side_validation and storage_cluster_id is None:  # noqa: E501
            raise ValueError("Invalid value for `storage_cluster_id`, must not be `None`")  # noqa: E501

        self._storage_cluster_id = storage_cluster_id

    @property
    def type(self):
        """Gets the type of this VmExportFile.  # noqa: E501


        :return: The type of this VmExportFile.  # noqa: E501
        :rtype: VmExportFileType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this VmExportFile.


        :param type: The type of this VmExportFile.  # noqa: E501
        :type type: VmExportFileType
        """
        if self.local_vars_configuration.client_side_validation and type is None:  # noqa: E501
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501

        self._type = type

    @property
    def vm(self):
        """Gets the vm of this VmExportFile.  # noqa: E501


        :return: The vm of this VmExportFile.  # noqa: E501
        :rtype: NestedVm
        """
        return self._vm

    @vm.setter
    def vm(self, vm):
        """Sets the vm of this VmExportFile.


        :param vm: The vm of this VmExportFile.  # noqa: E501
        :type vm: NestedVm
        """

        self._vm = vm

    @property
    def vm_volume(self):
        """Gets the vm_volume of this VmExportFile.  # noqa: E501


        :return: The vm_volume of this VmExportFile.  # noqa: E501
        :rtype: NestedVmVolume
        """
        return self._vm_volume

    @vm_volume.setter
    def vm_volume(self, vm_volume):
        """Sets the vm_volume of this VmExportFile.


        :param vm_volume: The vm_volume of this VmExportFile.  # noqa: E501
        :type vm_volume: NestedVmVolume
        """

        self._vm_volume = vm_volume

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VmExportFile):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VmExportFile):
            return True

        return self.to_dict() != other.to_dict()
