# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class VmFolder(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'cluster': 'NestedCluster',
        'id': 'str',
        'local_id': 'str',
        'name': 'str',
        'vm_num': 'int',
        'vms': 'list[NestedVm]'
    }

    attribute_map = {
        'cluster': 'cluster',
        'id': 'id',
        'local_id': 'local_id',
        'name': 'name',
        'vm_num': 'vm_num',
        'vms': 'vms'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """VmFolder - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._cluster = None
        self._id = None
        self._local_id = None
        self._name = None
        self._vm_num = None
        self._vms = None
        self.discriminator = None

        if "cluster" in kwargs:
            self.cluster = kwargs["cluster"]
        if "id" in kwargs:
            self.id = kwargs["id"]
        self.local_id = kwargs.get("local_id", None)
        if "name" in kwargs:
            self.name = kwargs["name"]
        self.vm_num = kwargs.get("vm_num", None)
        self.vms = kwargs.get("vms", None)

    @property
    def cluster(self):
        """Gets the cluster of this VmFolder.  # noqa: E501


        :return: The cluster of this VmFolder.  # noqa: E501
        :rtype: NestedCluster
        """
        return self._cluster

    @cluster.setter
    def cluster(self, cluster):
        """Sets the cluster of this VmFolder.


        :param cluster: The cluster of this VmFolder.  # noqa: E501
        :type cluster: NestedCluster
        """
        if self.local_vars_configuration.client_side_validation and cluster is None:  # noqa: E501
            raise ValueError("Invalid value for `cluster`, must not be `None`")  # noqa: E501

        self._cluster = cluster

    @property
    def id(self):
        """Gets the id of this VmFolder.  # noqa: E501


        :return: The id of this VmFolder.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this VmFolder.


        :param id: The id of this VmFolder.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def local_id(self):
        """Gets the local_id of this VmFolder.  # noqa: E501


        :return: The local_id of this VmFolder.  # noqa: E501
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id):
        """Sets the local_id of this VmFolder.


        :param local_id: The local_id of this VmFolder.  # noqa: E501
        :type local_id: str
        """

        self._local_id = local_id

    @property
    def name(self):
        """Gets the name of this VmFolder.  # noqa: E501


        :return: The name of this VmFolder.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this VmFolder.


        :param name: The name of this VmFolder.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def vm_num(self):
        """Gets the vm_num of this VmFolder.  # noqa: E501


        :return: The vm_num of this VmFolder.  # noqa: E501
        :rtype: int
        """
        return self._vm_num

    @vm_num.setter
    def vm_num(self, vm_num):
        """Sets the vm_num of this VmFolder.


        :param vm_num: The vm_num of this VmFolder.  # noqa: E501
        :type vm_num: int
        """

        self._vm_num = vm_num

    @property
    def vms(self):
        """Gets the vms of this VmFolder.  # noqa: E501


        :return: The vms of this VmFolder.  # noqa: E501
        :rtype: list[NestedVm]
        """
        return self._vms

    @vms.setter
    def vms(self, vms):
        """Sets the vms of this VmFolder.


        :param vms: The vms of this VmFolder.  # noqa: E501
        :type vms: list[NestedVm]
        """

        self._vms = vms

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VmFolder):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VmFolder):
            return True

        return self.to_dict() != other.to_dict()
