# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class VmGpuOperationParams(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'amount': 'int',
        'gpu_id': 'str'
    }

    attribute_map = {
        'amount': 'amount',
        'gpu_id': 'gpu_id'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """VmGpuOperationParams - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._amount = None
        self._gpu_id = None
        self.discriminator = None

        if "amount" in kwargs:
            self.amount = kwargs["amount"]
        if "gpu_id" in kwargs:
            self.gpu_id = kwargs["gpu_id"]

    @property
    def amount(self):
        """Gets the amount of this VmGpuOperationParams.  # noqa: E501


        :return: The amount of this VmGpuOperationParams.  # noqa: E501
        :rtype: int
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this VmGpuOperationParams.


        :param amount: The amount of this VmGpuOperationParams.  # noqa: E501
        :type amount: int
        """

        self._amount = amount

    @property
    def gpu_id(self):
        """Gets the gpu_id of this VmGpuOperationParams.  # noqa: E501


        :return: The gpu_id of this VmGpuOperationParams.  # noqa: E501
        :rtype: str
        """
        return self._gpu_id

    @gpu_id.setter
    def gpu_id(self, gpu_id):
        """Sets the gpu_id of this VmGpuOperationParams.


        :param gpu_id: The gpu_id of this VmGpuOperationParams.  # noqa: E501
        :type gpu_id: str
        """
        if self.local_vars_configuration.client_side_validation and gpu_id is None:  # noqa: E501
            raise ValueError("Invalid value for `gpu_id`, must not be `None`")  # noqa: E501

        self._gpu_id = gpu_id

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VmGpuOperationParams):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VmGpuOperationParams):
            return True

        return self.to_dict() != other.to_dict()
