# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class VmMetaData(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'win_opt': 'bool',
        'vm_tools_status': 'VmToolsStatus',
        'vm_nics': 'list[VmNicMetaData]',
        'vm_disks': 'list[VmDiskMetaData]',
        'video_type': 'VmVideoType',
        'vcpu': 'int',
        'sync_vm_time_on_resume': 'bool',
        'protected': 'bool',
        'nested_virtualization': 'bool',
        'name': 'str',
        'memory': 'float',
        'max_iops_policy': 'VmDiskIoRestrictType',
        'max_iops': 'int',
        'max_bandwidth_policy': 'VmDiskIoRestrictType',
        'max_bandwidth': 'float',
        'local_id': 'str',
        'io_policy': 'VmDiskIoPolicy',
        'internal': 'bool',
        'host_local_id': 'str',
        'ha_priority': 'VmHaPriority',
        'ha': 'bool',
        'guest_os_type': 'VmGuestsOperationSystem',
        'firmware': 'VmFirmware',
        'description': 'str',
        'cpu_sockets': 'int',
        'cpu_model': 'str',
        'cpu_exclusive_expected_enabled': 'bool',
        'cpu_cores': 'int',
        'cluster_vhost_enabled': 'bool',
        'cluster_version': 'str',
        'cluster_type': 'ClusterType',
        'cluster_local_id': 'str',
        'cluster_architecture': 'Architecture',
        'clock_offset': 'VmClockOffset',
        'boot_with_host': 'bool'
    }

    attribute_map = {
        'win_opt': 'win_opt',
        'vm_tools_status': 'vm_tools_status',
        'vm_nics': 'vm_nics',
        'vm_disks': 'vm_disks',
        'video_type': 'video_type',
        'vcpu': 'vcpu',
        'sync_vm_time_on_resume': 'sync_vm_time_on_resume',
        'protected': 'protected',
        'nested_virtualization': 'nested_virtualization',
        'name': 'name',
        'memory': 'memory',
        'max_iops_policy': 'max_iops_policy',
        'max_iops': 'max_iops',
        'max_bandwidth_policy': 'max_bandwidth_policy',
        'max_bandwidth': 'max_bandwidth',
        'local_id': 'local_id',
        'io_policy': 'io_policy',
        'internal': 'internal',
        'host_local_id': 'host_local_id',
        'ha_priority': 'ha_priority',
        'ha': 'ha',
        'guest_os_type': 'guest_os_type',
        'firmware': 'firmware',
        'description': 'description',
        'cpu_sockets': 'cpu_sockets',
        'cpu_model': 'cpu_model',
        'cpu_exclusive_expected_enabled': 'cpu_exclusive_expected_enabled',
        'cpu_cores': 'cpu_cores',
        'cluster_vhost_enabled': 'cluster_vhost_enabled',
        'cluster_version': 'cluster_version',
        'cluster_type': 'cluster_type',
        'cluster_local_id': 'cluster_local_id',
        'cluster_architecture': 'cluster_architecture',
        'clock_offset': 'clock_offset',
        'boot_with_host': 'boot_with_host'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """VmMetaData - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._win_opt = None
        self._vm_tools_status = None
        self._vm_nics = None
        self._vm_disks = None
        self._video_type = None
        self._vcpu = None
        self._sync_vm_time_on_resume = None
        self._protected = None
        self._nested_virtualization = None
        self._name = None
        self._memory = None
        self._max_iops_policy = None
        self._max_iops = None
        self._max_bandwidth_policy = None
        self._max_bandwidth = None
        self._local_id = None
        self._io_policy = None
        self._internal = None
        self._host_local_id = None
        self._ha_priority = None
        self._ha = None
        self._guest_os_type = None
        self._firmware = None
        self._description = None
        self._cpu_sockets = None
        self._cpu_model = None
        self._cpu_exclusive_expected_enabled = None
        self._cpu_cores = None
        self._cluster_vhost_enabled = None
        self._cluster_version = None
        self._cluster_type = None
        self._cluster_local_id = None
        self._cluster_architecture = None
        self._clock_offset = None
        self._boot_with_host = None
        self.discriminator = None

        self.win_opt = kwargs.get("win_opt", None)
        self.vm_tools_status = kwargs.get("vm_tools_status", None)
        self.vm_nics = kwargs.get("vm_nics", None)
        self.vm_disks = kwargs.get("vm_disks", None)
        self.video_type = kwargs.get("video_type", None)
        self.vcpu = kwargs.get("vcpu", None)
        self.sync_vm_time_on_resume = kwargs.get("sync_vm_time_on_resume", None)
        self.protected = kwargs.get("protected", None)
        self.nested_virtualization = kwargs.get("nested_virtualization", None)
        self.name = kwargs.get("name", None)
        self.memory = kwargs.get("memory", None)
        self.max_iops_policy = kwargs.get("max_iops_policy", None)
        self.max_iops = kwargs.get("max_iops", None)
        self.max_bandwidth_policy = kwargs.get("max_bandwidth_policy", None)
        self.max_bandwidth = kwargs.get("max_bandwidth", None)
        self.local_id = kwargs.get("local_id", None)
        self.io_policy = kwargs.get("io_policy", None)
        self.internal = kwargs.get("internal", None)
        self.host_local_id = kwargs.get("host_local_id", None)
        self.ha_priority = kwargs.get("ha_priority", None)
        self.ha = kwargs.get("ha", None)
        self.guest_os_type = kwargs.get("guest_os_type", None)
        self.firmware = kwargs.get("firmware", None)
        self.description = kwargs.get("description", None)
        self.cpu_sockets = kwargs.get("cpu_sockets", None)
        self.cpu_model = kwargs.get("cpu_model", None)
        self.cpu_exclusive_expected_enabled = kwargs.get("cpu_exclusive_expected_enabled", None)
        self.cpu_cores = kwargs.get("cpu_cores", None)
        self.cluster_vhost_enabled = kwargs.get("cluster_vhost_enabled", None)
        self.cluster_version = kwargs.get("cluster_version", None)
        self.cluster_type = kwargs.get("cluster_type", None)
        self.cluster_local_id = kwargs.get("cluster_local_id", None)
        self.cluster_architecture = kwargs.get("cluster_architecture", None)
        self.clock_offset = kwargs.get("clock_offset", None)
        self.boot_with_host = kwargs.get("boot_with_host", None)

    @property
    def win_opt(self):
        """Gets the win_opt of this VmMetaData.  # noqa: E501


        :return: The win_opt of this VmMetaData.  # noqa: E501
        :rtype: bool
        """
        return self._win_opt

    @win_opt.setter
    def win_opt(self, win_opt):
        """Sets the win_opt of this VmMetaData.


        :param win_opt: The win_opt of this VmMetaData.  # noqa: E501
        :type win_opt: bool
        """

        self._win_opt = win_opt

    @property
    def vm_tools_status(self):
        """Gets the vm_tools_status of this VmMetaData.  # noqa: E501


        :return: The vm_tools_status of this VmMetaData.  # noqa: E501
        :rtype: VmToolsStatus
        """
        return self._vm_tools_status

    @vm_tools_status.setter
    def vm_tools_status(self, vm_tools_status):
        """Sets the vm_tools_status of this VmMetaData.


        :param vm_tools_status: The vm_tools_status of this VmMetaData.  # noqa: E501
        :type vm_tools_status: VmToolsStatus
        """

        self._vm_tools_status = vm_tools_status

    @property
    def vm_nics(self):
        """Gets the vm_nics of this VmMetaData.  # noqa: E501


        :return: The vm_nics of this VmMetaData.  # noqa: E501
        :rtype: list[VmNicMetaData]
        """
        return self._vm_nics

    @vm_nics.setter
    def vm_nics(self, vm_nics):
        """Sets the vm_nics of this VmMetaData.


        :param vm_nics: The vm_nics of this VmMetaData.  # noqa: E501
        :type vm_nics: list[VmNicMetaData]
        """

        self._vm_nics = vm_nics

    @property
    def vm_disks(self):
        """Gets the vm_disks of this VmMetaData.  # noqa: E501


        :return: The vm_disks of this VmMetaData.  # noqa: E501
        :rtype: list[VmDiskMetaData]
        """
        return self._vm_disks

    @vm_disks.setter
    def vm_disks(self, vm_disks):
        """Sets the vm_disks of this VmMetaData.


        :param vm_disks: The vm_disks of this VmMetaData.  # noqa: E501
        :type vm_disks: list[VmDiskMetaData]
        """

        self._vm_disks = vm_disks

    @property
    def video_type(self):
        """Gets the video_type of this VmMetaData.  # noqa: E501


        :return: The video_type of this VmMetaData.  # noqa: E501
        :rtype: VmVideoType
        """
        return self._video_type

    @video_type.setter
    def video_type(self, video_type):
        """Sets the video_type of this VmMetaData.


        :param video_type: The video_type of this VmMetaData.  # noqa: E501
        :type video_type: VmVideoType
        """

        self._video_type = video_type

    @property
    def vcpu(self):
        """Gets the vcpu of this VmMetaData.  # noqa: E501


        :return: The vcpu of this VmMetaData.  # noqa: E501
        :rtype: int
        """
        return self._vcpu

    @vcpu.setter
    def vcpu(self, vcpu):
        """Sets the vcpu of this VmMetaData.


        :param vcpu: The vcpu of this VmMetaData.  # noqa: E501
        :type vcpu: int
        """

        self._vcpu = vcpu

    @property
    def sync_vm_time_on_resume(self):
        """Gets the sync_vm_time_on_resume of this VmMetaData.  # noqa: E501


        :return: The sync_vm_time_on_resume of this VmMetaData.  # noqa: E501
        :rtype: bool
        """
        return self._sync_vm_time_on_resume

    @sync_vm_time_on_resume.setter
    def sync_vm_time_on_resume(self, sync_vm_time_on_resume):
        """Sets the sync_vm_time_on_resume of this VmMetaData.


        :param sync_vm_time_on_resume: The sync_vm_time_on_resume of this VmMetaData.  # noqa: E501
        :type sync_vm_time_on_resume: bool
        """

        self._sync_vm_time_on_resume = sync_vm_time_on_resume

    @property
    def protected(self):
        """Gets the protected of this VmMetaData.  # noqa: E501


        :return: The protected of this VmMetaData.  # noqa: E501
        :rtype: bool
        """
        return self._protected

    @protected.setter
    def protected(self, protected):
        """Sets the protected of this VmMetaData.


        :param protected: The protected of this VmMetaData.  # noqa: E501
        :type protected: bool
        """

        self._protected = protected

    @property
    def nested_virtualization(self):
        """Gets the nested_virtualization of this VmMetaData.  # noqa: E501


        :return: The nested_virtualization of this VmMetaData.  # noqa: E501
        :rtype: bool
        """
        return self._nested_virtualization

    @nested_virtualization.setter
    def nested_virtualization(self, nested_virtualization):
        """Sets the nested_virtualization of this VmMetaData.


        :param nested_virtualization: The nested_virtualization of this VmMetaData.  # noqa: E501
        :type nested_virtualization: bool
        """

        self._nested_virtualization = nested_virtualization

    @property
    def name(self):
        """Gets the name of this VmMetaData.  # noqa: E501


        :return: The name of this VmMetaData.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this VmMetaData.


        :param name: The name of this VmMetaData.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def memory(self):
        """Gets the memory of this VmMetaData.  # noqa: E501


        :return: The memory of this VmMetaData.  # noqa: E501
        :rtype: float
        """
        return self._memory

    @memory.setter
    def memory(self, memory):
        """Sets the memory of this VmMetaData.


        :param memory: The memory of this VmMetaData.  # noqa: E501
        :type memory: float
        """

        self._memory = memory

    @property
    def max_iops_policy(self):
        """Gets the max_iops_policy of this VmMetaData.  # noqa: E501


        :return: The max_iops_policy of this VmMetaData.  # noqa: E501
        :rtype: VmDiskIoRestrictType
        """
        return self._max_iops_policy

    @max_iops_policy.setter
    def max_iops_policy(self, max_iops_policy):
        """Sets the max_iops_policy of this VmMetaData.


        :param max_iops_policy: The max_iops_policy of this VmMetaData.  # noqa: E501
        :type max_iops_policy: VmDiskIoRestrictType
        """

        self._max_iops_policy = max_iops_policy

    @property
    def max_iops(self):
        """Gets the max_iops of this VmMetaData.  # noqa: E501


        :return: The max_iops of this VmMetaData.  # noqa: E501
        :rtype: int
        """
        return self._max_iops

    @max_iops.setter
    def max_iops(self, max_iops):
        """Sets the max_iops of this VmMetaData.


        :param max_iops: The max_iops of this VmMetaData.  # noqa: E501
        :type max_iops: int
        """

        self._max_iops = max_iops

    @property
    def max_bandwidth_policy(self):
        """Gets the max_bandwidth_policy of this VmMetaData.  # noqa: E501


        :return: The max_bandwidth_policy of this VmMetaData.  # noqa: E501
        :rtype: VmDiskIoRestrictType
        """
        return self._max_bandwidth_policy

    @max_bandwidth_policy.setter
    def max_bandwidth_policy(self, max_bandwidth_policy):
        """Sets the max_bandwidth_policy of this VmMetaData.


        :param max_bandwidth_policy: The max_bandwidth_policy of this VmMetaData.  # noqa: E501
        :type max_bandwidth_policy: VmDiskIoRestrictType
        """

        self._max_bandwidth_policy = max_bandwidth_policy

    @property
    def max_bandwidth(self):
        """Gets the max_bandwidth of this VmMetaData.  # noqa: E501


        :return: The max_bandwidth of this VmMetaData.  # noqa: E501
        :rtype: float
        """
        return self._max_bandwidth

    @max_bandwidth.setter
    def max_bandwidth(self, max_bandwidth):
        """Sets the max_bandwidth of this VmMetaData.


        :param max_bandwidth: The max_bandwidth of this VmMetaData.  # noqa: E501
        :type max_bandwidth: float
        """

        self._max_bandwidth = max_bandwidth

    @property
    def local_id(self):
        """Gets the local_id of this VmMetaData.  # noqa: E501


        :return: The local_id of this VmMetaData.  # noqa: E501
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id):
        """Sets the local_id of this VmMetaData.


        :param local_id: The local_id of this VmMetaData.  # noqa: E501
        :type local_id: str
        """

        self._local_id = local_id

    @property
    def io_policy(self):
        """Gets the io_policy of this VmMetaData.  # noqa: E501


        :return: The io_policy of this VmMetaData.  # noqa: E501
        :rtype: VmDiskIoPolicy
        """
        return self._io_policy

    @io_policy.setter
    def io_policy(self, io_policy):
        """Sets the io_policy of this VmMetaData.


        :param io_policy: The io_policy of this VmMetaData.  # noqa: E501
        :type io_policy: VmDiskIoPolicy
        """

        self._io_policy = io_policy

    @property
    def internal(self):
        """Gets the internal of this VmMetaData.  # noqa: E501


        :return: The internal of this VmMetaData.  # noqa: E501
        :rtype: bool
        """
        return self._internal

    @internal.setter
    def internal(self, internal):
        """Sets the internal of this VmMetaData.


        :param internal: The internal of this VmMetaData.  # noqa: E501
        :type internal: bool
        """

        self._internal = internal

    @property
    def host_local_id(self):
        """Gets the host_local_id of this VmMetaData.  # noqa: E501


        :return: The host_local_id of this VmMetaData.  # noqa: E501
        :rtype: str
        """
        return self._host_local_id

    @host_local_id.setter
    def host_local_id(self, host_local_id):
        """Sets the host_local_id of this VmMetaData.


        :param host_local_id: The host_local_id of this VmMetaData.  # noqa: E501
        :type host_local_id: str
        """

        self._host_local_id = host_local_id

    @property
    def ha_priority(self):
        """Gets the ha_priority of this VmMetaData.  # noqa: E501


        :return: The ha_priority of this VmMetaData.  # noqa: E501
        :rtype: VmHaPriority
        """
        return self._ha_priority

    @ha_priority.setter
    def ha_priority(self, ha_priority):
        """Sets the ha_priority of this VmMetaData.


        :param ha_priority: The ha_priority of this VmMetaData.  # noqa: E501
        :type ha_priority: VmHaPriority
        """

        self._ha_priority = ha_priority

    @property
    def ha(self):
        """Gets the ha of this VmMetaData.  # noqa: E501


        :return: The ha of this VmMetaData.  # noqa: E501
        :rtype: bool
        """
        return self._ha

    @ha.setter
    def ha(self, ha):
        """Sets the ha of this VmMetaData.


        :param ha: The ha of this VmMetaData.  # noqa: E501
        :type ha: bool
        """

        self._ha = ha

    @property
    def guest_os_type(self):
        """Gets the guest_os_type of this VmMetaData.  # noqa: E501


        :return: The guest_os_type of this VmMetaData.  # noqa: E501
        :rtype: VmGuestsOperationSystem
        """
        return self._guest_os_type

    @guest_os_type.setter
    def guest_os_type(self, guest_os_type):
        """Sets the guest_os_type of this VmMetaData.


        :param guest_os_type: The guest_os_type of this VmMetaData.  # noqa: E501
        :type guest_os_type: VmGuestsOperationSystem
        """

        self._guest_os_type = guest_os_type

    @property
    def firmware(self):
        """Gets the firmware of this VmMetaData.  # noqa: E501


        :return: The firmware of this VmMetaData.  # noqa: E501
        :rtype: VmFirmware
        """
        return self._firmware

    @firmware.setter
    def firmware(self, firmware):
        """Sets the firmware of this VmMetaData.


        :param firmware: The firmware of this VmMetaData.  # noqa: E501
        :type firmware: VmFirmware
        """

        self._firmware = firmware

    @property
    def description(self):
        """Gets the description of this VmMetaData.  # noqa: E501


        :return: The description of this VmMetaData.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this VmMetaData.


        :param description: The description of this VmMetaData.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def cpu_sockets(self):
        """Gets the cpu_sockets of this VmMetaData.  # noqa: E501


        :return: The cpu_sockets of this VmMetaData.  # noqa: E501
        :rtype: int
        """
        return self._cpu_sockets

    @cpu_sockets.setter
    def cpu_sockets(self, cpu_sockets):
        """Sets the cpu_sockets of this VmMetaData.


        :param cpu_sockets: The cpu_sockets of this VmMetaData.  # noqa: E501
        :type cpu_sockets: int
        """

        self._cpu_sockets = cpu_sockets

    @property
    def cpu_model(self):
        """Gets the cpu_model of this VmMetaData.  # noqa: E501


        :return: The cpu_model of this VmMetaData.  # noqa: E501
        :rtype: str
        """
        return self._cpu_model

    @cpu_model.setter
    def cpu_model(self, cpu_model):
        """Sets the cpu_model of this VmMetaData.


        :param cpu_model: The cpu_model of this VmMetaData.  # noqa: E501
        :type cpu_model: str
        """

        self._cpu_model = cpu_model

    @property
    def cpu_exclusive_expected_enabled(self):
        """Gets the cpu_exclusive_expected_enabled of this VmMetaData.  # noqa: E501


        :return: The cpu_exclusive_expected_enabled of this VmMetaData.  # noqa: E501
        :rtype: bool
        """
        return self._cpu_exclusive_expected_enabled

    @cpu_exclusive_expected_enabled.setter
    def cpu_exclusive_expected_enabled(self, cpu_exclusive_expected_enabled):
        """Sets the cpu_exclusive_expected_enabled of this VmMetaData.


        :param cpu_exclusive_expected_enabled: The cpu_exclusive_expected_enabled of this VmMetaData.  # noqa: E501
        :type cpu_exclusive_expected_enabled: bool
        """

        self._cpu_exclusive_expected_enabled = cpu_exclusive_expected_enabled

    @property
    def cpu_cores(self):
        """Gets the cpu_cores of this VmMetaData.  # noqa: E501


        :return: The cpu_cores of this VmMetaData.  # noqa: E501
        :rtype: int
        """
        return self._cpu_cores

    @cpu_cores.setter
    def cpu_cores(self, cpu_cores):
        """Sets the cpu_cores of this VmMetaData.


        :param cpu_cores: The cpu_cores of this VmMetaData.  # noqa: E501
        :type cpu_cores: int
        """

        self._cpu_cores = cpu_cores

    @property
    def cluster_vhost_enabled(self):
        """Gets the cluster_vhost_enabled of this VmMetaData.  # noqa: E501


        :return: The cluster_vhost_enabled of this VmMetaData.  # noqa: E501
        :rtype: bool
        """
        return self._cluster_vhost_enabled

    @cluster_vhost_enabled.setter
    def cluster_vhost_enabled(self, cluster_vhost_enabled):
        """Sets the cluster_vhost_enabled of this VmMetaData.


        :param cluster_vhost_enabled: The cluster_vhost_enabled of this VmMetaData.  # noqa: E501
        :type cluster_vhost_enabled: bool
        """

        self._cluster_vhost_enabled = cluster_vhost_enabled

    @property
    def cluster_version(self):
        """Gets the cluster_version of this VmMetaData.  # noqa: E501


        :return: The cluster_version of this VmMetaData.  # noqa: E501
        :rtype: str
        """
        return self._cluster_version

    @cluster_version.setter
    def cluster_version(self, cluster_version):
        """Sets the cluster_version of this VmMetaData.


        :param cluster_version: The cluster_version of this VmMetaData.  # noqa: E501
        :type cluster_version: str
        """

        self._cluster_version = cluster_version

    @property
    def cluster_type(self):
        """Gets the cluster_type of this VmMetaData.  # noqa: E501


        :return: The cluster_type of this VmMetaData.  # noqa: E501
        :rtype: ClusterType
        """
        return self._cluster_type

    @cluster_type.setter
    def cluster_type(self, cluster_type):
        """Sets the cluster_type of this VmMetaData.


        :param cluster_type: The cluster_type of this VmMetaData.  # noqa: E501
        :type cluster_type: ClusterType
        """

        self._cluster_type = cluster_type

    @property
    def cluster_local_id(self):
        """Gets the cluster_local_id of this VmMetaData.  # noqa: E501


        :return: The cluster_local_id of this VmMetaData.  # noqa: E501
        :rtype: str
        """
        return self._cluster_local_id

    @cluster_local_id.setter
    def cluster_local_id(self, cluster_local_id):
        """Sets the cluster_local_id of this VmMetaData.


        :param cluster_local_id: The cluster_local_id of this VmMetaData.  # noqa: E501
        :type cluster_local_id: str
        """

        self._cluster_local_id = cluster_local_id

    @property
    def cluster_architecture(self):
        """Gets the cluster_architecture of this VmMetaData.  # noqa: E501


        :return: The cluster_architecture of this VmMetaData.  # noqa: E501
        :rtype: Architecture
        """
        return self._cluster_architecture

    @cluster_architecture.setter
    def cluster_architecture(self, cluster_architecture):
        """Sets the cluster_architecture of this VmMetaData.


        :param cluster_architecture: The cluster_architecture of this VmMetaData.  # noqa: E501
        :type cluster_architecture: Architecture
        """

        self._cluster_architecture = cluster_architecture

    @property
    def clock_offset(self):
        """Gets the clock_offset of this VmMetaData.  # noqa: E501


        :return: The clock_offset of this VmMetaData.  # noqa: E501
        :rtype: VmClockOffset
        """
        return self._clock_offset

    @clock_offset.setter
    def clock_offset(self, clock_offset):
        """Sets the clock_offset of this VmMetaData.


        :param clock_offset: The clock_offset of this VmMetaData.  # noqa: E501
        :type clock_offset: VmClockOffset
        """

        self._clock_offset = clock_offset

    @property
    def boot_with_host(self):
        """Gets the boot_with_host of this VmMetaData.  # noqa: E501


        :return: The boot_with_host of this VmMetaData.  # noqa: E501
        :rtype: bool
        """
        return self._boot_with_host

    @boot_with_host.setter
    def boot_with_host(self, boot_with_host):
        """Sets the boot_with_host of this VmMetaData.


        :param boot_with_host: The boot_with_host of this VmMetaData.  # noqa: E501
        :type boot_with_host: bool
        """

        self._boot_with_host = boot_with_host

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VmMetaData):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VmMetaData):
            return True

        return self.to_dict() != other.to_dict()
