# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class VmNicMetaData(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'vlan_name': 'str',
        'vlan_mode_type': 'VlanModeType',
        'vlan_local_id': 'str',
        'model': 'str',
        'mirror': 'bool',
        'mac_address': 'str',
        'local_id': 'str',
        'ingress_rate_limit_max_rate_in_bitps': 'float',
        'ingress_rate_limit_enabled': 'bool',
        'ingress_rate_limit_burst_in_bit': 'float',
        'enabled': 'bool',
        'egress_rate_limit_max_rate_in_bitps': 'float',
        'egress_rate_limit_enabled': 'bool',
        'egress_rate_limit_burst_in_bit': 'float'
    }

    attribute_map = {
        'vlan_name': 'vlan_name',
        'vlan_mode_type': 'vlan_mode_type',
        'vlan_local_id': 'vlan_local_id',
        'model': 'model',
        'mirror': 'mirror',
        'mac_address': 'mac_address',
        'local_id': 'local_id',
        'ingress_rate_limit_max_rate_in_bitps': 'ingress_rate_limit_max_rate_in_bitps',
        'ingress_rate_limit_enabled': 'ingress_rate_limit_enabled',
        'ingress_rate_limit_burst_in_bit': 'ingress_rate_limit_burst_in_bit',
        'enabled': 'enabled',
        'egress_rate_limit_max_rate_in_bitps': 'egress_rate_limit_max_rate_in_bitps',
        'egress_rate_limit_enabled': 'egress_rate_limit_enabled',
        'egress_rate_limit_burst_in_bit': 'egress_rate_limit_burst_in_bit'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """VmNicMetaData - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._vlan_name = None
        self._vlan_mode_type = None
        self._vlan_local_id = None
        self._model = None
        self._mirror = None
        self._mac_address = None
        self._local_id = None
        self._ingress_rate_limit_max_rate_in_bitps = None
        self._ingress_rate_limit_enabled = None
        self._ingress_rate_limit_burst_in_bit = None
        self._enabled = None
        self._egress_rate_limit_max_rate_in_bitps = None
        self._egress_rate_limit_enabled = None
        self._egress_rate_limit_burst_in_bit = None
        self.discriminator = None

        self.vlan_name = kwargs.get("vlan_name", None)
        self.vlan_mode_type = kwargs.get("vlan_mode_type", None)
        self.vlan_local_id = kwargs.get("vlan_local_id", None)
        self.model = kwargs.get("model", None)
        self.mirror = kwargs.get("mirror", None)
        self.mac_address = kwargs.get("mac_address", None)
        self.local_id = kwargs.get("local_id", None)
        self.ingress_rate_limit_max_rate_in_bitps = kwargs.get("ingress_rate_limit_max_rate_in_bitps", None)
        self.ingress_rate_limit_enabled = kwargs.get("ingress_rate_limit_enabled", None)
        self.ingress_rate_limit_burst_in_bit = kwargs.get("ingress_rate_limit_burst_in_bit", None)
        self.enabled = kwargs.get("enabled", None)
        self.egress_rate_limit_max_rate_in_bitps = kwargs.get("egress_rate_limit_max_rate_in_bitps", None)
        self.egress_rate_limit_enabled = kwargs.get("egress_rate_limit_enabled", None)
        self.egress_rate_limit_burst_in_bit = kwargs.get("egress_rate_limit_burst_in_bit", None)

    @property
    def vlan_name(self):
        """Gets the vlan_name of this VmNicMetaData.  # noqa: E501


        :return: The vlan_name of this VmNicMetaData.  # noqa: E501
        :rtype: str
        """
        return self._vlan_name

    @vlan_name.setter
    def vlan_name(self, vlan_name):
        """Sets the vlan_name of this VmNicMetaData.


        :param vlan_name: The vlan_name of this VmNicMetaData.  # noqa: E501
        :type vlan_name: str
        """

        self._vlan_name = vlan_name

    @property
    def vlan_mode_type(self):
        """Gets the vlan_mode_type of this VmNicMetaData.  # noqa: E501


        :return: The vlan_mode_type of this VmNicMetaData.  # noqa: E501
        :rtype: VlanModeType
        """
        return self._vlan_mode_type

    @vlan_mode_type.setter
    def vlan_mode_type(self, vlan_mode_type):
        """Sets the vlan_mode_type of this VmNicMetaData.


        :param vlan_mode_type: The vlan_mode_type of this VmNicMetaData.  # noqa: E501
        :type vlan_mode_type: VlanModeType
        """

        self._vlan_mode_type = vlan_mode_type

    @property
    def vlan_local_id(self):
        """Gets the vlan_local_id of this VmNicMetaData.  # noqa: E501


        :return: The vlan_local_id of this VmNicMetaData.  # noqa: E501
        :rtype: str
        """
        return self._vlan_local_id

    @vlan_local_id.setter
    def vlan_local_id(self, vlan_local_id):
        """Sets the vlan_local_id of this VmNicMetaData.


        :param vlan_local_id: The vlan_local_id of this VmNicMetaData.  # noqa: E501
        :type vlan_local_id: str
        """

        self._vlan_local_id = vlan_local_id

    @property
    def model(self):
        """Gets the model of this VmNicMetaData.  # noqa: E501


        :return: The model of this VmNicMetaData.  # noqa: E501
        :rtype: str
        """
        return self._model

    @model.setter
    def model(self, model):
        """Sets the model of this VmNicMetaData.


        :param model: The model of this VmNicMetaData.  # noqa: E501
        :type model: str
        """

        self._model = model

    @property
    def mirror(self):
        """Gets the mirror of this VmNicMetaData.  # noqa: E501


        :return: The mirror of this VmNicMetaData.  # noqa: E501
        :rtype: bool
        """
        return self._mirror

    @mirror.setter
    def mirror(self, mirror):
        """Sets the mirror of this VmNicMetaData.


        :param mirror: The mirror of this VmNicMetaData.  # noqa: E501
        :type mirror: bool
        """

        self._mirror = mirror

    @property
    def mac_address(self):
        """Gets the mac_address of this VmNicMetaData.  # noqa: E501


        :return: The mac_address of this VmNicMetaData.  # noqa: E501
        :rtype: str
        """
        return self._mac_address

    @mac_address.setter
    def mac_address(self, mac_address):
        """Sets the mac_address of this VmNicMetaData.


        :param mac_address: The mac_address of this VmNicMetaData.  # noqa: E501
        :type mac_address: str
        """

        self._mac_address = mac_address

    @property
    def local_id(self):
        """Gets the local_id of this VmNicMetaData.  # noqa: E501


        :return: The local_id of this VmNicMetaData.  # noqa: E501
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id):
        """Sets the local_id of this VmNicMetaData.


        :param local_id: The local_id of this VmNicMetaData.  # noqa: E501
        :type local_id: str
        """

        self._local_id = local_id

    @property
    def ingress_rate_limit_max_rate_in_bitps(self):
        """Gets the ingress_rate_limit_max_rate_in_bitps of this VmNicMetaData.  # noqa: E501


        :return: The ingress_rate_limit_max_rate_in_bitps of this VmNicMetaData.  # noqa: E501
        :rtype: float
        """
        return self._ingress_rate_limit_max_rate_in_bitps

    @ingress_rate_limit_max_rate_in_bitps.setter
    def ingress_rate_limit_max_rate_in_bitps(self, ingress_rate_limit_max_rate_in_bitps):
        """Sets the ingress_rate_limit_max_rate_in_bitps of this VmNicMetaData.


        :param ingress_rate_limit_max_rate_in_bitps: The ingress_rate_limit_max_rate_in_bitps of this VmNicMetaData.  # noqa: E501
        :type ingress_rate_limit_max_rate_in_bitps: float
        """

        self._ingress_rate_limit_max_rate_in_bitps = ingress_rate_limit_max_rate_in_bitps

    @property
    def ingress_rate_limit_enabled(self):
        """Gets the ingress_rate_limit_enabled of this VmNicMetaData.  # noqa: E501


        :return: The ingress_rate_limit_enabled of this VmNicMetaData.  # noqa: E501
        :rtype: bool
        """
        return self._ingress_rate_limit_enabled

    @ingress_rate_limit_enabled.setter
    def ingress_rate_limit_enabled(self, ingress_rate_limit_enabled):
        """Sets the ingress_rate_limit_enabled of this VmNicMetaData.


        :param ingress_rate_limit_enabled: The ingress_rate_limit_enabled of this VmNicMetaData.  # noqa: E501
        :type ingress_rate_limit_enabled: bool
        """

        self._ingress_rate_limit_enabled = ingress_rate_limit_enabled

    @property
    def ingress_rate_limit_burst_in_bit(self):
        """Gets the ingress_rate_limit_burst_in_bit of this VmNicMetaData.  # noqa: E501


        :return: The ingress_rate_limit_burst_in_bit of this VmNicMetaData.  # noqa: E501
        :rtype: float
        """
        return self._ingress_rate_limit_burst_in_bit

    @ingress_rate_limit_burst_in_bit.setter
    def ingress_rate_limit_burst_in_bit(self, ingress_rate_limit_burst_in_bit):
        """Sets the ingress_rate_limit_burst_in_bit of this VmNicMetaData.


        :param ingress_rate_limit_burst_in_bit: The ingress_rate_limit_burst_in_bit of this VmNicMetaData.  # noqa: E501
        :type ingress_rate_limit_burst_in_bit: float
        """

        self._ingress_rate_limit_burst_in_bit = ingress_rate_limit_burst_in_bit

    @property
    def enabled(self):
        """Gets the enabled of this VmNicMetaData.  # noqa: E501


        :return: The enabled of this VmNicMetaData.  # noqa: E501
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """Sets the enabled of this VmNicMetaData.


        :param enabled: The enabled of this VmNicMetaData.  # noqa: E501
        :type enabled: bool
        """

        self._enabled = enabled

    @property
    def egress_rate_limit_max_rate_in_bitps(self):
        """Gets the egress_rate_limit_max_rate_in_bitps of this VmNicMetaData.  # noqa: E501


        :return: The egress_rate_limit_max_rate_in_bitps of this VmNicMetaData.  # noqa: E501
        :rtype: float
        """
        return self._egress_rate_limit_max_rate_in_bitps

    @egress_rate_limit_max_rate_in_bitps.setter
    def egress_rate_limit_max_rate_in_bitps(self, egress_rate_limit_max_rate_in_bitps):
        """Sets the egress_rate_limit_max_rate_in_bitps of this VmNicMetaData.


        :param egress_rate_limit_max_rate_in_bitps: The egress_rate_limit_max_rate_in_bitps of this VmNicMetaData.  # noqa: E501
        :type egress_rate_limit_max_rate_in_bitps: float
        """

        self._egress_rate_limit_max_rate_in_bitps = egress_rate_limit_max_rate_in_bitps

    @property
    def egress_rate_limit_enabled(self):
        """Gets the egress_rate_limit_enabled of this VmNicMetaData.  # noqa: E501


        :return: The egress_rate_limit_enabled of this VmNicMetaData.  # noqa: E501
        :rtype: bool
        """
        return self._egress_rate_limit_enabled

    @egress_rate_limit_enabled.setter
    def egress_rate_limit_enabled(self, egress_rate_limit_enabled):
        """Sets the egress_rate_limit_enabled of this VmNicMetaData.


        :param egress_rate_limit_enabled: The egress_rate_limit_enabled of this VmNicMetaData.  # noqa: E501
        :type egress_rate_limit_enabled: bool
        """

        self._egress_rate_limit_enabled = egress_rate_limit_enabled

    @property
    def egress_rate_limit_burst_in_bit(self):
        """Gets the egress_rate_limit_burst_in_bit of this VmNicMetaData.  # noqa: E501


        :return: The egress_rate_limit_burst_in_bit of this VmNicMetaData.  # noqa: E501
        :rtype: float
        """
        return self._egress_rate_limit_burst_in_bit

    @egress_rate_limit_burst_in_bit.setter
    def egress_rate_limit_burst_in_bit(self, egress_rate_limit_burst_in_bit):
        """Sets the egress_rate_limit_burst_in_bit of this VmNicMetaData.


        :param egress_rate_limit_burst_in_bit: The egress_rate_limit_burst_in_bit of this VmNicMetaData.  # noqa: E501
        :type egress_rate_limit_burst_in_bit: float
        """

        self._egress_rate_limit_burst_in_bit = egress_rate_limit_burst_in_bit

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VmNicMetaData):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VmNicMetaData):
            return True

        return self.to_dict() != other.to_dict()
