# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class VmNicQosTraffic(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'rate_limit_unit': 'BitPSUnit',
        'rate_limit': 'int',
        'burst_unit': 'BitUnit',
        'burst': 'int',
        'enabled': 'bool'
    }

    attribute_map = {
        'rate_limit_unit': 'rate_limit_unit',
        'rate_limit': 'rate_limit',
        'burst_unit': 'burst_unit',
        'burst': 'burst',
        'enabled': 'enabled'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """VmNicQosTraffic - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._rate_limit_unit = None
        self._rate_limit = None
        self._burst_unit = None
        self._burst = None
        self._enabled = None
        self.discriminator = None

        if "rate_limit_unit" in kwargs:
            self.rate_limit_unit = kwargs["rate_limit_unit"]
        self.rate_limit = kwargs.get("rate_limit", None)
        if "burst_unit" in kwargs:
            self.burst_unit = kwargs["burst_unit"]
        self.burst = kwargs.get("burst", None)
        if "enabled" in kwargs:
            self.enabled = kwargs["enabled"]

    @property
    def rate_limit_unit(self):
        """Gets the rate_limit_unit of this VmNicQosTraffic.  # noqa: E501


        :return: The rate_limit_unit of this VmNicQosTraffic.  # noqa: E501
        :rtype: BitPSUnit
        """
        return self._rate_limit_unit

    @rate_limit_unit.setter
    def rate_limit_unit(self, rate_limit_unit):
        """Sets the rate_limit_unit of this VmNicQosTraffic.


        :param rate_limit_unit: The rate_limit_unit of this VmNicQosTraffic.  # noqa: E501
        :type rate_limit_unit: BitPSUnit
        """

        self._rate_limit_unit = rate_limit_unit

    @property
    def rate_limit(self):
        """Gets the rate_limit of this VmNicQosTraffic.  # noqa: E501


        :return: The rate_limit of this VmNicQosTraffic.  # noqa: E501
        :rtype: int
        """
        return self._rate_limit

    @rate_limit.setter
    def rate_limit(self, rate_limit):
        """Sets the rate_limit of this VmNicQosTraffic.


        :param rate_limit: The rate_limit of this VmNicQosTraffic.  # noqa: E501
        :type rate_limit: int
        """

        self._rate_limit = rate_limit

    @property
    def burst_unit(self):
        """Gets the burst_unit of this VmNicQosTraffic.  # noqa: E501


        :return: The burst_unit of this VmNicQosTraffic.  # noqa: E501
        :rtype: BitUnit
        """
        return self._burst_unit

    @burst_unit.setter
    def burst_unit(self, burst_unit):
        """Sets the burst_unit of this VmNicQosTraffic.


        :param burst_unit: The burst_unit of this VmNicQosTraffic.  # noqa: E501
        :type burst_unit: BitUnit
        """

        self._burst_unit = burst_unit

    @property
    def burst(self):
        """Gets the burst of this VmNicQosTraffic.  # noqa: E501


        :return: The burst of this VmNicQosTraffic.  # noqa: E501
        :rtype: int
        """
        return self._burst

    @burst.setter
    def burst(self, burst):
        """Sets the burst of this VmNicQosTraffic.


        :param burst: The burst of this VmNicQosTraffic.  # noqa: E501
        :type burst: int
        """

        self._burst = burst

    @property
    def enabled(self):
        """Gets the enabled of this VmNicQosTraffic.  # noqa: E501


        :return: The enabled of this VmNicQosTraffic.  # noqa: E501
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """Sets the enabled of this VmNicQosTraffic.


        :param enabled: The enabled of this VmNicQosTraffic.  # noqa: E501
        :type enabled: bool
        """
        if self.local_vars_configuration.client_side_validation and enabled is None:  # noqa: E501
            raise ValueError("Invalid value for `enabled`, must not be `None`")  # noqa: E501

        self._enabled = enabled

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VmNicQosTraffic):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VmNicQosTraffic):
            return True

        return self.to_dict() != other.to_dict()
