# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class VmPlacementGroup(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'cluster': 'NestedCluster',
        'description': 'str',
        'enabled': 'bool',
        'entity_async_status': 'EntityAsyncStatus',
        'id': 'str',
        'local_created_at': 'str',
        'local_id': 'str',
        'local_updated_at': 'str',
        'name': 'str',
        'vm_host_must_enabled': 'bool',
        'vm_host_must_host_uuids': 'list[NestedHost]',
        'vm_host_must_policy': 'bool',
        'vm_host_prefer_enabled': 'bool',
        'vm_host_prefer_host_uuids': 'list[NestedHost]',
        'vm_host_prefer_policy': 'bool',
        'vm_vm_policy': 'VmVmPolicy',
        'vm_vm_policy_enabled': 'bool',
        'vms': 'list[NestedVm]'
    }

    attribute_map = {
        'cluster': 'cluster',
        'description': 'description',
        'enabled': 'enabled',
        'entity_async_status': 'entityAsyncStatus',
        'id': 'id',
        'local_created_at': 'local_created_at',
        'local_id': 'local_id',
        'local_updated_at': 'local_updated_at',
        'name': 'name',
        'vm_host_must_enabled': 'vm_host_must_enabled',
        'vm_host_must_host_uuids': 'vm_host_must_host_uuids',
        'vm_host_must_policy': 'vm_host_must_policy',
        'vm_host_prefer_enabled': 'vm_host_prefer_enabled',
        'vm_host_prefer_host_uuids': 'vm_host_prefer_host_uuids',
        'vm_host_prefer_policy': 'vm_host_prefer_policy',
        'vm_vm_policy': 'vm_vm_policy',
        'vm_vm_policy_enabled': 'vm_vm_policy_enabled',
        'vms': 'vms'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """VmPlacementGroup - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._cluster = None
        self._description = None
        self._enabled = None
        self._entity_async_status = None
        self._id = None
        self._local_created_at = None
        self._local_id = None
        self._local_updated_at = None
        self._name = None
        self._vm_host_must_enabled = None
        self._vm_host_must_host_uuids = None
        self._vm_host_must_policy = None
        self._vm_host_prefer_enabled = None
        self._vm_host_prefer_host_uuids = None
        self._vm_host_prefer_policy = None
        self._vm_vm_policy = None
        self._vm_vm_policy_enabled = None
        self._vms = None
        self.discriminator = None

        if "cluster" in kwargs:
            self.cluster = kwargs["cluster"]
        if "description" in kwargs:
            self.description = kwargs["description"]
        if "enabled" in kwargs:
            self.enabled = kwargs["enabled"]
        self.entity_async_status = kwargs.get("entity_async_status", None)
        if "id" in kwargs:
            self.id = kwargs["id"]
        if "local_created_at" in kwargs:
            self.local_created_at = kwargs["local_created_at"]
        if "local_id" in kwargs:
            self.local_id = kwargs["local_id"]
        if "local_updated_at" in kwargs:
            self.local_updated_at = kwargs["local_updated_at"]
        if "name" in kwargs:
            self.name = kwargs["name"]
        if "vm_host_must_enabled" in kwargs:
            self.vm_host_must_enabled = kwargs["vm_host_must_enabled"]
        self.vm_host_must_host_uuids = kwargs.get("vm_host_must_host_uuids", None)
        if "vm_host_must_policy" in kwargs:
            self.vm_host_must_policy = kwargs["vm_host_must_policy"]
        if "vm_host_prefer_enabled" in kwargs:
            self.vm_host_prefer_enabled = kwargs["vm_host_prefer_enabled"]
        self.vm_host_prefer_host_uuids = kwargs.get("vm_host_prefer_host_uuids", None)
        if "vm_host_prefer_policy" in kwargs:
            self.vm_host_prefer_policy = kwargs["vm_host_prefer_policy"]
        if "vm_vm_policy" in kwargs:
            self.vm_vm_policy = kwargs["vm_vm_policy"]
        if "vm_vm_policy_enabled" in kwargs:
            self.vm_vm_policy_enabled = kwargs["vm_vm_policy_enabled"]
        self.vms = kwargs.get("vms", None)

    @property
    def cluster(self):
        """Gets the cluster of this VmPlacementGroup.  # noqa: E501


        :return: The cluster of this VmPlacementGroup.  # noqa: E501
        :rtype: NestedCluster
        """
        return self._cluster

    @cluster.setter
    def cluster(self, cluster):
        """Sets the cluster of this VmPlacementGroup.


        :param cluster: The cluster of this VmPlacementGroup.  # noqa: E501
        :type cluster: NestedCluster
        """
        if self.local_vars_configuration.client_side_validation and cluster is None:  # noqa: E501
            raise ValueError("Invalid value for `cluster`, must not be `None`")  # noqa: E501

        self._cluster = cluster

    @property
    def description(self):
        """Gets the description of this VmPlacementGroup.  # noqa: E501


        :return: The description of this VmPlacementGroup.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this VmPlacementGroup.


        :param description: The description of this VmPlacementGroup.  # noqa: E501
        :type description: str
        """
        if self.local_vars_configuration.client_side_validation and description is None:  # noqa: E501
            raise ValueError("Invalid value for `description`, must not be `None`")  # noqa: E501

        self._description = description

    @property
    def enabled(self):
        """Gets the enabled of this VmPlacementGroup.  # noqa: E501


        :return: The enabled of this VmPlacementGroup.  # noqa: E501
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """Sets the enabled of this VmPlacementGroup.


        :param enabled: The enabled of this VmPlacementGroup.  # noqa: E501
        :type enabled: bool
        """
        if self.local_vars_configuration.client_side_validation and enabled is None:  # noqa: E501
            raise ValueError("Invalid value for `enabled`, must not be `None`")  # noqa: E501

        self._enabled = enabled

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this VmPlacementGroup.  # noqa: E501


        :return: The entity_async_status of this VmPlacementGroup.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this VmPlacementGroup.


        :param entity_async_status: The entity_async_status of this VmPlacementGroup.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def id(self):
        """Gets the id of this VmPlacementGroup.  # noqa: E501


        :return: The id of this VmPlacementGroup.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this VmPlacementGroup.


        :param id: The id of this VmPlacementGroup.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def local_created_at(self):
        """Gets the local_created_at of this VmPlacementGroup.  # noqa: E501


        :return: The local_created_at of this VmPlacementGroup.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at

    @local_created_at.setter
    def local_created_at(self, local_created_at):
        """Sets the local_created_at of this VmPlacementGroup.


        :param local_created_at: The local_created_at of this VmPlacementGroup.  # noqa: E501
        :type local_created_at: str
        """
        if self.local_vars_configuration.client_side_validation and local_created_at is None:  # noqa: E501
            raise ValueError("Invalid value for `local_created_at`, must not be `None`")  # noqa: E501

        self._local_created_at = local_created_at

    @property
    def local_id(self):
        """Gets the local_id of this VmPlacementGroup.  # noqa: E501


        :return: The local_id of this VmPlacementGroup.  # noqa: E501
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id):
        """Sets the local_id of this VmPlacementGroup.


        :param local_id: The local_id of this VmPlacementGroup.  # noqa: E501
        :type local_id: str
        """
        if self.local_vars_configuration.client_side_validation and local_id is None:  # noqa: E501
            raise ValueError("Invalid value for `local_id`, must not be `None`")  # noqa: E501

        self._local_id = local_id

    @property
    def local_updated_at(self):
        """Gets the local_updated_at of this VmPlacementGroup.  # noqa: E501


        :return: The local_updated_at of this VmPlacementGroup.  # noqa: E501
        :rtype: str
        """
        return self._local_updated_at

    @local_updated_at.setter
    def local_updated_at(self, local_updated_at):
        """Sets the local_updated_at of this VmPlacementGroup.


        :param local_updated_at: The local_updated_at of this VmPlacementGroup.  # noqa: E501
        :type local_updated_at: str
        """
        if self.local_vars_configuration.client_side_validation and local_updated_at is None:  # noqa: E501
            raise ValueError("Invalid value for `local_updated_at`, must not be `None`")  # noqa: E501

        self._local_updated_at = local_updated_at

    @property
    def name(self):
        """Gets the name of this VmPlacementGroup.  # noqa: E501


        :return: The name of this VmPlacementGroup.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this VmPlacementGroup.


        :param name: The name of this VmPlacementGroup.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def vm_host_must_enabled(self):
        """Gets the vm_host_must_enabled of this VmPlacementGroup.  # noqa: E501


        :return: The vm_host_must_enabled of this VmPlacementGroup.  # noqa: E501
        :rtype: bool
        """
        return self._vm_host_must_enabled

    @vm_host_must_enabled.setter
    def vm_host_must_enabled(self, vm_host_must_enabled):
        """Sets the vm_host_must_enabled of this VmPlacementGroup.


        :param vm_host_must_enabled: The vm_host_must_enabled of this VmPlacementGroup.  # noqa: E501
        :type vm_host_must_enabled: bool
        """
        if self.local_vars_configuration.client_side_validation and vm_host_must_enabled is None:  # noqa: E501
            raise ValueError("Invalid value for `vm_host_must_enabled`, must not be `None`")  # noqa: E501

        self._vm_host_must_enabled = vm_host_must_enabled

    @property
    def vm_host_must_host_uuids(self):
        """Gets the vm_host_must_host_uuids of this VmPlacementGroup.  # noqa: E501


        :return: The vm_host_must_host_uuids of this VmPlacementGroup.  # noqa: E501
        :rtype: list[NestedHost]
        """
        return self._vm_host_must_host_uuids

    @vm_host_must_host_uuids.setter
    def vm_host_must_host_uuids(self, vm_host_must_host_uuids):
        """Sets the vm_host_must_host_uuids of this VmPlacementGroup.


        :param vm_host_must_host_uuids: The vm_host_must_host_uuids of this VmPlacementGroup.  # noqa: E501
        :type vm_host_must_host_uuids: list[NestedHost]
        """

        self._vm_host_must_host_uuids = vm_host_must_host_uuids

    @property
    def vm_host_must_policy(self):
        """Gets the vm_host_must_policy of this VmPlacementGroup.  # noqa: E501


        :return: The vm_host_must_policy of this VmPlacementGroup.  # noqa: E501
        :rtype: bool
        """
        return self._vm_host_must_policy

    @vm_host_must_policy.setter
    def vm_host_must_policy(self, vm_host_must_policy):
        """Sets the vm_host_must_policy of this VmPlacementGroup.


        :param vm_host_must_policy: The vm_host_must_policy of this VmPlacementGroup.  # noqa: E501
        :type vm_host_must_policy: bool
        """
        if self.local_vars_configuration.client_side_validation and vm_host_must_policy is None:  # noqa: E501
            raise ValueError("Invalid value for `vm_host_must_policy`, must not be `None`")  # noqa: E501

        self._vm_host_must_policy = vm_host_must_policy

    @property
    def vm_host_prefer_enabled(self):
        """Gets the vm_host_prefer_enabled of this VmPlacementGroup.  # noqa: E501


        :return: The vm_host_prefer_enabled of this VmPlacementGroup.  # noqa: E501
        :rtype: bool
        """
        return self._vm_host_prefer_enabled

    @vm_host_prefer_enabled.setter
    def vm_host_prefer_enabled(self, vm_host_prefer_enabled):
        """Sets the vm_host_prefer_enabled of this VmPlacementGroup.


        :param vm_host_prefer_enabled: The vm_host_prefer_enabled of this VmPlacementGroup.  # noqa: E501
        :type vm_host_prefer_enabled: bool
        """
        if self.local_vars_configuration.client_side_validation and vm_host_prefer_enabled is None:  # noqa: E501
            raise ValueError("Invalid value for `vm_host_prefer_enabled`, must not be `None`")  # noqa: E501

        self._vm_host_prefer_enabled = vm_host_prefer_enabled

    @property
    def vm_host_prefer_host_uuids(self):
        """Gets the vm_host_prefer_host_uuids of this VmPlacementGroup.  # noqa: E501


        :return: The vm_host_prefer_host_uuids of this VmPlacementGroup.  # noqa: E501
        :rtype: list[NestedHost]
        """
        return self._vm_host_prefer_host_uuids

    @vm_host_prefer_host_uuids.setter
    def vm_host_prefer_host_uuids(self, vm_host_prefer_host_uuids):
        """Sets the vm_host_prefer_host_uuids of this VmPlacementGroup.


        :param vm_host_prefer_host_uuids: The vm_host_prefer_host_uuids of this VmPlacementGroup.  # noqa: E501
        :type vm_host_prefer_host_uuids: list[NestedHost]
        """

        self._vm_host_prefer_host_uuids = vm_host_prefer_host_uuids

    @property
    def vm_host_prefer_policy(self):
        """Gets the vm_host_prefer_policy of this VmPlacementGroup.  # noqa: E501


        :return: The vm_host_prefer_policy of this VmPlacementGroup.  # noqa: E501
        :rtype: bool
        """
        return self._vm_host_prefer_policy

    @vm_host_prefer_policy.setter
    def vm_host_prefer_policy(self, vm_host_prefer_policy):
        """Sets the vm_host_prefer_policy of this VmPlacementGroup.


        :param vm_host_prefer_policy: The vm_host_prefer_policy of this VmPlacementGroup.  # noqa: E501
        :type vm_host_prefer_policy: bool
        """
        if self.local_vars_configuration.client_side_validation and vm_host_prefer_policy is None:  # noqa: E501
            raise ValueError("Invalid value for `vm_host_prefer_policy`, must not be `None`")  # noqa: E501

        self._vm_host_prefer_policy = vm_host_prefer_policy

    @property
    def vm_vm_policy(self):
        """Gets the vm_vm_policy of this VmPlacementGroup.  # noqa: E501


        :return: The vm_vm_policy of this VmPlacementGroup.  # noqa: E501
        :rtype: VmVmPolicy
        """
        return self._vm_vm_policy

    @vm_vm_policy.setter
    def vm_vm_policy(self, vm_vm_policy):
        """Sets the vm_vm_policy of this VmPlacementGroup.


        :param vm_vm_policy: The vm_vm_policy of this VmPlacementGroup.  # noqa: E501
        :type vm_vm_policy: VmVmPolicy
        """
        if self.local_vars_configuration.client_side_validation and vm_vm_policy is None:  # noqa: E501
            raise ValueError("Invalid value for `vm_vm_policy`, must not be `None`")  # noqa: E501

        self._vm_vm_policy = vm_vm_policy

    @property
    def vm_vm_policy_enabled(self):
        """Gets the vm_vm_policy_enabled of this VmPlacementGroup.  # noqa: E501


        :return: The vm_vm_policy_enabled of this VmPlacementGroup.  # noqa: E501
        :rtype: bool
        """
        return self._vm_vm_policy_enabled

    @vm_vm_policy_enabled.setter
    def vm_vm_policy_enabled(self, vm_vm_policy_enabled):
        """Sets the vm_vm_policy_enabled of this VmPlacementGroup.


        :param vm_vm_policy_enabled: The vm_vm_policy_enabled of this VmPlacementGroup.  # noqa: E501
        :type vm_vm_policy_enabled: bool
        """
        if self.local_vars_configuration.client_side_validation and vm_vm_policy_enabled is None:  # noqa: E501
            raise ValueError("Invalid value for `vm_vm_policy_enabled`, must not be `None`")  # noqa: E501

        self._vm_vm_policy_enabled = vm_vm_policy_enabled

    @property
    def vms(self):
        """Gets the vms of this VmPlacementGroup.  # noqa: E501


        :return: The vms of this VmPlacementGroup.  # noqa: E501
        :rtype: list[NestedVm]
        """
        return self._vms

    @vms.setter
    def vms(self, vms):
        """Sets the vms of this VmPlacementGroup.


        :param vms: The vms of this VmPlacementGroup.  # noqa: E501
        :type vms: list[NestedVm]
        """

        self._vms = vms

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VmPlacementGroup):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VmPlacementGroup):
            return True

        return self.to_dict() != other.to_dict()
