# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class VmSnapshot(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'clock_offset': 'VmClockOffset',
        'cluster': 'NestedCluster',
        'consistent_type': 'ConsistentType',
        'cpu': 'NestedCpu',
        'cpu_model': 'str',
        'description': 'str',
        'entity_async_status': 'EntityAsyncStatus',
        'firmware': 'VmFirmware',
        'ha': 'bool',
        'ha_priority': 'VmHaPriority',
        'id': 'str',
        'io_policy': 'VmDiskIoPolicy',
        'labels': 'list[NestedLabel]',
        'local_created_at': 'str',
        'local_id': 'str',
        'max_bandwidth': 'int',
        'max_bandwidth_policy': 'VmDiskIoRestrictType',
        'max_iops': 'int',
        'max_iops_policy': 'VmDiskIoRestrictType',
        'memory': 'int',
        'name': 'str',
        'size': 'int',
        'snapshot_group': 'NestedSnapshotGroup',
        'vcpu': 'int',
        'vm': 'NestedVm',
        'vm_disks': 'list[NestedFrozenDisks]',
        'vm_nics': 'list[NestedFrozenNic]',
        'win_opt': 'bool'
    }

    attribute_map = {
        'clock_offset': 'clock_offset',
        'cluster': 'cluster',
        'consistent_type': 'consistent_type',
        'cpu': 'cpu',
        'cpu_model': 'cpu_model',
        'description': 'description',
        'entity_async_status': 'entityAsyncStatus',
        'firmware': 'firmware',
        'ha': 'ha',
        'ha_priority': 'ha_priority',
        'id': 'id',
        'io_policy': 'io_policy',
        'labels': 'labels',
        'local_created_at': 'local_created_at',
        'local_id': 'local_id',
        'max_bandwidth': 'max_bandwidth',
        'max_bandwidth_policy': 'max_bandwidth_policy',
        'max_iops': 'max_iops',
        'max_iops_policy': 'max_iops_policy',
        'memory': 'memory',
        'name': 'name',
        'size': 'size',
        'snapshot_group': 'snapshot_group',
        'vcpu': 'vcpu',
        'vm': 'vm',
        'vm_disks': 'vm_disks',
        'vm_nics': 'vm_nics',
        'win_opt': 'win_opt'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """VmSnapshot - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._clock_offset = None
        self._cluster = None
        self._consistent_type = None
        self._cpu = None
        self._cpu_model = None
        self._description = None
        self._entity_async_status = None
        self._firmware = None
        self._ha = None
        self._ha_priority = None
        self._id = None
        self._io_policy = None
        self._labels = None
        self._local_created_at = None
        self._local_id = None
        self._max_bandwidth = None
        self._max_bandwidth_policy = None
        self._max_iops = None
        self._max_iops_policy = None
        self._memory = None
        self._name = None
        self._size = None
        self._snapshot_group = None
        self._vcpu = None
        self._vm = None
        self._vm_disks = None
        self._vm_nics = None
        self._win_opt = None
        self.discriminator = None

        if "clock_offset" in kwargs:
            self.clock_offset = kwargs["clock_offset"]
        if "cluster" in kwargs:
            self.cluster = kwargs["cluster"]
        if "consistent_type" in kwargs:
            self.consistent_type = kwargs["consistent_type"]
        if "cpu" in kwargs:
            self.cpu = kwargs["cpu"]
        if "cpu_model" in kwargs:
            self.cpu_model = kwargs["cpu_model"]
        if "description" in kwargs:
            self.description = kwargs["description"]
        self.entity_async_status = kwargs.get("entity_async_status", None)
        if "firmware" in kwargs:
            self.firmware = kwargs["firmware"]
        if "ha" in kwargs:
            self.ha = kwargs["ha"]
        self.ha_priority = kwargs.get("ha_priority", None)
        if "id" in kwargs:
            self.id = kwargs["id"]
        self.io_policy = kwargs.get("io_policy", None)
        self.labels = kwargs.get("labels", None)
        self.local_created_at = kwargs.get("local_created_at", None)
        if "local_id" in kwargs:
            self.local_id = kwargs["local_id"]
        self.max_bandwidth = kwargs.get("max_bandwidth", None)
        self.max_bandwidth_policy = kwargs.get("max_bandwidth_policy", None)
        self.max_iops = kwargs.get("max_iops", None)
        self.max_iops_policy = kwargs.get("max_iops_policy", None)
        if "memory" in kwargs:
            self.memory = kwargs["memory"]
        if "name" in kwargs:
            self.name = kwargs["name"]
        if "size" in kwargs:
            self.size = kwargs["size"]
        self.snapshot_group = kwargs.get("snapshot_group", None)
        if "vcpu" in kwargs:
            self.vcpu = kwargs["vcpu"]
        self.vm = kwargs.get("vm", None)
        self.vm_disks = kwargs.get("vm_disks", None)
        self.vm_nics = kwargs.get("vm_nics", None)
        if "win_opt" in kwargs:
            self.win_opt = kwargs["win_opt"]

    @property
    def clock_offset(self):
        """Gets the clock_offset of this VmSnapshot.  # noqa: E501


        :return: The clock_offset of this VmSnapshot.  # noqa: E501
        :rtype: VmClockOffset
        """
        return self._clock_offset

    @clock_offset.setter
    def clock_offset(self, clock_offset):
        """Sets the clock_offset of this VmSnapshot.


        :param clock_offset: The clock_offset of this VmSnapshot.  # noqa: E501
        :type clock_offset: VmClockOffset
        """
        if self.local_vars_configuration.client_side_validation and clock_offset is None:  # noqa: E501
            raise ValueError("Invalid value for `clock_offset`, must not be `None`")  # noqa: E501

        self._clock_offset = clock_offset

    @property
    def cluster(self):
        """Gets the cluster of this VmSnapshot.  # noqa: E501


        :return: The cluster of this VmSnapshot.  # noqa: E501
        :rtype: NestedCluster
        """
        return self._cluster

    @cluster.setter
    def cluster(self, cluster):
        """Sets the cluster of this VmSnapshot.


        :param cluster: The cluster of this VmSnapshot.  # noqa: E501
        :type cluster: NestedCluster
        """
        if self.local_vars_configuration.client_side_validation and cluster is None:  # noqa: E501
            raise ValueError("Invalid value for `cluster`, must not be `None`")  # noqa: E501

        self._cluster = cluster

    @property
    def consistent_type(self):
        """Gets the consistent_type of this VmSnapshot.  # noqa: E501


        :return: The consistent_type of this VmSnapshot.  # noqa: E501
        :rtype: ConsistentType
        """
        return self._consistent_type

    @consistent_type.setter
    def consistent_type(self, consistent_type):
        """Sets the consistent_type of this VmSnapshot.


        :param consistent_type: The consistent_type of this VmSnapshot.  # noqa: E501
        :type consistent_type: ConsistentType
        """
        if self.local_vars_configuration.client_side_validation and consistent_type is None:  # noqa: E501
            raise ValueError("Invalid value for `consistent_type`, must not be `None`")  # noqa: E501

        self._consistent_type = consistent_type

    @property
    def cpu(self):
        """Gets the cpu of this VmSnapshot.  # noqa: E501


        :return: The cpu of this VmSnapshot.  # noqa: E501
        :rtype: NestedCpu
        """
        return self._cpu

    @cpu.setter
    def cpu(self, cpu):
        """Sets the cpu of this VmSnapshot.


        :param cpu: The cpu of this VmSnapshot.  # noqa: E501
        :type cpu: NestedCpu
        """
        if self.local_vars_configuration.client_side_validation and cpu is None:  # noqa: E501
            raise ValueError("Invalid value for `cpu`, must not be `None`")  # noqa: E501

        self._cpu = cpu

    @property
    def cpu_model(self):
        """Gets the cpu_model of this VmSnapshot.  # noqa: E501


        :return: The cpu_model of this VmSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._cpu_model

    @cpu_model.setter
    def cpu_model(self, cpu_model):
        """Sets the cpu_model of this VmSnapshot.


        :param cpu_model: The cpu_model of this VmSnapshot.  # noqa: E501
        :type cpu_model: str
        """
        if self.local_vars_configuration.client_side_validation and cpu_model is None:  # noqa: E501
            raise ValueError("Invalid value for `cpu_model`, must not be `None`")  # noqa: E501

        self._cpu_model = cpu_model

    @property
    def description(self):
        """Gets the description of this VmSnapshot.  # noqa: E501


        :return: The description of this VmSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this VmSnapshot.


        :param description: The description of this VmSnapshot.  # noqa: E501
        :type description: str
        """
        if self.local_vars_configuration.client_side_validation and description is None:  # noqa: E501
            raise ValueError("Invalid value for `description`, must not be `None`")  # noqa: E501

        self._description = description

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this VmSnapshot.  # noqa: E501


        :return: The entity_async_status of this VmSnapshot.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this VmSnapshot.


        :param entity_async_status: The entity_async_status of this VmSnapshot.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def firmware(self):
        """Gets the firmware of this VmSnapshot.  # noqa: E501


        :return: The firmware of this VmSnapshot.  # noqa: E501
        :rtype: VmFirmware
        """
        return self._firmware

    @firmware.setter
    def firmware(self, firmware):
        """Sets the firmware of this VmSnapshot.


        :param firmware: The firmware of this VmSnapshot.  # noqa: E501
        :type firmware: VmFirmware
        """
        if self.local_vars_configuration.client_side_validation and firmware is None:  # noqa: E501
            raise ValueError("Invalid value for `firmware`, must not be `None`")  # noqa: E501

        self._firmware = firmware

    @property
    def ha(self):
        """Gets the ha of this VmSnapshot.  # noqa: E501


        :return: The ha of this VmSnapshot.  # noqa: E501
        :rtype: bool
        """
        return self._ha

    @ha.setter
    def ha(self, ha):
        """Sets the ha of this VmSnapshot.


        :param ha: The ha of this VmSnapshot.  # noqa: E501
        :type ha: bool
        """
        if self.local_vars_configuration.client_side_validation and ha is None:  # noqa: E501
            raise ValueError("Invalid value for `ha`, must not be `None`")  # noqa: E501

        self._ha = ha

    @property
    def ha_priority(self):
        """Gets the ha_priority of this VmSnapshot.  # noqa: E501


        :return: The ha_priority of this VmSnapshot.  # noqa: E501
        :rtype: VmHaPriority
        """
        return self._ha_priority

    @ha_priority.setter
    def ha_priority(self, ha_priority):
        """Sets the ha_priority of this VmSnapshot.


        :param ha_priority: The ha_priority of this VmSnapshot.  # noqa: E501
        :type ha_priority: VmHaPriority
        """

        self._ha_priority = ha_priority

    @property
    def id(self):
        """Gets the id of this VmSnapshot.  # noqa: E501


        :return: The id of this VmSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this VmSnapshot.


        :param id: The id of this VmSnapshot.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def io_policy(self):
        """Gets the io_policy of this VmSnapshot.  # noqa: E501


        :return: The io_policy of this VmSnapshot.  # noqa: E501
        :rtype: VmDiskIoPolicy
        """
        return self._io_policy

    @io_policy.setter
    def io_policy(self, io_policy):
        """Sets the io_policy of this VmSnapshot.


        :param io_policy: The io_policy of this VmSnapshot.  # noqa: E501
        :type io_policy: VmDiskIoPolicy
        """

        self._io_policy = io_policy

    @property
    def labels(self):
        """Gets the labels of this VmSnapshot.  # noqa: E501


        :return: The labels of this VmSnapshot.  # noqa: E501
        :rtype: list[NestedLabel]
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this VmSnapshot.


        :param labels: The labels of this VmSnapshot.  # noqa: E501
        :type labels: list[NestedLabel]
        """

        self._labels = labels

    @property
    def local_created_at(self):
        """Gets the local_created_at of this VmSnapshot.  # noqa: E501


        :return: The local_created_at of this VmSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at

    @local_created_at.setter
    def local_created_at(self, local_created_at):
        """Sets the local_created_at of this VmSnapshot.


        :param local_created_at: The local_created_at of this VmSnapshot.  # noqa: E501
        :type local_created_at: str
        """

        self._local_created_at = local_created_at

    @property
    def local_id(self):
        """Gets the local_id of this VmSnapshot.  # noqa: E501


        :return: The local_id of this VmSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id):
        """Sets the local_id of this VmSnapshot.


        :param local_id: The local_id of this VmSnapshot.  # noqa: E501
        :type local_id: str
        """
        if self.local_vars_configuration.client_side_validation and local_id is None:  # noqa: E501
            raise ValueError("Invalid value for `local_id`, must not be `None`")  # noqa: E501

        self._local_id = local_id

    @property
    def max_bandwidth(self):
        """Gets the max_bandwidth of this VmSnapshot.  # noqa: E501


        :return: The max_bandwidth of this VmSnapshot.  # noqa: E501
        :rtype: int
        """
        return self._max_bandwidth

    @max_bandwidth.setter
    def max_bandwidth(self, max_bandwidth):
        """Sets the max_bandwidth of this VmSnapshot.


        :param max_bandwidth: The max_bandwidth of this VmSnapshot.  # noqa: E501
        :type max_bandwidth: int
        """

        self._max_bandwidth = max_bandwidth

    @property
    def max_bandwidth_policy(self):
        """Gets the max_bandwidth_policy of this VmSnapshot.  # noqa: E501


        :return: The max_bandwidth_policy of this VmSnapshot.  # noqa: E501
        :rtype: VmDiskIoRestrictType
        """
        return self._max_bandwidth_policy

    @max_bandwidth_policy.setter
    def max_bandwidth_policy(self, max_bandwidth_policy):
        """Sets the max_bandwidth_policy of this VmSnapshot.


        :param max_bandwidth_policy: The max_bandwidth_policy of this VmSnapshot.  # noqa: E501
        :type max_bandwidth_policy: VmDiskIoRestrictType
        """

        self._max_bandwidth_policy = max_bandwidth_policy

    @property
    def max_iops(self):
        """Gets the max_iops of this VmSnapshot.  # noqa: E501


        :return: The max_iops of this VmSnapshot.  # noqa: E501
        :rtype: int
        """
        return self._max_iops

    @max_iops.setter
    def max_iops(self, max_iops):
        """Sets the max_iops of this VmSnapshot.


        :param max_iops: The max_iops of this VmSnapshot.  # noqa: E501
        :type max_iops: int
        """

        self._max_iops = max_iops

    @property
    def max_iops_policy(self):
        """Gets the max_iops_policy of this VmSnapshot.  # noqa: E501


        :return: The max_iops_policy of this VmSnapshot.  # noqa: E501
        :rtype: VmDiskIoRestrictType
        """
        return self._max_iops_policy

    @max_iops_policy.setter
    def max_iops_policy(self, max_iops_policy):
        """Sets the max_iops_policy of this VmSnapshot.


        :param max_iops_policy: The max_iops_policy of this VmSnapshot.  # noqa: E501
        :type max_iops_policy: VmDiskIoRestrictType
        """

        self._max_iops_policy = max_iops_policy

    @property
    def memory(self):
        """Gets the memory of this VmSnapshot.  # noqa: E501


        :return: The memory of this VmSnapshot.  # noqa: E501
        :rtype: int
        """
        return self._memory

    @memory.setter
    def memory(self, memory):
        """Sets the memory of this VmSnapshot.


        :param memory: The memory of this VmSnapshot.  # noqa: E501
        :type memory: int
        """
        if self.local_vars_configuration.client_side_validation and memory is None:  # noqa: E501
            raise ValueError("Invalid value for `memory`, must not be `None`")  # noqa: E501

        self._memory = memory

    @property
    def name(self):
        """Gets the name of this VmSnapshot.  # noqa: E501


        :return: The name of this VmSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this VmSnapshot.


        :param name: The name of this VmSnapshot.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def size(self):
        """Gets the size of this VmSnapshot.  # noqa: E501


        :return: The size of this VmSnapshot.  # noqa: E501
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size):
        """Sets the size of this VmSnapshot.


        :param size: The size of this VmSnapshot.  # noqa: E501
        :type size: int
        """
        if self.local_vars_configuration.client_side_validation and size is None:  # noqa: E501
            raise ValueError("Invalid value for `size`, must not be `None`")  # noqa: E501

        self._size = size

    @property
    def snapshot_group(self):
        """Gets the snapshot_group of this VmSnapshot.  # noqa: E501


        :return: The snapshot_group of this VmSnapshot.  # noqa: E501
        :rtype: NestedSnapshotGroup
        """
        return self._snapshot_group

    @snapshot_group.setter
    def snapshot_group(self, snapshot_group):
        """Sets the snapshot_group of this VmSnapshot.


        :param snapshot_group: The snapshot_group of this VmSnapshot.  # noqa: E501
        :type snapshot_group: NestedSnapshotGroup
        """

        self._snapshot_group = snapshot_group

    @property
    def vcpu(self):
        """Gets the vcpu of this VmSnapshot.  # noqa: E501


        :return: The vcpu of this VmSnapshot.  # noqa: E501
        :rtype: int
        """
        return self._vcpu

    @vcpu.setter
    def vcpu(self, vcpu):
        """Sets the vcpu of this VmSnapshot.


        :param vcpu: The vcpu of this VmSnapshot.  # noqa: E501
        :type vcpu: int
        """
        if self.local_vars_configuration.client_side_validation and vcpu is None:  # noqa: E501
            raise ValueError("Invalid value for `vcpu`, must not be `None`")  # noqa: E501

        self._vcpu = vcpu

    @property
    def vm(self):
        """Gets the vm of this VmSnapshot.  # noqa: E501


        :return: The vm of this VmSnapshot.  # noqa: E501
        :rtype: NestedVm
        """
        return self._vm

    @vm.setter
    def vm(self, vm):
        """Sets the vm of this VmSnapshot.


        :param vm: The vm of this VmSnapshot.  # noqa: E501
        :type vm: NestedVm
        """

        self._vm = vm

    @property
    def vm_disks(self):
        """Gets the vm_disks of this VmSnapshot.  # noqa: E501


        :return: The vm_disks of this VmSnapshot.  # noqa: E501
        :rtype: list[NestedFrozenDisks]
        """
        return self._vm_disks

    @vm_disks.setter
    def vm_disks(self, vm_disks):
        """Sets the vm_disks of this VmSnapshot.


        :param vm_disks: The vm_disks of this VmSnapshot.  # noqa: E501
        :type vm_disks: list[NestedFrozenDisks]
        """

        self._vm_disks = vm_disks

    @property
    def vm_nics(self):
        """Gets the vm_nics of this VmSnapshot.  # noqa: E501


        :return: The vm_nics of this VmSnapshot.  # noqa: E501
        :rtype: list[NestedFrozenNic]
        """
        return self._vm_nics

    @vm_nics.setter
    def vm_nics(self, vm_nics):
        """Sets the vm_nics of this VmSnapshot.


        :param vm_nics: The vm_nics of this VmSnapshot.  # noqa: E501
        :type vm_nics: list[NestedFrozenNic]
        """

        self._vm_nics = vm_nics

    @property
    def win_opt(self):
        """Gets the win_opt of this VmSnapshot.  # noqa: E501


        :return: The win_opt of this VmSnapshot.  # noqa: E501
        :rtype: bool
        """
        return self._win_opt

    @win_opt.setter
    def win_opt(self, win_opt):
        """Sets the win_opt of this VmSnapshot.


        :param win_opt: The win_opt of this VmSnapshot.  # noqa: E501
        :type win_opt: bool
        """
        if self.local_vars_configuration.client_side_validation and win_opt is None:  # noqa: E501
            raise ValueError("Invalid value for `win_opt`, must not be `None`")  # noqa: E501

        self._win_opt = win_opt

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VmSnapshot):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VmSnapshot):
            return True

        return self.to_dict() != other.to_dict()
