# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class VmTemplateWhereInput(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        '_and': 'list[VmTemplateWhereInput]',
        '_not': 'list[VmTemplateWhereInput]',
        '_or': 'list[VmTemplateWhereInput]',
        'clock_offset': 'VmClockOffset',
        'clock_offset_in': 'list[VmClockOffset]',
        'clock_offset_not': 'VmClockOffset',
        'clock_offset_not_in': 'list[VmClockOffset]',
        'cloud_init_supported': 'bool',
        'cloud_init_supported_not': 'bool',
        'cluster': 'ClusterWhereInput',
        'content_library_vm_template': 'ContentLibraryVmTemplateWhereInput',
        'cpu_model': 'str',
        'cpu_model_contains': 'str',
        'cpu_model_ends_with': 'str',
        'cpu_model_gt': 'str',
        'cpu_model_gte': 'str',
        'cpu_model_in': 'list[str]',
        'cpu_model_lt': 'str',
        'cpu_model_lte': 'str',
        'cpu_model_not': 'str',
        'cpu_model_not_contains': 'str',
        'cpu_model_not_ends_with': 'str',
        'cpu_model_not_in': 'list[str]',
        'cpu_model_not_starts_with': 'str',
        'cpu_model_starts_with': 'str',
        'description': 'str',
        'description_contains': 'str',
        'description_ends_with': 'str',
        'description_gt': 'str',
        'description_gte': 'str',
        'description_in': 'list[str]',
        'description_lt': 'str',
        'description_lte': 'str',
        'description_not': 'str',
        'description_not_contains': 'str',
        'description_not_ends_with': 'str',
        'description_not_in': 'list[str]',
        'description_not_starts_with': 'str',
        'description_starts_with': 'str',
        'entity_async_status': 'EntityAsyncStatus',
        'entity_async_status_in': 'list[EntityAsyncStatus]',
        'entity_async_status_not': 'EntityAsyncStatus',
        'entity_async_status_not_in': 'list[EntityAsyncStatus]',
        'firmware': 'VmFirmware',
        'firmware_in': 'list[VmFirmware]',
        'firmware_not': 'VmFirmware',
        'firmware_not_in': 'list[VmFirmware]',
        'ha': 'bool',
        'ha_not': 'bool',
        'id': 'str',
        'id_contains': 'str',
        'id_ends_with': 'str',
        'id_gt': 'str',
        'id_gte': 'str',
        'id_in': 'list[str]',
        'id_lt': 'str',
        'id_lte': 'str',
        'id_not': 'str',
        'id_not_contains': 'str',
        'id_not_ends_with': 'str',
        'id_not_in': 'list[str]',
        'id_not_starts_with': 'str',
        'id_starts_with': 'str',
        'io_policy': 'VmDiskIoPolicy',
        'io_policy_in': 'list[VmDiskIoPolicy]',
        'io_policy_not': 'VmDiskIoPolicy',
        'io_policy_not_in': 'list[VmDiskIoPolicy]',
        'labels_every': 'LabelWhereInput',
        'labels_none': 'LabelWhereInput',
        'labels_some': 'LabelWhereInput',
        'local_created_at': 'str',
        'local_created_at_gt': 'str',
        'local_created_at_gte': 'str',
        'local_created_at_in': 'list[str]',
        'local_created_at_lt': 'str',
        'local_created_at_lte': 'str',
        'local_created_at_not': 'str',
        'local_created_at_not_in': 'list[str]',
        'local_id': 'str',
        'local_id_contains': 'str',
        'local_id_ends_with': 'str',
        'local_id_gt': 'str',
        'local_id_gte': 'str',
        'local_id_in': 'list[str]',
        'local_id_lt': 'str',
        'local_id_lte': 'str',
        'local_id_not': 'str',
        'local_id_not_contains': 'str',
        'local_id_not_ends_with': 'str',
        'local_id_not_in': 'list[str]',
        'local_id_not_starts_with': 'str',
        'local_id_starts_with': 'str',
        'max_bandwidth': 'int',
        'max_bandwidth_gt': 'int',
        'max_bandwidth_gte': 'int',
        'max_bandwidth_in': 'list[int]',
        'max_bandwidth_lt': 'int',
        'max_bandwidth_lte': 'int',
        'max_bandwidth_not': 'int',
        'max_bandwidth_not_in': 'list[int]',
        'max_bandwidth_policy': 'VmDiskIoRestrictType',
        'max_bandwidth_policy_in': 'list[VmDiskIoRestrictType]',
        'max_bandwidth_policy_not': 'VmDiskIoRestrictType',
        'max_bandwidth_policy_not_in': 'list[VmDiskIoRestrictType]',
        'max_iops': 'int',
        'max_iops_gt': 'int',
        'max_iops_gte': 'int',
        'max_iops_in': 'list[int]',
        'max_iops_lt': 'int',
        'max_iops_lte': 'int',
        'max_iops_not': 'int',
        'max_iops_not_in': 'list[int]',
        'max_iops_policy': 'VmDiskIoRestrictType',
        'max_iops_policy_in': 'list[VmDiskIoRestrictType]',
        'max_iops_policy_not': 'VmDiskIoRestrictType',
        'max_iops_policy_not_in': 'list[VmDiskIoRestrictType]',
        'memory': 'int',
        'memory_gt': 'int',
        'memory_gte': 'int',
        'memory_in': 'list[int]',
        'memory_lt': 'int',
        'memory_lte': 'int',
        'memory_not': 'int',
        'memory_not_in': 'list[int]',
        'name': 'str',
        'name_contains': 'str',
        'name_ends_with': 'str',
        'name_gt': 'str',
        'name_gte': 'str',
        'name_in': 'list[str]',
        'name_lt': 'str',
        'name_lte': 'str',
        'name_not': 'str',
        'name_not_contains': 'str',
        'name_not_ends_with': 'str',
        'name_not_in': 'list[str]',
        'name_not_starts_with': 'str',
        'name_starts_with': 'str',
        'size': 'int',
        'size_gt': 'int',
        'size_gte': 'int',
        'size_in': 'list[int]',
        'size_lt': 'int',
        'size_lte': 'int',
        'size_not': 'int',
        'size_not_in': 'list[int]',
        'vcpu': 'int',
        'vcpu_gt': 'int',
        'vcpu_gte': 'int',
        'vcpu_in': 'list[int]',
        'vcpu_lt': 'int',
        'vcpu_lte': 'int',
        'vcpu_not': 'int',
        'vcpu_not_in': 'list[int]',
        'video_type': 'str',
        'video_type_contains': 'str',
        'video_type_ends_with': 'str',
        'video_type_gt': 'str',
        'video_type_gte': 'str',
        'video_type_in': 'list[str]',
        'video_type_lt': 'str',
        'video_type_lte': 'str',
        'video_type_not': 'str',
        'video_type_not_contains': 'str',
        'video_type_not_ends_with': 'str',
        'video_type_not_in': 'list[str]',
        'video_type_not_starts_with': 'str',
        'video_type_starts_with': 'str',
        'win_opt': 'bool',
        'win_opt_not': 'bool'
    }

    attribute_map = {
        '_and': 'AND',
        '_not': 'NOT',
        '_or': 'OR',
        'clock_offset': 'clock_offset',
        'clock_offset_in': 'clock_offset_in',
        'clock_offset_not': 'clock_offset_not',
        'clock_offset_not_in': 'clock_offset_not_in',
        'cloud_init_supported': 'cloud_init_supported',
        'cloud_init_supported_not': 'cloud_init_supported_not',
        'cluster': 'cluster',
        'content_library_vm_template': 'content_library_vm_template',
        'cpu_model': 'cpu_model',
        'cpu_model_contains': 'cpu_model_contains',
        'cpu_model_ends_with': 'cpu_model_ends_with',
        'cpu_model_gt': 'cpu_model_gt',
        'cpu_model_gte': 'cpu_model_gte',
        'cpu_model_in': 'cpu_model_in',
        'cpu_model_lt': 'cpu_model_lt',
        'cpu_model_lte': 'cpu_model_lte',
        'cpu_model_not': 'cpu_model_not',
        'cpu_model_not_contains': 'cpu_model_not_contains',
        'cpu_model_not_ends_with': 'cpu_model_not_ends_with',
        'cpu_model_not_in': 'cpu_model_not_in',
        'cpu_model_not_starts_with': 'cpu_model_not_starts_with',
        'cpu_model_starts_with': 'cpu_model_starts_with',
        'description': 'description',
        'description_contains': 'description_contains',
        'description_ends_with': 'description_ends_with',
        'description_gt': 'description_gt',
        'description_gte': 'description_gte',
        'description_in': 'description_in',
        'description_lt': 'description_lt',
        'description_lte': 'description_lte',
        'description_not': 'description_not',
        'description_not_contains': 'description_not_contains',
        'description_not_ends_with': 'description_not_ends_with',
        'description_not_in': 'description_not_in',
        'description_not_starts_with': 'description_not_starts_with',
        'description_starts_with': 'description_starts_with',
        'entity_async_status': 'entityAsyncStatus',
        'entity_async_status_in': 'entityAsyncStatus_in',
        'entity_async_status_not': 'entityAsyncStatus_not',
        'entity_async_status_not_in': 'entityAsyncStatus_not_in',
        'firmware': 'firmware',
        'firmware_in': 'firmware_in',
        'firmware_not': 'firmware_not',
        'firmware_not_in': 'firmware_not_in',
        'ha': 'ha',
        'ha_not': 'ha_not',
        'id': 'id',
        'id_contains': 'id_contains',
        'id_ends_with': 'id_ends_with',
        'id_gt': 'id_gt',
        'id_gte': 'id_gte',
        'id_in': 'id_in',
        'id_lt': 'id_lt',
        'id_lte': 'id_lte',
        'id_not': 'id_not',
        'id_not_contains': 'id_not_contains',
        'id_not_ends_with': 'id_not_ends_with',
        'id_not_in': 'id_not_in',
        'id_not_starts_with': 'id_not_starts_with',
        'id_starts_with': 'id_starts_with',
        'io_policy': 'io_policy',
        'io_policy_in': 'io_policy_in',
        'io_policy_not': 'io_policy_not',
        'io_policy_not_in': 'io_policy_not_in',
        'labels_every': 'labels_every',
        'labels_none': 'labels_none',
        'labels_some': 'labels_some',
        'local_created_at': 'local_created_at',
        'local_created_at_gt': 'local_created_at_gt',
        'local_created_at_gte': 'local_created_at_gte',
        'local_created_at_in': 'local_created_at_in',
        'local_created_at_lt': 'local_created_at_lt',
        'local_created_at_lte': 'local_created_at_lte',
        'local_created_at_not': 'local_created_at_not',
        'local_created_at_not_in': 'local_created_at_not_in',
        'local_id': 'local_id',
        'local_id_contains': 'local_id_contains',
        'local_id_ends_with': 'local_id_ends_with',
        'local_id_gt': 'local_id_gt',
        'local_id_gte': 'local_id_gte',
        'local_id_in': 'local_id_in',
        'local_id_lt': 'local_id_lt',
        'local_id_lte': 'local_id_lte',
        'local_id_not': 'local_id_not',
        'local_id_not_contains': 'local_id_not_contains',
        'local_id_not_ends_with': 'local_id_not_ends_with',
        'local_id_not_in': 'local_id_not_in',
        'local_id_not_starts_with': 'local_id_not_starts_with',
        'local_id_starts_with': 'local_id_starts_with',
        'max_bandwidth': 'max_bandwidth',
        'max_bandwidth_gt': 'max_bandwidth_gt',
        'max_bandwidth_gte': 'max_bandwidth_gte',
        'max_bandwidth_in': 'max_bandwidth_in',
        'max_bandwidth_lt': 'max_bandwidth_lt',
        'max_bandwidth_lte': 'max_bandwidth_lte',
        'max_bandwidth_not': 'max_bandwidth_not',
        'max_bandwidth_not_in': 'max_bandwidth_not_in',
        'max_bandwidth_policy': 'max_bandwidth_policy',
        'max_bandwidth_policy_in': 'max_bandwidth_policy_in',
        'max_bandwidth_policy_not': 'max_bandwidth_policy_not',
        'max_bandwidth_policy_not_in': 'max_bandwidth_policy_not_in',
        'max_iops': 'max_iops',
        'max_iops_gt': 'max_iops_gt',
        'max_iops_gte': 'max_iops_gte',
        'max_iops_in': 'max_iops_in',
        'max_iops_lt': 'max_iops_lt',
        'max_iops_lte': 'max_iops_lte',
        'max_iops_not': 'max_iops_not',
        'max_iops_not_in': 'max_iops_not_in',
        'max_iops_policy': 'max_iops_policy',
        'max_iops_policy_in': 'max_iops_policy_in',
        'max_iops_policy_not': 'max_iops_policy_not',
        'max_iops_policy_not_in': 'max_iops_policy_not_in',
        'memory': 'memory',
        'memory_gt': 'memory_gt',
        'memory_gte': 'memory_gte',
        'memory_in': 'memory_in',
        'memory_lt': 'memory_lt',
        'memory_lte': 'memory_lte',
        'memory_not': 'memory_not',
        'memory_not_in': 'memory_not_in',
        'name': 'name',
        'name_contains': 'name_contains',
        'name_ends_with': 'name_ends_with',
        'name_gt': 'name_gt',
        'name_gte': 'name_gte',
        'name_in': 'name_in',
        'name_lt': 'name_lt',
        'name_lte': 'name_lte',
        'name_not': 'name_not',
        'name_not_contains': 'name_not_contains',
        'name_not_ends_with': 'name_not_ends_with',
        'name_not_in': 'name_not_in',
        'name_not_starts_with': 'name_not_starts_with',
        'name_starts_with': 'name_starts_with',
        'size': 'size',
        'size_gt': 'size_gt',
        'size_gte': 'size_gte',
        'size_in': 'size_in',
        'size_lt': 'size_lt',
        'size_lte': 'size_lte',
        'size_not': 'size_not',
        'size_not_in': 'size_not_in',
        'vcpu': 'vcpu',
        'vcpu_gt': 'vcpu_gt',
        'vcpu_gte': 'vcpu_gte',
        'vcpu_in': 'vcpu_in',
        'vcpu_lt': 'vcpu_lt',
        'vcpu_lte': 'vcpu_lte',
        'vcpu_not': 'vcpu_not',
        'vcpu_not_in': 'vcpu_not_in',
        'video_type': 'video_type',
        'video_type_contains': 'video_type_contains',
        'video_type_ends_with': 'video_type_ends_with',
        'video_type_gt': 'video_type_gt',
        'video_type_gte': 'video_type_gte',
        'video_type_in': 'video_type_in',
        'video_type_lt': 'video_type_lt',
        'video_type_lte': 'video_type_lte',
        'video_type_not': 'video_type_not',
        'video_type_not_contains': 'video_type_not_contains',
        'video_type_not_ends_with': 'video_type_not_ends_with',
        'video_type_not_in': 'video_type_not_in',
        'video_type_not_starts_with': 'video_type_not_starts_with',
        'video_type_starts_with': 'video_type_starts_with',
        'win_opt': 'win_opt',
        'win_opt_not': 'win_opt_not'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """VmTemplateWhereInput - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self.__and = None
        self.__not = None
        self.__or = None
        self._clock_offset = None
        self._clock_offset_in = None
        self._clock_offset_not = None
        self._clock_offset_not_in = None
        self._cloud_init_supported = None
        self._cloud_init_supported_not = None
        self._cluster = None
        self._content_library_vm_template = None
        self._cpu_model = None
        self._cpu_model_contains = None
        self._cpu_model_ends_with = None
        self._cpu_model_gt = None
        self._cpu_model_gte = None
        self._cpu_model_in = None
        self._cpu_model_lt = None
        self._cpu_model_lte = None
        self._cpu_model_not = None
        self._cpu_model_not_contains = None
        self._cpu_model_not_ends_with = None
        self._cpu_model_not_in = None
        self._cpu_model_not_starts_with = None
        self._cpu_model_starts_with = None
        self._description = None
        self._description_contains = None
        self._description_ends_with = None
        self._description_gt = None
        self._description_gte = None
        self._description_in = None
        self._description_lt = None
        self._description_lte = None
        self._description_not = None
        self._description_not_contains = None
        self._description_not_ends_with = None
        self._description_not_in = None
        self._description_not_starts_with = None
        self._description_starts_with = None
        self._entity_async_status = None
        self._entity_async_status_in = None
        self._entity_async_status_not = None
        self._entity_async_status_not_in = None
        self._firmware = None
        self._firmware_in = None
        self._firmware_not = None
        self._firmware_not_in = None
        self._ha = None
        self._ha_not = None
        self._id = None
        self._id_contains = None
        self._id_ends_with = None
        self._id_gt = None
        self._id_gte = None
        self._id_in = None
        self._id_lt = None
        self._id_lte = None
        self._id_not = None
        self._id_not_contains = None
        self._id_not_ends_with = None
        self._id_not_in = None
        self._id_not_starts_with = None
        self._id_starts_with = None
        self._io_policy = None
        self._io_policy_in = None
        self._io_policy_not = None
        self._io_policy_not_in = None
        self._labels_every = None
        self._labels_none = None
        self._labels_some = None
        self._local_created_at = None
        self._local_created_at_gt = None
        self._local_created_at_gte = None
        self._local_created_at_in = None
        self._local_created_at_lt = None
        self._local_created_at_lte = None
        self._local_created_at_not = None
        self._local_created_at_not_in = None
        self._local_id = None
        self._local_id_contains = None
        self._local_id_ends_with = None
        self._local_id_gt = None
        self._local_id_gte = None
        self._local_id_in = None
        self._local_id_lt = None
        self._local_id_lte = None
        self._local_id_not = None
        self._local_id_not_contains = None
        self._local_id_not_ends_with = None
        self._local_id_not_in = None
        self._local_id_not_starts_with = None
        self._local_id_starts_with = None
        self._max_bandwidth = None
        self._max_bandwidth_gt = None
        self._max_bandwidth_gte = None
        self._max_bandwidth_in = None
        self._max_bandwidth_lt = None
        self._max_bandwidth_lte = None
        self._max_bandwidth_not = None
        self._max_bandwidth_not_in = None
        self._max_bandwidth_policy = None
        self._max_bandwidth_policy_in = None
        self._max_bandwidth_policy_not = None
        self._max_bandwidth_policy_not_in = None
        self._max_iops = None
        self._max_iops_gt = None
        self._max_iops_gte = None
        self._max_iops_in = None
        self._max_iops_lt = None
        self._max_iops_lte = None
        self._max_iops_not = None
        self._max_iops_not_in = None
        self._max_iops_policy = None
        self._max_iops_policy_in = None
        self._max_iops_policy_not = None
        self._max_iops_policy_not_in = None
        self._memory = None
        self._memory_gt = None
        self._memory_gte = None
        self._memory_in = None
        self._memory_lt = None
        self._memory_lte = None
        self._memory_not = None
        self._memory_not_in = None
        self._name = None
        self._name_contains = None
        self._name_ends_with = None
        self._name_gt = None
        self._name_gte = None
        self._name_in = None
        self._name_lt = None
        self._name_lte = None
        self._name_not = None
        self._name_not_contains = None
        self._name_not_ends_with = None
        self._name_not_in = None
        self._name_not_starts_with = None
        self._name_starts_with = None
        self._size = None
        self._size_gt = None
        self._size_gte = None
        self._size_in = None
        self._size_lt = None
        self._size_lte = None
        self._size_not = None
        self._size_not_in = None
        self._vcpu = None
        self._vcpu_gt = None
        self._vcpu_gte = None
        self._vcpu_in = None
        self._vcpu_lt = None
        self._vcpu_lte = None
        self._vcpu_not = None
        self._vcpu_not_in = None
        self._video_type = None
        self._video_type_contains = None
        self._video_type_ends_with = None
        self._video_type_gt = None
        self._video_type_gte = None
        self._video_type_in = None
        self._video_type_lt = None
        self._video_type_lte = None
        self._video_type_not = None
        self._video_type_not_contains = None
        self._video_type_not_ends_with = None
        self._video_type_not_in = None
        self._video_type_not_starts_with = None
        self._video_type_starts_with = None
        self._win_opt = None
        self._win_opt_not = None
        self.discriminator = None

        self._and = kwargs.get("_and", None)
        self._not = kwargs.get("_not", None)
        self._or = kwargs.get("_or", None)
        self.clock_offset = kwargs.get("clock_offset", None)
        self.clock_offset_in = kwargs.get("clock_offset_in", None)
        self.clock_offset_not = kwargs.get("clock_offset_not", None)
        self.clock_offset_not_in = kwargs.get("clock_offset_not_in", None)
        self.cloud_init_supported = kwargs.get("cloud_init_supported", None)
        self.cloud_init_supported_not = kwargs.get("cloud_init_supported_not", None)
        self.cluster = kwargs.get("cluster", None)
        self.content_library_vm_template = kwargs.get("content_library_vm_template", None)
        self.cpu_model = kwargs.get("cpu_model", None)
        self.cpu_model_contains = kwargs.get("cpu_model_contains", None)
        self.cpu_model_ends_with = kwargs.get("cpu_model_ends_with", None)
        self.cpu_model_gt = kwargs.get("cpu_model_gt", None)
        self.cpu_model_gte = kwargs.get("cpu_model_gte", None)
        self.cpu_model_in = kwargs.get("cpu_model_in", None)
        self.cpu_model_lt = kwargs.get("cpu_model_lt", None)
        self.cpu_model_lte = kwargs.get("cpu_model_lte", None)
        self.cpu_model_not = kwargs.get("cpu_model_not", None)
        self.cpu_model_not_contains = kwargs.get("cpu_model_not_contains", None)
        self.cpu_model_not_ends_with = kwargs.get("cpu_model_not_ends_with", None)
        self.cpu_model_not_in = kwargs.get("cpu_model_not_in", None)
        self.cpu_model_not_starts_with = kwargs.get("cpu_model_not_starts_with", None)
        self.cpu_model_starts_with = kwargs.get("cpu_model_starts_with", None)
        self.description = kwargs.get("description", None)
        self.description_contains = kwargs.get("description_contains", None)
        self.description_ends_with = kwargs.get("description_ends_with", None)
        self.description_gt = kwargs.get("description_gt", None)
        self.description_gte = kwargs.get("description_gte", None)
        self.description_in = kwargs.get("description_in", None)
        self.description_lt = kwargs.get("description_lt", None)
        self.description_lte = kwargs.get("description_lte", None)
        self.description_not = kwargs.get("description_not", None)
        self.description_not_contains = kwargs.get("description_not_contains", None)
        self.description_not_ends_with = kwargs.get("description_not_ends_with", None)
        self.description_not_in = kwargs.get("description_not_in", None)
        self.description_not_starts_with = kwargs.get("description_not_starts_with", None)
        self.description_starts_with = kwargs.get("description_starts_with", None)
        self.entity_async_status = kwargs.get("entity_async_status", None)
        self.entity_async_status_in = kwargs.get("entity_async_status_in", None)
        self.entity_async_status_not = kwargs.get("entity_async_status_not", None)
        self.entity_async_status_not_in = kwargs.get("entity_async_status_not_in", None)
        self.firmware = kwargs.get("firmware", None)
        self.firmware_in = kwargs.get("firmware_in", None)
        self.firmware_not = kwargs.get("firmware_not", None)
        self.firmware_not_in = kwargs.get("firmware_not_in", None)
        self.ha = kwargs.get("ha", None)
        self.ha_not = kwargs.get("ha_not", None)
        self.id = kwargs.get("id", None)
        self.id_contains = kwargs.get("id_contains", None)
        self.id_ends_with = kwargs.get("id_ends_with", None)
        self.id_gt = kwargs.get("id_gt", None)
        self.id_gte = kwargs.get("id_gte", None)
        self.id_in = kwargs.get("id_in", None)
        self.id_lt = kwargs.get("id_lt", None)
        self.id_lte = kwargs.get("id_lte", None)
        self.id_not = kwargs.get("id_not", None)
        self.id_not_contains = kwargs.get("id_not_contains", None)
        self.id_not_ends_with = kwargs.get("id_not_ends_with", None)
        self.id_not_in = kwargs.get("id_not_in", None)
        self.id_not_starts_with = kwargs.get("id_not_starts_with", None)
        self.id_starts_with = kwargs.get("id_starts_with", None)
        self.io_policy = kwargs.get("io_policy", None)
        self.io_policy_in = kwargs.get("io_policy_in", None)
        self.io_policy_not = kwargs.get("io_policy_not", None)
        self.io_policy_not_in = kwargs.get("io_policy_not_in", None)
        self.labels_every = kwargs.get("labels_every", None)
        self.labels_none = kwargs.get("labels_none", None)
        self.labels_some = kwargs.get("labels_some", None)
        self.local_created_at = kwargs.get("local_created_at", None)
        self.local_created_at_gt = kwargs.get("local_created_at_gt", None)
        self.local_created_at_gte = kwargs.get("local_created_at_gte", None)
        self.local_created_at_in = kwargs.get("local_created_at_in", None)
        self.local_created_at_lt = kwargs.get("local_created_at_lt", None)
        self.local_created_at_lte = kwargs.get("local_created_at_lte", None)
        self.local_created_at_not = kwargs.get("local_created_at_not", None)
        self.local_created_at_not_in = kwargs.get("local_created_at_not_in", None)
        self.local_id = kwargs.get("local_id", None)
        self.local_id_contains = kwargs.get("local_id_contains", None)
        self.local_id_ends_with = kwargs.get("local_id_ends_with", None)
        self.local_id_gt = kwargs.get("local_id_gt", None)
        self.local_id_gte = kwargs.get("local_id_gte", None)
        self.local_id_in = kwargs.get("local_id_in", None)
        self.local_id_lt = kwargs.get("local_id_lt", None)
        self.local_id_lte = kwargs.get("local_id_lte", None)
        self.local_id_not = kwargs.get("local_id_not", None)
        self.local_id_not_contains = kwargs.get("local_id_not_contains", None)
        self.local_id_not_ends_with = kwargs.get("local_id_not_ends_with", None)
        self.local_id_not_in = kwargs.get("local_id_not_in", None)
        self.local_id_not_starts_with = kwargs.get("local_id_not_starts_with", None)
        self.local_id_starts_with = kwargs.get("local_id_starts_with", None)
        self.max_bandwidth = kwargs.get("max_bandwidth", None)
        self.max_bandwidth_gt = kwargs.get("max_bandwidth_gt", None)
        self.max_bandwidth_gte = kwargs.get("max_bandwidth_gte", None)
        self.max_bandwidth_in = kwargs.get("max_bandwidth_in", None)
        self.max_bandwidth_lt = kwargs.get("max_bandwidth_lt", None)
        self.max_bandwidth_lte = kwargs.get("max_bandwidth_lte", None)
        self.max_bandwidth_not = kwargs.get("max_bandwidth_not", None)
        self.max_bandwidth_not_in = kwargs.get("max_bandwidth_not_in", None)
        self.max_bandwidth_policy = kwargs.get("max_bandwidth_policy", None)
        self.max_bandwidth_policy_in = kwargs.get("max_bandwidth_policy_in", None)
        self.max_bandwidth_policy_not = kwargs.get("max_bandwidth_policy_not", None)
        self.max_bandwidth_policy_not_in = kwargs.get("max_bandwidth_policy_not_in", None)
        self.max_iops = kwargs.get("max_iops", None)
        self.max_iops_gt = kwargs.get("max_iops_gt", None)
        self.max_iops_gte = kwargs.get("max_iops_gte", None)
        self.max_iops_in = kwargs.get("max_iops_in", None)
        self.max_iops_lt = kwargs.get("max_iops_lt", None)
        self.max_iops_lte = kwargs.get("max_iops_lte", None)
        self.max_iops_not = kwargs.get("max_iops_not", None)
        self.max_iops_not_in = kwargs.get("max_iops_not_in", None)
        self.max_iops_policy = kwargs.get("max_iops_policy", None)
        self.max_iops_policy_in = kwargs.get("max_iops_policy_in", None)
        self.max_iops_policy_not = kwargs.get("max_iops_policy_not", None)
        self.max_iops_policy_not_in = kwargs.get("max_iops_policy_not_in", None)
        self.memory = kwargs.get("memory", None)
        self.memory_gt = kwargs.get("memory_gt", None)
        self.memory_gte = kwargs.get("memory_gte", None)
        self.memory_in = kwargs.get("memory_in", None)
        self.memory_lt = kwargs.get("memory_lt", None)
        self.memory_lte = kwargs.get("memory_lte", None)
        self.memory_not = kwargs.get("memory_not", None)
        self.memory_not_in = kwargs.get("memory_not_in", None)
        self.name = kwargs.get("name", None)
        self.name_contains = kwargs.get("name_contains", None)
        self.name_ends_with = kwargs.get("name_ends_with", None)
        self.name_gt = kwargs.get("name_gt", None)
        self.name_gte = kwargs.get("name_gte", None)
        self.name_in = kwargs.get("name_in", None)
        self.name_lt = kwargs.get("name_lt", None)
        self.name_lte = kwargs.get("name_lte", None)
        self.name_not = kwargs.get("name_not", None)
        self.name_not_contains = kwargs.get("name_not_contains", None)
        self.name_not_ends_with = kwargs.get("name_not_ends_with", None)
        self.name_not_in = kwargs.get("name_not_in", None)
        self.name_not_starts_with = kwargs.get("name_not_starts_with", None)
        self.name_starts_with = kwargs.get("name_starts_with", None)
        self.size = kwargs.get("size", None)
        self.size_gt = kwargs.get("size_gt", None)
        self.size_gte = kwargs.get("size_gte", None)
        self.size_in = kwargs.get("size_in", None)
        self.size_lt = kwargs.get("size_lt", None)
        self.size_lte = kwargs.get("size_lte", None)
        self.size_not = kwargs.get("size_not", None)
        self.size_not_in = kwargs.get("size_not_in", None)
        self.vcpu = kwargs.get("vcpu", None)
        self.vcpu_gt = kwargs.get("vcpu_gt", None)
        self.vcpu_gte = kwargs.get("vcpu_gte", None)
        self.vcpu_in = kwargs.get("vcpu_in", None)
        self.vcpu_lt = kwargs.get("vcpu_lt", None)
        self.vcpu_lte = kwargs.get("vcpu_lte", None)
        self.vcpu_not = kwargs.get("vcpu_not", None)
        self.vcpu_not_in = kwargs.get("vcpu_not_in", None)
        self.video_type = kwargs.get("video_type", None)
        self.video_type_contains = kwargs.get("video_type_contains", None)
        self.video_type_ends_with = kwargs.get("video_type_ends_with", None)
        self.video_type_gt = kwargs.get("video_type_gt", None)
        self.video_type_gte = kwargs.get("video_type_gte", None)
        self.video_type_in = kwargs.get("video_type_in", None)
        self.video_type_lt = kwargs.get("video_type_lt", None)
        self.video_type_lte = kwargs.get("video_type_lte", None)
        self.video_type_not = kwargs.get("video_type_not", None)
        self.video_type_not_contains = kwargs.get("video_type_not_contains", None)
        self.video_type_not_ends_with = kwargs.get("video_type_not_ends_with", None)
        self.video_type_not_in = kwargs.get("video_type_not_in", None)
        self.video_type_not_starts_with = kwargs.get("video_type_not_starts_with", None)
        self.video_type_starts_with = kwargs.get("video_type_starts_with", None)
        self.win_opt = kwargs.get("win_opt", None)
        self.win_opt_not = kwargs.get("win_opt_not", None)

    @property
    def _and(self):
        """Gets the _and of this VmTemplateWhereInput.  # noqa: E501


        :return: The _and of this VmTemplateWhereInput.  # noqa: E501
        :rtype: list[VmTemplateWhereInput]
        """
        return self.__and

    @_and.setter
    def _and(self, _and):
        """Sets the _and of this VmTemplateWhereInput.


        :param _and: The _and of this VmTemplateWhereInput.  # noqa: E501
        :type _and: list[VmTemplateWhereInput]
        """

        self.__and = _and

    @property
    def _not(self):
        """Gets the _not of this VmTemplateWhereInput.  # noqa: E501


        :return: The _not of this VmTemplateWhereInput.  # noqa: E501
        :rtype: list[VmTemplateWhereInput]
        """
        return self.__not

    @_not.setter
    def _not(self, _not):
        """Sets the _not of this VmTemplateWhereInput.


        :param _not: The _not of this VmTemplateWhereInput.  # noqa: E501
        :type _not: list[VmTemplateWhereInput]
        """

        self.__not = _not

    @property
    def _or(self):
        """Gets the _or of this VmTemplateWhereInput.  # noqa: E501


        :return: The _or of this VmTemplateWhereInput.  # noqa: E501
        :rtype: list[VmTemplateWhereInput]
        """
        return self.__or

    @_or.setter
    def _or(self, _or):
        """Sets the _or of this VmTemplateWhereInput.


        :param _or: The _or of this VmTemplateWhereInput.  # noqa: E501
        :type _or: list[VmTemplateWhereInput]
        """

        self.__or = _or

    @property
    def clock_offset(self):
        """Gets the clock_offset of this VmTemplateWhereInput.  # noqa: E501


        :return: The clock_offset of this VmTemplateWhereInput.  # noqa: E501
        :rtype: VmClockOffset
        """
        return self._clock_offset

    @clock_offset.setter
    def clock_offset(self, clock_offset):
        """Sets the clock_offset of this VmTemplateWhereInput.


        :param clock_offset: The clock_offset of this VmTemplateWhereInput.  # noqa: E501
        :type clock_offset: VmClockOffset
        """

        self._clock_offset = clock_offset

    @property
    def clock_offset_in(self):
        """Gets the clock_offset_in of this VmTemplateWhereInput.  # noqa: E501


        :return: The clock_offset_in of this VmTemplateWhereInput.  # noqa: E501
        :rtype: list[VmClockOffset]
        """
        return self._clock_offset_in

    @clock_offset_in.setter
    def clock_offset_in(self, clock_offset_in):
        """Sets the clock_offset_in of this VmTemplateWhereInput.


        :param clock_offset_in: The clock_offset_in of this VmTemplateWhereInput.  # noqa: E501
        :type clock_offset_in: list[VmClockOffset]
        """

        self._clock_offset_in = clock_offset_in

    @property
    def clock_offset_not(self):
        """Gets the clock_offset_not of this VmTemplateWhereInput.  # noqa: E501


        :return: The clock_offset_not of this VmTemplateWhereInput.  # noqa: E501
        :rtype: VmClockOffset
        """
        return self._clock_offset_not

    @clock_offset_not.setter
    def clock_offset_not(self, clock_offset_not):
        """Sets the clock_offset_not of this VmTemplateWhereInput.


        :param clock_offset_not: The clock_offset_not of this VmTemplateWhereInput.  # noqa: E501
        :type clock_offset_not: VmClockOffset
        """

        self._clock_offset_not = clock_offset_not

    @property
    def clock_offset_not_in(self):
        """Gets the clock_offset_not_in of this VmTemplateWhereInput.  # noqa: E501


        :return: The clock_offset_not_in of this VmTemplateWhereInput.  # noqa: E501
        :rtype: list[VmClockOffset]
        """
        return self._clock_offset_not_in

    @clock_offset_not_in.setter
    def clock_offset_not_in(self, clock_offset_not_in):
        """Sets the clock_offset_not_in of this VmTemplateWhereInput.


        :param clock_offset_not_in: The clock_offset_not_in of this VmTemplateWhereInput.  # noqa: E501
        :type clock_offset_not_in: list[VmClockOffset]
        """

        self._clock_offset_not_in = clock_offset_not_in

    @property
    def cloud_init_supported(self):
        """Gets the cloud_init_supported of this VmTemplateWhereInput.  # noqa: E501


        :return: The cloud_init_supported of this VmTemplateWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._cloud_init_supported

    @cloud_init_supported.setter
    def cloud_init_supported(self, cloud_init_supported):
        """Sets the cloud_init_supported of this VmTemplateWhereInput.


        :param cloud_init_supported: The cloud_init_supported of this VmTemplateWhereInput.  # noqa: E501
        :type cloud_init_supported: bool
        """

        self._cloud_init_supported = cloud_init_supported

    @property
    def cloud_init_supported_not(self):
        """Gets the cloud_init_supported_not of this VmTemplateWhereInput.  # noqa: E501


        :return: The cloud_init_supported_not of this VmTemplateWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._cloud_init_supported_not

    @cloud_init_supported_not.setter
    def cloud_init_supported_not(self, cloud_init_supported_not):
        """Sets the cloud_init_supported_not of this VmTemplateWhereInput.


        :param cloud_init_supported_not: The cloud_init_supported_not of this VmTemplateWhereInput.  # noqa: E501
        :type cloud_init_supported_not: bool
        """

        self._cloud_init_supported_not = cloud_init_supported_not

    @property
    def cluster(self):
        """Gets the cluster of this VmTemplateWhereInput.  # noqa: E501


        :return: The cluster of this VmTemplateWhereInput.  # noqa: E501
        :rtype: ClusterWhereInput
        """
        return self._cluster

    @cluster.setter
    def cluster(self, cluster):
        """Sets the cluster of this VmTemplateWhereInput.


        :param cluster: The cluster of this VmTemplateWhereInput.  # noqa: E501
        :type cluster: ClusterWhereInput
        """

        self._cluster = cluster

    @property
    def content_library_vm_template(self):
        """Gets the content_library_vm_template of this VmTemplateWhereInput.  # noqa: E501


        :return: The content_library_vm_template of this VmTemplateWhereInput.  # noqa: E501
        :rtype: ContentLibraryVmTemplateWhereInput
        """
        return self._content_library_vm_template

    @content_library_vm_template.setter
    def content_library_vm_template(self, content_library_vm_template):
        """Sets the content_library_vm_template of this VmTemplateWhereInput.


        :param content_library_vm_template: The content_library_vm_template of this VmTemplateWhereInput.  # noqa: E501
        :type content_library_vm_template: ContentLibraryVmTemplateWhereInput
        """

        self._content_library_vm_template = content_library_vm_template

    @property
    def cpu_model(self):
        """Gets the cpu_model of this VmTemplateWhereInput.  # noqa: E501


        :return: The cpu_model of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cpu_model

    @cpu_model.setter
    def cpu_model(self, cpu_model):
        """Sets the cpu_model of this VmTemplateWhereInput.


        :param cpu_model: The cpu_model of this VmTemplateWhereInput.  # noqa: E501
        :type cpu_model: str
        """

        self._cpu_model = cpu_model

    @property
    def cpu_model_contains(self):
        """Gets the cpu_model_contains of this VmTemplateWhereInput.  # noqa: E501


        :return: The cpu_model_contains of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cpu_model_contains

    @cpu_model_contains.setter
    def cpu_model_contains(self, cpu_model_contains):
        """Sets the cpu_model_contains of this VmTemplateWhereInput.


        :param cpu_model_contains: The cpu_model_contains of this VmTemplateWhereInput.  # noqa: E501
        :type cpu_model_contains: str
        """

        self._cpu_model_contains = cpu_model_contains

    @property
    def cpu_model_ends_with(self):
        """Gets the cpu_model_ends_with of this VmTemplateWhereInput.  # noqa: E501


        :return: The cpu_model_ends_with of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cpu_model_ends_with

    @cpu_model_ends_with.setter
    def cpu_model_ends_with(self, cpu_model_ends_with):
        """Sets the cpu_model_ends_with of this VmTemplateWhereInput.


        :param cpu_model_ends_with: The cpu_model_ends_with of this VmTemplateWhereInput.  # noqa: E501
        :type cpu_model_ends_with: str
        """

        self._cpu_model_ends_with = cpu_model_ends_with

    @property
    def cpu_model_gt(self):
        """Gets the cpu_model_gt of this VmTemplateWhereInput.  # noqa: E501


        :return: The cpu_model_gt of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cpu_model_gt

    @cpu_model_gt.setter
    def cpu_model_gt(self, cpu_model_gt):
        """Sets the cpu_model_gt of this VmTemplateWhereInput.


        :param cpu_model_gt: The cpu_model_gt of this VmTemplateWhereInput.  # noqa: E501
        :type cpu_model_gt: str
        """

        self._cpu_model_gt = cpu_model_gt

    @property
    def cpu_model_gte(self):
        """Gets the cpu_model_gte of this VmTemplateWhereInput.  # noqa: E501


        :return: The cpu_model_gte of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cpu_model_gte

    @cpu_model_gte.setter
    def cpu_model_gte(self, cpu_model_gte):
        """Sets the cpu_model_gte of this VmTemplateWhereInput.


        :param cpu_model_gte: The cpu_model_gte of this VmTemplateWhereInput.  # noqa: E501
        :type cpu_model_gte: str
        """

        self._cpu_model_gte = cpu_model_gte

    @property
    def cpu_model_in(self):
        """Gets the cpu_model_in of this VmTemplateWhereInput.  # noqa: E501


        :return: The cpu_model_in of this VmTemplateWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._cpu_model_in

    @cpu_model_in.setter
    def cpu_model_in(self, cpu_model_in):
        """Sets the cpu_model_in of this VmTemplateWhereInput.


        :param cpu_model_in: The cpu_model_in of this VmTemplateWhereInput.  # noqa: E501
        :type cpu_model_in: list[str]
        """

        self._cpu_model_in = cpu_model_in

    @property
    def cpu_model_lt(self):
        """Gets the cpu_model_lt of this VmTemplateWhereInput.  # noqa: E501


        :return: The cpu_model_lt of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cpu_model_lt

    @cpu_model_lt.setter
    def cpu_model_lt(self, cpu_model_lt):
        """Sets the cpu_model_lt of this VmTemplateWhereInput.


        :param cpu_model_lt: The cpu_model_lt of this VmTemplateWhereInput.  # noqa: E501
        :type cpu_model_lt: str
        """

        self._cpu_model_lt = cpu_model_lt

    @property
    def cpu_model_lte(self):
        """Gets the cpu_model_lte of this VmTemplateWhereInput.  # noqa: E501


        :return: The cpu_model_lte of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cpu_model_lte

    @cpu_model_lte.setter
    def cpu_model_lte(self, cpu_model_lte):
        """Sets the cpu_model_lte of this VmTemplateWhereInput.


        :param cpu_model_lte: The cpu_model_lte of this VmTemplateWhereInput.  # noqa: E501
        :type cpu_model_lte: str
        """

        self._cpu_model_lte = cpu_model_lte

    @property
    def cpu_model_not(self):
        """Gets the cpu_model_not of this VmTemplateWhereInput.  # noqa: E501


        :return: The cpu_model_not of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cpu_model_not

    @cpu_model_not.setter
    def cpu_model_not(self, cpu_model_not):
        """Sets the cpu_model_not of this VmTemplateWhereInput.


        :param cpu_model_not: The cpu_model_not of this VmTemplateWhereInput.  # noqa: E501
        :type cpu_model_not: str
        """

        self._cpu_model_not = cpu_model_not

    @property
    def cpu_model_not_contains(self):
        """Gets the cpu_model_not_contains of this VmTemplateWhereInput.  # noqa: E501


        :return: The cpu_model_not_contains of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cpu_model_not_contains

    @cpu_model_not_contains.setter
    def cpu_model_not_contains(self, cpu_model_not_contains):
        """Sets the cpu_model_not_contains of this VmTemplateWhereInput.


        :param cpu_model_not_contains: The cpu_model_not_contains of this VmTemplateWhereInput.  # noqa: E501
        :type cpu_model_not_contains: str
        """

        self._cpu_model_not_contains = cpu_model_not_contains

    @property
    def cpu_model_not_ends_with(self):
        """Gets the cpu_model_not_ends_with of this VmTemplateWhereInput.  # noqa: E501


        :return: The cpu_model_not_ends_with of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cpu_model_not_ends_with

    @cpu_model_not_ends_with.setter
    def cpu_model_not_ends_with(self, cpu_model_not_ends_with):
        """Sets the cpu_model_not_ends_with of this VmTemplateWhereInput.


        :param cpu_model_not_ends_with: The cpu_model_not_ends_with of this VmTemplateWhereInput.  # noqa: E501
        :type cpu_model_not_ends_with: str
        """

        self._cpu_model_not_ends_with = cpu_model_not_ends_with

    @property
    def cpu_model_not_in(self):
        """Gets the cpu_model_not_in of this VmTemplateWhereInput.  # noqa: E501


        :return: The cpu_model_not_in of this VmTemplateWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._cpu_model_not_in

    @cpu_model_not_in.setter
    def cpu_model_not_in(self, cpu_model_not_in):
        """Sets the cpu_model_not_in of this VmTemplateWhereInput.


        :param cpu_model_not_in: The cpu_model_not_in of this VmTemplateWhereInput.  # noqa: E501
        :type cpu_model_not_in: list[str]
        """

        self._cpu_model_not_in = cpu_model_not_in

    @property
    def cpu_model_not_starts_with(self):
        """Gets the cpu_model_not_starts_with of this VmTemplateWhereInput.  # noqa: E501


        :return: The cpu_model_not_starts_with of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cpu_model_not_starts_with

    @cpu_model_not_starts_with.setter
    def cpu_model_not_starts_with(self, cpu_model_not_starts_with):
        """Sets the cpu_model_not_starts_with of this VmTemplateWhereInput.


        :param cpu_model_not_starts_with: The cpu_model_not_starts_with of this VmTemplateWhereInput.  # noqa: E501
        :type cpu_model_not_starts_with: str
        """

        self._cpu_model_not_starts_with = cpu_model_not_starts_with

    @property
    def cpu_model_starts_with(self):
        """Gets the cpu_model_starts_with of this VmTemplateWhereInput.  # noqa: E501


        :return: The cpu_model_starts_with of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cpu_model_starts_with

    @cpu_model_starts_with.setter
    def cpu_model_starts_with(self, cpu_model_starts_with):
        """Sets the cpu_model_starts_with of this VmTemplateWhereInput.


        :param cpu_model_starts_with: The cpu_model_starts_with of this VmTemplateWhereInput.  # noqa: E501
        :type cpu_model_starts_with: str
        """

        self._cpu_model_starts_with = cpu_model_starts_with

    @property
    def description(self):
        """Gets the description of this VmTemplateWhereInput.  # noqa: E501


        :return: The description of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this VmTemplateWhereInput.


        :param description: The description of this VmTemplateWhereInput.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def description_contains(self):
        """Gets the description_contains of this VmTemplateWhereInput.  # noqa: E501


        :return: The description_contains of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_contains

    @description_contains.setter
    def description_contains(self, description_contains):
        """Sets the description_contains of this VmTemplateWhereInput.


        :param description_contains: The description_contains of this VmTemplateWhereInput.  # noqa: E501
        :type description_contains: str
        """

        self._description_contains = description_contains

    @property
    def description_ends_with(self):
        """Gets the description_ends_with of this VmTemplateWhereInput.  # noqa: E501


        :return: The description_ends_with of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_ends_with

    @description_ends_with.setter
    def description_ends_with(self, description_ends_with):
        """Sets the description_ends_with of this VmTemplateWhereInput.


        :param description_ends_with: The description_ends_with of this VmTemplateWhereInput.  # noqa: E501
        :type description_ends_with: str
        """

        self._description_ends_with = description_ends_with

    @property
    def description_gt(self):
        """Gets the description_gt of this VmTemplateWhereInput.  # noqa: E501


        :return: The description_gt of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_gt

    @description_gt.setter
    def description_gt(self, description_gt):
        """Sets the description_gt of this VmTemplateWhereInput.


        :param description_gt: The description_gt of this VmTemplateWhereInput.  # noqa: E501
        :type description_gt: str
        """

        self._description_gt = description_gt

    @property
    def description_gte(self):
        """Gets the description_gte of this VmTemplateWhereInput.  # noqa: E501


        :return: The description_gte of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_gte

    @description_gte.setter
    def description_gte(self, description_gte):
        """Sets the description_gte of this VmTemplateWhereInput.


        :param description_gte: The description_gte of this VmTemplateWhereInput.  # noqa: E501
        :type description_gte: str
        """

        self._description_gte = description_gte

    @property
    def description_in(self):
        """Gets the description_in of this VmTemplateWhereInput.  # noqa: E501


        :return: The description_in of this VmTemplateWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._description_in

    @description_in.setter
    def description_in(self, description_in):
        """Sets the description_in of this VmTemplateWhereInput.


        :param description_in: The description_in of this VmTemplateWhereInput.  # noqa: E501
        :type description_in: list[str]
        """

        self._description_in = description_in

    @property
    def description_lt(self):
        """Gets the description_lt of this VmTemplateWhereInput.  # noqa: E501


        :return: The description_lt of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_lt

    @description_lt.setter
    def description_lt(self, description_lt):
        """Sets the description_lt of this VmTemplateWhereInput.


        :param description_lt: The description_lt of this VmTemplateWhereInput.  # noqa: E501
        :type description_lt: str
        """

        self._description_lt = description_lt

    @property
    def description_lte(self):
        """Gets the description_lte of this VmTemplateWhereInput.  # noqa: E501


        :return: The description_lte of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_lte

    @description_lte.setter
    def description_lte(self, description_lte):
        """Sets the description_lte of this VmTemplateWhereInput.


        :param description_lte: The description_lte of this VmTemplateWhereInput.  # noqa: E501
        :type description_lte: str
        """

        self._description_lte = description_lte

    @property
    def description_not(self):
        """Gets the description_not of this VmTemplateWhereInput.  # noqa: E501


        :return: The description_not of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_not

    @description_not.setter
    def description_not(self, description_not):
        """Sets the description_not of this VmTemplateWhereInput.


        :param description_not: The description_not of this VmTemplateWhereInput.  # noqa: E501
        :type description_not: str
        """

        self._description_not = description_not

    @property
    def description_not_contains(self):
        """Gets the description_not_contains of this VmTemplateWhereInput.  # noqa: E501


        :return: The description_not_contains of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_not_contains

    @description_not_contains.setter
    def description_not_contains(self, description_not_contains):
        """Sets the description_not_contains of this VmTemplateWhereInput.


        :param description_not_contains: The description_not_contains of this VmTemplateWhereInput.  # noqa: E501
        :type description_not_contains: str
        """

        self._description_not_contains = description_not_contains

    @property
    def description_not_ends_with(self):
        """Gets the description_not_ends_with of this VmTemplateWhereInput.  # noqa: E501


        :return: The description_not_ends_with of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_not_ends_with

    @description_not_ends_with.setter
    def description_not_ends_with(self, description_not_ends_with):
        """Sets the description_not_ends_with of this VmTemplateWhereInput.


        :param description_not_ends_with: The description_not_ends_with of this VmTemplateWhereInput.  # noqa: E501
        :type description_not_ends_with: str
        """

        self._description_not_ends_with = description_not_ends_with

    @property
    def description_not_in(self):
        """Gets the description_not_in of this VmTemplateWhereInput.  # noqa: E501


        :return: The description_not_in of this VmTemplateWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._description_not_in

    @description_not_in.setter
    def description_not_in(self, description_not_in):
        """Sets the description_not_in of this VmTemplateWhereInput.


        :param description_not_in: The description_not_in of this VmTemplateWhereInput.  # noqa: E501
        :type description_not_in: list[str]
        """

        self._description_not_in = description_not_in

    @property
    def description_not_starts_with(self):
        """Gets the description_not_starts_with of this VmTemplateWhereInput.  # noqa: E501


        :return: The description_not_starts_with of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_not_starts_with

    @description_not_starts_with.setter
    def description_not_starts_with(self, description_not_starts_with):
        """Sets the description_not_starts_with of this VmTemplateWhereInput.


        :param description_not_starts_with: The description_not_starts_with of this VmTemplateWhereInput.  # noqa: E501
        :type description_not_starts_with: str
        """

        self._description_not_starts_with = description_not_starts_with

    @property
    def description_starts_with(self):
        """Gets the description_starts_with of this VmTemplateWhereInput.  # noqa: E501


        :return: The description_starts_with of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_starts_with

    @description_starts_with.setter
    def description_starts_with(self, description_starts_with):
        """Sets the description_starts_with of this VmTemplateWhereInput.


        :param description_starts_with: The description_starts_with of this VmTemplateWhereInput.  # noqa: E501
        :type description_starts_with: str
        """

        self._description_starts_with = description_starts_with

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this VmTemplateWhereInput.  # noqa: E501


        :return: The entity_async_status of this VmTemplateWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this VmTemplateWhereInput.


        :param entity_async_status: The entity_async_status of this VmTemplateWhereInput.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def entity_async_status_in(self):
        """Gets the entity_async_status_in of this VmTemplateWhereInput.  # noqa: E501


        :return: The entity_async_status_in of this VmTemplateWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_in

    @entity_async_status_in.setter
    def entity_async_status_in(self, entity_async_status_in):
        """Sets the entity_async_status_in of this VmTemplateWhereInput.


        :param entity_async_status_in: The entity_async_status_in of this VmTemplateWhereInput.  # noqa: E501
        :type entity_async_status_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_in = entity_async_status_in

    @property
    def entity_async_status_not(self):
        """Gets the entity_async_status_not of this VmTemplateWhereInput.  # noqa: E501


        :return: The entity_async_status_not of this VmTemplateWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status_not

    @entity_async_status_not.setter
    def entity_async_status_not(self, entity_async_status_not):
        """Sets the entity_async_status_not of this VmTemplateWhereInput.


        :param entity_async_status_not: The entity_async_status_not of this VmTemplateWhereInput.  # noqa: E501
        :type entity_async_status_not: EntityAsyncStatus
        """

        self._entity_async_status_not = entity_async_status_not

    @property
    def entity_async_status_not_in(self):
        """Gets the entity_async_status_not_in of this VmTemplateWhereInput.  # noqa: E501


        :return: The entity_async_status_not_in of this VmTemplateWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_not_in

    @entity_async_status_not_in.setter
    def entity_async_status_not_in(self, entity_async_status_not_in):
        """Sets the entity_async_status_not_in of this VmTemplateWhereInput.


        :param entity_async_status_not_in: The entity_async_status_not_in of this VmTemplateWhereInput.  # noqa: E501
        :type entity_async_status_not_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_not_in = entity_async_status_not_in

    @property
    def firmware(self):
        """Gets the firmware of this VmTemplateWhereInput.  # noqa: E501


        :return: The firmware of this VmTemplateWhereInput.  # noqa: E501
        :rtype: VmFirmware
        """
        return self._firmware

    @firmware.setter
    def firmware(self, firmware):
        """Sets the firmware of this VmTemplateWhereInput.


        :param firmware: The firmware of this VmTemplateWhereInput.  # noqa: E501
        :type firmware: VmFirmware
        """

        self._firmware = firmware

    @property
    def firmware_in(self):
        """Gets the firmware_in of this VmTemplateWhereInput.  # noqa: E501


        :return: The firmware_in of this VmTemplateWhereInput.  # noqa: E501
        :rtype: list[VmFirmware]
        """
        return self._firmware_in

    @firmware_in.setter
    def firmware_in(self, firmware_in):
        """Sets the firmware_in of this VmTemplateWhereInput.


        :param firmware_in: The firmware_in of this VmTemplateWhereInput.  # noqa: E501
        :type firmware_in: list[VmFirmware]
        """

        self._firmware_in = firmware_in

    @property
    def firmware_not(self):
        """Gets the firmware_not of this VmTemplateWhereInput.  # noqa: E501


        :return: The firmware_not of this VmTemplateWhereInput.  # noqa: E501
        :rtype: VmFirmware
        """
        return self._firmware_not

    @firmware_not.setter
    def firmware_not(self, firmware_not):
        """Sets the firmware_not of this VmTemplateWhereInput.


        :param firmware_not: The firmware_not of this VmTemplateWhereInput.  # noqa: E501
        :type firmware_not: VmFirmware
        """

        self._firmware_not = firmware_not

    @property
    def firmware_not_in(self):
        """Gets the firmware_not_in of this VmTemplateWhereInput.  # noqa: E501


        :return: The firmware_not_in of this VmTemplateWhereInput.  # noqa: E501
        :rtype: list[VmFirmware]
        """
        return self._firmware_not_in

    @firmware_not_in.setter
    def firmware_not_in(self, firmware_not_in):
        """Sets the firmware_not_in of this VmTemplateWhereInput.


        :param firmware_not_in: The firmware_not_in of this VmTemplateWhereInput.  # noqa: E501
        :type firmware_not_in: list[VmFirmware]
        """

        self._firmware_not_in = firmware_not_in

    @property
    def ha(self):
        """Gets the ha of this VmTemplateWhereInput.  # noqa: E501


        :return: The ha of this VmTemplateWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._ha

    @ha.setter
    def ha(self, ha):
        """Sets the ha of this VmTemplateWhereInput.


        :param ha: The ha of this VmTemplateWhereInput.  # noqa: E501
        :type ha: bool
        """

        self._ha = ha

    @property
    def ha_not(self):
        """Gets the ha_not of this VmTemplateWhereInput.  # noqa: E501


        :return: The ha_not of this VmTemplateWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._ha_not

    @ha_not.setter
    def ha_not(self, ha_not):
        """Sets the ha_not of this VmTemplateWhereInput.


        :param ha_not: The ha_not of this VmTemplateWhereInput.  # noqa: E501
        :type ha_not: bool
        """

        self._ha_not = ha_not

    @property
    def id(self):
        """Gets the id of this VmTemplateWhereInput.  # noqa: E501


        :return: The id of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this VmTemplateWhereInput.


        :param id: The id of this VmTemplateWhereInput.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def id_contains(self):
        """Gets the id_contains of this VmTemplateWhereInput.  # noqa: E501


        :return: The id_contains of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_contains

    @id_contains.setter
    def id_contains(self, id_contains):
        """Sets the id_contains of this VmTemplateWhereInput.


        :param id_contains: The id_contains of this VmTemplateWhereInput.  # noqa: E501
        :type id_contains: str
        """

        self._id_contains = id_contains

    @property
    def id_ends_with(self):
        """Gets the id_ends_with of this VmTemplateWhereInput.  # noqa: E501


        :return: The id_ends_with of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_ends_with

    @id_ends_with.setter
    def id_ends_with(self, id_ends_with):
        """Sets the id_ends_with of this VmTemplateWhereInput.


        :param id_ends_with: The id_ends_with of this VmTemplateWhereInput.  # noqa: E501
        :type id_ends_with: str
        """

        self._id_ends_with = id_ends_with

    @property
    def id_gt(self):
        """Gets the id_gt of this VmTemplateWhereInput.  # noqa: E501


        :return: The id_gt of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gt

    @id_gt.setter
    def id_gt(self, id_gt):
        """Sets the id_gt of this VmTemplateWhereInput.


        :param id_gt: The id_gt of this VmTemplateWhereInput.  # noqa: E501
        :type id_gt: str
        """

        self._id_gt = id_gt

    @property
    def id_gte(self):
        """Gets the id_gte of this VmTemplateWhereInput.  # noqa: E501


        :return: The id_gte of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gte

    @id_gte.setter
    def id_gte(self, id_gte):
        """Sets the id_gte of this VmTemplateWhereInput.


        :param id_gte: The id_gte of this VmTemplateWhereInput.  # noqa: E501
        :type id_gte: str
        """

        self._id_gte = id_gte

    @property
    def id_in(self):
        """Gets the id_in of this VmTemplateWhereInput.  # noqa: E501


        :return: The id_in of this VmTemplateWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_in

    @id_in.setter
    def id_in(self, id_in):
        """Sets the id_in of this VmTemplateWhereInput.


        :param id_in: The id_in of this VmTemplateWhereInput.  # noqa: E501
        :type id_in: list[str]
        """

        self._id_in = id_in

    @property
    def id_lt(self):
        """Gets the id_lt of this VmTemplateWhereInput.  # noqa: E501


        :return: The id_lt of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lt

    @id_lt.setter
    def id_lt(self, id_lt):
        """Sets the id_lt of this VmTemplateWhereInput.


        :param id_lt: The id_lt of this VmTemplateWhereInput.  # noqa: E501
        :type id_lt: str
        """

        self._id_lt = id_lt

    @property
    def id_lte(self):
        """Gets the id_lte of this VmTemplateWhereInput.  # noqa: E501


        :return: The id_lte of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lte

    @id_lte.setter
    def id_lte(self, id_lte):
        """Sets the id_lte of this VmTemplateWhereInput.


        :param id_lte: The id_lte of this VmTemplateWhereInput.  # noqa: E501
        :type id_lte: str
        """

        self._id_lte = id_lte

    @property
    def id_not(self):
        """Gets the id_not of this VmTemplateWhereInput.  # noqa: E501


        :return: The id_not of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not

    @id_not.setter
    def id_not(self, id_not):
        """Sets the id_not of this VmTemplateWhereInput.


        :param id_not: The id_not of this VmTemplateWhereInput.  # noqa: E501
        :type id_not: str
        """

        self._id_not = id_not

    @property
    def id_not_contains(self):
        """Gets the id_not_contains of this VmTemplateWhereInput.  # noqa: E501


        :return: The id_not_contains of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_contains

    @id_not_contains.setter
    def id_not_contains(self, id_not_contains):
        """Sets the id_not_contains of this VmTemplateWhereInput.


        :param id_not_contains: The id_not_contains of this VmTemplateWhereInput.  # noqa: E501
        :type id_not_contains: str
        """

        self._id_not_contains = id_not_contains

    @property
    def id_not_ends_with(self):
        """Gets the id_not_ends_with of this VmTemplateWhereInput.  # noqa: E501


        :return: The id_not_ends_with of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_ends_with

    @id_not_ends_with.setter
    def id_not_ends_with(self, id_not_ends_with):
        """Sets the id_not_ends_with of this VmTemplateWhereInput.


        :param id_not_ends_with: The id_not_ends_with of this VmTemplateWhereInput.  # noqa: E501
        :type id_not_ends_with: str
        """

        self._id_not_ends_with = id_not_ends_with

    @property
    def id_not_in(self):
        """Gets the id_not_in of this VmTemplateWhereInput.  # noqa: E501


        :return: The id_not_in of this VmTemplateWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_not_in

    @id_not_in.setter
    def id_not_in(self, id_not_in):
        """Sets the id_not_in of this VmTemplateWhereInput.


        :param id_not_in: The id_not_in of this VmTemplateWhereInput.  # noqa: E501
        :type id_not_in: list[str]
        """

        self._id_not_in = id_not_in

    @property
    def id_not_starts_with(self):
        """Gets the id_not_starts_with of this VmTemplateWhereInput.  # noqa: E501


        :return: The id_not_starts_with of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_starts_with

    @id_not_starts_with.setter
    def id_not_starts_with(self, id_not_starts_with):
        """Sets the id_not_starts_with of this VmTemplateWhereInput.


        :param id_not_starts_with: The id_not_starts_with of this VmTemplateWhereInput.  # noqa: E501
        :type id_not_starts_with: str
        """

        self._id_not_starts_with = id_not_starts_with

    @property
    def id_starts_with(self):
        """Gets the id_starts_with of this VmTemplateWhereInput.  # noqa: E501


        :return: The id_starts_with of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_starts_with

    @id_starts_with.setter
    def id_starts_with(self, id_starts_with):
        """Sets the id_starts_with of this VmTemplateWhereInput.


        :param id_starts_with: The id_starts_with of this VmTemplateWhereInput.  # noqa: E501
        :type id_starts_with: str
        """

        self._id_starts_with = id_starts_with

    @property
    def io_policy(self):
        """Gets the io_policy of this VmTemplateWhereInput.  # noqa: E501


        :return: The io_policy of this VmTemplateWhereInput.  # noqa: E501
        :rtype: VmDiskIoPolicy
        """
        return self._io_policy

    @io_policy.setter
    def io_policy(self, io_policy):
        """Sets the io_policy of this VmTemplateWhereInput.


        :param io_policy: The io_policy of this VmTemplateWhereInput.  # noqa: E501
        :type io_policy: VmDiskIoPolicy
        """

        self._io_policy = io_policy

    @property
    def io_policy_in(self):
        """Gets the io_policy_in of this VmTemplateWhereInput.  # noqa: E501


        :return: The io_policy_in of this VmTemplateWhereInput.  # noqa: E501
        :rtype: list[VmDiskIoPolicy]
        """
        return self._io_policy_in

    @io_policy_in.setter
    def io_policy_in(self, io_policy_in):
        """Sets the io_policy_in of this VmTemplateWhereInput.


        :param io_policy_in: The io_policy_in of this VmTemplateWhereInput.  # noqa: E501
        :type io_policy_in: list[VmDiskIoPolicy]
        """

        self._io_policy_in = io_policy_in

    @property
    def io_policy_not(self):
        """Gets the io_policy_not of this VmTemplateWhereInput.  # noqa: E501


        :return: The io_policy_not of this VmTemplateWhereInput.  # noqa: E501
        :rtype: VmDiskIoPolicy
        """
        return self._io_policy_not

    @io_policy_not.setter
    def io_policy_not(self, io_policy_not):
        """Sets the io_policy_not of this VmTemplateWhereInput.


        :param io_policy_not: The io_policy_not of this VmTemplateWhereInput.  # noqa: E501
        :type io_policy_not: VmDiskIoPolicy
        """

        self._io_policy_not = io_policy_not

    @property
    def io_policy_not_in(self):
        """Gets the io_policy_not_in of this VmTemplateWhereInput.  # noqa: E501


        :return: The io_policy_not_in of this VmTemplateWhereInput.  # noqa: E501
        :rtype: list[VmDiskIoPolicy]
        """
        return self._io_policy_not_in

    @io_policy_not_in.setter
    def io_policy_not_in(self, io_policy_not_in):
        """Sets the io_policy_not_in of this VmTemplateWhereInput.


        :param io_policy_not_in: The io_policy_not_in of this VmTemplateWhereInput.  # noqa: E501
        :type io_policy_not_in: list[VmDiskIoPolicy]
        """

        self._io_policy_not_in = io_policy_not_in

    @property
    def labels_every(self):
        """Gets the labels_every of this VmTemplateWhereInput.  # noqa: E501


        :return: The labels_every of this VmTemplateWhereInput.  # noqa: E501
        :rtype: LabelWhereInput
        """
        return self._labels_every

    @labels_every.setter
    def labels_every(self, labels_every):
        """Sets the labels_every of this VmTemplateWhereInput.


        :param labels_every: The labels_every of this VmTemplateWhereInput.  # noqa: E501
        :type labels_every: LabelWhereInput
        """

        self._labels_every = labels_every

    @property
    def labels_none(self):
        """Gets the labels_none of this VmTemplateWhereInput.  # noqa: E501


        :return: The labels_none of this VmTemplateWhereInput.  # noqa: E501
        :rtype: LabelWhereInput
        """
        return self._labels_none

    @labels_none.setter
    def labels_none(self, labels_none):
        """Sets the labels_none of this VmTemplateWhereInput.


        :param labels_none: The labels_none of this VmTemplateWhereInput.  # noqa: E501
        :type labels_none: LabelWhereInput
        """

        self._labels_none = labels_none

    @property
    def labels_some(self):
        """Gets the labels_some of this VmTemplateWhereInput.  # noqa: E501


        :return: The labels_some of this VmTemplateWhereInput.  # noqa: E501
        :rtype: LabelWhereInput
        """
        return self._labels_some

    @labels_some.setter
    def labels_some(self, labels_some):
        """Sets the labels_some of this VmTemplateWhereInput.


        :param labels_some: The labels_some of this VmTemplateWhereInput.  # noqa: E501
        :type labels_some: LabelWhereInput
        """

        self._labels_some = labels_some

    @property
    def local_created_at(self):
        """Gets the local_created_at of this VmTemplateWhereInput.  # noqa: E501


        :return: The local_created_at of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at

    @local_created_at.setter
    def local_created_at(self, local_created_at):
        """Sets the local_created_at of this VmTemplateWhereInput.


        :param local_created_at: The local_created_at of this VmTemplateWhereInput.  # noqa: E501
        :type local_created_at: str
        """

        self._local_created_at = local_created_at

    @property
    def local_created_at_gt(self):
        """Gets the local_created_at_gt of this VmTemplateWhereInput.  # noqa: E501


        :return: The local_created_at_gt of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at_gt

    @local_created_at_gt.setter
    def local_created_at_gt(self, local_created_at_gt):
        """Sets the local_created_at_gt of this VmTemplateWhereInput.


        :param local_created_at_gt: The local_created_at_gt of this VmTemplateWhereInput.  # noqa: E501
        :type local_created_at_gt: str
        """

        self._local_created_at_gt = local_created_at_gt

    @property
    def local_created_at_gte(self):
        """Gets the local_created_at_gte of this VmTemplateWhereInput.  # noqa: E501


        :return: The local_created_at_gte of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at_gte

    @local_created_at_gte.setter
    def local_created_at_gte(self, local_created_at_gte):
        """Sets the local_created_at_gte of this VmTemplateWhereInput.


        :param local_created_at_gte: The local_created_at_gte of this VmTemplateWhereInput.  # noqa: E501
        :type local_created_at_gte: str
        """

        self._local_created_at_gte = local_created_at_gte

    @property
    def local_created_at_in(self):
        """Gets the local_created_at_in of this VmTemplateWhereInput.  # noqa: E501


        :return: The local_created_at_in of this VmTemplateWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_created_at_in

    @local_created_at_in.setter
    def local_created_at_in(self, local_created_at_in):
        """Sets the local_created_at_in of this VmTemplateWhereInput.


        :param local_created_at_in: The local_created_at_in of this VmTemplateWhereInput.  # noqa: E501
        :type local_created_at_in: list[str]
        """

        self._local_created_at_in = local_created_at_in

    @property
    def local_created_at_lt(self):
        """Gets the local_created_at_lt of this VmTemplateWhereInput.  # noqa: E501


        :return: The local_created_at_lt of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at_lt

    @local_created_at_lt.setter
    def local_created_at_lt(self, local_created_at_lt):
        """Sets the local_created_at_lt of this VmTemplateWhereInput.


        :param local_created_at_lt: The local_created_at_lt of this VmTemplateWhereInput.  # noqa: E501
        :type local_created_at_lt: str
        """

        self._local_created_at_lt = local_created_at_lt

    @property
    def local_created_at_lte(self):
        """Gets the local_created_at_lte of this VmTemplateWhereInput.  # noqa: E501


        :return: The local_created_at_lte of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at_lte

    @local_created_at_lte.setter
    def local_created_at_lte(self, local_created_at_lte):
        """Sets the local_created_at_lte of this VmTemplateWhereInput.


        :param local_created_at_lte: The local_created_at_lte of this VmTemplateWhereInput.  # noqa: E501
        :type local_created_at_lte: str
        """

        self._local_created_at_lte = local_created_at_lte

    @property
    def local_created_at_not(self):
        """Gets the local_created_at_not of this VmTemplateWhereInput.  # noqa: E501


        :return: The local_created_at_not of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at_not

    @local_created_at_not.setter
    def local_created_at_not(self, local_created_at_not):
        """Sets the local_created_at_not of this VmTemplateWhereInput.


        :param local_created_at_not: The local_created_at_not of this VmTemplateWhereInput.  # noqa: E501
        :type local_created_at_not: str
        """

        self._local_created_at_not = local_created_at_not

    @property
    def local_created_at_not_in(self):
        """Gets the local_created_at_not_in of this VmTemplateWhereInput.  # noqa: E501


        :return: The local_created_at_not_in of this VmTemplateWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_created_at_not_in

    @local_created_at_not_in.setter
    def local_created_at_not_in(self, local_created_at_not_in):
        """Sets the local_created_at_not_in of this VmTemplateWhereInput.


        :param local_created_at_not_in: The local_created_at_not_in of this VmTemplateWhereInput.  # noqa: E501
        :type local_created_at_not_in: list[str]
        """

        self._local_created_at_not_in = local_created_at_not_in

    @property
    def local_id(self):
        """Gets the local_id of this VmTemplateWhereInput.  # noqa: E501


        :return: The local_id of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id):
        """Sets the local_id of this VmTemplateWhereInput.


        :param local_id: The local_id of this VmTemplateWhereInput.  # noqa: E501
        :type local_id: str
        """

        self._local_id = local_id

    @property
    def local_id_contains(self):
        """Gets the local_id_contains of this VmTemplateWhereInput.  # noqa: E501


        :return: The local_id_contains of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_contains

    @local_id_contains.setter
    def local_id_contains(self, local_id_contains):
        """Sets the local_id_contains of this VmTemplateWhereInput.


        :param local_id_contains: The local_id_contains of this VmTemplateWhereInput.  # noqa: E501
        :type local_id_contains: str
        """

        self._local_id_contains = local_id_contains

    @property
    def local_id_ends_with(self):
        """Gets the local_id_ends_with of this VmTemplateWhereInput.  # noqa: E501


        :return: The local_id_ends_with of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_ends_with

    @local_id_ends_with.setter
    def local_id_ends_with(self, local_id_ends_with):
        """Sets the local_id_ends_with of this VmTemplateWhereInput.


        :param local_id_ends_with: The local_id_ends_with of this VmTemplateWhereInput.  # noqa: E501
        :type local_id_ends_with: str
        """

        self._local_id_ends_with = local_id_ends_with

    @property
    def local_id_gt(self):
        """Gets the local_id_gt of this VmTemplateWhereInput.  # noqa: E501


        :return: The local_id_gt of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_gt

    @local_id_gt.setter
    def local_id_gt(self, local_id_gt):
        """Sets the local_id_gt of this VmTemplateWhereInput.


        :param local_id_gt: The local_id_gt of this VmTemplateWhereInput.  # noqa: E501
        :type local_id_gt: str
        """

        self._local_id_gt = local_id_gt

    @property
    def local_id_gte(self):
        """Gets the local_id_gte of this VmTemplateWhereInput.  # noqa: E501


        :return: The local_id_gte of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_gte

    @local_id_gte.setter
    def local_id_gte(self, local_id_gte):
        """Sets the local_id_gte of this VmTemplateWhereInput.


        :param local_id_gte: The local_id_gte of this VmTemplateWhereInput.  # noqa: E501
        :type local_id_gte: str
        """

        self._local_id_gte = local_id_gte

    @property
    def local_id_in(self):
        """Gets the local_id_in of this VmTemplateWhereInput.  # noqa: E501


        :return: The local_id_in of this VmTemplateWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_id_in

    @local_id_in.setter
    def local_id_in(self, local_id_in):
        """Sets the local_id_in of this VmTemplateWhereInput.


        :param local_id_in: The local_id_in of this VmTemplateWhereInput.  # noqa: E501
        :type local_id_in: list[str]
        """

        self._local_id_in = local_id_in

    @property
    def local_id_lt(self):
        """Gets the local_id_lt of this VmTemplateWhereInput.  # noqa: E501


        :return: The local_id_lt of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_lt

    @local_id_lt.setter
    def local_id_lt(self, local_id_lt):
        """Sets the local_id_lt of this VmTemplateWhereInput.


        :param local_id_lt: The local_id_lt of this VmTemplateWhereInput.  # noqa: E501
        :type local_id_lt: str
        """

        self._local_id_lt = local_id_lt

    @property
    def local_id_lte(self):
        """Gets the local_id_lte of this VmTemplateWhereInput.  # noqa: E501


        :return: The local_id_lte of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_lte

    @local_id_lte.setter
    def local_id_lte(self, local_id_lte):
        """Sets the local_id_lte of this VmTemplateWhereInput.


        :param local_id_lte: The local_id_lte of this VmTemplateWhereInput.  # noqa: E501
        :type local_id_lte: str
        """

        self._local_id_lte = local_id_lte

    @property
    def local_id_not(self):
        """Gets the local_id_not of this VmTemplateWhereInput.  # noqa: E501


        :return: The local_id_not of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not

    @local_id_not.setter
    def local_id_not(self, local_id_not):
        """Sets the local_id_not of this VmTemplateWhereInput.


        :param local_id_not: The local_id_not of this VmTemplateWhereInput.  # noqa: E501
        :type local_id_not: str
        """

        self._local_id_not = local_id_not

    @property
    def local_id_not_contains(self):
        """Gets the local_id_not_contains of this VmTemplateWhereInput.  # noqa: E501


        :return: The local_id_not_contains of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_contains

    @local_id_not_contains.setter
    def local_id_not_contains(self, local_id_not_contains):
        """Sets the local_id_not_contains of this VmTemplateWhereInput.


        :param local_id_not_contains: The local_id_not_contains of this VmTemplateWhereInput.  # noqa: E501
        :type local_id_not_contains: str
        """

        self._local_id_not_contains = local_id_not_contains

    @property
    def local_id_not_ends_with(self):
        """Gets the local_id_not_ends_with of this VmTemplateWhereInput.  # noqa: E501


        :return: The local_id_not_ends_with of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_ends_with

    @local_id_not_ends_with.setter
    def local_id_not_ends_with(self, local_id_not_ends_with):
        """Sets the local_id_not_ends_with of this VmTemplateWhereInput.


        :param local_id_not_ends_with: The local_id_not_ends_with of this VmTemplateWhereInput.  # noqa: E501
        :type local_id_not_ends_with: str
        """

        self._local_id_not_ends_with = local_id_not_ends_with

    @property
    def local_id_not_in(self):
        """Gets the local_id_not_in of this VmTemplateWhereInput.  # noqa: E501


        :return: The local_id_not_in of this VmTemplateWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_id_not_in

    @local_id_not_in.setter
    def local_id_not_in(self, local_id_not_in):
        """Sets the local_id_not_in of this VmTemplateWhereInput.


        :param local_id_not_in: The local_id_not_in of this VmTemplateWhereInput.  # noqa: E501
        :type local_id_not_in: list[str]
        """

        self._local_id_not_in = local_id_not_in

    @property
    def local_id_not_starts_with(self):
        """Gets the local_id_not_starts_with of this VmTemplateWhereInput.  # noqa: E501


        :return: The local_id_not_starts_with of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_starts_with

    @local_id_not_starts_with.setter
    def local_id_not_starts_with(self, local_id_not_starts_with):
        """Sets the local_id_not_starts_with of this VmTemplateWhereInput.


        :param local_id_not_starts_with: The local_id_not_starts_with of this VmTemplateWhereInput.  # noqa: E501
        :type local_id_not_starts_with: str
        """

        self._local_id_not_starts_with = local_id_not_starts_with

    @property
    def local_id_starts_with(self):
        """Gets the local_id_starts_with of this VmTemplateWhereInput.  # noqa: E501


        :return: The local_id_starts_with of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_starts_with

    @local_id_starts_with.setter
    def local_id_starts_with(self, local_id_starts_with):
        """Sets the local_id_starts_with of this VmTemplateWhereInput.


        :param local_id_starts_with: The local_id_starts_with of this VmTemplateWhereInput.  # noqa: E501
        :type local_id_starts_with: str
        """

        self._local_id_starts_with = local_id_starts_with

    @property
    def max_bandwidth(self):
        """Gets the max_bandwidth of this VmTemplateWhereInput.  # noqa: E501


        :return: The max_bandwidth of this VmTemplateWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._max_bandwidth

    @max_bandwidth.setter
    def max_bandwidth(self, max_bandwidth):
        """Sets the max_bandwidth of this VmTemplateWhereInput.


        :param max_bandwidth: The max_bandwidth of this VmTemplateWhereInput.  # noqa: E501
        :type max_bandwidth: int
        """

        self._max_bandwidth = max_bandwidth

    @property
    def max_bandwidth_gt(self):
        """Gets the max_bandwidth_gt of this VmTemplateWhereInput.  # noqa: E501


        :return: The max_bandwidth_gt of this VmTemplateWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._max_bandwidth_gt

    @max_bandwidth_gt.setter
    def max_bandwidth_gt(self, max_bandwidth_gt):
        """Sets the max_bandwidth_gt of this VmTemplateWhereInput.


        :param max_bandwidth_gt: The max_bandwidth_gt of this VmTemplateWhereInput.  # noqa: E501
        :type max_bandwidth_gt: int
        """

        self._max_bandwidth_gt = max_bandwidth_gt

    @property
    def max_bandwidth_gte(self):
        """Gets the max_bandwidth_gte of this VmTemplateWhereInput.  # noqa: E501


        :return: The max_bandwidth_gte of this VmTemplateWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._max_bandwidth_gte

    @max_bandwidth_gte.setter
    def max_bandwidth_gte(self, max_bandwidth_gte):
        """Sets the max_bandwidth_gte of this VmTemplateWhereInput.


        :param max_bandwidth_gte: The max_bandwidth_gte of this VmTemplateWhereInput.  # noqa: E501
        :type max_bandwidth_gte: int
        """

        self._max_bandwidth_gte = max_bandwidth_gte

    @property
    def max_bandwidth_in(self):
        """Gets the max_bandwidth_in of this VmTemplateWhereInput.  # noqa: E501


        :return: The max_bandwidth_in of this VmTemplateWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._max_bandwidth_in

    @max_bandwidth_in.setter
    def max_bandwidth_in(self, max_bandwidth_in):
        """Sets the max_bandwidth_in of this VmTemplateWhereInput.


        :param max_bandwidth_in: The max_bandwidth_in of this VmTemplateWhereInput.  # noqa: E501
        :type max_bandwidth_in: list[int]
        """

        self._max_bandwidth_in = max_bandwidth_in

    @property
    def max_bandwidth_lt(self):
        """Gets the max_bandwidth_lt of this VmTemplateWhereInput.  # noqa: E501


        :return: The max_bandwidth_lt of this VmTemplateWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._max_bandwidth_lt

    @max_bandwidth_lt.setter
    def max_bandwidth_lt(self, max_bandwidth_lt):
        """Sets the max_bandwidth_lt of this VmTemplateWhereInput.


        :param max_bandwidth_lt: The max_bandwidth_lt of this VmTemplateWhereInput.  # noqa: E501
        :type max_bandwidth_lt: int
        """

        self._max_bandwidth_lt = max_bandwidth_lt

    @property
    def max_bandwidth_lte(self):
        """Gets the max_bandwidth_lte of this VmTemplateWhereInput.  # noqa: E501


        :return: The max_bandwidth_lte of this VmTemplateWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._max_bandwidth_lte

    @max_bandwidth_lte.setter
    def max_bandwidth_lte(self, max_bandwidth_lte):
        """Sets the max_bandwidth_lte of this VmTemplateWhereInput.


        :param max_bandwidth_lte: The max_bandwidth_lte of this VmTemplateWhereInput.  # noqa: E501
        :type max_bandwidth_lte: int
        """

        self._max_bandwidth_lte = max_bandwidth_lte

    @property
    def max_bandwidth_not(self):
        """Gets the max_bandwidth_not of this VmTemplateWhereInput.  # noqa: E501


        :return: The max_bandwidth_not of this VmTemplateWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._max_bandwidth_not

    @max_bandwidth_not.setter
    def max_bandwidth_not(self, max_bandwidth_not):
        """Sets the max_bandwidth_not of this VmTemplateWhereInput.


        :param max_bandwidth_not: The max_bandwidth_not of this VmTemplateWhereInput.  # noqa: E501
        :type max_bandwidth_not: int
        """

        self._max_bandwidth_not = max_bandwidth_not

    @property
    def max_bandwidth_not_in(self):
        """Gets the max_bandwidth_not_in of this VmTemplateWhereInput.  # noqa: E501


        :return: The max_bandwidth_not_in of this VmTemplateWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._max_bandwidth_not_in

    @max_bandwidth_not_in.setter
    def max_bandwidth_not_in(self, max_bandwidth_not_in):
        """Sets the max_bandwidth_not_in of this VmTemplateWhereInput.


        :param max_bandwidth_not_in: The max_bandwidth_not_in of this VmTemplateWhereInput.  # noqa: E501
        :type max_bandwidth_not_in: list[int]
        """

        self._max_bandwidth_not_in = max_bandwidth_not_in

    @property
    def max_bandwidth_policy(self):
        """Gets the max_bandwidth_policy of this VmTemplateWhereInput.  # noqa: E501


        :return: The max_bandwidth_policy of this VmTemplateWhereInput.  # noqa: E501
        :rtype: VmDiskIoRestrictType
        """
        return self._max_bandwidth_policy

    @max_bandwidth_policy.setter
    def max_bandwidth_policy(self, max_bandwidth_policy):
        """Sets the max_bandwidth_policy of this VmTemplateWhereInput.


        :param max_bandwidth_policy: The max_bandwidth_policy of this VmTemplateWhereInput.  # noqa: E501
        :type max_bandwidth_policy: VmDiskIoRestrictType
        """

        self._max_bandwidth_policy = max_bandwidth_policy

    @property
    def max_bandwidth_policy_in(self):
        """Gets the max_bandwidth_policy_in of this VmTemplateWhereInput.  # noqa: E501


        :return: The max_bandwidth_policy_in of this VmTemplateWhereInput.  # noqa: E501
        :rtype: list[VmDiskIoRestrictType]
        """
        return self._max_bandwidth_policy_in

    @max_bandwidth_policy_in.setter
    def max_bandwidth_policy_in(self, max_bandwidth_policy_in):
        """Sets the max_bandwidth_policy_in of this VmTemplateWhereInput.


        :param max_bandwidth_policy_in: The max_bandwidth_policy_in of this VmTemplateWhereInput.  # noqa: E501
        :type max_bandwidth_policy_in: list[VmDiskIoRestrictType]
        """

        self._max_bandwidth_policy_in = max_bandwidth_policy_in

    @property
    def max_bandwidth_policy_not(self):
        """Gets the max_bandwidth_policy_not of this VmTemplateWhereInput.  # noqa: E501


        :return: The max_bandwidth_policy_not of this VmTemplateWhereInput.  # noqa: E501
        :rtype: VmDiskIoRestrictType
        """
        return self._max_bandwidth_policy_not

    @max_bandwidth_policy_not.setter
    def max_bandwidth_policy_not(self, max_bandwidth_policy_not):
        """Sets the max_bandwidth_policy_not of this VmTemplateWhereInput.


        :param max_bandwidth_policy_not: The max_bandwidth_policy_not of this VmTemplateWhereInput.  # noqa: E501
        :type max_bandwidth_policy_not: VmDiskIoRestrictType
        """

        self._max_bandwidth_policy_not = max_bandwidth_policy_not

    @property
    def max_bandwidth_policy_not_in(self):
        """Gets the max_bandwidth_policy_not_in of this VmTemplateWhereInput.  # noqa: E501


        :return: The max_bandwidth_policy_not_in of this VmTemplateWhereInput.  # noqa: E501
        :rtype: list[VmDiskIoRestrictType]
        """
        return self._max_bandwidth_policy_not_in

    @max_bandwidth_policy_not_in.setter
    def max_bandwidth_policy_not_in(self, max_bandwidth_policy_not_in):
        """Sets the max_bandwidth_policy_not_in of this VmTemplateWhereInput.


        :param max_bandwidth_policy_not_in: The max_bandwidth_policy_not_in of this VmTemplateWhereInput.  # noqa: E501
        :type max_bandwidth_policy_not_in: list[VmDiskIoRestrictType]
        """

        self._max_bandwidth_policy_not_in = max_bandwidth_policy_not_in

    @property
    def max_iops(self):
        """Gets the max_iops of this VmTemplateWhereInput.  # noqa: E501


        :return: The max_iops of this VmTemplateWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._max_iops

    @max_iops.setter
    def max_iops(self, max_iops):
        """Sets the max_iops of this VmTemplateWhereInput.


        :param max_iops: The max_iops of this VmTemplateWhereInput.  # noqa: E501
        :type max_iops: int
        """

        self._max_iops = max_iops

    @property
    def max_iops_gt(self):
        """Gets the max_iops_gt of this VmTemplateWhereInput.  # noqa: E501


        :return: The max_iops_gt of this VmTemplateWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._max_iops_gt

    @max_iops_gt.setter
    def max_iops_gt(self, max_iops_gt):
        """Sets the max_iops_gt of this VmTemplateWhereInput.


        :param max_iops_gt: The max_iops_gt of this VmTemplateWhereInput.  # noqa: E501
        :type max_iops_gt: int
        """

        self._max_iops_gt = max_iops_gt

    @property
    def max_iops_gte(self):
        """Gets the max_iops_gte of this VmTemplateWhereInput.  # noqa: E501


        :return: The max_iops_gte of this VmTemplateWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._max_iops_gte

    @max_iops_gte.setter
    def max_iops_gte(self, max_iops_gte):
        """Sets the max_iops_gte of this VmTemplateWhereInput.


        :param max_iops_gte: The max_iops_gte of this VmTemplateWhereInput.  # noqa: E501
        :type max_iops_gte: int
        """

        self._max_iops_gte = max_iops_gte

    @property
    def max_iops_in(self):
        """Gets the max_iops_in of this VmTemplateWhereInput.  # noqa: E501


        :return: The max_iops_in of this VmTemplateWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._max_iops_in

    @max_iops_in.setter
    def max_iops_in(self, max_iops_in):
        """Sets the max_iops_in of this VmTemplateWhereInput.


        :param max_iops_in: The max_iops_in of this VmTemplateWhereInput.  # noqa: E501
        :type max_iops_in: list[int]
        """

        self._max_iops_in = max_iops_in

    @property
    def max_iops_lt(self):
        """Gets the max_iops_lt of this VmTemplateWhereInput.  # noqa: E501


        :return: The max_iops_lt of this VmTemplateWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._max_iops_lt

    @max_iops_lt.setter
    def max_iops_lt(self, max_iops_lt):
        """Sets the max_iops_lt of this VmTemplateWhereInput.


        :param max_iops_lt: The max_iops_lt of this VmTemplateWhereInput.  # noqa: E501
        :type max_iops_lt: int
        """

        self._max_iops_lt = max_iops_lt

    @property
    def max_iops_lte(self):
        """Gets the max_iops_lte of this VmTemplateWhereInput.  # noqa: E501


        :return: The max_iops_lte of this VmTemplateWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._max_iops_lte

    @max_iops_lte.setter
    def max_iops_lte(self, max_iops_lte):
        """Sets the max_iops_lte of this VmTemplateWhereInput.


        :param max_iops_lte: The max_iops_lte of this VmTemplateWhereInput.  # noqa: E501
        :type max_iops_lte: int
        """

        self._max_iops_lte = max_iops_lte

    @property
    def max_iops_not(self):
        """Gets the max_iops_not of this VmTemplateWhereInput.  # noqa: E501


        :return: The max_iops_not of this VmTemplateWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._max_iops_not

    @max_iops_not.setter
    def max_iops_not(self, max_iops_not):
        """Sets the max_iops_not of this VmTemplateWhereInput.


        :param max_iops_not: The max_iops_not of this VmTemplateWhereInput.  # noqa: E501
        :type max_iops_not: int
        """

        self._max_iops_not = max_iops_not

    @property
    def max_iops_not_in(self):
        """Gets the max_iops_not_in of this VmTemplateWhereInput.  # noqa: E501


        :return: The max_iops_not_in of this VmTemplateWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._max_iops_not_in

    @max_iops_not_in.setter
    def max_iops_not_in(self, max_iops_not_in):
        """Sets the max_iops_not_in of this VmTemplateWhereInput.


        :param max_iops_not_in: The max_iops_not_in of this VmTemplateWhereInput.  # noqa: E501
        :type max_iops_not_in: list[int]
        """

        self._max_iops_not_in = max_iops_not_in

    @property
    def max_iops_policy(self):
        """Gets the max_iops_policy of this VmTemplateWhereInput.  # noqa: E501


        :return: The max_iops_policy of this VmTemplateWhereInput.  # noqa: E501
        :rtype: VmDiskIoRestrictType
        """
        return self._max_iops_policy

    @max_iops_policy.setter
    def max_iops_policy(self, max_iops_policy):
        """Sets the max_iops_policy of this VmTemplateWhereInput.


        :param max_iops_policy: The max_iops_policy of this VmTemplateWhereInput.  # noqa: E501
        :type max_iops_policy: VmDiskIoRestrictType
        """

        self._max_iops_policy = max_iops_policy

    @property
    def max_iops_policy_in(self):
        """Gets the max_iops_policy_in of this VmTemplateWhereInput.  # noqa: E501


        :return: The max_iops_policy_in of this VmTemplateWhereInput.  # noqa: E501
        :rtype: list[VmDiskIoRestrictType]
        """
        return self._max_iops_policy_in

    @max_iops_policy_in.setter
    def max_iops_policy_in(self, max_iops_policy_in):
        """Sets the max_iops_policy_in of this VmTemplateWhereInput.


        :param max_iops_policy_in: The max_iops_policy_in of this VmTemplateWhereInput.  # noqa: E501
        :type max_iops_policy_in: list[VmDiskIoRestrictType]
        """

        self._max_iops_policy_in = max_iops_policy_in

    @property
    def max_iops_policy_not(self):
        """Gets the max_iops_policy_not of this VmTemplateWhereInput.  # noqa: E501


        :return: The max_iops_policy_not of this VmTemplateWhereInput.  # noqa: E501
        :rtype: VmDiskIoRestrictType
        """
        return self._max_iops_policy_not

    @max_iops_policy_not.setter
    def max_iops_policy_not(self, max_iops_policy_not):
        """Sets the max_iops_policy_not of this VmTemplateWhereInput.


        :param max_iops_policy_not: The max_iops_policy_not of this VmTemplateWhereInput.  # noqa: E501
        :type max_iops_policy_not: VmDiskIoRestrictType
        """

        self._max_iops_policy_not = max_iops_policy_not

    @property
    def max_iops_policy_not_in(self):
        """Gets the max_iops_policy_not_in of this VmTemplateWhereInput.  # noqa: E501


        :return: The max_iops_policy_not_in of this VmTemplateWhereInput.  # noqa: E501
        :rtype: list[VmDiskIoRestrictType]
        """
        return self._max_iops_policy_not_in

    @max_iops_policy_not_in.setter
    def max_iops_policy_not_in(self, max_iops_policy_not_in):
        """Sets the max_iops_policy_not_in of this VmTemplateWhereInput.


        :param max_iops_policy_not_in: The max_iops_policy_not_in of this VmTemplateWhereInput.  # noqa: E501
        :type max_iops_policy_not_in: list[VmDiskIoRestrictType]
        """

        self._max_iops_policy_not_in = max_iops_policy_not_in

    @property
    def memory(self):
        """Gets the memory of this VmTemplateWhereInput.  # noqa: E501


        :return: The memory of this VmTemplateWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._memory

    @memory.setter
    def memory(self, memory):
        """Sets the memory of this VmTemplateWhereInput.


        :param memory: The memory of this VmTemplateWhereInput.  # noqa: E501
        :type memory: int
        """

        self._memory = memory

    @property
    def memory_gt(self):
        """Gets the memory_gt of this VmTemplateWhereInput.  # noqa: E501


        :return: The memory_gt of this VmTemplateWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._memory_gt

    @memory_gt.setter
    def memory_gt(self, memory_gt):
        """Sets the memory_gt of this VmTemplateWhereInput.


        :param memory_gt: The memory_gt of this VmTemplateWhereInput.  # noqa: E501
        :type memory_gt: int
        """

        self._memory_gt = memory_gt

    @property
    def memory_gte(self):
        """Gets the memory_gte of this VmTemplateWhereInput.  # noqa: E501


        :return: The memory_gte of this VmTemplateWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._memory_gte

    @memory_gte.setter
    def memory_gte(self, memory_gte):
        """Sets the memory_gte of this VmTemplateWhereInput.


        :param memory_gte: The memory_gte of this VmTemplateWhereInput.  # noqa: E501
        :type memory_gte: int
        """

        self._memory_gte = memory_gte

    @property
    def memory_in(self):
        """Gets the memory_in of this VmTemplateWhereInput.  # noqa: E501


        :return: The memory_in of this VmTemplateWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._memory_in

    @memory_in.setter
    def memory_in(self, memory_in):
        """Sets the memory_in of this VmTemplateWhereInput.


        :param memory_in: The memory_in of this VmTemplateWhereInput.  # noqa: E501
        :type memory_in: list[int]
        """

        self._memory_in = memory_in

    @property
    def memory_lt(self):
        """Gets the memory_lt of this VmTemplateWhereInput.  # noqa: E501


        :return: The memory_lt of this VmTemplateWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._memory_lt

    @memory_lt.setter
    def memory_lt(self, memory_lt):
        """Sets the memory_lt of this VmTemplateWhereInput.


        :param memory_lt: The memory_lt of this VmTemplateWhereInput.  # noqa: E501
        :type memory_lt: int
        """

        self._memory_lt = memory_lt

    @property
    def memory_lte(self):
        """Gets the memory_lte of this VmTemplateWhereInput.  # noqa: E501


        :return: The memory_lte of this VmTemplateWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._memory_lte

    @memory_lte.setter
    def memory_lte(self, memory_lte):
        """Sets the memory_lte of this VmTemplateWhereInput.


        :param memory_lte: The memory_lte of this VmTemplateWhereInput.  # noqa: E501
        :type memory_lte: int
        """

        self._memory_lte = memory_lte

    @property
    def memory_not(self):
        """Gets the memory_not of this VmTemplateWhereInput.  # noqa: E501


        :return: The memory_not of this VmTemplateWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._memory_not

    @memory_not.setter
    def memory_not(self, memory_not):
        """Sets the memory_not of this VmTemplateWhereInput.


        :param memory_not: The memory_not of this VmTemplateWhereInput.  # noqa: E501
        :type memory_not: int
        """

        self._memory_not = memory_not

    @property
    def memory_not_in(self):
        """Gets the memory_not_in of this VmTemplateWhereInput.  # noqa: E501


        :return: The memory_not_in of this VmTemplateWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._memory_not_in

    @memory_not_in.setter
    def memory_not_in(self, memory_not_in):
        """Sets the memory_not_in of this VmTemplateWhereInput.


        :param memory_not_in: The memory_not_in of this VmTemplateWhereInput.  # noqa: E501
        :type memory_not_in: list[int]
        """

        self._memory_not_in = memory_not_in

    @property
    def name(self):
        """Gets the name of this VmTemplateWhereInput.  # noqa: E501


        :return: The name of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this VmTemplateWhereInput.


        :param name: The name of this VmTemplateWhereInput.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def name_contains(self):
        """Gets the name_contains of this VmTemplateWhereInput.  # noqa: E501


        :return: The name_contains of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_contains

    @name_contains.setter
    def name_contains(self, name_contains):
        """Sets the name_contains of this VmTemplateWhereInput.


        :param name_contains: The name_contains of this VmTemplateWhereInput.  # noqa: E501
        :type name_contains: str
        """

        self._name_contains = name_contains

    @property
    def name_ends_with(self):
        """Gets the name_ends_with of this VmTemplateWhereInput.  # noqa: E501


        :return: The name_ends_with of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_ends_with

    @name_ends_with.setter
    def name_ends_with(self, name_ends_with):
        """Sets the name_ends_with of this VmTemplateWhereInput.


        :param name_ends_with: The name_ends_with of this VmTemplateWhereInput.  # noqa: E501
        :type name_ends_with: str
        """

        self._name_ends_with = name_ends_with

    @property
    def name_gt(self):
        """Gets the name_gt of this VmTemplateWhereInput.  # noqa: E501


        :return: The name_gt of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_gt

    @name_gt.setter
    def name_gt(self, name_gt):
        """Sets the name_gt of this VmTemplateWhereInput.


        :param name_gt: The name_gt of this VmTemplateWhereInput.  # noqa: E501
        :type name_gt: str
        """

        self._name_gt = name_gt

    @property
    def name_gte(self):
        """Gets the name_gte of this VmTemplateWhereInput.  # noqa: E501


        :return: The name_gte of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_gte

    @name_gte.setter
    def name_gte(self, name_gte):
        """Sets the name_gte of this VmTemplateWhereInput.


        :param name_gte: The name_gte of this VmTemplateWhereInput.  # noqa: E501
        :type name_gte: str
        """

        self._name_gte = name_gte

    @property
    def name_in(self):
        """Gets the name_in of this VmTemplateWhereInput.  # noqa: E501


        :return: The name_in of this VmTemplateWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._name_in

    @name_in.setter
    def name_in(self, name_in):
        """Sets the name_in of this VmTemplateWhereInput.


        :param name_in: The name_in of this VmTemplateWhereInput.  # noqa: E501
        :type name_in: list[str]
        """

        self._name_in = name_in

    @property
    def name_lt(self):
        """Gets the name_lt of this VmTemplateWhereInput.  # noqa: E501


        :return: The name_lt of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_lt

    @name_lt.setter
    def name_lt(self, name_lt):
        """Sets the name_lt of this VmTemplateWhereInput.


        :param name_lt: The name_lt of this VmTemplateWhereInput.  # noqa: E501
        :type name_lt: str
        """

        self._name_lt = name_lt

    @property
    def name_lte(self):
        """Gets the name_lte of this VmTemplateWhereInput.  # noqa: E501


        :return: The name_lte of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_lte

    @name_lte.setter
    def name_lte(self, name_lte):
        """Sets the name_lte of this VmTemplateWhereInput.


        :param name_lte: The name_lte of this VmTemplateWhereInput.  # noqa: E501
        :type name_lte: str
        """

        self._name_lte = name_lte

    @property
    def name_not(self):
        """Gets the name_not of this VmTemplateWhereInput.  # noqa: E501


        :return: The name_not of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not

    @name_not.setter
    def name_not(self, name_not):
        """Sets the name_not of this VmTemplateWhereInput.


        :param name_not: The name_not of this VmTemplateWhereInput.  # noqa: E501
        :type name_not: str
        """

        self._name_not = name_not

    @property
    def name_not_contains(self):
        """Gets the name_not_contains of this VmTemplateWhereInput.  # noqa: E501


        :return: The name_not_contains of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_contains

    @name_not_contains.setter
    def name_not_contains(self, name_not_contains):
        """Sets the name_not_contains of this VmTemplateWhereInput.


        :param name_not_contains: The name_not_contains of this VmTemplateWhereInput.  # noqa: E501
        :type name_not_contains: str
        """

        self._name_not_contains = name_not_contains

    @property
    def name_not_ends_with(self):
        """Gets the name_not_ends_with of this VmTemplateWhereInput.  # noqa: E501


        :return: The name_not_ends_with of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_ends_with

    @name_not_ends_with.setter
    def name_not_ends_with(self, name_not_ends_with):
        """Sets the name_not_ends_with of this VmTemplateWhereInput.


        :param name_not_ends_with: The name_not_ends_with of this VmTemplateWhereInput.  # noqa: E501
        :type name_not_ends_with: str
        """

        self._name_not_ends_with = name_not_ends_with

    @property
    def name_not_in(self):
        """Gets the name_not_in of this VmTemplateWhereInput.  # noqa: E501


        :return: The name_not_in of this VmTemplateWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._name_not_in

    @name_not_in.setter
    def name_not_in(self, name_not_in):
        """Sets the name_not_in of this VmTemplateWhereInput.


        :param name_not_in: The name_not_in of this VmTemplateWhereInput.  # noqa: E501
        :type name_not_in: list[str]
        """

        self._name_not_in = name_not_in

    @property
    def name_not_starts_with(self):
        """Gets the name_not_starts_with of this VmTemplateWhereInput.  # noqa: E501


        :return: The name_not_starts_with of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_starts_with

    @name_not_starts_with.setter
    def name_not_starts_with(self, name_not_starts_with):
        """Sets the name_not_starts_with of this VmTemplateWhereInput.


        :param name_not_starts_with: The name_not_starts_with of this VmTemplateWhereInput.  # noqa: E501
        :type name_not_starts_with: str
        """

        self._name_not_starts_with = name_not_starts_with

    @property
    def name_starts_with(self):
        """Gets the name_starts_with of this VmTemplateWhereInput.  # noqa: E501


        :return: The name_starts_with of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_starts_with

    @name_starts_with.setter
    def name_starts_with(self, name_starts_with):
        """Sets the name_starts_with of this VmTemplateWhereInput.


        :param name_starts_with: The name_starts_with of this VmTemplateWhereInput.  # noqa: E501
        :type name_starts_with: str
        """

        self._name_starts_with = name_starts_with

    @property
    def size(self):
        """Gets the size of this VmTemplateWhereInput.  # noqa: E501


        :return: The size of this VmTemplateWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size):
        """Sets the size of this VmTemplateWhereInput.


        :param size: The size of this VmTemplateWhereInput.  # noqa: E501
        :type size: int
        """

        self._size = size

    @property
    def size_gt(self):
        """Gets the size_gt of this VmTemplateWhereInput.  # noqa: E501


        :return: The size_gt of this VmTemplateWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._size_gt

    @size_gt.setter
    def size_gt(self, size_gt):
        """Sets the size_gt of this VmTemplateWhereInput.


        :param size_gt: The size_gt of this VmTemplateWhereInput.  # noqa: E501
        :type size_gt: int
        """

        self._size_gt = size_gt

    @property
    def size_gte(self):
        """Gets the size_gte of this VmTemplateWhereInput.  # noqa: E501


        :return: The size_gte of this VmTemplateWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._size_gte

    @size_gte.setter
    def size_gte(self, size_gte):
        """Sets the size_gte of this VmTemplateWhereInput.


        :param size_gte: The size_gte of this VmTemplateWhereInput.  # noqa: E501
        :type size_gte: int
        """

        self._size_gte = size_gte

    @property
    def size_in(self):
        """Gets the size_in of this VmTemplateWhereInput.  # noqa: E501


        :return: The size_in of this VmTemplateWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._size_in

    @size_in.setter
    def size_in(self, size_in):
        """Sets the size_in of this VmTemplateWhereInput.


        :param size_in: The size_in of this VmTemplateWhereInput.  # noqa: E501
        :type size_in: list[int]
        """

        self._size_in = size_in

    @property
    def size_lt(self):
        """Gets the size_lt of this VmTemplateWhereInput.  # noqa: E501


        :return: The size_lt of this VmTemplateWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._size_lt

    @size_lt.setter
    def size_lt(self, size_lt):
        """Sets the size_lt of this VmTemplateWhereInput.


        :param size_lt: The size_lt of this VmTemplateWhereInput.  # noqa: E501
        :type size_lt: int
        """

        self._size_lt = size_lt

    @property
    def size_lte(self):
        """Gets the size_lte of this VmTemplateWhereInput.  # noqa: E501


        :return: The size_lte of this VmTemplateWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._size_lte

    @size_lte.setter
    def size_lte(self, size_lte):
        """Sets the size_lte of this VmTemplateWhereInput.


        :param size_lte: The size_lte of this VmTemplateWhereInput.  # noqa: E501
        :type size_lte: int
        """

        self._size_lte = size_lte

    @property
    def size_not(self):
        """Gets the size_not of this VmTemplateWhereInput.  # noqa: E501


        :return: The size_not of this VmTemplateWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._size_not

    @size_not.setter
    def size_not(self, size_not):
        """Sets the size_not of this VmTemplateWhereInput.


        :param size_not: The size_not of this VmTemplateWhereInput.  # noqa: E501
        :type size_not: int
        """

        self._size_not = size_not

    @property
    def size_not_in(self):
        """Gets the size_not_in of this VmTemplateWhereInput.  # noqa: E501


        :return: The size_not_in of this VmTemplateWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._size_not_in

    @size_not_in.setter
    def size_not_in(self, size_not_in):
        """Sets the size_not_in of this VmTemplateWhereInput.


        :param size_not_in: The size_not_in of this VmTemplateWhereInput.  # noqa: E501
        :type size_not_in: list[int]
        """

        self._size_not_in = size_not_in

    @property
    def vcpu(self):
        """Gets the vcpu of this VmTemplateWhereInput.  # noqa: E501


        :return: The vcpu of this VmTemplateWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._vcpu

    @vcpu.setter
    def vcpu(self, vcpu):
        """Sets the vcpu of this VmTemplateWhereInput.


        :param vcpu: The vcpu of this VmTemplateWhereInput.  # noqa: E501
        :type vcpu: int
        """

        self._vcpu = vcpu

    @property
    def vcpu_gt(self):
        """Gets the vcpu_gt of this VmTemplateWhereInput.  # noqa: E501


        :return: The vcpu_gt of this VmTemplateWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._vcpu_gt

    @vcpu_gt.setter
    def vcpu_gt(self, vcpu_gt):
        """Sets the vcpu_gt of this VmTemplateWhereInput.


        :param vcpu_gt: The vcpu_gt of this VmTemplateWhereInput.  # noqa: E501
        :type vcpu_gt: int
        """

        self._vcpu_gt = vcpu_gt

    @property
    def vcpu_gte(self):
        """Gets the vcpu_gte of this VmTemplateWhereInput.  # noqa: E501


        :return: The vcpu_gte of this VmTemplateWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._vcpu_gte

    @vcpu_gte.setter
    def vcpu_gte(self, vcpu_gte):
        """Sets the vcpu_gte of this VmTemplateWhereInput.


        :param vcpu_gte: The vcpu_gte of this VmTemplateWhereInput.  # noqa: E501
        :type vcpu_gte: int
        """

        self._vcpu_gte = vcpu_gte

    @property
    def vcpu_in(self):
        """Gets the vcpu_in of this VmTemplateWhereInput.  # noqa: E501


        :return: The vcpu_in of this VmTemplateWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._vcpu_in

    @vcpu_in.setter
    def vcpu_in(self, vcpu_in):
        """Sets the vcpu_in of this VmTemplateWhereInput.


        :param vcpu_in: The vcpu_in of this VmTemplateWhereInput.  # noqa: E501
        :type vcpu_in: list[int]
        """

        self._vcpu_in = vcpu_in

    @property
    def vcpu_lt(self):
        """Gets the vcpu_lt of this VmTemplateWhereInput.  # noqa: E501


        :return: The vcpu_lt of this VmTemplateWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._vcpu_lt

    @vcpu_lt.setter
    def vcpu_lt(self, vcpu_lt):
        """Sets the vcpu_lt of this VmTemplateWhereInput.


        :param vcpu_lt: The vcpu_lt of this VmTemplateWhereInput.  # noqa: E501
        :type vcpu_lt: int
        """

        self._vcpu_lt = vcpu_lt

    @property
    def vcpu_lte(self):
        """Gets the vcpu_lte of this VmTemplateWhereInput.  # noqa: E501


        :return: The vcpu_lte of this VmTemplateWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._vcpu_lte

    @vcpu_lte.setter
    def vcpu_lte(self, vcpu_lte):
        """Sets the vcpu_lte of this VmTemplateWhereInput.


        :param vcpu_lte: The vcpu_lte of this VmTemplateWhereInput.  # noqa: E501
        :type vcpu_lte: int
        """

        self._vcpu_lte = vcpu_lte

    @property
    def vcpu_not(self):
        """Gets the vcpu_not of this VmTemplateWhereInput.  # noqa: E501


        :return: The vcpu_not of this VmTemplateWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._vcpu_not

    @vcpu_not.setter
    def vcpu_not(self, vcpu_not):
        """Sets the vcpu_not of this VmTemplateWhereInput.


        :param vcpu_not: The vcpu_not of this VmTemplateWhereInput.  # noqa: E501
        :type vcpu_not: int
        """

        self._vcpu_not = vcpu_not

    @property
    def vcpu_not_in(self):
        """Gets the vcpu_not_in of this VmTemplateWhereInput.  # noqa: E501


        :return: The vcpu_not_in of this VmTemplateWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._vcpu_not_in

    @vcpu_not_in.setter
    def vcpu_not_in(self, vcpu_not_in):
        """Sets the vcpu_not_in of this VmTemplateWhereInput.


        :param vcpu_not_in: The vcpu_not_in of this VmTemplateWhereInput.  # noqa: E501
        :type vcpu_not_in: list[int]
        """

        self._vcpu_not_in = vcpu_not_in

    @property
    def video_type(self):
        """Gets the video_type of this VmTemplateWhereInput.  # noqa: E501


        :return: The video_type of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._video_type

    @video_type.setter
    def video_type(self, video_type):
        """Sets the video_type of this VmTemplateWhereInput.


        :param video_type: The video_type of this VmTemplateWhereInput.  # noqa: E501
        :type video_type: str
        """

        self._video_type = video_type

    @property
    def video_type_contains(self):
        """Gets the video_type_contains of this VmTemplateWhereInput.  # noqa: E501


        :return: The video_type_contains of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._video_type_contains

    @video_type_contains.setter
    def video_type_contains(self, video_type_contains):
        """Sets the video_type_contains of this VmTemplateWhereInput.


        :param video_type_contains: The video_type_contains of this VmTemplateWhereInput.  # noqa: E501
        :type video_type_contains: str
        """

        self._video_type_contains = video_type_contains

    @property
    def video_type_ends_with(self):
        """Gets the video_type_ends_with of this VmTemplateWhereInput.  # noqa: E501


        :return: The video_type_ends_with of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._video_type_ends_with

    @video_type_ends_with.setter
    def video_type_ends_with(self, video_type_ends_with):
        """Sets the video_type_ends_with of this VmTemplateWhereInput.


        :param video_type_ends_with: The video_type_ends_with of this VmTemplateWhereInput.  # noqa: E501
        :type video_type_ends_with: str
        """

        self._video_type_ends_with = video_type_ends_with

    @property
    def video_type_gt(self):
        """Gets the video_type_gt of this VmTemplateWhereInput.  # noqa: E501


        :return: The video_type_gt of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._video_type_gt

    @video_type_gt.setter
    def video_type_gt(self, video_type_gt):
        """Sets the video_type_gt of this VmTemplateWhereInput.


        :param video_type_gt: The video_type_gt of this VmTemplateWhereInput.  # noqa: E501
        :type video_type_gt: str
        """

        self._video_type_gt = video_type_gt

    @property
    def video_type_gte(self):
        """Gets the video_type_gte of this VmTemplateWhereInput.  # noqa: E501


        :return: The video_type_gte of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._video_type_gte

    @video_type_gte.setter
    def video_type_gte(self, video_type_gte):
        """Sets the video_type_gte of this VmTemplateWhereInput.


        :param video_type_gte: The video_type_gte of this VmTemplateWhereInput.  # noqa: E501
        :type video_type_gte: str
        """

        self._video_type_gte = video_type_gte

    @property
    def video_type_in(self):
        """Gets the video_type_in of this VmTemplateWhereInput.  # noqa: E501


        :return: The video_type_in of this VmTemplateWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._video_type_in

    @video_type_in.setter
    def video_type_in(self, video_type_in):
        """Sets the video_type_in of this VmTemplateWhereInput.


        :param video_type_in: The video_type_in of this VmTemplateWhereInput.  # noqa: E501
        :type video_type_in: list[str]
        """

        self._video_type_in = video_type_in

    @property
    def video_type_lt(self):
        """Gets the video_type_lt of this VmTemplateWhereInput.  # noqa: E501


        :return: The video_type_lt of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._video_type_lt

    @video_type_lt.setter
    def video_type_lt(self, video_type_lt):
        """Sets the video_type_lt of this VmTemplateWhereInput.


        :param video_type_lt: The video_type_lt of this VmTemplateWhereInput.  # noqa: E501
        :type video_type_lt: str
        """

        self._video_type_lt = video_type_lt

    @property
    def video_type_lte(self):
        """Gets the video_type_lte of this VmTemplateWhereInput.  # noqa: E501


        :return: The video_type_lte of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._video_type_lte

    @video_type_lte.setter
    def video_type_lte(self, video_type_lte):
        """Sets the video_type_lte of this VmTemplateWhereInput.


        :param video_type_lte: The video_type_lte of this VmTemplateWhereInput.  # noqa: E501
        :type video_type_lte: str
        """

        self._video_type_lte = video_type_lte

    @property
    def video_type_not(self):
        """Gets the video_type_not of this VmTemplateWhereInput.  # noqa: E501


        :return: The video_type_not of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._video_type_not

    @video_type_not.setter
    def video_type_not(self, video_type_not):
        """Sets the video_type_not of this VmTemplateWhereInput.


        :param video_type_not: The video_type_not of this VmTemplateWhereInput.  # noqa: E501
        :type video_type_not: str
        """

        self._video_type_not = video_type_not

    @property
    def video_type_not_contains(self):
        """Gets the video_type_not_contains of this VmTemplateWhereInput.  # noqa: E501


        :return: The video_type_not_contains of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._video_type_not_contains

    @video_type_not_contains.setter
    def video_type_not_contains(self, video_type_not_contains):
        """Sets the video_type_not_contains of this VmTemplateWhereInput.


        :param video_type_not_contains: The video_type_not_contains of this VmTemplateWhereInput.  # noqa: E501
        :type video_type_not_contains: str
        """

        self._video_type_not_contains = video_type_not_contains

    @property
    def video_type_not_ends_with(self):
        """Gets the video_type_not_ends_with of this VmTemplateWhereInput.  # noqa: E501


        :return: The video_type_not_ends_with of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._video_type_not_ends_with

    @video_type_not_ends_with.setter
    def video_type_not_ends_with(self, video_type_not_ends_with):
        """Sets the video_type_not_ends_with of this VmTemplateWhereInput.


        :param video_type_not_ends_with: The video_type_not_ends_with of this VmTemplateWhereInput.  # noqa: E501
        :type video_type_not_ends_with: str
        """

        self._video_type_not_ends_with = video_type_not_ends_with

    @property
    def video_type_not_in(self):
        """Gets the video_type_not_in of this VmTemplateWhereInput.  # noqa: E501


        :return: The video_type_not_in of this VmTemplateWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._video_type_not_in

    @video_type_not_in.setter
    def video_type_not_in(self, video_type_not_in):
        """Sets the video_type_not_in of this VmTemplateWhereInput.


        :param video_type_not_in: The video_type_not_in of this VmTemplateWhereInput.  # noqa: E501
        :type video_type_not_in: list[str]
        """

        self._video_type_not_in = video_type_not_in

    @property
    def video_type_not_starts_with(self):
        """Gets the video_type_not_starts_with of this VmTemplateWhereInput.  # noqa: E501


        :return: The video_type_not_starts_with of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._video_type_not_starts_with

    @video_type_not_starts_with.setter
    def video_type_not_starts_with(self, video_type_not_starts_with):
        """Sets the video_type_not_starts_with of this VmTemplateWhereInput.


        :param video_type_not_starts_with: The video_type_not_starts_with of this VmTemplateWhereInput.  # noqa: E501
        :type video_type_not_starts_with: str
        """

        self._video_type_not_starts_with = video_type_not_starts_with

    @property
    def video_type_starts_with(self):
        """Gets the video_type_starts_with of this VmTemplateWhereInput.  # noqa: E501


        :return: The video_type_starts_with of this VmTemplateWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._video_type_starts_with

    @video_type_starts_with.setter
    def video_type_starts_with(self, video_type_starts_with):
        """Sets the video_type_starts_with of this VmTemplateWhereInput.


        :param video_type_starts_with: The video_type_starts_with of this VmTemplateWhereInput.  # noqa: E501
        :type video_type_starts_with: str
        """

        self._video_type_starts_with = video_type_starts_with

    @property
    def win_opt(self):
        """Gets the win_opt of this VmTemplateWhereInput.  # noqa: E501


        :return: The win_opt of this VmTemplateWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._win_opt

    @win_opt.setter
    def win_opt(self, win_opt):
        """Sets the win_opt of this VmTemplateWhereInput.


        :param win_opt: The win_opt of this VmTemplateWhereInput.  # noqa: E501
        :type win_opt: bool
        """

        self._win_opt = win_opt

    @property
    def win_opt_not(self):
        """Gets the win_opt_not of this VmTemplateWhereInput.  # noqa: E501


        :return: The win_opt_not of this VmTemplateWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._win_opt_not

    @win_opt_not.setter
    def win_opt_not(self, win_opt_not):
        """Sets the win_opt_not of this VmTemplateWhereInput.


        :param win_opt_not: The win_opt_not of this VmTemplateWhereInput.  # noqa: E501
        :type win_opt_not: bool
        """

        self._win_opt_not = win_opt_not

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VmTemplateWhereInput):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VmTemplateWhereInput):
            return True

        return self.to_dict() != other.to_dict()
