# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class VmUpdateAdvancedOptionsParamsData(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'video_type': 'VmVideoType',
        'windows_optimize': 'bool',
        'cpu_model': 'str',
        'clock_offset': 'VmClockOffset'
    }

    attribute_map = {
        'video_type': 'video_type',
        'windows_optimize': 'windows_optimize',
        'cpu_model': 'cpu_model',
        'clock_offset': 'clock_offset'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """VmUpdateAdvancedOptionsParamsData - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._video_type = None
        self._windows_optimize = None
        self._cpu_model = None
        self._clock_offset = None
        self.discriminator = None

        if "video_type" in kwargs:
            self.video_type = kwargs["video_type"]
        if "windows_optimize" in kwargs:
            self.windows_optimize = kwargs["windows_optimize"]
        if "cpu_model" in kwargs:
            self.cpu_model = kwargs["cpu_model"]
        if "clock_offset" in kwargs:
            self.clock_offset = kwargs["clock_offset"]

    @property
    def video_type(self):
        """Gets the video_type of this VmUpdateAdvancedOptionsParamsData.  # noqa: E501


        :return: The video_type of this VmUpdateAdvancedOptionsParamsData.  # noqa: E501
        :rtype: VmVideoType
        """
        return self._video_type

    @video_type.setter
    def video_type(self, video_type):
        """Sets the video_type of this VmUpdateAdvancedOptionsParamsData.


        :param video_type: The video_type of this VmUpdateAdvancedOptionsParamsData.  # noqa: E501
        :type video_type: VmVideoType
        """

        self._video_type = video_type

    @property
    def windows_optimize(self):
        """Gets the windows_optimize of this VmUpdateAdvancedOptionsParamsData.  # noqa: E501


        :return: The windows_optimize of this VmUpdateAdvancedOptionsParamsData.  # noqa: E501
        :rtype: bool
        """
        return self._windows_optimize

    @windows_optimize.setter
    def windows_optimize(self, windows_optimize):
        """Sets the windows_optimize of this VmUpdateAdvancedOptionsParamsData.


        :param windows_optimize: The windows_optimize of this VmUpdateAdvancedOptionsParamsData.  # noqa: E501
        :type windows_optimize: bool
        """

        self._windows_optimize = windows_optimize

    @property
    def cpu_model(self):
        """Gets the cpu_model of this VmUpdateAdvancedOptionsParamsData.  # noqa: E501


        :return: The cpu_model of this VmUpdateAdvancedOptionsParamsData.  # noqa: E501
        :rtype: str
        """
        return self._cpu_model

    @cpu_model.setter
    def cpu_model(self, cpu_model):
        """Sets the cpu_model of this VmUpdateAdvancedOptionsParamsData.


        :param cpu_model: The cpu_model of this VmUpdateAdvancedOptionsParamsData.  # noqa: E501
        :type cpu_model: str
        """

        self._cpu_model = cpu_model

    @property
    def clock_offset(self):
        """Gets the clock_offset of this VmUpdateAdvancedOptionsParamsData.  # noqa: E501


        :return: The clock_offset of this VmUpdateAdvancedOptionsParamsData.  # noqa: E501
        :rtype: VmClockOffset
        """
        return self._clock_offset

    @clock_offset.setter
    def clock_offset(self, clock_offset):
        """Sets the clock_offset of this VmUpdateAdvancedOptionsParamsData.


        :param clock_offset: The clock_offset of this VmUpdateAdvancedOptionsParamsData.  # noqa: E501
        :type clock_offset: VmClockOffset
        """

        self._clock_offset = clock_offset

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VmUpdateAdvancedOptionsParamsData):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VmUpdateAdvancedOptionsParamsData):
            return True

        return self.to_dict() != other.to_dict()
