# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class VmUpdateIoPolicyParamsData(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'each_disk': 'list[VmUpdateEachDiskIoPolicyParams]',
        'whole_vm': 'VmRestrictIoParamsData',
        'io_policy': 'VmDiskIoPolicy'
    }

    attribute_map = {
        'each_disk': 'each_disk',
        'whole_vm': 'whole_vm',
        'io_policy': 'io_policy'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """VmUpdateIoPolicyParamsData - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._each_disk = None
        self._whole_vm = None
        self._io_policy = None
        self.discriminator = None

        if "each_disk" in kwargs:
            self.each_disk = kwargs["each_disk"]
        if "whole_vm" in kwargs:
            self.whole_vm = kwargs["whole_vm"]
        self.io_policy = kwargs.get("io_policy", None)

    @property
    def each_disk(self):
        """Gets the each_disk of this VmUpdateIoPolicyParamsData.  # noqa: E501


        :return: The each_disk of this VmUpdateIoPolicyParamsData.  # noqa: E501
        :rtype: list[VmUpdateEachDiskIoPolicyParams]
        """
        return self._each_disk

    @each_disk.setter
    def each_disk(self, each_disk):
        """Sets the each_disk of this VmUpdateIoPolicyParamsData.


        :param each_disk: The each_disk of this VmUpdateIoPolicyParamsData.  # noqa: E501
        :type each_disk: list[VmUpdateEachDiskIoPolicyParams]
        """

        self._each_disk = each_disk

    @property
    def whole_vm(self):
        """Gets the whole_vm of this VmUpdateIoPolicyParamsData.  # noqa: E501


        :return: The whole_vm of this VmUpdateIoPolicyParamsData.  # noqa: E501
        :rtype: VmRestrictIoParamsData
        """
        return self._whole_vm

    @whole_vm.setter
    def whole_vm(self, whole_vm):
        """Sets the whole_vm of this VmUpdateIoPolicyParamsData.


        :param whole_vm: The whole_vm of this VmUpdateIoPolicyParamsData.  # noqa: E501
        :type whole_vm: VmRestrictIoParamsData
        """

        self._whole_vm = whole_vm

    @property
    def io_policy(self):
        """Gets the io_policy of this VmUpdateIoPolicyParamsData.  # noqa: E501


        :return: The io_policy of this VmUpdateIoPolicyParamsData.  # noqa: E501
        :rtype: VmDiskIoPolicy
        """
        return self._io_policy

    @io_policy.setter
    def io_policy(self, io_policy):
        """Sets the io_policy of this VmUpdateIoPolicyParamsData.


        :param io_policy: The io_policy of this VmUpdateIoPolicyParamsData.  # noqa: E501
        :type io_policy: VmDiskIoPolicy
        """

        self._io_policy = io_policy

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VmUpdateIoPolicyParamsData):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VmUpdateIoPolicyParamsData):
            return True

        return self.to_dict() != other.to_dict()
