# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class VmUpdateNicParamsData(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'vpc_nic': 'UpdateVpcNicPayloads',
        'subnet_mask': 'str',
        'gateway': 'str',
        'ip_address': 'str',
        'nic_id': 'str',
        'connect_vlan_id': 'str',
        'mirror': 'bool',
        'model': 'VmNicModel',
        'enabled': 'bool',
        'mac_address': 'str',
        'nic_index': 'int'
    }

    attribute_map = {
        'vpc_nic': 'vpc_nic',
        'subnet_mask': 'subnet_mask',
        'gateway': 'gateway',
        'ip_address': 'ip_address',
        'nic_id': 'nic_id',
        'connect_vlan_id': 'connect_vlan_id',
        'mirror': 'mirror',
        'model': 'model',
        'enabled': 'enabled',
        'mac_address': 'mac_address',
        'nic_index': 'nic_index'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """VmUpdateNicParamsData - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._vpc_nic = None
        self._subnet_mask = None
        self._gateway = None
        self._ip_address = None
        self._nic_id = None
        self._connect_vlan_id = None
        self._mirror = None
        self._model = None
        self._enabled = None
        self._mac_address = None
        self._nic_index = None
        self.discriminator = None

        if "vpc_nic" in kwargs:
            self.vpc_nic = kwargs["vpc_nic"]
        if "subnet_mask" in kwargs:
            self.subnet_mask = kwargs["subnet_mask"]
        if "gateway" in kwargs:
            self.gateway = kwargs["gateway"]
        if "ip_address" in kwargs:
            self.ip_address = kwargs["ip_address"]
        if "nic_id" in kwargs:
            self.nic_id = kwargs["nic_id"]
        if "connect_vlan_id" in kwargs:
            self.connect_vlan_id = kwargs["connect_vlan_id"]
        if "mirror" in kwargs:
            self.mirror = kwargs["mirror"]
        if "model" in kwargs:
            self.model = kwargs["model"]
        if "enabled" in kwargs:
            self.enabled = kwargs["enabled"]
        if "mac_address" in kwargs:
            self.mac_address = kwargs["mac_address"]
        if "nic_index" in kwargs:
            self.nic_index = kwargs["nic_index"]

    @property
    def vpc_nic(self):
        """Gets the vpc_nic of this VmUpdateNicParamsData.  # noqa: E501


        :return: The vpc_nic of this VmUpdateNicParamsData.  # noqa: E501
        :rtype: UpdateVpcNicPayloads
        """
        return self._vpc_nic

    @vpc_nic.setter
    def vpc_nic(self, vpc_nic):
        """Sets the vpc_nic of this VmUpdateNicParamsData.


        :param vpc_nic: The vpc_nic of this VmUpdateNicParamsData.  # noqa: E501
        :type vpc_nic: UpdateVpcNicPayloads
        """

        self._vpc_nic = vpc_nic

    @property
    def subnet_mask(self):
        """Gets the subnet_mask of this VmUpdateNicParamsData.  # noqa: E501


        :return: The subnet_mask of this VmUpdateNicParamsData.  # noqa: E501
        :rtype: str
        """
        return self._subnet_mask

    @subnet_mask.setter
    def subnet_mask(self, subnet_mask):
        """Sets the subnet_mask of this VmUpdateNicParamsData.


        :param subnet_mask: The subnet_mask of this VmUpdateNicParamsData.  # noqa: E501
        :type subnet_mask: str
        """

        self._subnet_mask = subnet_mask

    @property
    def gateway(self):
        """Gets the gateway of this VmUpdateNicParamsData.  # noqa: E501


        :return: The gateway of this VmUpdateNicParamsData.  # noqa: E501
        :rtype: str
        """
        return self._gateway

    @gateway.setter
    def gateway(self, gateway):
        """Sets the gateway of this VmUpdateNicParamsData.


        :param gateway: The gateway of this VmUpdateNicParamsData.  # noqa: E501
        :type gateway: str
        """

        self._gateway = gateway

    @property
    def ip_address(self):
        """Gets the ip_address of this VmUpdateNicParamsData.  # noqa: E501


        :return: The ip_address of this VmUpdateNicParamsData.  # noqa: E501
        :rtype: str
        """
        return self._ip_address

    @ip_address.setter
    def ip_address(self, ip_address):
        """Sets the ip_address of this VmUpdateNicParamsData.


        :param ip_address: The ip_address of this VmUpdateNicParamsData.  # noqa: E501
        :type ip_address: str
        """

        self._ip_address = ip_address

    @property
    def nic_id(self):
        """Gets the nic_id of this VmUpdateNicParamsData.  # noqa: E501


        :return: The nic_id of this VmUpdateNicParamsData.  # noqa: E501
        :rtype: str
        """
        return self._nic_id

    @nic_id.setter
    def nic_id(self, nic_id):
        """Sets the nic_id of this VmUpdateNicParamsData.


        :param nic_id: The nic_id of this VmUpdateNicParamsData.  # noqa: E501
        :type nic_id: str
        """

        self._nic_id = nic_id

    @property
    def connect_vlan_id(self):
        """Gets the connect_vlan_id of this VmUpdateNicParamsData.  # noqa: E501


        :return: The connect_vlan_id of this VmUpdateNicParamsData.  # noqa: E501
        :rtype: str
        """
        return self._connect_vlan_id

    @connect_vlan_id.setter
    def connect_vlan_id(self, connect_vlan_id):
        """Sets the connect_vlan_id of this VmUpdateNicParamsData.


        :param connect_vlan_id: The connect_vlan_id of this VmUpdateNicParamsData.  # noqa: E501
        :type connect_vlan_id: str
        """

        self._connect_vlan_id = connect_vlan_id

    @property
    def mirror(self):
        """Gets the mirror of this VmUpdateNicParamsData.  # noqa: E501


        :return: The mirror of this VmUpdateNicParamsData.  # noqa: E501
        :rtype: bool
        """
        return self._mirror

    @mirror.setter
    def mirror(self, mirror):
        """Sets the mirror of this VmUpdateNicParamsData.


        :param mirror: The mirror of this VmUpdateNicParamsData.  # noqa: E501
        :type mirror: bool
        """

        self._mirror = mirror

    @property
    def model(self):
        """Gets the model of this VmUpdateNicParamsData.  # noqa: E501


        :return: The model of this VmUpdateNicParamsData.  # noqa: E501
        :rtype: VmNicModel
        """
        return self._model

    @model.setter
    def model(self, model):
        """Sets the model of this VmUpdateNicParamsData.


        :param model: The model of this VmUpdateNicParamsData.  # noqa: E501
        :type model: VmNicModel
        """

        self._model = model

    @property
    def enabled(self):
        """Gets the enabled of this VmUpdateNicParamsData.  # noqa: E501


        :return: The enabled of this VmUpdateNicParamsData.  # noqa: E501
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """Sets the enabled of this VmUpdateNicParamsData.


        :param enabled: The enabled of this VmUpdateNicParamsData.  # noqa: E501
        :type enabled: bool
        """

        self._enabled = enabled

    @property
    def mac_address(self):
        """Gets the mac_address of this VmUpdateNicParamsData.  # noqa: E501


        :return: The mac_address of this VmUpdateNicParamsData.  # noqa: E501
        :rtype: str
        """
        return self._mac_address

    @mac_address.setter
    def mac_address(self, mac_address):
        """Sets the mac_address of this VmUpdateNicParamsData.


        :param mac_address: The mac_address of this VmUpdateNicParamsData.  # noqa: E501
        :type mac_address: str
        """

        self._mac_address = mac_address

    @property
    def nic_index(self):
        """Gets the nic_index of this VmUpdateNicParamsData.  # noqa: E501


        :return: The nic_index of this VmUpdateNicParamsData.  # noqa: E501
        :rtype: int
        """
        return self._nic_index

    @nic_index.setter
    def nic_index(self, nic_index):
        """Sets the nic_index of this VmUpdateNicParamsData.


        :param nic_index: The nic_index of this VmUpdateNicParamsData.  # noqa: E501
        :type nic_index: int
        """
        if self.local_vars_configuration.client_side_validation and nic_index is None:  # noqa: E501
            raise ValueError("Invalid value for `nic_index`, must not be `None`")  # noqa: E501

        self._nic_index = nic_index

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VmUpdateNicParamsData):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VmUpdateNicParamsData):
            return True

        return self.to_dict() != other.to_dict()
