# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class VmUpdateOwnerParamsData(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'search_for': 'str',
        'value': 'str'
    }

    attribute_map = {
        'search_for': 'search_for',
        'value': 'value'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """VmUpdateOwnerParamsData - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._search_for = None
        self._value = None
        self.discriminator = None

        if "search_for" in kwargs:
            self.search_for = kwargs["search_for"]
        if "value" in kwargs:
            self.value = kwargs["value"]

    @property
    def search_for(self):
        """Gets the search_for of this VmUpdateOwnerParamsData.  # noqa: E501


        :return: The search_for of this VmUpdateOwnerParamsData.  # noqa: E501
        :rtype: str
        """
        return self._search_for

    @search_for.setter
    def search_for(self, search_for):
        """Sets the search_for of this VmUpdateOwnerParamsData.


        :param search_for: The search_for of this VmUpdateOwnerParamsData.  # noqa: E501
        :type search_for: str
        """
        if self.local_vars_configuration.client_side_validation and search_for is None:  # noqa: E501
            raise ValueError("Invalid value for `search_for`, must not be `None`")  # noqa: E501
        allowed_values = ["username", "id"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and search_for not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `search_for` ({0}), must be one of {1}"  # noqa: E501
                .format(search_for, allowed_values)
            )

        self._search_for = search_for

    @property
    def value(self):
        """Gets the value of this VmUpdateOwnerParamsData.  # noqa: E501


        :return: The value of this VmUpdateOwnerParamsData.  # noqa: E501
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """Sets the value of this VmUpdateOwnerParamsData.


        :param value: The value of this VmUpdateOwnerParamsData.  # noqa: E501
        :type value: str
        """
        if self.local_vars_configuration.client_side_validation and value is None:  # noqa: E501
            raise ValueError("Invalid value for `value`, must not be `None`")  # noqa: E501

        self._value = value

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VmUpdateOwnerParamsData):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VmUpdateOwnerParamsData):
            return True

        return self.to_dict() != other.to_dict()
