# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class VmVlanCreationParams(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'qos_burst_unit': 'ByteUnit',
        'qos_burst': 'int',
        'qos_max_bandwidth_unit': 'BPSUnit',
        'qos_max_bandwidth': 'int',
        'qos_min_bandwidth_unit': 'BPSUnit',
        'qos_min_bandwidth': 'int',
        'qos_priority': 'float',
        'mode_type': 'VlanModeType',
        'network_ids': 'list[str]',
        'vds_id': 'str',
        'vlan_id': 'int',
        'name': 'str'
    }

    attribute_map = {
        'qos_burst_unit': 'qos_burst_unit',
        'qos_burst': 'qos_burst',
        'qos_max_bandwidth_unit': 'qos_max_bandwidth_unit',
        'qos_max_bandwidth': 'qos_max_bandwidth',
        'qos_min_bandwidth_unit': 'qos_min_bandwidth_unit',
        'qos_min_bandwidth': 'qos_min_bandwidth',
        'qos_priority': 'qos_priority',
        'mode_type': 'mode_type',
        'network_ids': 'network_ids',
        'vds_id': 'vds_id',
        'vlan_id': 'vlan_id',
        'name': 'name'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """VmVlanCreationParams - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._qos_burst_unit = None
        self._qos_burst = None
        self._qos_max_bandwidth_unit = None
        self._qos_max_bandwidth = None
        self._qos_min_bandwidth_unit = None
        self._qos_min_bandwidth = None
        self._qos_priority = None
        self._mode_type = None
        self._network_ids = None
        self._vds_id = None
        self._vlan_id = None
        self._name = None
        self.discriminator = None

        if "qos_burst_unit" in kwargs:
            self.qos_burst_unit = kwargs["qos_burst_unit"]
        self.qos_burst = kwargs.get("qos_burst", None)
        if "qos_max_bandwidth_unit" in kwargs:
            self.qos_max_bandwidth_unit = kwargs["qos_max_bandwidth_unit"]
        self.qos_max_bandwidth = kwargs.get("qos_max_bandwidth", None)
        if "qos_min_bandwidth_unit" in kwargs:
            self.qos_min_bandwidth_unit = kwargs["qos_min_bandwidth_unit"]
        self.qos_min_bandwidth = kwargs.get("qos_min_bandwidth", None)
        if "qos_priority" in kwargs:
            self.qos_priority = kwargs["qos_priority"]
        if "mode_type" in kwargs:
            self.mode_type = kwargs["mode_type"]
        if "network_ids" in kwargs:
            self.network_ids = kwargs["network_ids"]
        if "vds_id" in kwargs:
            self.vds_id = kwargs["vds_id"]
        if "vlan_id" in kwargs:
            self.vlan_id = kwargs["vlan_id"]
        if "name" in kwargs:
            self.name = kwargs["name"]

    @property
    def qos_burst_unit(self):
        """Gets the qos_burst_unit of this VmVlanCreationParams.  # noqa: E501


        :return: The qos_burst_unit of this VmVlanCreationParams.  # noqa: E501
        :rtype: ByteUnit
        """
        return self._qos_burst_unit

    @qos_burst_unit.setter
    def qos_burst_unit(self, qos_burst_unit):
        """Sets the qos_burst_unit of this VmVlanCreationParams.


        :param qos_burst_unit: The qos_burst_unit of this VmVlanCreationParams.  # noqa: E501
        :type qos_burst_unit: ByteUnit
        """

        self._qos_burst_unit = qos_burst_unit

    @property
    def qos_burst(self):
        """Gets the qos_burst of this VmVlanCreationParams.  # noqa: E501


        :return: The qos_burst of this VmVlanCreationParams.  # noqa: E501
        :rtype: int
        """
        return self._qos_burst

    @qos_burst.setter
    def qos_burst(self, qos_burst):
        """Sets the qos_burst of this VmVlanCreationParams.


        :param qos_burst: The qos_burst of this VmVlanCreationParams.  # noqa: E501
        :type qos_burst: int
        """

        self._qos_burst = qos_burst

    @property
    def qos_max_bandwidth_unit(self):
        """Gets the qos_max_bandwidth_unit of this VmVlanCreationParams.  # noqa: E501


        :return: The qos_max_bandwidth_unit of this VmVlanCreationParams.  # noqa: E501
        :rtype: BPSUnit
        """
        return self._qos_max_bandwidth_unit

    @qos_max_bandwidth_unit.setter
    def qos_max_bandwidth_unit(self, qos_max_bandwidth_unit):
        """Sets the qos_max_bandwidth_unit of this VmVlanCreationParams.


        :param qos_max_bandwidth_unit: The qos_max_bandwidth_unit of this VmVlanCreationParams.  # noqa: E501
        :type qos_max_bandwidth_unit: BPSUnit
        """

        self._qos_max_bandwidth_unit = qos_max_bandwidth_unit

    @property
    def qos_max_bandwidth(self):
        """Gets the qos_max_bandwidth of this VmVlanCreationParams.  # noqa: E501


        :return: The qos_max_bandwidth of this VmVlanCreationParams.  # noqa: E501
        :rtype: int
        """
        return self._qos_max_bandwidth

    @qos_max_bandwidth.setter
    def qos_max_bandwidth(self, qos_max_bandwidth):
        """Sets the qos_max_bandwidth of this VmVlanCreationParams.


        :param qos_max_bandwidth: The qos_max_bandwidth of this VmVlanCreationParams.  # noqa: E501
        :type qos_max_bandwidth: int
        """

        self._qos_max_bandwidth = qos_max_bandwidth

    @property
    def qos_min_bandwidth_unit(self):
        """Gets the qos_min_bandwidth_unit of this VmVlanCreationParams.  # noqa: E501


        :return: The qos_min_bandwidth_unit of this VmVlanCreationParams.  # noqa: E501
        :rtype: BPSUnit
        """
        return self._qos_min_bandwidth_unit

    @qos_min_bandwidth_unit.setter
    def qos_min_bandwidth_unit(self, qos_min_bandwidth_unit):
        """Sets the qos_min_bandwidth_unit of this VmVlanCreationParams.


        :param qos_min_bandwidth_unit: The qos_min_bandwidth_unit of this VmVlanCreationParams.  # noqa: E501
        :type qos_min_bandwidth_unit: BPSUnit
        """

        self._qos_min_bandwidth_unit = qos_min_bandwidth_unit

    @property
    def qos_min_bandwidth(self):
        """Gets the qos_min_bandwidth of this VmVlanCreationParams.  # noqa: E501


        :return: The qos_min_bandwidth of this VmVlanCreationParams.  # noqa: E501
        :rtype: int
        """
        return self._qos_min_bandwidth

    @qos_min_bandwidth.setter
    def qos_min_bandwidth(self, qos_min_bandwidth):
        """Sets the qos_min_bandwidth of this VmVlanCreationParams.


        :param qos_min_bandwidth: The qos_min_bandwidth of this VmVlanCreationParams.  # noqa: E501
        :type qos_min_bandwidth: int
        """

        self._qos_min_bandwidth = qos_min_bandwidth

    @property
    def qos_priority(self):
        """Gets the qos_priority of this VmVlanCreationParams.  # noqa: E501


        :return: The qos_priority of this VmVlanCreationParams.  # noqa: E501
        :rtype: float
        """
        return self._qos_priority

    @qos_priority.setter
    def qos_priority(self, qos_priority):
        """Sets the qos_priority of this VmVlanCreationParams.


        :param qos_priority: The qos_priority of this VmVlanCreationParams.  # noqa: E501
        :type qos_priority: float
        """
        if (self.local_vars_configuration.client_side_validation and
                qos_priority is not None and qos_priority < 0):  # noqa: E501
            raise ValueError("Invalid value for `qos_priority`, must be a value greater than or equal to `0`")  # noqa: E501

        self._qos_priority = qos_priority

    @property
    def mode_type(self):
        """Gets the mode_type of this VmVlanCreationParams.  # noqa: E501


        :return: The mode_type of this VmVlanCreationParams.  # noqa: E501
        :rtype: VlanModeType
        """
        return self._mode_type

    @mode_type.setter
    def mode_type(self, mode_type):
        """Sets the mode_type of this VmVlanCreationParams.


        :param mode_type: The mode_type of this VmVlanCreationParams.  # noqa: E501
        :type mode_type: VlanModeType
        """

        self._mode_type = mode_type

    @property
    def network_ids(self):
        """Gets the network_ids of this VmVlanCreationParams.  # noqa: E501


        :return: The network_ids of this VmVlanCreationParams.  # noqa: E501
        :rtype: list[str]
        """
        return self._network_ids

    @network_ids.setter
    def network_ids(self, network_ids):
        """Sets the network_ids of this VmVlanCreationParams.


        :param network_ids: The network_ids of this VmVlanCreationParams.  # noqa: E501
        :type network_ids: list[str]
        """

        self._network_ids = network_ids

    @property
    def vds_id(self):
        """Gets the vds_id of this VmVlanCreationParams.  # noqa: E501


        :return: The vds_id of this VmVlanCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._vds_id

    @vds_id.setter
    def vds_id(self, vds_id):
        """Sets the vds_id of this VmVlanCreationParams.


        :param vds_id: The vds_id of this VmVlanCreationParams.  # noqa: E501
        :type vds_id: str
        """
        if self.local_vars_configuration.client_side_validation and vds_id is None:  # noqa: E501
            raise ValueError("Invalid value for `vds_id`, must not be `None`")  # noqa: E501

        self._vds_id = vds_id

    @property
    def vlan_id(self):
        """Gets the vlan_id of this VmVlanCreationParams.  # noqa: E501


        :return: The vlan_id of this VmVlanCreationParams.  # noqa: E501
        :rtype: int
        """
        return self._vlan_id

    @vlan_id.setter
    def vlan_id(self, vlan_id):
        """Sets the vlan_id of this VmVlanCreationParams.


        :param vlan_id: The vlan_id of this VmVlanCreationParams.  # noqa: E501
        :type vlan_id: int
        """
        if (self.local_vars_configuration.client_side_validation and
                vlan_id is not None and vlan_id > 4095):  # noqa: E501
            raise ValueError("Invalid value for `vlan_id`, must be a value less than or equal to `4095`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                vlan_id is not None and vlan_id < 0):  # noqa: E501
            raise ValueError("Invalid value for `vlan_id`, must be a value greater than or equal to `0`")  # noqa: E501

        self._vlan_id = vlan_id

    @property
    def name(self):
        """Gets the name of this VmVlanCreationParams.  # noqa: E501


        :return: The name of this VmVlanCreationParams.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this VmVlanCreationParams.


        :param name: The name of this VmVlanCreationParams.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VmVlanCreationParams):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VmVlanCreationParams):
            return True

        return self.to_dict() != other.to_dict()
