# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class VmVncInfo(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'vm': 'Vm',
        'terminal': 'str',
        'redirect': 'str',
        'direct': 'str',
        'cluster_ip': 'str'
    }

    attribute_map = {
        'vm': 'vm',
        'terminal': 'terminal',
        'redirect': 'redirect',
        'direct': 'direct',
        'cluster_ip': 'cluster_ip'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """VmVncInfo - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._vm = None
        self._terminal = None
        self._redirect = None
        self._direct = None
        self._cluster_ip = None
        self.discriminator = None

        if "vm" in kwargs:
            self.vm = kwargs["vm"]
        if "terminal" in kwargs:
            self.terminal = kwargs["terminal"]
        if "redirect" in kwargs:
            self.redirect = kwargs["redirect"]
        if "direct" in kwargs:
            self.direct = kwargs["direct"]
        if "cluster_ip" in kwargs:
            self.cluster_ip = kwargs["cluster_ip"]

    @property
    def vm(self):
        """Gets the vm of this VmVncInfo.  # noqa: E501


        :return: The vm of this VmVncInfo.  # noqa: E501
        :rtype: Vm
        """
        return self._vm

    @vm.setter
    def vm(self, vm):
        """Sets the vm of this VmVncInfo.


        :param vm: The vm of this VmVncInfo.  # noqa: E501
        :type vm: Vm
        """
        if self.local_vars_configuration.client_side_validation and vm is None:  # noqa: E501
            raise ValueError("Invalid value for `vm`, must not be `None`")  # noqa: E501

        self._vm = vm

    @property
    def terminal(self):
        """Gets the terminal of this VmVncInfo.  # noqa: E501


        :return: The terminal of this VmVncInfo.  # noqa: E501
        :rtype: str
        """
        return self._terminal

    @terminal.setter
    def terminal(self, terminal):
        """Sets the terminal of this VmVncInfo.


        :param terminal: The terminal of this VmVncInfo.  # noqa: E501
        :type terminal: str
        """
        if self.local_vars_configuration.client_side_validation and terminal is None:  # noqa: E501
            raise ValueError("Invalid value for `terminal`, must not be `None`")  # noqa: E501

        self._terminal = terminal

    @property
    def redirect(self):
        """Gets the redirect of this VmVncInfo.  # noqa: E501


        :return: The redirect of this VmVncInfo.  # noqa: E501
        :rtype: str
        """
        return self._redirect

    @redirect.setter
    def redirect(self, redirect):
        """Sets the redirect of this VmVncInfo.


        :param redirect: The redirect of this VmVncInfo.  # noqa: E501
        :type redirect: str
        """
        if self.local_vars_configuration.client_side_validation and redirect is None:  # noqa: E501
            raise ValueError("Invalid value for `redirect`, must not be `None`")  # noqa: E501

        self._redirect = redirect

    @property
    def direct(self):
        """Gets the direct of this VmVncInfo.  # noqa: E501


        :return: The direct of this VmVncInfo.  # noqa: E501
        :rtype: str
        """
        return self._direct

    @direct.setter
    def direct(self, direct):
        """Sets the direct of this VmVncInfo.


        :param direct: The direct of this VmVncInfo.  # noqa: E501
        :type direct: str
        """

        self._direct = direct

    @property
    def cluster_ip(self):
        """Gets the cluster_ip of this VmVncInfo.  # noqa: E501


        :return: The cluster_ip of this VmVncInfo.  # noqa: E501
        :rtype: str
        """
        return self._cluster_ip

    @cluster_ip.setter
    def cluster_ip(self, cluster_ip):
        """Sets the cluster_ip of this VmVncInfo.


        :param cluster_ip: The cluster_ip of this VmVncInfo.  # noqa: E501
        :type cluster_ip: str
        """
        if self.local_vars_configuration.client_side_validation and cluster_ip is None:  # noqa: E501
            raise ValueError("Invalid value for `cluster_ip`, must not be `None`")  # noqa: E501

        self._cluster_ip = cluster_ip

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VmVncInfo):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VmVncInfo):
            return True

        return self.to_dict() != other.to_dict()
