# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class VmVolume(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'cluster': 'NestedCluster',
        'description': 'str',
        'elf_storage_policy': 'VmVolumeElfStoragePolicyType',
        'elf_storage_policy_ec_k': 'int',
        'elf_storage_policy_ec_m': 'int',
        'elf_storage_policy_replica_num': 'int',
        'elf_storage_policy_thin_provision': 'bool',
        'entity_async_status': 'EntityAsyncStatus',
        'guest_size_usage': 'float',
        'guest_used_size': 'int',
        'id': 'str',
        'labels': 'list[NestedLabel]',
        'local_created_at': 'str',
        'local_id': 'str',
        'lun': 'NestedIscsiLun',
        'mounting': 'bool',
        'name': 'str',
        'path': 'str',
        'resident_in_cache': 'bool',
        'sharing': 'bool',
        'size': 'int',
        'type': 'VmVolumeType',
        'unique_logical_size': 'float',
        'unique_size': 'int',
        'used_size': 'int',
        'used_size_usage': 'float',
        'vm_disks': 'list[NestedVmDisk]'
    }

    attribute_map = {
        'cluster': 'cluster',
        'description': 'description',
        'elf_storage_policy': 'elf_storage_policy',
        'elf_storage_policy_ec_k': 'elf_storage_policy_ec_k',
        'elf_storage_policy_ec_m': 'elf_storage_policy_ec_m',
        'elf_storage_policy_replica_num': 'elf_storage_policy_replica_num',
        'elf_storage_policy_thin_provision': 'elf_storage_policy_thin_provision',
        'entity_async_status': 'entityAsyncStatus',
        'guest_size_usage': 'guest_size_usage',
        'guest_used_size': 'guest_used_size',
        'id': 'id',
        'labels': 'labels',
        'local_created_at': 'local_created_at',
        'local_id': 'local_id',
        'lun': 'lun',
        'mounting': 'mounting',
        'name': 'name',
        'path': 'path',
        'resident_in_cache': 'resident_in_cache',
        'sharing': 'sharing',
        'size': 'size',
        'type': 'type',
        'unique_logical_size': 'unique_logical_size',
        'unique_size': 'unique_size',
        'used_size': 'used_size',
        'used_size_usage': 'used_size_usage',
        'vm_disks': 'vm_disks'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """VmVolume - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._cluster = None
        self._description = None
        self._elf_storage_policy = None
        self._elf_storage_policy_ec_k = None
        self._elf_storage_policy_ec_m = None
        self._elf_storage_policy_replica_num = None
        self._elf_storage_policy_thin_provision = None
        self._entity_async_status = None
        self._guest_size_usage = None
        self._guest_used_size = None
        self._id = None
        self._labels = None
        self._local_created_at = None
        self._local_id = None
        self._lun = None
        self._mounting = None
        self._name = None
        self._path = None
        self._resident_in_cache = None
        self._sharing = None
        self._size = None
        self._type = None
        self._unique_logical_size = None
        self._unique_size = None
        self._used_size = None
        self._used_size_usage = None
        self._vm_disks = None
        self.discriminator = None

        if "cluster" in kwargs:
            self.cluster = kwargs["cluster"]
        self.description = kwargs.get("description", None)
        if "elf_storage_policy" in kwargs:
            self.elf_storage_policy = kwargs["elf_storage_policy"]
        self.elf_storage_policy_ec_k = kwargs.get("elf_storage_policy_ec_k", None)
        self.elf_storage_policy_ec_m = kwargs.get("elf_storage_policy_ec_m", None)
        self.elf_storage_policy_replica_num = kwargs.get("elf_storage_policy_replica_num", None)
        self.elf_storage_policy_thin_provision = kwargs.get("elf_storage_policy_thin_provision", None)
        self.entity_async_status = kwargs.get("entity_async_status", None)
        self.guest_size_usage = kwargs.get("guest_size_usage", None)
        self.guest_used_size = kwargs.get("guest_used_size", None)
        if "id" in kwargs:
            self.id = kwargs["id"]
        self.labels = kwargs.get("labels", None)
        if "local_created_at" in kwargs:
            self.local_created_at = kwargs["local_created_at"]
        if "local_id" in kwargs:
            self.local_id = kwargs["local_id"]
        self.lun = kwargs.get("lun", None)
        if "mounting" in kwargs:
            self.mounting = kwargs["mounting"]
        if "name" in kwargs:
            self.name = kwargs["name"]
        if "path" in kwargs:
            self.path = kwargs["path"]
        self.resident_in_cache = kwargs.get("resident_in_cache", None)
        if "sharing" in kwargs:
            self.sharing = kwargs["sharing"]
        if "size" in kwargs:
            self.size = kwargs["size"]
        self.type = kwargs.get("type", None)
        self.unique_logical_size = kwargs.get("unique_logical_size", None)
        self.unique_size = kwargs.get("unique_size", None)
        self.used_size = kwargs.get("used_size", None)
        self.used_size_usage = kwargs.get("used_size_usage", None)
        self.vm_disks = kwargs.get("vm_disks", None)

    @property
    def cluster(self):
        """Gets the cluster of this VmVolume.  # noqa: E501


        :return: The cluster of this VmVolume.  # noqa: E501
        :rtype: NestedCluster
        """
        return self._cluster

    @cluster.setter
    def cluster(self, cluster):
        """Sets the cluster of this VmVolume.


        :param cluster: The cluster of this VmVolume.  # noqa: E501
        :type cluster: NestedCluster
        """
        if self.local_vars_configuration.client_side_validation and cluster is None:  # noqa: E501
            raise ValueError("Invalid value for `cluster`, must not be `None`")  # noqa: E501

        self._cluster = cluster

    @property
    def description(self):
        """Gets the description of this VmVolume.  # noqa: E501


        :return: The description of this VmVolume.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this VmVolume.


        :param description: The description of this VmVolume.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def elf_storage_policy(self):
        """Gets the elf_storage_policy of this VmVolume.  # noqa: E501


        :return: The elf_storage_policy of this VmVolume.  # noqa: E501
        :rtype: VmVolumeElfStoragePolicyType
        """
        return self._elf_storage_policy

    @elf_storage_policy.setter
    def elf_storage_policy(self, elf_storage_policy):
        """Sets the elf_storage_policy of this VmVolume.


        :param elf_storage_policy: The elf_storage_policy of this VmVolume.  # noqa: E501
        :type elf_storage_policy: VmVolumeElfStoragePolicyType
        """
        if self.local_vars_configuration.client_side_validation and elf_storage_policy is None:  # noqa: E501
            raise ValueError("Invalid value for `elf_storage_policy`, must not be `None`")  # noqa: E501

        self._elf_storage_policy = elf_storage_policy

    @property
    def elf_storage_policy_ec_k(self):
        """Gets the elf_storage_policy_ec_k of this VmVolume.  # noqa: E501


        :return: The elf_storage_policy_ec_k of this VmVolume.  # noqa: E501
        :rtype: int
        """
        return self._elf_storage_policy_ec_k

    @elf_storage_policy_ec_k.setter
    def elf_storage_policy_ec_k(self, elf_storage_policy_ec_k):
        """Sets the elf_storage_policy_ec_k of this VmVolume.


        :param elf_storage_policy_ec_k: The elf_storage_policy_ec_k of this VmVolume.  # noqa: E501
        :type elf_storage_policy_ec_k: int
        """

        self._elf_storage_policy_ec_k = elf_storage_policy_ec_k

    @property
    def elf_storage_policy_ec_m(self):
        """Gets the elf_storage_policy_ec_m of this VmVolume.  # noqa: E501


        :return: The elf_storage_policy_ec_m of this VmVolume.  # noqa: E501
        :rtype: int
        """
        return self._elf_storage_policy_ec_m

    @elf_storage_policy_ec_m.setter
    def elf_storage_policy_ec_m(self, elf_storage_policy_ec_m):
        """Sets the elf_storage_policy_ec_m of this VmVolume.


        :param elf_storage_policy_ec_m: The elf_storage_policy_ec_m of this VmVolume.  # noqa: E501
        :type elf_storage_policy_ec_m: int
        """

        self._elf_storage_policy_ec_m = elf_storage_policy_ec_m

    @property
    def elf_storage_policy_replica_num(self):
        """Gets the elf_storage_policy_replica_num of this VmVolume.  # noqa: E501


        :return: The elf_storage_policy_replica_num of this VmVolume.  # noqa: E501
        :rtype: int
        """
        return self._elf_storage_policy_replica_num

    @elf_storage_policy_replica_num.setter
    def elf_storage_policy_replica_num(self, elf_storage_policy_replica_num):
        """Sets the elf_storage_policy_replica_num of this VmVolume.


        :param elf_storage_policy_replica_num: The elf_storage_policy_replica_num of this VmVolume.  # noqa: E501
        :type elf_storage_policy_replica_num: int
        """

        self._elf_storage_policy_replica_num = elf_storage_policy_replica_num

    @property
    def elf_storage_policy_thin_provision(self):
        """Gets the elf_storage_policy_thin_provision of this VmVolume.  # noqa: E501


        :return: The elf_storage_policy_thin_provision of this VmVolume.  # noqa: E501
        :rtype: bool
        """
        return self._elf_storage_policy_thin_provision

    @elf_storage_policy_thin_provision.setter
    def elf_storage_policy_thin_provision(self, elf_storage_policy_thin_provision):
        """Sets the elf_storage_policy_thin_provision of this VmVolume.


        :param elf_storage_policy_thin_provision: The elf_storage_policy_thin_provision of this VmVolume.  # noqa: E501
        :type elf_storage_policy_thin_provision: bool
        """

        self._elf_storage_policy_thin_provision = elf_storage_policy_thin_provision

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this VmVolume.  # noqa: E501


        :return: The entity_async_status of this VmVolume.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this VmVolume.


        :param entity_async_status: The entity_async_status of this VmVolume.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def guest_size_usage(self):
        """Gets the guest_size_usage of this VmVolume.  # noqa: E501


        :return: The guest_size_usage of this VmVolume.  # noqa: E501
        :rtype: float
        """
        return self._guest_size_usage

    @guest_size_usage.setter
    def guest_size_usage(self, guest_size_usage):
        """Sets the guest_size_usage of this VmVolume.


        :param guest_size_usage: The guest_size_usage of this VmVolume.  # noqa: E501
        :type guest_size_usage: float
        """

        self._guest_size_usage = guest_size_usage

    @property
    def guest_used_size(self):
        """Gets the guest_used_size of this VmVolume.  # noqa: E501


        :return: The guest_used_size of this VmVolume.  # noqa: E501
        :rtype: int
        """
        return self._guest_used_size

    @guest_used_size.setter
    def guest_used_size(self, guest_used_size):
        """Sets the guest_used_size of this VmVolume.


        :param guest_used_size: The guest_used_size of this VmVolume.  # noqa: E501
        :type guest_used_size: int
        """

        self._guest_used_size = guest_used_size

    @property
    def id(self):
        """Gets the id of this VmVolume.  # noqa: E501


        :return: The id of this VmVolume.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this VmVolume.


        :param id: The id of this VmVolume.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def labels(self):
        """Gets the labels of this VmVolume.  # noqa: E501


        :return: The labels of this VmVolume.  # noqa: E501
        :rtype: list[NestedLabel]
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this VmVolume.


        :param labels: The labels of this VmVolume.  # noqa: E501
        :type labels: list[NestedLabel]
        """

        self._labels = labels

    @property
    def local_created_at(self):
        """Gets the local_created_at of this VmVolume.  # noqa: E501


        :return: The local_created_at of this VmVolume.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at

    @local_created_at.setter
    def local_created_at(self, local_created_at):
        """Sets the local_created_at of this VmVolume.


        :param local_created_at: The local_created_at of this VmVolume.  # noqa: E501
        :type local_created_at: str
        """
        if self.local_vars_configuration.client_side_validation and local_created_at is None:  # noqa: E501
            raise ValueError("Invalid value for `local_created_at`, must not be `None`")  # noqa: E501

        self._local_created_at = local_created_at

    @property
    def local_id(self):
        """Gets the local_id of this VmVolume.  # noqa: E501


        :return: The local_id of this VmVolume.  # noqa: E501
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id):
        """Sets the local_id of this VmVolume.


        :param local_id: The local_id of this VmVolume.  # noqa: E501
        :type local_id: str
        """
        if self.local_vars_configuration.client_side_validation and local_id is None:  # noqa: E501
            raise ValueError("Invalid value for `local_id`, must not be `None`")  # noqa: E501

        self._local_id = local_id

    @property
    def lun(self):
        """Gets the lun of this VmVolume.  # noqa: E501


        :return: The lun of this VmVolume.  # noqa: E501
        :rtype: NestedIscsiLun
        """
        return self._lun

    @lun.setter
    def lun(self, lun):
        """Sets the lun of this VmVolume.


        :param lun: The lun of this VmVolume.  # noqa: E501
        :type lun: NestedIscsiLun
        """

        self._lun = lun

    @property
    def mounting(self):
        """Gets the mounting of this VmVolume.  # noqa: E501


        :return: The mounting of this VmVolume.  # noqa: E501
        :rtype: bool
        """
        return self._mounting

    @mounting.setter
    def mounting(self, mounting):
        """Sets the mounting of this VmVolume.


        :param mounting: The mounting of this VmVolume.  # noqa: E501
        :type mounting: bool
        """
        if self.local_vars_configuration.client_side_validation and mounting is None:  # noqa: E501
            raise ValueError("Invalid value for `mounting`, must not be `None`")  # noqa: E501

        self._mounting = mounting

    @property
    def name(self):
        """Gets the name of this VmVolume.  # noqa: E501


        :return: The name of this VmVolume.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this VmVolume.


        :param name: The name of this VmVolume.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def path(self):
        """Gets the path of this VmVolume.  # noqa: E501


        :return: The path of this VmVolume.  # noqa: E501
        :rtype: str
        """
        return self._path

    @path.setter
    def path(self, path):
        """Sets the path of this VmVolume.


        :param path: The path of this VmVolume.  # noqa: E501
        :type path: str
        """
        if self.local_vars_configuration.client_side_validation and path is None:  # noqa: E501
            raise ValueError("Invalid value for `path`, must not be `None`")  # noqa: E501

        self._path = path

    @property
    def resident_in_cache(self):
        """Gets the resident_in_cache of this VmVolume.  # noqa: E501


        :return: The resident_in_cache of this VmVolume.  # noqa: E501
        :rtype: bool
        """
        return self._resident_in_cache

    @resident_in_cache.setter
    def resident_in_cache(self, resident_in_cache):
        """Sets the resident_in_cache of this VmVolume.


        :param resident_in_cache: The resident_in_cache of this VmVolume.  # noqa: E501
        :type resident_in_cache: bool
        """

        self._resident_in_cache = resident_in_cache

    @property
    def sharing(self):
        """Gets the sharing of this VmVolume.  # noqa: E501


        :return: The sharing of this VmVolume.  # noqa: E501
        :rtype: bool
        """
        return self._sharing

    @sharing.setter
    def sharing(self, sharing):
        """Sets the sharing of this VmVolume.


        :param sharing: The sharing of this VmVolume.  # noqa: E501
        :type sharing: bool
        """
        if self.local_vars_configuration.client_side_validation and sharing is None:  # noqa: E501
            raise ValueError("Invalid value for `sharing`, must not be `None`")  # noqa: E501

        self._sharing = sharing

    @property
    def size(self):
        """Gets the size of this VmVolume.  # noqa: E501


        :return: The size of this VmVolume.  # noqa: E501
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size):
        """Sets the size of this VmVolume.


        :param size: The size of this VmVolume.  # noqa: E501
        :type size: int
        """
        if self.local_vars_configuration.client_side_validation and size is None:  # noqa: E501
            raise ValueError("Invalid value for `size`, must not be `None`")  # noqa: E501

        self._size = size

    @property
    def type(self):
        """Gets the type of this VmVolume.  # noqa: E501


        :return: The type of this VmVolume.  # noqa: E501
        :rtype: VmVolumeType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this VmVolume.


        :param type: The type of this VmVolume.  # noqa: E501
        :type type: VmVolumeType
        """

        self._type = type

    @property
    def unique_logical_size(self):
        """Gets the unique_logical_size of this VmVolume.  # noqa: E501


        :return: The unique_logical_size of this VmVolume.  # noqa: E501
        :rtype: float
        """
        return self._unique_logical_size

    @unique_logical_size.setter
    def unique_logical_size(self, unique_logical_size):
        """Sets the unique_logical_size of this VmVolume.


        :param unique_logical_size: The unique_logical_size of this VmVolume.  # noqa: E501
        :type unique_logical_size: float
        """

        self._unique_logical_size = unique_logical_size

    @property
    def unique_size(self):
        """Gets the unique_size of this VmVolume.  # noqa: E501


        :return: The unique_size of this VmVolume.  # noqa: E501
        :rtype: int
        """
        return self._unique_size

    @unique_size.setter
    def unique_size(self, unique_size):
        """Sets the unique_size of this VmVolume.


        :param unique_size: The unique_size of this VmVolume.  # noqa: E501
        :type unique_size: int
        """

        self._unique_size = unique_size

    @property
    def used_size(self):
        """Gets the used_size of this VmVolume.  # noqa: E501


        :return: The used_size of this VmVolume.  # noqa: E501
        :rtype: int
        """
        return self._used_size

    @used_size.setter
    def used_size(self, used_size):
        """Sets the used_size of this VmVolume.


        :param used_size: The used_size of this VmVolume.  # noqa: E501
        :type used_size: int
        """

        self._used_size = used_size

    @property
    def used_size_usage(self):
        """Gets the used_size_usage of this VmVolume.  # noqa: E501


        :return: The used_size_usage of this VmVolume.  # noqa: E501
        :rtype: float
        """
        return self._used_size_usage

    @used_size_usage.setter
    def used_size_usage(self, used_size_usage):
        """Sets the used_size_usage of this VmVolume.


        :param used_size_usage: The used_size_usage of this VmVolume.  # noqa: E501
        :type used_size_usage: float
        """

        self._used_size_usage = used_size_usage

    @property
    def vm_disks(self):
        """Gets the vm_disks of this VmVolume.  # noqa: E501


        :return: The vm_disks of this VmVolume.  # noqa: E501
        :rtype: list[NestedVmDisk]
        """
        return self._vm_disks

    @vm_disks.setter
    def vm_disks(self, vm_disks):
        """Sets the vm_disks of this VmVolume.


        :param vm_disks: The vm_disks of this VmVolume.  # noqa: E501
        :type vm_disks: list[NestedVmDisk]
        """

        self._vm_disks = vm_disks

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VmVolume):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VmVolume):
            return True

        return self.to_dict() != other.to_dict()
