# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class VmVolumeSnapshot(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'cluster': 'NestedCluster',
        'create_at': 'str',
        'description': 'str',
        'elf_storage_policy': 'VmVolumeElfStoragePolicyType',
        'elf_storage_policy_ec_k': 'int',
        'elf_storage_policy_ec_m': 'int',
        'elf_storage_policy_replica_num': 'int',
        'elf_storage_policy_thin_provision': 'bool',
        'entity_async_status': 'EntityAsyncStatus',
        'id': 'str',
        'labels': 'list[NestedLabel]',
        'local_created_at': 'str',
        'local_id': 'str',
        'name': 'str',
        'resident_in_cache': 'bool',
        'shared_size': 'float',
        'size': 'float',
        'type': 'VmVolumeSnapshotType',
        'unique_size': 'float',
        'vm_volume': 'NestedVmVolume',
        'volume_sharing': 'bool',
        'volume_size': 'float',
        'zbs_snapshot_uuid': 'str'
    }

    attribute_map = {
        'cluster': 'cluster',
        'create_at': 'createAt',
        'description': 'description',
        'elf_storage_policy': 'elf_storage_policy',
        'elf_storage_policy_ec_k': 'elf_storage_policy_ec_k',
        'elf_storage_policy_ec_m': 'elf_storage_policy_ec_m',
        'elf_storage_policy_replica_num': 'elf_storage_policy_replica_num',
        'elf_storage_policy_thin_provision': 'elf_storage_policy_thin_provision',
        'entity_async_status': 'entityAsyncStatus',
        'id': 'id',
        'labels': 'labels',
        'local_created_at': 'local_created_at',
        'local_id': 'local_id',
        'name': 'name',
        'resident_in_cache': 'resident_in_cache',
        'shared_size': 'shared_size',
        'size': 'size',
        'type': 'type',
        'unique_size': 'unique_size',
        'vm_volume': 'vm_volume',
        'volume_sharing': 'volume_sharing',
        'volume_size': 'volume_size',
        'zbs_snapshot_uuid': 'zbs_snapshot_uuid'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """VmVolumeSnapshot - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._cluster = None
        self._create_at = None
        self._description = None
        self._elf_storage_policy = None
        self._elf_storage_policy_ec_k = None
        self._elf_storage_policy_ec_m = None
        self._elf_storage_policy_replica_num = None
        self._elf_storage_policy_thin_provision = None
        self._entity_async_status = None
        self._id = None
        self._labels = None
        self._local_created_at = None
        self._local_id = None
        self._name = None
        self._resident_in_cache = None
        self._shared_size = None
        self._size = None
        self._type = None
        self._unique_size = None
        self._vm_volume = None
        self._volume_sharing = None
        self._volume_size = None
        self._zbs_snapshot_uuid = None
        self.discriminator = None

        if "cluster" in kwargs:
            self.cluster = kwargs["cluster"]
        self.create_at = kwargs.get("create_at", None)
        if "description" in kwargs:
            self.description = kwargs["description"]
        if "elf_storage_policy" in kwargs:
            self.elf_storage_policy = kwargs["elf_storage_policy"]
        self.elf_storage_policy_ec_k = kwargs.get("elf_storage_policy_ec_k", None)
        self.elf_storage_policy_ec_m = kwargs.get("elf_storage_policy_ec_m", None)
        self.elf_storage_policy_replica_num = kwargs.get("elf_storage_policy_replica_num", None)
        self.elf_storage_policy_thin_provision = kwargs.get("elf_storage_policy_thin_provision", None)
        self.entity_async_status = kwargs.get("entity_async_status", None)
        if "id" in kwargs:
            self.id = kwargs["id"]
        self.labels = kwargs.get("labels", None)
        if "local_created_at" in kwargs:
            self.local_created_at = kwargs["local_created_at"]
        if "local_id" in kwargs:
            self.local_id = kwargs["local_id"]
        if "name" in kwargs:
            self.name = kwargs["name"]
        self.resident_in_cache = kwargs.get("resident_in_cache", None)
        self.shared_size = kwargs.get("shared_size", None)
        self.size = kwargs.get("size", None)
        if "type" in kwargs:
            self.type = kwargs["type"]
        self.unique_size = kwargs.get("unique_size", None)
        self.vm_volume = kwargs.get("vm_volume", None)
        self.volume_sharing = kwargs.get("volume_sharing", None)
        self.volume_size = kwargs.get("volume_size", None)
        self.zbs_snapshot_uuid = kwargs.get("zbs_snapshot_uuid", None)

    @property
    def cluster(self):
        """Gets the cluster of this VmVolumeSnapshot.  # noqa: E501


        :return: The cluster of this VmVolumeSnapshot.  # noqa: E501
        :rtype: NestedCluster
        """
        return self._cluster

    @cluster.setter
    def cluster(self, cluster):
        """Sets the cluster of this VmVolumeSnapshot.


        :param cluster: The cluster of this VmVolumeSnapshot.  # noqa: E501
        :type cluster: NestedCluster
        """
        if self.local_vars_configuration.client_side_validation and cluster is None:  # noqa: E501
            raise ValueError("Invalid value for `cluster`, must not be `None`")  # noqa: E501

        self._cluster = cluster

    @property
    def create_at(self):
        """Gets the create_at of this VmVolumeSnapshot.  # noqa: E501


        :return: The create_at of this VmVolumeSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._create_at

    @create_at.setter
    def create_at(self, create_at):
        """Sets the create_at of this VmVolumeSnapshot.


        :param create_at: The create_at of this VmVolumeSnapshot.  # noqa: E501
        :type create_at: str
        """

        self._create_at = create_at

    @property
    def description(self):
        """Gets the description of this VmVolumeSnapshot.  # noqa: E501


        :return: The description of this VmVolumeSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this VmVolumeSnapshot.


        :param description: The description of this VmVolumeSnapshot.  # noqa: E501
        :type description: str
        """
        if self.local_vars_configuration.client_side_validation and description is None:  # noqa: E501
            raise ValueError("Invalid value for `description`, must not be `None`")  # noqa: E501

        self._description = description

    @property
    def elf_storage_policy(self):
        """Gets the elf_storage_policy of this VmVolumeSnapshot.  # noqa: E501


        :return: The elf_storage_policy of this VmVolumeSnapshot.  # noqa: E501
        :rtype: VmVolumeElfStoragePolicyType
        """
        return self._elf_storage_policy

    @elf_storage_policy.setter
    def elf_storage_policy(self, elf_storage_policy):
        """Sets the elf_storage_policy of this VmVolumeSnapshot.


        :param elf_storage_policy: The elf_storage_policy of this VmVolumeSnapshot.  # noqa: E501
        :type elf_storage_policy: VmVolumeElfStoragePolicyType
        """
        if self.local_vars_configuration.client_side_validation and elf_storage_policy is None:  # noqa: E501
            raise ValueError("Invalid value for `elf_storage_policy`, must not be `None`")  # noqa: E501

        self._elf_storage_policy = elf_storage_policy

    @property
    def elf_storage_policy_ec_k(self):
        """Gets the elf_storage_policy_ec_k of this VmVolumeSnapshot.  # noqa: E501


        :return: The elf_storage_policy_ec_k of this VmVolumeSnapshot.  # noqa: E501
        :rtype: int
        """
        return self._elf_storage_policy_ec_k

    @elf_storage_policy_ec_k.setter
    def elf_storage_policy_ec_k(self, elf_storage_policy_ec_k):
        """Sets the elf_storage_policy_ec_k of this VmVolumeSnapshot.


        :param elf_storage_policy_ec_k: The elf_storage_policy_ec_k of this VmVolumeSnapshot.  # noqa: E501
        :type elf_storage_policy_ec_k: int
        """

        self._elf_storage_policy_ec_k = elf_storage_policy_ec_k

    @property
    def elf_storage_policy_ec_m(self):
        """Gets the elf_storage_policy_ec_m of this VmVolumeSnapshot.  # noqa: E501


        :return: The elf_storage_policy_ec_m of this VmVolumeSnapshot.  # noqa: E501
        :rtype: int
        """
        return self._elf_storage_policy_ec_m

    @elf_storage_policy_ec_m.setter
    def elf_storage_policy_ec_m(self, elf_storage_policy_ec_m):
        """Sets the elf_storage_policy_ec_m of this VmVolumeSnapshot.


        :param elf_storage_policy_ec_m: The elf_storage_policy_ec_m of this VmVolumeSnapshot.  # noqa: E501
        :type elf_storage_policy_ec_m: int
        """

        self._elf_storage_policy_ec_m = elf_storage_policy_ec_m

    @property
    def elf_storage_policy_replica_num(self):
        """Gets the elf_storage_policy_replica_num of this VmVolumeSnapshot.  # noqa: E501


        :return: The elf_storage_policy_replica_num of this VmVolumeSnapshot.  # noqa: E501
        :rtype: int
        """
        return self._elf_storage_policy_replica_num

    @elf_storage_policy_replica_num.setter
    def elf_storage_policy_replica_num(self, elf_storage_policy_replica_num):
        """Sets the elf_storage_policy_replica_num of this VmVolumeSnapshot.


        :param elf_storage_policy_replica_num: The elf_storage_policy_replica_num of this VmVolumeSnapshot.  # noqa: E501
        :type elf_storage_policy_replica_num: int
        """

        self._elf_storage_policy_replica_num = elf_storage_policy_replica_num

    @property
    def elf_storage_policy_thin_provision(self):
        """Gets the elf_storage_policy_thin_provision of this VmVolumeSnapshot.  # noqa: E501


        :return: The elf_storage_policy_thin_provision of this VmVolumeSnapshot.  # noqa: E501
        :rtype: bool
        """
        return self._elf_storage_policy_thin_provision

    @elf_storage_policy_thin_provision.setter
    def elf_storage_policy_thin_provision(self, elf_storage_policy_thin_provision):
        """Sets the elf_storage_policy_thin_provision of this VmVolumeSnapshot.


        :param elf_storage_policy_thin_provision: The elf_storage_policy_thin_provision of this VmVolumeSnapshot.  # noqa: E501
        :type elf_storage_policy_thin_provision: bool
        """

        self._elf_storage_policy_thin_provision = elf_storage_policy_thin_provision

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this VmVolumeSnapshot.  # noqa: E501


        :return: The entity_async_status of this VmVolumeSnapshot.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this VmVolumeSnapshot.


        :param entity_async_status: The entity_async_status of this VmVolumeSnapshot.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def id(self):
        """Gets the id of this VmVolumeSnapshot.  # noqa: E501


        :return: The id of this VmVolumeSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this VmVolumeSnapshot.


        :param id: The id of this VmVolumeSnapshot.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def labels(self):
        """Gets the labels of this VmVolumeSnapshot.  # noqa: E501


        :return: The labels of this VmVolumeSnapshot.  # noqa: E501
        :rtype: list[NestedLabel]
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this VmVolumeSnapshot.


        :param labels: The labels of this VmVolumeSnapshot.  # noqa: E501
        :type labels: list[NestedLabel]
        """

        self._labels = labels

    @property
    def local_created_at(self):
        """Gets the local_created_at of this VmVolumeSnapshot.  # noqa: E501


        :return: The local_created_at of this VmVolumeSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at

    @local_created_at.setter
    def local_created_at(self, local_created_at):
        """Sets the local_created_at of this VmVolumeSnapshot.


        :param local_created_at: The local_created_at of this VmVolumeSnapshot.  # noqa: E501
        :type local_created_at: str
        """
        if self.local_vars_configuration.client_side_validation and local_created_at is None:  # noqa: E501
            raise ValueError("Invalid value for `local_created_at`, must not be `None`")  # noqa: E501

        self._local_created_at = local_created_at

    @property
    def local_id(self):
        """Gets the local_id of this VmVolumeSnapshot.  # noqa: E501


        :return: The local_id of this VmVolumeSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id):
        """Sets the local_id of this VmVolumeSnapshot.


        :param local_id: The local_id of this VmVolumeSnapshot.  # noqa: E501
        :type local_id: str
        """
        if self.local_vars_configuration.client_side_validation and local_id is None:  # noqa: E501
            raise ValueError("Invalid value for `local_id`, must not be `None`")  # noqa: E501

        self._local_id = local_id

    @property
    def name(self):
        """Gets the name of this VmVolumeSnapshot.  # noqa: E501


        :return: The name of this VmVolumeSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this VmVolumeSnapshot.


        :param name: The name of this VmVolumeSnapshot.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def resident_in_cache(self):
        """Gets the resident_in_cache of this VmVolumeSnapshot.  # noqa: E501


        :return: The resident_in_cache of this VmVolumeSnapshot.  # noqa: E501
        :rtype: bool
        """
        return self._resident_in_cache

    @resident_in_cache.setter
    def resident_in_cache(self, resident_in_cache):
        """Sets the resident_in_cache of this VmVolumeSnapshot.


        :param resident_in_cache: The resident_in_cache of this VmVolumeSnapshot.  # noqa: E501
        :type resident_in_cache: bool
        """

        self._resident_in_cache = resident_in_cache

    @property
    def shared_size(self):
        """Gets the shared_size of this VmVolumeSnapshot.  # noqa: E501


        :return: The shared_size of this VmVolumeSnapshot.  # noqa: E501
        :rtype: float
        """
        return self._shared_size

    @shared_size.setter
    def shared_size(self, shared_size):
        """Sets the shared_size of this VmVolumeSnapshot.


        :param shared_size: The shared_size of this VmVolumeSnapshot.  # noqa: E501
        :type shared_size: float
        """

        self._shared_size = shared_size

    @property
    def size(self):
        """Gets the size of this VmVolumeSnapshot.  # noqa: E501


        :return: The size of this VmVolumeSnapshot.  # noqa: E501
        :rtype: float
        """
        return self._size

    @size.setter
    def size(self, size):
        """Sets the size of this VmVolumeSnapshot.


        :param size: The size of this VmVolumeSnapshot.  # noqa: E501
        :type size: float
        """

        self._size = size

    @property
    def type(self):
        """Gets the type of this VmVolumeSnapshot.  # noqa: E501


        :return: The type of this VmVolumeSnapshot.  # noqa: E501
        :rtype: VmVolumeSnapshotType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this VmVolumeSnapshot.


        :param type: The type of this VmVolumeSnapshot.  # noqa: E501
        :type type: VmVolumeSnapshotType
        """
        if self.local_vars_configuration.client_side_validation and type is None:  # noqa: E501
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501

        self._type = type

    @property
    def unique_size(self):
        """Gets the unique_size of this VmVolumeSnapshot.  # noqa: E501


        :return: The unique_size of this VmVolumeSnapshot.  # noqa: E501
        :rtype: float
        """
        return self._unique_size

    @unique_size.setter
    def unique_size(self, unique_size):
        """Sets the unique_size of this VmVolumeSnapshot.


        :param unique_size: The unique_size of this VmVolumeSnapshot.  # noqa: E501
        :type unique_size: float
        """

        self._unique_size = unique_size

    @property
    def vm_volume(self):
        """Gets the vm_volume of this VmVolumeSnapshot.  # noqa: E501


        :return: The vm_volume of this VmVolumeSnapshot.  # noqa: E501
        :rtype: NestedVmVolume
        """
        return self._vm_volume

    @vm_volume.setter
    def vm_volume(self, vm_volume):
        """Sets the vm_volume of this VmVolumeSnapshot.


        :param vm_volume: The vm_volume of this VmVolumeSnapshot.  # noqa: E501
        :type vm_volume: NestedVmVolume
        """

        self._vm_volume = vm_volume

    @property
    def volume_sharing(self):
        """Gets the volume_sharing of this VmVolumeSnapshot.  # noqa: E501


        :return: The volume_sharing of this VmVolumeSnapshot.  # noqa: E501
        :rtype: bool
        """
        return self._volume_sharing

    @volume_sharing.setter
    def volume_sharing(self, volume_sharing):
        """Sets the volume_sharing of this VmVolumeSnapshot.


        :param volume_sharing: The volume_sharing of this VmVolumeSnapshot.  # noqa: E501
        :type volume_sharing: bool
        """

        self._volume_sharing = volume_sharing

    @property
    def volume_size(self):
        """Gets the volume_size of this VmVolumeSnapshot.  # noqa: E501


        :return: The volume_size of this VmVolumeSnapshot.  # noqa: E501
        :rtype: float
        """
        return self._volume_size

    @volume_size.setter
    def volume_size(self, volume_size):
        """Sets the volume_size of this VmVolumeSnapshot.


        :param volume_size: The volume_size of this VmVolumeSnapshot.  # noqa: E501
        :type volume_size: float
        """

        self._volume_size = volume_size

    @property
    def zbs_snapshot_uuid(self):
        """Gets the zbs_snapshot_uuid of this VmVolumeSnapshot.  # noqa: E501


        :return: The zbs_snapshot_uuid of this VmVolumeSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._zbs_snapshot_uuid

    @zbs_snapshot_uuid.setter
    def zbs_snapshot_uuid(self, zbs_snapshot_uuid):
        """Sets the zbs_snapshot_uuid of this VmVolumeSnapshot.


        :param zbs_snapshot_uuid: The zbs_snapshot_uuid of this VmVolumeSnapshot.  # noqa: E501
        :type zbs_snapshot_uuid: str
        """

        self._zbs_snapshot_uuid = zbs_snapshot_uuid

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VmVolumeSnapshot):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VmVolumeSnapshot):
            return True

        return self.to_dict() != other.to_dict()
