# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class VmVolumeSnapshotWhereInput(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        '_and': 'list[VmVolumeSnapshotWhereInput]',
        '_not': 'list[VmVolumeSnapshotWhereInput]',
        '_or': 'list[VmVolumeSnapshotWhereInput]',
        'cluster': 'ClusterWhereInput',
        'create_at': 'str',
        'create_at_gt': 'str',
        'create_at_gte': 'str',
        'create_at_in': 'list[str]',
        'create_at_lt': 'str',
        'create_at_lte': 'str',
        'create_at_not': 'str',
        'create_at_not_in': 'list[str]',
        'description': 'str',
        'description_contains': 'str',
        'description_ends_with': 'str',
        'description_gt': 'str',
        'description_gte': 'str',
        'description_in': 'list[str]',
        'description_lt': 'str',
        'description_lte': 'str',
        'description_not': 'str',
        'description_not_contains': 'str',
        'description_not_ends_with': 'str',
        'description_not_in': 'list[str]',
        'description_not_starts_with': 'str',
        'description_starts_with': 'str',
        'elf_storage_policy': 'VmVolumeElfStoragePolicyType',
        'elf_storage_policy_ec_k': 'int',
        'elf_storage_policy_ec_k_gt': 'int',
        'elf_storage_policy_ec_k_gte': 'int',
        'elf_storage_policy_ec_k_in': 'list[int]',
        'elf_storage_policy_ec_k_lt': 'int',
        'elf_storage_policy_ec_k_lte': 'int',
        'elf_storage_policy_ec_k_not': 'int',
        'elf_storage_policy_ec_k_not_in': 'list[int]',
        'elf_storage_policy_ec_m': 'int',
        'elf_storage_policy_ec_m_gt': 'int',
        'elf_storage_policy_ec_m_gte': 'int',
        'elf_storage_policy_ec_m_in': 'list[int]',
        'elf_storage_policy_ec_m_lt': 'int',
        'elf_storage_policy_ec_m_lte': 'int',
        'elf_storage_policy_ec_m_not': 'int',
        'elf_storage_policy_ec_m_not_in': 'list[int]',
        'elf_storage_policy_in': 'list[VmVolumeElfStoragePolicyType]',
        'elf_storage_policy_not': 'VmVolumeElfStoragePolicyType',
        'elf_storage_policy_not_in': 'list[VmVolumeElfStoragePolicyType]',
        'elf_storage_policy_replica_num': 'int',
        'elf_storage_policy_replica_num_gt': 'int',
        'elf_storage_policy_replica_num_gte': 'int',
        'elf_storage_policy_replica_num_in': 'list[int]',
        'elf_storage_policy_replica_num_lt': 'int',
        'elf_storage_policy_replica_num_lte': 'int',
        'elf_storage_policy_replica_num_not': 'int',
        'elf_storage_policy_replica_num_not_in': 'list[int]',
        'elf_storage_policy_thin_provision': 'bool',
        'elf_storage_policy_thin_provision_not': 'bool',
        'entity_async_status': 'EntityAsyncStatus',
        'entity_async_status_in': 'list[EntityAsyncStatus]',
        'entity_async_status_not': 'EntityAsyncStatus',
        'entity_async_status_not_in': 'list[EntityAsyncStatus]',
        'id': 'str',
        'id_contains': 'str',
        'id_ends_with': 'str',
        'id_gt': 'str',
        'id_gte': 'str',
        'id_in': 'list[str]',
        'id_lt': 'str',
        'id_lte': 'str',
        'id_not': 'str',
        'id_not_contains': 'str',
        'id_not_ends_with': 'str',
        'id_not_in': 'list[str]',
        'id_not_starts_with': 'str',
        'id_starts_with': 'str',
        'labels_every': 'LabelWhereInput',
        'labels_none': 'LabelWhereInput',
        'labels_some': 'LabelWhereInput',
        'local_created_at': 'str',
        'local_created_at_gt': 'str',
        'local_created_at_gte': 'str',
        'local_created_at_in': 'list[str]',
        'local_created_at_lt': 'str',
        'local_created_at_lte': 'str',
        'local_created_at_not': 'str',
        'local_created_at_not_in': 'list[str]',
        'local_id': 'str',
        'local_id_contains': 'str',
        'local_id_ends_with': 'str',
        'local_id_gt': 'str',
        'local_id_gte': 'str',
        'local_id_in': 'list[str]',
        'local_id_lt': 'str',
        'local_id_lte': 'str',
        'local_id_not': 'str',
        'local_id_not_contains': 'str',
        'local_id_not_ends_with': 'str',
        'local_id_not_in': 'list[str]',
        'local_id_not_starts_with': 'str',
        'local_id_starts_with': 'str',
        'name': 'str',
        'name_contains': 'str',
        'name_ends_with': 'str',
        'name_gt': 'str',
        'name_gte': 'str',
        'name_in': 'list[str]',
        'name_lt': 'str',
        'name_lte': 'str',
        'name_not': 'str',
        'name_not_contains': 'str',
        'name_not_ends_with': 'str',
        'name_not_in': 'list[str]',
        'name_not_starts_with': 'str',
        'name_starts_with': 'str',
        'resident_in_cache': 'bool',
        'resident_in_cache_not': 'bool',
        'shared_size': 'float',
        'shared_size_gt': 'float',
        'shared_size_gte': 'float',
        'shared_size_in': 'list[float]',
        'shared_size_lt': 'float',
        'shared_size_lte': 'float',
        'shared_size_not': 'float',
        'shared_size_not_in': 'list[float]',
        'size': 'float',
        'size_gt': 'float',
        'size_gte': 'float',
        'size_in': 'list[float]',
        'size_lt': 'float',
        'size_lte': 'float',
        'size_not': 'float',
        'size_not_in': 'list[float]',
        'type': 'VmVolumeSnapshotType',
        'type_in': 'list[VmVolumeSnapshotType]',
        'type_not': 'VmVolumeSnapshotType',
        'type_not_in': 'list[VmVolumeSnapshotType]',
        'unique_size': 'float',
        'unique_size_gt': 'float',
        'unique_size_gte': 'float',
        'unique_size_in': 'list[float]',
        'unique_size_lt': 'float',
        'unique_size_lte': 'float',
        'unique_size_not': 'float',
        'unique_size_not_in': 'list[float]',
        'vm_volume': 'VmVolumeWhereInput',
        'volume_sharing': 'bool',
        'volume_sharing_not': 'bool',
        'volume_size': 'float',
        'volume_size_gt': 'float',
        'volume_size_gte': 'float',
        'volume_size_in': 'list[float]',
        'volume_size_lt': 'float',
        'volume_size_lte': 'float',
        'volume_size_not': 'float',
        'volume_size_not_in': 'list[float]',
        'zbs_snapshot_uuid': 'str',
        'zbs_snapshot_uuid_contains': 'str',
        'zbs_snapshot_uuid_ends_with': 'str',
        'zbs_snapshot_uuid_gt': 'str',
        'zbs_snapshot_uuid_gte': 'str',
        'zbs_snapshot_uuid_in': 'list[str]',
        'zbs_snapshot_uuid_lt': 'str',
        'zbs_snapshot_uuid_lte': 'str',
        'zbs_snapshot_uuid_not': 'str',
        'zbs_snapshot_uuid_not_contains': 'str',
        'zbs_snapshot_uuid_not_ends_with': 'str',
        'zbs_snapshot_uuid_not_in': 'list[str]',
        'zbs_snapshot_uuid_not_starts_with': 'str',
        'zbs_snapshot_uuid_starts_with': 'str'
    }

    attribute_map = {
        '_and': 'AND',
        '_not': 'NOT',
        '_or': 'OR',
        'cluster': 'cluster',
        'create_at': 'createAt',
        'create_at_gt': 'createAt_gt',
        'create_at_gte': 'createAt_gte',
        'create_at_in': 'createAt_in',
        'create_at_lt': 'createAt_lt',
        'create_at_lte': 'createAt_lte',
        'create_at_not': 'createAt_not',
        'create_at_not_in': 'createAt_not_in',
        'description': 'description',
        'description_contains': 'description_contains',
        'description_ends_with': 'description_ends_with',
        'description_gt': 'description_gt',
        'description_gte': 'description_gte',
        'description_in': 'description_in',
        'description_lt': 'description_lt',
        'description_lte': 'description_lte',
        'description_not': 'description_not',
        'description_not_contains': 'description_not_contains',
        'description_not_ends_with': 'description_not_ends_with',
        'description_not_in': 'description_not_in',
        'description_not_starts_with': 'description_not_starts_with',
        'description_starts_with': 'description_starts_with',
        'elf_storage_policy': 'elf_storage_policy',
        'elf_storage_policy_ec_k': 'elf_storage_policy_ec_k',
        'elf_storage_policy_ec_k_gt': 'elf_storage_policy_ec_k_gt',
        'elf_storage_policy_ec_k_gte': 'elf_storage_policy_ec_k_gte',
        'elf_storage_policy_ec_k_in': 'elf_storage_policy_ec_k_in',
        'elf_storage_policy_ec_k_lt': 'elf_storage_policy_ec_k_lt',
        'elf_storage_policy_ec_k_lte': 'elf_storage_policy_ec_k_lte',
        'elf_storage_policy_ec_k_not': 'elf_storage_policy_ec_k_not',
        'elf_storage_policy_ec_k_not_in': 'elf_storage_policy_ec_k_not_in',
        'elf_storage_policy_ec_m': 'elf_storage_policy_ec_m',
        'elf_storage_policy_ec_m_gt': 'elf_storage_policy_ec_m_gt',
        'elf_storage_policy_ec_m_gte': 'elf_storage_policy_ec_m_gte',
        'elf_storage_policy_ec_m_in': 'elf_storage_policy_ec_m_in',
        'elf_storage_policy_ec_m_lt': 'elf_storage_policy_ec_m_lt',
        'elf_storage_policy_ec_m_lte': 'elf_storage_policy_ec_m_lte',
        'elf_storage_policy_ec_m_not': 'elf_storage_policy_ec_m_not',
        'elf_storage_policy_ec_m_not_in': 'elf_storage_policy_ec_m_not_in',
        'elf_storage_policy_in': 'elf_storage_policy_in',
        'elf_storage_policy_not': 'elf_storage_policy_not',
        'elf_storage_policy_not_in': 'elf_storage_policy_not_in',
        'elf_storage_policy_replica_num': 'elf_storage_policy_replica_num',
        'elf_storage_policy_replica_num_gt': 'elf_storage_policy_replica_num_gt',
        'elf_storage_policy_replica_num_gte': 'elf_storage_policy_replica_num_gte',
        'elf_storage_policy_replica_num_in': 'elf_storage_policy_replica_num_in',
        'elf_storage_policy_replica_num_lt': 'elf_storage_policy_replica_num_lt',
        'elf_storage_policy_replica_num_lte': 'elf_storage_policy_replica_num_lte',
        'elf_storage_policy_replica_num_not': 'elf_storage_policy_replica_num_not',
        'elf_storage_policy_replica_num_not_in': 'elf_storage_policy_replica_num_not_in',
        'elf_storage_policy_thin_provision': 'elf_storage_policy_thin_provision',
        'elf_storage_policy_thin_provision_not': 'elf_storage_policy_thin_provision_not',
        'entity_async_status': 'entityAsyncStatus',
        'entity_async_status_in': 'entityAsyncStatus_in',
        'entity_async_status_not': 'entityAsyncStatus_not',
        'entity_async_status_not_in': 'entityAsyncStatus_not_in',
        'id': 'id',
        'id_contains': 'id_contains',
        'id_ends_with': 'id_ends_with',
        'id_gt': 'id_gt',
        'id_gte': 'id_gte',
        'id_in': 'id_in',
        'id_lt': 'id_lt',
        'id_lte': 'id_lte',
        'id_not': 'id_not',
        'id_not_contains': 'id_not_contains',
        'id_not_ends_with': 'id_not_ends_with',
        'id_not_in': 'id_not_in',
        'id_not_starts_with': 'id_not_starts_with',
        'id_starts_with': 'id_starts_with',
        'labels_every': 'labels_every',
        'labels_none': 'labels_none',
        'labels_some': 'labels_some',
        'local_created_at': 'local_created_at',
        'local_created_at_gt': 'local_created_at_gt',
        'local_created_at_gte': 'local_created_at_gte',
        'local_created_at_in': 'local_created_at_in',
        'local_created_at_lt': 'local_created_at_lt',
        'local_created_at_lte': 'local_created_at_lte',
        'local_created_at_not': 'local_created_at_not',
        'local_created_at_not_in': 'local_created_at_not_in',
        'local_id': 'local_id',
        'local_id_contains': 'local_id_contains',
        'local_id_ends_with': 'local_id_ends_with',
        'local_id_gt': 'local_id_gt',
        'local_id_gte': 'local_id_gte',
        'local_id_in': 'local_id_in',
        'local_id_lt': 'local_id_lt',
        'local_id_lte': 'local_id_lte',
        'local_id_not': 'local_id_not',
        'local_id_not_contains': 'local_id_not_contains',
        'local_id_not_ends_with': 'local_id_not_ends_with',
        'local_id_not_in': 'local_id_not_in',
        'local_id_not_starts_with': 'local_id_not_starts_with',
        'local_id_starts_with': 'local_id_starts_with',
        'name': 'name',
        'name_contains': 'name_contains',
        'name_ends_with': 'name_ends_with',
        'name_gt': 'name_gt',
        'name_gte': 'name_gte',
        'name_in': 'name_in',
        'name_lt': 'name_lt',
        'name_lte': 'name_lte',
        'name_not': 'name_not',
        'name_not_contains': 'name_not_contains',
        'name_not_ends_with': 'name_not_ends_with',
        'name_not_in': 'name_not_in',
        'name_not_starts_with': 'name_not_starts_with',
        'name_starts_with': 'name_starts_with',
        'resident_in_cache': 'resident_in_cache',
        'resident_in_cache_not': 'resident_in_cache_not',
        'shared_size': 'shared_size',
        'shared_size_gt': 'shared_size_gt',
        'shared_size_gte': 'shared_size_gte',
        'shared_size_in': 'shared_size_in',
        'shared_size_lt': 'shared_size_lt',
        'shared_size_lte': 'shared_size_lte',
        'shared_size_not': 'shared_size_not',
        'shared_size_not_in': 'shared_size_not_in',
        'size': 'size',
        'size_gt': 'size_gt',
        'size_gte': 'size_gte',
        'size_in': 'size_in',
        'size_lt': 'size_lt',
        'size_lte': 'size_lte',
        'size_not': 'size_not',
        'size_not_in': 'size_not_in',
        'type': 'type',
        'type_in': 'type_in',
        'type_not': 'type_not',
        'type_not_in': 'type_not_in',
        'unique_size': 'unique_size',
        'unique_size_gt': 'unique_size_gt',
        'unique_size_gte': 'unique_size_gte',
        'unique_size_in': 'unique_size_in',
        'unique_size_lt': 'unique_size_lt',
        'unique_size_lte': 'unique_size_lte',
        'unique_size_not': 'unique_size_not',
        'unique_size_not_in': 'unique_size_not_in',
        'vm_volume': 'vm_volume',
        'volume_sharing': 'volume_sharing',
        'volume_sharing_not': 'volume_sharing_not',
        'volume_size': 'volume_size',
        'volume_size_gt': 'volume_size_gt',
        'volume_size_gte': 'volume_size_gte',
        'volume_size_in': 'volume_size_in',
        'volume_size_lt': 'volume_size_lt',
        'volume_size_lte': 'volume_size_lte',
        'volume_size_not': 'volume_size_not',
        'volume_size_not_in': 'volume_size_not_in',
        'zbs_snapshot_uuid': 'zbs_snapshot_uuid',
        'zbs_snapshot_uuid_contains': 'zbs_snapshot_uuid_contains',
        'zbs_snapshot_uuid_ends_with': 'zbs_snapshot_uuid_ends_with',
        'zbs_snapshot_uuid_gt': 'zbs_snapshot_uuid_gt',
        'zbs_snapshot_uuid_gte': 'zbs_snapshot_uuid_gte',
        'zbs_snapshot_uuid_in': 'zbs_snapshot_uuid_in',
        'zbs_snapshot_uuid_lt': 'zbs_snapshot_uuid_lt',
        'zbs_snapshot_uuid_lte': 'zbs_snapshot_uuid_lte',
        'zbs_snapshot_uuid_not': 'zbs_snapshot_uuid_not',
        'zbs_snapshot_uuid_not_contains': 'zbs_snapshot_uuid_not_contains',
        'zbs_snapshot_uuid_not_ends_with': 'zbs_snapshot_uuid_not_ends_with',
        'zbs_snapshot_uuid_not_in': 'zbs_snapshot_uuid_not_in',
        'zbs_snapshot_uuid_not_starts_with': 'zbs_snapshot_uuid_not_starts_with',
        'zbs_snapshot_uuid_starts_with': 'zbs_snapshot_uuid_starts_with'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """VmVolumeSnapshotWhereInput - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self.__and = None
        self.__not = None
        self.__or = None
        self._cluster = None
        self._create_at = None
        self._create_at_gt = None
        self._create_at_gte = None
        self._create_at_in = None
        self._create_at_lt = None
        self._create_at_lte = None
        self._create_at_not = None
        self._create_at_not_in = None
        self._description = None
        self._description_contains = None
        self._description_ends_with = None
        self._description_gt = None
        self._description_gte = None
        self._description_in = None
        self._description_lt = None
        self._description_lte = None
        self._description_not = None
        self._description_not_contains = None
        self._description_not_ends_with = None
        self._description_not_in = None
        self._description_not_starts_with = None
        self._description_starts_with = None
        self._elf_storage_policy = None
        self._elf_storage_policy_ec_k = None
        self._elf_storage_policy_ec_k_gt = None
        self._elf_storage_policy_ec_k_gte = None
        self._elf_storage_policy_ec_k_in = None
        self._elf_storage_policy_ec_k_lt = None
        self._elf_storage_policy_ec_k_lte = None
        self._elf_storage_policy_ec_k_not = None
        self._elf_storage_policy_ec_k_not_in = None
        self._elf_storage_policy_ec_m = None
        self._elf_storage_policy_ec_m_gt = None
        self._elf_storage_policy_ec_m_gte = None
        self._elf_storage_policy_ec_m_in = None
        self._elf_storage_policy_ec_m_lt = None
        self._elf_storage_policy_ec_m_lte = None
        self._elf_storage_policy_ec_m_not = None
        self._elf_storage_policy_ec_m_not_in = None
        self._elf_storage_policy_in = None
        self._elf_storage_policy_not = None
        self._elf_storage_policy_not_in = None
        self._elf_storage_policy_replica_num = None
        self._elf_storage_policy_replica_num_gt = None
        self._elf_storage_policy_replica_num_gte = None
        self._elf_storage_policy_replica_num_in = None
        self._elf_storage_policy_replica_num_lt = None
        self._elf_storage_policy_replica_num_lte = None
        self._elf_storage_policy_replica_num_not = None
        self._elf_storage_policy_replica_num_not_in = None
        self._elf_storage_policy_thin_provision = None
        self._elf_storage_policy_thin_provision_not = None
        self._entity_async_status = None
        self._entity_async_status_in = None
        self._entity_async_status_not = None
        self._entity_async_status_not_in = None
        self._id = None
        self._id_contains = None
        self._id_ends_with = None
        self._id_gt = None
        self._id_gte = None
        self._id_in = None
        self._id_lt = None
        self._id_lte = None
        self._id_not = None
        self._id_not_contains = None
        self._id_not_ends_with = None
        self._id_not_in = None
        self._id_not_starts_with = None
        self._id_starts_with = None
        self._labels_every = None
        self._labels_none = None
        self._labels_some = None
        self._local_created_at = None
        self._local_created_at_gt = None
        self._local_created_at_gte = None
        self._local_created_at_in = None
        self._local_created_at_lt = None
        self._local_created_at_lte = None
        self._local_created_at_not = None
        self._local_created_at_not_in = None
        self._local_id = None
        self._local_id_contains = None
        self._local_id_ends_with = None
        self._local_id_gt = None
        self._local_id_gte = None
        self._local_id_in = None
        self._local_id_lt = None
        self._local_id_lte = None
        self._local_id_not = None
        self._local_id_not_contains = None
        self._local_id_not_ends_with = None
        self._local_id_not_in = None
        self._local_id_not_starts_with = None
        self._local_id_starts_with = None
        self._name = None
        self._name_contains = None
        self._name_ends_with = None
        self._name_gt = None
        self._name_gte = None
        self._name_in = None
        self._name_lt = None
        self._name_lte = None
        self._name_not = None
        self._name_not_contains = None
        self._name_not_ends_with = None
        self._name_not_in = None
        self._name_not_starts_with = None
        self._name_starts_with = None
        self._resident_in_cache = None
        self._resident_in_cache_not = None
        self._shared_size = None
        self._shared_size_gt = None
        self._shared_size_gte = None
        self._shared_size_in = None
        self._shared_size_lt = None
        self._shared_size_lte = None
        self._shared_size_not = None
        self._shared_size_not_in = None
        self._size = None
        self._size_gt = None
        self._size_gte = None
        self._size_in = None
        self._size_lt = None
        self._size_lte = None
        self._size_not = None
        self._size_not_in = None
        self._type = None
        self._type_in = None
        self._type_not = None
        self._type_not_in = None
        self._unique_size = None
        self._unique_size_gt = None
        self._unique_size_gte = None
        self._unique_size_in = None
        self._unique_size_lt = None
        self._unique_size_lte = None
        self._unique_size_not = None
        self._unique_size_not_in = None
        self._vm_volume = None
        self._volume_sharing = None
        self._volume_sharing_not = None
        self._volume_size = None
        self._volume_size_gt = None
        self._volume_size_gte = None
        self._volume_size_in = None
        self._volume_size_lt = None
        self._volume_size_lte = None
        self._volume_size_not = None
        self._volume_size_not_in = None
        self._zbs_snapshot_uuid = None
        self._zbs_snapshot_uuid_contains = None
        self._zbs_snapshot_uuid_ends_with = None
        self._zbs_snapshot_uuid_gt = None
        self._zbs_snapshot_uuid_gte = None
        self._zbs_snapshot_uuid_in = None
        self._zbs_snapshot_uuid_lt = None
        self._zbs_snapshot_uuid_lte = None
        self._zbs_snapshot_uuid_not = None
        self._zbs_snapshot_uuid_not_contains = None
        self._zbs_snapshot_uuid_not_ends_with = None
        self._zbs_snapshot_uuid_not_in = None
        self._zbs_snapshot_uuid_not_starts_with = None
        self._zbs_snapshot_uuid_starts_with = None
        self.discriminator = None

        self._and = kwargs.get("_and", None)
        self._not = kwargs.get("_not", None)
        self._or = kwargs.get("_or", None)
        self.cluster = kwargs.get("cluster", None)
        self.create_at = kwargs.get("create_at", None)
        self.create_at_gt = kwargs.get("create_at_gt", None)
        self.create_at_gte = kwargs.get("create_at_gte", None)
        self.create_at_in = kwargs.get("create_at_in", None)
        self.create_at_lt = kwargs.get("create_at_lt", None)
        self.create_at_lte = kwargs.get("create_at_lte", None)
        self.create_at_not = kwargs.get("create_at_not", None)
        self.create_at_not_in = kwargs.get("create_at_not_in", None)
        self.description = kwargs.get("description", None)
        self.description_contains = kwargs.get("description_contains", None)
        self.description_ends_with = kwargs.get("description_ends_with", None)
        self.description_gt = kwargs.get("description_gt", None)
        self.description_gte = kwargs.get("description_gte", None)
        self.description_in = kwargs.get("description_in", None)
        self.description_lt = kwargs.get("description_lt", None)
        self.description_lte = kwargs.get("description_lte", None)
        self.description_not = kwargs.get("description_not", None)
        self.description_not_contains = kwargs.get("description_not_contains", None)
        self.description_not_ends_with = kwargs.get("description_not_ends_with", None)
        self.description_not_in = kwargs.get("description_not_in", None)
        self.description_not_starts_with = kwargs.get("description_not_starts_with", None)
        self.description_starts_with = kwargs.get("description_starts_with", None)
        self.elf_storage_policy = kwargs.get("elf_storage_policy", None)
        self.elf_storage_policy_ec_k = kwargs.get("elf_storage_policy_ec_k", None)
        self.elf_storage_policy_ec_k_gt = kwargs.get("elf_storage_policy_ec_k_gt", None)
        self.elf_storage_policy_ec_k_gte = kwargs.get("elf_storage_policy_ec_k_gte", None)
        self.elf_storage_policy_ec_k_in = kwargs.get("elf_storage_policy_ec_k_in", None)
        self.elf_storage_policy_ec_k_lt = kwargs.get("elf_storage_policy_ec_k_lt", None)
        self.elf_storage_policy_ec_k_lte = kwargs.get("elf_storage_policy_ec_k_lte", None)
        self.elf_storage_policy_ec_k_not = kwargs.get("elf_storage_policy_ec_k_not", None)
        self.elf_storage_policy_ec_k_not_in = kwargs.get("elf_storage_policy_ec_k_not_in", None)
        self.elf_storage_policy_ec_m = kwargs.get("elf_storage_policy_ec_m", None)
        self.elf_storage_policy_ec_m_gt = kwargs.get("elf_storage_policy_ec_m_gt", None)
        self.elf_storage_policy_ec_m_gte = kwargs.get("elf_storage_policy_ec_m_gte", None)
        self.elf_storage_policy_ec_m_in = kwargs.get("elf_storage_policy_ec_m_in", None)
        self.elf_storage_policy_ec_m_lt = kwargs.get("elf_storage_policy_ec_m_lt", None)
        self.elf_storage_policy_ec_m_lte = kwargs.get("elf_storage_policy_ec_m_lte", None)
        self.elf_storage_policy_ec_m_not = kwargs.get("elf_storage_policy_ec_m_not", None)
        self.elf_storage_policy_ec_m_not_in = kwargs.get("elf_storage_policy_ec_m_not_in", None)
        self.elf_storage_policy_in = kwargs.get("elf_storage_policy_in", None)
        self.elf_storage_policy_not = kwargs.get("elf_storage_policy_not", None)
        self.elf_storage_policy_not_in = kwargs.get("elf_storage_policy_not_in", None)
        self.elf_storage_policy_replica_num = kwargs.get("elf_storage_policy_replica_num", None)
        self.elf_storage_policy_replica_num_gt = kwargs.get("elf_storage_policy_replica_num_gt", None)
        self.elf_storage_policy_replica_num_gte = kwargs.get("elf_storage_policy_replica_num_gte", None)
        self.elf_storage_policy_replica_num_in = kwargs.get("elf_storage_policy_replica_num_in", None)
        self.elf_storage_policy_replica_num_lt = kwargs.get("elf_storage_policy_replica_num_lt", None)
        self.elf_storage_policy_replica_num_lte = kwargs.get("elf_storage_policy_replica_num_lte", None)
        self.elf_storage_policy_replica_num_not = kwargs.get("elf_storage_policy_replica_num_not", None)
        self.elf_storage_policy_replica_num_not_in = kwargs.get("elf_storage_policy_replica_num_not_in", None)
        self.elf_storage_policy_thin_provision = kwargs.get("elf_storage_policy_thin_provision", None)
        self.elf_storage_policy_thin_provision_not = kwargs.get("elf_storage_policy_thin_provision_not", None)
        self.entity_async_status = kwargs.get("entity_async_status", None)
        self.entity_async_status_in = kwargs.get("entity_async_status_in", None)
        self.entity_async_status_not = kwargs.get("entity_async_status_not", None)
        self.entity_async_status_not_in = kwargs.get("entity_async_status_not_in", None)
        self.id = kwargs.get("id", None)
        self.id_contains = kwargs.get("id_contains", None)
        self.id_ends_with = kwargs.get("id_ends_with", None)
        self.id_gt = kwargs.get("id_gt", None)
        self.id_gte = kwargs.get("id_gte", None)
        self.id_in = kwargs.get("id_in", None)
        self.id_lt = kwargs.get("id_lt", None)
        self.id_lte = kwargs.get("id_lte", None)
        self.id_not = kwargs.get("id_not", None)
        self.id_not_contains = kwargs.get("id_not_contains", None)
        self.id_not_ends_with = kwargs.get("id_not_ends_with", None)
        self.id_not_in = kwargs.get("id_not_in", None)
        self.id_not_starts_with = kwargs.get("id_not_starts_with", None)
        self.id_starts_with = kwargs.get("id_starts_with", None)
        self.labels_every = kwargs.get("labels_every", None)
        self.labels_none = kwargs.get("labels_none", None)
        self.labels_some = kwargs.get("labels_some", None)
        self.local_created_at = kwargs.get("local_created_at", None)
        self.local_created_at_gt = kwargs.get("local_created_at_gt", None)
        self.local_created_at_gte = kwargs.get("local_created_at_gte", None)
        self.local_created_at_in = kwargs.get("local_created_at_in", None)
        self.local_created_at_lt = kwargs.get("local_created_at_lt", None)
        self.local_created_at_lte = kwargs.get("local_created_at_lte", None)
        self.local_created_at_not = kwargs.get("local_created_at_not", None)
        self.local_created_at_not_in = kwargs.get("local_created_at_not_in", None)
        self.local_id = kwargs.get("local_id", None)
        self.local_id_contains = kwargs.get("local_id_contains", None)
        self.local_id_ends_with = kwargs.get("local_id_ends_with", None)
        self.local_id_gt = kwargs.get("local_id_gt", None)
        self.local_id_gte = kwargs.get("local_id_gte", None)
        self.local_id_in = kwargs.get("local_id_in", None)
        self.local_id_lt = kwargs.get("local_id_lt", None)
        self.local_id_lte = kwargs.get("local_id_lte", None)
        self.local_id_not = kwargs.get("local_id_not", None)
        self.local_id_not_contains = kwargs.get("local_id_not_contains", None)
        self.local_id_not_ends_with = kwargs.get("local_id_not_ends_with", None)
        self.local_id_not_in = kwargs.get("local_id_not_in", None)
        self.local_id_not_starts_with = kwargs.get("local_id_not_starts_with", None)
        self.local_id_starts_with = kwargs.get("local_id_starts_with", None)
        self.name = kwargs.get("name", None)
        self.name_contains = kwargs.get("name_contains", None)
        self.name_ends_with = kwargs.get("name_ends_with", None)
        self.name_gt = kwargs.get("name_gt", None)
        self.name_gte = kwargs.get("name_gte", None)
        self.name_in = kwargs.get("name_in", None)
        self.name_lt = kwargs.get("name_lt", None)
        self.name_lte = kwargs.get("name_lte", None)
        self.name_not = kwargs.get("name_not", None)
        self.name_not_contains = kwargs.get("name_not_contains", None)
        self.name_not_ends_with = kwargs.get("name_not_ends_with", None)
        self.name_not_in = kwargs.get("name_not_in", None)
        self.name_not_starts_with = kwargs.get("name_not_starts_with", None)
        self.name_starts_with = kwargs.get("name_starts_with", None)
        self.resident_in_cache = kwargs.get("resident_in_cache", None)
        self.resident_in_cache_not = kwargs.get("resident_in_cache_not", None)
        self.shared_size = kwargs.get("shared_size", None)
        self.shared_size_gt = kwargs.get("shared_size_gt", None)
        self.shared_size_gte = kwargs.get("shared_size_gte", None)
        self.shared_size_in = kwargs.get("shared_size_in", None)
        self.shared_size_lt = kwargs.get("shared_size_lt", None)
        self.shared_size_lte = kwargs.get("shared_size_lte", None)
        self.shared_size_not = kwargs.get("shared_size_not", None)
        self.shared_size_not_in = kwargs.get("shared_size_not_in", None)
        self.size = kwargs.get("size", None)
        self.size_gt = kwargs.get("size_gt", None)
        self.size_gte = kwargs.get("size_gte", None)
        self.size_in = kwargs.get("size_in", None)
        self.size_lt = kwargs.get("size_lt", None)
        self.size_lte = kwargs.get("size_lte", None)
        self.size_not = kwargs.get("size_not", None)
        self.size_not_in = kwargs.get("size_not_in", None)
        self.type = kwargs.get("type", None)
        self.type_in = kwargs.get("type_in", None)
        self.type_not = kwargs.get("type_not", None)
        self.type_not_in = kwargs.get("type_not_in", None)
        self.unique_size = kwargs.get("unique_size", None)
        self.unique_size_gt = kwargs.get("unique_size_gt", None)
        self.unique_size_gte = kwargs.get("unique_size_gte", None)
        self.unique_size_in = kwargs.get("unique_size_in", None)
        self.unique_size_lt = kwargs.get("unique_size_lt", None)
        self.unique_size_lte = kwargs.get("unique_size_lte", None)
        self.unique_size_not = kwargs.get("unique_size_not", None)
        self.unique_size_not_in = kwargs.get("unique_size_not_in", None)
        self.vm_volume = kwargs.get("vm_volume", None)
        self.volume_sharing = kwargs.get("volume_sharing", None)
        self.volume_sharing_not = kwargs.get("volume_sharing_not", None)
        self.volume_size = kwargs.get("volume_size", None)
        self.volume_size_gt = kwargs.get("volume_size_gt", None)
        self.volume_size_gte = kwargs.get("volume_size_gte", None)
        self.volume_size_in = kwargs.get("volume_size_in", None)
        self.volume_size_lt = kwargs.get("volume_size_lt", None)
        self.volume_size_lte = kwargs.get("volume_size_lte", None)
        self.volume_size_not = kwargs.get("volume_size_not", None)
        self.volume_size_not_in = kwargs.get("volume_size_not_in", None)
        self.zbs_snapshot_uuid = kwargs.get("zbs_snapshot_uuid", None)
        self.zbs_snapshot_uuid_contains = kwargs.get("zbs_snapshot_uuid_contains", None)
        self.zbs_snapshot_uuid_ends_with = kwargs.get("zbs_snapshot_uuid_ends_with", None)
        self.zbs_snapshot_uuid_gt = kwargs.get("zbs_snapshot_uuid_gt", None)
        self.zbs_snapshot_uuid_gte = kwargs.get("zbs_snapshot_uuid_gte", None)
        self.zbs_snapshot_uuid_in = kwargs.get("zbs_snapshot_uuid_in", None)
        self.zbs_snapshot_uuid_lt = kwargs.get("zbs_snapshot_uuid_lt", None)
        self.zbs_snapshot_uuid_lte = kwargs.get("zbs_snapshot_uuid_lte", None)
        self.zbs_snapshot_uuid_not = kwargs.get("zbs_snapshot_uuid_not", None)
        self.zbs_snapshot_uuid_not_contains = kwargs.get("zbs_snapshot_uuid_not_contains", None)
        self.zbs_snapshot_uuid_not_ends_with = kwargs.get("zbs_snapshot_uuid_not_ends_with", None)
        self.zbs_snapshot_uuid_not_in = kwargs.get("zbs_snapshot_uuid_not_in", None)
        self.zbs_snapshot_uuid_not_starts_with = kwargs.get("zbs_snapshot_uuid_not_starts_with", None)
        self.zbs_snapshot_uuid_starts_with = kwargs.get("zbs_snapshot_uuid_starts_with", None)

    @property
    def _and(self):
        """Gets the _and of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The _and of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: list[VmVolumeSnapshotWhereInput]
        """
        return self.__and

    @_and.setter
    def _and(self, _and):
        """Sets the _and of this VmVolumeSnapshotWhereInput.


        :param _and: The _and of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type _and: list[VmVolumeSnapshotWhereInput]
        """

        self.__and = _and

    @property
    def _not(self):
        """Gets the _not of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The _not of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: list[VmVolumeSnapshotWhereInput]
        """
        return self.__not

    @_not.setter
    def _not(self, _not):
        """Sets the _not of this VmVolumeSnapshotWhereInput.


        :param _not: The _not of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type _not: list[VmVolumeSnapshotWhereInput]
        """

        self.__not = _not

    @property
    def _or(self):
        """Gets the _or of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The _or of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: list[VmVolumeSnapshotWhereInput]
        """
        return self.__or

    @_or.setter
    def _or(self, _or):
        """Sets the _or of this VmVolumeSnapshotWhereInput.


        :param _or: The _or of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type _or: list[VmVolumeSnapshotWhereInput]
        """

        self.__or = _or

    @property
    def cluster(self):
        """Gets the cluster of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The cluster of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: ClusterWhereInput
        """
        return self._cluster

    @cluster.setter
    def cluster(self, cluster):
        """Sets the cluster of this VmVolumeSnapshotWhereInput.


        :param cluster: The cluster of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type cluster: ClusterWhereInput
        """

        self._cluster = cluster

    @property
    def create_at(self):
        """Gets the create_at of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The create_at of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._create_at

    @create_at.setter
    def create_at(self, create_at):
        """Sets the create_at of this VmVolumeSnapshotWhereInput.


        :param create_at: The create_at of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type create_at: str
        """

        self._create_at = create_at

    @property
    def create_at_gt(self):
        """Gets the create_at_gt of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The create_at_gt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._create_at_gt

    @create_at_gt.setter
    def create_at_gt(self, create_at_gt):
        """Sets the create_at_gt of this VmVolumeSnapshotWhereInput.


        :param create_at_gt: The create_at_gt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type create_at_gt: str
        """

        self._create_at_gt = create_at_gt

    @property
    def create_at_gte(self):
        """Gets the create_at_gte of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The create_at_gte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._create_at_gte

    @create_at_gte.setter
    def create_at_gte(self, create_at_gte):
        """Sets the create_at_gte of this VmVolumeSnapshotWhereInput.


        :param create_at_gte: The create_at_gte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type create_at_gte: str
        """

        self._create_at_gte = create_at_gte

    @property
    def create_at_in(self):
        """Gets the create_at_in of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The create_at_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._create_at_in

    @create_at_in.setter
    def create_at_in(self, create_at_in):
        """Sets the create_at_in of this VmVolumeSnapshotWhereInput.


        :param create_at_in: The create_at_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type create_at_in: list[str]
        """

        self._create_at_in = create_at_in

    @property
    def create_at_lt(self):
        """Gets the create_at_lt of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The create_at_lt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._create_at_lt

    @create_at_lt.setter
    def create_at_lt(self, create_at_lt):
        """Sets the create_at_lt of this VmVolumeSnapshotWhereInput.


        :param create_at_lt: The create_at_lt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type create_at_lt: str
        """

        self._create_at_lt = create_at_lt

    @property
    def create_at_lte(self):
        """Gets the create_at_lte of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The create_at_lte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._create_at_lte

    @create_at_lte.setter
    def create_at_lte(self, create_at_lte):
        """Sets the create_at_lte of this VmVolumeSnapshotWhereInput.


        :param create_at_lte: The create_at_lte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type create_at_lte: str
        """

        self._create_at_lte = create_at_lte

    @property
    def create_at_not(self):
        """Gets the create_at_not of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The create_at_not of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._create_at_not

    @create_at_not.setter
    def create_at_not(self, create_at_not):
        """Sets the create_at_not of this VmVolumeSnapshotWhereInput.


        :param create_at_not: The create_at_not of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type create_at_not: str
        """

        self._create_at_not = create_at_not

    @property
    def create_at_not_in(self):
        """Gets the create_at_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The create_at_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._create_at_not_in

    @create_at_not_in.setter
    def create_at_not_in(self, create_at_not_in):
        """Sets the create_at_not_in of this VmVolumeSnapshotWhereInput.


        :param create_at_not_in: The create_at_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type create_at_not_in: list[str]
        """

        self._create_at_not_in = create_at_not_in

    @property
    def description(self):
        """Gets the description of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The description of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this VmVolumeSnapshotWhereInput.


        :param description: The description of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def description_contains(self):
        """Gets the description_contains of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The description_contains of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_contains

    @description_contains.setter
    def description_contains(self, description_contains):
        """Sets the description_contains of this VmVolumeSnapshotWhereInput.


        :param description_contains: The description_contains of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type description_contains: str
        """

        self._description_contains = description_contains

    @property
    def description_ends_with(self):
        """Gets the description_ends_with of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The description_ends_with of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_ends_with

    @description_ends_with.setter
    def description_ends_with(self, description_ends_with):
        """Sets the description_ends_with of this VmVolumeSnapshotWhereInput.


        :param description_ends_with: The description_ends_with of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type description_ends_with: str
        """

        self._description_ends_with = description_ends_with

    @property
    def description_gt(self):
        """Gets the description_gt of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The description_gt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_gt

    @description_gt.setter
    def description_gt(self, description_gt):
        """Sets the description_gt of this VmVolumeSnapshotWhereInput.


        :param description_gt: The description_gt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type description_gt: str
        """

        self._description_gt = description_gt

    @property
    def description_gte(self):
        """Gets the description_gte of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The description_gte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_gte

    @description_gte.setter
    def description_gte(self, description_gte):
        """Sets the description_gte of this VmVolumeSnapshotWhereInput.


        :param description_gte: The description_gte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type description_gte: str
        """

        self._description_gte = description_gte

    @property
    def description_in(self):
        """Gets the description_in of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The description_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._description_in

    @description_in.setter
    def description_in(self, description_in):
        """Sets the description_in of this VmVolumeSnapshotWhereInput.


        :param description_in: The description_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type description_in: list[str]
        """

        self._description_in = description_in

    @property
    def description_lt(self):
        """Gets the description_lt of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The description_lt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_lt

    @description_lt.setter
    def description_lt(self, description_lt):
        """Sets the description_lt of this VmVolumeSnapshotWhereInput.


        :param description_lt: The description_lt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type description_lt: str
        """

        self._description_lt = description_lt

    @property
    def description_lte(self):
        """Gets the description_lte of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The description_lte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_lte

    @description_lte.setter
    def description_lte(self, description_lte):
        """Sets the description_lte of this VmVolumeSnapshotWhereInput.


        :param description_lte: The description_lte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type description_lte: str
        """

        self._description_lte = description_lte

    @property
    def description_not(self):
        """Gets the description_not of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The description_not of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_not

    @description_not.setter
    def description_not(self, description_not):
        """Sets the description_not of this VmVolumeSnapshotWhereInput.


        :param description_not: The description_not of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type description_not: str
        """

        self._description_not = description_not

    @property
    def description_not_contains(self):
        """Gets the description_not_contains of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The description_not_contains of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_not_contains

    @description_not_contains.setter
    def description_not_contains(self, description_not_contains):
        """Sets the description_not_contains of this VmVolumeSnapshotWhereInput.


        :param description_not_contains: The description_not_contains of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type description_not_contains: str
        """

        self._description_not_contains = description_not_contains

    @property
    def description_not_ends_with(self):
        """Gets the description_not_ends_with of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The description_not_ends_with of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_not_ends_with

    @description_not_ends_with.setter
    def description_not_ends_with(self, description_not_ends_with):
        """Sets the description_not_ends_with of this VmVolumeSnapshotWhereInput.


        :param description_not_ends_with: The description_not_ends_with of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type description_not_ends_with: str
        """

        self._description_not_ends_with = description_not_ends_with

    @property
    def description_not_in(self):
        """Gets the description_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The description_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._description_not_in

    @description_not_in.setter
    def description_not_in(self, description_not_in):
        """Sets the description_not_in of this VmVolumeSnapshotWhereInput.


        :param description_not_in: The description_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type description_not_in: list[str]
        """

        self._description_not_in = description_not_in

    @property
    def description_not_starts_with(self):
        """Gets the description_not_starts_with of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The description_not_starts_with of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_not_starts_with

    @description_not_starts_with.setter
    def description_not_starts_with(self, description_not_starts_with):
        """Sets the description_not_starts_with of this VmVolumeSnapshotWhereInput.


        :param description_not_starts_with: The description_not_starts_with of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type description_not_starts_with: str
        """

        self._description_not_starts_with = description_not_starts_with

    @property
    def description_starts_with(self):
        """Gets the description_starts_with of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The description_starts_with of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_starts_with

    @description_starts_with.setter
    def description_starts_with(self, description_starts_with):
        """Sets the description_starts_with of this VmVolumeSnapshotWhereInput.


        :param description_starts_with: The description_starts_with of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type description_starts_with: str
        """

        self._description_starts_with = description_starts_with

    @property
    def elf_storage_policy(self):
        """Gets the elf_storage_policy of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The elf_storage_policy of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: VmVolumeElfStoragePolicyType
        """
        return self._elf_storage_policy

    @elf_storage_policy.setter
    def elf_storage_policy(self, elf_storage_policy):
        """Sets the elf_storage_policy of this VmVolumeSnapshotWhereInput.


        :param elf_storage_policy: The elf_storage_policy of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type elf_storage_policy: VmVolumeElfStoragePolicyType
        """

        self._elf_storage_policy = elf_storage_policy

    @property
    def elf_storage_policy_ec_k(self):
        """Gets the elf_storage_policy_ec_k of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The elf_storage_policy_ec_k of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._elf_storage_policy_ec_k

    @elf_storage_policy_ec_k.setter
    def elf_storage_policy_ec_k(self, elf_storage_policy_ec_k):
        """Sets the elf_storage_policy_ec_k of this VmVolumeSnapshotWhereInput.


        :param elf_storage_policy_ec_k: The elf_storage_policy_ec_k of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type elf_storage_policy_ec_k: int
        """

        self._elf_storage_policy_ec_k = elf_storage_policy_ec_k

    @property
    def elf_storage_policy_ec_k_gt(self):
        """Gets the elf_storage_policy_ec_k_gt of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The elf_storage_policy_ec_k_gt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._elf_storage_policy_ec_k_gt

    @elf_storage_policy_ec_k_gt.setter
    def elf_storage_policy_ec_k_gt(self, elf_storage_policy_ec_k_gt):
        """Sets the elf_storage_policy_ec_k_gt of this VmVolumeSnapshotWhereInput.


        :param elf_storage_policy_ec_k_gt: The elf_storage_policy_ec_k_gt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type elf_storage_policy_ec_k_gt: int
        """

        self._elf_storage_policy_ec_k_gt = elf_storage_policy_ec_k_gt

    @property
    def elf_storage_policy_ec_k_gte(self):
        """Gets the elf_storage_policy_ec_k_gte of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The elf_storage_policy_ec_k_gte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._elf_storage_policy_ec_k_gte

    @elf_storage_policy_ec_k_gte.setter
    def elf_storage_policy_ec_k_gte(self, elf_storage_policy_ec_k_gte):
        """Sets the elf_storage_policy_ec_k_gte of this VmVolumeSnapshotWhereInput.


        :param elf_storage_policy_ec_k_gte: The elf_storage_policy_ec_k_gte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type elf_storage_policy_ec_k_gte: int
        """

        self._elf_storage_policy_ec_k_gte = elf_storage_policy_ec_k_gte

    @property
    def elf_storage_policy_ec_k_in(self):
        """Gets the elf_storage_policy_ec_k_in of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The elf_storage_policy_ec_k_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._elf_storage_policy_ec_k_in

    @elf_storage_policy_ec_k_in.setter
    def elf_storage_policy_ec_k_in(self, elf_storage_policy_ec_k_in):
        """Sets the elf_storage_policy_ec_k_in of this VmVolumeSnapshotWhereInput.


        :param elf_storage_policy_ec_k_in: The elf_storage_policy_ec_k_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type elf_storage_policy_ec_k_in: list[int]
        """

        self._elf_storage_policy_ec_k_in = elf_storage_policy_ec_k_in

    @property
    def elf_storage_policy_ec_k_lt(self):
        """Gets the elf_storage_policy_ec_k_lt of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The elf_storage_policy_ec_k_lt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._elf_storage_policy_ec_k_lt

    @elf_storage_policy_ec_k_lt.setter
    def elf_storage_policy_ec_k_lt(self, elf_storage_policy_ec_k_lt):
        """Sets the elf_storage_policy_ec_k_lt of this VmVolumeSnapshotWhereInput.


        :param elf_storage_policy_ec_k_lt: The elf_storage_policy_ec_k_lt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type elf_storage_policy_ec_k_lt: int
        """

        self._elf_storage_policy_ec_k_lt = elf_storage_policy_ec_k_lt

    @property
    def elf_storage_policy_ec_k_lte(self):
        """Gets the elf_storage_policy_ec_k_lte of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The elf_storage_policy_ec_k_lte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._elf_storage_policy_ec_k_lte

    @elf_storage_policy_ec_k_lte.setter
    def elf_storage_policy_ec_k_lte(self, elf_storage_policy_ec_k_lte):
        """Sets the elf_storage_policy_ec_k_lte of this VmVolumeSnapshotWhereInput.


        :param elf_storage_policy_ec_k_lte: The elf_storage_policy_ec_k_lte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type elf_storage_policy_ec_k_lte: int
        """

        self._elf_storage_policy_ec_k_lte = elf_storage_policy_ec_k_lte

    @property
    def elf_storage_policy_ec_k_not(self):
        """Gets the elf_storage_policy_ec_k_not of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The elf_storage_policy_ec_k_not of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._elf_storage_policy_ec_k_not

    @elf_storage_policy_ec_k_not.setter
    def elf_storage_policy_ec_k_not(self, elf_storage_policy_ec_k_not):
        """Sets the elf_storage_policy_ec_k_not of this VmVolumeSnapshotWhereInput.


        :param elf_storage_policy_ec_k_not: The elf_storage_policy_ec_k_not of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type elf_storage_policy_ec_k_not: int
        """

        self._elf_storage_policy_ec_k_not = elf_storage_policy_ec_k_not

    @property
    def elf_storage_policy_ec_k_not_in(self):
        """Gets the elf_storage_policy_ec_k_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The elf_storage_policy_ec_k_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._elf_storage_policy_ec_k_not_in

    @elf_storage_policy_ec_k_not_in.setter
    def elf_storage_policy_ec_k_not_in(self, elf_storage_policy_ec_k_not_in):
        """Sets the elf_storage_policy_ec_k_not_in of this VmVolumeSnapshotWhereInput.


        :param elf_storage_policy_ec_k_not_in: The elf_storage_policy_ec_k_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type elf_storage_policy_ec_k_not_in: list[int]
        """

        self._elf_storage_policy_ec_k_not_in = elf_storage_policy_ec_k_not_in

    @property
    def elf_storage_policy_ec_m(self):
        """Gets the elf_storage_policy_ec_m of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The elf_storage_policy_ec_m of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._elf_storage_policy_ec_m

    @elf_storage_policy_ec_m.setter
    def elf_storage_policy_ec_m(self, elf_storage_policy_ec_m):
        """Sets the elf_storage_policy_ec_m of this VmVolumeSnapshotWhereInput.


        :param elf_storage_policy_ec_m: The elf_storage_policy_ec_m of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type elf_storage_policy_ec_m: int
        """

        self._elf_storage_policy_ec_m = elf_storage_policy_ec_m

    @property
    def elf_storage_policy_ec_m_gt(self):
        """Gets the elf_storage_policy_ec_m_gt of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The elf_storage_policy_ec_m_gt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._elf_storage_policy_ec_m_gt

    @elf_storage_policy_ec_m_gt.setter
    def elf_storage_policy_ec_m_gt(self, elf_storage_policy_ec_m_gt):
        """Sets the elf_storage_policy_ec_m_gt of this VmVolumeSnapshotWhereInput.


        :param elf_storage_policy_ec_m_gt: The elf_storage_policy_ec_m_gt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type elf_storage_policy_ec_m_gt: int
        """

        self._elf_storage_policy_ec_m_gt = elf_storage_policy_ec_m_gt

    @property
    def elf_storage_policy_ec_m_gte(self):
        """Gets the elf_storage_policy_ec_m_gte of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The elf_storage_policy_ec_m_gte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._elf_storage_policy_ec_m_gte

    @elf_storage_policy_ec_m_gte.setter
    def elf_storage_policy_ec_m_gte(self, elf_storage_policy_ec_m_gte):
        """Sets the elf_storage_policy_ec_m_gte of this VmVolumeSnapshotWhereInput.


        :param elf_storage_policy_ec_m_gte: The elf_storage_policy_ec_m_gte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type elf_storage_policy_ec_m_gte: int
        """

        self._elf_storage_policy_ec_m_gte = elf_storage_policy_ec_m_gte

    @property
    def elf_storage_policy_ec_m_in(self):
        """Gets the elf_storage_policy_ec_m_in of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The elf_storage_policy_ec_m_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._elf_storage_policy_ec_m_in

    @elf_storage_policy_ec_m_in.setter
    def elf_storage_policy_ec_m_in(self, elf_storage_policy_ec_m_in):
        """Sets the elf_storage_policy_ec_m_in of this VmVolumeSnapshotWhereInput.


        :param elf_storage_policy_ec_m_in: The elf_storage_policy_ec_m_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type elf_storage_policy_ec_m_in: list[int]
        """

        self._elf_storage_policy_ec_m_in = elf_storage_policy_ec_m_in

    @property
    def elf_storage_policy_ec_m_lt(self):
        """Gets the elf_storage_policy_ec_m_lt of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The elf_storage_policy_ec_m_lt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._elf_storage_policy_ec_m_lt

    @elf_storage_policy_ec_m_lt.setter
    def elf_storage_policy_ec_m_lt(self, elf_storage_policy_ec_m_lt):
        """Sets the elf_storage_policy_ec_m_lt of this VmVolumeSnapshotWhereInput.


        :param elf_storage_policy_ec_m_lt: The elf_storage_policy_ec_m_lt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type elf_storage_policy_ec_m_lt: int
        """

        self._elf_storage_policy_ec_m_lt = elf_storage_policy_ec_m_lt

    @property
    def elf_storage_policy_ec_m_lte(self):
        """Gets the elf_storage_policy_ec_m_lte of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The elf_storage_policy_ec_m_lte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._elf_storage_policy_ec_m_lte

    @elf_storage_policy_ec_m_lte.setter
    def elf_storage_policy_ec_m_lte(self, elf_storage_policy_ec_m_lte):
        """Sets the elf_storage_policy_ec_m_lte of this VmVolumeSnapshotWhereInput.


        :param elf_storage_policy_ec_m_lte: The elf_storage_policy_ec_m_lte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type elf_storage_policy_ec_m_lte: int
        """

        self._elf_storage_policy_ec_m_lte = elf_storage_policy_ec_m_lte

    @property
    def elf_storage_policy_ec_m_not(self):
        """Gets the elf_storage_policy_ec_m_not of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The elf_storage_policy_ec_m_not of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._elf_storage_policy_ec_m_not

    @elf_storage_policy_ec_m_not.setter
    def elf_storage_policy_ec_m_not(self, elf_storage_policy_ec_m_not):
        """Sets the elf_storage_policy_ec_m_not of this VmVolumeSnapshotWhereInput.


        :param elf_storage_policy_ec_m_not: The elf_storage_policy_ec_m_not of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type elf_storage_policy_ec_m_not: int
        """

        self._elf_storage_policy_ec_m_not = elf_storage_policy_ec_m_not

    @property
    def elf_storage_policy_ec_m_not_in(self):
        """Gets the elf_storage_policy_ec_m_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The elf_storage_policy_ec_m_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._elf_storage_policy_ec_m_not_in

    @elf_storage_policy_ec_m_not_in.setter
    def elf_storage_policy_ec_m_not_in(self, elf_storage_policy_ec_m_not_in):
        """Sets the elf_storage_policy_ec_m_not_in of this VmVolumeSnapshotWhereInput.


        :param elf_storage_policy_ec_m_not_in: The elf_storage_policy_ec_m_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type elf_storage_policy_ec_m_not_in: list[int]
        """

        self._elf_storage_policy_ec_m_not_in = elf_storage_policy_ec_m_not_in

    @property
    def elf_storage_policy_in(self):
        """Gets the elf_storage_policy_in of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The elf_storage_policy_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: list[VmVolumeElfStoragePolicyType]
        """
        return self._elf_storage_policy_in

    @elf_storage_policy_in.setter
    def elf_storage_policy_in(self, elf_storage_policy_in):
        """Sets the elf_storage_policy_in of this VmVolumeSnapshotWhereInput.


        :param elf_storage_policy_in: The elf_storage_policy_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type elf_storage_policy_in: list[VmVolumeElfStoragePolicyType]
        """

        self._elf_storage_policy_in = elf_storage_policy_in

    @property
    def elf_storage_policy_not(self):
        """Gets the elf_storage_policy_not of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The elf_storage_policy_not of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: VmVolumeElfStoragePolicyType
        """
        return self._elf_storage_policy_not

    @elf_storage_policy_not.setter
    def elf_storage_policy_not(self, elf_storage_policy_not):
        """Sets the elf_storage_policy_not of this VmVolumeSnapshotWhereInput.


        :param elf_storage_policy_not: The elf_storage_policy_not of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type elf_storage_policy_not: VmVolumeElfStoragePolicyType
        """

        self._elf_storage_policy_not = elf_storage_policy_not

    @property
    def elf_storage_policy_not_in(self):
        """Gets the elf_storage_policy_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The elf_storage_policy_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: list[VmVolumeElfStoragePolicyType]
        """
        return self._elf_storage_policy_not_in

    @elf_storage_policy_not_in.setter
    def elf_storage_policy_not_in(self, elf_storage_policy_not_in):
        """Sets the elf_storage_policy_not_in of this VmVolumeSnapshotWhereInput.


        :param elf_storage_policy_not_in: The elf_storage_policy_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type elf_storage_policy_not_in: list[VmVolumeElfStoragePolicyType]
        """

        self._elf_storage_policy_not_in = elf_storage_policy_not_in

    @property
    def elf_storage_policy_replica_num(self):
        """Gets the elf_storage_policy_replica_num of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The elf_storage_policy_replica_num of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._elf_storage_policy_replica_num

    @elf_storage_policy_replica_num.setter
    def elf_storage_policy_replica_num(self, elf_storage_policy_replica_num):
        """Sets the elf_storage_policy_replica_num of this VmVolumeSnapshotWhereInput.


        :param elf_storage_policy_replica_num: The elf_storage_policy_replica_num of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type elf_storage_policy_replica_num: int
        """

        self._elf_storage_policy_replica_num = elf_storage_policy_replica_num

    @property
    def elf_storage_policy_replica_num_gt(self):
        """Gets the elf_storage_policy_replica_num_gt of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The elf_storage_policy_replica_num_gt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._elf_storage_policy_replica_num_gt

    @elf_storage_policy_replica_num_gt.setter
    def elf_storage_policy_replica_num_gt(self, elf_storage_policy_replica_num_gt):
        """Sets the elf_storage_policy_replica_num_gt of this VmVolumeSnapshotWhereInput.


        :param elf_storage_policy_replica_num_gt: The elf_storage_policy_replica_num_gt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type elf_storage_policy_replica_num_gt: int
        """

        self._elf_storage_policy_replica_num_gt = elf_storage_policy_replica_num_gt

    @property
    def elf_storage_policy_replica_num_gte(self):
        """Gets the elf_storage_policy_replica_num_gte of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The elf_storage_policy_replica_num_gte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._elf_storage_policy_replica_num_gte

    @elf_storage_policy_replica_num_gte.setter
    def elf_storage_policy_replica_num_gte(self, elf_storage_policy_replica_num_gte):
        """Sets the elf_storage_policy_replica_num_gte of this VmVolumeSnapshotWhereInput.


        :param elf_storage_policy_replica_num_gte: The elf_storage_policy_replica_num_gte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type elf_storage_policy_replica_num_gte: int
        """

        self._elf_storage_policy_replica_num_gte = elf_storage_policy_replica_num_gte

    @property
    def elf_storage_policy_replica_num_in(self):
        """Gets the elf_storage_policy_replica_num_in of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The elf_storage_policy_replica_num_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._elf_storage_policy_replica_num_in

    @elf_storage_policy_replica_num_in.setter
    def elf_storage_policy_replica_num_in(self, elf_storage_policy_replica_num_in):
        """Sets the elf_storage_policy_replica_num_in of this VmVolumeSnapshotWhereInput.


        :param elf_storage_policy_replica_num_in: The elf_storage_policy_replica_num_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type elf_storage_policy_replica_num_in: list[int]
        """

        self._elf_storage_policy_replica_num_in = elf_storage_policy_replica_num_in

    @property
    def elf_storage_policy_replica_num_lt(self):
        """Gets the elf_storage_policy_replica_num_lt of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The elf_storage_policy_replica_num_lt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._elf_storage_policy_replica_num_lt

    @elf_storage_policy_replica_num_lt.setter
    def elf_storage_policy_replica_num_lt(self, elf_storage_policy_replica_num_lt):
        """Sets the elf_storage_policy_replica_num_lt of this VmVolumeSnapshotWhereInput.


        :param elf_storage_policy_replica_num_lt: The elf_storage_policy_replica_num_lt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type elf_storage_policy_replica_num_lt: int
        """

        self._elf_storage_policy_replica_num_lt = elf_storage_policy_replica_num_lt

    @property
    def elf_storage_policy_replica_num_lte(self):
        """Gets the elf_storage_policy_replica_num_lte of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The elf_storage_policy_replica_num_lte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._elf_storage_policy_replica_num_lte

    @elf_storage_policy_replica_num_lte.setter
    def elf_storage_policy_replica_num_lte(self, elf_storage_policy_replica_num_lte):
        """Sets the elf_storage_policy_replica_num_lte of this VmVolumeSnapshotWhereInput.


        :param elf_storage_policy_replica_num_lte: The elf_storage_policy_replica_num_lte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type elf_storage_policy_replica_num_lte: int
        """

        self._elf_storage_policy_replica_num_lte = elf_storage_policy_replica_num_lte

    @property
    def elf_storage_policy_replica_num_not(self):
        """Gets the elf_storage_policy_replica_num_not of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The elf_storage_policy_replica_num_not of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._elf_storage_policy_replica_num_not

    @elf_storage_policy_replica_num_not.setter
    def elf_storage_policy_replica_num_not(self, elf_storage_policy_replica_num_not):
        """Sets the elf_storage_policy_replica_num_not of this VmVolumeSnapshotWhereInput.


        :param elf_storage_policy_replica_num_not: The elf_storage_policy_replica_num_not of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type elf_storage_policy_replica_num_not: int
        """

        self._elf_storage_policy_replica_num_not = elf_storage_policy_replica_num_not

    @property
    def elf_storage_policy_replica_num_not_in(self):
        """Gets the elf_storage_policy_replica_num_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The elf_storage_policy_replica_num_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._elf_storage_policy_replica_num_not_in

    @elf_storage_policy_replica_num_not_in.setter
    def elf_storage_policy_replica_num_not_in(self, elf_storage_policy_replica_num_not_in):
        """Sets the elf_storage_policy_replica_num_not_in of this VmVolumeSnapshotWhereInput.


        :param elf_storage_policy_replica_num_not_in: The elf_storage_policy_replica_num_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type elf_storage_policy_replica_num_not_in: list[int]
        """

        self._elf_storage_policy_replica_num_not_in = elf_storage_policy_replica_num_not_in

    @property
    def elf_storage_policy_thin_provision(self):
        """Gets the elf_storage_policy_thin_provision of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The elf_storage_policy_thin_provision of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._elf_storage_policy_thin_provision

    @elf_storage_policy_thin_provision.setter
    def elf_storage_policy_thin_provision(self, elf_storage_policy_thin_provision):
        """Sets the elf_storage_policy_thin_provision of this VmVolumeSnapshotWhereInput.


        :param elf_storage_policy_thin_provision: The elf_storage_policy_thin_provision of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type elf_storage_policy_thin_provision: bool
        """

        self._elf_storage_policy_thin_provision = elf_storage_policy_thin_provision

    @property
    def elf_storage_policy_thin_provision_not(self):
        """Gets the elf_storage_policy_thin_provision_not of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The elf_storage_policy_thin_provision_not of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._elf_storage_policy_thin_provision_not

    @elf_storage_policy_thin_provision_not.setter
    def elf_storage_policy_thin_provision_not(self, elf_storage_policy_thin_provision_not):
        """Sets the elf_storage_policy_thin_provision_not of this VmVolumeSnapshotWhereInput.


        :param elf_storage_policy_thin_provision_not: The elf_storage_policy_thin_provision_not of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type elf_storage_policy_thin_provision_not: bool
        """

        self._elf_storage_policy_thin_provision_not = elf_storage_policy_thin_provision_not

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The entity_async_status of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this VmVolumeSnapshotWhereInput.


        :param entity_async_status: The entity_async_status of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def entity_async_status_in(self):
        """Gets the entity_async_status_in of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The entity_async_status_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_in

    @entity_async_status_in.setter
    def entity_async_status_in(self, entity_async_status_in):
        """Sets the entity_async_status_in of this VmVolumeSnapshotWhereInput.


        :param entity_async_status_in: The entity_async_status_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type entity_async_status_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_in = entity_async_status_in

    @property
    def entity_async_status_not(self):
        """Gets the entity_async_status_not of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The entity_async_status_not of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status_not

    @entity_async_status_not.setter
    def entity_async_status_not(self, entity_async_status_not):
        """Sets the entity_async_status_not of this VmVolumeSnapshotWhereInput.


        :param entity_async_status_not: The entity_async_status_not of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type entity_async_status_not: EntityAsyncStatus
        """

        self._entity_async_status_not = entity_async_status_not

    @property
    def entity_async_status_not_in(self):
        """Gets the entity_async_status_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The entity_async_status_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_not_in

    @entity_async_status_not_in.setter
    def entity_async_status_not_in(self, entity_async_status_not_in):
        """Sets the entity_async_status_not_in of this VmVolumeSnapshotWhereInput.


        :param entity_async_status_not_in: The entity_async_status_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type entity_async_status_not_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_not_in = entity_async_status_not_in

    @property
    def id(self):
        """Gets the id of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The id of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this VmVolumeSnapshotWhereInput.


        :param id: The id of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def id_contains(self):
        """Gets the id_contains of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The id_contains of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_contains

    @id_contains.setter
    def id_contains(self, id_contains):
        """Sets the id_contains of this VmVolumeSnapshotWhereInput.


        :param id_contains: The id_contains of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type id_contains: str
        """

        self._id_contains = id_contains

    @property
    def id_ends_with(self):
        """Gets the id_ends_with of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The id_ends_with of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_ends_with

    @id_ends_with.setter
    def id_ends_with(self, id_ends_with):
        """Sets the id_ends_with of this VmVolumeSnapshotWhereInput.


        :param id_ends_with: The id_ends_with of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type id_ends_with: str
        """

        self._id_ends_with = id_ends_with

    @property
    def id_gt(self):
        """Gets the id_gt of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The id_gt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gt

    @id_gt.setter
    def id_gt(self, id_gt):
        """Sets the id_gt of this VmVolumeSnapshotWhereInput.


        :param id_gt: The id_gt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type id_gt: str
        """

        self._id_gt = id_gt

    @property
    def id_gte(self):
        """Gets the id_gte of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The id_gte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gte

    @id_gte.setter
    def id_gte(self, id_gte):
        """Sets the id_gte of this VmVolumeSnapshotWhereInput.


        :param id_gte: The id_gte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type id_gte: str
        """

        self._id_gte = id_gte

    @property
    def id_in(self):
        """Gets the id_in of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The id_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_in

    @id_in.setter
    def id_in(self, id_in):
        """Sets the id_in of this VmVolumeSnapshotWhereInput.


        :param id_in: The id_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type id_in: list[str]
        """

        self._id_in = id_in

    @property
    def id_lt(self):
        """Gets the id_lt of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The id_lt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lt

    @id_lt.setter
    def id_lt(self, id_lt):
        """Sets the id_lt of this VmVolumeSnapshotWhereInput.


        :param id_lt: The id_lt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type id_lt: str
        """

        self._id_lt = id_lt

    @property
    def id_lte(self):
        """Gets the id_lte of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The id_lte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lte

    @id_lte.setter
    def id_lte(self, id_lte):
        """Sets the id_lte of this VmVolumeSnapshotWhereInput.


        :param id_lte: The id_lte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type id_lte: str
        """

        self._id_lte = id_lte

    @property
    def id_not(self):
        """Gets the id_not of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The id_not of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not

    @id_not.setter
    def id_not(self, id_not):
        """Sets the id_not of this VmVolumeSnapshotWhereInput.


        :param id_not: The id_not of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type id_not: str
        """

        self._id_not = id_not

    @property
    def id_not_contains(self):
        """Gets the id_not_contains of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The id_not_contains of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_contains

    @id_not_contains.setter
    def id_not_contains(self, id_not_contains):
        """Sets the id_not_contains of this VmVolumeSnapshotWhereInput.


        :param id_not_contains: The id_not_contains of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type id_not_contains: str
        """

        self._id_not_contains = id_not_contains

    @property
    def id_not_ends_with(self):
        """Gets the id_not_ends_with of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The id_not_ends_with of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_ends_with

    @id_not_ends_with.setter
    def id_not_ends_with(self, id_not_ends_with):
        """Sets the id_not_ends_with of this VmVolumeSnapshotWhereInput.


        :param id_not_ends_with: The id_not_ends_with of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type id_not_ends_with: str
        """

        self._id_not_ends_with = id_not_ends_with

    @property
    def id_not_in(self):
        """Gets the id_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The id_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_not_in

    @id_not_in.setter
    def id_not_in(self, id_not_in):
        """Sets the id_not_in of this VmVolumeSnapshotWhereInput.


        :param id_not_in: The id_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type id_not_in: list[str]
        """

        self._id_not_in = id_not_in

    @property
    def id_not_starts_with(self):
        """Gets the id_not_starts_with of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The id_not_starts_with of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_starts_with

    @id_not_starts_with.setter
    def id_not_starts_with(self, id_not_starts_with):
        """Sets the id_not_starts_with of this VmVolumeSnapshotWhereInput.


        :param id_not_starts_with: The id_not_starts_with of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type id_not_starts_with: str
        """

        self._id_not_starts_with = id_not_starts_with

    @property
    def id_starts_with(self):
        """Gets the id_starts_with of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The id_starts_with of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_starts_with

    @id_starts_with.setter
    def id_starts_with(self, id_starts_with):
        """Sets the id_starts_with of this VmVolumeSnapshotWhereInput.


        :param id_starts_with: The id_starts_with of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type id_starts_with: str
        """

        self._id_starts_with = id_starts_with

    @property
    def labels_every(self):
        """Gets the labels_every of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The labels_every of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: LabelWhereInput
        """
        return self._labels_every

    @labels_every.setter
    def labels_every(self, labels_every):
        """Sets the labels_every of this VmVolumeSnapshotWhereInput.


        :param labels_every: The labels_every of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type labels_every: LabelWhereInput
        """

        self._labels_every = labels_every

    @property
    def labels_none(self):
        """Gets the labels_none of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The labels_none of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: LabelWhereInput
        """
        return self._labels_none

    @labels_none.setter
    def labels_none(self, labels_none):
        """Sets the labels_none of this VmVolumeSnapshotWhereInput.


        :param labels_none: The labels_none of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type labels_none: LabelWhereInput
        """

        self._labels_none = labels_none

    @property
    def labels_some(self):
        """Gets the labels_some of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The labels_some of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: LabelWhereInput
        """
        return self._labels_some

    @labels_some.setter
    def labels_some(self, labels_some):
        """Sets the labels_some of this VmVolumeSnapshotWhereInput.


        :param labels_some: The labels_some of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type labels_some: LabelWhereInput
        """

        self._labels_some = labels_some

    @property
    def local_created_at(self):
        """Gets the local_created_at of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The local_created_at of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at

    @local_created_at.setter
    def local_created_at(self, local_created_at):
        """Sets the local_created_at of this VmVolumeSnapshotWhereInput.


        :param local_created_at: The local_created_at of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type local_created_at: str
        """

        self._local_created_at = local_created_at

    @property
    def local_created_at_gt(self):
        """Gets the local_created_at_gt of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The local_created_at_gt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at_gt

    @local_created_at_gt.setter
    def local_created_at_gt(self, local_created_at_gt):
        """Sets the local_created_at_gt of this VmVolumeSnapshotWhereInput.


        :param local_created_at_gt: The local_created_at_gt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type local_created_at_gt: str
        """

        self._local_created_at_gt = local_created_at_gt

    @property
    def local_created_at_gte(self):
        """Gets the local_created_at_gte of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The local_created_at_gte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at_gte

    @local_created_at_gte.setter
    def local_created_at_gte(self, local_created_at_gte):
        """Sets the local_created_at_gte of this VmVolumeSnapshotWhereInput.


        :param local_created_at_gte: The local_created_at_gte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type local_created_at_gte: str
        """

        self._local_created_at_gte = local_created_at_gte

    @property
    def local_created_at_in(self):
        """Gets the local_created_at_in of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The local_created_at_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_created_at_in

    @local_created_at_in.setter
    def local_created_at_in(self, local_created_at_in):
        """Sets the local_created_at_in of this VmVolumeSnapshotWhereInput.


        :param local_created_at_in: The local_created_at_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type local_created_at_in: list[str]
        """

        self._local_created_at_in = local_created_at_in

    @property
    def local_created_at_lt(self):
        """Gets the local_created_at_lt of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The local_created_at_lt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at_lt

    @local_created_at_lt.setter
    def local_created_at_lt(self, local_created_at_lt):
        """Sets the local_created_at_lt of this VmVolumeSnapshotWhereInput.


        :param local_created_at_lt: The local_created_at_lt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type local_created_at_lt: str
        """

        self._local_created_at_lt = local_created_at_lt

    @property
    def local_created_at_lte(self):
        """Gets the local_created_at_lte of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The local_created_at_lte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at_lte

    @local_created_at_lte.setter
    def local_created_at_lte(self, local_created_at_lte):
        """Sets the local_created_at_lte of this VmVolumeSnapshotWhereInput.


        :param local_created_at_lte: The local_created_at_lte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type local_created_at_lte: str
        """

        self._local_created_at_lte = local_created_at_lte

    @property
    def local_created_at_not(self):
        """Gets the local_created_at_not of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The local_created_at_not of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at_not

    @local_created_at_not.setter
    def local_created_at_not(self, local_created_at_not):
        """Sets the local_created_at_not of this VmVolumeSnapshotWhereInput.


        :param local_created_at_not: The local_created_at_not of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type local_created_at_not: str
        """

        self._local_created_at_not = local_created_at_not

    @property
    def local_created_at_not_in(self):
        """Gets the local_created_at_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The local_created_at_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_created_at_not_in

    @local_created_at_not_in.setter
    def local_created_at_not_in(self, local_created_at_not_in):
        """Sets the local_created_at_not_in of this VmVolumeSnapshotWhereInput.


        :param local_created_at_not_in: The local_created_at_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type local_created_at_not_in: list[str]
        """

        self._local_created_at_not_in = local_created_at_not_in

    @property
    def local_id(self):
        """Gets the local_id of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The local_id of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id):
        """Sets the local_id of this VmVolumeSnapshotWhereInput.


        :param local_id: The local_id of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type local_id: str
        """

        self._local_id = local_id

    @property
    def local_id_contains(self):
        """Gets the local_id_contains of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The local_id_contains of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_contains

    @local_id_contains.setter
    def local_id_contains(self, local_id_contains):
        """Sets the local_id_contains of this VmVolumeSnapshotWhereInput.


        :param local_id_contains: The local_id_contains of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type local_id_contains: str
        """

        self._local_id_contains = local_id_contains

    @property
    def local_id_ends_with(self):
        """Gets the local_id_ends_with of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The local_id_ends_with of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_ends_with

    @local_id_ends_with.setter
    def local_id_ends_with(self, local_id_ends_with):
        """Sets the local_id_ends_with of this VmVolumeSnapshotWhereInput.


        :param local_id_ends_with: The local_id_ends_with of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type local_id_ends_with: str
        """

        self._local_id_ends_with = local_id_ends_with

    @property
    def local_id_gt(self):
        """Gets the local_id_gt of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The local_id_gt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_gt

    @local_id_gt.setter
    def local_id_gt(self, local_id_gt):
        """Sets the local_id_gt of this VmVolumeSnapshotWhereInput.


        :param local_id_gt: The local_id_gt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type local_id_gt: str
        """

        self._local_id_gt = local_id_gt

    @property
    def local_id_gte(self):
        """Gets the local_id_gte of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The local_id_gte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_gte

    @local_id_gte.setter
    def local_id_gte(self, local_id_gte):
        """Sets the local_id_gte of this VmVolumeSnapshotWhereInput.


        :param local_id_gte: The local_id_gte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type local_id_gte: str
        """

        self._local_id_gte = local_id_gte

    @property
    def local_id_in(self):
        """Gets the local_id_in of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The local_id_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_id_in

    @local_id_in.setter
    def local_id_in(self, local_id_in):
        """Sets the local_id_in of this VmVolumeSnapshotWhereInput.


        :param local_id_in: The local_id_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type local_id_in: list[str]
        """

        self._local_id_in = local_id_in

    @property
    def local_id_lt(self):
        """Gets the local_id_lt of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The local_id_lt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_lt

    @local_id_lt.setter
    def local_id_lt(self, local_id_lt):
        """Sets the local_id_lt of this VmVolumeSnapshotWhereInput.


        :param local_id_lt: The local_id_lt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type local_id_lt: str
        """

        self._local_id_lt = local_id_lt

    @property
    def local_id_lte(self):
        """Gets the local_id_lte of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The local_id_lte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_lte

    @local_id_lte.setter
    def local_id_lte(self, local_id_lte):
        """Sets the local_id_lte of this VmVolumeSnapshotWhereInput.


        :param local_id_lte: The local_id_lte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type local_id_lte: str
        """

        self._local_id_lte = local_id_lte

    @property
    def local_id_not(self):
        """Gets the local_id_not of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The local_id_not of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not

    @local_id_not.setter
    def local_id_not(self, local_id_not):
        """Sets the local_id_not of this VmVolumeSnapshotWhereInput.


        :param local_id_not: The local_id_not of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type local_id_not: str
        """

        self._local_id_not = local_id_not

    @property
    def local_id_not_contains(self):
        """Gets the local_id_not_contains of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The local_id_not_contains of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_contains

    @local_id_not_contains.setter
    def local_id_not_contains(self, local_id_not_contains):
        """Sets the local_id_not_contains of this VmVolumeSnapshotWhereInput.


        :param local_id_not_contains: The local_id_not_contains of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type local_id_not_contains: str
        """

        self._local_id_not_contains = local_id_not_contains

    @property
    def local_id_not_ends_with(self):
        """Gets the local_id_not_ends_with of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The local_id_not_ends_with of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_ends_with

    @local_id_not_ends_with.setter
    def local_id_not_ends_with(self, local_id_not_ends_with):
        """Sets the local_id_not_ends_with of this VmVolumeSnapshotWhereInput.


        :param local_id_not_ends_with: The local_id_not_ends_with of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type local_id_not_ends_with: str
        """

        self._local_id_not_ends_with = local_id_not_ends_with

    @property
    def local_id_not_in(self):
        """Gets the local_id_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The local_id_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_id_not_in

    @local_id_not_in.setter
    def local_id_not_in(self, local_id_not_in):
        """Sets the local_id_not_in of this VmVolumeSnapshotWhereInput.


        :param local_id_not_in: The local_id_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type local_id_not_in: list[str]
        """

        self._local_id_not_in = local_id_not_in

    @property
    def local_id_not_starts_with(self):
        """Gets the local_id_not_starts_with of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The local_id_not_starts_with of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_starts_with

    @local_id_not_starts_with.setter
    def local_id_not_starts_with(self, local_id_not_starts_with):
        """Sets the local_id_not_starts_with of this VmVolumeSnapshotWhereInput.


        :param local_id_not_starts_with: The local_id_not_starts_with of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type local_id_not_starts_with: str
        """

        self._local_id_not_starts_with = local_id_not_starts_with

    @property
    def local_id_starts_with(self):
        """Gets the local_id_starts_with of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The local_id_starts_with of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_starts_with

    @local_id_starts_with.setter
    def local_id_starts_with(self, local_id_starts_with):
        """Sets the local_id_starts_with of this VmVolumeSnapshotWhereInput.


        :param local_id_starts_with: The local_id_starts_with of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type local_id_starts_with: str
        """

        self._local_id_starts_with = local_id_starts_with

    @property
    def name(self):
        """Gets the name of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The name of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this VmVolumeSnapshotWhereInput.


        :param name: The name of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def name_contains(self):
        """Gets the name_contains of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The name_contains of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_contains

    @name_contains.setter
    def name_contains(self, name_contains):
        """Sets the name_contains of this VmVolumeSnapshotWhereInput.


        :param name_contains: The name_contains of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type name_contains: str
        """

        self._name_contains = name_contains

    @property
    def name_ends_with(self):
        """Gets the name_ends_with of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The name_ends_with of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_ends_with

    @name_ends_with.setter
    def name_ends_with(self, name_ends_with):
        """Sets the name_ends_with of this VmVolumeSnapshotWhereInput.


        :param name_ends_with: The name_ends_with of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type name_ends_with: str
        """

        self._name_ends_with = name_ends_with

    @property
    def name_gt(self):
        """Gets the name_gt of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The name_gt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_gt

    @name_gt.setter
    def name_gt(self, name_gt):
        """Sets the name_gt of this VmVolumeSnapshotWhereInput.


        :param name_gt: The name_gt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type name_gt: str
        """

        self._name_gt = name_gt

    @property
    def name_gte(self):
        """Gets the name_gte of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The name_gte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_gte

    @name_gte.setter
    def name_gte(self, name_gte):
        """Sets the name_gte of this VmVolumeSnapshotWhereInput.


        :param name_gte: The name_gte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type name_gte: str
        """

        self._name_gte = name_gte

    @property
    def name_in(self):
        """Gets the name_in of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The name_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._name_in

    @name_in.setter
    def name_in(self, name_in):
        """Sets the name_in of this VmVolumeSnapshotWhereInput.


        :param name_in: The name_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type name_in: list[str]
        """

        self._name_in = name_in

    @property
    def name_lt(self):
        """Gets the name_lt of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The name_lt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_lt

    @name_lt.setter
    def name_lt(self, name_lt):
        """Sets the name_lt of this VmVolumeSnapshotWhereInput.


        :param name_lt: The name_lt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type name_lt: str
        """

        self._name_lt = name_lt

    @property
    def name_lte(self):
        """Gets the name_lte of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The name_lte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_lte

    @name_lte.setter
    def name_lte(self, name_lte):
        """Sets the name_lte of this VmVolumeSnapshotWhereInput.


        :param name_lte: The name_lte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type name_lte: str
        """

        self._name_lte = name_lte

    @property
    def name_not(self):
        """Gets the name_not of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The name_not of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not

    @name_not.setter
    def name_not(self, name_not):
        """Sets the name_not of this VmVolumeSnapshotWhereInput.


        :param name_not: The name_not of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type name_not: str
        """

        self._name_not = name_not

    @property
    def name_not_contains(self):
        """Gets the name_not_contains of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The name_not_contains of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_contains

    @name_not_contains.setter
    def name_not_contains(self, name_not_contains):
        """Sets the name_not_contains of this VmVolumeSnapshotWhereInput.


        :param name_not_contains: The name_not_contains of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type name_not_contains: str
        """

        self._name_not_contains = name_not_contains

    @property
    def name_not_ends_with(self):
        """Gets the name_not_ends_with of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The name_not_ends_with of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_ends_with

    @name_not_ends_with.setter
    def name_not_ends_with(self, name_not_ends_with):
        """Sets the name_not_ends_with of this VmVolumeSnapshotWhereInput.


        :param name_not_ends_with: The name_not_ends_with of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type name_not_ends_with: str
        """

        self._name_not_ends_with = name_not_ends_with

    @property
    def name_not_in(self):
        """Gets the name_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The name_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._name_not_in

    @name_not_in.setter
    def name_not_in(self, name_not_in):
        """Sets the name_not_in of this VmVolumeSnapshotWhereInput.


        :param name_not_in: The name_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type name_not_in: list[str]
        """

        self._name_not_in = name_not_in

    @property
    def name_not_starts_with(self):
        """Gets the name_not_starts_with of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The name_not_starts_with of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_starts_with

    @name_not_starts_with.setter
    def name_not_starts_with(self, name_not_starts_with):
        """Sets the name_not_starts_with of this VmVolumeSnapshotWhereInput.


        :param name_not_starts_with: The name_not_starts_with of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type name_not_starts_with: str
        """

        self._name_not_starts_with = name_not_starts_with

    @property
    def name_starts_with(self):
        """Gets the name_starts_with of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The name_starts_with of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_starts_with

    @name_starts_with.setter
    def name_starts_with(self, name_starts_with):
        """Sets the name_starts_with of this VmVolumeSnapshotWhereInput.


        :param name_starts_with: The name_starts_with of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type name_starts_with: str
        """

        self._name_starts_with = name_starts_with

    @property
    def resident_in_cache(self):
        """Gets the resident_in_cache of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The resident_in_cache of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._resident_in_cache

    @resident_in_cache.setter
    def resident_in_cache(self, resident_in_cache):
        """Sets the resident_in_cache of this VmVolumeSnapshotWhereInput.


        :param resident_in_cache: The resident_in_cache of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type resident_in_cache: bool
        """

        self._resident_in_cache = resident_in_cache

    @property
    def resident_in_cache_not(self):
        """Gets the resident_in_cache_not of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The resident_in_cache_not of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._resident_in_cache_not

    @resident_in_cache_not.setter
    def resident_in_cache_not(self, resident_in_cache_not):
        """Sets the resident_in_cache_not of this VmVolumeSnapshotWhereInput.


        :param resident_in_cache_not: The resident_in_cache_not of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type resident_in_cache_not: bool
        """

        self._resident_in_cache_not = resident_in_cache_not

    @property
    def shared_size(self):
        """Gets the shared_size of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The shared_size of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._shared_size

    @shared_size.setter
    def shared_size(self, shared_size):
        """Sets the shared_size of this VmVolumeSnapshotWhereInput.


        :param shared_size: The shared_size of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type shared_size: float
        """

        self._shared_size = shared_size

    @property
    def shared_size_gt(self):
        """Gets the shared_size_gt of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The shared_size_gt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._shared_size_gt

    @shared_size_gt.setter
    def shared_size_gt(self, shared_size_gt):
        """Sets the shared_size_gt of this VmVolumeSnapshotWhereInput.


        :param shared_size_gt: The shared_size_gt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type shared_size_gt: float
        """

        self._shared_size_gt = shared_size_gt

    @property
    def shared_size_gte(self):
        """Gets the shared_size_gte of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The shared_size_gte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._shared_size_gte

    @shared_size_gte.setter
    def shared_size_gte(self, shared_size_gte):
        """Sets the shared_size_gte of this VmVolumeSnapshotWhereInput.


        :param shared_size_gte: The shared_size_gte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type shared_size_gte: float
        """

        self._shared_size_gte = shared_size_gte

    @property
    def shared_size_in(self):
        """Gets the shared_size_in of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The shared_size_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: list[float]
        """
        return self._shared_size_in

    @shared_size_in.setter
    def shared_size_in(self, shared_size_in):
        """Sets the shared_size_in of this VmVolumeSnapshotWhereInput.


        :param shared_size_in: The shared_size_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type shared_size_in: list[float]
        """

        self._shared_size_in = shared_size_in

    @property
    def shared_size_lt(self):
        """Gets the shared_size_lt of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The shared_size_lt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._shared_size_lt

    @shared_size_lt.setter
    def shared_size_lt(self, shared_size_lt):
        """Sets the shared_size_lt of this VmVolumeSnapshotWhereInput.


        :param shared_size_lt: The shared_size_lt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type shared_size_lt: float
        """

        self._shared_size_lt = shared_size_lt

    @property
    def shared_size_lte(self):
        """Gets the shared_size_lte of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The shared_size_lte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._shared_size_lte

    @shared_size_lte.setter
    def shared_size_lte(self, shared_size_lte):
        """Sets the shared_size_lte of this VmVolumeSnapshotWhereInput.


        :param shared_size_lte: The shared_size_lte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type shared_size_lte: float
        """

        self._shared_size_lte = shared_size_lte

    @property
    def shared_size_not(self):
        """Gets the shared_size_not of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The shared_size_not of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._shared_size_not

    @shared_size_not.setter
    def shared_size_not(self, shared_size_not):
        """Sets the shared_size_not of this VmVolumeSnapshotWhereInput.


        :param shared_size_not: The shared_size_not of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type shared_size_not: float
        """

        self._shared_size_not = shared_size_not

    @property
    def shared_size_not_in(self):
        """Gets the shared_size_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The shared_size_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: list[float]
        """
        return self._shared_size_not_in

    @shared_size_not_in.setter
    def shared_size_not_in(self, shared_size_not_in):
        """Sets the shared_size_not_in of this VmVolumeSnapshotWhereInput.


        :param shared_size_not_in: The shared_size_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type shared_size_not_in: list[float]
        """

        self._shared_size_not_in = shared_size_not_in

    @property
    def size(self):
        """Gets the size of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The size of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._size

    @size.setter
    def size(self, size):
        """Sets the size of this VmVolumeSnapshotWhereInput.


        :param size: The size of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type size: float
        """

        self._size = size

    @property
    def size_gt(self):
        """Gets the size_gt of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The size_gt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._size_gt

    @size_gt.setter
    def size_gt(self, size_gt):
        """Sets the size_gt of this VmVolumeSnapshotWhereInput.


        :param size_gt: The size_gt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type size_gt: float
        """

        self._size_gt = size_gt

    @property
    def size_gte(self):
        """Gets the size_gte of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The size_gte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._size_gte

    @size_gte.setter
    def size_gte(self, size_gte):
        """Sets the size_gte of this VmVolumeSnapshotWhereInput.


        :param size_gte: The size_gte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type size_gte: float
        """

        self._size_gte = size_gte

    @property
    def size_in(self):
        """Gets the size_in of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The size_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: list[float]
        """
        return self._size_in

    @size_in.setter
    def size_in(self, size_in):
        """Sets the size_in of this VmVolumeSnapshotWhereInput.


        :param size_in: The size_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type size_in: list[float]
        """

        self._size_in = size_in

    @property
    def size_lt(self):
        """Gets the size_lt of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The size_lt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._size_lt

    @size_lt.setter
    def size_lt(self, size_lt):
        """Sets the size_lt of this VmVolumeSnapshotWhereInput.


        :param size_lt: The size_lt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type size_lt: float
        """

        self._size_lt = size_lt

    @property
    def size_lte(self):
        """Gets the size_lte of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The size_lte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._size_lte

    @size_lte.setter
    def size_lte(self, size_lte):
        """Sets the size_lte of this VmVolumeSnapshotWhereInput.


        :param size_lte: The size_lte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type size_lte: float
        """

        self._size_lte = size_lte

    @property
    def size_not(self):
        """Gets the size_not of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The size_not of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._size_not

    @size_not.setter
    def size_not(self, size_not):
        """Sets the size_not of this VmVolumeSnapshotWhereInput.


        :param size_not: The size_not of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type size_not: float
        """

        self._size_not = size_not

    @property
    def size_not_in(self):
        """Gets the size_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The size_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: list[float]
        """
        return self._size_not_in

    @size_not_in.setter
    def size_not_in(self, size_not_in):
        """Sets the size_not_in of this VmVolumeSnapshotWhereInput.


        :param size_not_in: The size_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type size_not_in: list[float]
        """

        self._size_not_in = size_not_in

    @property
    def type(self):
        """Gets the type of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The type of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: VmVolumeSnapshotType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this VmVolumeSnapshotWhereInput.


        :param type: The type of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type type: VmVolumeSnapshotType
        """

        self._type = type

    @property
    def type_in(self):
        """Gets the type_in of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The type_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: list[VmVolumeSnapshotType]
        """
        return self._type_in

    @type_in.setter
    def type_in(self, type_in):
        """Sets the type_in of this VmVolumeSnapshotWhereInput.


        :param type_in: The type_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type type_in: list[VmVolumeSnapshotType]
        """

        self._type_in = type_in

    @property
    def type_not(self):
        """Gets the type_not of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The type_not of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: VmVolumeSnapshotType
        """
        return self._type_not

    @type_not.setter
    def type_not(self, type_not):
        """Sets the type_not of this VmVolumeSnapshotWhereInput.


        :param type_not: The type_not of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type type_not: VmVolumeSnapshotType
        """

        self._type_not = type_not

    @property
    def type_not_in(self):
        """Gets the type_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The type_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: list[VmVolumeSnapshotType]
        """
        return self._type_not_in

    @type_not_in.setter
    def type_not_in(self, type_not_in):
        """Sets the type_not_in of this VmVolumeSnapshotWhereInput.


        :param type_not_in: The type_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type type_not_in: list[VmVolumeSnapshotType]
        """

        self._type_not_in = type_not_in

    @property
    def unique_size(self):
        """Gets the unique_size of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The unique_size of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._unique_size

    @unique_size.setter
    def unique_size(self, unique_size):
        """Sets the unique_size of this VmVolumeSnapshotWhereInput.


        :param unique_size: The unique_size of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type unique_size: float
        """

        self._unique_size = unique_size

    @property
    def unique_size_gt(self):
        """Gets the unique_size_gt of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The unique_size_gt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._unique_size_gt

    @unique_size_gt.setter
    def unique_size_gt(self, unique_size_gt):
        """Sets the unique_size_gt of this VmVolumeSnapshotWhereInput.


        :param unique_size_gt: The unique_size_gt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type unique_size_gt: float
        """

        self._unique_size_gt = unique_size_gt

    @property
    def unique_size_gte(self):
        """Gets the unique_size_gte of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The unique_size_gte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._unique_size_gte

    @unique_size_gte.setter
    def unique_size_gte(self, unique_size_gte):
        """Sets the unique_size_gte of this VmVolumeSnapshotWhereInput.


        :param unique_size_gte: The unique_size_gte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type unique_size_gte: float
        """

        self._unique_size_gte = unique_size_gte

    @property
    def unique_size_in(self):
        """Gets the unique_size_in of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The unique_size_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: list[float]
        """
        return self._unique_size_in

    @unique_size_in.setter
    def unique_size_in(self, unique_size_in):
        """Sets the unique_size_in of this VmVolumeSnapshotWhereInput.


        :param unique_size_in: The unique_size_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type unique_size_in: list[float]
        """

        self._unique_size_in = unique_size_in

    @property
    def unique_size_lt(self):
        """Gets the unique_size_lt of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The unique_size_lt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._unique_size_lt

    @unique_size_lt.setter
    def unique_size_lt(self, unique_size_lt):
        """Sets the unique_size_lt of this VmVolumeSnapshotWhereInput.


        :param unique_size_lt: The unique_size_lt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type unique_size_lt: float
        """

        self._unique_size_lt = unique_size_lt

    @property
    def unique_size_lte(self):
        """Gets the unique_size_lte of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The unique_size_lte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._unique_size_lte

    @unique_size_lte.setter
    def unique_size_lte(self, unique_size_lte):
        """Sets the unique_size_lte of this VmVolumeSnapshotWhereInput.


        :param unique_size_lte: The unique_size_lte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type unique_size_lte: float
        """

        self._unique_size_lte = unique_size_lte

    @property
    def unique_size_not(self):
        """Gets the unique_size_not of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The unique_size_not of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._unique_size_not

    @unique_size_not.setter
    def unique_size_not(self, unique_size_not):
        """Sets the unique_size_not of this VmVolumeSnapshotWhereInput.


        :param unique_size_not: The unique_size_not of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type unique_size_not: float
        """

        self._unique_size_not = unique_size_not

    @property
    def unique_size_not_in(self):
        """Gets the unique_size_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The unique_size_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: list[float]
        """
        return self._unique_size_not_in

    @unique_size_not_in.setter
    def unique_size_not_in(self, unique_size_not_in):
        """Sets the unique_size_not_in of this VmVolumeSnapshotWhereInput.


        :param unique_size_not_in: The unique_size_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type unique_size_not_in: list[float]
        """

        self._unique_size_not_in = unique_size_not_in

    @property
    def vm_volume(self):
        """Gets the vm_volume of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The vm_volume of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: VmVolumeWhereInput
        """
        return self._vm_volume

    @vm_volume.setter
    def vm_volume(self, vm_volume):
        """Sets the vm_volume of this VmVolumeSnapshotWhereInput.


        :param vm_volume: The vm_volume of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type vm_volume: VmVolumeWhereInput
        """

        self._vm_volume = vm_volume

    @property
    def volume_sharing(self):
        """Gets the volume_sharing of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The volume_sharing of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._volume_sharing

    @volume_sharing.setter
    def volume_sharing(self, volume_sharing):
        """Sets the volume_sharing of this VmVolumeSnapshotWhereInput.


        :param volume_sharing: The volume_sharing of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type volume_sharing: bool
        """

        self._volume_sharing = volume_sharing

    @property
    def volume_sharing_not(self):
        """Gets the volume_sharing_not of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The volume_sharing_not of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._volume_sharing_not

    @volume_sharing_not.setter
    def volume_sharing_not(self, volume_sharing_not):
        """Sets the volume_sharing_not of this VmVolumeSnapshotWhereInput.


        :param volume_sharing_not: The volume_sharing_not of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type volume_sharing_not: bool
        """

        self._volume_sharing_not = volume_sharing_not

    @property
    def volume_size(self):
        """Gets the volume_size of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The volume_size of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._volume_size

    @volume_size.setter
    def volume_size(self, volume_size):
        """Sets the volume_size of this VmVolumeSnapshotWhereInput.


        :param volume_size: The volume_size of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type volume_size: float
        """

        self._volume_size = volume_size

    @property
    def volume_size_gt(self):
        """Gets the volume_size_gt of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The volume_size_gt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._volume_size_gt

    @volume_size_gt.setter
    def volume_size_gt(self, volume_size_gt):
        """Sets the volume_size_gt of this VmVolumeSnapshotWhereInput.


        :param volume_size_gt: The volume_size_gt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type volume_size_gt: float
        """

        self._volume_size_gt = volume_size_gt

    @property
    def volume_size_gte(self):
        """Gets the volume_size_gte of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The volume_size_gte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._volume_size_gte

    @volume_size_gte.setter
    def volume_size_gte(self, volume_size_gte):
        """Sets the volume_size_gte of this VmVolumeSnapshotWhereInput.


        :param volume_size_gte: The volume_size_gte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type volume_size_gte: float
        """

        self._volume_size_gte = volume_size_gte

    @property
    def volume_size_in(self):
        """Gets the volume_size_in of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The volume_size_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: list[float]
        """
        return self._volume_size_in

    @volume_size_in.setter
    def volume_size_in(self, volume_size_in):
        """Sets the volume_size_in of this VmVolumeSnapshotWhereInput.


        :param volume_size_in: The volume_size_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type volume_size_in: list[float]
        """

        self._volume_size_in = volume_size_in

    @property
    def volume_size_lt(self):
        """Gets the volume_size_lt of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The volume_size_lt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._volume_size_lt

    @volume_size_lt.setter
    def volume_size_lt(self, volume_size_lt):
        """Sets the volume_size_lt of this VmVolumeSnapshotWhereInput.


        :param volume_size_lt: The volume_size_lt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type volume_size_lt: float
        """

        self._volume_size_lt = volume_size_lt

    @property
    def volume_size_lte(self):
        """Gets the volume_size_lte of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The volume_size_lte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._volume_size_lte

    @volume_size_lte.setter
    def volume_size_lte(self, volume_size_lte):
        """Sets the volume_size_lte of this VmVolumeSnapshotWhereInput.


        :param volume_size_lte: The volume_size_lte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type volume_size_lte: float
        """

        self._volume_size_lte = volume_size_lte

    @property
    def volume_size_not(self):
        """Gets the volume_size_not of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The volume_size_not of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._volume_size_not

    @volume_size_not.setter
    def volume_size_not(self, volume_size_not):
        """Sets the volume_size_not of this VmVolumeSnapshotWhereInput.


        :param volume_size_not: The volume_size_not of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type volume_size_not: float
        """

        self._volume_size_not = volume_size_not

    @property
    def volume_size_not_in(self):
        """Gets the volume_size_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The volume_size_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: list[float]
        """
        return self._volume_size_not_in

    @volume_size_not_in.setter
    def volume_size_not_in(self, volume_size_not_in):
        """Sets the volume_size_not_in of this VmVolumeSnapshotWhereInput.


        :param volume_size_not_in: The volume_size_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type volume_size_not_in: list[float]
        """

        self._volume_size_not_in = volume_size_not_in

    @property
    def zbs_snapshot_uuid(self):
        """Gets the zbs_snapshot_uuid of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The zbs_snapshot_uuid of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._zbs_snapshot_uuid

    @zbs_snapshot_uuid.setter
    def zbs_snapshot_uuid(self, zbs_snapshot_uuid):
        """Sets the zbs_snapshot_uuid of this VmVolumeSnapshotWhereInput.


        :param zbs_snapshot_uuid: The zbs_snapshot_uuid of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type zbs_snapshot_uuid: str
        """

        self._zbs_snapshot_uuid = zbs_snapshot_uuid

    @property
    def zbs_snapshot_uuid_contains(self):
        """Gets the zbs_snapshot_uuid_contains of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The zbs_snapshot_uuid_contains of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._zbs_snapshot_uuid_contains

    @zbs_snapshot_uuid_contains.setter
    def zbs_snapshot_uuid_contains(self, zbs_snapshot_uuid_contains):
        """Sets the zbs_snapshot_uuid_contains of this VmVolumeSnapshotWhereInput.


        :param zbs_snapshot_uuid_contains: The zbs_snapshot_uuid_contains of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type zbs_snapshot_uuid_contains: str
        """

        self._zbs_snapshot_uuid_contains = zbs_snapshot_uuid_contains

    @property
    def zbs_snapshot_uuid_ends_with(self):
        """Gets the zbs_snapshot_uuid_ends_with of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The zbs_snapshot_uuid_ends_with of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._zbs_snapshot_uuid_ends_with

    @zbs_snapshot_uuid_ends_with.setter
    def zbs_snapshot_uuid_ends_with(self, zbs_snapshot_uuid_ends_with):
        """Sets the zbs_snapshot_uuid_ends_with of this VmVolumeSnapshotWhereInput.


        :param zbs_snapshot_uuid_ends_with: The zbs_snapshot_uuid_ends_with of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type zbs_snapshot_uuid_ends_with: str
        """

        self._zbs_snapshot_uuid_ends_with = zbs_snapshot_uuid_ends_with

    @property
    def zbs_snapshot_uuid_gt(self):
        """Gets the zbs_snapshot_uuid_gt of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The zbs_snapshot_uuid_gt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._zbs_snapshot_uuid_gt

    @zbs_snapshot_uuid_gt.setter
    def zbs_snapshot_uuid_gt(self, zbs_snapshot_uuid_gt):
        """Sets the zbs_snapshot_uuid_gt of this VmVolumeSnapshotWhereInput.


        :param zbs_snapshot_uuid_gt: The zbs_snapshot_uuid_gt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type zbs_snapshot_uuid_gt: str
        """

        self._zbs_snapshot_uuid_gt = zbs_snapshot_uuid_gt

    @property
    def zbs_snapshot_uuid_gte(self):
        """Gets the zbs_snapshot_uuid_gte of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The zbs_snapshot_uuid_gte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._zbs_snapshot_uuid_gte

    @zbs_snapshot_uuid_gte.setter
    def zbs_snapshot_uuid_gte(self, zbs_snapshot_uuid_gte):
        """Sets the zbs_snapshot_uuid_gte of this VmVolumeSnapshotWhereInput.


        :param zbs_snapshot_uuid_gte: The zbs_snapshot_uuid_gte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type zbs_snapshot_uuid_gte: str
        """

        self._zbs_snapshot_uuid_gte = zbs_snapshot_uuid_gte

    @property
    def zbs_snapshot_uuid_in(self):
        """Gets the zbs_snapshot_uuid_in of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The zbs_snapshot_uuid_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._zbs_snapshot_uuid_in

    @zbs_snapshot_uuid_in.setter
    def zbs_snapshot_uuid_in(self, zbs_snapshot_uuid_in):
        """Sets the zbs_snapshot_uuid_in of this VmVolumeSnapshotWhereInput.


        :param zbs_snapshot_uuid_in: The zbs_snapshot_uuid_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type zbs_snapshot_uuid_in: list[str]
        """

        self._zbs_snapshot_uuid_in = zbs_snapshot_uuid_in

    @property
    def zbs_snapshot_uuid_lt(self):
        """Gets the zbs_snapshot_uuid_lt of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The zbs_snapshot_uuid_lt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._zbs_snapshot_uuid_lt

    @zbs_snapshot_uuid_lt.setter
    def zbs_snapshot_uuid_lt(self, zbs_snapshot_uuid_lt):
        """Sets the zbs_snapshot_uuid_lt of this VmVolumeSnapshotWhereInput.


        :param zbs_snapshot_uuid_lt: The zbs_snapshot_uuid_lt of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type zbs_snapshot_uuid_lt: str
        """

        self._zbs_snapshot_uuid_lt = zbs_snapshot_uuid_lt

    @property
    def zbs_snapshot_uuid_lte(self):
        """Gets the zbs_snapshot_uuid_lte of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The zbs_snapshot_uuid_lte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._zbs_snapshot_uuid_lte

    @zbs_snapshot_uuid_lte.setter
    def zbs_snapshot_uuid_lte(self, zbs_snapshot_uuid_lte):
        """Sets the zbs_snapshot_uuid_lte of this VmVolumeSnapshotWhereInput.


        :param zbs_snapshot_uuid_lte: The zbs_snapshot_uuid_lte of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type zbs_snapshot_uuid_lte: str
        """

        self._zbs_snapshot_uuid_lte = zbs_snapshot_uuid_lte

    @property
    def zbs_snapshot_uuid_not(self):
        """Gets the zbs_snapshot_uuid_not of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The zbs_snapshot_uuid_not of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._zbs_snapshot_uuid_not

    @zbs_snapshot_uuid_not.setter
    def zbs_snapshot_uuid_not(self, zbs_snapshot_uuid_not):
        """Sets the zbs_snapshot_uuid_not of this VmVolumeSnapshotWhereInput.


        :param zbs_snapshot_uuid_not: The zbs_snapshot_uuid_not of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type zbs_snapshot_uuid_not: str
        """

        self._zbs_snapshot_uuid_not = zbs_snapshot_uuid_not

    @property
    def zbs_snapshot_uuid_not_contains(self):
        """Gets the zbs_snapshot_uuid_not_contains of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The zbs_snapshot_uuid_not_contains of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._zbs_snapshot_uuid_not_contains

    @zbs_snapshot_uuid_not_contains.setter
    def zbs_snapshot_uuid_not_contains(self, zbs_snapshot_uuid_not_contains):
        """Sets the zbs_snapshot_uuid_not_contains of this VmVolumeSnapshotWhereInput.


        :param zbs_snapshot_uuid_not_contains: The zbs_snapshot_uuid_not_contains of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type zbs_snapshot_uuid_not_contains: str
        """

        self._zbs_snapshot_uuid_not_contains = zbs_snapshot_uuid_not_contains

    @property
    def zbs_snapshot_uuid_not_ends_with(self):
        """Gets the zbs_snapshot_uuid_not_ends_with of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The zbs_snapshot_uuid_not_ends_with of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._zbs_snapshot_uuid_not_ends_with

    @zbs_snapshot_uuid_not_ends_with.setter
    def zbs_snapshot_uuid_not_ends_with(self, zbs_snapshot_uuid_not_ends_with):
        """Sets the zbs_snapshot_uuid_not_ends_with of this VmVolumeSnapshotWhereInput.


        :param zbs_snapshot_uuid_not_ends_with: The zbs_snapshot_uuid_not_ends_with of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type zbs_snapshot_uuid_not_ends_with: str
        """

        self._zbs_snapshot_uuid_not_ends_with = zbs_snapshot_uuid_not_ends_with

    @property
    def zbs_snapshot_uuid_not_in(self):
        """Gets the zbs_snapshot_uuid_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The zbs_snapshot_uuid_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._zbs_snapshot_uuid_not_in

    @zbs_snapshot_uuid_not_in.setter
    def zbs_snapshot_uuid_not_in(self, zbs_snapshot_uuid_not_in):
        """Sets the zbs_snapshot_uuid_not_in of this VmVolumeSnapshotWhereInput.


        :param zbs_snapshot_uuid_not_in: The zbs_snapshot_uuid_not_in of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type zbs_snapshot_uuid_not_in: list[str]
        """

        self._zbs_snapshot_uuid_not_in = zbs_snapshot_uuid_not_in

    @property
    def zbs_snapshot_uuid_not_starts_with(self):
        """Gets the zbs_snapshot_uuid_not_starts_with of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The zbs_snapshot_uuid_not_starts_with of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._zbs_snapshot_uuid_not_starts_with

    @zbs_snapshot_uuid_not_starts_with.setter
    def zbs_snapshot_uuid_not_starts_with(self, zbs_snapshot_uuid_not_starts_with):
        """Sets the zbs_snapshot_uuid_not_starts_with of this VmVolumeSnapshotWhereInput.


        :param zbs_snapshot_uuid_not_starts_with: The zbs_snapshot_uuid_not_starts_with of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type zbs_snapshot_uuid_not_starts_with: str
        """

        self._zbs_snapshot_uuid_not_starts_with = zbs_snapshot_uuid_not_starts_with

    @property
    def zbs_snapshot_uuid_starts_with(self):
        """Gets the zbs_snapshot_uuid_starts_with of this VmVolumeSnapshotWhereInput.  # noqa: E501


        :return: The zbs_snapshot_uuid_starts_with of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._zbs_snapshot_uuid_starts_with

    @zbs_snapshot_uuid_starts_with.setter
    def zbs_snapshot_uuid_starts_with(self, zbs_snapshot_uuid_starts_with):
        """Sets the zbs_snapshot_uuid_starts_with of this VmVolumeSnapshotWhereInput.


        :param zbs_snapshot_uuid_starts_with: The zbs_snapshot_uuid_starts_with of this VmVolumeSnapshotWhereInput.  # noqa: E501
        :type zbs_snapshot_uuid_starts_with: str
        """

        self._zbs_snapshot_uuid_starts_with = zbs_snapshot_uuid_starts_with

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VmVolumeSnapshotWhereInput):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VmVolumeSnapshotWhereInput):
            return True

        return self.to_dict() != other.to_dict()
