# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class VmVolumeWhereInput(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        '_and': 'list[VmVolumeWhereInput]',
        '_not': 'list[VmVolumeWhereInput]',
        '_or': 'list[VmVolumeWhereInput]',
        'cluster': 'ClusterWhereInput',
        'description': 'str',
        'description_contains': 'str',
        'description_ends_with': 'str',
        'description_gt': 'str',
        'description_gte': 'str',
        'description_in': 'list[str]',
        'description_lt': 'str',
        'description_lte': 'str',
        'description_not': 'str',
        'description_not_contains': 'str',
        'description_not_ends_with': 'str',
        'description_not_in': 'list[str]',
        'description_not_starts_with': 'str',
        'description_starts_with': 'str',
        'elf_storage_policy': 'VmVolumeElfStoragePolicyType',
        'elf_storage_policy_ec_k': 'int',
        'elf_storage_policy_ec_k_gt': 'int',
        'elf_storage_policy_ec_k_gte': 'int',
        'elf_storage_policy_ec_k_in': 'list[int]',
        'elf_storage_policy_ec_k_lt': 'int',
        'elf_storage_policy_ec_k_lte': 'int',
        'elf_storage_policy_ec_k_not': 'int',
        'elf_storage_policy_ec_k_not_in': 'list[int]',
        'elf_storage_policy_ec_m': 'int',
        'elf_storage_policy_ec_m_gt': 'int',
        'elf_storage_policy_ec_m_gte': 'int',
        'elf_storage_policy_ec_m_in': 'list[int]',
        'elf_storage_policy_ec_m_lt': 'int',
        'elf_storage_policy_ec_m_lte': 'int',
        'elf_storage_policy_ec_m_not': 'int',
        'elf_storage_policy_ec_m_not_in': 'list[int]',
        'elf_storage_policy_in': 'list[VmVolumeElfStoragePolicyType]',
        'elf_storage_policy_not': 'VmVolumeElfStoragePolicyType',
        'elf_storage_policy_not_in': 'list[VmVolumeElfStoragePolicyType]',
        'elf_storage_policy_replica_num': 'int',
        'elf_storage_policy_replica_num_gt': 'int',
        'elf_storage_policy_replica_num_gte': 'int',
        'elf_storage_policy_replica_num_in': 'list[int]',
        'elf_storage_policy_replica_num_lt': 'int',
        'elf_storage_policy_replica_num_lte': 'int',
        'elf_storage_policy_replica_num_not': 'int',
        'elf_storage_policy_replica_num_not_in': 'list[int]',
        'elf_storage_policy_thin_provision': 'bool',
        'elf_storage_policy_thin_provision_not': 'bool',
        'entity_async_status': 'EntityAsyncStatus',
        'entity_async_status_in': 'list[EntityAsyncStatus]',
        'entity_async_status_not': 'EntityAsyncStatus',
        'entity_async_status_not_in': 'list[EntityAsyncStatus]',
        'guest_size_usage': 'float',
        'guest_size_usage_gt': 'float',
        'guest_size_usage_gte': 'float',
        'guest_size_usage_in': 'list[float]',
        'guest_size_usage_lt': 'float',
        'guest_size_usage_lte': 'float',
        'guest_size_usage_not': 'float',
        'guest_size_usage_not_in': 'list[float]',
        'guest_used_size': 'int',
        'guest_used_size_gt': 'int',
        'guest_used_size_gte': 'int',
        'guest_used_size_in': 'list[int]',
        'guest_used_size_lt': 'int',
        'guest_used_size_lte': 'int',
        'guest_used_size_not': 'int',
        'guest_used_size_not_in': 'list[int]',
        'id': 'str',
        'id_contains': 'str',
        'id_ends_with': 'str',
        'id_gt': 'str',
        'id_gte': 'str',
        'id_in': 'list[str]',
        'id_lt': 'str',
        'id_lte': 'str',
        'id_not': 'str',
        'id_not_contains': 'str',
        'id_not_ends_with': 'str',
        'id_not_in': 'list[str]',
        'id_not_starts_with': 'str',
        'id_starts_with': 'str',
        'labels_every': 'LabelWhereInput',
        'labels_none': 'LabelWhereInput',
        'labels_some': 'LabelWhereInput',
        'local_created_at': 'str',
        'local_created_at_gt': 'str',
        'local_created_at_gte': 'str',
        'local_created_at_in': 'list[str]',
        'local_created_at_lt': 'str',
        'local_created_at_lte': 'str',
        'local_created_at_not': 'str',
        'local_created_at_not_in': 'list[str]',
        'local_id': 'str',
        'local_id_contains': 'str',
        'local_id_ends_with': 'str',
        'local_id_gt': 'str',
        'local_id_gte': 'str',
        'local_id_in': 'list[str]',
        'local_id_lt': 'str',
        'local_id_lte': 'str',
        'local_id_not': 'str',
        'local_id_not_contains': 'str',
        'local_id_not_ends_with': 'str',
        'local_id_not_in': 'list[str]',
        'local_id_not_starts_with': 'str',
        'local_id_starts_with': 'str',
        'lun': 'IscsiLunWhereInput',
        'mounting': 'bool',
        'mounting_not': 'bool',
        'name': 'str',
        'name_contains': 'str',
        'name_ends_with': 'str',
        'name_gt': 'str',
        'name_gte': 'str',
        'name_in': 'list[str]',
        'name_lt': 'str',
        'name_lte': 'str',
        'name_not': 'str',
        'name_not_contains': 'str',
        'name_not_ends_with': 'str',
        'name_not_in': 'list[str]',
        'name_not_starts_with': 'str',
        'name_starts_with': 'str',
        'path': 'str',
        'path_contains': 'str',
        'path_ends_with': 'str',
        'path_gt': 'str',
        'path_gte': 'str',
        'path_in': 'list[str]',
        'path_lt': 'str',
        'path_lte': 'str',
        'path_not': 'str',
        'path_not_contains': 'str',
        'path_not_ends_with': 'str',
        'path_not_in': 'list[str]',
        'path_not_starts_with': 'str',
        'path_starts_with': 'str',
        'resident_in_cache': 'bool',
        'resident_in_cache_not': 'bool',
        'sharing': 'bool',
        'sharing_not': 'bool',
        'size': 'int',
        'size_gt': 'int',
        'size_gte': 'int',
        'size_in': 'list[int]',
        'size_lt': 'int',
        'size_lte': 'int',
        'size_not': 'int',
        'size_not_in': 'list[int]',
        'type': 'VmVolumeType',
        'type_in': 'list[VmVolumeType]',
        'type_not': 'VmVolumeType',
        'type_not_in': 'list[VmVolumeType]',
        'unique_logical_size': 'float',
        'unique_logical_size_gt': 'float',
        'unique_logical_size_gte': 'float',
        'unique_logical_size_in': 'list[float]',
        'unique_logical_size_lt': 'float',
        'unique_logical_size_lte': 'float',
        'unique_logical_size_not': 'float',
        'unique_logical_size_not_in': 'list[float]',
        'unique_size': 'int',
        'unique_size_gt': 'int',
        'unique_size_gte': 'int',
        'unique_size_in': 'list[int]',
        'unique_size_lt': 'int',
        'unique_size_lte': 'int',
        'unique_size_not': 'int',
        'unique_size_not_in': 'list[int]',
        'used_size': 'int',
        'used_size_gt': 'int',
        'used_size_gte': 'int',
        'used_size_in': 'list[int]',
        'used_size_lt': 'int',
        'used_size_lte': 'int',
        'used_size_not': 'int',
        'used_size_not_in': 'list[int]',
        'used_size_usage': 'float',
        'used_size_usage_gt': 'float',
        'used_size_usage_gte': 'float',
        'used_size_usage_in': 'list[float]',
        'used_size_usage_lt': 'float',
        'used_size_usage_lte': 'float',
        'used_size_usage_not': 'float',
        'used_size_usage_not_in': 'list[float]',
        'vm_disks_every': 'VmDiskWhereInput',
        'vm_disks_none': 'VmDiskWhereInput',
        'vm_disks_some': 'VmDiskWhereInput'
    }

    attribute_map = {
        '_and': 'AND',
        '_not': 'NOT',
        '_or': 'OR',
        'cluster': 'cluster',
        'description': 'description',
        'description_contains': 'description_contains',
        'description_ends_with': 'description_ends_with',
        'description_gt': 'description_gt',
        'description_gte': 'description_gte',
        'description_in': 'description_in',
        'description_lt': 'description_lt',
        'description_lte': 'description_lte',
        'description_not': 'description_not',
        'description_not_contains': 'description_not_contains',
        'description_not_ends_with': 'description_not_ends_with',
        'description_not_in': 'description_not_in',
        'description_not_starts_with': 'description_not_starts_with',
        'description_starts_with': 'description_starts_with',
        'elf_storage_policy': 'elf_storage_policy',
        'elf_storage_policy_ec_k': 'elf_storage_policy_ec_k',
        'elf_storage_policy_ec_k_gt': 'elf_storage_policy_ec_k_gt',
        'elf_storage_policy_ec_k_gte': 'elf_storage_policy_ec_k_gte',
        'elf_storage_policy_ec_k_in': 'elf_storage_policy_ec_k_in',
        'elf_storage_policy_ec_k_lt': 'elf_storage_policy_ec_k_lt',
        'elf_storage_policy_ec_k_lte': 'elf_storage_policy_ec_k_lte',
        'elf_storage_policy_ec_k_not': 'elf_storage_policy_ec_k_not',
        'elf_storage_policy_ec_k_not_in': 'elf_storage_policy_ec_k_not_in',
        'elf_storage_policy_ec_m': 'elf_storage_policy_ec_m',
        'elf_storage_policy_ec_m_gt': 'elf_storage_policy_ec_m_gt',
        'elf_storage_policy_ec_m_gte': 'elf_storage_policy_ec_m_gte',
        'elf_storage_policy_ec_m_in': 'elf_storage_policy_ec_m_in',
        'elf_storage_policy_ec_m_lt': 'elf_storage_policy_ec_m_lt',
        'elf_storage_policy_ec_m_lte': 'elf_storage_policy_ec_m_lte',
        'elf_storage_policy_ec_m_not': 'elf_storage_policy_ec_m_not',
        'elf_storage_policy_ec_m_not_in': 'elf_storage_policy_ec_m_not_in',
        'elf_storage_policy_in': 'elf_storage_policy_in',
        'elf_storage_policy_not': 'elf_storage_policy_not',
        'elf_storage_policy_not_in': 'elf_storage_policy_not_in',
        'elf_storage_policy_replica_num': 'elf_storage_policy_replica_num',
        'elf_storage_policy_replica_num_gt': 'elf_storage_policy_replica_num_gt',
        'elf_storage_policy_replica_num_gte': 'elf_storage_policy_replica_num_gte',
        'elf_storage_policy_replica_num_in': 'elf_storage_policy_replica_num_in',
        'elf_storage_policy_replica_num_lt': 'elf_storage_policy_replica_num_lt',
        'elf_storage_policy_replica_num_lte': 'elf_storage_policy_replica_num_lte',
        'elf_storage_policy_replica_num_not': 'elf_storage_policy_replica_num_not',
        'elf_storage_policy_replica_num_not_in': 'elf_storage_policy_replica_num_not_in',
        'elf_storage_policy_thin_provision': 'elf_storage_policy_thin_provision',
        'elf_storage_policy_thin_provision_not': 'elf_storage_policy_thin_provision_not',
        'entity_async_status': 'entityAsyncStatus',
        'entity_async_status_in': 'entityAsyncStatus_in',
        'entity_async_status_not': 'entityAsyncStatus_not',
        'entity_async_status_not_in': 'entityAsyncStatus_not_in',
        'guest_size_usage': 'guest_size_usage',
        'guest_size_usage_gt': 'guest_size_usage_gt',
        'guest_size_usage_gte': 'guest_size_usage_gte',
        'guest_size_usage_in': 'guest_size_usage_in',
        'guest_size_usage_lt': 'guest_size_usage_lt',
        'guest_size_usage_lte': 'guest_size_usage_lte',
        'guest_size_usage_not': 'guest_size_usage_not',
        'guest_size_usage_not_in': 'guest_size_usage_not_in',
        'guest_used_size': 'guest_used_size',
        'guest_used_size_gt': 'guest_used_size_gt',
        'guest_used_size_gte': 'guest_used_size_gte',
        'guest_used_size_in': 'guest_used_size_in',
        'guest_used_size_lt': 'guest_used_size_lt',
        'guest_used_size_lte': 'guest_used_size_lte',
        'guest_used_size_not': 'guest_used_size_not',
        'guest_used_size_not_in': 'guest_used_size_not_in',
        'id': 'id',
        'id_contains': 'id_contains',
        'id_ends_with': 'id_ends_with',
        'id_gt': 'id_gt',
        'id_gte': 'id_gte',
        'id_in': 'id_in',
        'id_lt': 'id_lt',
        'id_lte': 'id_lte',
        'id_not': 'id_not',
        'id_not_contains': 'id_not_contains',
        'id_not_ends_with': 'id_not_ends_with',
        'id_not_in': 'id_not_in',
        'id_not_starts_with': 'id_not_starts_with',
        'id_starts_with': 'id_starts_with',
        'labels_every': 'labels_every',
        'labels_none': 'labels_none',
        'labels_some': 'labels_some',
        'local_created_at': 'local_created_at',
        'local_created_at_gt': 'local_created_at_gt',
        'local_created_at_gte': 'local_created_at_gte',
        'local_created_at_in': 'local_created_at_in',
        'local_created_at_lt': 'local_created_at_lt',
        'local_created_at_lte': 'local_created_at_lte',
        'local_created_at_not': 'local_created_at_not',
        'local_created_at_not_in': 'local_created_at_not_in',
        'local_id': 'local_id',
        'local_id_contains': 'local_id_contains',
        'local_id_ends_with': 'local_id_ends_with',
        'local_id_gt': 'local_id_gt',
        'local_id_gte': 'local_id_gte',
        'local_id_in': 'local_id_in',
        'local_id_lt': 'local_id_lt',
        'local_id_lte': 'local_id_lte',
        'local_id_not': 'local_id_not',
        'local_id_not_contains': 'local_id_not_contains',
        'local_id_not_ends_with': 'local_id_not_ends_with',
        'local_id_not_in': 'local_id_not_in',
        'local_id_not_starts_with': 'local_id_not_starts_with',
        'local_id_starts_with': 'local_id_starts_with',
        'lun': 'lun',
        'mounting': 'mounting',
        'mounting_not': 'mounting_not',
        'name': 'name',
        'name_contains': 'name_contains',
        'name_ends_with': 'name_ends_with',
        'name_gt': 'name_gt',
        'name_gte': 'name_gte',
        'name_in': 'name_in',
        'name_lt': 'name_lt',
        'name_lte': 'name_lte',
        'name_not': 'name_not',
        'name_not_contains': 'name_not_contains',
        'name_not_ends_with': 'name_not_ends_with',
        'name_not_in': 'name_not_in',
        'name_not_starts_with': 'name_not_starts_with',
        'name_starts_with': 'name_starts_with',
        'path': 'path',
        'path_contains': 'path_contains',
        'path_ends_with': 'path_ends_with',
        'path_gt': 'path_gt',
        'path_gte': 'path_gte',
        'path_in': 'path_in',
        'path_lt': 'path_lt',
        'path_lte': 'path_lte',
        'path_not': 'path_not',
        'path_not_contains': 'path_not_contains',
        'path_not_ends_with': 'path_not_ends_with',
        'path_not_in': 'path_not_in',
        'path_not_starts_with': 'path_not_starts_with',
        'path_starts_with': 'path_starts_with',
        'resident_in_cache': 'resident_in_cache',
        'resident_in_cache_not': 'resident_in_cache_not',
        'sharing': 'sharing',
        'sharing_not': 'sharing_not',
        'size': 'size',
        'size_gt': 'size_gt',
        'size_gte': 'size_gte',
        'size_in': 'size_in',
        'size_lt': 'size_lt',
        'size_lte': 'size_lte',
        'size_not': 'size_not',
        'size_not_in': 'size_not_in',
        'type': 'type',
        'type_in': 'type_in',
        'type_not': 'type_not',
        'type_not_in': 'type_not_in',
        'unique_logical_size': 'unique_logical_size',
        'unique_logical_size_gt': 'unique_logical_size_gt',
        'unique_logical_size_gte': 'unique_logical_size_gte',
        'unique_logical_size_in': 'unique_logical_size_in',
        'unique_logical_size_lt': 'unique_logical_size_lt',
        'unique_logical_size_lte': 'unique_logical_size_lte',
        'unique_logical_size_not': 'unique_logical_size_not',
        'unique_logical_size_not_in': 'unique_logical_size_not_in',
        'unique_size': 'unique_size',
        'unique_size_gt': 'unique_size_gt',
        'unique_size_gte': 'unique_size_gte',
        'unique_size_in': 'unique_size_in',
        'unique_size_lt': 'unique_size_lt',
        'unique_size_lte': 'unique_size_lte',
        'unique_size_not': 'unique_size_not',
        'unique_size_not_in': 'unique_size_not_in',
        'used_size': 'used_size',
        'used_size_gt': 'used_size_gt',
        'used_size_gte': 'used_size_gte',
        'used_size_in': 'used_size_in',
        'used_size_lt': 'used_size_lt',
        'used_size_lte': 'used_size_lte',
        'used_size_not': 'used_size_not',
        'used_size_not_in': 'used_size_not_in',
        'used_size_usage': 'used_size_usage',
        'used_size_usage_gt': 'used_size_usage_gt',
        'used_size_usage_gte': 'used_size_usage_gte',
        'used_size_usage_in': 'used_size_usage_in',
        'used_size_usage_lt': 'used_size_usage_lt',
        'used_size_usage_lte': 'used_size_usage_lte',
        'used_size_usage_not': 'used_size_usage_not',
        'used_size_usage_not_in': 'used_size_usage_not_in',
        'vm_disks_every': 'vm_disks_every',
        'vm_disks_none': 'vm_disks_none',
        'vm_disks_some': 'vm_disks_some'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """VmVolumeWhereInput - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self.__and = None
        self.__not = None
        self.__or = None
        self._cluster = None
        self._description = None
        self._description_contains = None
        self._description_ends_with = None
        self._description_gt = None
        self._description_gte = None
        self._description_in = None
        self._description_lt = None
        self._description_lte = None
        self._description_not = None
        self._description_not_contains = None
        self._description_not_ends_with = None
        self._description_not_in = None
        self._description_not_starts_with = None
        self._description_starts_with = None
        self._elf_storage_policy = None
        self._elf_storage_policy_ec_k = None
        self._elf_storage_policy_ec_k_gt = None
        self._elf_storage_policy_ec_k_gte = None
        self._elf_storage_policy_ec_k_in = None
        self._elf_storage_policy_ec_k_lt = None
        self._elf_storage_policy_ec_k_lte = None
        self._elf_storage_policy_ec_k_not = None
        self._elf_storage_policy_ec_k_not_in = None
        self._elf_storage_policy_ec_m = None
        self._elf_storage_policy_ec_m_gt = None
        self._elf_storage_policy_ec_m_gte = None
        self._elf_storage_policy_ec_m_in = None
        self._elf_storage_policy_ec_m_lt = None
        self._elf_storage_policy_ec_m_lte = None
        self._elf_storage_policy_ec_m_not = None
        self._elf_storage_policy_ec_m_not_in = None
        self._elf_storage_policy_in = None
        self._elf_storage_policy_not = None
        self._elf_storage_policy_not_in = None
        self._elf_storage_policy_replica_num = None
        self._elf_storage_policy_replica_num_gt = None
        self._elf_storage_policy_replica_num_gte = None
        self._elf_storage_policy_replica_num_in = None
        self._elf_storage_policy_replica_num_lt = None
        self._elf_storage_policy_replica_num_lte = None
        self._elf_storage_policy_replica_num_not = None
        self._elf_storage_policy_replica_num_not_in = None
        self._elf_storage_policy_thin_provision = None
        self._elf_storage_policy_thin_provision_not = None
        self._entity_async_status = None
        self._entity_async_status_in = None
        self._entity_async_status_not = None
        self._entity_async_status_not_in = None
        self._guest_size_usage = None
        self._guest_size_usage_gt = None
        self._guest_size_usage_gte = None
        self._guest_size_usage_in = None
        self._guest_size_usage_lt = None
        self._guest_size_usage_lte = None
        self._guest_size_usage_not = None
        self._guest_size_usage_not_in = None
        self._guest_used_size = None
        self._guest_used_size_gt = None
        self._guest_used_size_gte = None
        self._guest_used_size_in = None
        self._guest_used_size_lt = None
        self._guest_used_size_lte = None
        self._guest_used_size_not = None
        self._guest_used_size_not_in = None
        self._id = None
        self._id_contains = None
        self._id_ends_with = None
        self._id_gt = None
        self._id_gte = None
        self._id_in = None
        self._id_lt = None
        self._id_lte = None
        self._id_not = None
        self._id_not_contains = None
        self._id_not_ends_with = None
        self._id_not_in = None
        self._id_not_starts_with = None
        self._id_starts_with = None
        self._labels_every = None
        self._labels_none = None
        self._labels_some = None
        self._local_created_at = None
        self._local_created_at_gt = None
        self._local_created_at_gte = None
        self._local_created_at_in = None
        self._local_created_at_lt = None
        self._local_created_at_lte = None
        self._local_created_at_not = None
        self._local_created_at_not_in = None
        self._local_id = None
        self._local_id_contains = None
        self._local_id_ends_with = None
        self._local_id_gt = None
        self._local_id_gte = None
        self._local_id_in = None
        self._local_id_lt = None
        self._local_id_lte = None
        self._local_id_not = None
        self._local_id_not_contains = None
        self._local_id_not_ends_with = None
        self._local_id_not_in = None
        self._local_id_not_starts_with = None
        self._local_id_starts_with = None
        self._lun = None
        self._mounting = None
        self._mounting_not = None
        self._name = None
        self._name_contains = None
        self._name_ends_with = None
        self._name_gt = None
        self._name_gte = None
        self._name_in = None
        self._name_lt = None
        self._name_lte = None
        self._name_not = None
        self._name_not_contains = None
        self._name_not_ends_with = None
        self._name_not_in = None
        self._name_not_starts_with = None
        self._name_starts_with = None
        self._path = None
        self._path_contains = None
        self._path_ends_with = None
        self._path_gt = None
        self._path_gte = None
        self._path_in = None
        self._path_lt = None
        self._path_lte = None
        self._path_not = None
        self._path_not_contains = None
        self._path_not_ends_with = None
        self._path_not_in = None
        self._path_not_starts_with = None
        self._path_starts_with = None
        self._resident_in_cache = None
        self._resident_in_cache_not = None
        self._sharing = None
        self._sharing_not = None
        self._size = None
        self._size_gt = None
        self._size_gte = None
        self._size_in = None
        self._size_lt = None
        self._size_lte = None
        self._size_not = None
        self._size_not_in = None
        self._type = None
        self._type_in = None
        self._type_not = None
        self._type_not_in = None
        self._unique_logical_size = None
        self._unique_logical_size_gt = None
        self._unique_logical_size_gte = None
        self._unique_logical_size_in = None
        self._unique_logical_size_lt = None
        self._unique_logical_size_lte = None
        self._unique_logical_size_not = None
        self._unique_logical_size_not_in = None
        self._unique_size = None
        self._unique_size_gt = None
        self._unique_size_gte = None
        self._unique_size_in = None
        self._unique_size_lt = None
        self._unique_size_lte = None
        self._unique_size_not = None
        self._unique_size_not_in = None
        self._used_size = None
        self._used_size_gt = None
        self._used_size_gte = None
        self._used_size_in = None
        self._used_size_lt = None
        self._used_size_lte = None
        self._used_size_not = None
        self._used_size_not_in = None
        self._used_size_usage = None
        self._used_size_usage_gt = None
        self._used_size_usage_gte = None
        self._used_size_usage_in = None
        self._used_size_usage_lt = None
        self._used_size_usage_lte = None
        self._used_size_usage_not = None
        self._used_size_usage_not_in = None
        self._vm_disks_every = None
        self._vm_disks_none = None
        self._vm_disks_some = None
        self.discriminator = None

        self._and = kwargs.get("_and", None)
        self._not = kwargs.get("_not", None)
        self._or = kwargs.get("_or", None)
        self.cluster = kwargs.get("cluster", None)
        self.description = kwargs.get("description", None)
        self.description_contains = kwargs.get("description_contains", None)
        self.description_ends_with = kwargs.get("description_ends_with", None)
        self.description_gt = kwargs.get("description_gt", None)
        self.description_gte = kwargs.get("description_gte", None)
        self.description_in = kwargs.get("description_in", None)
        self.description_lt = kwargs.get("description_lt", None)
        self.description_lte = kwargs.get("description_lte", None)
        self.description_not = kwargs.get("description_not", None)
        self.description_not_contains = kwargs.get("description_not_contains", None)
        self.description_not_ends_with = kwargs.get("description_not_ends_with", None)
        self.description_not_in = kwargs.get("description_not_in", None)
        self.description_not_starts_with = kwargs.get("description_not_starts_with", None)
        self.description_starts_with = kwargs.get("description_starts_with", None)
        self.elf_storage_policy = kwargs.get("elf_storage_policy", None)
        self.elf_storage_policy_ec_k = kwargs.get("elf_storage_policy_ec_k", None)
        self.elf_storage_policy_ec_k_gt = kwargs.get("elf_storage_policy_ec_k_gt", None)
        self.elf_storage_policy_ec_k_gte = kwargs.get("elf_storage_policy_ec_k_gte", None)
        self.elf_storage_policy_ec_k_in = kwargs.get("elf_storage_policy_ec_k_in", None)
        self.elf_storage_policy_ec_k_lt = kwargs.get("elf_storage_policy_ec_k_lt", None)
        self.elf_storage_policy_ec_k_lte = kwargs.get("elf_storage_policy_ec_k_lte", None)
        self.elf_storage_policy_ec_k_not = kwargs.get("elf_storage_policy_ec_k_not", None)
        self.elf_storage_policy_ec_k_not_in = kwargs.get("elf_storage_policy_ec_k_not_in", None)
        self.elf_storage_policy_ec_m = kwargs.get("elf_storage_policy_ec_m", None)
        self.elf_storage_policy_ec_m_gt = kwargs.get("elf_storage_policy_ec_m_gt", None)
        self.elf_storage_policy_ec_m_gte = kwargs.get("elf_storage_policy_ec_m_gte", None)
        self.elf_storage_policy_ec_m_in = kwargs.get("elf_storage_policy_ec_m_in", None)
        self.elf_storage_policy_ec_m_lt = kwargs.get("elf_storage_policy_ec_m_lt", None)
        self.elf_storage_policy_ec_m_lte = kwargs.get("elf_storage_policy_ec_m_lte", None)
        self.elf_storage_policy_ec_m_not = kwargs.get("elf_storage_policy_ec_m_not", None)
        self.elf_storage_policy_ec_m_not_in = kwargs.get("elf_storage_policy_ec_m_not_in", None)
        self.elf_storage_policy_in = kwargs.get("elf_storage_policy_in", None)
        self.elf_storage_policy_not = kwargs.get("elf_storage_policy_not", None)
        self.elf_storage_policy_not_in = kwargs.get("elf_storage_policy_not_in", None)
        self.elf_storage_policy_replica_num = kwargs.get("elf_storage_policy_replica_num", None)
        self.elf_storage_policy_replica_num_gt = kwargs.get("elf_storage_policy_replica_num_gt", None)
        self.elf_storage_policy_replica_num_gte = kwargs.get("elf_storage_policy_replica_num_gte", None)
        self.elf_storage_policy_replica_num_in = kwargs.get("elf_storage_policy_replica_num_in", None)
        self.elf_storage_policy_replica_num_lt = kwargs.get("elf_storage_policy_replica_num_lt", None)
        self.elf_storage_policy_replica_num_lte = kwargs.get("elf_storage_policy_replica_num_lte", None)
        self.elf_storage_policy_replica_num_not = kwargs.get("elf_storage_policy_replica_num_not", None)
        self.elf_storage_policy_replica_num_not_in = kwargs.get("elf_storage_policy_replica_num_not_in", None)
        self.elf_storage_policy_thin_provision = kwargs.get("elf_storage_policy_thin_provision", None)
        self.elf_storage_policy_thin_provision_not = kwargs.get("elf_storage_policy_thin_provision_not", None)
        self.entity_async_status = kwargs.get("entity_async_status", None)
        self.entity_async_status_in = kwargs.get("entity_async_status_in", None)
        self.entity_async_status_not = kwargs.get("entity_async_status_not", None)
        self.entity_async_status_not_in = kwargs.get("entity_async_status_not_in", None)
        self.guest_size_usage = kwargs.get("guest_size_usage", None)
        self.guest_size_usage_gt = kwargs.get("guest_size_usage_gt", None)
        self.guest_size_usage_gte = kwargs.get("guest_size_usage_gte", None)
        self.guest_size_usage_in = kwargs.get("guest_size_usage_in", None)
        self.guest_size_usage_lt = kwargs.get("guest_size_usage_lt", None)
        self.guest_size_usage_lte = kwargs.get("guest_size_usage_lte", None)
        self.guest_size_usage_not = kwargs.get("guest_size_usage_not", None)
        self.guest_size_usage_not_in = kwargs.get("guest_size_usage_not_in", None)
        self.guest_used_size = kwargs.get("guest_used_size", None)
        self.guest_used_size_gt = kwargs.get("guest_used_size_gt", None)
        self.guest_used_size_gte = kwargs.get("guest_used_size_gte", None)
        self.guest_used_size_in = kwargs.get("guest_used_size_in", None)
        self.guest_used_size_lt = kwargs.get("guest_used_size_lt", None)
        self.guest_used_size_lte = kwargs.get("guest_used_size_lte", None)
        self.guest_used_size_not = kwargs.get("guest_used_size_not", None)
        self.guest_used_size_not_in = kwargs.get("guest_used_size_not_in", None)
        self.id = kwargs.get("id", None)
        self.id_contains = kwargs.get("id_contains", None)
        self.id_ends_with = kwargs.get("id_ends_with", None)
        self.id_gt = kwargs.get("id_gt", None)
        self.id_gte = kwargs.get("id_gte", None)
        self.id_in = kwargs.get("id_in", None)
        self.id_lt = kwargs.get("id_lt", None)
        self.id_lte = kwargs.get("id_lte", None)
        self.id_not = kwargs.get("id_not", None)
        self.id_not_contains = kwargs.get("id_not_contains", None)
        self.id_not_ends_with = kwargs.get("id_not_ends_with", None)
        self.id_not_in = kwargs.get("id_not_in", None)
        self.id_not_starts_with = kwargs.get("id_not_starts_with", None)
        self.id_starts_with = kwargs.get("id_starts_with", None)
        self.labels_every = kwargs.get("labels_every", None)
        self.labels_none = kwargs.get("labels_none", None)
        self.labels_some = kwargs.get("labels_some", None)
        self.local_created_at = kwargs.get("local_created_at", None)
        self.local_created_at_gt = kwargs.get("local_created_at_gt", None)
        self.local_created_at_gte = kwargs.get("local_created_at_gte", None)
        self.local_created_at_in = kwargs.get("local_created_at_in", None)
        self.local_created_at_lt = kwargs.get("local_created_at_lt", None)
        self.local_created_at_lte = kwargs.get("local_created_at_lte", None)
        self.local_created_at_not = kwargs.get("local_created_at_not", None)
        self.local_created_at_not_in = kwargs.get("local_created_at_not_in", None)
        self.local_id = kwargs.get("local_id", None)
        self.local_id_contains = kwargs.get("local_id_contains", None)
        self.local_id_ends_with = kwargs.get("local_id_ends_with", None)
        self.local_id_gt = kwargs.get("local_id_gt", None)
        self.local_id_gte = kwargs.get("local_id_gte", None)
        self.local_id_in = kwargs.get("local_id_in", None)
        self.local_id_lt = kwargs.get("local_id_lt", None)
        self.local_id_lte = kwargs.get("local_id_lte", None)
        self.local_id_not = kwargs.get("local_id_not", None)
        self.local_id_not_contains = kwargs.get("local_id_not_contains", None)
        self.local_id_not_ends_with = kwargs.get("local_id_not_ends_with", None)
        self.local_id_not_in = kwargs.get("local_id_not_in", None)
        self.local_id_not_starts_with = kwargs.get("local_id_not_starts_with", None)
        self.local_id_starts_with = kwargs.get("local_id_starts_with", None)
        self.lun = kwargs.get("lun", None)
        self.mounting = kwargs.get("mounting", None)
        self.mounting_not = kwargs.get("mounting_not", None)
        self.name = kwargs.get("name", None)
        self.name_contains = kwargs.get("name_contains", None)
        self.name_ends_with = kwargs.get("name_ends_with", None)
        self.name_gt = kwargs.get("name_gt", None)
        self.name_gte = kwargs.get("name_gte", None)
        self.name_in = kwargs.get("name_in", None)
        self.name_lt = kwargs.get("name_lt", None)
        self.name_lte = kwargs.get("name_lte", None)
        self.name_not = kwargs.get("name_not", None)
        self.name_not_contains = kwargs.get("name_not_contains", None)
        self.name_not_ends_with = kwargs.get("name_not_ends_with", None)
        self.name_not_in = kwargs.get("name_not_in", None)
        self.name_not_starts_with = kwargs.get("name_not_starts_with", None)
        self.name_starts_with = kwargs.get("name_starts_with", None)
        self.path = kwargs.get("path", None)
        self.path_contains = kwargs.get("path_contains", None)
        self.path_ends_with = kwargs.get("path_ends_with", None)
        self.path_gt = kwargs.get("path_gt", None)
        self.path_gte = kwargs.get("path_gte", None)
        self.path_in = kwargs.get("path_in", None)
        self.path_lt = kwargs.get("path_lt", None)
        self.path_lte = kwargs.get("path_lte", None)
        self.path_not = kwargs.get("path_not", None)
        self.path_not_contains = kwargs.get("path_not_contains", None)
        self.path_not_ends_with = kwargs.get("path_not_ends_with", None)
        self.path_not_in = kwargs.get("path_not_in", None)
        self.path_not_starts_with = kwargs.get("path_not_starts_with", None)
        self.path_starts_with = kwargs.get("path_starts_with", None)
        self.resident_in_cache = kwargs.get("resident_in_cache", None)
        self.resident_in_cache_not = kwargs.get("resident_in_cache_not", None)
        self.sharing = kwargs.get("sharing", None)
        self.sharing_not = kwargs.get("sharing_not", None)
        self.size = kwargs.get("size", None)
        self.size_gt = kwargs.get("size_gt", None)
        self.size_gte = kwargs.get("size_gte", None)
        self.size_in = kwargs.get("size_in", None)
        self.size_lt = kwargs.get("size_lt", None)
        self.size_lte = kwargs.get("size_lte", None)
        self.size_not = kwargs.get("size_not", None)
        self.size_not_in = kwargs.get("size_not_in", None)
        self.type = kwargs.get("type", None)
        self.type_in = kwargs.get("type_in", None)
        self.type_not = kwargs.get("type_not", None)
        self.type_not_in = kwargs.get("type_not_in", None)
        self.unique_logical_size = kwargs.get("unique_logical_size", None)
        self.unique_logical_size_gt = kwargs.get("unique_logical_size_gt", None)
        self.unique_logical_size_gte = kwargs.get("unique_logical_size_gte", None)
        self.unique_logical_size_in = kwargs.get("unique_logical_size_in", None)
        self.unique_logical_size_lt = kwargs.get("unique_logical_size_lt", None)
        self.unique_logical_size_lte = kwargs.get("unique_logical_size_lte", None)
        self.unique_logical_size_not = kwargs.get("unique_logical_size_not", None)
        self.unique_logical_size_not_in = kwargs.get("unique_logical_size_not_in", None)
        self.unique_size = kwargs.get("unique_size", None)
        self.unique_size_gt = kwargs.get("unique_size_gt", None)
        self.unique_size_gte = kwargs.get("unique_size_gte", None)
        self.unique_size_in = kwargs.get("unique_size_in", None)
        self.unique_size_lt = kwargs.get("unique_size_lt", None)
        self.unique_size_lte = kwargs.get("unique_size_lte", None)
        self.unique_size_not = kwargs.get("unique_size_not", None)
        self.unique_size_not_in = kwargs.get("unique_size_not_in", None)
        self.used_size = kwargs.get("used_size", None)
        self.used_size_gt = kwargs.get("used_size_gt", None)
        self.used_size_gte = kwargs.get("used_size_gte", None)
        self.used_size_in = kwargs.get("used_size_in", None)
        self.used_size_lt = kwargs.get("used_size_lt", None)
        self.used_size_lte = kwargs.get("used_size_lte", None)
        self.used_size_not = kwargs.get("used_size_not", None)
        self.used_size_not_in = kwargs.get("used_size_not_in", None)
        self.used_size_usage = kwargs.get("used_size_usage", None)
        self.used_size_usage_gt = kwargs.get("used_size_usage_gt", None)
        self.used_size_usage_gte = kwargs.get("used_size_usage_gte", None)
        self.used_size_usage_in = kwargs.get("used_size_usage_in", None)
        self.used_size_usage_lt = kwargs.get("used_size_usage_lt", None)
        self.used_size_usage_lte = kwargs.get("used_size_usage_lte", None)
        self.used_size_usage_not = kwargs.get("used_size_usage_not", None)
        self.used_size_usage_not_in = kwargs.get("used_size_usage_not_in", None)
        self.vm_disks_every = kwargs.get("vm_disks_every", None)
        self.vm_disks_none = kwargs.get("vm_disks_none", None)
        self.vm_disks_some = kwargs.get("vm_disks_some", None)

    @property
    def _and(self):
        """Gets the _and of this VmVolumeWhereInput.  # noqa: E501


        :return: The _and of this VmVolumeWhereInput.  # noqa: E501
        :rtype: list[VmVolumeWhereInput]
        """
        return self.__and

    @_and.setter
    def _and(self, _and):
        """Sets the _and of this VmVolumeWhereInput.


        :param _and: The _and of this VmVolumeWhereInput.  # noqa: E501
        :type _and: list[VmVolumeWhereInput]
        """

        self.__and = _and

    @property
    def _not(self):
        """Gets the _not of this VmVolumeWhereInput.  # noqa: E501


        :return: The _not of this VmVolumeWhereInput.  # noqa: E501
        :rtype: list[VmVolumeWhereInput]
        """
        return self.__not

    @_not.setter
    def _not(self, _not):
        """Sets the _not of this VmVolumeWhereInput.


        :param _not: The _not of this VmVolumeWhereInput.  # noqa: E501
        :type _not: list[VmVolumeWhereInput]
        """

        self.__not = _not

    @property
    def _or(self):
        """Gets the _or of this VmVolumeWhereInput.  # noqa: E501


        :return: The _or of this VmVolumeWhereInput.  # noqa: E501
        :rtype: list[VmVolumeWhereInput]
        """
        return self.__or

    @_or.setter
    def _or(self, _or):
        """Sets the _or of this VmVolumeWhereInput.


        :param _or: The _or of this VmVolumeWhereInput.  # noqa: E501
        :type _or: list[VmVolumeWhereInput]
        """

        self.__or = _or

    @property
    def cluster(self):
        """Gets the cluster of this VmVolumeWhereInput.  # noqa: E501


        :return: The cluster of this VmVolumeWhereInput.  # noqa: E501
        :rtype: ClusterWhereInput
        """
        return self._cluster

    @cluster.setter
    def cluster(self, cluster):
        """Sets the cluster of this VmVolumeWhereInput.


        :param cluster: The cluster of this VmVolumeWhereInput.  # noqa: E501
        :type cluster: ClusterWhereInput
        """

        self._cluster = cluster

    @property
    def description(self):
        """Gets the description of this VmVolumeWhereInput.  # noqa: E501


        :return: The description of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this VmVolumeWhereInput.


        :param description: The description of this VmVolumeWhereInput.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def description_contains(self):
        """Gets the description_contains of this VmVolumeWhereInput.  # noqa: E501


        :return: The description_contains of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_contains

    @description_contains.setter
    def description_contains(self, description_contains):
        """Sets the description_contains of this VmVolumeWhereInput.


        :param description_contains: The description_contains of this VmVolumeWhereInput.  # noqa: E501
        :type description_contains: str
        """

        self._description_contains = description_contains

    @property
    def description_ends_with(self):
        """Gets the description_ends_with of this VmVolumeWhereInput.  # noqa: E501


        :return: The description_ends_with of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_ends_with

    @description_ends_with.setter
    def description_ends_with(self, description_ends_with):
        """Sets the description_ends_with of this VmVolumeWhereInput.


        :param description_ends_with: The description_ends_with of this VmVolumeWhereInput.  # noqa: E501
        :type description_ends_with: str
        """

        self._description_ends_with = description_ends_with

    @property
    def description_gt(self):
        """Gets the description_gt of this VmVolumeWhereInput.  # noqa: E501


        :return: The description_gt of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_gt

    @description_gt.setter
    def description_gt(self, description_gt):
        """Sets the description_gt of this VmVolumeWhereInput.


        :param description_gt: The description_gt of this VmVolumeWhereInput.  # noqa: E501
        :type description_gt: str
        """

        self._description_gt = description_gt

    @property
    def description_gte(self):
        """Gets the description_gte of this VmVolumeWhereInput.  # noqa: E501


        :return: The description_gte of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_gte

    @description_gte.setter
    def description_gte(self, description_gte):
        """Sets the description_gte of this VmVolumeWhereInput.


        :param description_gte: The description_gte of this VmVolumeWhereInput.  # noqa: E501
        :type description_gte: str
        """

        self._description_gte = description_gte

    @property
    def description_in(self):
        """Gets the description_in of this VmVolumeWhereInput.  # noqa: E501


        :return: The description_in of this VmVolumeWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._description_in

    @description_in.setter
    def description_in(self, description_in):
        """Sets the description_in of this VmVolumeWhereInput.


        :param description_in: The description_in of this VmVolumeWhereInput.  # noqa: E501
        :type description_in: list[str]
        """

        self._description_in = description_in

    @property
    def description_lt(self):
        """Gets the description_lt of this VmVolumeWhereInput.  # noqa: E501


        :return: The description_lt of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_lt

    @description_lt.setter
    def description_lt(self, description_lt):
        """Sets the description_lt of this VmVolumeWhereInput.


        :param description_lt: The description_lt of this VmVolumeWhereInput.  # noqa: E501
        :type description_lt: str
        """

        self._description_lt = description_lt

    @property
    def description_lte(self):
        """Gets the description_lte of this VmVolumeWhereInput.  # noqa: E501


        :return: The description_lte of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_lte

    @description_lte.setter
    def description_lte(self, description_lte):
        """Sets the description_lte of this VmVolumeWhereInput.


        :param description_lte: The description_lte of this VmVolumeWhereInput.  # noqa: E501
        :type description_lte: str
        """

        self._description_lte = description_lte

    @property
    def description_not(self):
        """Gets the description_not of this VmVolumeWhereInput.  # noqa: E501


        :return: The description_not of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_not

    @description_not.setter
    def description_not(self, description_not):
        """Sets the description_not of this VmVolumeWhereInput.


        :param description_not: The description_not of this VmVolumeWhereInput.  # noqa: E501
        :type description_not: str
        """

        self._description_not = description_not

    @property
    def description_not_contains(self):
        """Gets the description_not_contains of this VmVolumeWhereInput.  # noqa: E501


        :return: The description_not_contains of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_not_contains

    @description_not_contains.setter
    def description_not_contains(self, description_not_contains):
        """Sets the description_not_contains of this VmVolumeWhereInput.


        :param description_not_contains: The description_not_contains of this VmVolumeWhereInput.  # noqa: E501
        :type description_not_contains: str
        """

        self._description_not_contains = description_not_contains

    @property
    def description_not_ends_with(self):
        """Gets the description_not_ends_with of this VmVolumeWhereInput.  # noqa: E501


        :return: The description_not_ends_with of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_not_ends_with

    @description_not_ends_with.setter
    def description_not_ends_with(self, description_not_ends_with):
        """Sets the description_not_ends_with of this VmVolumeWhereInput.


        :param description_not_ends_with: The description_not_ends_with of this VmVolumeWhereInput.  # noqa: E501
        :type description_not_ends_with: str
        """

        self._description_not_ends_with = description_not_ends_with

    @property
    def description_not_in(self):
        """Gets the description_not_in of this VmVolumeWhereInput.  # noqa: E501


        :return: The description_not_in of this VmVolumeWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._description_not_in

    @description_not_in.setter
    def description_not_in(self, description_not_in):
        """Sets the description_not_in of this VmVolumeWhereInput.


        :param description_not_in: The description_not_in of this VmVolumeWhereInput.  # noqa: E501
        :type description_not_in: list[str]
        """

        self._description_not_in = description_not_in

    @property
    def description_not_starts_with(self):
        """Gets the description_not_starts_with of this VmVolumeWhereInput.  # noqa: E501


        :return: The description_not_starts_with of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_not_starts_with

    @description_not_starts_with.setter
    def description_not_starts_with(self, description_not_starts_with):
        """Sets the description_not_starts_with of this VmVolumeWhereInput.


        :param description_not_starts_with: The description_not_starts_with of this VmVolumeWhereInput.  # noqa: E501
        :type description_not_starts_with: str
        """

        self._description_not_starts_with = description_not_starts_with

    @property
    def description_starts_with(self):
        """Gets the description_starts_with of this VmVolumeWhereInput.  # noqa: E501


        :return: The description_starts_with of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_starts_with

    @description_starts_with.setter
    def description_starts_with(self, description_starts_with):
        """Sets the description_starts_with of this VmVolumeWhereInput.


        :param description_starts_with: The description_starts_with of this VmVolumeWhereInput.  # noqa: E501
        :type description_starts_with: str
        """

        self._description_starts_with = description_starts_with

    @property
    def elf_storage_policy(self):
        """Gets the elf_storage_policy of this VmVolumeWhereInput.  # noqa: E501


        :return: The elf_storage_policy of this VmVolumeWhereInput.  # noqa: E501
        :rtype: VmVolumeElfStoragePolicyType
        """
        return self._elf_storage_policy

    @elf_storage_policy.setter
    def elf_storage_policy(self, elf_storage_policy):
        """Sets the elf_storage_policy of this VmVolumeWhereInput.


        :param elf_storage_policy: The elf_storage_policy of this VmVolumeWhereInput.  # noqa: E501
        :type elf_storage_policy: VmVolumeElfStoragePolicyType
        """

        self._elf_storage_policy = elf_storage_policy

    @property
    def elf_storage_policy_ec_k(self):
        """Gets the elf_storage_policy_ec_k of this VmVolumeWhereInput.  # noqa: E501


        :return: The elf_storage_policy_ec_k of this VmVolumeWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._elf_storage_policy_ec_k

    @elf_storage_policy_ec_k.setter
    def elf_storage_policy_ec_k(self, elf_storage_policy_ec_k):
        """Sets the elf_storage_policy_ec_k of this VmVolumeWhereInput.


        :param elf_storage_policy_ec_k: The elf_storage_policy_ec_k of this VmVolumeWhereInput.  # noqa: E501
        :type elf_storage_policy_ec_k: int
        """

        self._elf_storage_policy_ec_k = elf_storage_policy_ec_k

    @property
    def elf_storage_policy_ec_k_gt(self):
        """Gets the elf_storage_policy_ec_k_gt of this VmVolumeWhereInput.  # noqa: E501


        :return: The elf_storage_policy_ec_k_gt of this VmVolumeWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._elf_storage_policy_ec_k_gt

    @elf_storage_policy_ec_k_gt.setter
    def elf_storage_policy_ec_k_gt(self, elf_storage_policy_ec_k_gt):
        """Sets the elf_storage_policy_ec_k_gt of this VmVolumeWhereInput.


        :param elf_storage_policy_ec_k_gt: The elf_storage_policy_ec_k_gt of this VmVolumeWhereInput.  # noqa: E501
        :type elf_storage_policy_ec_k_gt: int
        """

        self._elf_storage_policy_ec_k_gt = elf_storage_policy_ec_k_gt

    @property
    def elf_storage_policy_ec_k_gte(self):
        """Gets the elf_storage_policy_ec_k_gte of this VmVolumeWhereInput.  # noqa: E501


        :return: The elf_storage_policy_ec_k_gte of this VmVolumeWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._elf_storage_policy_ec_k_gte

    @elf_storage_policy_ec_k_gte.setter
    def elf_storage_policy_ec_k_gte(self, elf_storage_policy_ec_k_gte):
        """Sets the elf_storage_policy_ec_k_gte of this VmVolumeWhereInput.


        :param elf_storage_policy_ec_k_gte: The elf_storage_policy_ec_k_gte of this VmVolumeWhereInput.  # noqa: E501
        :type elf_storage_policy_ec_k_gte: int
        """

        self._elf_storage_policy_ec_k_gte = elf_storage_policy_ec_k_gte

    @property
    def elf_storage_policy_ec_k_in(self):
        """Gets the elf_storage_policy_ec_k_in of this VmVolumeWhereInput.  # noqa: E501


        :return: The elf_storage_policy_ec_k_in of this VmVolumeWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._elf_storage_policy_ec_k_in

    @elf_storage_policy_ec_k_in.setter
    def elf_storage_policy_ec_k_in(self, elf_storage_policy_ec_k_in):
        """Sets the elf_storage_policy_ec_k_in of this VmVolumeWhereInput.


        :param elf_storage_policy_ec_k_in: The elf_storage_policy_ec_k_in of this VmVolumeWhereInput.  # noqa: E501
        :type elf_storage_policy_ec_k_in: list[int]
        """

        self._elf_storage_policy_ec_k_in = elf_storage_policy_ec_k_in

    @property
    def elf_storage_policy_ec_k_lt(self):
        """Gets the elf_storage_policy_ec_k_lt of this VmVolumeWhereInput.  # noqa: E501


        :return: The elf_storage_policy_ec_k_lt of this VmVolumeWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._elf_storage_policy_ec_k_lt

    @elf_storage_policy_ec_k_lt.setter
    def elf_storage_policy_ec_k_lt(self, elf_storage_policy_ec_k_lt):
        """Sets the elf_storage_policy_ec_k_lt of this VmVolumeWhereInput.


        :param elf_storage_policy_ec_k_lt: The elf_storage_policy_ec_k_lt of this VmVolumeWhereInput.  # noqa: E501
        :type elf_storage_policy_ec_k_lt: int
        """

        self._elf_storage_policy_ec_k_lt = elf_storage_policy_ec_k_lt

    @property
    def elf_storage_policy_ec_k_lte(self):
        """Gets the elf_storage_policy_ec_k_lte of this VmVolumeWhereInput.  # noqa: E501


        :return: The elf_storage_policy_ec_k_lte of this VmVolumeWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._elf_storage_policy_ec_k_lte

    @elf_storage_policy_ec_k_lte.setter
    def elf_storage_policy_ec_k_lte(self, elf_storage_policy_ec_k_lte):
        """Sets the elf_storage_policy_ec_k_lte of this VmVolumeWhereInput.


        :param elf_storage_policy_ec_k_lte: The elf_storage_policy_ec_k_lte of this VmVolumeWhereInput.  # noqa: E501
        :type elf_storage_policy_ec_k_lte: int
        """

        self._elf_storage_policy_ec_k_lte = elf_storage_policy_ec_k_lte

    @property
    def elf_storage_policy_ec_k_not(self):
        """Gets the elf_storage_policy_ec_k_not of this VmVolumeWhereInput.  # noqa: E501


        :return: The elf_storage_policy_ec_k_not of this VmVolumeWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._elf_storage_policy_ec_k_not

    @elf_storage_policy_ec_k_not.setter
    def elf_storage_policy_ec_k_not(self, elf_storage_policy_ec_k_not):
        """Sets the elf_storage_policy_ec_k_not of this VmVolumeWhereInput.


        :param elf_storage_policy_ec_k_not: The elf_storage_policy_ec_k_not of this VmVolumeWhereInput.  # noqa: E501
        :type elf_storage_policy_ec_k_not: int
        """

        self._elf_storage_policy_ec_k_not = elf_storage_policy_ec_k_not

    @property
    def elf_storage_policy_ec_k_not_in(self):
        """Gets the elf_storage_policy_ec_k_not_in of this VmVolumeWhereInput.  # noqa: E501


        :return: The elf_storage_policy_ec_k_not_in of this VmVolumeWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._elf_storage_policy_ec_k_not_in

    @elf_storage_policy_ec_k_not_in.setter
    def elf_storage_policy_ec_k_not_in(self, elf_storage_policy_ec_k_not_in):
        """Sets the elf_storage_policy_ec_k_not_in of this VmVolumeWhereInput.


        :param elf_storage_policy_ec_k_not_in: The elf_storage_policy_ec_k_not_in of this VmVolumeWhereInput.  # noqa: E501
        :type elf_storage_policy_ec_k_not_in: list[int]
        """

        self._elf_storage_policy_ec_k_not_in = elf_storage_policy_ec_k_not_in

    @property
    def elf_storage_policy_ec_m(self):
        """Gets the elf_storage_policy_ec_m of this VmVolumeWhereInput.  # noqa: E501


        :return: The elf_storage_policy_ec_m of this VmVolumeWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._elf_storage_policy_ec_m

    @elf_storage_policy_ec_m.setter
    def elf_storage_policy_ec_m(self, elf_storage_policy_ec_m):
        """Sets the elf_storage_policy_ec_m of this VmVolumeWhereInput.


        :param elf_storage_policy_ec_m: The elf_storage_policy_ec_m of this VmVolumeWhereInput.  # noqa: E501
        :type elf_storage_policy_ec_m: int
        """

        self._elf_storage_policy_ec_m = elf_storage_policy_ec_m

    @property
    def elf_storage_policy_ec_m_gt(self):
        """Gets the elf_storage_policy_ec_m_gt of this VmVolumeWhereInput.  # noqa: E501


        :return: The elf_storage_policy_ec_m_gt of this VmVolumeWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._elf_storage_policy_ec_m_gt

    @elf_storage_policy_ec_m_gt.setter
    def elf_storage_policy_ec_m_gt(self, elf_storage_policy_ec_m_gt):
        """Sets the elf_storage_policy_ec_m_gt of this VmVolumeWhereInput.


        :param elf_storage_policy_ec_m_gt: The elf_storage_policy_ec_m_gt of this VmVolumeWhereInput.  # noqa: E501
        :type elf_storage_policy_ec_m_gt: int
        """

        self._elf_storage_policy_ec_m_gt = elf_storage_policy_ec_m_gt

    @property
    def elf_storage_policy_ec_m_gte(self):
        """Gets the elf_storage_policy_ec_m_gte of this VmVolumeWhereInput.  # noqa: E501


        :return: The elf_storage_policy_ec_m_gte of this VmVolumeWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._elf_storage_policy_ec_m_gte

    @elf_storage_policy_ec_m_gte.setter
    def elf_storage_policy_ec_m_gte(self, elf_storage_policy_ec_m_gte):
        """Sets the elf_storage_policy_ec_m_gte of this VmVolumeWhereInput.


        :param elf_storage_policy_ec_m_gte: The elf_storage_policy_ec_m_gte of this VmVolumeWhereInput.  # noqa: E501
        :type elf_storage_policy_ec_m_gte: int
        """

        self._elf_storage_policy_ec_m_gte = elf_storage_policy_ec_m_gte

    @property
    def elf_storage_policy_ec_m_in(self):
        """Gets the elf_storage_policy_ec_m_in of this VmVolumeWhereInput.  # noqa: E501


        :return: The elf_storage_policy_ec_m_in of this VmVolumeWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._elf_storage_policy_ec_m_in

    @elf_storage_policy_ec_m_in.setter
    def elf_storage_policy_ec_m_in(self, elf_storage_policy_ec_m_in):
        """Sets the elf_storage_policy_ec_m_in of this VmVolumeWhereInput.


        :param elf_storage_policy_ec_m_in: The elf_storage_policy_ec_m_in of this VmVolumeWhereInput.  # noqa: E501
        :type elf_storage_policy_ec_m_in: list[int]
        """

        self._elf_storage_policy_ec_m_in = elf_storage_policy_ec_m_in

    @property
    def elf_storage_policy_ec_m_lt(self):
        """Gets the elf_storage_policy_ec_m_lt of this VmVolumeWhereInput.  # noqa: E501


        :return: The elf_storage_policy_ec_m_lt of this VmVolumeWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._elf_storage_policy_ec_m_lt

    @elf_storage_policy_ec_m_lt.setter
    def elf_storage_policy_ec_m_lt(self, elf_storage_policy_ec_m_lt):
        """Sets the elf_storage_policy_ec_m_lt of this VmVolumeWhereInput.


        :param elf_storage_policy_ec_m_lt: The elf_storage_policy_ec_m_lt of this VmVolumeWhereInput.  # noqa: E501
        :type elf_storage_policy_ec_m_lt: int
        """

        self._elf_storage_policy_ec_m_lt = elf_storage_policy_ec_m_lt

    @property
    def elf_storage_policy_ec_m_lte(self):
        """Gets the elf_storage_policy_ec_m_lte of this VmVolumeWhereInput.  # noqa: E501


        :return: The elf_storage_policy_ec_m_lte of this VmVolumeWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._elf_storage_policy_ec_m_lte

    @elf_storage_policy_ec_m_lte.setter
    def elf_storage_policy_ec_m_lte(self, elf_storage_policy_ec_m_lte):
        """Sets the elf_storage_policy_ec_m_lte of this VmVolumeWhereInput.


        :param elf_storage_policy_ec_m_lte: The elf_storage_policy_ec_m_lte of this VmVolumeWhereInput.  # noqa: E501
        :type elf_storage_policy_ec_m_lte: int
        """

        self._elf_storage_policy_ec_m_lte = elf_storage_policy_ec_m_lte

    @property
    def elf_storage_policy_ec_m_not(self):
        """Gets the elf_storage_policy_ec_m_not of this VmVolumeWhereInput.  # noqa: E501


        :return: The elf_storage_policy_ec_m_not of this VmVolumeWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._elf_storage_policy_ec_m_not

    @elf_storage_policy_ec_m_not.setter
    def elf_storage_policy_ec_m_not(self, elf_storage_policy_ec_m_not):
        """Sets the elf_storage_policy_ec_m_not of this VmVolumeWhereInput.


        :param elf_storage_policy_ec_m_not: The elf_storage_policy_ec_m_not of this VmVolumeWhereInput.  # noqa: E501
        :type elf_storage_policy_ec_m_not: int
        """

        self._elf_storage_policy_ec_m_not = elf_storage_policy_ec_m_not

    @property
    def elf_storage_policy_ec_m_not_in(self):
        """Gets the elf_storage_policy_ec_m_not_in of this VmVolumeWhereInput.  # noqa: E501


        :return: The elf_storage_policy_ec_m_not_in of this VmVolumeWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._elf_storage_policy_ec_m_not_in

    @elf_storage_policy_ec_m_not_in.setter
    def elf_storage_policy_ec_m_not_in(self, elf_storage_policy_ec_m_not_in):
        """Sets the elf_storage_policy_ec_m_not_in of this VmVolumeWhereInput.


        :param elf_storage_policy_ec_m_not_in: The elf_storage_policy_ec_m_not_in of this VmVolumeWhereInput.  # noqa: E501
        :type elf_storage_policy_ec_m_not_in: list[int]
        """

        self._elf_storage_policy_ec_m_not_in = elf_storage_policy_ec_m_not_in

    @property
    def elf_storage_policy_in(self):
        """Gets the elf_storage_policy_in of this VmVolumeWhereInput.  # noqa: E501


        :return: The elf_storage_policy_in of this VmVolumeWhereInput.  # noqa: E501
        :rtype: list[VmVolumeElfStoragePolicyType]
        """
        return self._elf_storage_policy_in

    @elf_storage_policy_in.setter
    def elf_storage_policy_in(self, elf_storage_policy_in):
        """Sets the elf_storage_policy_in of this VmVolumeWhereInput.


        :param elf_storage_policy_in: The elf_storage_policy_in of this VmVolumeWhereInput.  # noqa: E501
        :type elf_storage_policy_in: list[VmVolumeElfStoragePolicyType]
        """

        self._elf_storage_policy_in = elf_storage_policy_in

    @property
    def elf_storage_policy_not(self):
        """Gets the elf_storage_policy_not of this VmVolumeWhereInput.  # noqa: E501


        :return: The elf_storage_policy_not of this VmVolumeWhereInput.  # noqa: E501
        :rtype: VmVolumeElfStoragePolicyType
        """
        return self._elf_storage_policy_not

    @elf_storage_policy_not.setter
    def elf_storage_policy_not(self, elf_storage_policy_not):
        """Sets the elf_storage_policy_not of this VmVolumeWhereInput.


        :param elf_storage_policy_not: The elf_storage_policy_not of this VmVolumeWhereInput.  # noqa: E501
        :type elf_storage_policy_not: VmVolumeElfStoragePolicyType
        """

        self._elf_storage_policy_not = elf_storage_policy_not

    @property
    def elf_storage_policy_not_in(self):
        """Gets the elf_storage_policy_not_in of this VmVolumeWhereInput.  # noqa: E501


        :return: The elf_storage_policy_not_in of this VmVolumeWhereInput.  # noqa: E501
        :rtype: list[VmVolumeElfStoragePolicyType]
        """
        return self._elf_storage_policy_not_in

    @elf_storage_policy_not_in.setter
    def elf_storage_policy_not_in(self, elf_storage_policy_not_in):
        """Sets the elf_storage_policy_not_in of this VmVolumeWhereInput.


        :param elf_storage_policy_not_in: The elf_storage_policy_not_in of this VmVolumeWhereInput.  # noqa: E501
        :type elf_storage_policy_not_in: list[VmVolumeElfStoragePolicyType]
        """

        self._elf_storage_policy_not_in = elf_storage_policy_not_in

    @property
    def elf_storage_policy_replica_num(self):
        """Gets the elf_storage_policy_replica_num of this VmVolumeWhereInput.  # noqa: E501


        :return: The elf_storage_policy_replica_num of this VmVolumeWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._elf_storage_policy_replica_num

    @elf_storage_policy_replica_num.setter
    def elf_storage_policy_replica_num(self, elf_storage_policy_replica_num):
        """Sets the elf_storage_policy_replica_num of this VmVolumeWhereInput.


        :param elf_storage_policy_replica_num: The elf_storage_policy_replica_num of this VmVolumeWhereInput.  # noqa: E501
        :type elf_storage_policy_replica_num: int
        """

        self._elf_storage_policy_replica_num = elf_storage_policy_replica_num

    @property
    def elf_storage_policy_replica_num_gt(self):
        """Gets the elf_storage_policy_replica_num_gt of this VmVolumeWhereInput.  # noqa: E501


        :return: The elf_storage_policy_replica_num_gt of this VmVolumeWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._elf_storage_policy_replica_num_gt

    @elf_storage_policy_replica_num_gt.setter
    def elf_storage_policy_replica_num_gt(self, elf_storage_policy_replica_num_gt):
        """Sets the elf_storage_policy_replica_num_gt of this VmVolumeWhereInput.


        :param elf_storage_policy_replica_num_gt: The elf_storage_policy_replica_num_gt of this VmVolumeWhereInput.  # noqa: E501
        :type elf_storage_policy_replica_num_gt: int
        """

        self._elf_storage_policy_replica_num_gt = elf_storage_policy_replica_num_gt

    @property
    def elf_storage_policy_replica_num_gte(self):
        """Gets the elf_storage_policy_replica_num_gte of this VmVolumeWhereInput.  # noqa: E501


        :return: The elf_storage_policy_replica_num_gte of this VmVolumeWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._elf_storage_policy_replica_num_gte

    @elf_storage_policy_replica_num_gte.setter
    def elf_storage_policy_replica_num_gte(self, elf_storage_policy_replica_num_gte):
        """Sets the elf_storage_policy_replica_num_gte of this VmVolumeWhereInput.


        :param elf_storage_policy_replica_num_gte: The elf_storage_policy_replica_num_gte of this VmVolumeWhereInput.  # noqa: E501
        :type elf_storage_policy_replica_num_gte: int
        """

        self._elf_storage_policy_replica_num_gte = elf_storage_policy_replica_num_gte

    @property
    def elf_storage_policy_replica_num_in(self):
        """Gets the elf_storage_policy_replica_num_in of this VmVolumeWhereInput.  # noqa: E501


        :return: The elf_storage_policy_replica_num_in of this VmVolumeWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._elf_storage_policy_replica_num_in

    @elf_storage_policy_replica_num_in.setter
    def elf_storage_policy_replica_num_in(self, elf_storage_policy_replica_num_in):
        """Sets the elf_storage_policy_replica_num_in of this VmVolumeWhereInput.


        :param elf_storage_policy_replica_num_in: The elf_storage_policy_replica_num_in of this VmVolumeWhereInput.  # noqa: E501
        :type elf_storage_policy_replica_num_in: list[int]
        """

        self._elf_storage_policy_replica_num_in = elf_storage_policy_replica_num_in

    @property
    def elf_storage_policy_replica_num_lt(self):
        """Gets the elf_storage_policy_replica_num_lt of this VmVolumeWhereInput.  # noqa: E501


        :return: The elf_storage_policy_replica_num_lt of this VmVolumeWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._elf_storage_policy_replica_num_lt

    @elf_storage_policy_replica_num_lt.setter
    def elf_storage_policy_replica_num_lt(self, elf_storage_policy_replica_num_lt):
        """Sets the elf_storage_policy_replica_num_lt of this VmVolumeWhereInput.


        :param elf_storage_policy_replica_num_lt: The elf_storage_policy_replica_num_lt of this VmVolumeWhereInput.  # noqa: E501
        :type elf_storage_policy_replica_num_lt: int
        """

        self._elf_storage_policy_replica_num_lt = elf_storage_policy_replica_num_lt

    @property
    def elf_storage_policy_replica_num_lte(self):
        """Gets the elf_storage_policy_replica_num_lte of this VmVolumeWhereInput.  # noqa: E501


        :return: The elf_storage_policy_replica_num_lte of this VmVolumeWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._elf_storage_policy_replica_num_lte

    @elf_storage_policy_replica_num_lte.setter
    def elf_storage_policy_replica_num_lte(self, elf_storage_policy_replica_num_lte):
        """Sets the elf_storage_policy_replica_num_lte of this VmVolumeWhereInput.


        :param elf_storage_policy_replica_num_lte: The elf_storage_policy_replica_num_lte of this VmVolumeWhereInput.  # noqa: E501
        :type elf_storage_policy_replica_num_lte: int
        """

        self._elf_storage_policy_replica_num_lte = elf_storage_policy_replica_num_lte

    @property
    def elf_storage_policy_replica_num_not(self):
        """Gets the elf_storage_policy_replica_num_not of this VmVolumeWhereInput.  # noqa: E501


        :return: The elf_storage_policy_replica_num_not of this VmVolumeWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._elf_storage_policy_replica_num_not

    @elf_storage_policy_replica_num_not.setter
    def elf_storage_policy_replica_num_not(self, elf_storage_policy_replica_num_not):
        """Sets the elf_storage_policy_replica_num_not of this VmVolumeWhereInput.


        :param elf_storage_policy_replica_num_not: The elf_storage_policy_replica_num_not of this VmVolumeWhereInput.  # noqa: E501
        :type elf_storage_policy_replica_num_not: int
        """

        self._elf_storage_policy_replica_num_not = elf_storage_policy_replica_num_not

    @property
    def elf_storage_policy_replica_num_not_in(self):
        """Gets the elf_storage_policy_replica_num_not_in of this VmVolumeWhereInput.  # noqa: E501


        :return: The elf_storage_policy_replica_num_not_in of this VmVolumeWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._elf_storage_policy_replica_num_not_in

    @elf_storage_policy_replica_num_not_in.setter
    def elf_storage_policy_replica_num_not_in(self, elf_storage_policy_replica_num_not_in):
        """Sets the elf_storage_policy_replica_num_not_in of this VmVolumeWhereInput.


        :param elf_storage_policy_replica_num_not_in: The elf_storage_policy_replica_num_not_in of this VmVolumeWhereInput.  # noqa: E501
        :type elf_storage_policy_replica_num_not_in: list[int]
        """

        self._elf_storage_policy_replica_num_not_in = elf_storage_policy_replica_num_not_in

    @property
    def elf_storage_policy_thin_provision(self):
        """Gets the elf_storage_policy_thin_provision of this VmVolumeWhereInput.  # noqa: E501


        :return: The elf_storage_policy_thin_provision of this VmVolumeWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._elf_storage_policy_thin_provision

    @elf_storage_policy_thin_provision.setter
    def elf_storage_policy_thin_provision(self, elf_storage_policy_thin_provision):
        """Sets the elf_storage_policy_thin_provision of this VmVolumeWhereInput.


        :param elf_storage_policy_thin_provision: The elf_storage_policy_thin_provision of this VmVolumeWhereInput.  # noqa: E501
        :type elf_storage_policy_thin_provision: bool
        """

        self._elf_storage_policy_thin_provision = elf_storage_policy_thin_provision

    @property
    def elf_storage_policy_thin_provision_not(self):
        """Gets the elf_storage_policy_thin_provision_not of this VmVolumeWhereInput.  # noqa: E501


        :return: The elf_storage_policy_thin_provision_not of this VmVolumeWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._elf_storage_policy_thin_provision_not

    @elf_storage_policy_thin_provision_not.setter
    def elf_storage_policy_thin_provision_not(self, elf_storage_policy_thin_provision_not):
        """Sets the elf_storage_policy_thin_provision_not of this VmVolumeWhereInput.


        :param elf_storage_policy_thin_provision_not: The elf_storage_policy_thin_provision_not of this VmVolumeWhereInput.  # noqa: E501
        :type elf_storage_policy_thin_provision_not: bool
        """

        self._elf_storage_policy_thin_provision_not = elf_storage_policy_thin_provision_not

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this VmVolumeWhereInput.  # noqa: E501


        :return: The entity_async_status of this VmVolumeWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this VmVolumeWhereInput.


        :param entity_async_status: The entity_async_status of this VmVolumeWhereInput.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def entity_async_status_in(self):
        """Gets the entity_async_status_in of this VmVolumeWhereInput.  # noqa: E501


        :return: The entity_async_status_in of this VmVolumeWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_in

    @entity_async_status_in.setter
    def entity_async_status_in(self, entity_async_status_in):
        """Sets the entity_async_status_in of this VmVolumeWhereInput.


        :param entity_async_status_in: The entity_async_status_in of this VmVolumeWhereInput.  # noqa: E501
        :type entity_async_status_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_in = entity_async_status_in

    @property
    def entity_async_status_not(self):
        """Gets the entity_async_status_not of this VmVolumeWhereInput.  # noqa: E501


        :return: The entity_async_status_not of this VmVolumeWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status_not

    @entity_async_status_not.setter
    def entity_async_status_not(self, entity_async_status_not):
        """Sets the entity_async_status_not of this VmVolumeWhereInput.


        :param entity_async_status_not: The entity_async_status_not of this VmVolumeWhereInput.  # noqa: E501
        :type entity_async_status_not: EntityAsyncStatus
        """

        self._entity_async_status_not = entity_async_status_not

    @property
    def entity_async_status_not_in(self):
        """Gets the entity_async_status_not_in of this VmVolumeWhereInput.  # noqa: E501


        :return: The entity_async_status_not_in of this VmVolumeWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_not_in

    @entity_async_status_not_in.setter
    def entity_async_status_not_in(self, entity_async_status_not_in):
        """Sets the entity_async_status_not_in of this VmVolumeWhereInput.


        :param entity_async_status_not_in: The entity_async_status_not_in of this VmVolumeWhereInput.  # noqa: E501
        :type entity_async_status_not_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_not_in = entity_async_status_not_in

    @property
    def guest_size_usage(self):
        """Gets the guest_size_usage of this VmVolumeWhereInput.  # noqa: E501


        :return: The guest_size_usage of this VmVolumeWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._guest_size_usage

    @guest_size_usage.setter
    def guest_size_usage(self, guest_size_usage):
        """Sets the guest_size_usage of this VmVolumeWhereInput.


        :param guest_size_usage: The guest_size_usage of this VmVolumeWhereInput.  # noqa: E501
        :type guest_size_usage: float
        """

        self._guest_size_usage = guest_size_usage

    @property
    def guest_size_usage_gt(self):
        """Gets the guest_size_usage_gt of this VmVolumeWhereInput.  # noqa: E501


        :return: The guest_size_usage_gt of this VmVolumeWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._guest_size_usage_gt

    @guest_size_usage_gt.setter
    def guest_size_usage_gt(self, guest_size_usage_gt):
        """Sets the guest_size_usage_gt of this VmVolumeWhereInput.


        :param guest_size_usage_gt: The guest_size_usage_gt of this VmVolumeWhereInput.  # noqa: E501
        :type guest_size_usage_gt: float
        """

        self._guest_size_usage_gt = guest_size_usage_gt

    @property
    def guest_size_usage_gte(self):
        """Gets the guest_size_usage_gte of this VmVolumeWhereInput.  # noqa: E501


        :return: The guest_size_usage_gte of this VmVolumeWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._guest_size_usage_gte

    @guest_size_usage_gte.setter
    def guest_size_usage_gte(self, guest_size_usage_gte):
        """Sets the guest_size_usage_gte of this VmVolumeWhereInput.


        :param guest_size_usage_gte: The guest_size_usage_gte of this VmVolumeWhereInput.  # noqa: E501
        :type guest_size_usage_gte: float
        """

        self._guest_size_usage_gte = guest_size_usage_gte

    @property
    def guest_size_usage_in(self):
        """Gets the guest_size_usage_in of this VmVolumeWhereInput.  # noqa: E501


        :return: The guest_size_usage_in of this VmVolumeWhereInput.  # noqa: E501
        :rtype: list[float]
        """
        return self._guest_size_usage_in

    @guest_size_usage_in.setter
    def guest_size_usage_in(self, guest_size_usage_in):
        """Sets the guest_size_usage_in of this VmVolumeWhereInput.


        :param guest_size_usage_in: The guest_size_usage_in of this VmVolumeWhereInput.  # noqa: E501
        :type guest_size_usage_in: list[float]
        """

        self._guest_size_usage_in = guest_size_usage_in

    @property
    def guest_size_usage_lt(self):
        """Gets the guest_size_usage_lt of this VmVolumeWhereInput.  # noqa: E501


        :return: The guest_size_usage_lt of this VmVolumeWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._guest_size_usage_lt

    @guest_size_usage_lt.setter
    def guest_size_usage_lt(self, guest_size_usage_lt):
        """Sets the guest_size_usage_lt of this VmVolumeWhereInput.


        :param guest_size_usage_lt: The guest_size_usage_lt of this VmVolumeWhereInput.  # noqa: E501
        :type guest_size_usage_lt: float
        """

        self._guest_size_usage_lt = guest_size_usage_lt

    @property
    def guest_size_usage_lte(self):
        """Gets the guest_size_usage_lte of this VmVolumeWhereInput.  # noqa: E501


        :return: The guest_size_usage_lte of this VmVolumeWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._guest_size_usage_lte

    @guest_size_usage_lte.setter
    def guest_size_usage_lte(self, guest_size_usage_lte):
        """Sets the guest_size_usage_lte of this VmVolumeWhereInput.


        :param guest_size_usage_lte: The guest_size_usage_lte of this VmVolumeWhereInput.  # noqa: E501
        :type guest_size_usage_lte: float
        """

        self._guest_size_usage_lte = guest_size_usage_lte

    @property
    def guest_size_usage_not(self):
        """Gets the guest_size_usage_not of this VmVolumeWhereInput.  # noqa: E501


        :return: The guest_size_usage_not of this VmVolumeWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._guest_size_usage_not

    @guest_size_usage_not.setter
    def guest_size_usage_not(self, guest_size_usage_not):
        """Sets the guest_size_usage_not of this VmVolumeWhereInput.


        :param guest_size_usage_not: The guest_size_usage_not of this VmVolumeWhereInput.  # noqa: E501
        :type guest_size_usage_not: float
        """

        self._guest_size_usage_not = guest_size_usage_not

    @property
    def guest_size_usage_not_in(self):
        """Gets the guest_size_usage_not_in of this VmVolumeWhereInput.  # noqa: E501


        :return: The guest_size_usage_not_in of this VmVolumeWhereInput.  # noqa: E501
        :rtype: list[float]
        """
        return self._guest_size_usage_not_in

    @guest_size_usage_not_in.setter
    def guest_size_usage_not_in(self, guest_size_usage_not_in):
        """Sets the guest_size_usage_not_in of this VmVolumeWhereInput.


        :param guest_size_usage_not_in: The guest_size_usage_not_in of this VmVolumeWhereInput.  # noqa: E501
        :type guest_size_usage_not_in: list[float]
        """

        self._guest_size_usage_not_in = guest_size_usage_not_in

    @property
    def guest_used_size(self):
        """Gets the guest_used_size of this VmVolumeWhereInput.  # noqa: E501


        :return: The guest_used_size of this VmVolumeWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._guest_used_size

    @guest_used_size.setter
    def guest_used_size(self, guest_used_size):
        """Sets the guest_used_size of this VmVolumeWhereInput.


        :param guest_used_size: The guest_used_size of this VmVolumeWhereInput.  # noqa: E501
        :type guest_used_size: int
        """

        self._guest_used_size = guest_used_size

    @property
    def guest_used_size_gt(self):
        """Gets the guest_used_size_gt of this VmVolumeWhereInput.  # noqa: E501


        :return: The guest_used_size_gt of this VmVolumeWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._guest_used_size_gt

    @guest_used_size_gt.setter
    def guest_used_size_gt(self, guest_used_size_gt):
        """Sets the guest_used_size_gt of this VmVolumeWhereInput.


        :param guest_used_size_gt: The guest_used_size_gt of this VmVolumeWhereInput.  # noqa: E501
        :type guest_used_size_gt: int
        """

        self._guest_used_size_gt = guest_used_size_gt

    @property
    def guest_used_size_gte(self):
        """Gets the guest_used_size_gte of this VmVolumeWhereInput.  # noqa: E501


        :return: The guest_used_size_gte of this VmVolumeWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._guest_used_size_gte

    @guest_used_size_gte.setter
    def guest_used_size_gte(self, guest_used_size_gte):
        """Sets the guest_used_size_gte of this VmVolumeWhereInput.


        :param guest_used_size_gte: The guest_used_size_gte of this VmVolumeWhereInput.  # noqa: E501
        :type guest_used_size_gte: int
        """

        self._guest_used_size_gte = guest_used_size_gte

    @property
    def guest_used_size_in(self):
        """Gets the guest_used_size_in of this VmVolumeWhereInput.  # noqa: E501


        :return: The guest_used_size_in of this VmVolumeWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._guest_used_size_in

    @guest_used_size_in.setter
    def guest_used_size_in(self, guest_used_size_in):
        """Sets the guest_used_size_in of this VmVolumeWhereInput.


        :param guest_used_size_in: The guest_used_size_in of this VmVolumeWhereInput.  # noqa: E501
        :type guest_used_size_in: list[int]
        """

        self._guest_used_size_in = guest_used_size_in

    @property
    def guest_used_size_lt(self):
        """Gets the guest_used_size_lt of this VmVolumeWhereInput.  # noqa: E501


        :return: The guest_used_size_lt of this VmVolumeWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._guest_used_size_lt

    @guest_used_size_lt.setter
    def guest_used_size_lt(self, guest_used_size_lt):
        """Sets the guest_used_size_lt of this VmVolumeWhereInput.


        :param guest_used_size_lt: The guest_used_size_lt of this VmVolumeWhereInput.  # noqa: E501
        :type guest_used_size_lt: int
        """

        self._guest_used_size_lt = guest_used_size_lt

    @property
    def guest_used_size_lte(self):
        """Gets the guest_used_size_lte of this VmVolumeWhereInput.  # noqa: E501


        :return: The guest_used_size_lte of this VmVolumeWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._guest_used_size_lte

    @guest_used_size_lte.setter
    def guest_used_size_lte(self, guest_used_size_lte):
        """Sets the guest_used_size_lte of this VmVolumeWhereInput.


        :param guest_used_size_lte: The guest_used_size_lte of this VmVolumeWhereInput.  # noqa: E501
        :type guest_used_size_lte: int
        """

        self._guest_used_size_lte = guest_used_size_lte

    @property
    def guest_used_size_not(self):
        """Gets the guest_used_size_not of this VmVolumeWhereInput.  # noqa: E501


        :return: The guest_used_size_not of this VmVolumeWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._guest_used_size_not

    @guest_used_size_not.setter
    def guest_used_size_not(self, guest_used_size_not):
        """Sets the guest_used_size_not of this VmVolumeWhereInput.


        :param guest_used_size_not: The guest_used_size_not of this VmVolumeWhereInput.  # noqa: E501
        :type guest_used_size_not: int
        """

        self._guest_used_size_not = guest_used_size_not

    @property
    def guest_used_size_not_in(self):
        """Gets the guest_used_size_not_in of this VmVolumeWhereInput.  # noqa: E501


        :return: The guest_used_size_not_in of this VmVolumeWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._guest_used_size_not_in

    @guest_used_size_not_in.setter
    def guest_used_size_not_in(self, guest_used_size_not_in):
        """Sets the guest_used_size_not_in of this VmVolumeWhereInput.


        :param guest_used_size_not_in: The guest_used_size_not_in of this VmVolumeWhereInput.  # noqa: E501
        :type guest_used_size_not_in: list[int]
        """

        self._guest_used_size_not_in = guest_used_size_not_in

    @property
    def id(self):
        """Gets the id of this VmVolumeWhereInput.  # noqa: E501


        :return: The id of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this VmVolumeWhereInput.


        :param id: The id of this VmVolumeWhereInput.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def id_contains(self):
        """Gets the id_contains of this VmVolumeWhereInput.  # noqa: E501


        :return: The id_contains of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_contains

    @id_contains.setter
    def id_contains(self, id_contains):
        """Sets the id_contains of this VmVolumeWhereInput.


        :param id_contains: The id_contains of this VmVolumeWhereInput.  # noqa: E501
        :type id_contains: str
        """

        self._id_contains = id_contains

    @property
    def id_ends_with(self):
        """Gets the id_ends_with of this VmVolumeWhereInput.  # noqa: E501


        :return: The id_ends_with of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_ends_with

    @id_ends_with.setter
    def id_ends_with(self, id_ends_with):
        """Sets the id_ends_with of this VmVolumeWhereInput.


        :param id_ends_with: The id_ends_with of this VmVolumeWhereInput.  # noqa: E501
        :type id_ends_with: str
        """

        self._id_ends_with = id_ends_with

    @property
    def id_gt(self):
        """Gets the id_gt of this VmVolumeWhereInput.  # noqa: E501


        :return: The id_gt of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gt

    @id_gt.setter
    def id_gt(self, id_gt):
        """Sets the id_gt of this VmVolumeWhereInput.


        :param id_gt: The id_gt of this VmVolumeWhereInput.  # noqa: E501
        :type id_gt: str
        """

        self._id_gt = id_gt

    @property
    def id_gte(self):
        """Gets the id_gte of this VmVolumeWhereInput.  # noqa: E501


        :return: The id_gte of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gte

    @id_gte.setter
    def id_gte(self, id_gte):
        """Sets the id_gte of this VmVolumeWhereInput.


        :param id_gte: The id_gte of this VmVolumeWhereInput.  # noqa: E501
        :type id_gte: str
        """

        self._id_gte = id_gte

    @property
    def id_in(self):
        """Gets the id_in of this VmVolumeWhereInput.  # noqa: E501


        :return: The id_in of this VmVolumeWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_in

    @id_in.setter
    def id_in(self, id_in):
        """Sets the id_in of this VmVolumeWhereInput.


        :param id_in: The id_in of this VmVolumeWhereInput.  # noqa: E501
        :type id_in: list[str]
        """

        self._id_in = id_in

    @property
    def id_lt(self):
        """Gets the id_lt of this VmVolumeWhereInput.  # noqa: E501


        :return: The id_lt of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lt

    @id_lt.setter
    def id_lt(self, id_lt):
        """Sets the id_lt of this VmVolumeWhereInput.


        :param id_lt: The id_lt of this VmVolumeWhereInput.  # noqa: E501
        :type id_lt: str
        """

        self._id_lt = id_lt

    @property
    def id_lte(self):
        """Gets the id_lte of this VmVolumeWhereInput.  # noqa: E501


        :return: The id_lte of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lte

    @id_lte.setter
    def id_lte(self, id_lte):
        """Sets the id_lte of this VmVolumeWhereInput.


        :param id_lte: The id_lte of this VmVolumeWhereInput.  # noqa: E501
        :type id_lte: str
        """

        self._id_lte = id_lte

    @property
    def id_not(self):
        """Gets the id_not of this VmVolumeWhereInput.  # noqa: E501


        :return: The id_not of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not

    @id_not.setter
    def id_not(self, id_not):
        """Sets the id_not of this VmVolumeWhereInput.


        :param id_not: The id_not of this VmVolumeWhereInput.  # noqa: E501
        :type id_not: str
        """

        self._id_not = id_not

    @property
    def id_not_contains(self):
        """Gets the id_not_contains of this VmVolumeWhereInput.  # noqa: E501


        :return: The id_not_contains of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_contains

    @id_not_contains.setter
    def id_not_contains(self, id_not_contains):
        """Sets the id_not_contains of this VmVolumeWhereInput.


        :param id_not_contains: The id_not_contains of this VmVolumeWhereInput.  # noqa: E501
        :type id_not_contains: str
        """

        self._id_not_contains = id_not_contains

    @property
    def id_not_ends_with(self):
        """Gets the id_not_ends_with of this VmVolumeWhereInput.  # noqa: E501


        :return: The id_not_ends_with of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_ends_with

    @id_not_ends_with.setter
    def id_not_ends_with(self, id_not_ends_with):
        """Sets the id_not_ends_with of this VmVolumeWhereInput.


        :param id_not_ends_with: The id_not_ends_with of this VmVolumeWhereInput.  # noqa: E501
        :type id_not_ends_with: str
        """

        self._id_not_ends_with = id_not_ends_with

    @property
    def id_not_in(self):
        """Gets the id_not_in of this VmVolumeWhereInput.  # noqa: E501


        :return: The id_not_in of this VmVolumeWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_not_in

    @id_not_in.setter
    def id_not_in(self, id_not_in):
        """Sets the id_not_in of this VmVolumeWhereInput.


        :param id_not_in: The id_not_in of this VmVolumeWhereInput.  # noqa: E501
        :type id_not_in: list[str]
        """

        self._id_not_in = id_not_in

    @property
    def id_not_starts_with(self):
        """Gets the id_not_starts_with of this VmVolumeWhereInput.  # noqa: E501


        :return: The id_not_starts_with of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_starts_with

    @id_not_starts_with.setter
    def id_not_starts_with(self, id_not_starts_with):
        """Sets the id_not_starts_with of this VmVolumeWhereInput.


        :param id_not_starts_with: The id_not_starts_with of this VmVolumeWhereInput.  # noqa: E501
        :type id_not_starts_with: str
        """

        self._id_not_starts_with = id_not_starts_with

    @property
    def id_starts_with(self):
        """Gets the id_starts_with of this VmVolumeWhereInput.  # noqa: E501


        :return: The id_starts_with of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_starts_with

    @id_starts_with.setter
    def id_starts_with(self, id_starts_with):
        """Sets the id_starts_with of this VmVolumeWhereInput.


        :param id_starts_with: The id_starts_with of this VmVolumeWhereInput.  # noqa: E501
        :type id_starts_with: str
        """

        self._id_starts_with = id_starts_with

    @property
    def labels_every(self):
        """Gets the labels_every of this VmVolumeWhereInput.  # noqa: E501


        :return: The labels_every of this VmVolumeWhereInput.  # noqa: E501
        :rtype: LabelWhereInput
        """
        return self._labels_every

    @labels_every.setter
    def labels_every(self, labels_every):
        """Sets the labels_every of this VmVolumeWhereInput.


        :param labels_every: The labels_every of this VmVolumeWhereInput.  # noqa: E501
        :type labels_every: LabelWhereInput
        """

        self._labels_every = labels_every

    @property
    def labels_none(self):
        """Gets the labels_none of this VmVolumeWhereInput.  # noqa: E501


        :return: The labels_none of this VmVolumeWhereInput.  # noqa: E501
        :rtype: LabelWhereInput
        """
        return self._labels_none

    @labels_none.setter
    def labels_none(self, labels_none):
        """Sets the labels_none of this VmVolumeWhereInput.


        :param labels_none: The labels_none of this VmVolumeWhereInput.  # noqa: E501
        :type labels_none: LabelWhereInput
        """

        self._labels_none = labels_none

    @property
    def labels_some(self):
        """Gets the labels_some of this VmVolumeWhereInput.  # noqa: E501


        :return: The labels_some of this VmVolumeWhereInput.  # noqa: E501
        :rtype: LabelWhereInput
        """
        return self._labels_some

    @labels_some.setter
    def labels_some(self, labels_some):
        """Sets the labels_some of this VmVolumeWhereInput.


        :param labels_some: The labels_some of this VmVolumeWhereInput.  # noqa: E501
        :type labels_some: LabelWhereInput
        """

        self._labels_some = labels_some

    @property
    def local_created_at(self):
        """Gets the local_created_at of this VmVolumeWhereInput.  # noqa: E501


        :return: The local_created_at of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at

    @local_created_at.setter
    def local_created_at(self, local_created_at):
        """Sets the local_created_at of this VmVolumeWhereInput.


        :param local_created_at: The local_created_at of this VmVolumeWhereInput.  # noqa: E501
        :type local_created_at: str
        """

        self._local_created_at = local_created_at

    @property
    def local_created_at_gt(self):
        """Gets the local_created_at_gt of this VmVolumeWhereInput.  # noqa: E501


        :return: The local_created_at_gt of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at_gt

    @local_created_at_gt.setter
    def local_created_at_gt(self, local_created_at_gt):
        """Sets the local_created_at_gt of this VmVolumeWhereInput.


        :param local_created_at_gt: The local_created_at_gt of this VmVolumeWhereInput.  # noqa: E501
        :type local_created_at_gt: str
        """

        self._local_created_at_gt = local_created_at_gt

    @property
    def local_created_at_gte(self):
        """Gets the local_created_at_gte of this VmVolumeWhereInput.  # noqa: E501


        :return: The local_created_at_gte of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at_gte

    @local_created_at_gte.setter
    def local_created_at_gte(self, local_created_at_gte):
        """Sets the local_created_at_gte of this VmVolumeWhereInput.


        :param local_created_at_gte: The local_created_at_gte of this VmVolumeWhereInput.  # noqa: E501
        :type local_created_at_gte: str
        """

        self._local_created_at_gte = local_created_at_gte

    @property
    def local_created_at_in(self):
        """Gets the local_created_at_in of this VmVolumeWhereInput.  # noqa: E501


        :return: The local_created_at_in of this VmVolumeWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_created_at_in

    @local_created_at_in.setter
    def local_created_at_in(self, local_created_at_in):
        """Sets the local_created_at_in of this VmVolumeWhereInput.


        :param local_created_at_in: The local_created_at_in of this VmVolumeWhereInput.  # noqa: E501
        :type local_created_at_in: list[str]
        """

        self._local_created_at_in = local_created_at_in

    @property
    def local_created_at_lt(self):
        """Gets the local_created_at_lt of this VmVolumeWhereInput.  # noqa: E501


        :return: The local_created_at_lt of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at_lt

    @local_created_at_lt.setter
    def local_created_at_lt(self, local_created_at_lt):
        """Sets the local_created_at_lt of this VmVolumeWhereInput.


        :param local_created_at_lt: The local_created_at_lt of this VmVolumeWhereInput.  # noqa: E501
        :type local_created_at_lt: str
        """

        self._local_created_at_lt = local_created_at_lt

    @property
    def local_created_at_lte(self):
        """Gets the local_created_at_lte of this VmVolumeWhereInput.  # noqa: E501


        :return: The local_created_at_lte of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at_lte

    @local_created_at_lte.setter
    def local_created_at_lte(self, local_created_at_lte):
        """Sets the local_created_at_lte of this VmVolumeWhereInput.


        :param local_created_at_lte: The local_created_at_lte of this VmVolumeWhereInput.  # noqa: E501
        :type local_created_at_lte: str
        """

        self._local_created_at_lte = local_created_at_lte

    @property
    def local_created_at_not(self):
        """Gets the local_created_at_not of this VmVolumeWhereInput.  # noqa: E501


        :return: The local_created_at_not of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at_not

    @local_created_at_not.setter
    def local_created_at_not(self, local_created_at_not):
        """Sets the local_created_at_not of this VmVolumeWhereInput.


        :param local_created_at_not: The local_created_at_not of this VmVolumeWhereInput.  # noqa: E501
        :type local_created_at_not: str
        """

        self._local_created_at_not = local_created_at_not

    @property
    def local_created_at_not_in(self):
        """Gets the local_created_at_not_in of this VmVolumeWhereInput.  # noqa: E501


        :return: The local_created_at_not_in of this VmVolumeWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_created_at_not_in

    @local_created_at_not_in.setter
    def local_created_at_not_in(self, local_created_at_not_in):
        """Sets the local_created_at_not_in of this VmVolumeWhereInput.


        :param local_created_at_not_in: The local_created_at_not_in of this VmVolumeWhereInput.  # noqa: E501
        :type local_created_at_not_in: list[str]
        """

        self._local_created_at_not_in = local_created_at_not_in

    @property
    def local_id(self):
        """Gets the local_id of this VmVolumeWhereInput.  # noqa: E501


        :return: The local_id of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id):
        """Sets the local_id of this VmVolumeWhereInput.


        :param local_id: The local_id of this VmVolumeWhereInput.  # noqa: E501
        :type local_id: str
        """

        self._local_id = local_id

    @property
    def local_id_contains(self):
        """Gets the local_id_contains of this VmVolumeWhereInput.  # noqa: E501


        :return: The local_id_contains of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_contains

    @local_id_contains.setter
    def local_id_contains(self, local_id_contains):
        """Sets the local_id_contains of this VmVolumeWhereInput.


        :param local_id_contains: The local_id_contains of this VmVolumeWhereInput.  # noqa: E501
        :type local_id_contains: str
        """

        self._local_id_contains = local_id_contains

    @property
    def local_id_ends_with(self):
        """Gets the local_id_ends_with of this VmVolumeWhereInput.  # noqa: E501


        :return: The local_id_ends_with of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_ends_with

    @local_id_ends_with.setter
    def local_id_ends_with(self, local_id_ends_with):
        """Sets the local_id_ends_with of this VmVolumeWhereInput.


        :param local_id_ends_with: The local_id_ends_with of this VmVolumeWhereInput.  # noqa: E501
        :type local_id_ends_with: str
        """

        self._local_id_ends_with = local_id_ends_with

    @property
    def local_id_gt(self):
        """Gets the local_id_gt of this VmVolumeWhereInput.  # noqa: E501


        :return: The local_id_gt of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_gt

    @local_id_gt.setter
    def local_id_gt(self, local_id_gt):
        """Sets the local_id_gt of this VmVolumeWhereInput.


        :param local_id_gt: The local_id_gt of this VmVolumeWhereInput.  # noqa: E501
        :type local_id_gt: str
        """

        self._local_id_gt = local_id_gt

    @property
    def local_id_gte(self):
        """Gets the local_id_gte of this VmVolumeWhereInput.  # noqa: E501


        :return: The local_id_gte of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_gte

    @local_id_gte.setter
    def local_id_gte(self, local_id_gte):
        """Sets the local_id_gte of this VmVolumeWhereInput.


        :param local_id_gte: The local_id_gte of this VmVolumeWhereInput.  # noqa: E501
        :type local_id_gte: str
        """

        self._local_id_gte = local_id_gte

    @property
    def local_id_in(self):
        """Gets the local_id_in of this VmVolumeWhereInput.  # noqa: E501


        :return: The local_id_in of this VmVolumeWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_id_in

    @local_id_in.setter
    def local_id_in(self, local_id_in):
        """Sets the local_id_in of this VmVolumeWhereInput.


        :param local_id_in: The local_id_in of this VmVolumeWhereInput.  # noqa: E501
        :type local_id_in: list[str]
        """

        self._local_id_in = local_id_in

    @property
    def local_id_lt(self):
        """Gets the local_id_lt of this VmVolumeWhereInput.  # noqa: E501


        :return: The local_id_lt of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_lt

    @local_id_lt.setter
    def local_id_lt(self, local_id_lt):
        """Sets the local_id_lt of this VmVolumeWhereInput.


        :param local_id_lt: The local_id_lt of this VmVolumeWhereInput.  # noqa: E501
        :type local_id_lt: str
        """

        self._local_id_lt = local_id_lt

    @property
    def local_id_lte(self):
        """Gets the local_id_lte of this VmVolumeWhereInput.  # noqa: E501


        :return: The local_id_lte of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_lte

    @local_id_lte.setter
    def local_id_lte(self, local_id_lte):
        """Sets the local_id_lte of this VmVolumeWhereInput.


        :param local_id_lte: The local_id_lte of this VmVolumeWhereInput.  # noqa: E501
        :type local_id_lte: str
        """

        self._local_id_lte = local_id_lte

    @property
    def local_id_not(self):
        """Gets the local_id_not of this VmVolumeWhereInput.  # noqa: E501


        :return: The local_id_not of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not

    @local_id_not.setter
    def local_id_not(self, local_id_not):
        """Sets the local_id_not of this VmVolumeWhereInput.


        :param local_id_not: The local_id_not of this VmVolumeWhereInput.  # noqa: E501
        :type local_id_not: str
        """

        self._local_id_not = local_id_not

    @property
    def local_id_not_contains(self):
        """Gets the local_id_not_contains of this VmVolumeWhereInput.  # noqa: E501


        :return: The local_id_not_contains of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_contains

    @local_id_not_contains.setter
    def local_id_not_contains(self, local_id_not_contains):
        """Sets the local_id_not_contains of this VmVolumeWhereInput.


        :param local_id_not_contains: The local_id_not_contains of this VmVolumeWhereInput.  # noqa: E501
        :type local_id_not_contains: str
        """

        self._local_id_not_contains = local_id_not_contains

    @property
    def local_id_not_ends_with(self):
        """Gets the local_id_not_ends_with of this VmVolumeWhereInput.  # noqa: E501


        :return: The local_id_not_ends_with of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_ends_with

    @local_id_not_ends_with.setter
    def local_id_not_ends_with(self, local_id_not_ends_with):
        """Sets the local_id_not_ends_with of this VmVolumeWhereInput.


        :param local_id_not_ends_with: The local_id_not_ends_with of this VmVolumeWhereInput.  # noqa: E501
        :type local_id_not_ends_with: str
        """

        self._local_id_not_ends_with = local_id_not_ends_with

    @property
    def local_id_not_in(self):
        """Gets the local_id_not_in of this VmVolumeWhereInput.  # noqa: E501


        :return: The local_id_not_in of this VmVolumeWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_id_not_in

    @local_id_not_in.setter
    def local_id_not_in(self, local_id_not_in):
        """Sets the local_id_not_in of this VmVolumeWhereInput.


        :param local_id_not_in: The local_id_not_in of this VmVolumeWhereInput.  # noqa: E501
        :type local_id_not_in: list[str]
        """

        self._local_id_not_in = local_id_not_in

    @property
    def local_id_not_starts_with(self):
        """Gets the local_id_not_starts_with of this VmVolumeWhereInput.  # noqa: E501


        :return: The local_id_not_starts_with of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_starts_with

    @local_id_not_starts_with.setter
    def local_id_not_starts_with(self, local_id_not_starts_with):
        """Sets the local_id_not_starts_with of this VmVolumeWhereInput.


        :param local_id_not_starts_with: The local_id_not_starts_with of this VmVolumeWhereInput.  # noqa: E501
        :type local_id_not_starts_with: str
        """

        self._local_id_not_starts_with = local_id_not_starts_with

    @property
    def local_id_starts_with(self):
        """Gets the local_id_starts_with of this VmVolumeWhereInput.  # noqa: E501


        :return: The local_id_starts_with of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_starts_with

    @local_id_starts_with.setter
    def local_id_starts_with(self, local_id_starts_with):
        """Sets the local_id_starts_with of this VmVolumeWhereInput.


        :param local_id_starts_with: The local_id_starts_with of this VmVolumeWhereInput.  # noqa: E501
        :type local_id_starts_with: str
        """

        self._local_id_starts_with = local_id_starts_with

    @property
    def lun(self):
        """Gets the lun of this VmVolumeWhereInput.  # noqa: E501


        :return: The lun of this VmVolumeWhereInput.  # noqa: E501
        :rtype: IscsiLunWhereInput
        """
        return self._lun

    @lun.setter
    def lun(self, lun):
        """Sets the lun of this VmVolumeWhereInput.


        :param lun: The lun of this VmVolumeWhereInput.  # noqa: E501
        :type lun: IscsiLunWhereInput
        """

        self._lun = lun

    @property
    def mounting(self):
        """Gets the mounting of this VmVolumeWhereInput.  # noqa: E501


        :return: The mounting of this VmVolumeWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._mounting

    @mounting.setter
    def mounting(self, mounting):
        """Sets the mounting of this VmVolumeWhereInput.


        :param mounting: The mounting of this VmVolumeWhereInput.  # noqa: E501
        :type mounting: bool
        """

        self._mounting = mounting

    @property
    def mounting_not(self):
        """Gets the mounting_not of this VmVolumeWhereInput.  # noqa: E501


        :return: The mounting_not of this VmVolumeWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._mounting_not

    @mounting_not.setter
    def mounting_not(self, mounting_not):
        """Sets the mounting_not of this VmVolumeWhereInput.


        :param mounting_not: The mounting_not of this VmVolumeWhereInput.  # noqa: E501
        :type mounting_not: bool
        """

        self._mounting_not = mounting_not

    @property
    def name(self):
        """Gets the name of this VmVolumeWhereInput.  # noqa: E501


        :return: The name of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this VmVolumeWhereInput.


        :param name: The name of this VmVolumeWhereInput.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def name_contains(self):
        """Gets the name_contains of this VmVolumeWhereInput.  # noqa: E501


        :return: The name_contains of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_contains

    @name_contains.setter
    def name_contains(self, name_contains):
        """Sets the name_contains of this VmVolumeWhereInput.


        :param name_contains: The name_contains of this VmVolumeWhereInput.  # noqa: E501
        :type name_contains: str
        """

        self._name_contains = name_contains

    @property
    def name_ends_with(self):
        """Gets the name_ends_with of this VmVolumeWhereInput.  # noqa: E501


        :return: The name_ends_with of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_ends_with

    @name_ends_with.setter
    def name_ends_with(self, name_ends_with):
        """Sets the name_ends_with of this VmVolumeWhereInput.


        :param name_ends_with: The name_ends_with of this VmVolumeWhereInput.  # noqa: E501
        :type name_ends_with: str
        """

        self._name_ends_with = name_ends_with

    @property
    def name_gt(self):
        """Gets the name_gt of this VmVolumeWhereInput.  # noqa: E501


        :return: The name_gt of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_gt

    @name_gt.setter
    def name_gt(self, name_gt):
        """Sets the name_gt of this VmVolumeWhereInput.


        :param name_gt: The name_gt of this VmVolumeWhereInput.  # noqa: E501
        :type name_gt: str
        """

        self._name_gt = name_gt

    @property
    def name_gte(self):
        """Gets the name_gte of this VmVolumeWhereInput.  # noqa: E501


        :return: The name_gte of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_gte

    @name_gte.setter
    def name_gte(self, name_gte):
        """Sets the name_gte of this VmVolumeWhereInput.


        :param name_gte: The name_gte of this VmVolumeWhereInput.  # noqa: E501
        :type name_gte: str
        """

        self._name_gte = name_gte

    @property
    def name_in(self):
        """Gets the name_in of this VmVolumeWhereInput.  # noqa: E501


        :return: The name_in of this VmVolumeWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._name_in

    @name_in.setter
    def name_in(self, name_in):
        """Sets the name_in of this VmVolumeWhereInput.


        :param name_in: The name_in of this VmVolumeWhereInput.  # noqa: E501
        :type name_in: list[str]
        """

        self._name_in = name_in

    @property
    def name_lt(self):
        """Gets the name_lt of this VmVolumeWhereInput.  # noqa: E501


        :return: The name_lt of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_lt

    @name_lt.setter
    def name_lt(self, name_lt):
        """Sets the name_lt of this VmVolumeWhereInput.


        :param name_lt: The name_lt of this VmVolumeWhereInput.  # noqa: E501
        :type name_lt: str
        """

        self._name_lt = name_lt

    @property
    def name_lte(self):
        """Gets the name_lte of this VmVolumeWhereInput.  # noqa: E501


        :return: The name_lte of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_lte

    @name_lte.setter
    def name_lte(self, name_lte):
        """Sets the name_lte of this VmVolumeWhereInput.


        :param name_lte: The name_lte of this VmVolumeWhereInput.  # noqa: E501
        :type name_lte: str
        """

        self._name_lte = name_lte

    @property
    def name_not(self):
        """Gets the name_not of this VmVolumeWhereInput.  # noqa: E501


        :return: The name_not of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not

    @name_not.setter
    def name_not(self, name_not):
        """Sets the name_not of this VmVolumeWhereInput.


        :param name_not: The name_not of this VmVolumeWhereInput.  # noqa: E501
        :type name_not: str
        """

        self._name_not = name_not

    @property
    def name_not_contains(self):
        """Gets the name_not_contains of this VmVolumeWhereInput.  # noqa: E501


        :return: The name_not_contains of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_contains

    @name_not_contains.setter
    def name_not_contains(self, name_not_contains):
        """Sets the name_not_contains of this VmVolumeWhereInput.


        :param name_not_contains: The name_not_contains of this VmVolumeWhereInput.  # noqa: E501
        :type name_not_contains: str
        """

        self._name_not_contains = name_not_contains

    @property
    def name_not_ends_with(self):
        """Gets the name_not_ends_with of this VmVolumeWhereInput.  # noqa: E501


        :return: The name_not_ends_with of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_ends_with

    @name_not_ends_with.setter
    def name_not_ends_with(self, name_not_ends_with):
        """Sets the name_not_ends_with of this VmVolumeWhereInput.


        :param name_not_ends_with: The name_not_ends_with of this VmVolumeWhereInput.  # noqa: E501
        :type name_not_ends_with: str
        """

        self._name_not_ends_with = name_not_ends_with

    @property
    def name_not_in(self):
        """Gets the name_not_in of this VmVolumeWhereInput.  # noqa: E501


        :return: The name_not_in of this VmVolumeWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._name_not_in

    @name_not_in.setter
    def name_not_in(self, name_not_in):
        """Sets the name_not_in of this VmVolumeWhereInput.


        :param name_not_in: The name_not_in of this VmVolumeWhereInput.  # noqa: E501
        :type name_not_in: list[str]
        """

        self._name_not_in = name_not_in

    @property
    def name_not_starts_with(self):
        """Gets the name_not_starts_with of this VmVolumeWhereInput.  # noqa: E501


        :return: The name_not_starts_with of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_starts_with

    @name_not_starts_with.setter
    def name_not_starts_with(self, name_not_starts_with):
        """Sets the name_not_starts_with of this VmVolumeWhereInput.


        :param name_not_starts_with: The name_not_starts_with of this VmVolumeWhereInput.  # noqa: E501
        :type name_not_starts_with: str
        """

        self._name_not_starts_with = name_not_starts_with

    @property
    def name_starts_with(self):
        """Gets the name_starts_with of this VmVolumeWhereInput.  # noqa: E501


        :return: The name_starts_with of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_starts_with

    @name_starts_with.setter
    def name_starts_with(self, name_starts_with):
        """Sets the name_starts_with of this VmVolumeWhereInput.


        :param name_starts_with: The name_starts_with of this VmVolumeWhereInput.  # noqa: E501
        :type name_starts_with: str
        """

        self._name_starts_with = name_starts_with

    @property
    def path(self):
        """Gets the path of this VmVolumeWhereInput.  # noqa: E501


        :return: The path of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._path

    @path.setter
    def path(self, path):
        """Sets the path of this VmVolumeWhereInput.


        :param path: The path of this VmVolumeWhereInput.  # noqa: E501
        :type path: str
        """

        self._path = path

    @property
    def path_contains(self):
        """Gets the path_contains of this VmVolumeWhereInput.  # noqa: E501


        :return: The path_contains of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._path_contains

    @path_contains.setter
    def path_contains(self, path_contains):
        """Sets the path_contains of this VmVolumeWhereInput.


        :param path_contains: The path_contains of this VmVolumeWhereInput.  # noqa: E501
        :type path_contains: str
        """

        self._path_contains = path_contains

    @property
    def path_ends_with(self):
        """Gets the path_ends_with of this VmVolumeWhereInput.  # noqa: E501


        :return: The path_ends_with of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._path_ends_with

    @path_ends_with.setter
    def path_ends_with(self, path_ends_with):
        """Sets the path_ends_with of this VmVolumeWhereInput.


        :param path_ends_with: The path_ends_with of this VmVolumeWhereInput.  # noqa: E501
        :type path_ends_with: str
        """

        self._path_ends_with = path_ends_with

    @property
    def path_gt(self):
        """Gets the path_gt of this VmVolumeWhereInput.  # noqa: E501


        :return: The path_gt of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._path_gt

    @path_gt.setter
    def path_gt(self, path_gt):
        """Sets the path_gt of this VmVolumeWhereInput.


        :param path_gt: The path_gt of this VmVolumeWhereInput.  # noqa: E501
        :type path_gt: str
        """

        self._path_gt = path_gt

    @property
    def path_gte(self):
        """Gets the path_gte of this VmVolumeWhereInput.  # noqa: E501


        :return: The path_gte of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._path_gte

    @path_gte.setter
    def path_gte(self, path_gte):
        """Sets the path_gte of this VmVolumeWhereInput.


        :param path_gte: The path_gte of this VmVolumeWhereInput.  # noqa: E501
        :type path_gte: str
        """

        self._path_gte = path_gte

    @property
    def path_in(self):
        """Gets the path_in of this VmVolumeWhereInput.  # noqa: E501


        :return: The path_in of this VmVolumeWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._path_in

    @path_in.setter
    def path_in(self, path_in):
        """Sets the path_in of this VmVolumeWhereInput.


        :param path_in: The path_in of this VmVolumeWhereInput.  # noqa: E501
        :type path_in: list[str]
        """

        self._path_in = path_in

    @property
    def path_lt(self):
        """Gets the path_lt of this VmVolumeWhereInput.  # noqa: E501


        :return: The path_lt of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._path_lt

    @path_lt.setter
    def path_lt(self, path_lt):
        """Sets the path_lt of this VmVolumeWhereInput.


        :param path_lt: The path_lt of this VmVolumeWhereInput.  # noqa: E501
        :type path_lt: str
        """

        self._path_lt = path_lt

    @property
    def path_lte(self):
        """Gets the path_lte of this VmVolumeWhereInput.  # noqa: E501


        :return: The path_lte of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._path_lte

    @path_lte.setter
    def path_lte(self, path_lte):
        """Sets the path_lte of this VmVolumeWhereInput.


        :param path_lte: The path_lte of this VmVolumeWhereInput.  # noqa: E501
        :type path_lte: str
        """

        self._path_lte = path_lte

    @property
    def path_not(self):
        """Gets the path_not of this VmVolumeWhereInput.  # noqa: E501


        :return: The path_not of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._path_not

    @path_not.setter
    def path_not(self, path_not):
        """Sets the path_not of this VmVolumeWhereInput.


        :param path_not: The path_not of this VmVolumeWhereInput.  # noqa: E501
        :type path_not: str
        """

        self._path_not = path_not

    @property
    def path_not_contains(self):
        """Gets the path_not_contains of this VmVolumeWhereInput.  # noqa: E501


        :return: The path_not_contains of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._path_not_contains

    @path_not_contains.setter
    def path_not_contains(self, path_not_contains):
        """Sets the path_not_contains of this VmVolumeWhereInput.


        :param path_not_contains: The path_not_contains of this VmVolumeWhereInput.  # noqa: E501
        :type path_not_contains: str
        """

        self._path_not_contains = path_not_contains

    @property
    def path_not_ends_with(self):
        """Gets the path_not_ends_with of this VmVolumeWhereInput.  # noqa: E501


        :return: The path_not_ends_with of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._path_not_ends_with

    @path_not_ends_with.setter
    def path_not_ends_with(self, path_not_ends_with):
        """Sets the path_not_ends_with of this VmVolumeWhereInput.


        :param path_not_ends_with: The path_not_ends_with of this VmVolumeWhereInput.  # noqa: E501
        :type path_not_ends_with: str
        """

        self._path_not_ends_with = path_not_ends_with

    @property
    def path_not_in(self):
        """Gets the path_not_in of this VmVolumeWhereInput.  # noqa: E501


        :return: The path_not_in of this VmVolumeWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._path_not_in

    @path_not_in.setter
    def path_not_in(self, path_not_in):
        """Sets the path_not_in of this VmVolumeWhereInput.


        :param path_not_in: The path_not_in of this VmVolumeWhereInput.  # noqa: E501
        :type path_not_in: list[str]
        """

        self._path_not_in = path_not_in

    @property
    def path_not_starts_with(self):
        """Gets the path_not_starts_with of this VmVolumeWhereInput.  # noqa: E501


        :return: The path_not_starts_with of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._path_not_starts_with

    @path_not_starts_with.setter
    def path_not_starts_with(self, path_not_starts_with):
        """Sets the path_not_starts_with of this VmVolumeWhereInput.


        :param path_not_starts_with: The path_not_starts_with of this VmVolumeWhereInput.  # noqa: E501
        :type path_not_starts_with: str
        """

        self._path_not_starts_with = path_not_starts_with

    @property
    def path_starts_with(self):
        """Gets the path_starts_with of this VmVolumeWhereInput.  # noqa: E501


        :return: The path_starts_with of this VmVolumeWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._path_starts_with

    @path_starts_with.setter
    def path_starts_with(self, path_starts_with):
        """Sets the path_starts_with of this VmVolumeWhereInput.


        :param path_starts_with: The path_starts_with of this VmVolumeWhereInput.  # noqa: E501
        :type path_starts_with: str
        """

        self._path_starts_with = path_starts_with

    @property
    def resident_in_cache(self):
        """Gets the resident_in_cache of this VmVolumeWhereInput.  # noqa: E501


        :return: The resident_in_cache of this VmVolumeWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._resident_in_cache

    @resident_in_cache.setter
    def resident_in_cache(self, resident_in_cache):
        """Sets the resident_in_cache of this VmVolumeWhereInput.


        :param resident_in_cache: The resident_in_cache of this VmVolumeWhereInput.  # noqa: E501
        :type resident_in_cache: bool
        """

        self._resident_in_cache = resident_in_cache

    @property
    def resident_in_cache_not(self):
        """Gets the resident_in_cache_not of this VmVolumeWhereInput.  # noqa: E501


        :return: The resident_in_cache_not of this VmVolumeWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._resident_in_cache_not

    @resident_in_cache_not.setter
    def resident_in_cache_not(self, resident_in_cache_not):
        """Sets the resident_in_cache_not of this VmVolumeWhereInput.


        :param resident_in_cache_not: The resident_in_cache_not of this VmVolumeWhereInput.  # noqa: E501
        :type resident_in_cache_not: bool
        """

        self._resident_in_cache_not = resident_in_cache_not

    @property
    def sharing(self):
        """Gets the sharing of this VmVolumeWhereInput.  # noqa: E501


        :return: The sharing of this VmVolumeWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._sharing

    @sharing.setter
    def sharing(self, sharing):
        """Sets the sharing of this VmVolumeWhereInput.


        :param sharing: The sharing of this VmVolumeWhereInput.  # noqa: E501
        :type sharing: bool
        """

        self._sharing = sharing

    @property
    def sharing_not(self):
        """Gets the sharing_not of this VmVolumeWhereInput.  # noqa: E501


        :return: The sharing_not of this VmVolumeWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._sharing_not

    @sharing_not.setter
    def sharing_not(self, sharing_not):
        """Sets the sharing_not of this VmVolumeWhereInput.


        :param sharing_not: The sharing_not of this VmVolumeWhereInput.  # noqa: E501
        :type sharing_not: bool
        """

        self._sharing_not = sharing_not

    @property
    def size(self):
        """Gets the size of this VmVolumeWhereInput.  # noqa: E501


        :return: The size of this VmVolumeWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size):
        """Sets the size of this VmVolumeWhereInput.


        :param size: The size of this VmVolumeWhereInput.  # noqa: E501
        :type size: int
        """

        self._size = size

    @property
    def size_gt(self):
        """Gets the size_gt of this VmVolumeWhereInput.  # noqa: E501


        :return: The size_gt of this VmVolumeWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._size_gt

    @size_gt.setter
    def size_gt(self, size_gt):
        """Sets the size_gt of this VmVolumeWhereInput.


        :param size_gt: The size_gt of this VmVolumeWhereInput.  # noqa: E501
        :type size_gt: int
        """

        self._size_gt = size_gt

    @property
    def size_gte(self):
        """Gets the size_gte of this VmVolumeWhereInput.  # noqa: E501


        :return: The size_gte of this VmVolumeWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._size_gte

    @size_gte.setter
    def size_gte(self, size_gte):
        """Sets the size_gte of this VmVolumeWhereInput.


        :param size_gte: The size_gte of this VmVolumeWhereInput.  # noqa: E501
        :type size_gte: int
        """

        self._size_gte = size_gte

    @property
    def size_in(self):
        """Gets the size_in of this VmVolumeWhereInput.  # noqa: E501


        :return: The size_in of this VmVolumeWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._size_in

    @size_in.setter
    def size_in(self, size_in):
        """Sets the size_in of this VmVolumeWhereInput.


        :param size_in: The size_in of this VmVolumeWhereInput.  # noqa: E501
        :type size_in: list[int]
        """

        self._size_in = size_in

    @property
    def size_lt(self):
        """Gets the size_lt of this VmVolumeWhereInput.  # noqa: E501


        :return: The size_lt of this VmVolumeWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._size_lt

    @size_lt.setter
    def size_lt(self, size_lt):
        """Sets the size_lt of this VmVolumeWhereInput.


        :param size_lt: The size_lt of this VmVolumeWhereInput.  # noqa: E501
        :type size_lt: int
        """

        self._size_lt = size_lt

    @property
    def size_lte(self):
        """Gets the size_lte of this VmVolumeWhereInput.  # noqa: E501


        :return: The size_lte of this VmVolumeWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._size_lte

    @size_lte.setter
    def size_lte(self, size_lte):
        """Sets the size_lte of this VmVolumeWhereInput.


        :param size_lte: The size_lte of this VmVolumeWhereInput.  # noqa: E501
        :type size_lte: int
        """

        self._size_lte = size_lte

    @property
    def size_not(self):
        """Gets the size_not of this VmVolumeWhereInput.  # noqa: E501


        :return: The size_not of this VmVolumeWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._size_not

    @size_not.setter
    def size_not(self, size_not):
        """Sets the size_not of this VmVolumeWhereInput.


        :param size_not: The size_not of this VmVolumeWhereInput.  # noqa: E501
        :type size_not: int
        """

        self._size_not = size_not

    @property
    def size_not_in(self):
        """Gets the size_not_in of this VmVolumeWhereInput.  # noqa: E501


        :return: The size_not_in of this VmVolumeWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._size_not_in

    @size_not_in.setter
    def size_not_in(self, size_not_in):
        """Sets the size_not_in of this VmVolumeWhereInput.


        :param size_not_in: The size_not_in of this VmVolumeWhereInput.  # noqa: E501
        :type size_not_in: list[int]
        """

        self._size_not_in = size_not_in

    @property
    def type(self):
        """Gets the type of this VmVolumeWhereInput.  # noqa: E501


        :return: The type of this VmVolumeWhereInput.  # noqa: E501
        :rtype: VmVolumeType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this VmVolumeWhereInput.


        :param type: The type of this VmVolumeWhereInput.  # noqa: E501
        :type type: VmVolumeType
        """

        self._type = type

    @property
    def type_in(self):
        """Gets the type_in of this VmVolumeWhereInput.  # noqa: E501


        :return: The type_in of this VmVolumeWhereInput.  # noqa: E501
        :rtype: list[VmVolumeType]
        """
        return self._type_in

    @type_in.setter
    def type_in(self, type_in):
        """Sets the type_in of this VmVolumeWhereInput.


        :param type_in: The type_in of this VmVolumeWhereInput.  # noqa: E501
        :type type_in: list[VmVolumeType]
        """

        self._type_in = type_in

    @property
    def type_not(self):
        """Gets the type_not of this VmVolumeWhereInput.  # noqa: E501


        :return: The type_not of this VmVolumeWhereInput.  # noqa: E501
        :rtype: VmVolumeType
        """
        return self._type_not

    @type_not.setter
    def type_not(self, type_not):
        """Sets the type_not of this VmVolumeWhereInput.


        :param type_not: The type_not of this VmVolumeWhereInput.  # noqa: E501
        :type type_not: VmVolumeType
        """

        self._type_not = type_not

    @property
    def type_not_in(self):
        """Gets the type_not_in of this VmVolumeWhereInput.  # noqa: E501


        :return: The type_not_in of this VmVolumeWhereInput.  # noqa: E501
        :rtype: list[VmVolumeType]
        """
        return self._type_not_in

    @type_not_in.setter
    def type_not_in(self, type_not_in):
        """Sets the type_not_in of this VmVolumeWhereInput.


        :param type_not_in: The type_not_in of this VmVolumeWhereInput.  # noqa: E501
        :type type_not_in: list[VmVolumeType]
        """

        self._type_not_in = type_not_in

    @property
    def unique_logical_size(self):
        """Gets the unique_logical_size of this VmVolumeWhereInput.  # noqa: E501


        :return: The unique_logical_size of this VmVolumeWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._unique_logical_size

    @unique_logical_size.setter
    def unique_logical_size(self, unique_logical_size):
        """Sets the unique_logical_size of this VmVolumeWhereInput.


        :param unique_logical_size: The unique_logical_size of this VmVolumeWhereInput.  # noqa: E501
        :type unique_logical_size: float
        """

        self._unique_logical_size = unique_logical_size

    @property
    def unique_logical_size_gt(self):
        """Gets the unique_logical_size_gt of this VmVolumeWhereInput.  # noqa: E501


        :return: The unique_logical_size_gt of this VmVolumeWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._unique_logical_size_gt

    @unique_logical_size_gt.setter
    def unique_logical_size_gt(self, unique_logical_size_gt):
        """Sets the unique_logical_size_gt of this VmVolumeWhereInput.


        :param unique_logical_size_gt: The unique_logical_size_gt of this VmVolumeWhereInput.  # noqa: E501
        :type unique_logical_size_gt: float
        """

        self._unique_logical_size_gt = unique_logical_size_gt

    @property
    def unique_logical_size_gte(self):
        """Gets the unique_logical_size_gte of this VmVolumeWhereInput.  # noqa: E501


        :return: The unique_logical_size_gte of this VmVolumeWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._unique_logical_size_gte

    @unique_logical_size_gte.setter
    def unique_logical_size_gte(self, unique_logical_size_gte):
        """Sets the unique_logical_size_gte of this VmVolumeWhereInput.


        :param unique_logical_size_gte: The unique_logical_size_gte of this VmVolumeWhereInput.  # noqa: E501
        :type unique_logical_size_gte: float
        """

        self._unique_logical_size_gte = unique_logical_size_gte

    @property
    def unique_logical_size_in(self):
        """Gets the unique_logical_size_in of this VmVolumeWhereInput.  # noqa: E501


        :return: The unique_logical_size_in of this VmVolumeWhereInput.  # noqa: E501
        :rtype: list[float]
        """
        return self._unique_logical_size_in

    @unique_logical_size_in.setter
    def unique_logical_size_in(self, unique_logical_size_in):
        """Sets the unique_logical_size_in of this VmVolumeWhereInput.


        :param unique_logical_size_in: The unique_logical_size_in of this VmVolumeWhereInput.  # noqa: E501
        :type unique_logical_size_in: list[float]
        """

        self._unique_logical_size_in = unique_logical_size_in

    @property
    def unique_logical_size_lt(self):
        """Gets the unique_logical_size_lt of this VmVolumeWhereInput.  # noqa: E501


        :return: The unique_logical_size_lt of this VmVolumeWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._unique_logical_size_lt

    @unique_logical_size_lt.setter
    def unique_logical_size_lt(self, unique_logical_size_lt):
        """Sets the unique_logical_size_lt of this VmVolumeWhereInput.


        :param unique_logical_size_lt: The unique_logical_size_lt of this VmVolumeWhereInput.  # noqa: E501
        :type unique_logical_size_lt: float
        """

        self._unique_logical_size_lt = unique_logical_size_lt

    @property
    def unique_logical_size_lte(self):
        """Gets the unique_logical_size_lte of this VmVolumeWhereInput.  # noqa: E501


        :return: The unique_logical_size_lte of this VmVolumeWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._unique_logical_size_lte

    @unique_logical_size_lte.setter
    def unique_logical_size_lte(self, unique_logical_size_lte):
        """Sets the unique_logical_size_lte of this VmVolumeWhereInput.


        :param unique_logical_size_lte: The unique_logical_size_lte of this VmVolumeWhereInput.  # noqa: E501
        :type unique_logical_size_lte: float
        """

        self._unique_logical_size_lte = unique_logical_size_lte

    @property
    def unique_logical_size_not(self):
        """Gets the unique_logical_size_not of this VmVolumeWhereInput.  # noqa: E501


        :return: The unique_logical_size_not of this VmVolumeWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._unique_logical_size_not

    @unique_logical_size_not.setter
    def unique_logical_size_not(self, unique_logical_size_not):
        """Sets the unique_logical_size_not of this VmVolumeWhereInput.


        :param unique_logical_size_not: The unique_logical_size_not of this VmVolumeWhereInput.  # noqa: E501
        :type unique_logical_size_not: float
        """

        self._unique_logical_size_not = unique_logical_size_not

    @property
    def unique_logical_size_not_in(self):
        """Gets the unique_logical_size_not_in of this VmVolumeWhereInput.  # noqa: E501


        :return: The unique_logical_size_not_in of this VmVolumeWhereInput.  # noqa: E501
        :rtype: list[float]
        """
        return self._unique_logical_size_not_in

    @unique_logical_size_not_in.setter
    def unique_logical_size_not_in(self, unique_logical_size_not_in):
        """Sets the unique_logical_size_not_in of this VmVolumeWhereInput.


        :param unique_logical_size_not_in: The unique_logical_size_not_in of this VmVolumeWhereInput.  # noqa: E501
        :type unique_logical_size_not_in: list[float]
        """

        self._unique_logical_size_not_in = unique_logical_size_not_in

    @property
    def unique_size(self):
        """Gets the unique_size of this VmVolumeWhereInput.  # noqa: E501


        :return: The unique_size of this VmVolumeWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._unique_size

    @unique_size.setter
    def unique_size(self, unique_size):
        """Sets the unique_size of this VmVolumeWhereInput.


        :param unique_size: The unique_size of this VmVolumeWhereInput.  # noqa: E501
        :type unique_size: int
        """

        self._unique_size = unique_size

    @property
    def unique_size_gt(self):
        """Gets the unique_size_gt of this VmVolumeWhereInput.  # noqa: E501


        :return: The unique_size_gt of this VmVolumeWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._unique_size_gt

    @unique_size_gt.setter
    def unique_size_gt(self, unique_size_gt):
        """Sets the unique_size_gt of this VmVolumeWhereInput.


        :param unique_size_gt: The unique_size_gt of this VmVolumeWhereInput.  # noqa: E501
        :type unique_size_gt: int
        """

        self._unique_size_gt = unique_size_gt

    @property
    def unique_size_gte(self):
        """Gets the unique_size_gte of this VmVolumeWhereInput.  # noqa: E501


        :return: The unique_size_gte of this VmVolumeWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._unique_size_gte

    @unique_size_gte.setter
    def unique_size_gte(self, unique_size_gte):
        """Sets the unique_size_gte of this VmVolumeWhereInput.


        :param unique_size_gte: The unique_size_gte of this VmVolumeWhereInput.  # noqa: E501
        :type unique_size_gte: int
        """

        self._unique_size_gte = unique_size_gte

    @property
    def unique_size_in(self):
        """Gets the unique_size_in of this VmVolumeWhereInput.  # noqa: E501


        :return: The unique_size_in of this VmVolumeWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._unique_size_in

    @unique_size_in.setter
    def unique_size_in(self, unique_size_in):
        """Sets the unique_size_in of this VmVolumeWhereInput.


        :param unique_size_in: The unique_size_in of this VmVolumeWhereInput.  # noqa: E501
        :type unique_size_in: list[int]
        """

        self._unique_size_in = unique_size_in

    @property
    def unique_size_lt(self):
        """Gets the unique_size_lt of this VmVolumeWhereInput.  # noqa: E501


        :return: The unique_size_lt of this VmVolumeWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._unique_size_lt

    @unique_size_lt.setter
    def unique_size_lt(self, unique_size_lt):
        """Sets the unique_size_lt of this VmVolumeWhereInput.


        :param unique_size_lt: The unique_size_lt of this VmVolumeWhereInput.  # noqa: E501
        :type unique_size_lt: int
        """

        self._unique_size_lt = unique_size_lt

    @property
    def unique_size_lte(self):
        """Gets the unique_size_lte of this VmVolumeWhereInput.  # noqa: E501


        :return: The unique_size_lte of this VmVolumeWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._unique_size_lte

    @unique_size_lte.setter
    def unique_size_lte(self, unique_size_lte):
        """Sets the unique_size_lte of this VmVolumeWhereInput.


        :param unique_size_lte: The unique_size_lte of this VmVolumeWhereInput.  # noqa: E501
        :type unique_size_lte: int
        """

        self._unique_size_lte = unique_size_lte

    @property
    def unique_size_not(self):
        """Gets the unique_size_not of this VmVolumeWhereInput.  # noqa: E501


        :return: The unique_size_not of this VmVolumeWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._unique_size_not

    @unique_size_not.setter
    def unique_size_not(self, unique_size_not):
        """Sets the unique_size_not of this VmVolumeWhereInput.


        :param unique_size_not: The unique_size_not of this VmVolumeWhereInput.  # noqa: E501
        :type unique_size_not: int
        """

        self._unique_size_not = unique_size_not

    @property
    def unique_size_not_in(self):
        """Gets the unique_size_not_in of this VmVolumeWhereInput.  # noqa: E501


        :return: The unique_size_not_in of this VmVolumeWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._unique_size_not_in

    @unique_size_not_in.setter
    def unique_size_not_in(self, unique_size_not_in):
        """Sets the unique_size_not_in of this VmVolumeWhereInput.


        :param unique_size_not_in: The unique_size_not_in of this VmVolumeWhereInput.  # noqa: E501
        :type unique_size_not_in: list[int]
        """

        self._unique_size_not_in = unique_size_not_in

    @property
    def used_size(self):
        """Gets the used_size of this VmVolumeWhereInput.  # noqa: E501


        :return: The used_size of this VmVolumeWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._used_size

    @used_size.setter
    def used_size(self, used_size):
        """Sets the used_size of this VmVolumeWhereInput.


        :param used_size: The used_size of this VmVolumeWhereInput.  # noqa: E501
        :type used_size: int
        """

        self._used_size = used_size

    @property
    def used_size_gt(self):
        """Gets the used_size_gt of this VmVolumeWhereInput.  # noqa: E501


        :return: The used_size_gt of this VmVolumeWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._used_size_gt

    @used_size_gt.setter
    def used_size_gt(self, used_size_gt):
        """Sets the used_size_gt of this VmVolumeWhereInput.


        :param used_size_gt: The used_size_gt of this VmVolumeWhereInput.  # noqa: E501
        :type used_size_gt: int
        """

        self._used_size_gt = used_size_gt

    @property
    def used_size_gte(self):
        """Gets the used_size_gte of this VmVolumeWhereInput.  # noqa: E501


        :return: The used_size_gte of this VmVolumeWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._used_size_gte

    @used_size_gte.setter
    def used_size_gte(self, used_size_gte):
        """Sets the used_size_gte of this VmVolumeWhereInput.


        :param used_size_gte: The used_size_gte of this VmVolumeWhereInput.  # noqa: E501
        :type used_size_gte: int
        """

        self._used_size_gte = used_size_gte

    @property
    def used_size_in(self):
        """Gets the used_size_in of this VmVolumeWhereInput.  # noqa: E501


        :return: The used_size_in of this VmVolumeWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._used_size_in

    @used_size_in.setter
    def used_size_in(self, used_size_in):
        """Sets the used_size_in of this VmVolumeWhereInput.


        :param used_size_in: The used_size_in of this VmVolumeWhereInput.  # noqa: E501
        :type used_size_in: list[int]
        """

        self._used_size_in = used_size_in

    @property
    def used_size_lt(self):
        """Gets the used_size_lt of this VmVolumeWhereInput.  # noqa: E501


        :return: The used_size_lt of this VmVolumeWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._used_size_lt

    @used_size_lt.setter
    def used_size_lt(self, used_size_lt):
        """Sets the used_size_lt of this VmVolumeWhereInput.


        :param used_size_lt: The used_size_lt of this VmVolumeWhereInput.  # noqa: E501
        :type used_size_lt: int
        """

        self._used_size_lt = used_size_lt

    @property
    def used_size_lte(self):
        """Gets the used_size_lte of this VmVolumeWhereInput.  # noqa: E501


        :return: The used_size_lte of this VmVolumeWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._used_size_lte

    @used_size_lte.setter
    def used_size_lte(self, used_size_lte):
        """Sets the used_size_lte of this VmVolumeWhereInput.


        :param used_size_lte: The used_size_lte of this VmVolumeWhereInput.  # noqa: E501
        :type used_size_lte: int
        """

        self._used_size_lte = used_size_lte

    @property
    def used_size_not(self):
        """Gets the used_size_not of this VmVolumeWhereInput.  # noqa: E501


        :return: The used_size_not of this VmVolumeWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._used_size_not

    @used_size_not.setter
    def used_size_not(self, used_size_not):
        """Sets the used_size_not of this VmVolumeWhereInput.


        :param used_size_not: The used_size_not of this VmVolumeWhereInput.  # noqa: E501
        :type used_size_not: int
        """

        self._used_size_not = used_size_not

    @property
    def used_size_not_in(self):
        """Gets the used_size_not_in of this VmVolumeWhereInput.  # noqa: E501


        :return: The used_size_not_in of this VmVolumeWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._used_size_not_in

    @used_size_not_in.setter
    def used_size_not_in(self, used_size_not_in):
        """Sets the used_size_not_in of this VmVolumeWhereInput.


        :param used_size_not_in: The used_size_not_in of this VmVolumeWhereInput.  # noqa: E501
        :type used_size_not_in: list[int]
        """

        self._used_size_not_in = used_size_not_in

    @property
    def used_size_usage(self):
        """Gets the used_size_usage of this VmVolumeWhereInput.  # noqa: E501


        :return: The used_size_usage of this VmVolumeWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._used_size_usage

    @used_size_usage.setter
    def used_size_usage(self, used_size_usage):
        """Sets the used_size_usage of this VmVolumeWhereInput.


        :param used_size_usage: The used_size_usage of this VmVolumeWhereInput.  # noqa: E501
        :type used_size_usage: float
        """

        self._used_size_usage = used_size_usage

    @property
    def used_size_usage_gt(self):
        """Gets the used_size_usage_gt of this VmVolumeWhereInput.  # noqa: E501


        :return: The used_size_usage_gt of this VmVolumeWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._used_size_usage_gt

    @used_size_usage_gt.setter
    def used_size_usage_gt(self, used_size_usage_gt):
        """Sets the used_size_usage_gt of this VmVolumeWhereInput.


        :param used_size_usage_gt: The used_size_usage_gt of this VmVolumeWhereInput.  # noqa: E501
        :type used_size_usage_gt: float
        """

        self._used_size_usage_gt = used_size_usage_gt

    @property
    def used_size_usage_gte(self):
        """Gets the used_size_usage_gte of this VmVolumeWhereInput.  # noqa: E501


        :return: The used_size_usage_gte of this VmVolumeWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._used_size_usage_gte

    @used_size_usage_gte.setter
    def used_size_usage_gte(self, used_size_usage_gte):
        """Sets the used_size_usage_gte of this VmVolumeWhereInput.


        :param used_size_usage_gte: The used_size_usage_gte of this VmVolumeWhereInput.  # noqa: E501
        :type used_size_usage_gte: float
        """

        self._used_size_usage_gte = used_size_usage_gte

    @property
    def used_size_usage_in(self):
        """Gets the used_size_usage_in of this VmVolumeWhereInput.  # noqa: E501


        :return: The used_size_usage_in of this VmVolumeWhereInput.  # noqa: E501
        :rtype: list[float]
        """
        return self._used_size_usage_in

    @used_size_usage_in.setter
    def used_size_usage_in(self, used_size_usage_in):
        """Sets the used_size_usage_in of this VmVolumeWhereInput.


        :param used_size_usage_in: The used_size_usage_in of this VmVolumeWhereInput.  # noqa: E501
        :type used_size_usage_in: list[float]
        """

        self._used_size_usage_in = used_size_usage_in

    @property
    def used_size_usage_lt(self):
        """Gets the used_size_usage_lt of this VmVolumeWhereInput.  # noqa: E501


        :return: The used_size_usage_lt of this VmVolumeWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._used_size_usage_lt

    @used_size_usage_lt.setter
    def used_size_usage_lt(self, used_size_usage_lt):
        """Sets the used_size_usage_lt of this VmVolumeWhereInput.


        :param used_size_usage_lt: The used_size_usage_lt of this VmVolumeWhereInput.  # noqa: E501
        :type used_size_usage_lt: float
        """

        self._used_size_usage_lt = used_size_usage_lt

    @property
    def used_size_usage_lte(self):
        """Gets the used_size_usage_lte of this VmVolumeWhereInput.  # noqa: E501


        :return: The used_size_usage_lte of this VmVolumeWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._used_size_usage_lte

    @used_size_usage_lte.setter
    def used_size_usage_lte(self, used_size_usage_lte):
        """Sets the used_size_usage_lte of this VmVolumeWhereInput.


        :param used_size_usage_lte: The used_size_usage_lte of this VmVolumeWhereInput.  # noqa: E501
        :type used_size_usage_lte: float
        """

        self._used_size_usage_lte = used_size_usage_lte

    @property
    def used_size_usage_not(self):
        """Gets the used_size_usage_not of this VmVolumeWhereInput.  # noqa: E501


        :return: The used_size_usage_not of this VmVolumeWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._used_size_usage_not

    @used_size_usage_not.setter
    def used_size_usage_not(self, used_size_usage_not):
        """Sets the used_size_usage_not of this VmVolumeWhereInput.


        :param used_size_usage_not: The used_size_usage_not of this VmVolumeWhereInput.  # noqa: E501
        :type used_size_usage_not: float
        """

        self._used_size_usage_not = used_size_usage_not

    @property
    def used_size_usage_not_in(self):
        """Gets the used_size_usage_not_in of this VmVolumeWhereInput.  # noqa: E501


        :return: The used_size_usage_not_in of this VmVolumeWhereInput.  # noqa: E501
        :rtype: list[float]
        """
        return self._used_size_usage_not_in

    @used_size_usage_not_in.setter
    def used_size_usage_not_in(self, used_size_usage_not_in):
        """Sets the used_size_usage_not_in of this VmVolumeWhereInput.


        :param used_size_usage_not_in: The used_size_usage_not_in of this VmVolumeWhereInput.  # noqa: E501
        :type used_size_usage_not_in: list[float]
        """

        self._used_size_usage_not_in = used_size_usage_not_in

    @property
    def vm_disks_every(self):
        """Gets the vm_disks_every of this VmVolumeWhereInput.  # noqa: E501


        :return: The vm_disks_every of this VmVolumeWhereInput.  # noqa: E501
        :rtype: VmDiskWhereInput
        """
        return self._vm_disks_every

    @vm_disks_every.setter
    def vm_disks_every(self, vm_disks_every):
        """Sets the vm_disks_every of this VmVolumeWhereInput.


        :param vm_disks_every: The vm_disks_every of this VmVolumeWhereInput.  # noqa: E501
        :type vm_disks_every: VmDiskWhereInput
        """

        self._vm_disks_every = vm_disks_every

    @property
    def vm_disks_none(self):
        """Gets the vm_disks_none of this VmVolumeWhereInput.  # noqa: E501


        :return: The vm_disks_none of this VmVolumeWhereInput.  # noqa: E501
        :rtype: VmDiskWhereInput
        """
        return self._vm_disks_none

    @vm_disks_none.setter
    def vm_disks_none(self, vm_disks_none):
        """Sets the vm_disks_none of this VmVolumeWhereInput.


        :param vm_disks_none: The vm_disks_none of this VmVolumeWhereInput.  # noqa: E501
        :type vm_disks_none: VmDiskWhereInput
        """

        self._vm_disks_none = vm_disks_none

    @property
    def vm_disks_some(self):
        """Gets the vm_disks_some of this VmVolumeWhereInput.  # noqa: E501


        :return: The vm_disks_some of this VmVolumeWhereInput.  # noqa: E501
        :rtype: VmDiskWhereInput
        """
        return self._vm_disks_some

    @vm_disks_some.setter
    def vm_disks_some(self, vm_disks_some):
        """Sets the vm_disks_some of this VmVolumeWhereInput.


        :param vm_disks_some: The vm_disks_some of this VmVolumeWhereInput.  # noqa: E501
        :type vm_disks_some: VmDiskWhereInput
        """

        self._vm_disks_some = vm_disks_some

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VmVolumeWhereInput):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VmVolumeWhereInput):
            return True

        return self.to_dict() != other.to_dict()
