# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class VnetBondWhereInput(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        '_and': 'list[VnetBondWhereInput]',
        '_not': 'list[VnetBondWhereInput]',
        '_or': 'list[VnetBondWhereInput]',
        'bond_for_client': 'bool',
        'bond_for_client_not': 'bool',
        'bond_for_server': 'bool',
        'bond_for_server_not': 'bool',
        'entity_async_status': 'EntityAsyncStatus',
        'entity_async_status_in': 'list[EntityAsyncStatus]',
        'entity_async_status_not': 'EntityAsyncStatus',
        'entity_async_status_not_in': 'list[EntityAsyncStatus]',
        'id': 'str',
        'id_contains': 'str',
        'id_ends_with': 'str',
        'id_gt': 'str',
        'id_gte': 'str',
        'id_in': 'list[str]',
        'id_lt': 'str',
        'id_lte': 'str',
        'id_not': 'str',
        'id_not_contains': 'str',
        'id_not_ends_with': 'str',
        'id_not_in': 'list[str]',
        'id_not_starts_with': 'str',
        'id_starts_with': 'str',
        'load_balancer_service': 'LoadBalancerServiceWhereInput',
        'local_id': 'str',
        'local_id_contains': 'str',
        'local_id_ends_with': 'str',
        'local_id_gt': 'str',
        'local_id_gte': 'str',
        'local_id_in': 'list[str]',
        'local_id_lt': 'str',
        'local_id_lte': 'str',
        'local_id_not': 'str',
        'local_id_not_contains': 'str',
        'local_id_not_ends_with': 'str',
        'local_id_not_in': 'list[str]',
        'local_id_not_starts_with': 'str',
        'local_id_starts_with': 'str',
        'name': 'str',
        'name_contains': 'str',
        'name_ends_with': 'str',
        'name_gt': 'str',
        'name_gte': 'str',
        'name_in': 'list[str]',
        'name_lt': 'str',
        'name_lte': 'str',
        'name_not': 'str',
        'name_not_contains': 'str',
        'name_not_ends_with': 'str',
        'name_not_in': 'list[str]',
        'name_not_starts_with': 'str',
        'name_starts_with': 'str',
        'namespace': 'str',
        'namespace_contains': 'str',
        'namespace_ends_with': 'str',
        'namespace_gt': 'str',
        'namespace_gte': 'str',
        'namespace_in': 'list[str]',
        'namespace_lt': 'str',
        'namespace_lte': 'str',
        'namespace_not': 'str',
        'namespace_not_contains': 'str',
        'namespace_not_ends_with': 'str',
        'namespace_not_in': 'list[str]',
        'namespace_not_starts_with': 'str',
        'namespace_starts_with': 'str',
        'vlan': 'VlanWhereInput'
    }

    attribute_map = {
        '_and': 'AND',
        '_not': 'NOT',
        '_or': 'OR',
        'bond_for_client': 'bond_for_client',
        'bond_for_client_not': 'bond_for_client_not',
        'bond_for_server': 'bond_for_server',
        'bond_for_server_not': 'bond_for_server_not',
        'entity_async_status': 'entityAsyncStatus',
        'entity_async_status_in': 'entityAsyncStatus_in',
        'entity_async_status_not': 'entityAsyncStatus_not',
        'entity_async_status_not_in': 'entityAsyncStatus_not_in',
        'id': 'id',
        'id_contains': 'id_contains',
        'id_ends_with': 'id_ends_with',
        'id_gt': 'id_gt',
        'id_gte': 'id_gte',
        'id_in': 'id_in',
        'id_lt': 'id_lt',
        'id_lte': 'id_lte',
        'id_not': 'id_not',
        'id_not_contains': 'id_not_contains',
        'id_not_ends_with': 'id_not_ends_with',
        'id_not_in': 'id_not_in',
        'id_not_starts_with': 'id_not_starts_with',
        'id_starts_with': 'id_starts_with',
        'load_balancer_service': 'load_balancer_service',
        'local_id': 'local_id',
        'local_id_contains': 'local_id_contains',
        'local_id_ends_with': 'local_id_ends_with',
        'local_id_gt': 'local_id_gt',
        'local_id_gte': 'local_id_gte',
        'local_id_in': 'local_id_in',
        'local_id_lt': 'local_id_lt',
        'local_id_lte': 'local_id_lte',
        'local_id_not': 'local_id_not',
        'local_id_not_contains': 'local_id_not_contains',
        'local_id_not_ends_with': 'local_id_not_ends_with',
        'local_id_not_in': 'local_id_not_in',
        'local_id_not_starts_with': 'local_id_not_starts_with',
        'local_id_starts_with': 'local_id_starts_with',
        'name': 'name',
        'name_contains': 'name_contains',
        'name_ends_with': 'name_ends_with',
        'name_gt': 'name_gt',
        'name_gte': 'name_gte',
        'name_in': 'name_in',
        'name_lt': 'name_lt',
        'name_lte': 'name_lte',
        'name_not': 'name_not',
        'name_not_contains': 'name_not_contains',
        'name_not_ends_with': 'name_not_ends_with',
        'name_not_in': 'name_not_in',
        'name_not_starts_with': 'name_not_starts_with',
        'name_starts_with': 'name_starts_with',
        'namespace': 'namespace',
        'namespace_contains': 'namespace_contains',
        'namespace_ends_with': 'namespace_ends_with',
        'namespace_gt': 'namespace_gt',
        'namespace_gte': 'namespace_gte',
        'namespace_in': 'namespace_in',
        'namespace_lt': 'namespace_lt',
        'namespace_lte': 'namespace_lte',
        'namespace_not': 'namespace_not',
        'namespace_not_contains': 'namespace_not_contains',
        'namespace_not_ends_with': 'namespace_not_ends_with',
        'namespace_not_in': 'namespace_not_in',
        'namespace_not_starts_with': 'namespace_not_starts_with',
        'namespace_starts_with': 'namespace_starts_with',
        'vlan': 'vlan'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """VnetBondWhereInput - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self.__and = None
        self.__not = None
        self.__or = None
        self._bond_for_client = None
        self._bond_for_client_not = None
        self._bond_for_server = None
        self._bond_for_server_not = None
        self._entity_async_status = None
        self._entity_async_status_in = None
        self._entity_async_status_not = None
        self._entity_async_status_not_in = None
        self._id = None
        self._id_contains = None
        self._id_ends_with = None
        self._id_gt = None
        self._id_gte = None
        self._id_in = None
        self._id_lt = None
        self._id_lte = None
        self._id_not = None
        self._id_not_contains = None
        self._id_not_ends_with = None
        self._id_not_in = None
        self._id_not_starts_with = None
        self._id_starts_with = None
        self._load_balancer_service = None
        self._local_id = None
        self._local_id_contains = None
        self._local_id_ends_with = None
        self._local_id_gt = None
        self._local_id_gte = None
        self._local_id_in = None
        self._local_id_lt = None
        self._local_id_lte = None
        self._local_id_not = None
        self._local_id_not_contains = None
        self._local_id_not_ends_with = None
        self._local_id_not_in = None
        self._local_id_not_starts_with = None
        self._local_id_starts_with = None
        self._name = None
        self._name_contains = None
        self._name_ends_with = None
        self._name_gt = None
        self._name_gte = None
        self._name_in = None
        self._name_lt = None
        self._name_lte = None
        self._name_not = None
        self._name_not_contains = None
        self._name_not_ends_with = None
        self._name_not_in = None
        self._name_not_starts_with = None
        self._name_starts_with = None
        self._namespace = None
        self._namespace_contains = None
        self._namespace_ends_with = None
        self._namespace_gt = None
        self._namespace_gte = None
        self._namespace_in = None
        self._namespace_lt = None
        self._namespace_lte = None
        self._namespace_not = None
        self._namespace_not_contains = None
        self._namespace_not_ends_with = None
        self._namespace_not_in = None
        self._namespace_not_starts_with = None
        self._namespace_starts_with = None
        self._vlan = None
        self.discriminator = None

        self._and = kwargs.get("_and", None)
        self._not = kwargs.get("_not", None)
        self._or = kwargs.get("_or", None)
        self.bond_for_client = kwargs.get("bond_for_client", None)
        self.bond_for_client_not = kwargs.get("bond_for_client_not", None)
        self.bond_for_server = kwargs.get("bond_for_server", None)
        self.bond_for_server_not = kwargs.get("bond_for_server_not", None)
        self.entity_async_status = kwargs.get("entity_async_status", None)
        self.entity_async_status_in = kwargs.get("entity_async_status_in", None)
        self.entity_async_status_not = kwargs.get("entity_async_status_not", None)
        self.entity_async_status_not_in = kwargs.get("entity_async_status_not_in", None)
        self.id = kwargs.get("id", None)
        self.id_contains = kwargs.get("id_contains", None)
        self.id_ends_with = kwargs.get("id_ends_with", None)
        self.id_gt = kwargs.get("id_gt", None)
        self.id_gte = kwargs.get("id_gte", None)
        self.id_in = kwargs.get("id_in", None)
        self.id_lt = kwargs.get("id_lt", None)
        self.id_lte = kwargs.get("id_lte", None)
        self.id_not = kwargs.get("id_not", None)
        self.id_not_contains = kwargs.get("id_not_contains", None)
        self.id_not_ends_with = kwargs.get("id_not_ends_with", None)
        self.id_not_in = kwargs.get("id_not_in", None)
        self.id_not_starts_with = kwargs.get("id_not_starts_with", None)
        self.id_starts_with = kwargs.get("id_starts_with", None)
        self.load_balancer_service = kwargs.get("load_balancer_service", None)
        self.local_id = kwargs.get("local_id", None)
        self.local_id_contains = kwargs.get("local_id_contains", None)
        self.local_id_ends_with = kwargs.get("local_id_ends_with", None)
        self.local_id_gt = kwargs.get("local_id_gt", None)
        self.local_id_gte = kwargs.get("local_id_gte", None)
        self.local_id_in = kwargs.get("local_id_in", None)
        self.local_id_lt = kwargs.get("local_id_lt", None)
        self.local_id_lte = kwargs.get("local_id_lte", None)
        self.local_id_not = kwargs.get("local_id_not", None)
        self.local_id_not_contains = kwargs.get("local_id_not_contains", None)
        self.local_id_not_ends_with = kwargs.get("local_id_not_ends_with", None)
        self.local_id_not_in = kwargs.get("local_id_not_in", None)
        self.local_id_not_starts_with = kwargs.get("local_id_not_starts_with", None)
        self.local_id_starts_with = kwargs.get("local_id_starts_with", None)
        self.name = kwargs.get("name", None)
        self.name_contains = kwargs.get("name_contains", None)
        self.name_ends_with = kwargs.get("name_ends_with", None)
        self.name_gt = kwargs.get("name_gt", None)
        self.name_gte = kwargs.get("name_gte", None)
        self.name_in = kwargs.get("name_in", None)
        self.name_lt = kwargs.get("name_lt", None)
        self.name_lte = kwargs.get("name_lte", None)
        self.name_not = kwargs.get("name_not", None)
        self.name_not_contains = kwargs.get("name_not_contains", None)
        self.name_not_ends_with = kwargs.get("name_not_ends_with", None)
        self.name_not_in = kwargs.get("name_not_in", None)
        self.name_not_starts_with = kwargs.get("name_not_starts_with", None)
        self.name_starts_with = kwargs.get("name_starts_with", None)
        self.namespace = kwargs.get("namespace", None)
        self.namespace_contains = kwargs.get("namespace_contains", None)
        self.namespace_ends_with = kwargs.get("namespace_ends_with", None)
        self.namespace_gt = kwargs.get("namespace_gt", None)
        self.namespace_gte = kwargs.get("namespace_gte", None)
        self.namespace_in = kwargs.get("namespace_in", None)
        self.namespace_lt = kwargs.get("namespace_lt", None)
        self.namespace_lte = kwargs.get("namespace_lte", None)
        self.namespace_not = kwargs.get("namespace_not", None)
        self.namespace_not_contains = kwargs.get("namespace_not_contains", None)
        self.namespace_not_ends_with = kwargs.get("namespace_not_ends_with", None)
        self.namespace_not_in = kwargs.get("namespace_not_in", None)
        self.namespace_not_starts_with = kwargs.get("namespace_not_starts_with", None)
        self.namespace_starts_with = kwargs.get("namespace_starts_with", None)
        self.vlan = kwargs.get("vlan", None)

    @property
    def _and(self):
        """Gets the _and of this VnetBondWhereInput.  # noqa: E501


        :return: The _and of this VnetBondWhereInput.  # noqa: E501
        :rtype: list[VnetBondWhereInput]
        """
        return self.__and

    @_and.setter
    def _and(self, _and):
        """Sets the _and of this VnetBondWhereInput.


        :param _and: The _and of this VnetBondWhereInput.  # noqa: E501
        :type _and: list[VnetBondWhereInput]
        """

        self.__and = _and

    @property
    def _not(self):
        """Gets the _not of this VnetBondWhereInput.  # noqa: E501


        :return: The _not of this VnetBondWhereInput.  # noqa: E501
        :rtype: list[VnetBondWhereInput]
        """
        return self.__not

    @_not.setter
    def _not(self, _not):
        """Sets the _not of this VnetBondWhereInput.


        :param _not: The _not of this VnetBondWhereInput.  # noqa: E501
        :type _not: list[VnetBondWhereInput]
        """

        self.__not = _not

    @property
    def _or(self):
        """Gets the _or of this VnetBondWhereInput.  # noqa: E501


        :return: The _or of this VnetBondWhereInput.  # noqa: E501
        :rtype: list[VnetBondWhereInput]
        """
        return self.__or

    @_or.setter
    def _or(self, _or):
        """Sets the _or of this VnetBondWhereInput.


        :param _or: The _or of this VnetBondWhereInput.  # noqa: E501
        :type _or: list[VnetBondWhereInput]
        """

        self.__or = _or

    @property
    def bond_for_client(self):
        """Gets the bond_for_client of this VnetBondWhereInput.  # noqa: E501


        :return: The bond_for_client of this VnetBondWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._bond_for_client

    @bond_for_client.setter
    def bond_for_client(self, bond_for_client):
        """Sets the bond_for_client of this VnetBondWhereInput.


        :param bond_for_client: The bond_for_client of this VnetBondWhereInput.  # noqa: E501
        :type bond_for_client: bool
        """

        self._bond_for_client = bond_for_client

    @property
    def bond_for_client_not(self):
        """Gets the bond_for_client_not of this VnetBondWhereInput.  # noqa: E501


        :return: The bond_for_client_not of this VnetBondWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._bond_for_client_not

    @bond_for_client_not.setter
    def bond_for_client_not(self, bond_for_client_not):
        """Sets the bond_for_client_not of this VnetBondWhereInput.


        :param bond_for_client_not: The bond_for_client_not of this VnetBondWhereInput.  # noqa: E501
        :type bond_for_client_not: bool
        """

        self._bond_for_client_not = bond_for_client_not

    @property
    def bond_for_server(self):
        """Gets the bond_for_server of this VnetBondWhereInput.  # noqa: E501


        :return: The bond_for_server of this VnetBondWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._bond_for_server

    @bond_for_server.setter
    def bond_for_server(self, bond_for_server):
        """Sets the bond_for_server of this VnetBondWhereInput.


        :param bond_for_server: The bond_for_server of this VnetBondWhereInput.  # noqa: E501
        :type bond_for_server: bool
        """

        self._bond_for_server = bond_for_server

    @property
    def bond_for_server_not(self):
        """Gets the bond_for_server_not of this VnetBondWhereInput.  # noqa: E501


        :return: The bond_for_server_not of this VnetBondWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._bond_for_server_not

    @bond_for_server_not.setter
    def bond_for_server_not(self, bond_for_server_not):
        """Sets the bond_for_server_not of this VnetBondWhereInput.


        :param bond_for_server_not: The bond_for_server_not of this VnetBondWhereInput.  # noqa: E501
        :type bond_for_server_not: bool
        """

        self._bond_for_server_not = bond_for_server_not

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this VnetBondWhereInput.  # noqa: E501


        :return: The entity_async_status of this VnetBondWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this VnetBondWhereInput.


        :param entity_async_status: The entity_async_status of this VnetBondWhereInput.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def entity_async_status_in(self):
        """Gets the entity_async_status_in of this VnetBondWhereInput.  # noqa: E501


        :return: The entity_async_status_in of this VnetBondWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_in

    @entity_async_status_in.setter
    def entity_async_status_in(self, entity_async_status_in):
        """Sets the entity_async_status_in of this VnetBondWhereInput.


        :param entity_async_status_in: The entity_async_status_in of this VnetBondWhereInput.  # noqa: E501
        :type entity_async_status_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_in = entity_async_status_in

    @property
    def entity_async_status_not(self):
        """Gets the entity_async_status_not of this VnetBondWhereInput.  # noqa: E501


        :return: The entity_async_status_not of this VnetBondWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status_not

    @entity_async_status_not.setter
    def entity_async_status_not(self, entity_async_status_not):
        """Sets the entity_async_status_not of this VnetBondWhereInput.


        :param entity_async_status_not: The entity_async_status_not of this VnetBondWhereInput.  # noqa: E501
        :type entity_async_status_not: EntityAsyncStatus
        """

        self._entity_async_status_not = entity_async_status_not

    @property
    def entity_async_status_not_in(self):
        """Gets the entity_async_status_not_in of this VnetBondWhereInput.  # noqa: E501


        :return: The entity_async_status_not_in of this VnetBondWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_not_in

    @entity_async_status_not_in.setter
    def entity_async_status_not_in(self, entity_async_status_not_in):
        """Sets the entity_async_status_not_in of this VnetBondWhereInput.


        :param entity_async_status_not_in: The entity_async_status_not_in of this VnetBondWhereInput.  # noqa: E501
        :type entity_async_status_not_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_not_in = entity_async_status_not_in

    @property
    def id(self):
        """Gets the id of this VnetBondWhereInput.  # noqa: E501


        :return: The id of this VnetBondWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this VnetBondWhereInput.


        :param id: The id of this VnetBondWhereInput.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def id_contains(self):
        """Gets the id_contains of this VnetBondWhereInput.  # noqa: E501


        :return: The id_contains of this VnetBondWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_contains

    @id_contains.setter
    def id_contains(self, id_contains):
        """Sets the id_contains of this VnetBondWhereInput.


        :param id_contains: The id_contains of this VnetBondWhereInput.  # noqa: E501
        :type id_contains: str
        """

        self._id_contains = id_contains

    @property
    def id_ends_with(self):
        """Gets the id_ends_with of this VnetBondWhereInput.  # noqa: E501


        :return: The id_ends_with of this VnetBondWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_ends_with

    @id_ends_with.setter
    def id_ends_with(self, id_ends_with):
        """Sets the id_ends_with of this VnetBondWhereInput.


        :param id_ends_with: The id_ends_with of this VnetBondWhereInput.  # noqa: E501
        :type id_ends_with: str
        """

        self._id_ends_with = id_ends_with

    @property
    def id_gt(self):
        """Gets the id_gt of this VnetBondWhereInput.  # noqa: E501


        :return: The id_gt of this VnetBondWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gt

    @id_gt.setter
    def id_gt(self, id_gt):
        """Sets the id_gt of this VnetBondWhereInput.


        :param id_gt: The id_gt of this VnetBondWhereInput.  # noqa: E501
        :type id_gt: str
        """

        self._id_gt = id_gt

    @property
    def id_gte(self):
        """Gets the id_gte of this VnetBondWhereInput.  # noqa: E501


        :return: The id_gte of this VnetBondWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gte

    @id_gte.setter
    def id_gte(self, id_gte):
        """Sets the id_gte of this VnetBondWhereInput.


        :param id_gte: The id_gte of this VnetBondWhereInput.  # noqa: E501
        :type id_gte: str
        """

        self._id_gte = id_gte

    @property
    def id_in(self):
        """Gets the id_in of this VnetBondWhereInput.  # noqa: E501


        :return: The id_in of this VnetBondWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_in

    @id_in.setter
    def id_in(self, id_in):
        """Sets the id_in of this VnetBondWhereInput.


        :param id_in: The id_in of this VnetBondWhereInput.  # noqa: E501
        :type id_in: list[str]
        """

        self._id_in = id_in

    @property
    def id_lt(self):
        """Gets the id_lt of this VnetBondWhereInput.  # noqa: E501


        :return: The id_lt of this VnetBondWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lt

    @id_lt.setter
    def id_lt(self, id_lt):
        """Sets the id_lt of this VnetBondWhereInput.


        :param id_lt: The id_lt of this VnetBondWhereInput.  # noqa: E501
        :type id_lt: str
        """

        self._id_lt = id_lt

    @property
    def id_lte(self):
        """Gets the id_lte of this VnetBondWhereInput.  # noqa: E501


        :return: The id_lte of this VnetBondWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lte

    @id_lte.setter
    def id_lte(self, id_lte):
        """Sets the id_lte of this VnetBondWhereInput.


        :param id_lte: The id_lte of this VnetBondWhereInput.  # noqa: E501
        :type id_lte: str
        """

        self._id_lte = id_lte

    @property
    def id_not(self):
        """Gets the id_not of this VnetBondWhereInput.  # noqa: E501


        :return: The id_not of this VnetBondWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not

    @id_not.setter
    def id_not(self, id_not):
        """Sets the id_not of this VnetBondWhereInput.


        :param id_not: The id_not of this VnetBondWhereInput.  # noqa: E501
        :type id_not: str
        """

        self._id_not = id_not

    @property
    def id_not_contains(self):
        """Gets the id_not_contains of this VnetBondWhereInput.  # noqa: E501


        :return: The id_not_contains of this VnetBondWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_contains

    @id_not_contains.setter
    def id_not_contains(self, id_not_contains):
        """Sets the id_not_contains of this VnetBondWhereInput.


        :param id_not_contains: The id_not_contains of this VnetBondWhereInput.  # noqa: E501
        :type id_not_contains: str
        """

        self._id_not_contains = id_not_contains

    @property
    def id_not_ends_with(self):
        """Gets the id_not_ends_with of this VnetBondWhereInput.  # noqa: E501


        :return: The id_not_ends_with of this VnetBondWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_ends_with

    @id_not_ends_with.setter
    def id_not_ends_with(self, id_not_ends_with):
        """Sets the id_not_ends_with of this VnetBondWhereInput.


        :param id_not_ends_with: The id_not_ends_with of this VnetBondWhereInput.  # noqa: E501
        :type id_not_ends_with: str
        """

        self._id_not_ends_with = id_not_ends_with

    @property
    def id_not_in(self):
        """Gets the id_not_in of this VnetBondWhereInput.  # noqa: E501


        :return: The id_not_in of this VnetBondWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_not_in

    @id_not_in.setter
    def id_not_in(self, id_not_in):
        """Sets the id_not_in of this VnetBondWhereInput.


        :param id_not_in: The id_not_in of this VnetBondWhereInput.  # noqa: E501
        :type id_not_in: list[str]
        """

        self._id_not_in = id_not_in

    @property
    def id_not_starts_with(self):
        """Gets the id_not_starts_with of this VnetBondWhereInput.  # noqa: E501


        :return: The id_not_starts_with of this VnetBondWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_starts_with

    @id_not_starts_with.setter
    def id_not_starts_with(self, id_not_starts_with):
        """Sets the id_not_starts_with of this VnetBondWhereInput.


        :param id_not_starts_with: The id_not_starts_with of this VnetBondWhereInput.  # noqa: E501
        :type id_not_starts_with: str
        """

        self._id_not_starts_with = id_not_starts_with

    @property
    def id_starts_with(self):
        """Gets the id_starts_with of this VnetBondWhereInput.  # noqa: E501


        :return: The id_starts_with of this VnetBondWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_starts_with

    @id_starts_with.setter
    def id_starts_with(self, id_starts_with):
        """Sets the id_starts_with of this VnetBondWhereInput.


        :param id_starts_with: The id_starts_with of this VnetBondWhereInput.  # noqa: E501
        :type id_starts_with: str
        """

        self._id_starts_with = id_starts_with

    @property
    def load_balancer_service(self):
        """Gets the load_balancer_service of this VnetBondWhereInput.  # noqa: E501


        :return: The load_balancer_service of this VnetBondWhereInput.  # noqa: E501
        :rtype: LoadBalancerServiceWhereInput
        """
        return self._load_balancer_service

    @load_balancer_service.setter
    def load_balancer_service(self, load_balancer_service):
        """Sets the load_balancer_service of this VnetBondWhereInput.


        :param load_balancer_service: The load_balancer_service of this VnetBondWhereInput.  # noqa: E501
        :type load_balancer_service: LoadBalancerServiceWhereInput
        """

        self._load_balancer_service = load_balancer_service

    @property
    def local_id(self):
        """Gets the local_id of this VnetBondWhereInput.  # noqa: E501


        :return: The local_id of this VnetBondWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id):
        """Sets the local_id of this VnetBondWhereInput.


        :param local_id: The local_id of this VnetBondWhereInput.  # noqa: E501
        :type local_id: str
        """

        self._local_id = local_id

    @property
    def local_id_contains(self):
        """Gets the local_id_contains of this VnetBondWhereInput.  # noqa: E501


        :return: The local_id_contains of this VnetBondWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_contains

    @local_id_contains.setter
    def local_id_contains(self, local_id_contains):
        """Sets the local_id_contains of this VnetBondWhereInput.


        :param local_id_contains: The local_id_contains of this VnetBondWhereInput.  # noqa: E501
        :type local_id_contains: str
        """

        self._local_id_contains = local_id_contains

    @property
    def local_id_ends_with(self):
        """Gets the local_id_ends_with of this VnetBondWhereInput.  # noqa: E501


        :return: The local_id_ends_with of this VnetBondWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_ends_with

    @local_id_ends_with.setter
    def local_id_ends_with(self, local_id_ends_with):
        """Sets the local_id_ends_with of this VnetBondWhereInput.


        :param local_id_ends_with: The local_id_ends_with of this VnetBondWhereInput.  # noqa: E501
        :type local_id_ends_with: str
        """

        self._local_id_ends_with = local_id_ends_with

    @property
    def local_id_gt(self):
        """Gets the local_id_gt of this VnetBondWhereInput.  # noqa: E501


        :return: The local_id_gt of this VnetBondWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_gt

    @local_id_gt.setter
    def local_id_gt(self, local_id_gt):
        """Sets the local_id_gt of this VnetBondWhereInput.


        :param local_id_gt: The local_id_gt of this VnetBondWhereInput.  # noqa: E501
        :type local_id_gt: str
        """

        self._local_id_gt = local_id_gt

    @property
    def local_id_gte(self):
        """Gets the local_id_gte of this VnetBondWhereInput.  # noqa: E501


        :return: The local_id_gte of this VnetBondWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_gte

    @local_id_gte.setter
    def local_id_gte(self, local_id_gte):
        """Sets the local_id_gte of this VnetBondWhereInput.


        :param local_id_gte: The local_id_gte of this VnetBondWhereInput.  # noqa: E501
        :type local_id_gte: str
        """

        self._local_id_gte = local_id_gte

    @property
    def local_id_in(self):
        """Gets the local_id_in of this VnetBondWhereInput.  # noqa: E501


        :return: The local_id_in of this VnetBondWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_id_in

    @local_id_in.setter
    def local_id_in(self, local_id_in):
        """Sets the local_id_in of this VnetBondWhereInput.


        :param local_id_in: The local_id_in of this VnetBondWhereInput.  # noqa: E501
        :type local_id_in: list[str]
        """

        self._local_id_in = local_id_in

    @property
    def local_id_lt(self):
        """Gets the local_id_lt of this VnetBondWhereInput.  # noqa: E501


        :return: The local_id_lt of this VnetBondWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_lt

    @local_id_lt.setter
    def local_id_lt(self, local_id_lt):
        """Sets the local_id_lt of this VnetBondWhereInput.


        :param local_id_lt: The local_id_lt of this VnetBondWhereInput.  # noqa: E501
        :type local_id_lt: str
        """

        self._local_id_lt = local_id_lt

    @property
    def local_id_lte(self):
        """Gets the local_id_lte of this VnetBondWhereInput.  # noqa: E501


        :return: The local_id_lte of this VnetBondWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_lte

    @local_id_lte.setter
    def local_id_lte(self, local_id_lte):
        """Sets the local_id_lte of this VnetBondWhereInput.


        :param local_id_lte: The local_id_lte of this VnetBondWhereInput.  # noqa: E501
        :type local_id_lte: str
        """

        self._local_id_lte = local_id_lte

    @property
    def local_id_not(self):
        """Gets the local_id_not of this VnetBondWhereInput.  # noqa: E501


        :return: The local_id_not of this VnetBondWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not

    @local_id_not.setter
    def local_id_not(self, local_id_not):
        """Sets the local_id_not of this VnetBondWhereInput.


        :param local_id_not: The local_id_not of this VnetBondWhereInput.  # noqa: E501
        :type local_id_not: str
        """

        self._local_id_not = local_id_not

    @property
    def local_id_not_contains(self):
        """Gets the local_id_not_contains of this VnetBondWhereInput.  # noqa: E501


        :return: The local_id_not_contains of this VnetBondWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_contains

    @local_id_not_contains.setter
    def local_id_not_contains(self, local_id_not_contains):
        """Sets the local_id_not_contains of this VnetBondWhereInput.


        :param local_id_not_contains: The local_id_not_contains of this VnetBondWhereInput.  # noqa: E501
        :type local_id_not_contains: str
        """

        self._local_id_not_contains = local_id_not_contains

    @property
    def local_id_not_ends_with(self):
        """Gets the local_id_not_ends_with of this VnetBondWhereInput.  # noqa: E501


        :return: The local_id_not_ends_with of this VnetBondWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_ends_with

    @local_id_not_ends_with.setter
    def local_id_not_ends_with(self, local_id_not_ends_with):
        """Sets the local_id_not_ends_with of this VnetBondWhereInput.


        :param local_id_not_ends_with: The local_id_not_ends_with of this VnetBondWhereInput.  # noqa: E501
        :type local_id_not_ends_with: str
        """

        self._local_id_not_ends_with = local_id_not_ends_with

    @property
    def local_id_not_in(self):
        """Gets the local_id_not_in of this VnetBondWhereInput.  # noqa: E501


        :return: The local_id_not_in of this VnetBondWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_id_not_in

    @local_id_not_in.setter
    def local_id_not_in(self, local_id_not_in):
        """Sets the local_id_not_in of this VnetBondWhereInput.


        :param local_id_not_in: The local_id_not_in of this VnetBondWhereInput.  # noqa: E501
        :type local_id_not_in: list[str]
        """

        self._local_id_not_in = local_id_not_in

    @property
    def local_id_not_starts_with(self):
        """Gets the local_id_not_starts_with of this VnetBondWhereInput.  # noqa: E501


        :return: The local_id_not_starts_with of this VnetBondWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_starts_with

    @local_id_not_starts_with.setter
    def local_id_not_starts_with(self, local_id_not_starts_with):
        """Sets the local_id_not_starts_with of this VnetBondWhereInput.


        :param local_id_not_starts_with: The local_id_not_starts_with of this VnetBondWhereInput.  # noqa: E501
        :type local_id_not_starts_with: str
        """

        self._local_id_not_starts_with = local_id_not_starts_with

    @property
    def local_id_starts_with(self):
        """Gets the local_id_starts_with of this VnetBondWhereInput.  # noqa: E501


        :return: The local_id_starts_with of this VnetBondWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_starts_with

    @local_id_starts_with.setter
    def local_id_starts_with(self, local_id_starts_with):
        """Sets the local_id_starts_with of this VnetBondWhereInput.


        :param local_id_starts_with: The local_id_starts_with of this VnetBondWhereInput.  # noqa: E501
        :type local_id_starts_with: str
        """

        self._local_id_starts_with = local_id_starts_with

    @property
    def name(self):
        """Gets the name of this VnetBondWhereInput.  # noqa: E501


        :return: The name of this VnetBondWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this VnetBondWhereInput.


        :param name: The name of this VnetBondWhereInput.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def name_contains(self):
        """Gets the name_contains of this VnetBondWhereInput.  # noqa: E501


        :return: The name_contains of this VnetBondWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_contains

    @name_contains.setter
    def name_contains(self, name_contains):
        """Sets the name_contains of this VnetBondWhereInput.


        :param name_contains: The name_contains of this VnetBondWhereInput.  # noqa: E501
        :type name_contains: str
        """

        self._name_contains = name_contains

    @property
    def name_ends_with(self):
        """Gets the name_ends_with of this VnetBondWhereInput.  # noqa: E501


        :return: The name_ends_with of this VnetBondWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_ends_with

    @name_ends_with.setter
    def name_ends_with(self, name_ends_with):
        """Sets the name_ends_with of this VnetBondWhereInput.


        :param name_ends_with: The name_ends_with of this VnetBondWhereInput.  # noqa: E501
        :type name_ends_with: str
        """

        self._name_ends_with = name_ends_with

    @property
    def name_gt(self):
        """Gets the name_gt of this VnetBondWhereInput.  # noqa: E501


        :return: The name_gt of this VnetBondWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_gt

    @name_gt.setter
    def name_gt(self, name_gt):
        """Sets the name_gt of this VnetBondWhereInput.


        :param name_gt: The name_gt of this VnetBondWhereInput.  # noqa: E501
        :type name_gt: str
        """

        self._name_gt = name_gt

    @property
    def name_gte(self):
        """Gets the name_gte of this VnetBondWhereInput.  # noqa: E501


        :return: The name_gte of this VnetBondWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_gte

    @name_gte.setter
    def name_gte(self, name_gte):
        """Sets the name_gte of this VnetBondWhereInput.


        :param name_gte: The name_gte of this VnetBondWhereInput.  # noqa: E501
        :type name_gte: str
        """

        self._name_gte = name_gte

    @property
    def name_in(self):
        """Gets the name_in of this VnetBondWhereInput.  # noqa: E501


        :return: The name_in of this VnetBondWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._name_in

    @name_in.setter
    def name_in(self, name_in):
        """Sets the name_in of this VnetBondWhereInput.


        :param name_in: The name_in of this VnetBondWhereInput.  # noqa: E501
        :type name_in: list[str]
        """

        self._name_in = name_in

    @property
    def name_lt(self):
        """Gets the name_lt of this VnetBondWhereInput.  # noqa: E501


        :return: The name_lt of this VnetBondWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_lt

    @name_lt.setter
    def name_lt(self, name_lt):
        """Sets the name_lt of this VnetBondWhereInput.


        :param name_lt: The name_lt of this VnetBondWhereInput.  # noqa: E501
        :type name_lt: str
        """

        self._name_lt = name_lt

    @property
    def name_lte(self):
        """Gets the name_lte of this VnetBondWhereInput.  # noqa: E501


        :return: The name_lte of this VnetBondWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_lte

    @name_lte.setter
    def name_lte(self, name_lte):
        """Sets the name_lte of this VnetBondWhereInput.


        :param name_lte: The name_lte of this VnetBondWhereInput.  # noqa: E501
        :type name_lte: str
        """

        self._name_lte = name_lte

    @property
    def name_not(self):
        """Gets the name_not of this VnetBondWhereInput.  # noqa: E501


        :return: The name_not of this VnetBondWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not

    @name_not.setter
    def name_not(self, name_not):
        """Sets the name_not of this VnetBondWhereInput.


        :param name_not: The name_not of this VnetBondWhereInput.  # noqa: E501
        :type name_not: str
        """

        self._name_not = name_not

    @property
    def name_not_contains(self):
        """Gets the name_not_contains of this VnetBondWhereInput.  # noqa: E501


        :return: The name_not_contains of this VnetBondWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_contains

    @name_not_contains.setter
    def name_not_contains(self, name_not_contains):
        """Sets the name_not_contains of this VnetBondWhereInput.


        :param name_not_contains: The name_not_contains of this VnetBondWhereInput.  # noqa: E501
        :type name_not_contains: str
        """

        self._name_not_contains = name_not_contains

    @property
    def name_not_ends_with(self):
        """Gets the name_not_ends_with of this VnetBondWhereInput.  # noqa: E501


        :return: The name_not_ends_with of this VnetBondWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_ends_with

    @name_not_ends_with.setter
    def name_not_ends_with(self, name_not_ends_with):
        """Sets the name_not_ends_with of this VnetBondWhereInput.


        :param name_not_ends_with: The name_not_ends_with of this VnetBondWhereInput.  # noqa: E501
        :type name_not_ends_with: str
        """

        self._name_not_ends_with = name_not_ends_with

    @property
    def name_not_in(self):
        """Gets the name_not_in of this VnetBondWhereInput.  # noqa: E501


        :return: The name_not_in of this VnetBondWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._name_not_in

    @name_not_in.setter
    def name_not_in(self, name_not_in):
        """Sets the name_not_in of this VnetBondWhereInput.


        :param name_not_in: The name_not_in of this VnetBondWhereInput.  # noqa: E501
        :type name_not_in: list[str]
        """

        self._name_not_in = name_not_in

    @property
    def name_not_starts_with(self):
        """Gets the name_not_starts_with of this VnetBondWhereInput.  # noqa: E501


        :return: The name_not_starts_with of this VnetBondWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_starts_with

    @name_not_starts_with.setter
    def name_not_starts_with(self, name_not_starts_with):
        """Sets the name_not_starts_with of this VnetBondWhereInput.


        :param name_not_starts_with: The name_not_starts_with of this VnetBondWhereInput.  # noqa: E501
        :type name_not_starts_with: str
        """

        self._name_not_starts_with = name_not_starts_with

    @property
    def name_starts_with(self):
        """Gets the name_starts_with of this VnetBondWhereInput.  # noqa: E501


        :return: The name_starts_with of this VnetBondWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_starts_with

    @name_starts_with.setter
    def name_starts_with(self, name_starts_with):
        """Sets the name_starts_with of this VnetBondWhereInput.


        :param name_starts_with: The name_starts_with of this VnetBondWhereInput.  # noqa: E501
        :type name_starts_with: str
        """

        self._name_starts_with = name_starts_with

    @property
    def namespace(self):
        """Gets the namespace of this VnetBondWhereInput.  # noqa: E501


        :return: The namespace of this VnetBondWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """Sets the namespace of this VnetBondWhereInput.


        :param namespace: The namespace of this VnetBondWhereInput.  # noqa: E501
        :type namespace: str
        """

        self._namespace = namespace

    @property
    def namespace_contains(self):
        """Gets the namespace_contains of this VnetBondWhereInput.  # noqa: E501


        :return: The namespace_contains of this VnetBondWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._namespace_contains

    @namespace_contains.setter
    def namespace_contains(self, namespace_contains):
        """Sets the namespace_contains of this VnetBondWhereInput.


        :param namespace_contains: The namespace_contains of this VnetBondWhereInput.  # noqa: E501
        :type namespace_contains: str
        """

        self._namespace_contains = namespace_contains

    @property
    def namespace_ends_with(self):
        """Gets the namespace_ends_with of this VnetBondWhereInput.  # noqa: E501


        :return: The namespace_ends_with of this VnetBondWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._namespace_ends_with

    @namespace_ends_with.setter
    def namespace_ends_with(self, namespace_ends_with):
        """Sets the namespace_ends_with of this VnetBondWhereInput.


        :param namespace_ends_with: The namespace_ends_with of this VnetBondWhereInput.  # noqa: E501
        :type namespace_ends_with: str
        """

        self._namespace_ends_with = namespace_ends_with

    @property
    def namespace_gt(self):
        """Gets the namespace_gt of this VnetBondWhereInput.  # noqa: E501


        :return: The namespace_gt of this VnetBondWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._namespace_gt

    @namespace_gt.setter
    def namespace_gt(self, namespace_gt):
        """Sets the namespace_gt of this VnetBondWhereInput.


        :param namespace_gt: The namespace_gt of this VnetBondWhereInput.  # noqa: E501
        :type namespace_gt: str
        """

        self._namespace_gt = namespace_gt

    @property
    def namespace_gte(self):
        """Gets the namespace_gte of this VnetBondWhereInput.  # noqa: E501


        :return: The namespace_gte of this VnetBondWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._namespace_gte

    @namespace_gte.setter
    def namespace_gte(self, namespace_gte):
        """Sets the namespace_gte of this VnetBondWhereInput.


        :param namespace_gte: The namespace_gte of this VnetBondWhereInput.  # noqa: E501
        :type namespace_gte: str
        """

        self._namespace_gte = namespace_gte

    @property
    def namespace_in(self):
        """Gets the namespace_in of this VnetBondWhereInput.  # noqa: E501


        :return: The namespace_in of this VnetBondWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._namespace_in

    @namespace_in.setter
    def namespace_in(self, namespace_in):
        """Sets the namespace_in of this VnetBondWhereInput.


        :param namespace_in: The namespace_in of this VnetBondWhereInput.  # noqa: E501
        :type namespace_in: list[str]
        """

        self._namespace_in = namespace_in

    @property
    def namespace_lt(self):
        """Gets the namespace_lt of this VnetBondWhereInput.  # noqa: E501


        :return: The namespace_lt of this VnetBondWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._namespace_lt

    @namespace_lt.setter
    def namespace_lt(self, namespace_lt):
        """Sets the namespace_lt of this VnetBondWhereInput.


        :param namespace_lt: The namespace_lt of this VnetBondWhereInput.  # noqa: E501
        :type namespace_lt: str
        """

        self._namespace_lt = namespace_lt

    @property
    def namespace_lte(self):
        """Gets the namespace_lte of this VnetBondWhereInput.  # noqa: E501


        :return: The namespace_lte of this VnetBondWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._namespace_lte

    @namespace_lte.setter
    def namespace_lte(self, namespace_lte):
        """Sets the namespace_lte of this VnetBondWhereInput.


        :param namespace_lte: The namespace_lte of this VnetBondWhereInput.  # noqa: E501
        :type namespace_lte: str
        """

        self._namespace_lte = namespace_lte

    @property
    def namespace_not(self):
        """Gets the namespace_not of this VnetBondWhereInput.  # noqa: E501


        :return: The namespace_not of this VnetBondWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._namespace_not

    @namespace_not.setter
    def namespace_not(self, namespace_not):
        """Sets the namespace_not of this VnetBondWhereInput.


        :param namespace_not: The namespace_not of this VnetBondWhereInput.  # noqa: E501
        :type namespace_not: str
        """

        self._namespace_not = namespace_not

    @property
    def namespace_not_contains(self):
        """Gets the namespace_not_contains of this VnetBondWhereInput.  # noqa: E501


        :return: The namespace_not_contains of this VnetBondWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._namespace_not_contains

    @namespace_not_contains.setter
    def namespace_not_contains(self, namespace_not_contains):
        """Sets the namespace_not_contains of this VnetBondWhereInput.


        :param namespace_not_contains: The namespace_not_contains of this VnetBondWhereInput.  # noqa: E501
        :type namespace_not_contains: str
        """

        self._namespace_not_contains = namespace_not_contains

    @property
    def namespace_not_ends_with(self):
        """Gets the namespace_not_ends_with of this VnetBondWhereInput.  # noqa: E501


        :return: The namespace_not_ends_with of this VnetBondWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._namespace_not_ends_with

    @namespace_not_ends_with.setter
    def namespace_not_ends_with(self, namespace_not_ends_with):
        """Sets the namespace_not_ends_with of this VnetBondWhereInput.


        :param namespace_not_ends_with: The namespace_not_ends_with of this VnetBondWhereInput.  # noqa: E501
        :type namespace_not_ends_with: str
        """

        self._namespace_not_ends_with = namespace_not_ends_with

    @property
    def namespace_not_in(self):
        """Gets the namespace_not_in of this VnetBondWhereInput.  # noqa: E501


        :return: The namespace_not_in of this VnetBondWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._namespace_not_in

    @namespace_not_in.setter
    def namespace_not_in(self, namespace_not_in):
        """Sets the namespace_not_in of this VnetBondWhereInput.


        :param namespace_not_in: The namespace_not_in of this VnetBondWhereInput.  # noqa: E501
        :type namespace_not_in: list[str]
        """

        self._namespace_not_in = namespace_not_in

    @property
    def namespace_not_starts_with(self):
        """Gets the namespace_not_starts_with of this VnetBondWhereInput.  # noqa: E501


        :return: The namespace_not_starts_with of this VnetBondWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._namespace_not_starts_with

    @namespace_not_starts_with.setter
    def namespace_not_starts_with(self, namespace_not_starts_with):
        """Sets the namespace_not_starts_with of this VnetBondWhereInput.


        :param namespace_not_starts_with: The namespace_not_starts_with of this VnetBondWhereInput.  # noqa: E501
        :type namespace_not_starts_with: str
        """

        self._namespace_not_starts_with = namespace_not_starts_with

    @property
    def namespace_starts_with(self):
        """Gets the namespace_starts_with of this VnetBondWhereInput.  # noqa: E501


        :return: The namespace_starts_with of this VnetBondWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._namespace_starts_with

    @namespace_starts_with.setter
    def namespace_starts_with(self, namespace_starts_with):
        """Sets the namespace_starts_with of this VnetBondWhereInput.


        :param namespace_starts_with: The namespace_starts_with of this VnetBondWhereInput.  # noqa: E501
        :type namespace_starts_with: str
        """

        self._namespace_starts_with = namespace_starts_with

    @property
    def vlan(self):
        """Gets the vlan of this VnetBondWhereInput.  # noqa: E501


        :return: The vlan of this VnetBondWhereInput.  # noqa: E501
        :rtype: VlanWhereInput
        """
        return self._vlan

    @vlan.setter
    def vlan(self, vlan):
        """Sets the vlan of this VnetBondWhereInput.


        :param vlan: The vlan of this VnetBondWhereInput.  # noqa: E501
        :type vlan: VlanWhereInput
        """

        self._vlan = vlan

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VnetBondWhereInput):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VnetBondWhereInput):
            return True

        return self.to_dict() != other.to_dict()
