# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class WitnessWhereInput(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        '_and': 'list[WitnessWhereInput]',
        '_not': 'list[WitnessWhereInput]',
        '_or': 'list[WitnessWhereInput]',
        'cluster': 'ClusterWhereInput',
        'cpu_hz_per_core': 'int',
        'cpu_hz_per_core_gt': 'int',
        'cpu_hz_per_core_gte': 'int',
        'cpu_hz_per_core_in': 'list[int]',
        'cpu_hz_per_core_lt': 'int',
        'cpu_hz_per_core_lte': 'int',
        'cpu_hz_per_core_not': 'int',
        'cpu_hz_per_core_not_in': 'list[int]',
        'data_ip': 'str',
        'data_ip_contains': 'str',
        'data_ip_ends_with': 'str',
        'data_ip_gt': 'str',
        'data_ip_gte': 'str',
        'data_ip_in': 'list[str]',
        'data_ip_lt': 'str',
        'data_ip_lte': 'str',
        'data_ip_not': 'str',
        'data_ip_not_contains': 'str',
        'data_ip_not_ends_with': 'str',
        'data_ip_not_in': 'list[str]',
        'data_ip_not_starts_with': 'str',
        'data_ip_starts_with': 'str',
        'id': 'str',
        'id_contains': 'str',
        'id_ends_with': 'str',
        'id_gt': 'str',
        'id_gte': 'str',
        'id_in': 'list[str]',
        'id_lt': 'str',
        'id_lte': 'str',
        'id_not': 'str',
        'id_not_contains': 'str',
        'id_not_ends_with': 'str',
        'id_not_in': 'list[str]',
        'id_not_starts_with': 'str',
        'id_starts_with': 'str',
        'local_id': 'str',
        'local_id_contains': 'str',
        'local_id_ends_with': 'str',
        'local_id_gt': 'str',
        'local_id_gte': 'str',
        'local_id_in': 'list[str]',
        'local_id_lt': 'str',
        'local_id_lte': 'str',
        'local_id_not': 'str',
        'local_id_not_contains': 'str',
        'local_id_not_ends_with': 'str',
        'local_id_not_in': 'list[str]',
        'local_id_not_starts_with': 'str',
        'local_id_starts_with': 'str',
        'management_ip': 'str',
        'management_ip_contains': 'str',
        'management_ip_ends_with': 'str',
        'management_ip_gt': 'str',
        'management_ip_gte': 'str',
        'management_ip_in': 'list[str]',
        'management_ip_lt': 'str',
        'management_ip_lte': 'str',
        'management_ip_not': 'str',
        'management_ip_not_contains': 'str',
        'management_ip_not_ends_with': 'str',
        'management_ip_not_in': 'list[str]',
        'management_ip_not_starts_with': 'str',
        'management_ip_starts_with': 'str',
        'name': 'str',
        'name_contains': 'str',
        'name_ends_with': 'str',
        'name_gt': 'str',
        'name_gte': 'str',
        'name_in': 'list[str]',
        'name_lt': 'str',
        'name_lte': 'str',
        'name_not': 'str',
        'name_not_contains': 'str',
        'name_not_ends_with': 'str',
        'name_not_in': 'list[str]',
        'name_not_starts_with': 'str',
        'name_starts_with': 'str',
        'system_data_capacity': 'int',
        'system_data_capacity_gt': 'int',
        'system_data_capacity_gte': 'int',
        'system_data_capacity_in': 'list[int]',
        'system_data_capacity_lt': 'int',
        'system_data_capacity_lte': 'int',
        'system_data_capacity_not': 'int',
        'system_data_capacity_not_in': 'list[int]',
        'system_used_data_space': 'int',
        'system_used_data_space_gt': 'int',
        'system_used_data_space_gte': 'int',
        'system_used_data_space_in': 'list[int]',
        'system_used_data_space_lt': 'int',
        'system_used_data_space_lte': 'int',
        'system_used_data_space_not': 'int',
        'system_used_data_space_not_in': 'list[int]',
        'total_cpu_cores': 'int',
        'total_cpu_cores_gt': 'int',
        'total_cpu_cores_gte': 'int',
        'total_cpu_cores_in': 'list[int]',
        'total_cpu_cores_lt': 'int',
        'total_cpu_cores_lte': 'int',
        'total_cpu_cores_not': 'int',
        'total_cpu_cores_not_in': 'list[int]',
        'total_cpu_hz': 'int',
        'total_cpu_hz_gt': 'int',
        'total_cpu_hz_gte': 'int',
        'total_cpu_hz_in': 'list[int]',
        'total_cpu_hz_lt': 'int',
        'total_cpu_hz_lte': 'int',
        'total_cpu_hz_not': 'int',
        'total_cpu_hz_not_in': 'list[int]',
        'total_memory_bytes': 'int',
        'total_memory_bytes_gt': 'int',
        'total_memory_bytes_gte': 'int',
        'total_memory_bytes_in': 'list[int]',
        'total_memory_bytes_lt': 'int',
        'total_memory_bytes_lte': 'int',
        'total_memory_bytes_not': 'int',
        'total_memory_bytes_not_in': 'list[int]'
    }

    attribute_map = {
        '_and': 'AND',
        '_not': 'NOT',
        '_or': 'OR',
        'cluster': 'cluster',
        'cpu_hz_per_core': 'cpu_hz_per_core',
        'cpu_hz_per_core_gt': 'cpu_hz_per_core_gt',
        'cpu_hz_per_core_gte': 'cpu_hz_per_core_gte',
        'cpu_hz_per_core_in': 'cpu_hz_per_core_in',
        'cpu_hz_per_core_lt': 'cpu_hz_per_core_lt',
        'cpu_hz_per_core_lte': 'cpu_hz_per_core_lte',
        'cpu_hz_per_core_not': 'cpu_hz_per_core_not',
        'cpu_hz_per_core_not_in': 'cpu_hz_per_core_not_in',
        'data_ip': 'data_ip',
        'data_ip_contains': 'data_ip_contains',
        'data_ip_ends_with': 'data_ip_ends_with',
        'data_ip_gt': 'data_ip_gt',
        'data_ip_gte': 'data_ip_gte',
        'data_ip_in': 'data_ip_in',
        'data_ip_lt': 'data_ip_lt',
        'data_ip_lte': 'data_ip_lte',
        'data_ip_not': 'data_ip_not',
        'data_ip_not_contains': 'data_ip_not_contains',
        'data_ip_not_ends_with': 'data_ip_not_ends_with',
        'data_ip_not_in': 'data_ip_not_in',
        'data_ip_not_starts_with': 'data_ip_not_starts_with',
        'data_ip_starts_with': 'data_ip_starts_with',
        'id': 'id',
        'id_contains': 'id_contains',
        'id_ends_with': 'id_ends_with',
        'id_gt': 'id_gt',
        'id_gte': 'id_gte',
        'id_in': 'id_in',
        'id_lt': 'id_lt',
        'id_lte': 'id_lte',
        'id_not': 'id_not',
        'id_not_contains': 'id_not_contains',
        'id_not_ends_with': 'id_not_ends_with',
        'id_not_in': 'id_not_in',
        'id_not_starts_with': 'id_not_starts_with',
        'id_starts_with': 'id_starts_with',
        'local_id': 'local_id',
        'local_id_contains': 'local_id_contains',
        'local_id_ends_with': 'local_id_ends_with',
        'local_id_gt': 'local_id_gt',
        'local_id_gte': 'local_id_gte',
        'local_id_in': 'local_id_in',
        'local_id_lt': 'local_id_lt',
        'local_id_lte': 'local_id_lte',
        'local_id_not': 'local_id_not',
        'local_id_not_contains': 'local_id_not_contains',
        'local_id_not_ends_with': 'local_id_not_ends_with',
        'local_id_not_in': 'local_id_not_in',
        'local_id_not_starts_with': 'local_id_not_starts_with',
        'local_id_starts_with': 'local_id_starts_with',
        'management_ip': 'management_ip',
        'management_ip_contains': 'management_ip_contains',
        'management_ip_ends_with': 'management_ip_ends_with',
        'management_ip_gt': 'management_ip_gt',
        'management_ip_gte': 'management_ip_gte',
        'management_ip_in': 'management_ip_in',
        'management_ip_lt': 'management_ip_lt',
        'management_ip_lte': 'management_ip_lte',
        'management_ip_not': 'management_ip_not',
        'management_ip_not_contains': 'management_ip_not_contains',
        'management_ip_not_ends_with': 'management_ip_not_ends_with',
        'management_ip_not_in': 'management_ip_not_in',
        'management_ip_not_starts_with': 'management_ip_not_starts_with',
        'management_ip_starts_with': 'management_ip_starts_with',
        'name': 'name',
        'name_contains': 'name_contains',
        'name_ends_with': 'name_ends_with',
        'name_gt': 'name_gt',
        'name_gte': 'name_gte',
        'name_in': 'name_in',
        'name_lt': 'name_lt',
        'name_lte': 'name_lte',
        'name_not': 'name_not',
        'name_not_contains': 'name_not_contains',
        'name_not_ends_with': 'name_not_ends_with',
        'name_not_in': 'name_not_in',
        'name_not_starts_with': 'name_not_starts_with',
        'name_starts_with': 'name_starts_with',
        'system_data_capacity': 'system_data_capacity',
        'system_data_capacity_gt': 'system_data_capacity_gt',
        'system_data_capacity_gte': 'system_data_capacity_gte',
        'system_data_capacity_in': 'system_data_capacity_in',
        'system_data_capacity_lt': 'system_data_capacity_lt',
        'system_data_capacity_lte': 'system_data_capacity_lte',
        'system_data_capacity_not': 'system_data_capacity_not',
        'system_data_capacity_not_in': 'system_data_capacity_not_in',
        'system_used_data_space': 'system_used_data_space',
        'system_used_data_space_gt': 'system_used_data_space_gt',
        'system_used_data_space_gte': 'system_used_data_space_gte',
        'system_used_data_space_in': 'system_used_data_space_in',
        'system_used_data_space_lt': 'system_used_data_space_lt',
        'system_used_data_space_lte': 'system_used_data_space_lte',
        'system_used_data_space_not': 'system_used_data_space_not',
        'system_used_data_space_not_in': 'system_used_data_space_not_in',
        'total_cpu_cores': 'total_cpu_cores',
        'total_cpu_cores_gt': 'total_cpu_cores_gt',
        'total_cpu_cores_gte': 'total_cpu_cores_gte',
        'total_cpu_cores_in': 'total_cpu_cores_in',
        'total_cpu_cores_lt': 'total_cpu_cores_lt',
        'total_cpu_cores_lte': 'total_cpu_cores_lte',
        'total_cpu_cores_not': 'total_cpu_cores_not',
        'total_cpu_cores_not_in': 'total_cpu_cores_not_in',
        'total_cpu_hz': 'total_cpu_hz',
        'total_cpu_hz_gt': 'total_cpu_hz_gt',
        'total_cpu_hz_gte': 'total_cpu_hz_gte',
        'total_cpu_hz_in': 'total_cpu_hz_in',
        'total_cpu_hz_lt': 'total_cpu_hz_lt',
        'total_cpu_hz_lte': 'total_cpu_hz_lte',
        'total_cpu_hz_not': 'total_cpu_hz_not',
        'total_cpu_hz_not_in': 'total_cpu_hz_not_in',
        'total_memory_bytes': 'total_memory_bytes',
        'total_memory_bytes_gt': 'total_memory_bytes_gt',
        'total_memory_bytes_gte': 'total_memory_bytes_gte',
        'total_memory_bytes_in': 'total_memory_bytes_in',
        'total_memory_bytes_lt': 'total_memory_bytes_lt',
        'total_memory_bytes_lte': 'total_memory_bytes_lte',
        'total_memory_bytes_not': 'total_memory_bytes_not',
        'total_memory_bytes_not_in': 'total_memory_bytes_not_in'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """WitnessWhereInput - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self.__and = None
        self.__not = None
        self.__or = None
        self._cluster = None
        self._cpu_hz_per_core = None
        self._cpu_hz_per_core_gt = None
        self._cpu_hz_per_core_gte = None
        self._cpu_hz_per_core_in = None
        self._cpu_hz_per_core_lt = None
        self._cpu_hz_per_core_lte = None
        self._cpu_hz_per_core_not = None
        self._cpu_hz_per_core_not_in = None
        self._data_ip = None
        self._data_ip_contains = None
        self._data_ip_ends_with = None
        self._data_ip_gt = None
        self._data_ip_gte = None
        self._data_ip_in = None
        self._data_ip_lt = None
        self._data_ip_lte = None
        self._data_ip_not = None
        self._data_ip_not_contains = None
        self._data_ip_not_ends_with = None
        self._data_ip_not_in = None
        self._data_ip_not_starts_with = None
        self._data_ip_starts_with = None
        self._id = None
        self._id_contains = None
        self._id_ends_with = None
        self._id_gt = None
        self._id_gte = None
        self._id_in = None
        self._id_lt = None
        self._id_lte = None
        self._id_not = None
        self._id_not_contains = None
        self._id_not_ends_with = None
        self._id_not_in = None
        self._id_not_starts_with = None
        self._id_starts_with = None
        self._local_id = None
        self._local_id_contains = None
        self._local_id_ends_with = None
        self._local_id_gt = None
        self._local_id_gte = None
        self._local_id_in = None
        self._local_id_lt = None
        self._local_id_lte = None
        self._local_id_not = None
        self._local_id_not_contains = None
        self._local_id_not_ends_with = None
        self._local_id_not_in = None
        self._local_id_not_starts_with = None
        self._local_id_starts_with = None
        self._management_ip = None
        self._management_ip_contains = None
        self._management_ip_ends_with = None
        self._management_ip_gt = None
        self._management_ip_gte = None
        self._management_ip_in = None
        self._management_ip_lt = None
        self._management_ip_lte = None
        self._management_ip_not = None
        self._management_ip_not_contains = None
        self._management_ip_not_ends_with = None
        self._management_ip_not_in = None
        self._management_ip_not_starts_with = None
        self._management_ip_starts_with = None
        self._name = None
        self._name_contains = None
        self._name_ends_with = None
        self._name_gt = None
        self._name_gte = None
        self._name_in = None
        self._name_lt = None
        self._name_lte = None
        self._name_not = None
        self._name_not_contains = None
        self._name_not_ends_with = None
        self._name_not_in = None
        self._name_not_starts_with = None
        self._name_starts_with = None
        self._system_data_capacity = None
        self._system_data_capacity_gt = None
        self._system_data_capacity_gte = None
        self._system_data_capacity_in = None
        self._system_data_capacity_lt = None
        self._system_data_capacity_lte = None
        self._system_data_capacity_not = None
        self._system_data_capacity_not_in = None
        self._system_used_data_space = None
        self._system_used_data_space_gt = None
        self._system_used_data_space_gte = None
        self._system_used_data_space_in = None
        self._system_used_data_space_lt = None
        self._system_used_data_space_lte = None
        self._system_used_data_space_not = None
        self._system_used_data_space_not_in = None
        self._total_cpu_cores = None
        self._total_cpu_cores_gt = None
        self._total_cpu_cores_gte = None
        self._total_cpu_cores_in = None
        self._total_cpu_cores_lt = None
        self._total_cpu_cores_lte = None
        self._total_cpu_cores_not = None
        self._total_cpu_cores_not_in = None
        self._total_cpu_hz = None
        self._total_cpu_hz_gt = None
        self._total_cpu_hz_gte = None
        self._total_cpu_hz_in = None
        self._total_cpu_hz_lt = None
        self._total_cpu_hz_lte = None
        self._total_cpu_hz_not = None
        self._total_cpu_hz_not_in = None
        self._total_memory_bytes = None
        self._total_memory_bytes_gt = None
        self._total_memory_bytes_gte = None
        self._total_memory_bytes_in = None
        self._total_memory_bytes_lt = None
        self._total_memory_bytes_lte = None
        self._total_memory_bytes_not = None
        self._total_memory_bytes_not_in = None
        self.discriminator = None

        self._and = kwargs.get("_and", None)
        self._not = kwargs.get("_not", None)
        self._or = kwargs.get("_or", None)
        self.cluster = kwargs.get("cluster", None)
        self.cpu_hz_per_core = kwargs.get("cpu_hz_per_core", None)
        self.cpu_hz_per_core_gt = kwargs.get("cpu_hz_per_core_gt", None)
        self.cpu_hz_per_core_gte = kwargs.get("cpu_hz_per_core_gte", None)
        self.cpu_hz_per_core_in = kwargs.get("cpu_hz_per_core_in", None)
        self.cpu_hz_per_core_lt = kwargs.get("cpu_hz_per_core_lt", None)
        self.cpu_hz_per_core_lte = kwargs.get("cpu_hz_per_core_lte", None)
        self.cpu_hz_per_core_not = kwargs.get("cpu_hz_per_core_not", None)
        self.cpu_hz_per_core_not_in = kwargs.get("cpu_hz_per_core_not_in", None)
        self.data_ip = kwargs.get("data_ip", None)
        self.data_ip_contains = kwargs.get("data_ip_contains", None)
        self.data_ip_ends_with = kwargs.get("data_ip_ends_with", None)
        self.data_ip_gt = kwargs.get("data_ip_gt", None)
        self.data_ip_gte = kwargs.get("data_ip_gte", None)
        self.data_ip_in = kwargs.get("data_ip_in", None)
        self.data_ip_lt = kwargs.get("data_ip_lt", None)
        self.data_ip_lte = kwargs.get("data_ip_lte", None)
        self.data_ip_not = kwargs.get("data_ip_not", None)
        self.data_ip_not_contains = kwargs.get("data_ip_not_contains", None)
        self.data_ip_not_ends_with = kwargs.get("data_ip_not_ends_with", None)
        self.data_ip_not_in = kwargs.get("data_ip_not_in", None)
        self.data_ip_not_starts_with = kwargs.get("data_ip_not_starts_with", None)
        self.data_ip_starts_with = kwargs.get("data_ip_starts_with", None)
        self.id = kwargs.get("id", None)
        self.id_contains = kwargs.get("id_contains", None)
        self.id_ends_with = kwargs.get("id_ends_with", None)
        self.id_gt = kwargs.get("id_gt", None)
        self.id_gte = kwargs.get("id_gte", None)
        self.id_in = kwargs.get("id_in", None)
        self.id_lt = kwargs.get("id_lt", None)
        self.id_lte = kwargs.get("id_lte", None)
        self.id_not = kwargs.get("id_not", None)
        self.id_not_contains = kwargs.get("id_not_contains", None)
        self.id_not_ends_with = kwargs.get("id_not_ends_with", None)
        self.id_not_in = kwargs.get("id_not_in", None)
        self.id_not_starts_with = kwargs.get("id_not_starts_with", None)
        self.id_starts_with = kwargs.get("id_starts_with", None)
        self.local_id = kwargs.get("local_id", None)
        self.local_id_contains = kwargs.get("local_id_contains", None)
        self.local_id_ends_with = kwargs.get("local_id_ends_with", None)
        self.local_id_gt = kwargs.get("local_id_gt", None)
        self.local_id_gte = kwargs.get("local_id_gte", None)
        self.local_id_in = kwargs.get("local_id_in", None)
        self.local_id_lt = kwargs.get("local_id_lt", None)
        self.local_id_lte = kwargs.get("local_id_lte", None)
        self.local_id_not = kwargs.get("local_id_not", None)
        self.local_id_not_contains = kwargs.get("local_id_not_contains", None)
        self.local_id_not_ends_with = kwargs.get("local_id_not_ends_with", None)
        self.local_id_not_in = kwargs.get("local_id_not_in", None)
        self.local_id_not_starts_with = kwargs.get("local_id_not_starts_with", None)
        self.local_id_starts_with = kwargs.get("local_id_starts_with", None)
        self.management_ip = kwargs.get("management_ip", None)
        self.management_ip_contains = kwargs.get("management_ip_contains", None)
        self.management_ip_ends_with = kwargs.get("management_ip_ends_with", None)
        self.management_ip_gt = kwargs.get("management_ip_gt", None)
        self.management_ip_gte = kwargs.get("management_ip_gte", None)
        self.management_ip_in = kwargs.get("management_ip_in", None)
        self.management_ip_lt = kwargs.get("management_ip_lt", None)
        self.management_ip_lte = kwargs.get("management_ip_lte", None)
        self.management_ip_not = kwargs.get("management_ip_not", None)
        self.management_ip_not_contains = kwargs.get("management_ip_not_contains", None)
        self.management_ip_not_ends_with = kwargs.get("management_ip_not_ends_with", None)
        self.management_ip_not_in = kwargs.get("management_ip_not_in", None)
        self.management_ip_not_starts_with = kwargs.get("management_ip_not_starts_with", None)
        self.management_ip_starts_with = kwargs.get("management_ip_starts_with", None)
        self.name = kwargs.get("name", None)
        self.name_contains = kwargs.get("name_contains", None)
        self.name_ends_with = kwargs.get("name_ends_with", None)
        self.name_gt = kwargs.get("name_gt", None)
        self.name_gte = kwargs.get("name_gte", None)
        self.name_in = kwargs.get("name_in", None)
        self.name_lt = kwargs.get("name_lt", None)
        self.name_lte = kwargs.get("name_lte", None)
        self.name_not = kwargs.get("name_not", None)
        self.name_not_contains = kwargs.get("name_not_contains", None)
        self.name_not_ends_with = kwargs.get("name_not_ends_with", None)
        self.name_not_in = kwargs.get("name_not_in", None)
        self.name_not_starts_with = kwargs.get("name_not_starts_with", None)
        self.name_starts_with = kwargs.get("name_starts_with", None)
        self.system_data_capacity = kwargs.get("system_data_capacity", None)
        self.system_data_capacity_gt = kwargs.get("system_data_capacity_gt", None)
        self.system_data_capacity_gte = kwargs.get("system_data_capacity_gte", None)
        self.system_data_capacity_in = kwargs.get("system_data_capacity_in", None)
        self.system_data_capacity_lt = kwargs.get("system_data_capacity_lt", None)
        self.system_data_capacity_lte = kwargs.get("system_data_capacity_lte", None)
        self.system_data_capacity_not = kwargs.get("system_data_capacity_not", None)
        self.system_data_capacity_not_in = kwargs.get("system_data_capacity_not_in", None)
        self.system_used_data_space = kwargs.get("system_used_data_space", None)
        self.system_used_data_space_gt = kwargs.get("system_used_data_space_gt", None)
        self.system_used_data_space_gte = kwargs.get("system_used_data_space_gte", None)
        self.system_used_data_space_in = kwargs.get("system_used_data_space_in", None)
        self.system_used_data_space_lt = kwargs.get("system_used_data_space_lt", None)
        self.system_used_data_space_lte = kwargs.get("system_used_data_space_lte", None)
        self.system_used_data_space_not = kwargs.get("system_used_data_space_not", None)
        self.system_used_data_space_not_in = kwargs.get("system_used_data_space_not_in", None)
        self.total_cpu_cores = kwargs.get("total_cpu_cores", None)
        self.total_cpu_cores_gt = kwargs.get("total_cpu_cores_gt", None)
        self.total_cpu_cores_gte = kwargs.get("total_cpu_cores_gte", None)
        self.total_cpu_cores_in = kwargs.get("total_cpu_cores_in", None)
        self.total_cpu_cores_lt = kwargs.get("total_cpu_cores_lt", None)
        self.total_cpu_cores_lte = kwargs.get("total_cpu_cores_lte", None)
        self.total_cpu_cores_not = kwargs.get("total_cpu_cores_not", None)
        self.total_cpu_cores_not_in = kwargs.get("total_cpu_cores_not_in", None)
        self.total_cpu_hz = kwargs.get("total_cpu_hz", None)
        self.total_cpu_hz_gt = kwargs.get("total_cpu_hz_gt", None)
        self.total_cpu_hz_gte = kwargs.get("total_cpu_hz_gte", None)
        self.total_cpu_hz_in = kwargs.get("total_cpu_hz_in", None)
        self.total_cpu_hz_lt = kwargs.get("total_cpu_hz_lt", None)
        self.total_cpu_hz_lte = kwargs.get("total_cpu_hz_lte", None)
        self.total_cpu_hz_not = kwargs.get("total_cpu_hz_not", None)
        self.total_cpu_hz_not_in = kwargs.get("total_cpu_hz_not_in", None)
        self.total_memory_bytes = kwargs.get("total_memory_bytes", None)
        self.total_memory_bytes_gt = kwargs.get("total_memory_bytes_gt", None)
        self.total_memory_bytes_gte = kwargs.get("total_memory_bytes_gte", None)
        self.total_memory_bytes_in = kwargs.get("total_memory_bytes_in", None)
        self.total_memory_bytes_lt = kwargs.get("total_memory_bytes_lt", None)
        self.total_memory_bytes_lte = kwargs.get("total_memory_bytes_lte", None)
        self.total_memory_bytes_not = kwargs.get("total_memory_bytes_not", None)
        self.total_memory_bytes_not_in = kwargs.get("total_memory_bytes_not_in", None)

    @property
    def _and(self):
        """Gets the _and of this WitnessWhereInput.  # noqa: E501


        :return: The _and of this WitnessWhereInput.  # noqa: E501
        :rtype: list[WitnessWhereInput]
        """
        return self.__and

    @_and.setter
    def _and(self, _and):
        """Sets the _and of this WitnessWhereInput.


        :param _and: The _and of this WitnessWhereInput.  # noqa: E501
        :type _and: list[WitnessWhereInput]
        """

        self.__and = _and

    @property
    def _not(self):
        """Gets the _not of this WitnessWhereInput.  # noqa: E501


        :return: The _not of this WitnessWhereInput.  # noqa: E501
        :rtype: list[WitnessWhereInput]
        """
        return self.__not

    @_not.setter
    def _not(self, _not):
        """Sets the _not of this WitnessWhereInput.


        :param _not: The _not of this WitnessWhereInput.  # noqa: E501
        :type _not: list[WitnessWhereInput]
        """

        self.__not = _not

    @property
    def _or(self):
        """Gets the _or of this WitnessWhereInput.  # noqa: E501


        :return: The _or of this WitnessWhereInput.  # noqa: E501
        :rtype: list[WitnessWhereInput]
        """
        return self.__or

    @_or.setter
    def _or(self, _or):
        """Sets the _or of this WitnessWhereInput.


        :param _or: The _or of this WitnessWhereInput.  # noqa: E501
        :type _or: list[WitnessWhereInput]
        """

        self.__or = _or

    @property
    def cluster(self):
        """Gets the cluster of this WitnessWhereInput.  # noqa: E501


        :return: The cluster of this WitnessWhereInput.  # noqa: E501
        :rtype: ClusterWhereInput
        """
        return self._cluster

    @cluster.setter
    def cluster(self, cluster):
        """Sets the cluster of this WitnessWhereInput.


        :param cluster: The cluster of this WitnessWhereInput.  # noqa: E501
        :type cluster: ClusterWhereInput
        """

        self._cluster = cluster

    @property
    def cpu_hz_per_core(self):
        """Gets the cpu_hz_per_core of this WitnessWhereInput.  # noqa: E501


        :return: The cpu_hz_per_core of this WitnessWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._cpu_hz_per_core

    @cpu_hz_per_core.setter
    def cpu_hz_per_core(self, cpu_hz_per_core):
        """Sets the cpu_hz_per_core of this WitnessWhereInput.


        :param cpu_hz_per_core: The cpu_hz_per_core of this WitnessWhereInput.  # noqa: E501
        :type cpu_hz_per_core: int
        """

        self._cpu_hz_per_core = cpu_hz_per_core

    @property
    def cpu_hz_per_core_gt(self):
        """Gets the cpu_hz_per_core_gt of this WitnessWhereInput.  # noqa: E501


        :return: The cpu_hz_per_core_gt of this WitnessWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._cpu_hz_per_core_gt

    @cpu_hz_per_core_gt.setter
    def cpu_hz_per_core_gt(self, cpu_hz_per_core_gt):
        """Sets the cpu_hz_per_core_gt of this WitnessWhereInput.


        :param cpu_hz_per_core_gt: The cpu_hz_per_core_gt of this WitnessWhereInput.  # noqa: E501
        :type cpu_hz_per_core_gt: int
        """

        self._cpu_hz_per_core_gt = cpu_hz_per_core_gt

    @property
    def cpu_hz_per_core_gte(self):
        """Gets the cpu_hz_per_core_gte of this WitnessWhereInput.  # noqa: E501


        :return: The cpu_hz_per_core_gte of this WitnessWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._cpu_hz_per_core_gte

    @cpu_hz_per_core_gte.setter
    def cpu_hz_per_core_gte(self, cpu_hz_per_core_gte):
        """Sets the cpu_hz_per_core_gte of this WitnessWhereInput.


        :param cpu_hz_per_core_gte: The cpu_hz_per_core_gte of this WitnessWhereInput.  # noqa: E501
        :type cpu_hz_per_core_gte: int
        """

        self._cpu_hz_per_core_gte = cpu_hz_per_core_gte

    @property
    def cpu_hz_per_core_in(self):
        """Gets the cpu_hz_per_core_in of this WitnessWhereInput.  # noqa: E501


        :return: The cpu_hz_per_core_in of this WitnessWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._cpu_hz_per_core_in

    @cpu_hz_per_core_in.setter
    def cpu_hz_per_core_in(self, cpu_hz_per_core_in):
        """Sets the cpu_hz_per_core_in of this WitnessWhereInput.


        :param cpu_hz_per_core_in: The cpu_hz_per_core_in of this WitnessWhereInput.  # noqa: E501
        :type cpu_hz_per_core_in: list[int]
        """

        self._cpu_hz_per_core_in = cpu_hz_per_core_in

    @property
    def cpu_hz_per_core_lt(self):
        """Gets the cpu_hz_per_core_lt of this WitnessWhereInput.  # noqa: E501


        :return: The cpu_hz_per_core_lt of this WitnessWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._cpu_hz_per_core_lt

    @cpu_hz_per_core_lt.setter
    def cpu_hz_per_core_lt(self, cpu_hz_per_core_lt):
        """Sets the cpu_hz_per_core_lt of this WitnessWhereInput.


        :param cpu_hz_per_core_lt: The cpu_hz_per_core_lt of this WitnessWhereInput.  # noqa: E501
        :type cpu_hz_per_core_lt: int
        """

        self._cpu_hz_per_core_lt = cpu_hz_per_core_lt

    @property
    def cpu_hz_per_core_lte(self):
        """Gets the cpu_hz_per_core_lte of this WitnessWhereInput.  # noqa: E501


        :return: The cpu_hz_per_core_lte of this WitnessWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._cpu_hz_per_core_lte

    @cpu_hz_per_core_lte.setter
    def cpu_hz_per_core_lte(self, cpu_hz_per_core_lte):
        """Sets the cpu_hz_per_core_lte of this WitnessWhereInput.


        :param cpu_hz_per_core_lte: The cpu_hz_per_core_lte of this WitnessWhereInput.  # noqa: E501
        :type cpu_hz_per_core_lte: int
        """

        self._cpu_hz_per_core_lte = cpu_hz_per_core_lte

    @property
    def cpu_hz_per_core_not(self):
        """Gets the cpu_hz_per_core_not of this WitnessWhereInput.  # noqa: E501


        :return: The cpu_hz_per_core_not of this WitnessWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._cpu_hz_per_core_not

    @cpu_hz_per_core_not.setter
    def cpu_hz_per_core_not(self, cpu_hz_per_core_not):
        """Sets the cpu_hz_per_core_not of this WitnessWhereInput.


        :param cpu_hz_per_core_not: The cpu_hz_per_core_not of this WitnessWhereInput.  # noqa: E501
        :type cpu_hz_per_core_not: int
        """

        self._cpu_hz_per_core_not = cpu_hz_per_core_not

    @property
    def cpu_hz_per_core_not_in(self):
        """Gets the cpu_hz_per_core_not_in of this WitnessWhereInput.  # noqa: E501


        :return: The cpu_hz_per_core_not_in of this WitnessWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._cpu_hz_per_core_not_in

    @cpu_hz_per_core_not_in.setter
    def cpu_hz_per_core_not_in(self, cpu_hz_per_core_not_in):
        """Sets the cpu_hz_per_core_not_in of this WitnessWhereInput.


        :param cpu_hz_per_core_not_in: The cpu_hz_per_core_not_in of this WitnessWhereInput.  # noqa: E501
        :type cpu_hz_per_core_not_in: list[int]
        """

        self._cpu_hz_per_core_not_in = cpu_hz_per_core_not_in

    @property
    def data_ip(self):
        """Gets the data_ip of this WitnessWhereInput.  # noqa: E501


        :return: The data_ip of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._data_ip

    @data_ip.setter
    def data_ip(self, data_ip):
        """Sets the data_ip of this WitnessWhereInput.


        :param data_ip: The data_ip of this WitnessWhereInput.  # noqa: E501
        :type data_ip: str
        """

        self._data_ip = data_ip

    @property
    def data_ip_contains(self):
        """Gets the data_ip_contains of this WitnessWhereInput.  # noqa: E501


        :return: The data_ip_contains of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._data_ip_contains

    @data_ip_contains.setter
    def data_ip_contains(self, data_ip_contains):
        """Sets the data_ip_contains of this WitnessWhereInput.


        :param data_ip_contains: The data_ip_contains of this WitnessWhereInput.  # noqa: E501
        :type data_ip_contains: str
        """

        self._data_ip_contains = data_ip_contains

    @property
    def data_ip_ends_with(self):
        """Gets the data_ip_ends_with of this WitnessWhereInput.  # noqa: E501


        :return: The data_ip_ends_with of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._data_ip_ends_with

    @data_ip_ends_with.setter
    def data_ip_ends_with(self, data_ip_ends_with):
        """Sets the data_ip_ends_with of this WitnessWhereInput.


        :param data_ip_ends_with: The data_ip_ends_with of this WitnessWhereInput.  # noqa: E501
        :type data_ip_ends_with: str
        """

        self._data_ip_ends_with = data_ip_ends_with

    @property
    def data_ip_gt(self):
        """Gets the data_ip_gt of this WitnessWhereInput.  # noqa: E501


        :return: The data_ip_gt of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._data_ip_gt

    @data_ip_gt.setter
    def data_ip_gt(self, data_ip_gt):
        """Sets the data_ip_gt of this WitnessWhereInput.


        :param data_ip_gt: The data_ip_gt of this WitnessWhereInput.  # noqa: E501
        :type data_ip_gt: str
        """

        self._data_ip_gt = data_ip_gt

    @property
    def data_ip_gte(self):
        """Gets the data_ip_gte of this WitnessWhereInput.  # noqa: E501


        :return: The data_ip_gte of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._data_ip_gte

    @data_ip_gte.setter
    def data_ip_gte(self, data_ip_gte):
        """Sets the data_ip_gte of this WitnessWhereInput.


        :param data_ip_gte: The data_ip_gte of this WitnessWhereInput.  # noqa: E501
        :type data_ip_gte: str
        """

        self._data_ip_gte = data_ip_gte

    @property
    def data_ip_in(self):
        """Gets the data_ip_in of this WitnessWhereInput.  # noqa: E501


        :return: The data_ip_in of this WitnessWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._data_ip_in

    @data_ip_in.setter
    def data_ip_in(self, data_ip_in):
        """Sets the data_ip_in of this WitnessWhereInput.


        :param data_ip_in: The data_ip_in of this WitnessWhereInput.  # noqa: E501
        :type data_ip_in: list[str]
        """

        self._data_ip_in = data_ip_in

    @property
    def data_ip_lt(self):
        """Gets the data_ip_lt of this WitnessWhereInput.  # noqa: E501


        :return: The data_ip_lt of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._data_ip_lt

    @data_ip_lt.setter
    def data_ip_lt(self, data_ip_lt):
        """Sets the data_ip_lt of this WitnessWhereInput.


        :param data_ip_lt: The data_ip_lt of this WitnessWhereInput.  # noqa: E501
        :type data_ip_lt: str
        """

        self._data_ip_lt = data_ip_lt

    @property
    def data_ip_lte(self):
        """Gets the data_ip_lte of this WitnessWhereInput.  # noqa: E501


        :return: The data_ip_lte of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._data_ip_lte

    @data_ip_lte.setter
    def data_ip_lte(self, data_ip_lte):
        """Sets the data_ip_lte of this WitnessWhereInput.


        :param data_ip_lte: The data_ip_lte of this WitnessWhereInput.  # noqa: E501
        :type data_ip_lte: str
        """

        self._data_ip_lte = data_ip_lte

    @property
    def data_ip_not(self):
        """Gets the data_ip_not of this WitnessWhereInput.  # noqa: E501


        :return: The data_ip_not of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._data_ip_not

    @data_ip_not.setter
    def data_ip_not(self, data_ip_not):
        """Sets the data_ip_not of this WitnessWhereInput.


        :param data_ip_not: The data_ip_not of this WitnessWhereInput.  # noqa: E501
        :type data_ip_not: str
        """

        self._data_ip_not = data_ip_not

    @property
    def data_ip_not_contains(self):
        """Gets the data_ip_not_contains of this WitnessWhereInput.  # noqa: E501


        :return: The data_ip_not_contains of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._data_ip_not_contains

    @data_ip_not_contains.setter
    def data_ip_not_contains(self, data_ip_not_contains):
        """Sets the data_ip_not_contains of this WitnessWhereInput.


        :param data_ip_not_contains: The data_ip_not_contains of this WitnessWhereInput.  # noqa: E501
        :type data_ip_not_contains: str
        """

        self._data_ip_not_contains = data_ip_not_contains

    @property
    def data_ip_not_ends_with(self):
        """Gets the data_ip_not_ends_with of this WitnessWhereInput.  # noqa: E501


        :return: The data_ip_not_ends_with of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._data_ip_not_ends_with

    @data_ip_not_ends_with.setter
    def data_ip_not_ends_with(self, data_ip_not_ends_with):
        """Sets the data_ip_not_ends_with of this WitnessWhereInput.


        :param data_ip_not_ends_with: The data_ip_not_ends_with of this WitnessWhereInput.  # noqa: E501
        :type data_ip_not_ends_with: str
        """

        self._data_ip_not_ends_with = data_ip_not_ends_with

    @property
    def data_ip_not_in(self):
        """Gets the data_ip_not_in of this WitnessWhereInput.  # noqa: E501


        :return: The data_ip_not_in of this WitnessWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._data_ip_not_in

    @data_ip_not_in.setter
    def data_ip_not_in(self, data_ip_not_in):
        """Sets the data_ip_not_in of this WitnessWhereInput.


        :param data_ip_not_in: The data_ip_not_in of this WitnessWhereInput.  # noqa: E501
        :type data_ip_not_in: list[str]
        """

        self._data_ip_not_in = data_ip_not_in

    @property
    def data_ip_not_starts_with(self):
        """Gets the data_ip_not_starts_with of this WitnessWhereInput.  # noqa: E501


        :return: The data_ip_not_starts_with of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._data_ip_not_starts_with

    @data_ip_not_starts_with.setter
    def data_ip_not_starts_with(self, data_ip_not_starts_with):
        """Sets the data_ip_not_starts_with of this WitnessWhereInput.


        :param data_ip_not_starts_with: The data_ip_not_starts_with of this WitnessWhereInput.  # noqa: E501
        :type data_ip_not_starts_with: str
        """

        self._data_ip_not_starts_with = data_ip_not_starts_with

    @property
    def data_ip_starts_with(self):
        """Gets the data_ip_starts_with of this WitnessWhereInput.  # noqa: E501


        :return: The data_ip_starts_with of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._data_ip_starts_with

    @data_ip_starts_with.setter
    def data_ip_starts_with(self, data_ip_starts_with):
        """Sets the data_ip_starts_with of this WitnessWhereInput.


        :param data_ip_starts_with: The data_ip_starts_with of this WitnessWhereInput.  # noqa: E501
        :type data_ip_starts_with: str
        """

        self._data_ip_starts_with = data_ip_starts_with

    @property
    def id(self):
        """Gets the id of this WitnessWhereInput.  # noqa: E501


        :return: The id of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this WitnessWhereInput.


        :param id: The id of this WitnessWhereInput.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def id_contains(self):
        """Gets the id_contains of this WitnessWhereInput.  # noqa: E501


        :return: The id_contains of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_contains

    @id_contains.setter
    def id_contains(self, id_contains):
        """Sets the id_contains of this WitnessWhereInput.


        :param id_contains: The id_contains of this WitnessWhereInput.  # noqa: E501
        :type id_contains: str
        """

        self._id_contains = id_contains

    @property
    def id_ends_with(self):
        """Gets the id_ends_with of this WitnessWhereInput.  # noqa: E501


        :return: The id_ends_with of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_ends_with

    @id_ends_with.setter
    def id_ends_with(self, id_ends_with):
        """Sets the id_ends_with of this WitnessWhereInput.


        :param id_ends_with: The id_ends_with of this WitnessWhereInput.  # noqa: E501
        :type id_ends_with: str
        """

        self._id_ends_with = id_ends_with

    @property
    def id_gt(self):
        """Gets the id_gt of this WitnessWhereInput.  # noqa: E501


        :return: The id_gt of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gt

    @id_gt.setter
    def id_gt(self, id_gt):
        """Sets the id_gt of this WitnessWhereInput.


        :param id_gt: The id_gt of this WitnessWhereInput.  # noqa: E501
        :type id_gt: str
        """

        self._id_gt = id_gt

    @property
    def id_gte(self):
        """Gets the id_gte of this WitnessWhereInput.  # noqa: E501


        :return: The id_gte of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gte

    @id_gte.setter
    def id_gte(self, id_gte):
        """Sets the id_gte of this WitnessWhereInput.


        :param id_gte: The id_gte of this WitnessWhereInput.  # noqa: E501
        :type id_gte: str
        """

        self._id_gte = id_gte

    @property
    def id_in(self):
        """Gets the id_in of this WitnessWhereInput.  # noqa: E501


        :return: The id_in of this WitnessWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_in

    @id_in.setter
    def id_in(self, id_in):
        """Sets the id_in of this WitnessWhereInput.


        :param id_in: The id_in of this WitnessWhereInput.  # noqa: E501
        :type id_in: list[str]
        """

        self._id_in = id_in

    @property
    def id_lt(self):
        """Gets the id_lt of this WitnessWhereInput.  # noqa: E501


        :return: The id_lt of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lt

    @id_lt.setter
    def id_lt(self, id_lt):
        """Sets the id_lt of this WitnessWhereInput.


        :param id_lt: The id_lt of this WitnessWhereInput.  # noqa: E501
        :type id_lt: str
        """

        self._id_lt = id_lt

    @property
    def id_lte(self):
        """Gets the id_lte of this WitnessWhereInput.  # noqa: E501


        :return: The id_lte of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lte

    @id_lte.setter
    def id_lte(self, id_lte):
        """Sets the id_lte of this WitnessWhereInput.


        :param id_lte: The id_lte of this WitnessWhereInput.  # noqa: E501
        :type id_lte: str
        """

        self._id_lte = id_lte

    @property
    def id_not(self):
        """Gets the id_not of this WitnessWhereInput.  # noqa: E501


        :return: The id_not of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not

    @id_not.setter
    def id_not(self, id_not):
        """Sets the id_not of this WitnessWhereInput.


        :param id_not: The id_not of this WitnessWhereInput.  # noqa: E501
        :type id_not: str
        """

        self._id_not = id_not

    @property
    def id_not_contains(self):
        """Gets the id_not_contains of this WitnessWhereInput.  # noqa: E501


        :return: The id_not_contains of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_contains

    @id_not_contains.setter
    def id_not_contains(self, id_not_contains):
        """Sets the id_not_contains of this WitnessWhereInput.


        :param id_not_contains: The id_not_contains of this WitnessWhereInput.  # noqa: E501
        :type id_not_contains: str
        """

        self._id_not_contains = id_not_contains

    @property
    def id_not_ends_with(self):
        """Gets the id_not_ends_with of this WitnessWhereInput.  # noqa: E501


        :return: The id_not_ends_with of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_ends_with

    @id_not_ends_with.setter
    def id_not_ends_with(self, id_not_ends_with):
        """Sets the id_not_ends_with of this WitnessWhereInput.


        :param id_not_ends_with: The id_not_ends_with of this WitnessWhereInput.  # noqa: E501
        :type id_not_ends_with: str
        """

        self._id_not_ends_with = id_not_ends_with

    @property
    def id_not_in(self):
        """Gets the id_not_in of this WitnessWhereInput.  # noqa: E501


        :return: The id_not_in of this WitnessWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_not_in

    @id_not_in.setter
    def id_not_in(self, id_not_in):
        """Sets the id_not_in of this WitnessWhereInput.


        :param id_not_in: The id_not_in of this WitnessWhereInput.  # noqa: E501
        :type id_not_in: list[str]
        """

        self._id_not_in = id_not_in

    @property
    def id_not_starts_with(self):
        """Gets the id_not_starts_with of this WitnessWhereInput.  # noqa: E501


        :return: The id_not_starts_with of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_starts_with

    @id_not_starts_with.setter
    def id_not_starts_with(self, id_not_starts_with):
        """Sets the id_not_starts_with of this WitnessWhereInput.


        :param id_not_starts_with: The id_not_starts_with of this WitnessWhereInput.  # noqa: E501
        :type id_not_starts_with: str
        """

        self._id_not_starts_with = id_not_starts_with

    @property
    def id_starts_with(self):
        """Gets the id_starts_with of this WitnessWhereInput.  # noqa: E501


        :return: The id_starts_with of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_starts_with

    @id_starts_with.setter
    def id_starts_with(self, id_starts_with):
        """Sets the id_starts_with of this WitnessWhereInput.


        :param id_starts_with: The id_starts_with of this WitnessWhereInput.  # noqa: E501
        :type id_starts_with: str
        """

        self._id_starts_with = id_starts_with

    @property
    def local_id(self):
        """Gets the local_id of this WitnessWhereInput.  # noqa: E501


        :return: The local_id of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id):
        """Sets the local_id of this WitnessWhereInput.


        :param local_id: The local_id of this WitnessWhereInput.  # noqa: E501
        :type local_id: str
        """

        self._local_id = local_id

    @property
    def local_id_contains(self):
        """Gets the local_id_contains of this WitnessWhereInput.  # noqa: E501


        :return: The local_id_contains of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_contains

    @local_id_contains.setter
    def local_id_contains(self, local_id_contains):
        """Sets the local_id_contains of this WitnessWhereInput.


        :param local_id_contains: The local_id_contains of this WitnessWhereInput.  # noqa: E501
        :type local_id_contains: str
        """

        self._local_id_contains = local_id_contains

    @property
    def local_id_ends_with(self):
        """Gets the local_id_ends_with of this WitnessWhereInput.  # noqa: E501


        :return: The local_id_ends_with of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_ends_with

    @local_id_ends_with.setter
    def local_id_ends_with(self, local_id_ends_with):
        """Sets the local_id_ends_with of this WitnessWhereInput.


        :param local_id_ends_with: The local_id_ends_with of this WitnessWhereInput.  # noqa: E501
        :type local_id_ends_with: str
        """

        self._local_id_ends_with = local_id_ends_with

    @property
    def local_id_gt(self):
        """Gets the local_id_gt of this WitnessWhereInput.  # noqa: E501


        :return: The local_id_gt of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_gt

    @local_id_gt.setter
    def local_id_gt(self, local_id_gt):
        """Sets the local_id_gt of this WitnessWhereInput.


        :param local_id_gt: The local_id_gt of this WitnessWhereInput.  # noqa: E501
        :type local_id_gt: str
        """

        self._local_id_gt = local_id_gt

    @property
    def local_id_gte(self):
        """Gets the local_id_gte of this WitnessWhereInput.  # noqa: E501


        :return: The local_id_gte of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_gte

    @local_id_gte.setter
    def local_id_gte(self, local_id_gte):
        """Sets the local_id_gte of this WitnessWhereInput.


        :param local_id_gte: The local_id_gte of this WitnessWhereInput.  # noqa: E501
        :type local_id_gte: str
        """

        self._local_id_gte = local_id_gte

    @property
    def local_id_in(self):
        """Gets the local_id_in of this WitnessWhereInput.  # noqa: E501


        :return: The local_id_in of this WitnessWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_id_in

    @local_id_in.setter
    def local_id_in(self, local_id_in):
        """Sets the local_id_in of this WitnessWhereInput.


        :param local_id_in: The local_id_in of this WitnessWhereInput.  # noqa: E501
        :type local_id_in: list[str]
        """

        self._local_id_in = local_id_in

    @property
    def local_id_lt(self):
        """Gets the local_id_lt of this WitnessWhereInput.  # noqa: E501


        :return: The local_id_lt of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_lt

    @local_id_lt.setter
    def local_id_lt(self, local_id_lt):
        """Sets the local_id_lt of this WitnessWhereInput.


        :param local_id_lt: The local_id_lt of this WitnessWhereInput.  # noqa: E501
        :type local_id_lt: str
        """

        self._local_id_lt = local_id_lt

    @property
    def local_id_lte(self):
        """Gets the local_id_lte of this WitnessWhereInput.  # noqa: E501


        :return: The local_id_lte of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_lte

    @local_id_lte.setter
    def local_id_lte(self, local_id_lte):
        """Sets the local_id_lte of this WitnessWhereInput.


        :param local_id_lte: The local_id_lte of this WitnessWhereInput.  # noqa: E501
        :type local_id_lte: str
        """

        self._local_id_lte = local_id_lte

    @property
    def local_id_not(self):
        """Gets the local_id_not of this WitnessWhereInput.  # noqa: E501


        :return: The local_id_not of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not

    @local_id_not.setter
    def local_id_not(self, local_id_not):
        """Sets the local_id_not of this WitnessWhereInput.


        :param local_id_not: The local_id_not of this WitnessWhereInput.  # noqa: E501
        :type local_id_not: str
        """

        self._local_id_not = local_id_not

    @property
    def local_id_not_contains(self):
        """Gets the local_id_not_contains of this WitnessWhereInput.  # noqa: E501


        :return: The local_id_not_contains of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_contains

    @local_id_not_contains.setter
    def local_id_not_contains(self, local_id_not_contains):
        """Sets the local_id_not_contains of this WitnessWhereInput.


        :param local_id_not_contains: The local_id_not_contains of this WitnessWhereInput.  # noqa: E501
        :type local_id_not_contains: str
        """

        self._local_id_not_contains = local_id_not_contains

    @property
    def local_id_not_ends_with(self):
        """Gets the local_id_not_ends_with of this WitnessWhereInput.  # noqa: E501


        :return: The local_id_not_ends_with of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_ends_with

    @local_id_not_ends_with.setter
    def local_id_not_ends_with(self, local_id_not_ends_with):
        """Sets the local_id_not_ends_with of this WitnessWhereInput.


        :param local_id_not_ends_with: The local_id_not_ends_with of this WitnessWhereInput.  # noqa: E501
        :type local_id_not_ends_with: str
        """

        self._local_id_not_ends_with = local_id_not_ends_with

    @property
    def local_id_not_in(self):
        """Gets the local_id_not_in of this WitnessWhereInput.  # noqa: E501


        :return: The local_id_not_in of this WitnessWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_id_not_in

    @local_id_not_in.setter
    def local_id_not_in(self, local_id_not_in):
        """Sets the local_id_not_in of this WitnessWhereInput.


        :param local_id_not_in: The local_id_not_in of this WitnessWhereInput.  # noqa: E501
        :type local_id_not_in: list[str]
        """

        self._local_id_not_in = local_id_not_in

    @property
    def local_id_not_starts_with(self):
        """Gets the local_id_not_starts_with of this WitnessWhereInput.  # noqa: E501


        :return: The local_id_not_starts_with of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_starts_with

    @local_id_not_starts_with.setter
    def local_id_not_starts_with(self, local_id_not_starts_with):
        """Sets the local_id_not_starts_with of this WitnessWhereInput.


        :param local_id_not_starts_with: The local_id_not_starts_with of this WitnessWhereInput.  # noqa: E501
        :type local_id_not_starts_with: str
        """

        self._local_id_not_starts_with = local_id_not_starts_with

    @property
    def local_id_starts_with(self):
        """Gets the local_id_starts_with of this WitnessWhereInput.  # noqa: E501


        :return: The local_id_starts_with of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_starts_with

    @local_id_starts_with.setter
    def local_id_starts_with(self, local_id_starts_with):
        """Sets the local_id_starts_with of this WitnessWhereInput.


        :param local_id_starts_with: The local_id_starts_with of this WitnessWhereInput.  # noqa: E501
        :type local_id_starts_with: str
        """

        self._local_id_starts_with = local_id_starts_with

    @property
    def management_ip(self):
        """Gets the management_ip of this WitnessWhereInput.  # noqa: E501


        :return: The management_ip of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_ip

    @management_ip.setter
    def management_ip(self, management_ip):
        """Sets the management_ip of this WitnessWhereInput.


        :param management_ip: The management_ip of this WitnessWhereInput.  # noqa: E501
        :type management_ip: str
        """

        self._management_ip = management_ip

    @property
    def management_ip_contains(self):
        """Gets the management_ip_contains of this WitnessWhereInput.  # noqa: E501


        :return: The management_ip_contains of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_ip_contains

    @management_ip_contains.setter
    def management_ip_contains(self, management_ip_contains):
        """Sets the management_ip_contains of this WitnessWhereInput.


        :param management_ip_contains: The management_ip_contains of this WitnessWhereInput.  # noqa: E501
        :type management_ip_contains: str
        """

        self._management_ip_contains = management_ip_contains

    @property
    def management_ip_ends_with(self):
        """Gets the management_ip_ends_with of this WitnessWhereInput.  # noqa: E501


        :return: The management_ip_ends_with of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_ip_ends_with

    @management_ip_ends_with.setter
    def management_ip_ends_with(self, management_ip_ends_with):
        """Sets the management_ip_ends_with of this WitnessWhereInput.


        :param management_ip_ends_with: The management_ip_ends_with of this WitnessWhereInput.  # noqa: E501
        :type management_ip_ends_with: str
        """

        self._management_ip_ends_with = management_ip_ends_with

    @property
    def management_ip_gt(self):
        """Gets the management_ip_gt of this WitnessWhereInput.  # noqa: E501


        :return: The management_ip_gt of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_ip_gt

    @management_ip_gt.setter
    def management_ip_gt(self, management_ip_gt):
        """Sets the management_ip_gt of this WitnessWhereInput.


        :param management_ip_gt: The management_ip_gt of this WitnessWhereInput.  # noqa: E501
        :type management_ip_gt: str
        """

        self._management_ip_gt = management_ip_gt

    @property
    def management_ip_gte(self):
        """Gets the management_ip_gte of this WitnessWhereInput.  # noqa: E501


        :return: The management_ip_gte of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_ip_gte

    @management_ip_gte.setter
    def management_ip_gte(self, management_ip_gte):
        """Sets the management_ip_gte of this WitnessWhereInput.


        :param management_ip_gte: The management_ip_gte of this WitnessWhereInput.  # noqa: E501
        :type management_ip_gte: str
        """

        self._management_ip_gte = management_ip_gte

    @property
    def management_ip_in(self):
        """Gets the management_ip_in of this WitnessWhereInput.  # noqa: E501


        :return: The management_ip_in of this WitnessWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._management_ip_in

    @management_ip_in.setter
    def management_ip_in(self, management_ip_in):
        """Sets the management_ip_in of this WitnessWhereInput.


        :param management_ip_in: The management_ip_in of this WitnessWhereInput.  # noqa: E501
        :type management_ip_in: list[str]
        """

        self._management_ip_in = management_ip_in

    @property
    def management_ip_lt(self):
        """Gets the management_ip_lt of this WitnessWhereInput.  # noqa: E501


        :return: The management_ip_lt of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_ip_lt

    @management_ip_lt.setter
    def management_ip_lt(self, management_ip_lt):
        """Sets the management_ip_lt of this WitnessWhereInput.


        :param management_ip_lt: The management_ip_lt of this WitnessWhereInput.  # noqa: E501
        :type management_ip_lt: str
        """

        self._management_ip_lt = management_ip_lt

    @property
    def management_ip_lte(self):
        """Gets the management_ip_lte of this WitnessWhereInput.  # noqa: E501


        :return: The management_ip_lte of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_ip_lte

    @management_ip_lte.setter
    def management_ip_lte(self, management_ip_lte):
        """Sets the management_ip_lte of this WitnessWhereInput.


        :param management_ip_lte: The management_ip_lte of this WitnessWhereInput.  # noqa: E501
        :type management_ip_lte: str
        """

        self._management_ip_lte = management_ip_lte

    @property
    def management_ip_not(self):
        """Gets the management_ip_not of this WitnessWhereInput.  # noqa: E501


        :return: The management_ip_not of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_ip_not

    @management_ip_not.setter
    def management_ip_not(self, management_ip_not):
        """Sets the management_ip_not of this WitnessWhereInput.


        :param management_ip_not: The management_ip_not of this WitnessWhereInput.  # noqa: E501
        :type management_ip_not: str
        """

        self._management_ip_not = management_ip_not

    @property
    def management_ip_not_contains(self):
        """Gets the management_ip_not_contains of this WitnessWhereInput.  # noqa: E501


        :return: The management_ip_not_contains of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_ip_not_contains

    @management_ip_not_contains.setter
    def management_ip_not_contains(self, management_ip_not_contains):
        """Sets the management_ip_not_contains of this WitnessWhereInput.


        :param management_ip_not_contains: The management_ip_not_contains of this WitnessWhereInput.  # noqa: E501
        :type management_ip_not_contains: str
        """

        self._management_ip_not_contains = management_ip_not_contains

    @property
    def management_ip_not_ends_with(self):
        """Gets the management_ip_not_ends_with of this WitnessWhereInput.  # noqa: E501


        :return: The management_ip_not_ends_with of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_ip_not_ends_with

    @management_ip_not_ends_with.setter
    def management_ip_not_ends_with(self, management_ip_not_ends_with):
        """Sets the management_ip_not_ends_with of this WitnessWhereInput.


        :param management_ip_not_ends_with: The management_ip_not_ends_with of this WitnessWhereInput.  # noqa: E501
        :type management_ip_not_ends_with: str
        """

        self._management_ip_not_ends_with = management_ip_not_ends_with

    @property
    def management_ip_not_in(self):
        """Gets the management_ip_not_in of this WitnessWhereInput.  # noqa: E501


        :return: The management_ip_not_in of this WitnessWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._management_ip_not_in

    @management_ip_not_in.setter
    def management_ip_not_in(self, management_ip_not_in):
        """Sets the management_ip_not_in of this WitnessWhereInput.


        :param management_ip_not_in: The management_ip_not_in of this WitnessWhereInput.  # noqa: E501
        :type management_ip_not_in: list[str]
        """

        self._management_ip_not_in = management_ip_not_in

    @property
    def management_ip_not_starts_with(self):
        """Gets the management_ip_not_starts_with of this WitnessWhereInput.  # noqa: E501


        :return: The management_ip_not_starts_with of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_ip_not_starts_with

    @management_ip_not_starts_with.setter
    def management_ip_not_starts_with(self, management_ip_not_starts_with):
        """Sets the management_ip_not_starts_with of this WitnessWhereInput.


        :param management_ip_not_starts_with: The management_ip_not_starts_with of this WitnessWhereInput.  # noqa: E501
        :type management_ip_not_starts_with: str
        """

        self._management_ip_not_starts_with = management_ip_not_starts_with

    @property
    def management_ip_starts_with(self):
        """Gets the management_ip_starts_with of this WitnessWhereInput.  # noqa: E501


        :return: The management_ip_starts_with of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_ip_starts_with

    @management_ip_starts_with.setter
    def management_ip_starts_with(self, management_ip_starts_with):
        """Sets the management_ip_starts_with of this WitnessWhereInput.


        :param management_ip_starts_with: The management_ip_starts_with of this WitnessWhereInput.  # noqa: E501
        :type management_ip_starts_with: str
        """

        self._management_ip_starts_with = management_ip_starts_with

    @property
    def name(self):
        """Gets the name of this WitnessWhereInput.  # noqa: E501


        :return: The name of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this WitnessWhereInput.


        :param name: The name of this WitnessWhereInput.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def name_contains(self):
        """Gets the name_contains of this WitnessWhereInput.  # noqa: E501


        :return: The name_contains of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_contains

    @name_contains.setter
    def name_contains(self, name_contains):
        """Sets the name_contains of this WitnessWhereInput.


        :param name_contains: The name_contains of this WitnessWhereInput.  # noqa: E501
        :type name_contains: str
        """

        self._name_contains = name_contains

    @property
    def name_ends_with(self):
        """Gets the name_ends_with of this WitnessWhereInput.  # noqa: E501


        :return: The name_ends_with of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_ends_with

    @name_ends_with.setter
    def name_ends_with(self, name_ends_with):
        """Sets the name_ends_with of this WitnessWhereInput.


        :param name_ends_with: The name_ends_with of this WitnessWhereInput.  # noqa: E501
        :type name_ends_with: str
        """

        self._name_ends_with = name_ends_with

    @property
    def name_gt(self):
        """Gets the name_gt of this WitnessWhereInput.  # noqa: E501


        :return: The name_gt of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_gt

    @name_gt.setter
    def name_gt(self, name_gt):
        """Sets the name_gt of this WitnessWhereInput.


        :param name_gt: The name_gt of this WitnessWhereInput.  # noqa: E501
        :type name_gt: str
        """

        self._name_gt = name_gt

    @property
    def name_gte(self):
        """Gets the name_gte of this WitnessWhereInput.  # noqa: E501


        :return: The name_gte of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_gte

    @name_gte.setter
    def name_gte(self, name_gte):
        """Sets the name_gte of this WitnessWhereInput.


        :param name_gte: The name_gte of this WitnessWhereInput.  # noqa: E501
        :type name_gte: str
        """

        self._name_gte = name_gte

    @property
    def name_in(self):
        """Gets the name_in of this WitnessWhereInput.  # noqa: E501


        :return: The name_in of this WitnessWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._name_in

    @name_in.setter
    def name_in(self, name_in):
        """Sets the name_in of this WitnessWhereInput.


        :param name_in: The name_in of this WitnessWhereInput.  # noqa: E501
        :type name_in: list[str]
        """

        self._name_in = name_in

    @property
    def name_lt(self):
        """Gets the name_lt of this WitnessWhereInput.  # noqa: E501


        :return: The name_lt of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_lt

    @name_lt.setter
    def name_lt(self, name_lt):
        """Sets the name_lt of this WitnessWhereInput.


        :param name_lt: The name_lt of this WitnessWhereInput.  # noqa: E501
        :type name_lt: str
        """

        self._name_lt = name_lt

    @property
    def name_lte(self):
        """Gets the name_lte of this WitnessWhereInput.  # noqa: E501


        :return: The name_lte of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_lte

    @name_lte.setter
    def name_lte(self, name_lte):
        """Sets the name_lte of this WitnessWhereInput.


        :param name_lte: The name_lte of this WitnessWhereInput.  # noqa: E501
        :type name_lte: str
        """

        self._name_lte = name_lte

    @property
    def name_not(self):
        """Gets the name_not of this WitnessWhereInput.  # noqa: E501


        :return: The name_not of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not

    @name_not.setter
    def name_not(self, name_not):
        """Sets the name_not of this WitnessWhereInput.


        :param name_not: The name_not of this WitnessWhereInput.  # noqa: E501
        :type name_not: str
        """

        self._name_not = name_not

    @property
    def name_not_contains(self):
        """Gets the name_not_contains of this WitnessWhereInput.  # noqa: E501


        :return: The name_not_contains of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_contains

    @name_not_contains.setter
    def name_not_contains(self, name_not_contains):
        """Sets the name_not_contains of this WitnessWhereInput.


        :param name_not_contains: The name_not_contains of this WitnessWhereInput.  # noqa: E501
        :type name_not_contains: str
        """

        self._name_not_contains = name_not_contains

    @property
    def name_not_ends_with(self):
        """Gets the name_not_ends_with of this WitnessWhereInput.  # noqa: E501


        :return: The name_not_ends_with of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_ends_with

    @name_not_ends_with.setter
    def name_not_ends_with(self, name_not_ends_with):
        """Sets the name_not_ends_with of this WitnessWhereInput.


        :param name_not_ends_with: The name_not_ends_with of this WitnessWhereInput.  # noqa: E501
        :type name_not_ends_with: str
        """

        self._name_not_ends_with = name_not_ends_with

    @property
    def name_not_in(self):
        """Gets the name_not_in of this WitnessWhereInput.  # noqa: E501


        :return: The name_not_in of this WitnessWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._name_not_in

    @name_not_in.setter
    def name_not_in(self, name_not_in):
        """Sets the name_not_in of this WitnessWhereInput.


        :param name_not_in: The name_not_in of this WitnessWhereInput.  # noqa: E501
        :type name_not_in: list[str]
        """

        self._name_not_in = name_not_in

    @property
    def name_not_starts_with(self):
        """Gets the name_not_starts_with of this WitnessWhereInput.  # noqa: E501


        :return: The name_not_starts_with of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_starts_with

    @name_not_starts_with.setter
    def name_not_starts_with(self, name_not_starts_with):
        """Sets the name_not_starts_with of this WitnessWhereInput.


        :param name_not_starts_with: The name_not_starts_with of this WitnessWhereInput.  # noqa: E501
        :type name_not_starts_with: str
        """

        self._name_not_starts_with = name_not_starts_with

    @property
    def name_starts_with(self):
        """Gets the name_starts_with of this WitnessWhereInput.  # noqa: E501


        :return: The name_starts_with of this WitnessWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_starts_with

    @name_starts_with.setter
    def name_starts_with(self, name_starts_with):
        """Sets the name_starts_with of this WitnessWhereInput.


        :param name_starts_with: The name_starts_with of this WitnessWhereInput.  # noqa: E501
        :type name_starts_with: str
        """

        self._name_starts_with = name_starts_with

    @property
    def system_data_capacity(self):
        """Gets the system_data_capacity of this WitnessWhereInput.  # noqa: E501


        :return: The system_data_capacity of this WitnessWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._system_data_capacity

    @system_data_capacity.setter
    def system_data_capacity(self, system_data_capacity):
        """Sets the system_data_capacity of this WitnessWhereInput.


        :param system_data_capacity: The system_data_capacity of this WitnessWhereInput.  # noqa: E501
        :type system_data_capacity: int
        """

        self._system_data_capacity = system_data_capacity

    @property
    def system_data_capacity_gt(self):
        """Gets the system_data_capacity_gt of this WitnessWhereInput.  # noqa: E501


        :return: The system_data_capacity_gt of this WitnessWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._system_data_capacity_gt

    @system_data_capacity_gt.setter
    def system_data_capacity_gt(self, system_data_capacity_gt):
        """Sets the system_data_capacity_gt of this WitnessWhereInput.


        :param system_data_capacity_gt: The system_data_capacity_gt of this WitnessWhereInput.  # noqa: E501
        :type system_data_capacity_gt: int
        """

        self._system_data_capacity_gt = system_data_capacity_gt

    @property
    def system_data_capacity_gte(self):
        """Gets the system_data_capacity_gte of this WitnessWhereInput.  # noqa: E501


        :return: The system_data_capacity_gte of this WitnessWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._system_data_capacity_gte

    @system_data_capacity_gte.setter
    def system_data_capacity_gte(self, system_data_capacity_gte):
        """Sets the system_data_capacity_gte of this WitnessWhereInput.


        :param system_data_capacity_gte: The system_data_capacity_gte of this WitnessWhereInput.  # noqa: E501
        :type system_data_capacity_gte: int
        """

        self._system_data_capacity_gte = system_data_capacity_gte

    @property
    def system_data_capacity_in(self):
        """Gets the system_data_capacity_in of this WitnessWhereInput.  # noqa: E501


        :return: The system_data_capacity_in of this WitnessWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._system_data_capacity_in

    @system_data_capacity_in.setter
    def system_data_capacity_in(self, system_data_capacity_in):
        """Sets the system_data_capacity_in of this WitnessWhereInput.


        :param system_data_capacity_in: The system_data_capacity_in of this WitnessWhereInput.  # noqa: E501
        :type system_data_capacity_in: list[int]
        """

        self._system_data_capacity_in = system_data_capacity_in

    @property
    def system_data_capacity_lt(self):
        """Gets the system_data_capacity_lt of this WitnessWhereInput.  # noqa: E501


        :return: The system_data_capacity_lt of this WitnessWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._system_data_capacity_lt

    @system_data_capacity_lt.setter
    def system_data_capacity_lt(self, system_data_capacity_lt):
        """Sets the system_data_capacity_lt of this WitnessWhereInput.


        :param system_data_capacity_lt: The system_data_capacity_lt of this WitnessWhereInput.  # noqa: E501
        :type system_data_capacity_lt: int
        """

        self._system_data_capacity_lt = system_data_capacity_lt

    @property
    def system_data_capacity_lte(self):
        """Gets the system_data_capacity_lte of this WitnessWhereInput.  # noqa: E501


        :return: The system_data_capacity_lte of this WitnessWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._system_data_capacity_lte

    @system_data_capacity_lte.setter
    def system_data_capacity_lte(self, system_data_capacity_lte):
        """Sets the system_data_capacity_lte of this WitnessWhereInput.


        :param system_data_capacity_lte: The system_data_capacity_lte of this WitnessWhereInput.  # noqa: E501
        :type system_data_capacity_lte: int
        """

        self._system_data_capacity_lte = system_data_capacity_lte

    @property
    def system_data_capacity_not(self):
        """Gets the system_data_capacity_not of this WitnessWhereInput.  # noqa: E501


        :return: The system_data_capacity_not of this WitnessWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._system_data_capacity_not

    @system_data_capacity_not.setter
    def system_data_capacity_not(self, system_data_capacity_not):
        """Sets the system_data_capacity_not of this WitnessWhereInput.


        :param system_data_capacity_not: The system_data_capacity_not of this WitnessWhereInput.  # noqa: E501
        :type system_data_capacity_not: int
        """

        self._system_data_capacity_not = system_data_capacity_not

    @property
    def system_data_capacity_not_in(self):
        """Gets the system_data_capacity_not_in of this WitnessWhereInput.  # noqa: E501


        :return: The system_data_capacity_not_in of this WitnessWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._system_data_capacity_not_in

    @system_data_capacity_not_in.setter
    def system_data_capacity_not_in(self, system_data_capacity_not_in):
        """Sets the system_data_capacity_not_in of this WitnessWhereInput.


        :param system_data_capacity_not_in: The system_data_capacity_not_in of this WitnessWhereInput.  # noqa: E501
        :type system_data_capacity_not_in: list[int]
        """

        self._system_data_capacity_not_in = system_data_capacity_not_in

    @property
    def system_used_data_space(self):
        """Gets the system_used_data_space of this WitnessWhereInput.  # noqa: E501


        :return: The system_used_data_space of this WitnessWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._system_used_data_space

    @system_used_data_space.setter
    def system_used_data_space(self, system_used_data_space):
        """Sets the system_used_data_space of this WitnessWhereInput.


        :param system_used_data_space: The system_used_data_space of this WitnessWhereInput.  # noqa: E501
        :type system_used_data_space: int
        """

        self._system_used_data_space = system_used_data_space

    @property
    def system_used_data_space_gt(self):
        """Gets the system_used_data_space_gt of this WitnessWhereInput.  # noqa: E501


        :return: The system_used_data_space_gt of this WitnessWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._system_used_data_space_gt

    @system_used_data_space_gt.setter
    def system_used_data_space_gt(self, system_used_data_space_gt):
        """Sets the system_used_data_space_gt of this WitnessWhereInput.


        :param system_used_data_space_gt: The system_used_data_space_gt of this WitnessWhereInput.  # noqa: E501
        :type system_used_data_space_gt: int
        """

        self._system_used_data_space_gt = system_used_data_space_gt

    @property
    def system_used_data_space_gte(self):
        """Gets the system_used_data_space_gte of this WitnessWhereInput.  # noqa: E501


        :return: The system_used_data_space_gte of this WitnessWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._system_used_data_space_gte

    @system_used_data_space_gte.setter
    def system_used_data_space_gte(self, system_used_data_space_gte):
        """Sets the system_used_data_space_gte of this WitnessWhereInput.


        :param system_used_data_space_gte: The system_used_data_space_gte of this WitnessWhereInput.  # noqa: E501
        :type system_used_data_space_gte: int
        """

        self._system_used_data_space_gte = system_used_data_space_gte

    @property
    def system_used_data_space_in(self):
        """Gets the system_used_data_space_in of this WitnessWhereInput.  # noqa: E501


        :return: The system_used_data_space_in of this WitnessWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._system_used_data_space_in

    @system_used_data_space_in.setter
    def system_used_data_space_in(self, system_used_data_space_in):
        """Sets the system_used_data_space_in of this WitnessWhereInput.


        :param system_used_data_space_in: The system_used_data_space_in of this WitnessWhereInput.  # noqa: E501
        :type system_used_data_space_in: list[int]
        """

        self._system_used_data_space_in = system_used_data_space_in

    @property
    def system_used_data_space_lt(self):
        """Gets the system_used_data_space_lt of this WitnessWhereInput.  # noqa: E501


        :return: The system_used_data_space_lt of this WitnessWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._system_used_data_space_lt

    @system_used_data_space_lt.setter
    def system_used_data_space_lt(self, system_used_data_space_lt):
        """Sets the system_used_data_space_lt of this WitnessWhereInput.


        :param system_used_data_space_lt: The system_used_data_space_lt of this WitnessWhereInput.  # noqa: E501
        :type system_used_data_space_lt: int
        """

        self._system_used_data_space_lt = system_used_data_space_lt

    @property
    def system_used_data_space_lte(self):
        """Gets the system_used_data_space_lte of this WitnessWhereInput.  # noqa: E501


        :return: The system_used_data_space_lte of this WitnessWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._system_used_data_space_lte

    @system_used_data_space_lte.setter
    def system_used_data_space_lte(self, system_used_data_space_lte):
        """Sets the system_used_data_space_lte of this WitnessWhereInput.


        :param system_used_data_space_lte: The system_used_data_space_lte of this WitnessWhereInput.  # noqa: E501
        :type system_used_data_space_lte: int
        """

        self._system_used_data_space_lte = system_used_data_space_lte

    @property
    def system_used_data_space_not(self):
        """Gets the system_used_data_space_not of this WitnessWhereInput.  # noqa: E501


        :return: The system_used_data_space_not of this WitnessWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._system_used_data_space_not

    @system_used_data_space_not.setter
    def system_used_data_space_not(self, system_used_data_space_not):
        """Sets the system_used_data_space_not of this WitnessWhereInput.


        :param system_used_data_space_not: The system_used_data_space_not of this WitnessWhereInput.  # noqa: E501
        :type system_used_data_space_not: int
        """

        self._system_used_data_space_not = system_used_data_space_not

    @property
    def system_used_data_space_not_in(self):
        """Gets the system_used_data_space_not_in of this WitnessWhereInput.  # noqa: E501


        :return: The system_used_data_space_not_in of this WitnessWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._system_used_data_space_not_in

    @system_used_data_space_not_in.setter
    def system_used_data_space_not_in(self, system_used_data_space_not_in):
        """Sets the system_used_data_space_not_in of this WitnessWhereInput.


        :param system_used_data_space_not_in: The system_used_data_space_not_in of this WitnessWhereInput.  # noqa: E501
        :type system_used_data_space_not_in: list[int]
        """

        self._system_used_data_space_not_in = system_used_data_space_not_in

    @property
    def total_cpu_cores(self):
        """Gets the total_cpu_cores of this WitnessWhereInput.  # noqa: E501


        :return: The total_cpu_cores of this WitnessWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cpu_cores

    @total_cpu_cores.setter
    def total_cpu_cores(self, total_cpu_cores):
        """Sets the total_cpu_cores of this WitnessWhereInput.


        :param total_cpu_cores: The total_cpu_cores of this WitnessWhereInput.  # noqa: E501
        :type total_cpu_cores: int
        """

        self._total_cpu_cores = total_cpu_cores

    @property
    def total_cpu_cores_gt(self):
        """Gets the total_cpu_cores_gt of this WitnessWhereInput.  # noqa: E501


        :return: The total_cpu_cores_gt of this WitnessWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cpu_cores_gt

    @total_cpu_cores_gt.setter
    def total_cpu_cores_gt(self, total_cpu_cores_gt):
        """Sets the total_cpu_cores_gt of this WitnessWhereInput.


        :param total_cpu_cores_gt: The total_cpu_cores_gt of this WitnessWhereInput.  # noqa: E501
        :type total_cpu_cores_gt: int
        """

        self._total_cpu_cores_gt = total_cpu_cores_gt

    @property
    def total_cpu_cores_gte(self):
        """Gets the total_cpu_cores_gte of this WitnessWhereInput.  # noqa: E501


        :return: The total_cpu_cores_gte of this WitnessWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cpu_cores_gte

    @total_cpu_cores_gte.setter
    def total_cpu_cores_gte(self, total_cpu_cores_gte):
        """Sets the total_cpu_cores_gte of this WitnessWhereInput.


        :param total_cpu_cores_gte: The total_cpu_cores_gte of this WitnessWhereInput.  # noqa: E501
        :type total_cpu_cores_gte: int
        """

        self._total_cpu_cores_gte = total_cpu_cores_gte

    @property
    def total_cpu_cores_in(self):
        """Gets the total_cpu_cores_in of this WitnessWhereInput.  # noqa: E501


        :return: The total_cpu_cores_in of this WitnessWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._total_cpu_cores_in

    @total_cpu_cores_in.setter
    def total_cpu_cores_in(self, total_cpu_cores_in):
        """Sets the total_cpu_cores_in of this WitnessWhereInput.


        :param total_cpu_cores_in: The total_cpu_cores_in of this WitnessWhereInput.  # noqa: E501
        :type total_cpu_cores_in: list[int]
        """

        self._total_cpu_cores_in = total_cpu_cores_in

    @property
    def total_cpu_cores_lt(self):
        """Gets the total_cpu_cores_lt of this WitnessWhereInput.  # noqa: E501


        :return: The total_cpu_cores_lt of this WitnessWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cpu_cores_lt

    @total_cpu_cores_lt.setter
    def total_cpu_cores_lt(self, total_cpu_cores_lt):
        """Sets the total_cpu_cores_lt of this WitnessWhereInput.


        :param total_cpu_cores_lt: The total_cpu_cores_lt of this WitnessWhereInput.  # noqa: E501
        :type total_cpu_cores_lt: int
        """

        self._total_cpu_cores_lt = total_cpu_cores_lt

    @property
    def total_cpu_cores_lte(self):
        """Gets the total_cpu_cores_lte of this WitnessWhereInput.  # noqa: E501


        :return: The total_cpu_cores_lte of this WitnessWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cpu_cores_lte

    @total_cpu_cores_lte.setter
    def total_cpu_cores_lte(self, total_cpu_cores_lte):
        """Sets the total_cpu_cores_lte of this WitnessWhereInput.


        :param total_cpu_cores_lte: The total_cpu_cores_lte of this WitnessWhereInput.  # noqa: E501
        :type total_cpu_cores_lte: int
        """

        self._total_cpu_cores_lte = total_cpu_cores_lte

    @property
    def total_cpu_cores_not(self):
        """Gets the total_cpu_cores_not of this WitnessWhereInput.  # noqa: E501


        :return: The total_cpu_cores_not of this WitnessWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cpu_cores_not

    @total_cpu_cores_not.setter
    def total_cpu_cores_not(self, total_cpu_cores_not):
        """Sets the total_cpu_cores_not of this WitnessWhereInput.


        :param total_cpu_cores_not: The total_cpu_cores_not of this WitnessWhereInput.  # noqa: E501
        :type total_cpu_cores_not: int
        """

        self._total_cpu_cores_not = total_cpu_cores_not

    @property
    def total_cpu_cores_not_in(self):
        """Gets the total_cpu_cores_not_in of this WitnessWhereInput.  # noqa: E501


        :return: The total_cpu_cores_not_in of this WitnessWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._total_cpu_cores_not_in

    @total_cpu_cores_not_in.setter
    def total_cpu_cores_not_in(self, total_cpu_cores_not_in):
        """Sets the total_cpu_cores_not_in of this WitnessWhereInput.


        :param total_cpu_cores_not_in: The total_cpu_cores_not_in of this WitnessWhereInput.  # noqa: E501
        :type total_cpu_cores_not_in: list[int]
        """

        self._total_cpu_cores_not_in = total_cpu_cores_not_in

    @property
    def total_cpu_hz(self):
        """Gets the total_cpu_hz of this WitnessWhereInput.  # noqa: E501


        :return: The total_cpu_hz of this WitnessWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cpu_hz

    @total_cpu_hz.setter
    def total_cpu_hz(self, total_cpu_hz):
        """Sets the total_cpu_hz of this WitnessWhereInput.


        :param total_cpu_hz: The total_cpu_hz of this WitnessWhereInput.  # noqa: E501
        :type total_cpu_hz: int
        """

        self._total_cpu_hz = total_cpu_hz

    @property
    def total_cpu_hz_gt(self):
        """Gets the total_cpu_hz_gt of this WitnessWhereInput.  # noqa: E501


        :return: The total_cpu_hz_gt of this WitnessWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cpu_hz_gt

    @total_cpu_hz_gt.setter
    def total_cpu_hz_gt(self, total_cpu_hz_gt):
        """Sets the total_cpu_hz_gt of this WitnessWhereInput.


        :param total_cpu_hz_gt: The total_cpu_hz_gt of this WitnessWhereInput.  # noqa: E501
        :type total_cpu_hz_gt: int
        """

        self._total_cpu_hz_gt = total_cpu_hz_gt

    @property
    def total_cpu_hz_gte(self):
        """Gets the total_cpu_hz_gte of this WitnessWhereInput.  # noqa: E501


        :return: The total_cpu_hz_gte of this WitnessWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cpu_hz_gte

    @total_cpu_hz_gte.setter
    def total_cpu_hz_gte(self, total_cpu_hz_gte):
        """Sets the total_cpu_hz_gte of this WitnessWhereInput.


        :param total_cpu_hz_gte: The total_cpu_hz_gte of this WitnessWhereInput.  # noqa: E501
        :type total_cpu_hz_gte: int
        """

        self._total_cpu_hz_gte = total_cpu_hz_gte

    @property
    def total_cpu_hz_in(self):
        """Gets the total_cpu_hz_in of this WitnessWhereInput.  # noqa: E501


        :return: The total_cpu_hz_in of this WitnessWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._total_cpu_hz_in

    @total_cpu_hz_in.setter
    def total_cpu_hz_in(self, total_cpu_hz_in):
        """Sets the total_cpu_hz_in of this WitnessWhereInput.


        :param total_cpu_hz_in: The total_cpu_hz_in of this WitnessWhereInput.  # noqa: E501
        :type total_cpu_hz_in: list[int]
        """

        self._total_cpu_hz_in = total_cpu_hz_in

    @property
    def total_cpu_hz_lt(self):
        """Gets the total_cpu_hz_lt of this WitnessWhereInput.  # noqa: E501


        :return: The total_cpu_hz_lt of this WitnessWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cpu_hz_lt

    @total_cpu_hz_lt.setter
    def total_cpu_hz_lt(self, total_cpu_hz_lt):
        """Sets the total_cpu_hz_lt of this WitnessWhereInput.


        :param total_cpu_hz_lt: The total_cpu_hz_lt of this WitnessWhereInput.  # noqa: E501
        :type total_cpu_hz_lt: int
        """

        self._total_cpu_hz_lt = total_cpu_hz_lt

    @property
    def total_cpu_hz_lte(self):
        """Gets the total_cpu_hz_lte of this WitnessWhereInput.  # noqa: E501


        :return: The total_cpu_hz_lte of this WitnessWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cpu_hz_lte

    @total_cpu_hz_lte.setter
    def total_cpu_hz_lte(self, total_cpu_hz_lte):
        """Sets the total_cpu_hz_lte of this WitnessWhereInput.


        :param total_cpu_hz_lte: The total_cpu_hz_lte of this WitnessWhereInput.  # noqa: E501
        :type total_cpu_hz_lte: int
        """

        self._total_cpu_hz_lte = total_cpu_hz_lte

    @property
    def total_cpu_hz_not(self):
        """Gets the total_cpu_hz_not of this WitnessWhereInput.  # noqa: E501


        :return: The total_cpu_hz_not of this WitnessWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cpu_hz_not

    @total_cpu_hz_not.setter
    def total_cpu_hz_not(self, total_cpu_hz_not):
        """Sets the total_cpu_hz_not of this WitnessWhereInput.


        :param total_cpu_hz_not: The total_cpu_hz_not of this WitnessWhereInput.  # noqa: E501
        :type total_cpu_hz_not: int
        """

        self._total_cpu_hz_not = total_cpu_hz_not

    @property
    def total_cpu_hz_not_in(self):
        """Gets the total_cpu_hz_not_in of this WitnessWhereInput.  # noqa: E501


        :return: The total_cpu_hz_not_in of this WitnessWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._total_cpu_hz_not_in

    @total_cpu_hz_not_in.setter
    def total_cpu_hz_not_in(self, total_cpu_hz_not_in):
        """Sets the total_cpu_hz_not_in of this WitnessWhereInput.


        :param total_cpu_hz_not_in: The total_cpu_hz_not_in of this WitnessWhereInput.  # noqa: E501
        :type total_cpu_hz_not_in: list[int]
        """

        self._total_cpu_hz_not_in = total_cpu_hz_not_in

    @property
    def total_memory_bytes(self):
        """Gets the total_memory_bytes of this WitnessWhereInput.  # noqa: E501


        :return: The total_memory_bytes of this WitnessWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_memory_bytes

    @total_memory_bytes.setter
    def total_memory_bytes(self, total_memory_bytes):
        """Sets the total_memory_bytes of this WitnessWhereInput.


        :param total_memory_bytes: The total_memory_bytes of this WitnessWhereInput.  # noqa: E501
        :type total_memory_bytes: int
        """

        self._total_memory_bytes = total_memory_bytes

    @property
    def total_memory_bytes_gt(self):
        """Gets the total_memory_bytes_gt of this WitnessWhereInput.  # noqa: E501


        :return: The total_memory_bytes_gt of this WitnessWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_memory_bytes_gt

    @total_memory_bytes_gt.setter
    def total_memory_bytes_gt(self, total_memory_bytes_gt):
        """Sets the total_memory_bytes_gt of this WitnessWhereInput.


        :param total_memory_bytes_gt: The total_memory_bytes_gt of this WitnessWhereInput.  # noqa: E501
        :type total_memory_bytes_gt: int
        """

        self._total_memory_bytes_gt = total_memory_bytes_gt

    @property
    def total_memory_bytes_gte(self):
        """Gets the total_memory_bytes_gte of this WitnessWhereInput.  # noqa: E501


        :return: The total_memory_bytes_gte of this WitnessWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_memory_bytes_gte

    @total_memory_bytes_gte.setter
    def total_memory_bytes_gte(self, total_memory_bytes_gte):
        """Sets the total_memory_bytes_gte of this WitnessWhereInput.


        :param total_memory_bytes_gte: The total_memory_bytes_gte of this WitnessWhereInput.  # noqa: E501
        :type total_memory_bytes_gte: int
        """

        self._total_memory_bytes_gte = total_memory_bytes_gte

    @property
    def total_memory_bytes_in(self):
        """Gets the total_memory_bytes_in of this WitnessWhereInput.  # noqa: E501


        :return: The total_memory_bytes_in of this WitnessWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._total_memory_bytes_in

    @total_memory_bytes_in.setter
    def total_memory_bytes_in(self, total_memory_bytes_in):
        """Sets the total_memory_bytes_in of this WitnessWhereInput.


        :param total_memory_bytes_in: The total_memory_bytes_in of this WitnessWhereInput.  # noqa: E501
        :type total_memory_bytes_in: list[int]
        """

        self._total_memory_bytes_in = total_memory_bytes_in

    @property
    def total_memory_bytes_lt(self):
        """Gets the total_memory_bytes_lt of this WitnessWhereInput.  # noqa: E501


        :return: The total_memory_bytes_lt of this WitnessWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_memory_bytes_lt

    @total_memory_bytes_lt.setter
    def total_memory_bytes_lt(self, total_memory_bytes_lt):
        """Sets the total_memory_bytes_lt of this WitnessWhereInput.


        :param total_memory_bytes_lt: The total_memory_bytes_lt of this WitnessWhereInput.  # noqa: E501
        :type total_memory_bytes_lt: int
        """

        self._total_memory_bytes_lt = total_memory_bytes_lt

    @property
    def total_memory_bytes_lte(self):
        """Gets the total_memory_bytes_lte of this WitnessWhereInput.  # noqa: E501


        :return: The total_memory_bytes_lte of this WitnessWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_memory_bytes_lte

    @total_memory_bytes_lte.setter
    def total_memory_bytes_lte(self, total_memory_bytes_lte):
        """Sets the total_memory_bytes_lte of this WitnessWhereInput.


        :param total_memory_bytes_lte: The total_memory_bytes_lte of this WitnessWhereInput.  # noqa: E501
        :type total_memory_bytes_lte: int
        """

        self._total_memory_bytes_lte = total_memory_bytes_lte

    @property
    def total_memory_bytes_not(self):
        """Gets the total_memory_bytes_not of this WitnessWhereInput.  # noqa: E501


        :return: The total_memory_bytes_not of this WitnessWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_memory_bytes_not

    @total_memory_bytes_not.setter
    def total_memory_bytes_not(self, total_memory_bytes_not):
        """Sets the total_memory_bytes_not of this WitnessWhereInput.


        :param total_memory_bytes_not: The total_memory_bytes_not of this WitnessWhereInput.  # noqa: E501
        :type total_memory_bytes_not: int
        """

        self._total_memory_bytes_not = total_memory_bytes_not

    @property
    def total_memory_bytes_not_in(self):
        """Gets the total_memory_bytes_not_in of this WitnessWhereInput.  # noqa: E501


        :return: The total_memory_bytes_not_in of this WitnessWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._total_memory_bytes_not_in

    @total_memory_bytes_not_in.setter
    def total_memory_bytes_not_in(self, total_memory_bytes_not_in):
        """Sets the total_memory_bytes_not_in of this WitnessWhereInput.


        :param total_memory_bytes_not_in: The total_memory_bytes_not_in of this WitnessWhereInput.  # noqa: E501
        :type total_memory_bytes_not_in: list[int]
        """

        self._total_memory_bytes_not_in = total_memory_bytes_not_in

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, WitnessWhereInput):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, WitnessWhereInput):
            return True

        return self.to_dict() != other.to_dict()
