# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class ZoneWhereInput(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        '_and': 'list[ZoneWhereInput]',
        '_not': 'list[ZoneWhereInput]',
        '_or': 'list[ZoneWhereInput]',
        'cluster': 'ClusterWhereInput',
        'datacenter': 'DatacenterWhereInput',
        'failure_data_space': 'int',
        'failure_data_space_gt': 'int',
        'failure_data_space_gte': 'int',
        'failure_data_space_in': 'list[int]',
        'failure_data_space_lt': 'int',
        'failure_data_space_lte': 'int',
        'failure_data_space_not': 'int',
        'failure_data_space_not_in': 'list[int]',
        'host_num': 'int',
        'host_num_gt': 'int',
        'host_num_gte': 'int',
        'host_num_in': 'list[int]',
        'host_num_lt': 'int',
        'host_num_lte': 'int',
        'host_num_not': 'int',
        'host_num_not_in': 'list[int]',
        'hosts_every': 'HostWhereInput',
        'hosts_none': 'HostWhereInput',
        'hosts_some': 'HostWhereInput',
        'id': 'str',
        'id_contains': 'str',
        'id_ends_with': 'str',
        'id_gt': 'str',
        'id_gte': 'str',
        'id_in': 'list[str]',
        'id_lt': 'str',
        'id_lte': 'str',
        'id_not': 'str',
        'id_not_contains': 'str',
        'id_not_ends_with': 'str',
        'id_not_in': 'list[str]',
        'id_not_starts_with': 'str',
        'id_starts_with': 'str',
        'is_preferred': 'bool',
        'is_preferred_not': 'bool',
        'local_id': 'str',
        'local_id_contains': 'str',
        'local_id_ends_with': 'str',
        'local_id_gt': 'str',
        'local_id_gte': 'str',
        'local_id_in': 'list[str]',
        'local_id_lt': 'str',
        'local_id_lte': 'str',
        'local_id_not': 'str',
        'local_id_not_contains': 'str',
        'local_id_not_ends_with': 'str',
        'local_id_not_in': 'list[str]',
        'local_id_not_starts_with': 'str',
        'local_id_starts_with': 'str',
        'provisioned_cpu_cores': 'int',
        'provisioned_cpu_cores_for_active_vm': 'int',
        'provisioned_cpu_cores_for_active_vm_gt': 'int',
        'provisioned_cpu_cores_for_active_vm_gte': 'int',
        'provisioned_cpu_cores_for_active_vm_in': 'list[int]',
        'provisioned_cpu_cores_for_active_vm_lt': 'int',
        'provisioned_cpu_cores_for_active_vm_lte': 'int',
        'provisioned_cpu_cores_for_active_vm_not': 'int',
        'provisioned_cpu_cores_for_active_vm_not_in': 'list[int]',
        'provisioned_cpu_cores_gt': 'int',
        'provisioned_cpu_cores_gte': 'int',
        'provisioned_cpu_cores_in': 'list[int]',
        'provisioned_cpu_cores_lt': 'int',
        'provisioned_cpu_cores_lte': 'int',
        'provisioned_cpu_cores_not': 'int',
        'provisioned_cpu_cores_not_in': 'list[int]',
        'provisioned_data_space': 'int',
        'provisioned_data_space_gt': 'int',
        'provisioned_data_space_gte': 'int',
        'provisioned_data_space_in': 'list[int]',
        'provisioned_data_space_lt': 'int',
        'provisioned_data_space_lte': 'int',
        'provisioned_data_space_not': 'int',
        'provisioned_data_space_not_in': 'list[int]',
        'provisioned_memory_bytes': 'int',
        'provisioned_memory_bytes_gt': 'int',
        'provisioned_memory_bytes_gte': 'int',
        'provisioned_memory_bytes_in': 'list[int]',
        'provisioned_memory_bytes_lt': 'int',
        'provisioned_memory_bytes_lte': 'int',
        'provisioned_memory_bytes_not': 'int',
        'provisioned_memory_bytes_not_in': 'list[int]',
        'running_vm_num': 'int',
        'running_vm_num_gt': 'int',
        'running_vm_num_gte': 'int',
        'running_vm_num_in': 'list[int]',
        'running_vm_num_lt': 'int',
        'running_vm_num_lte': 'int',
        'running_vm_num_not': 'int',
        'running_vm_num_not_in': 'list[int]',
        'stopped_vm_num': 'int',
        'stopped_vm_num_gt': 'int',
        'stopped_vm_num_gte': 'int',
        'stopped_vm_num_in': 'list[int]',
        'stopped_vm_num_lt': 'int',
        'stopped_vm_num_lte': 'int',
        'stopped_vm_num_not': 'int',
        'stopped_vm_num_not_in': 'list[int]',
        'suspended_vm_num': 'int',
        'suspended_vm_num_gt': 'int',
        'suspended_vm_num_gte': 'int',
        'suspended_vm_num_in': 'list[int]',
        'suspended_vm_num_lt': 'int',
        'suspended_vm_num_lte': 'int',
        'suspended_vm_num_not': 'int',
        'suspended_vm_num_not_in': 'list[int]',
        'total_cache_capacity': 'int',
        'total_cache_capacity_gt': 'int',
        'total_cache_capacity_gte': 'int',
        'total_cache_capacity_in': 'list[int]',
        'total_cache_capacity_lt': 'int',
        'total_cache_capacity_lte': 'int',
        'total_cache_capacity_not': 'int',
        'total_cache_capacity_not_in': 'list[int]',
        'total_cpu_cores': 'int',
        'total_cpu_cores_gt': 'int',
        'total_cpu_cores_gte': 'int',
        'total_cpu_cores_in': 'list[int]',
        'total_cpu_cores_lt': 'int',
        'total_cpu_cores_lte': 'int',
        'total_cpu_cores_not': 'int',
        'total_cpu_cores_not_in': 'list[int]',
        'total_cpu_hz': 'int',
        'total_cpu_hz_gt': 'int',
        'total_cpu_hz_gte': 'int',
        'total_cpu_hz_in': 'list[int]',
        'total_cpu_hz_lt': 'int',
        'total_cpu_hz_lte': 'int',
        'total_cpu_hz_not': 'int',
        'total_cpu_hz_not_in': 'list[int]',
        'total_data_capacity': 'int',
        'total_data_capacity_gt': 'int',
        'total_data_capacity_gte': 'int',
        'total_data_capacity_in': 'list[int]',
        'total_data_capacity_lt': 'int',
        'total_data_capacity_lte': 'int',
        'total_data_capacity_not': 'int',
        'total_data_capacity_not_in': 'list[int]',
        'total_memory_bytes': 'int',
        'total_memory_bytes_gt': 'int',
        'total_memory_bytes_gte': 'int',
        'total_memory_bytes_in': 'list[int]',
        'total_memory_bytes_lt': 'int',
        'total_memory_bytes_lte': 'int',
        'total_memory_bytes_not': 'int',
        'total_memory_bytes_not_in': 'list[int]',
        'used_data_space': 'int',
        'used_data_space_gt': 'int',
        'used_data_space_gte': 'int',
        'used_data_space_in': 'list[int]',
        'used_data_space_lt': 'int',
        'used_data_space_lte': 'int',
        'used_data_space_not': 'int',
        'used_data_space_not_in': 'list[int]',
        'valid_data_space': 'int',
        'valid_data_space_gt': 'int',
        'valid_data_space_gte': 'int',
        'valid_data_space_in': 'list[int]',
        'valid_data_space_lt': 'int',
        'valid_data_space_lte': 'int',
        'valid_data_space_not': 'int',
        'valid_data_space_not_in': 'list[int]',
        'vm_num': 'int',
        'vm_num_gt': 'int',
        'vm_num_gte': 'int',
        'vm_num_in': 'list[int]',
        'vm_num_lt': 'int',
        'vm_num_lte': 'int',
        'vm_num_not': 'int',
        'vm_num_not_in': 'list[int]'
    }

    attribute_map = {
        '_and': 'AND',
        '_not': 'NOT',
        '_or': 'OR',
        'cluster': 'cluster',
        'datacenter': 'datacenter',
        'failure_data_space': 'failure_data_space',
        'failure_data_space_gt': 'failure_data_space_gt',
        'failure_data_space_gte': 'failure_data_space_gte',
        'failure_data_space_in': 'failure_data_space_in',
        'failure_data_space_lt': 'failure_data_space_lt',
        'failure_data_space_lte': 'failure_data_space_lte',
        'failure_data_space_not': 'failure_data_space_not',
        'failure_data_space_not_in': 'failure_data_space_not_in',
        'host_num': 'host_num',
        'host_num_gt': 'host_num_gt',
        'host_num_gte': 'host_num_gte',
        'host_num_in': 'host_num_in',
        'host_num_lt': 'host_num_lt',
        'host_num_lte': 'host_num_lte',
        'host_num_not': 'host_num_not',
        'host_num_not_in': 'host_num_not_in',
        'hosts_every': 'hosts_every',
        'hosts_none': 'hosts_none',
        'hosts_some': 'hosts_some',
        'id': 'id',
        'id_contains': 'id_contains',
        'id_ends_with': 'id_ends_with',
        'id_gt': 'id_gt',
        'id_gte': 'id_gte',
        'id_in': 'id_in',
        'id_lt': 'id_lt',
        'id_lte': 'id_lte',
        'id_not': 'id_not',
        'id_not_contains': 'id_not_contains',
        'id_not_ends_with': 'id_not_ends_with',
        'id_not_in': 'id_not_in',
        'id_not_starts_with': 'id_not_starts_with',
        'id_starts_with': 'id_starts_with',
        'is_preferred': 'is_preferred',
        'is_preferred_not': 'is_preferred_not',
        'local_id': 'local_id',
        'local_id_contains': 'local_id_contains',
        'local_id_ends_with': 'local_id_ends_with',
        'local_id_gt': 'local_id_gt',
        'local_id_gte': 'local_id_gte',
        'local_id_in': 'local_id_in',
        'local_id_lt': 'local_id_lt',
        'local_id_lte': 'local_id_lte',
        'local_id_not': 'local_id_not',
        'local_id_not_contains': 'local_id_not_contains',
        'local_id_not_ends_with': 'local_id_not_ends_with',
        'local_id_not_in': 'local_id_not_in',
        'local_id_not_starts_with': 'local_id_not_starts_with',
        'local_id_starts_with': 'local_id_starts_with',
        'provisioned_cpu_cores': 'provisioned_cpu_cores',
        'provisioned_cpu_cores_for_active_vm': 'provisioned_cpu_cores_for_active_vm',
        'provisioned_cpu_cores_for_active_vm_gt': 'provisioned_cpu_cores_for_active_vm_gt',
        'provisioned_cpu_cores_for_active_vm_gte': 'provisioned_cpu_cores_for_active_vm_gte',
        'provisioned_cpu_cores_for_active_vm_in': 'provisioned_cpu_cores_for_active_vm_in',
        'provisioned_cpu_cores_for_active_vm_lt': 'provisioned_cpu_cores_for_active_vm_lt',
        'provisioned_cpu_cores_for_active_vm_lte': 'provisioned_cpu_cores_for_active_vm_lte',
        'provisioned_cpu_cores_for_active_vm_not': 'provisioned_cpu_cores_for_active_vm_not',
        'provisioned_cpu_cores_for_active_vm_not_in': 'provisioned_cpu_cores_for_active_vm_not_in',
        'provisioned_cpu_cores_gt': 'provisioned_cpu_cores_gt',
        'provisioned_cpu_cores_gte': 'provisioned_cpu_cores_gte',
        'provisioned_cpu_cores_in': 'provisioned_cpu_cores_in',
        'provisioned_cpu_cores_lt': 'provisioned_cpu_cores_lt',
        'provisioned_cpu_cores_lte': 'provisioned_cpu_cores_lte',
        'provisioned_cpu_cores_not': 'provisioned_cpu_cores_not',
        'provisioned_cpu_cores_not_in': 'provisioned_cpu_cores_not_in',
        'provisioned_data_space': 'provisioned_data_space',
        'provisioned_data_space_gt': 'provisioned_data_space_gt',
        'provisioned_data_space_gte': 'provisioned_data_space_gte',
        'provisioned_data_space_in': 'provisioned_data_space_in',
        'provisioned_data_space_lt': 'provisioned_data_space_lt',
        'provisioned_data_space_lte': 'provisioned_data_space_lte',
        'provisioned_data_space_not': 'provisioned_data_space_not',
        'provisioned_data_space_not_in': 'provisioned_data_space_not_in',
        'provisioned_memory_bytes': 'provisioned_memory_bytes',
        'provisioned_memory_bytes_gt': 'provisioned_memory_bytes_gt',
        'provisioned_memory_bytes_gte': 'provisioned_memory_bytes_gte',
        'provisioned_memory_bytes_in': 'provisioned_memory_bytes_in',
        'provisioned_memory_bytes_lt': 'provisioned_memory_bytes_lt',
        'provisioned_memory_bytes_lte': 'provisioned_memory_bytes_lte',
        'provisioned_memory_bytes_not': 'provisioned_memory_bytes_not',
        'provisioned_memory_bytes_not_in': 'provisioned_memory_bytes_not_in',
        'running_vm_num': 'running_vm_num',
        'running_vm_num_gt': 'running_vm_num_gt',
        'running_vm_num_gte': 'running_vm_num_gte',
        'running_vm_num_in': 'running_vm_num_in',
        'running_vm_num_lt': 'running_vm_num_lt',
        'running_vm_num_lte': 'running_vm_num_lte',
        'running_vm_num_not': 'running_vm_num_not',
        'running_vm_num_not_in': 'running_vm_num_not_in',
        'stopped_vm_num': 'stopped_vm_num',
        'stopped_vm_num_gt': 'stopped_vm_num_gt',
        'stopped_vm_num_gte': 'stopped_vm_num_gte',
        'stopped_vm_num_in': 'stopped_vm_num_in',
        'stopped_vm_num_lt': 'stopped_vm_num_lt',
        'stopped_vm_num_lte': 'stopped_vm_num_lte',
        'stopped_vm_num_not': 'stopped_vm_num_not',
        'stopped_vm_num_not_in': 'stopped_vm_num_not_in',
        'suspended_vm_num': 'suspended_vm_num',
        'suspended_vm_num_gt': 'suspended_vm_num_gt',
        'suspended_vm_num_gte': 'suspended_vm_num_gte',
        'suspended_vm_num_in': 'suspended_vm_num_in',
        'suspended_vm_num_lt': 'suspended_vm_num_lt',
        'suspended_vm_num_lte': 'suspended_vm_num_lte',
        'suspended_vm_num_not': 'suspended_vm_num_not',
        'suspended_vm_num_not_in': 'suspended_vm_num_not_in',
        'total_cache_capacity': 'total_cache_capacity',
        'total_cache_capacity_gt': 'total_cache_capacity_gt',
        'total_cache_capacity_gte': 'total_cache_capacity_gte',
        'total_cache_capacity_in': 'total_cache_capacity_in',
        'total_cache_capacity_lt': 'total_cache_capacity_lt',
        'total_cache_capacity_lte': 'total_cache_capacity_lte',
        'total_cache_capacity_not': 'total_cache_capacity_not',
        'total_cache_capacity_not_in': 'total_cache_capacity_not_in',
        'total_cpu_cores': 'total_cpu_cores',
        'total_cpu_cores_gt': 'total_cpu_cores_gt',
        'total_cpu_cores_gte': 'total_cpu_cores_gte',
        'total_cpu_cores_in': 'total_cpu_cores_in',
        'total_cpu_cores_lt': 'total_cpu_cores_lt',
        'total_cpu_cores_lte': 'total_cpu_cores_lte',
        'total_cpu_cores_not': 'total_cpu_cores_not',
        'total_cpu_cores_not_in': 'total_cpu_cores_not_in',
        'total_cpu_hz': 'total_cpu_hz',
        'total_cpu_hz_gt': 'total_cpu_hz_gt',
        'total_cpu_hz_gte': 'total_cpu_hz_gte',
        'total_cpu_hz_in': 'total_cpu_hz_in',
        'total_cpu_hz_lt': 'total_cpu_hz_lt',
        'total_cpu_hz_lte': 'total_cpu_hz_lte',
        'total_cpu_hz_not': 'total_cpu_hz_not',
        'total_cpu_hz_not_in': 'total_cpu_hz_not_in',
        'total_data_capacity': 'total_data_capacity',
        'total_data_capacity_gt': 'total_data_capacity_gt',
        'total_data_capacity_gte': 'total_data_capacity_gte',
        'total_data_capacity_in': 'total_data_capacity_in',
        'total_data_capacity_lt': 'total_data_capacity_lt',
        'total_data_capacity_lte': 'total_data_capacity_lte',
        'total_data_capacity_not': 'total_data_capacity_not',
        'total_data_capacity_not_in': 'total_data_capacity_not_in',
        'total_memory_bytes': 'total_memory_bytes',
        'total_memory_bytes_gt': 'total_memory_bytes_gt',
        'total_memory_bytes_gte': 'total_memory_bytes_gte',
        'total_memory_bytes_in': 'total_memory_bytes_in',
        'total_memory_bytes_lt': 'total_memory_bytes_lt',
        'total_memory_bytes_lte': 'total_memory_bytes_lte',
        'total_memory_bytes_not': 'total_memory_bytes_not',
        'total_memory_bytes_not_in': 'total_memory_bytes_not_in',
        'used_data_space': 'used_data_space',
        'used_data_space_gt': 'used_data_space_gt',
        'used_data_space_gte': 'used_data_space_gte',
        'used_data_space_in': 'used_data_space_in',
        'used_data_space_lt': 'used_data_space_lt',
        'used_data_space_lte': 'used_data_space_lte',
        'used_data_space_not': 'used_data_space_not',
        'used_data_space_not_in': 'used_data_space_not_in',
        'valid_data_space': 'valid_data_space',
        'valid_data_space_gt': 'valid_data_space_gt',
        'valid_data_space_gte': 'valid_data_space_gte',
        'valid_data_space_in': 'valid_data_space_in',
        'valid_data_space_lt': 'valid_data_space_lt',
        'valid_data_space_lte': 'valid_data_space_lte',
        'valid_data_space_not': 'valid_data_space_not',
        'valid_data_space_not_in': 'valid_data_space_not_in',
        'vm_num': 'vm_num',
        'vm_num_gt': 'vm_num_gt',
        'vm_num_gte': 'vm_num_gte',
        'vm_num_in': 'vm_num_in',
        'vm_num_lt': 'vm_num_lt',
        'vm_num_lte': 'vm_num_lte',
        'vm_num_not': 'vm_num_not',
        'vm_num_not_in': 'vm_num_not_in'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """ZoneWhereInput - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self.__and = None
        self.__not = None
        self.__or = None
        self._cluster = None
        self._datacenter = None
        self._failure_data_space = None
        self._failure_data_space_gt = None
        self._failure_data_space_gte = None
        self._failure_data_space_in = None
        self._failure_data_space_lt = None
        self._failure_data_space_lte = None
        self._failure_data_space_not = None
        self._failure_data_space_not_in = None
        self._host_num = None
        self._host_num_gt = None
        self._host_num_gte = None
        self._host_num_in = None
        self._host_num_lt = None
        self._host_num_lte = None
        self._host_num_not = None
        self._host_num_not_in = None
        self._hosts_every = None
        self._hosts_none = None
        self._hosts_some = None
        self._id = None
        self._id_contains = None
        self._id_ends_with = None
        self._id_gt = None
        self._id_gte = None
        self._id_in = None
        self._id_lt = None
        self._id_lte = None
        self._id_not = None
        self._id_not_contains = None
        self._id_not_ends_with = None
        self._id_not_in = None
        self._id_not_starts_with = None
        self._id_starts_with = None
        self._is_preferred = None
        self._is_preferred_not = None
        self._local_id = None
        self._local_id_contains = None
        self._local_id_ends_with = None
        self._local_id_gt = None
        self._local_id_gte = None
        self._local_id_in = None
        self._local_id_lt = None
        self._local_id_lte = None
        self._local_id_not = None
        self._local_id_not_contains = None
        self._local_id_not_ends_with = None
        self._local_id_not_in = None
        self._local_id_not_starts_with = None
        self._local_id_starts_with = None
        self._provisioned_cpu_cores = None
        self._provisioned_cpu_cores_for_active_vm = None
        self._provisioned_cpu_cores_for_active_vm_gt = None
        self._provisioned_cpu_cores_for_active_vm_gte = None
        self._provisioned_cpu_cores_for_active_vm_in = None
        self._provisioned_cpu_cores_for_active_vm_lt = None
        self._provisioned_cpu_cores_for_active_vm_lte = None
        self._provisioned_cpu_cores_for_active_vm_not = None
        self._provisioned_cpu_cores_for_active_vm_not_in = None
        self._provisioned_cpu_cores_gt = None
        self._provisioned_cpu_cores_gte = None
        self._provisioned_cpu_cores_in = None
        self._provisioned_cpu_cores_lt = None
        self._provisioned_cpu_cores_lte = None
        self._provisioned_cpu_cores_not = None
        self._provisioned_cpu_cores_not_in = None
        self._provisioned_data_space = None
        self._provisioned_data_space_gt = None
        self._provisioned_data_space_gte = None
        self._provisioned_data_space_in = None
        self._provisioned_data_space_lt = None
        self._provisioned_data_space_lte = None
        self._provisioned_data_space_not = None
        self._provisioned_data_space_not_in = None
        self._provisioned_memory_bytes = None
        self._provisioned_memory_bytes_gt = None
        self._provisioned_memory_bytes_gte = None
        self._provisioned_memory_bytes_in = None
        self._provisioned_memory_bytes_lt = None
        self._provisioned_memory_bytes_lte = None
        self._provisioned_memory_bytes_not = None
        self._provisioned_memory_bytes_not_in = None
        self._running_vm_num = None
        self._running_vm_num_gt = None
        self._running_vm_num_gte = None
        self._running_vm_num_in = None
        self._running_vm_num_lt = None
        self._running_vm_num_lte = None
        self._running_vm_num_not = None
        self._running_vm_num_not_in = None
        self._stopped_vm_num = None
        self._stopped_vm_num_gt = None
        self._stopped_vm_num_gte = None
        self._stopped_vm_num_in = None
        self._stopped_vm_num_lt = None
        self._stopped_vm_num_lte = None
        self._stopped_vm_num_not = None
        self._stopped_vm_num_not_in = None
        self._suspended_vm_num = None
        self._suspended_vm_num_gt = None
        self._suspended_vm_num_gte = None
        self._suspended_vm_num_in = None
        self._suspended_vm_num_lt = None
        self._suspended_vm_num_lte = None
        self._suspended_vm_num_not = None
        self._suspended_vm_num_not_in = None
        self._total_cache_capacity = None
        self._total_cache_capacity_gt = None
        self._total_cache_capacity_gte = None
        self._total_cache_capacity_in = None
        self._total_cache_capacity_lt = None
        self._total_cache_capacity_lte = None
        self._total_cache_capacity_not = None
        self._total_cache_capacity_not_in = None
        self._total_cpu_cores = None
        self._total_cpu_cores_gt = None
        self._total_cpu_cores_gte = None
        self._total_cpu_cores_in = None
        self._total_cpu_cores_lt = None
        self._total_cpu_cores_lte = None
        self._total_cpu_cores_not = None
        self._total_cpu_cores_not_in = None
        self._total_cpu_hz = None
        self._total_cpu_hz_gt = None
        self._total_cpu_hz_gte = None
        self._total_cpu_hz_in = None
        self._total_cpu_hz_lt = None
        self._total_cpu_hz_lte = None
        self._total_cpu_hz_not = None
        self._total_cpu_hz_not_in = None
        self._total_data_capacity = None
        self._total_data_capacity_gt = None
        self._total_data_capacity_gte = None
        self._total_data_capacity_in = None
        self._total_data_capacity_lt = None
        self._total_data_capacity_lte = None
        self._total_data_capacity_not = None
        self._total_data_capacity_not_in = None
        self._total_memory_bytes = None
        self._total_memory_bytes_gt = None
        self._total_memory_bytes_gte = None
        self._total_memory_bytes_in = None
        self._total_memory_bytes_lt = None
        self._total_memory_bytes_lte = None
        self._total_memory_bytes_not = None
        self._total_memory_bytes_not_in = None
        self._used_data_space = None
        self._used_data_space_gt = None
        self._used_data_space_gte = None
        self._used_data_space_in = None
        self._used_data_space_lt = None
        self._used_data_space_lte = None
        self._used_data_space_not = None
        self._used_data_space_not_in = None
        self._valid_data_space = None
        self._valid_data_space_gt = None
        self._valid_data_space_gte = None
        self._valid_data_space_in = None
        self._valid_data_space_lt = None
        self._valid_data_space_lte = None
        self._valid_data_space_not = None
        self._valid_data_space_not_in = None
        self._vm_num = None
        self._vm_num_gt = None
        self._vm_num_gte = None
        self._vm_num_in = None
        self._vm_num_lt = None
        self._vm_num_lte = None
        self._vm_num_not = None
        self._vm_num_not_in = None
        self.discriminator = None

        self._and = kwargs.get("_and", None)
        self._not = kwargs.get("_not", None)
        self._or = kwargs.get("_or", None)
        self.cluster = kwargs.get("cluster", None)
        self.datacenter = kwargs.get("datacenter", None)
        self.failure_data_space = kwargs.get("failure_data_space", None)
        self.failure_data_space_gt = kwargs.get("failure_data_space_gt", None)
        self.failure_data_space_gte = kwargs.get("failure_data_space_gte", None)
        self.failure_data_space_in = kwargs.get("failure_data_space_in", None)
        self.failure_data_space_lt = kwargs.get("failure_data_space_lt", None)
        self.failure_data_space_lte = kwargs.get("failure_data_space_lte", None)
        self.failure_data_space_not = kwargs.get("failure_data_space_not", None)
        self.failure_data_space_not_in = kwargs.get("failure_data_space_not_in", None)
        self.host_num = kwargs.get("host_num", None)
        self.host_num_gt = kwargs.get("host_num_gt", None)
        self.host_num_gte = kwargs.get("host_num_gte", None)
        self.host_num_in = kwargs.get("host_num_in", None)
        self.host_num_lt = kwargs.get("host_num_lt", None)
        self.host_num_lte = kwargs.get("host_num_lte", None)
        self.host_num_not = kwargs.get("host_num_not", None)
        self.host_num_not_in = kwargs.get("host_num_not_in", None)
        self.hosts_every = kwargs.get("hosts_every", None)
        self.hosts_none = kwargs.get("hosts_none", None)
        self.hosts_some = kwargs.get("hosts_some", None)
        self.id = kwargs.get("id", None)
        self.id_contains = kwargs.get("id_contains", None)
        self.id_ends_with = kwargs.get("id_ends_with", None)
        self.id_gt = kwargs.get("id_gt", None)
        self.id_gte = kwargs.get("id_gte", None)
        self.id_in = kwargs.get("id_in", None)
        self.id_lt = kwargs.get("id_lt", None)
        self.id_lte = kwargs.get("id_lte", None)
        self.id_not = kwargs.get("id_not", None)
        self.id_not_contains = kwargs.get("id_not_contains", None)
        self.id_not_ends_with = kwargs.get("id_not_ends_with", None)
        self.id_not_in = kwargs.get("id_not_in", None)
        self.id_not_starts_with = kwargs.get("id_not_starts_with", None)
        self.id_starts_with = kwargs.get("id_starts_with", None)
        self.is_preferred = kwargs.get("is_preferred", None)
        self.is_preferred_not = kwargs.get("is_preferred_not", None)
        self.local_id = kwargs.get("local_id", None)
        self.local_id_contains = kwargs.get("local_id_contains", None)
        self.local_id_ends_with = kwargs.get("local_id_ends_with", None)
        self.local_id_gt = kwargs.get("local_id_gt", None)
        self.local_id_gte = kwargs.get("local_id_gte", None)
        self.local_id_in = kwargs.get("local_id_in", None)
        self.local_id_lt = kwargs.get("local_id_lt", None)
        self.local_id_lte = kwargs.get("local_id_lte", None)
        self.local_id_not = kwargs.get("local_id_not", None)
        self.local_id_not_contains = kwargs.get("local_id_not_contains", None)
        self.local_id_not_ends_with = kwargs.get("local_id_not_ends_with", None)
        self.local_id_not_in = kwargs.get("local_id_not_in", None)
        self.local_id_not_starts_with = kwargs.get("local_id_not_starts_with", None)
        self.local_id_starts_with = kwargs.get("local_id_starts_with", None)
        self.provisioned_cpu_cores = kwargs.get("provisioned_cpu_cores", None)
        self.provisioned_cpu_cores_for_active_vm = kwargs.get("provisioned_cpu_cores_for_active_vm", None)
        self.provisioned_cpu_cores_for_active_vm_gt = kwargs.get("provisioned_cpu_cores_for_active_vm_gt", None)
        self.provisioned_cpu_cores_for_active_vm_gte = kwargs.get("provisioned_cpu_cores_for_active_vm_gte", None)
        self.provisioned_cpu_cores_for_active_vm_in = kwargs.get("provisioned_cpu_cores_for_active_vm_in", None)
        self.provisioned_cpu_cores_for_active_vm_lt = kwargs.get("provisioned_cpu_cores_for_active_vm_lt", None)
        self.provisioned_cpu_cores_for_active_vm_lte = kwargs.get("provisioned_cpu_cores_for_active_vm_lte", None)
        self.provisioned_cpu_cores_for_active_vm_not = kwargs.get("provisioned_cpu_cores_for_active_vm_not", None)
        self.provisioned_cpu_cores_for_active_vm_not_in = kwargs.get("provisioned_cpu_cores_for_active_vm_not_in", None)
        self.provisioned_cpu_cores_gt = kwargs.get("provisioned_cpu_cores_gt", None)
        self.provisioned_cpu_cores_gte = kwargs.get("provisioned_cpu_cores_gte", None)
        self.provisioned_cpu_cores_in = kwargs.get("provisioned_cpu_cores_in", None)
        self.provisioned_cpu_cores_lt = kwargs.get("provisioned_cpu_cores_lt", None)
        self.provisioned_cpu_cores_lte = kwargs.get("provisioned_cpu_cores_lte", None)
        self.provisioned_cpu_cores_not = kwargs.get("provisioned_cpu_cores_not", None)
        self.provisioned_cpu_cores_not_in = kwargs.get("provisioned_cpu_cores_not_in", None)
        self.provisioned_data_space = kwargs.get("provisioned_data_space", None)
        self.provisioned_data_space_gt = kwargs.get("provisioned_data_space_gt", None)
        self.provisioned_data_space_gte = kwargs.get("provisioned_data_space_gte", None)
        self.provisioned_data_space_in = kwargs.get("provisioned_data_space_in", None)
        self.provisioned_data_space_lt = kwargs.get("provisioned_data_space_lt", None)
        self.provisioned_data_space_lte = kwargs.get("provisioned_data_space_lte", None)
        self.provisioned_data_space_not = kwargs.get("provisioned_data_space_not", None)
        self.provisioned_data_space_not_in = kwargs.get("provisioned_data_space_not_in", None)
        self.provisioned_memory_bytes = kwargs.get("provisioned_memory_bytes", None)
        self.provisioned_memory_bytes_gt = kwargs.get("provisioned_memory_bytes_gt", None)
        self.provisioned_memory_bytes_gte = kwargs.get("provisioned_memory_bytes_gte", None)
        self.provisioned_memory_bytes_in = kwargs.get("provisioned_memory_bytes_in", None)
        self.provisioned_memory_bytes_lt = kwargs.get("provisioned_memory_bytes_lt", None)
        self.provisioned_memory_bytes_lte = kwargs.get("provisioned_memory_bytes_lte", None)
        self.provisioned_memory_bytes_not = kwargs.get("provisioned_memory_bytes_not", None)
        self.provisioned_memory_bytes_not_in = kwargs.get("provisioned_memory_bytes_not_in", None)
        self.running_vm_num = kwargs.get("running_vm_num", None)
        self.running_vm_num_gt = kwargs.get("running_vm_num_gt", None)
        self.running_vm_num_gte = kwargs.get("running_vm_num_gte", None)
        self.running_vm_num_in = kwargs.get("running_vm_num_in", None)
        self.running_vm_num_lt = kwargs.get("running_vm_num_lt", None)
        self.running_vm_num_lte = kwargs.get("running_vm_num_lte", None)
        self.running_vm_num_not = kwargs.get("running_vm_num_not", None)
        self.running_vm_num_not_in = kwargs.get("running_vm_num_not_in", None)
        self.stopped_vm_num = kwargs.get("stopped_vm_num", None)
        self.stopped_vm_num_gt = kwargs.get("stopped_vm_num_gt", None)
        self.stopped_vm_num_gte = kwargs.get("stopped_vm_num_gte", None)
        self.stopped_vm_num_in = kwargs.get("stopped_vm_num_in", None)
        self.stopped_vm_num_lt = kwargs.get("stopped_vm_num_lt", None)
        self.stopped_vm_num_lte = kwargs.get("stopped_vm_num_lte", None)
        self.stopped_vm_num_not = kwargs.get("stopped_vm_num_not", None)
        self.stopped_vm_num_not_in = kwargs.get("stopped_vm_num_not_in", None)
        self.suspended_vm_num = kwargs.get("suspended_vm_num", None)
        self.suspended_vm_num_gt = kwargs.get("suspended_vm_num_gt", None)
        self.suspended_vm_num_gte = kwargs.get("suspended_vm_num_gte", None)
        self.suspended_vm_num_in = kwargs.get("suspended_vm_num_in", None)
        self.suspended_vm_num_lt = kwargs.get("suspended_vm_num_lt", None)
        self.suspended_vm_num_lte = kwargs.get("suspended_vm_num_lte", None)
        self.suspended_vm_num_not = kwargs.get("suspended_vm_num_not", None)
        self.suspended_vm_num_not_in = kwargs.get("suspended_vm_num_not_in", None)
        self.total_cache_capacity = kwargs.get("total_cache_capacity", None)
        self.total_cache_capacity_gt = kwargs.get("total_cache_capacity_gt", None)
        self.total_cache_capacity_gte = kwargs.get("total_cache_capacity_gte", None)
        self.total_cache_capacity_in = kwargs.get("total_cache_capacity_in", None)
        self.total_cache_capacity_lt = kwargs.get("total_cache_capacity_lt", None)
        self.total_cache_capacity_lte = kwargs.get("total_cache_capacity_lte", None)
        self.total_cache_capacity_not = kwargs.get("total_cache_capacity_not", None)
        self.total_cache_capacity_not_in = kwargs.get("total_cache_capacity_not_in", None)
        self.total_cpu_cores = kwargs.get("total_cpu_cores", None)
        self.total_cpu_cores_gt = kwargs.get("total_cpu_cores_gt", None)
        self.total_cpu_cores_gte = kwargs.get("total_cpu_cores_gte", None)
        self.total_cpu_cores_in = kwargs.get("total_cpu_cores_in", None)
        self.total_cpu_cores_lt = kwargs.get("total_cpu_cores_lt", None)
        self.total_cpu_cores_lte = kwargs.get("total_cpu_cores_lte", None)
        self.total_cpu_cores_not = kwargs.get("total_cpu_cores_not", None)
        self.total_cpu_cores_not_in = kwargs.get("total_cpu_cores_not_in", None)
        self.total_cpu_hz = kwargs.get("total_cpu_hz", None)
        self.total_cpu_hz_gt = kwargs.get("total_cpu_hz_gt", None)
        self.total_cpu_hz_gte = kwargs.get("total_cpu_hz_gte", None)
        self.total_cpu_hz_in = kwargs.get("total_cpu_hz_in", None)
        self.total_cpu_hz_lt = kwargs.get("total_cpu_hz_lt", None)
        self.total_cpu_hz_lte = kwargs.get("total_cpu_hz_lte", None)
        self.total_cpu_hz_not = kwargs.get("total_cpu_hz_not", None)
        self.total_cpu_hz_not_in = kwargs.get("total_cpu_hz_not_in", None)
        self.total_data_capacity = kwargs.get("total_data_capacity", None)
        self.total_data_capacity_gt = kwargs.get("total_data_capacity_gt", None)
        self.total_data_capacity_gte = kwargs.get("total_data_capacity_gte", None)
        self.total_data_capacity_in = kwargs.get("total_data_capacity_in", None)
        self.total_data_capacity_lt = kwargs.get("total_data_capacity_lt", None)
        self.total_data_capacity_lte = kwargs.get("total_data_capacity_lte", None)
        self.total_data_capacity_not = kwargs.get("total_data_capacity_not", None)
        self.total_data_capacity_not_in = kwargs.get("total_data_capacity_not_in", None)
        self.total_memory_bytes = kwargs.get("total_memory_bytes", None)
        self.total_memory_bytes_gt = kwargs.get("total_memory_bytes_gt", None)
        self.total_memory_bytes_gte = kwargs.get("total_memory_bytes_gte", None)
        self.total_memory_bytes_in = kwargs.get("total_memory_bytes_in", None)
        self.total_memory_bytes_lt = kwargs.get("total_memory_bytes_lt", None)
        self.total_memory_bytes_lte = kwargs.get("total_memory_bytes_lte", None)
        self.total_memory_bytes_not = kwargs.get("total_memory_bytes_not", None)
        self.total_memory_bytes_not_in = kwargs.get("total_memory_bytes_not_in", None)
        self.used_data_space = kwargs.get("used_data_space", None)
        self.used_data_space_gt = kwargs.get("used_data_space_gt", None)
        self.used_data_space_gte = kwargs.get("used_data_space_gte", None)
        self.used_data_space_in = kwargs.get("used_data_space_in", None)
        self.used_data_space_lt = kwargs.get("used_data_space_lt", None)
        self.used_data_space_lte = kwargs.get("used_data_space_lte", None)
        self.used_data_space_not = kwargs.get("used_data_space_not", None)
        self.used_data_space_not_in = kwargs.get("used_data_space_not_in", None)
        self.valid_data_space = kwargs.get("valid_data_space", None)
        self.valid_data_space_gt = kwargs.get("valid_data_space_gt", None)
        self.valid_data_space_gte = kwargs.get("valid_data_space_gte", None)
        self.valid_data_space_in = kwargs.get("valid_data_space_in", None)
        self.valid_data_space_lt = kwargs.get("valid_data_space_lt", None)
        self.valid_data_space_lte = kwargs.get("valid_data_space_lte", None)
        self.valid_data_space_not = kwargs.get("valid_data_space_not", None)
        self.valid_data_space_not_in = kwargs.get("valid_data_space_not_in", None)
        self.vm_num = kwargs.get("vm_num", None)
        self.vm_num_gt = kwargs.get("vm_num_gt", None)
        self.vm_num_gte = kwargs.get("vm_num_gte", None)
        self.vm_num_in = kwargs.get("vm_num_in", None)
        self.vm_num_lt = kwargs.get("vm_num_lt", None)
        self.vm_num_lte = kwargs.get("vm_num_lte", None)
        self.vm_num_not = kwargs.get("vm_num_not", None)
        self.vm_num_not_in = kwargs.get("vm_num_not_in", None)

    @property
    def _and(self):
        """Gets the _and of this ZoneWhereInput.  # noqa: E501


        :return: The _and of this ZoneWhereInput.  # noqa: E501
        :rtype: list[ZoneWhereInput]
        """
        return self.__and

    @_and.setter
    def _and(self, _and):
        """Sets the _and of this ZoneWhereInput.


        :param _and: The _and of this ZoneWhereInput.  # noqa: E501
        :type _and: list[ZoneWhereInput]
        """

        self.__and = _and

    @property
    def _not(self):
        """Gets the _not of this ZoneWhereInput.  # noqa: E501


        :return: The _not of this ZoneWhereInput.  # noqa: E501
        :rtype: list[ZoneWhereInput]
        """
        return self.__not

    @_not.setter
    def _not(self, _not):
        """Sets the _not of this ZoneWhereInput.


        :param _not: The _not of this ZoneWhereInput.  # noqa: E501
        :type _not: list[ZoneWhereInput]
        """

        self.__not = _not

    @property
    def _or(self):
        """Gets the _or of this ZoneWhereInput.  # noqa: E501


        :return: The _or of this ZoneWhereInput.  # noqa: E501
        :rtype: list[ZoneWhereInput]
        """
        return self.__or

    @_or.setter
    def _or(self, _or):
        """Sets the _or of this ZoneWhereInput.


        :param _or: The _or of this ZoneWhereInput.  # noqa: E501
        :type _or: list[ZoneWhereInput]
        """

        self.__or = _or

    @property
    def cluster(self):
        """Gets the cluster of this ZoneWhereInput.  # noqa: E501


        :return: The cluster of this ZoneWhereInput.  # noqa: E501
        :rtype: ClusterWhereInput
        """
        return self._cluster

    @cluster.setter
    def cluster(self, cluster):
        """Sets the cluster of this ZoneWhereInput.


        :param cluster: The cluster of this ZoneWhereInput.  # noqa: E501
        :type cluster: ClusterWhereInput
        """

        self._cluster = cluster

    @property
    def datacenter(self):
        """Gets the datacenter of this ZoneWhereInput.  # noqa: E501


        :return: The datacenter of this ZoneWhereInput.  # noqa: E501
        :rtype: DatacenterWhereInput
        """
        return self._datacenter

    @datacenter.setter
    def datacenter(self, datacenter):
        """Sets the datacenter of this ZoneWhereInput.


        :param datacenter: The datacenter of this ZoneWhereInput.  # noqa: E501
        :type datacenter: DatacenterWhereInput
        """

        self._datacenter = datacenter

    @property
    def failure_data_space(self):
        """Gets the failure_data_space of this ZoneWhereInput.  # noqa: E501


        :return: The failure_data_space of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._failure_data_space

    @failure_data_space.setter
    def failure_data_space(self, failure_data_space):
        """Sets the failure_data_space of this ZoneWhereInput.


        :param failure_data_space: The failure_data_space of this ZoneWhereInput.  # noqa: E501
        :type failure_data_space: int
        """

        self._failure_data_space = failure_data_space

    @property
    def failure_data_space_gt(self):
        """Gets the failure_data_space_gt of this ZoneWhereInput.  # noqa: E501


        :return: The failure_data_space_gt of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._failure_data_space_gt

    @failure_data_space_gt.setter
    def failure_data_space_gt(self, failure_data_space_gt):
        """Sets the failure_data_space_gt of this ZoneWhereInput.


        :param failure_data_space_gt: The failure_data_space_gt of this ZoneWhereInput.  # noqa: E501
        :type failure_data_space_gt: int
        """

        self._failure_data_space_gt = failure_data_space_gt

    @property
    def failure_data_space_gte(self):
        """Gets the failure_data_space_gte of this ZoneWhereInput.  # noqa: E501


        :return: The failure_data_space_gte of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._failure_data_space_gte

    @failure_data_space_gte.setter
    def failure_data_space_gte(self, failure_data_space_gte):
        """Sets the failure_data_space_gte of this ZoneWhereInput.


        :param failure_data_space_gte: The failure_data_space_gte of this ZoneWhereInput.  # noqa: E501
        :type failure_data_space_gte: int
        """

        self._failure_data_space_gte = failure_data_space_gte

    @property
    def failure_data_space_in(self):
        """Gets the failure_data_space_in of this ZoneWhereInput.  # noqa: E501


        :return: The failure_data_space_in of this ZoneWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._failure_data_space_in

    @failure_data_space_in.setter
    def failure_data_space_in(self, failure_data_space_in):
        """Sets the failure_data_space_in of this ZoneWhereInput.


        :param failure_data_space_in: The failure_data_space_in of this ZoneWhereInput.  # noqa: E501
        :type failure_data_space_in: list[int]
        """

        self._failure_data_space_in = failure_data_space_in

    @property
    def failure_data_space_lt(self):
        """Gets the failure_data_space_lt of this ZoneWhereInput.  # noqa: E501


        :return: The failure_data_space_lt of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._failure_data_space_lt

    @failure_data_space_lt.setter
    def failure_data_space_lt(self, failure_data_space_lt):
        """Sets the failure_data_space_lt of this ZoneWhereInput.


        :param failure_data_space_lt: The failure_data_space_lt of this ZoneWhereInput.  # noqa: E501
        :type failure_data_space_lt: int
        """

        self._failure_data_space_lt = failure_data_space_lt

    @property
    def failure_data_space_lte(self):
        """Gets the failure_data_space_lte of this ZoneWhereInput.  # noqa: E501


        :return: The failure_data_space_lte of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._failure_data_space_lte

    @failure_data_space_lte.setter
    def failure_data_space_lte(self, failure_data_space_lte):
        """Sets the failure_data_space_lte of this ZoneWhereInput.


        :param failure_data_space_lte: The failure_data_space_lte of this ZoneWhereInput.  # noqa: E501
        :type failure_data_space_lte: int
        """

        self._failure_data_space_lte = failure_data_space_lte

    @property
    def failure_data_space_not(self):
        """Gets the failure_data_space_not of this ZoneWhereInput.  # noqa: E501


        :return: The failure_data_space_not of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._failure_data_space_not

    @failure_data_space_not.setter
    def failure_data_space_not(self, failure_data_space_not):
        """Sets the failure_data_space_not of this ZoneWhereInput.


        :param failure_data_space_not: The failure_data_space_not of this ZoneWhereInput.  # noqa: E501
        :type failure_data_space_not: int
        """

        self._failure_data_space_not = failure_data_space_not

    @property
    def failure_data_space_not_in(self):
        """Gets the failure_data_space_not_in of this ZoneWhereInput.  # noqa: E501


        :return: The failure_data_space_not_in of this ZoneWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._failure_data_space_not_in

    @failure_data_space_not_in.setter
    def failure_data_space_not_in(self, failure_data_space_not_in):
        """Sets the failure_data_space_not_in of this ZoneWhereInput.


        :param failure_data_space_not_in: The failure_data_space_not_in of this ZoneWhereInput.  # noqa: E501
        :type failure_data_space_not_in: list[int]
        """

        self._failure_data_space_not_in = failure_data_space_not_in

    @property
    def host_num(self):
        """Gets the host_num of this ZoneWhereInput.  # noqa: E501


        :return: The host_num of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._host_num

    @host_num.setter
    def host_num(self, host_num):
        """Sets the host_num of this ZoneWhereInput.


        :param host_num: The host_num of this ZoneWhereInput.  # noqa: E501
        :type host_num: int
        """

        self._host_num = host_num

    @property
    def host_num_gt(self):
        """Gets the host_num_gt of this ZoneWhereInput.  # noqa: E501


        :return: The host_num_gt of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._host_num_gt

    @host_num_gt.setter
    def host_num_gt(self, host_num_gt):
        """Sets the host_num_gt of this ZoneWhereInput.


        :param host_num_gt: The host_num_gt of this ZoneWhereInput.  # noqa: E501
        :type host_num_gt: int
        """

        self._host_num_gt = host_num_gt

    @property
    def host_num_gte(self):
        """Gets the host_num_gte of this ZoneWhereInput.  # noqa: E501


        :return: The host_num_gte of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._host_num_gte

    @host_num_gte.setter
    def host_num_gte(self, host_num_gte):
        """Sets the host_num_gte of this ZoneWhereInput.


        :param host_num_gte: The host_num_gte of this ZoneWhereInput.  # noqa: E501
        :type host_num_gte: int
        """

        self._host_num_gte = host_num_gte

    @property
    def host_num_in(self):
        """Gets the host_num_in of this ZoneWhereInput.  # noqa: E501


        :return: The host_num_in of this ZoneWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._host_num_in

    @host_num_in.setter
    def host_num_in(self, host_num_in):
        """Sets the host_num_in of this ZoneWhereInput.


        :param host_num_in: The host_num_in of this ZoneWhereInput.  # noqa: E501
        :type host_num_in: list[int]
        """

        self._host_num_in = host_num_in

    @property
    def host_num_lt(self):
        """Gets the host_num_lt of this ZoneWhereInput.  # noqa: E501


        :return: The host_num_lt of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._host_num_lt

    @host_num_lt.setter
    def host_num_lt(self, host_num_lt):
        """Sets the host_num_lt of this ZoneWhereInput.


        :param host_num_lt: The host_num_lt of this ZoneWhereInput.  # noqa: E501
        :type host_num_lt: int
        """

        self._host_num_lt = host_num_lt

    @property
    def host_num_lte(self):
        """Gets the host_num_lte of this ZoneWhereInput.  # noqa: E501


        :return: The host_num_lte of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._host_num_lte

    @host_num_lte.setter
    def host_num_lte(self, host_num_lte):
        """Sets the host_num_lte of this ZoneWhereInput.


        :param host_num_lte: The host_num_lte of this ZoneWhereInput.  # noqa: E501
        :type host_num_lte: int
        """

        self._host_num_lte = host_num_lte

    @property
    def host_num_not(self):
        """Gets the host_num_not of this ZoneWhereInput.  # noqa: E501


        :return: The host_num_not of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._host_num_not

    @host_num_not.setter
    def host_num_not(self, host_num_not):
        """Sets the host_num_not of this ZoneWhereInput.


        :param host_num_not: The host_num_not of this ZoneWhereInput.  # noqa: E501
        :type host_num_not: int
        """

        self._host_num_not = host_num_not

    @property
    def host_num_not_in(self):
        """Gets the host_num_not_in of this ZoneWhereInput.  # noqa: E501


        :return: The host_num_not_in of this ZoneWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._host_num_not_in

    @host_num_not_in.setter
    def host_num_not_in(self, host_num_not_in):
        """Sets the host_num_not_in of this ZoneWhereInput.


        :param host_num_not_in: The host_num_not_in of this ZoneWhereInput.  # noqa: E501
        :type host_num_not_in: list[int]
        """

        self._host_num_not_in = host_num_not_in

    @property
    def hosts_every(self):
        """Gets the hosts_every of this ZoneWhereInput.  # noqa: E501


        :return: The hosts_every of this ZoneWhereInput.  # noqa: E501
        :rtype: HostWhereInput
        """
        return self._hosts_every

    @hosts_every.setter
    def hosts_every(self, hosts_every):
        """Sets the hosts_every of this ZoneWhereInput.


        :param hosts_every: The hosts_every of this ZoneWhereInput.  # noqa: E501
        :type hosts_every: HostWhereInput
        """

        self._hosts_every = hosts_every

    @property
    def hosts_none(self):
        """Gets the hosts_none of this ZoneWhereInput.  # noqa: E501


        :return: The hosts_none of this ZoneWhereInput.  # noqa: E501
        :rtype: HostWhereInput
        """
        return self._hosts_none

    @hosts_none.setter
    def hosts_none(self, hosts_none):
        """Sets the hosts_none of this ZoneWhereInput.


        :param hosts_none: The hosts_none of this ZoneWhereInput.  # noqa: E501
        :type hosts_none: HostWhereInput
        """

        self._hosts_none = hosts_none

    @property
    def hosts_some(self):
        """Gets the hosts_some of this ZoneWhereInput.  # noqa: E501


        :return: The hosts_some of this ZoneWhereInput.  # noqa: E501
        :rtype: HostWhereInput
        """
        return self._hosts_some

    @hosts_some.setter
    def hosts_some(self, hosts_some):
        """Sets the hosts_some of this ZoneWhereInput.


        :param hosts_some: The hosts_some of this ZoneWhereInput.  # noqa: E501
        :type hosts_some: HostWhereInput
        """

        self._hosts_some = hosts_some

    @property
    def id(self):
        """Gets the id of this ZoneWhereInput.  # noqa: E501


        :return: The id of this ZoneWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ZoneWhereInput.


        :param id: The id of this ZoneWhereInput.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def id_contains(self):
        """Gets the id_contains of this ZoneWhereInput.  # noqa: E501


        :return: The id_contains of this ZoneWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_contains

    @id_contains.setter
    def id_contains(self, id_contains):
        """Sets the id_contains of this ZoneWhereInput.


        :param id_contains: The id_contains of this ZoneWhereInput.  # noqa: E501
        :type id_contains: str
        """

        self._id_contains = id_contains

    @property
    def id_ends_with(self):
        """Gets the id_ends_with of this ZoneWhereInput.  # noqa: E501


        :return: The id_ends_with of this ZoneWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_ends_with

    @id_ends_with.setter
    def id_ends_with(self, id_ends_with):
        """Sets the id_ends_with of this ZoneWhereInput.


        :param id_ends_with: The id_ends_with of this ZoneWhereInput.  # noqa: E501
        :type id_ends_with: str
        """

        self._id_ends_with = id_ends_with

    @property
    def id_gt(self):
        """Gets the id_gt of this ZoneWhereInput.  # noqa: E501


        :return: The id_gt of this ZoneWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gt

    @id_gt.setter
    def id_gt(self, id_gt):
        """Sets the id_gt of this ZoneWhereInput.


        :param id_gt: The id_gt of this ZoneWhereInput.  # noqa: E501
        :type id_gt: str
        """

        self._id_gt = id_gt

    @property
    def id_gte(self):
        """Gets the id_gte of this ZoneWhereInput.  # noqa: E501


        :return: The id_gte of this ZoneWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gte

    @id_gte.setter
    def id_gte(self, id_gte):
        """Sets the id_gte of this ZoneWhereInput.


        :param id_gte: The id_gte of this ZoneWhereInput.  # noqa: E501
        :type id_gte: str
        """

        self._id_gte = id_gte

    @property
    def id_in(self):
        """Gets the id_in of this ZoneWhereInput.  # noqa: E501


        :return: The id_in of this ZoneWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_in

    @id_in.setter
    def id_in(self, id_in):
        """Sets the id_in of this ZoneWhereInput.


        :param id_in: The id_in of this ZoneWhereInput.  # noqa: E501
        :type id_in: list[str]
        """

        self._id_in = id_in

    @property
    def id_lt(self):
        """Gets the id_lt of this ZoneWhereInput.  # noqa: E501


        :return: The id_lt of this ZoneWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lt

    @id_lt.setter
    def id_lt(self, id_lt):
        """Sets the id_lt of this ZoneWhereInput.


        :param id_lt: The id_lt of this ZoneWhereInput.  # noqa: E501
        :type id_lt: str
        """

        self._id_lt = id_lt

    @property
    def id_lte(self):
        """Gets the id_lte of this ZoneWhereInput.  # noqa: E501


        :return: The id_lte of this ZoneWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lte

    @id_lte.setter
    def id_lte(self, id_lte):
        """Sets the id_lte of this ZoneWhereInput.


        :param id_lte: The id_lte of this ZoneWhereInput.  # noqa: E501
        :type id_lte: str
        """

        self._id_lte = id_lte

    @property
    def id_not(self):
        """Gets the id_not of this ZoneWhereInput.  # noqa: E501


        :return: The id_not of this ZoneWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not

    @id_not.setter
    def id_not(self, id_not):
        """Sets the id_not of this ZoneWhereInput.


        :param id_not: The id_not of this ZoneWhereInput.  # noqa: E501
        :type id_not: str
        """

        self._id_not = id_not

    @property
    def id_not_contains(self):
        """Gets the id_not_contains of this ZoneWhereInput.  # noqa: E501


        :return: The id_not_contains of this ZoneWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_contains

    @id_not_contains.setter
    def id_not_contains(self, id_not_contains):
        """Sets the id_not_contains of this ZoneWhereInput.


        :param id_not_contains: The id_not_contains of this ZoneWhereInput.  # noqa: E501
        :type id_not_contains: str
        """

        self._id_not_contains = id_not_contains

    @property
    def id_not_ends_with(self):
        """Gets the id_not_ends_with of this ZoneWhereInput.  # noqa: E501


        :return: The id_not_ends_with of this ZoneWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_ends_with

    @id_not_ends_with.setter
    def id_not_ends_with(self, id_not_ends_with):
        """Sets the id_not_ends_with of this ZoneWhereInput.


        :param id_not_ends_with: The id_not_ends_with of this ZoneWhereInput.  # noqa: E501
        :type id_not_ends_with: str
        """

        self._id_not_ends_with = id_not_ends_with

    @property
    def id_not_in(self):
        """Gets the id_not_in of this ZoneWhereInput.  # noqa: E501


        :return: The id_not_in of this ZoneWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_not_in

    @id_not_in.setter
    def id_not_in(self, id_not_in):
        """Sets the id_not_in of this ZoneWhereInput.


        :param id_not_in: The id_not_in of this ZoneWhereInput.  # noqa: E501
        :type id_not_in: list[str]
        """

        self._id_not_in = id_not_in

    @property
    def id_not_starts_with(self):
        """Gets the id_not_starts_with of this ZoneWhereInput.  # noqa: E501


        :return: The id_not_starts_with of this ZoneWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_starts_with

    @id_not_starts_with.setter
    def id_not_starts_with(self, id_not_starts_with):
        """Sets the id_not_starts_with of this ZoneWhereInput.


        :param id_not_starts_with: The id_not_starts_with of this ZoneWhereInput.  # noqa: E501
        :type id_not_starts_with: str
        """

        self._id_not_starts_with = id_not_starts_with

    @property
    def id_starts_with(self):
        """Gets the id_starts_with of this ZoneWhereInput.  # noqa: E501


        :return: The id_starts_with of this ZoneWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_starts_with

    @id_starts_with.setter
    def id_starts_with(self, id_starts_with):
        """Sets the id_starts_with of this ZoneWhereInput.


        :param id_starts_with: The id_starts_with of this ZoneWhereInput.  # noqa: E501
        :type id_starts_with: str
        """

        self._id_starts_with = id_starts_with

    @property
    def is_preferred(self):
        """Gets the is_preferred of this ZoneWhereInput.  # noqa: E501


        :return: The is_preferred of this ZoneWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._is_preferred

    @is_preferred.setter
    def is_preferred(self, is_preferred):
        """Sets the is_preferred of this ZoneWhereInput.


        :param is_preferred: The is_preferred of this ZoneWhereInput.  # noqa: E501
        :type is_preferred: bool
        """

        self._is_preferred = is_preferred

    @property
    def is_preferred_not(self):
        """Gets the is_preferred_not of this ZoneWhereInput.  # noqa: E501


        :return: The is_preferred_not of this ZoneWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._is_preferred_not

    @is_preferred_not.setter
    def is_preferred_not(self, is_preferred_not):
        """Sets the is_preferred_not of this ZoneWhereInput.


        :param is_preferred_not: The is_preferred_not of this ZoneWhereInput.  # noqa: E501
        :type is_preferred_not: bool
        """

        self._is_preferred_not = is_preferred_not

    @property
    def local_id(self):
        """Gets the local_id of this ZoneWhereInput.  # noqa: E501


        :return: The local_id of this ZoneWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id):
        """Sets the local_id of this ZoneWhereInput.


        :param local_id: The local_id of this ZoneWhereInput.  # noqa: E501
        :type local_id: str
        """

        self._local_id = local_id

    @property
    def local_id_contains(self):
        """Gets the local_id_contains of this ZoneWhereInput.  # noqa: E501


        :return: The local_id_contains of this ZoneWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_contains

    @local_id_contains.setter
    def local_id_contains(self, local_id_contains):
        """Sets the local_id_contains of this ZoneWhereInput.


        :param local_id_contains: The local_id_contains of this ZoneWhereInput.  # noqa: E501
        :type local_id_contains: str
        """

        self._local_id_contains = local_id_contains

    @property
    def local_id_ends_with(self):
        """Gets the local_id_ends_with of this ZoneWhereInput.  # noqa: E501


        :return: The local_id_ends_with of this ZoneWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_ends_with

    @local_id_ends_with.setter
    def local_id_ends_with(self, local_id_ends_with):
        """Sets the local_id_ends_with of this ZoneWhereInput.


        :param local_id_ends_with: The local_id_ends_with of this ZoneWhereInput.  # noqa: E501
        :type local_id_ends_with: str
        """

        self._local_id_ends_with = local_id_ends_with

    @property
    def local_id_gt(self):
        """Gets the local_id_gt of this ZoneWhereInput.  # noqa: E501


        :return: The local_id_gt of this ZoneWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_gt

    @local_id_gt.setter
    def local_id_gt(self, local_id_gt):
        """Sets the local_id_gt of this ZoneWhereInput.


        :param local_id_gt: The local_id_gt of this ZoneWhereInput.  # noqa: E501
        :type local_id_gt: str
        """

        self._local_id_gt = local_id_gt

    @property
    def local_id_gte(self):
        """Gets the local_id_gte of this ZoneWhereInput.  # noqa: E501


        :return: The local_id_gte of this ZoneWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_gte

    @local_id_gte.setter
    def local_id_gte(self, local_id_gte):
        """Sets the local_id_gte of this ZoneWhereInput.


        :param local_id_gte: The local_id_gte of this ZoneWhereInput.  # noqa: E501
        :type local_id_gte: str
        """

        self._local_id_gte = local_id_gte

    @property
    def local_id_in(self):
        """Gets the local_id_in of this ZoneWhereInput.  # noqa: E501


        :return: The local_id_in of this ZoneWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_id_in

    @local_id_in.setter
    def local_id_in(self, local_id_in):
        """Sets the local_id_in of this ZoneWhereInput.


        :param local_id_in: The local_id_in of this ZoneWhereInput.  # noqa: E501
        :type local_id_in: list[str]
        """

        self._local_id_in = local_id_in

    @property
    def local_id_lt(self):
        """Gets the local_id_lt of this ZoneWhereInput.  # noqa: E501


        :return: The local_id_lt of this ZoneWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_lt

    @local_id_lt.setter
    def local_id_lt(self, local_id_lt):
        """Sets the local_id_lt of this ZoneWhereInput.


        :param local_id_lt: The local_id_lt of this ZoneWhereInput.  # noqa: E501
        :type local_id_lt: str
        """

        self._local_id_lt = local_id_lt

    @property
    def local_id_lte(self):
        """Gets the local_id_lte of this ZoneWhereInput.  # noqa: E501


        :return: The local_id_lte of this ZoneWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_lte

    @local_id_lte.setter
    def local_id_lte(self, local_id_lte):
        """Sets the local_id_lte of this ZoneWhereInput.


        :param local_id_lte: The local_id_lte of this ZoneWhereInput.  # noqa: E501
        :type local_id_lte: str
        """

        self._local_id_lte = local_id_lte

    @property
    def local_id_not(self):
        """Gets the local_id_not of this ZoneWhereInput.  # noqa: E501


        :return: The local_id_not of this ZoneWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not

    @local_id_not.setter
    def local_id_not(self, local_id_not):
        """Sets the local_id_not of this ZoneWhereInput.


        :param local_id_not: The local_id_not of this ZoneWhereInput.  # noqa: E501
        :type local_id_not: str
        """

        self._local_id_not = local_id_not

    @property
    def local_id_not_contains(self):
        """Gets the local_id_not_contains of this ZoneWhereInput.  # noqa: E501


        :return: The local_id_not_contains of this ZoneWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_contains

    @local_id_not_contains.setter
    def local_id_not_contains(self, local_id_not_contains):
        """Sets the local_id_not_contains of this ZoneWhereInput.


        :param local_id_not_contains: The local_id_not_contains of this ZoneWhereInput.  # noqa: E501
        :type local_id_not_contains: str
        """

        self._local_id_not_contains = local_id_not_contains

    @property
    def local_id_not_ends_with(self):
        """Gets the local_id_not_ends_with of this ZoneWhereInput.  # noqa: E501


        :return: The local_id_not_ends_with of this ZoneWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_ends_with

    @local_id_not_ends_with.setter
    def local_id_not_ends_with(self, local_id_not_ends_with):
        """Sets the local_id_not_ends_with of this ZoneWhereInput.


        :param local_id_not_ends_with: The local_id_not_ends_with of this ZoneWhereInput.  # noqa: E501
        :type local_id_not_ends_with: str
        """

        self._local_id_not_ends_with = local_id_not_ends_with

    @property
    def local_id_not_in(self):
        """Gets the local_id_not_in of this ZoneWhereInput.  # noqa: E501


        :return: The local_id_not_in of this ZoneWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_id_not_in

    @local_id_not_in.setter
    def local_id_not_in(self, local_id_not_in):
        """Sets the local_id_not_in of this ZoneWhereInput.


        :param local_id_not_in: The local_id_not_in of this ZoneWhereInput.  # noqa: E501
        :type local_id_not_in: list[str]
        """

        self._local_id_not_in = local_id_not_in

    @property
    def local_id_not_starts_with(self):
        """Gets the local_id_not_starts_with of this ZoneWhereInput.  # noqa: E501


        :return: The local_id_not_starts_with of this ZoneWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_starts_with

    @local_id_not_starts_with.setter
    def local_id_not_starts_with(self, local_id_not_starts_with):
        """Sets the local_id_not_starts_with of this ZoneWhereInput.


        :param local_id_not_starts_with: The local_id_not_starts_with of this ZoneWhereInput.  # noqa: E501
        :type local_id_not_starts_with: str
        """

        self._local_id_not_starts_with = local_id_not_starts_with

    @property
    def local_id_starts_with(self):
        """Gets the local_id_starts_with of this ZoneWhereInput.  # noqa: E501


        :return: The local_id_starts_with of this ZoneWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_starts_with

    @local_id_starts_with.setter
    def local_id_starts_with(self, local_id_starts_with):
        """Sets the local_id_starts_with of this ZoneWhereInput.


        :param local_id_starts_with: The local_id_starts_with of this ZoneWhereInput.  # noqa: E501
        :type local_id_starts_with: str
        """

        self._local_id_starts_with = local_id_starts_with

    @property
    def provisioned_cpu_cores(self):
        """Gets the provisioned_cpu_cores of this ZoneWhereInput.  # noqa: E501


        :return: The provisioned_cpu_cores of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._provisioned_cpu_cores

    @provisioned_cpu_cores.setter
    def provisioned_cpu_cores(self, provisioned_cpu_cores):
        """Sets the provisioned_cpu_cores of this ZoneWhereInput.


        :param provisioned_cpu_cores: The provisioned_cpu_cores of this ZoneWhereInput.  # noqa: E501
        :type provisioned_cpu_cores: int
        """

        self._provisioned_cpu_cores = provisioned_cpu_cores

    @property
    def provisioned_cpu_cores_for_active_vm(self):
        """Gets the provisioned_cpu_cores_for_active_vm of this ZoneWhereInput.  # noqa: E501


        :return: The provisioned_cpu_cores_for_active_vm of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._provisioned_cpu_cores_for_active_vm

    @provisioned_cpu_cores_for_active_vm.setter
    def provisioned_cpu_cores_for_active_vm(self, provisioned_cpu_cores_for_active_vm):
        """Sets the provisioned_cpu_cores_for_active_vm of this ZoneWhereInput.


        :param provisioned_cpu_cores_for_active_vm: The provisioned_cpu_cores_for_active_vm of this ZoneWhereInput.  # noqa: E501
        :type provisioned_cpu_cores_for_active_vm: int
        """

        self._provisioned_cpu_cores_for_active_vm = provisioned_cpu_cores_for_active_vm

    @property
    def provisioned_cpu_cores_for_active_vm_gt(self):
        """Gets the provisioned_cpu_cores_for_active_vm_gt of this ZoneWhereInput.  # noqa: E501


        :return: The provisioned_cpu_cores_for_active_vm_gt of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._provisioned_cpu_cores_for_active_vm_gt

    @provisioned_cpu_cores_for_active_vm_gt.setter
    def provisioned_cpu_cores_for_active_vm_gt(self, provisioned_cpu_cores_for_active_vm_gt):
        """Sets the provisioned_cpu_cores_for_active_vm_gt of this ZoneWhereInput.


        :param provisioned_cpu_cores_for_active_vm_gt: The provisioned_cpu_cores_for_active_vm_gt of this ZoneWhereInput.  # noqa: E501
        :type provisioned_cpu_cores_for_active_vm_gt: int
        """

        self._provisioned_cpu_cores_for_active_vm_gt = provisioned_cpu_cores_for_active_vm_gt

    @property
    def provisioned_cpu_cores_for_active_vm_gte(self):
        """Gets the provisioned_cpu_cores_for_active_vm_gte of this ZoneWhereInput.  # noqa: E501


        :return: The provisioned_cpu_cores_for_active_vm_gte of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._provisioned_cpu_cores_for_active_vm_gte

    @provisioned_cpu_cores_for_active_vm_gte.setter
    def provisioned_cpu_cores_for_active_vm_gte(self, provisioned_cpu_cores_for_active_vm_gte):
        """Sets the provisioned_cpu_cores_for_active_vm_gte of this ZoneWhereInput.


        :param provisioned_cpu_cores_for_active_vm_gte: The provisioned_cpu_cores_for_active_vm_gte of this ZoneWhereInput.  # noqa: E501
        :type provisioned_cpu_cores_for_active_vm_gte: int
        """

        self._provisioned_cpu_cores_for_active_vm_gte = provisioned_cpu_cores_for_active_vm_gte

    @property
    def provisioned_cpu_cores_for_active_vm_in(self):
        """Gets the provisioned_cpu_cores_for_active_vm_in of this ZoneWhereInput.  # noqa: E501


        :return: The provisioned_cpu_cores_for_active_vm_in of this ZoneWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._provisioned_cpu_cores_for_active_vm_in

    @provisioned_cpu_cores_for_active_vm_in.setter
    def provisioned_cpu_cores_for_active_vm_in(self, provisioned_cpu_cores_for_active_vm_in):
        """Sets the provisioned_cpu_cores_for_active_vm_in of this ZoneWhereInput.


        :param provisioned_cpu_cores_for_active_vm_in: The provisioned_cpu_cores_for_active_vm_in of this ZoneWhereInput.  # noqa: E501
        :type provisioned_cpu_cores_for_active_vm_in: list[int]
        """

        self._provisioned_cpu_cores_for_active_vm_in = provisioned_cpu_cores_for_active_vm_in

    @property
    def provisioned_cpu_cores_for_active_vm_lt(self):
        """Gets the provisioned_cpu_cores_for_active_vm_lt of this ZoneWhereInput.  # noqa: E501


        :return: The provisioned_cpu_cores_for_active_vm_lt of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._provisioned_cpu_cores_for_active_vm_lt

    @provisioned_cpu_cores_for_active_vm_lt.setter
    def provisioned_cpu_cores_for_active_vm_lt(self, provisioned_cpu_cores_for_active_vm_lt):
        """Sets the provisioned_cpu_cores_for_active_vm_lt of this ZoneWhereInput.


        :param provisioned_cpu_cores_for_active_vm_lt: The provisioned_cpu_cores_for_active_vm_lt of this ZoneWhereInput.  # noqa: E501
        :type provisioned_cpu_cores_for_active_vm_lt: int
        """

        self._provisioned_cpu_cores_for_active_vm_lt = provisioned_cpu_cores_for_active_vm_lt

    @property
    def provisioned_cpu_cores_for_active_vm_lte(self):
        """Gets the provisioned_cpu_cores_for_active_vm_lte of this ZoneWhereInput.  # noqa: E501


        :return: The provisioned_cpu_cores_for_active_vm_lte of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._provisioned_cpu_cores_for_active_vm_lte

    @provisioned_cpu_cores_for_active_vm_lte.setter
    def provisioned_cpu_cores_for_active_vm_lte(self, provisioned_cpu_cores_for_active_vm_lte):
        """Sets the provisioned_cpu_cores_for_active_vm_lte of this ZoneWhereInput.


        :param provisioned_cpu_cores_for_active_vm_lte: The provisioned_cpu_cores_for_active_vm_lte of this ZoneWhereInput.  # noqa: E501
        :type provisioned_cpu_cores_for_active_vm_lte: int
        """

        self._provisioned_cpu_cores_for_active_vm_lte = provisioned_cpu_cores_for_active_vm_lte

    @property
    def provisioned_cpu_cores_for_active_vm_not(self):
        """Gets the provisioned_cpu_cores_for_active_vm_not of this ZoneWhereInput.  # noqa: E501


        :return: The provisioned_cpu_cores_for_active_vm_not of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._provisioned_cpu_cores_for_active_vm_not

    @provisioned_cpu_cores_for_active_vm_not.setter
    def provisioned_cpu_cores_for_active_vm_not(self, provisioned_cpu_cores_for_active_vm_not):
        """Sets the provisioned_cpu_cores_for_active_vm_not of this ZoneWhereInput.


        :param provisioned_cpu_cores_for_active_vm_not: The provisioned_cpu_cores_for_active_vm_not of this ZoneWhereInput.  # noqa: E501
        :type provisioned_cpu_cores_for_active_vm_not: int
        """

        self._provisioned_cpu_cores_for_active_vm_not = provisioned_cpu_cores_for_active_vm_not

    @property
    def provisioned_cpu_cores_for_active_vm_not_in(self):
        """Gets the provisioned_cpu_cores_for_active_vm_not_in of this ZoneWhereInput.  # noqa: E501


        :return: The provisioned_cpu_cores_for_active_vm_not_in of this ZoneWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._provisioned_cpu_cores_for_active_vm_not_in

    @provisioned_cpu_cores_for_active_vm_not_in.setter
    def provisioned_cpu_cores_for_active_vm_not_in(self, provisioned_cpu_cores_for_active_vm_not_in):
        """Sets the provisioned_cpu_cores_for_active_vm_not_in of this ZoneWhereInput.


        :param provisioned_cpu_cores_for_active_vm_not_in: The provisioned_cpu_cores_for_active_vm_not_in of this ZoneWhereInput.  # noqa: E501
        :type provisioned_cpu_cores_for_active_vm_not_in: list[int]
        """

        self._provisioned_cpu_cores_for_active_vm_not_in = provisioned_cpu_cores_for_active_vm_not_in

    @property
    def provisioned_cpu_cores_gt(self):
        """Gets the provisioned_cpu_cores_gt of this ZoneWhereInput.  # noqa: E501


        :return: The provisioned_cpu_cores_gt of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._provisioned_cpu_cores_gt

    @provisioned_cpu_cores_gt.setter
    def provisioned_cpu_cores_gt(self, provisioned_cpu_cores_gt):
        """Sets the provisioned_cpu_cores_gt of this ZoneWhereInput.


        :param provisioned_cpu_cores_gt: The provisioned_cpu_cores_gt of this ZoneWhereInput.  # noqa: E501
        :type provisioned_cpu_cores_gt: int
        """

        self._provisioned_cpu_cores_gt = provisioned_cpu_cores_gt

    @property
    def provisioned_cpu_cores_gte(self):
        """Gets the provisioned_cpu_cores_gte of this ZoneWhereInput.  # noqa: E501


        :return: The provisioned_cpu_cores_gte of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._provisioned_cpu_cores_gte

    @provisioned_cpu_cores_gte.setter
    def provisioned_cpu_cores_gte(self, provisioned_cpu_cores_gte):
        """Sets the provisioned_cpu_cores_gte of this ZoneWhereInput.


        :param provisioned_cpu_cores_gte: The provisioned_cpu_cores_gte of this ZoneWhereInput.  # noqa: E501
        :type provisioned_cpu_cores_gte: int
        """

        self._provisioned_cpu_cores_gte = provisioned_cpu_cores_gte

    @property
    def provisioned_cpu_cores_in(self):
        """Gets the provisioned_cpu_cores_in of this ZoneWhereInput.  # noqa: E501


        :return: The provisioned_cpu_cores_in of this ZoneWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._provisioned_cpu_cores_in

    @provisioned_cpu_cores_in.setter
    def provisioned_cpu_cores_in(self, provisioned_cpu_cores_in):
        """Sets the provisioned_cpu_cores_in of this ZoneWhereInput.


        :param provisioned_cpu_cores_in: The provisioned_cpu_cores_in of this ZoneWhereInput.  # noqa: E501
        :type provisioned_cpu_cores_in: list[int]
        """

        self._provisioned_cpu_cores_in = provisioned_cpu_cores_in

    @property
    def provisioned_cpu_cores_lt(self):
        """Gets the provisioned_cpu_cores_lt of this ZoneWhereInput.  # noqa: E501


        :return: The provisioned_cpu_cores_lt of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._provisioned_cpu_cores_lt

    @provisioned_cpu_cores_lt.setter
    def provisioned_cpu_cores_lt(self, provisioned_cpu_cores_lt):
        """Sets the provisioned_cpu_cores_lt of this ZoneWhereInput.


        :param provisioned_cpu_cores_lt: The provisioned_cpu_cores_lt of this ZoneWhereInput.  # noqa: E501
        :type provisioned_cpu_cores_lt: int
        """

        self._provisioned_cpu_cores_lt = provisioned_cpu_cores_lt

    @property
    def provisioned_cpu_cores_lte(self):
        """Gets the provisioned_cpu_cores_lte of this ZoneWhereInput.  # noqa: E501


        :return: The provisioned_cpu_cores_lte of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._provisioned_cpu_cores_lte

    @provisioned_cpu_cores_lte.setter
    def provisioned_cpu_cores_lte(self, provisioned_cpu_cores_lte):
        """Sets the provisioned_cpu_cores_lte of this ZoneWhereInput.


        :param provisioned_cpu_cores_lte: The provisioned_cpu_cores_lte of this ZoneWhereInput.  # noqa: E501
        :type provisioned_cpu_cores_lte: int
        """

        self._provisioned_cpu_cores_lte = provisioned_cpu_cores_lte

    @property
    def provisioned_cpu_cores_not(self):
        """Gets the provisioned_cpu_cores_not of this ZoneWhereInput.  # noqa: E501


        :return: The provisioned_cpu_cores_not of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._provisioned_cpu_cores_not

    @provisioned_cpu_cores_not.setter
    def provisioned_cpu_cores_not(self, provisioned_cpu_cores_not):
        """Sets the provisioned_cpu_cores_not of this ZoneWhereInput.


        :param provisioned_cpu_cores_not: The provisioned_cpu_cores_not of this ZoneWhereInput.  # noqa: E501
        :type provisioned_cpu_cores_not: int
        """

        self._provisioned_cpu_cores_not = provisioned_cpu_cores_not

    @property
    def provisioned_cpu_cores_not_in(self):
        """Gets the provisioned_cpu_cores_not_in of this ZoneWhereInput.  # noqa: E501


        :return: The provisioned_cpu_cores_not_in of this ZoneWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._provisioned_cpu_cores_not_in

    @provisioned_cpu_cores_not_in.setter
    def provisioned_cpu_cores_not_in(self, provisioned_cpu_cores_not_in):
        """Sets the provisioned_cpu_cores_not_in of this ZoneWhereInput.


        :param provisioned_cpu_cores_not_in: The provisioned_cpu_cores_not_in of this ZoneWhereInput.  # noqa: E501
        :type provisioned_cpu_cores_not_in: list[int]
        """

        self._provisioned_cpu_cores_not_in = provisioned_cpu_cores_not_in

    @property
    def provisioned_data_space(self):
        """Gets the provisioned_data_space of this ZoneWhereInput.  # noqa: E501


        :return: The provisioned_data_space of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._provisioned_data_space

    @provisioned_data_space.setter
    def provisioned_data_space(self, provisioned_data_space):
        """Sets the provisioned_data_space of this ZoneWhereInput.


        :param provisioned_data_space: The provisioned_data_space of this ZoneWhereInput.  # noqa: E501
        :type provisioned_data_space: int
        """

        self._provisioned_data_space = provisioned_data_space

    @property
    def provisioned_data_space_gt(self):
        """Gets the provisioned_data_space_gt of this ZoneWhereInput.  # noqa: E501


        :return: The provisioned_data_space_gt of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._provisioned_data_space_gt

    @provisioned_data_space_gt.setter
    def provisioned_data_space_gt(self, provisioned_data_space_gt):
        """Sets the provisioned_data_space_gt of this ZoneWhereInput.


        :param provisioned_data_space_gt: The provisioned_data_space_gt of this ZoneWhereInput.  # noqa: E501
        :type provisioned_data_space_gt: int
        """

        self._provisioned_data_space_gt = provisioned_data_space_gt

    @property
    def provisioned_data_space_gte(self):
        """Gets the provisioned_data_space_gte of this ZoneWhereInput.  # noqa: E501


        :return: The provisioned_data_space_gte of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._provisioned_data_space_gte

    @provisioned_data_space_gte.setter
    def provisioned_data_space_gte(self, provisioned_data_space_gte):
        """Sets the provisioned_data_space_gte of this ZoneWhereInput.


        :param provisioned_data_space_gte: The provisioned_data_space_gte of this ZoneWhereInput.  # noqa: E501
        :type provisioned_data_space_gte: int
        """

        self._provisioned_data_space_gte = provisioned_data_space_gte

    @property
    def provisioned_data_space_in(self):
        """Gets the provisioned_data_space_in of this ZoneWhereInput.  # noqa: E501


        :return: The provisioned_data_space_in of this ZoneWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._provisioned_data_space_in

    @provisioned_data_space_in.setter
    def provisioned_data_space_in(self, provisioned_data_space_in):
        """Sets the provisioned_data_space_in of this ZoneWhereInput.


        :param provisioned_data_space_in: The provisioned_data_space_in of this ZoneWhereInput.  # noqa: E501
        :type provisioned_data_space_in: list[int]
        """

        self._provisioned_data_space_in = provisioned_data_space_in

    @property
    def provisioned_data_space_lt(self):
        """Gets the provisioned_data_space_lt of this ZoneWhereInput.  # noqa: E501


        :return: The provisioned_data_space_lt of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._provisioned_data_space_lt

    @provisioned_data_space_lt.setter
    def provisioned_data_space_lt(self, provisioned_data_space_lt):
        """Sets the provisioned_data_space_lt of this ZoneWhereInput.


        :param provisioned_data_space_lt: The provisioned_data_space_lt of this ZoneWhereInput.  # noqa: E501
        :type provisioned_data_space_lt: int
        """

        self._provisioned_data_space_lt = provisioned_data_space_lt

    @property
    def provisioned_data_space_lte(self):
        """Gets the provisioned_data_space_lte of this ZoneWhereInput.  # noqa: E501


        :return: The provisioned_data_space_lte of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._provisioned_data_space_lte

    @provisioned_data_space_lte.setter
    def provisioned_data_space_lte(self, provisioned_data_space_lte):
        """Sets the provisioned_data_space_lte of this ZoneWhereInput.


        :param provisioned_data_space_lte: The provisioned_data_space_lte of this ZoneWhereInput.  # noqa: E501
        :type provisioned_data_space_lte: int
        """

        self._provisioned_data_space_lte = provisioned_data_space_lte

    @property
    def provisioned_data_space_not(self):
        """Gets the provisioned_data_space_not of this ZoneWhereInput.  # noqa: E501


        :return: The provisioned_data_space_not of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._provisioned_data_space_not

    @provisioned_data_space_not.setter
    def provisioned_data_space_not(self, provisioned_data_space_not):
        """Sets the provisioned_data_space_not of this ZoneWhereInput.


        :param provisioned_data_space_not: The provisioned_data_space_not of this ZoneWhereInput.  # noqa: E501
        :type provisioned_data_space_not: int
        """

        self._provisioned_data_space_not = provisioned_data_space_not

    @property
    def provisioned_data_space_not_in(self):
        """Gets the provisioned_data_space_not_in of this ZoneWhereInput.  # noqa: E501


        :return: The provisioned_data_space_not_in of this ZoneWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._provisioned_data_space_not_in

    @provisioned_data_space_not_in.setter
    def provisioned_data_space_not_in(self, provisioned_data_space_not_in):
        """Sets the provisioned_data_space_not_in of this ZoneWhereInput.


        :param provisioned_data_space_not_in: The provisioned_data_space_not_in of this ZoneWhereInput.  # noqa: E501
        :type provisioned_data_space_not_in: list[int]
        """

        self._provisioned_data_space_not_in = provisioned_data_space_not_in

    @property
    def provisioned_memory_bytes(self):
        """Gets the provisioned_memory_bytes of this ZoneWhereInput.  # noqa: E501


        :return: The provisioned_memory_bytes of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._provisioned_memory_bytes

    @provisioned_memory_bytes.setter
    def provisioned_memory_bytes(self, provisioned_memory_bytes):
        """Sets the provisioned_memory_bytes of this ZoneWhereInput.


        :param provisioned_memory_bytes: The provisioned_memory_bytes of this ZoneWhereInput.  # noqa: E501
        :type provisioned_memory_bytes: int
        """

        self._provisioned_memory_bytes = provisioned_memory_bytes

    @property
    def provisioned_memory_bytes_gt(self):
        """Gets the provisioned_memory_bytes_gt of this ZoneWhereInput.  # noqa: E501


        :return: The provisioned_memory_bytes_gt of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._provisioned_memory_bytes_gt

    @provisioned_memory_bytes_gt.setter
    def provisioned_memory_bytes_gt(self, provisioned_memory_bytes_gt):
        """Sets the provisioned_memory_bytes_gt of this ZoneWhereInput.


        :param provisioned_memory_bytes_gt: The provisioned_memory_bytes_gt of this ZoneWhereInput.  # noqa: E501
        :type provisioned_memory_bytes_gt: int
        """

        self._provisioned_memory_bytes_gt = provisioned_memory_bytes_gt

    @property
    def provisioned_memory_bytes_gte(self):
        """Gets the provisioned_memory_bytes_gte of this ZoneWhereInput.  # noqa: E501


        :return: The provisioned_memory_bytes_gte of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._provisioned_memory_bytes_gte

    @provisioned_memory_bytes_gte.setter
    def provisioned_memory_bytes_gte(self, provisioned_memory_bytes_gte):
        """Sets the provisioned_memory_bytes_gte of this ZoneWhereInput.


        :param provisioned_memory_bytes_gte: The provisioned_memory_bytes_gte of this ZoneWhereInput.  # noqa: E501
        :type provisioned_memory_bytes_gte: int
        """

        self._provisioned_memory_bytes_gte = provisioned_memory_bytes_gte

    @property
    def provisioned_memory_bytes_in(self):
        """Gets the provisioned_memory_bytes_in of this ZoneWhereInput.  # noqa: E501


        :return: The provisioned_memory_bytes_in of this ZoneWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._provisioned_memory_bytes_in

    @provisioned_memory_bytes_in.setter
    def provisioned_memory_bytes_in(self, provisioned_memory_bytes_in):
        """Sets the provisioned_memory_bytes_in of this ZoneWhereInput.


        :param provisioned_memory_bytes_in: The provisioned_memory_bytes_in of this ZoneWhereInput.  # noqa: E501
        :type provisioned_memory_bytes_in: list[int]
        """

        self._provisioned_memory_bytes_in = provisioned_memory_bytes_in

    @property
    def provisioned_memory_bytes_lt(self):
        """Gets the provisioned_memory_bytes_lt of this ZoneWhereInput.  # noqa: E501


        :return: The provisioned_memory_bytes_lt of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._provisioned_memory_bytes_lt

    @provisioned_memory_bytes_lt.setter
    def provisioned_memory_bytes_lt(self, provisioned_memory_bytes_lt):
        """Sets the provisioned_memory_bytes_lt of this ZoneWhereInput.


        :param provisioned_memory_bytes_lt: The provisioned_memory_bytes_lt of this ZoneWhereInput.  # noqa: E501
        :type provisioned_memory_bytes_lt: int
        """

        self._provisioned_memory_bytes_lt = provisioned_memory_bytes_lt

    @property
    def provisioned_memory_bytes_lte(self):
        """Gets the provisioned_memory_bytes_lte of this ZoneWhereInput.  # noqa: E501


        :return: The provisioned_memory_bytes_lte of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._provisioned_memory_bytes_lte

    @provisioned_memory_bytes_lte.setter
    def provisioned_memory_bytes_lte(self, provisioned_memory_bytes_lte):
        """Sets the provisioned_memory_bytes_lte of this ZoneWhereInput.


        :param provisioned_memory_bytes_lte: The provisioned_memory_bytes_lte of this ZoneWhereInput.  # noqa: E501
        :type provisioned_memory_bytes_lte: int
        """

        self._provisioned_memory_bytes_lte = provisioned_memory_bytes_lte

    @property
    def provisioned_memory_bytes_not(self):
        """Gets the provisioned_memory_bytes_not of this ZoneWhereInput.  # noqa: E501


        :return: The provisioned_memory_bytes_not of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._provisioned_memory_bytes_not

    @provisioned_memory_bytes_not.setter
    def provisioned_memory_bytes_not(self, provisioned_memory_bytes_not):
        """Sets the provisioned_memory_bytes_not of this ZoneWhereInput.


        :param provisioned_memory_bytes_not: The provisioned_memory_bytes_not of this ZoneWhereInput.  # noqa: E501
        :type provisioned_memory_bytes_not: int
        """

        self._provisioned_memory_bytes_not = provisioned_memory_bytes_not

    @property
    def provisioned_memory_bytes_not_in(self):
        """Gets the provisioned_memory_bytes_not_in of this ZoneWhereInput.  # noqa: E501


        :return: The provisioned_memory_bytes_not_in of this ZoneWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._provisioned_memory_bytes_not_in

    @provisioned_memory_bytes_not_in.setter
    def provisioned_memory_bytes_not_in(self, provisioned_memory_bytes_not_in):
        """Sets the provisioned_memory_bytes_not_in of this ZoneWhereInput.


        :param provisioned_memory_bytes_not_in: The provisioned_memory_bytes_not_in of this ZoneWhereInput.  # noqa: E501
        :type provisioned_memory_bytes_not_in: list[int]
        """

        self._provisioned_memory_bytes_not_in = provisioned_memory_bytes_not_in

    @property
    def running_vm_num(self):
        """Gets the running_vm_num of this ZoneWhereInput.  # noqa: E501


        :return: The running_vm_num of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._running_vm_num

    @running_vm_num.setter
    def running_vm_num(self, running_vm_num):
        """Sets the running_vm_num of this ZoneWhereInput.


        :param running_vm_num: The running_vm_num of this ZoneWhereInput.  # noqa: E501
        :type running_vm_num: int
        """

        self._running_vm_num = running_vm_num

    @property
    def running_vm_num_gt(self):
        """Gets the running_vm_num_gt of this ZoneWhereInput.  # noqa: E501


        :return: The running_vm_num_gt of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._running_vm_num_gt

    @running_vm_num_gt.setter
    def running_vm_num_gt(self, running_vm_num_gt):
        """Sets the running_vm_num_gt of this ZoneWhereInput.


        :param running_vm_num_gt: The running_vm_num_gt of this ZoneWhereInput.  # noqa: E501
        :type running_vm_num_gt: int
        """

        self._running_vm_num_gt = running_vm_num_gt

    @property
    def running_vm_num_gte(self):
        """Gets the running_vm_num_gte of this ZoneWhereInput.  # noqa: E501


        :return: The running_vm_num_gte of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._running_vm_num_gte

    @running_vm_num_gte.setter
    def running_vm_num_gte(self, running_vm_num_gte):
        """Sets the running_vm_num_gte of this ZoneWhereInput.


        :param running_vm_num_gte: The running_vm_num_gte of this ZoneWhereInput.  # noqa: E501
        :type running_vm_num_gte: int
        """

        self._running_vm_num_gte = running_vm_num_gte

    @property
    def running_vm_num_in(self):
        """Gets the running_vm_num_in of this ZoneWhereInput.  # noqa: E501


        :return: The running_vm_num_in of this ZoneWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._running_vm_num_in

    @running_vm_num_in.setter
    def running_vm_num_in(self, running_vm_num_in):
        """Sets the running_vm_num_in of this ZoneWhereInput.


        :param running_vm_num_in: The running_vm_num_in of this ZoneWhereInput.  # noqa: E501
        :type running_vm_num_in: list[int]
        """

        self._running_vm_num_in = running_vm_num_in

    @property
    def running_vm_num_lt(self):
        """Gets the running_vm_num_lt of this ZoneWhereInput.  # noqa: E501


        :return: The running_vm_num_lt of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._running_vm_num_lt

    @running_vm_num_lt.setter
    def running_vm_num_lt(self, running_vm_num_lt):
        """Sets the running_vm_num_lt of this ZoneWhereInput.


        :param running_vm_num_lt: The running_vm_num_lt of this ZoneWhereInput.  # noqa: E501
        :type running_vm_num_lt: int
        """

        self._running_vm_num_lt = running_vm_num_lt

    @property
    def running_vm_num_lte(self):
        """Gets the running_vm_num_lte of this ZoneWhereInput.  # noqa: E501


        :return: The running_vm_num_lte of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._running_vm_num_lte

    @running_vm_num_lte.setter
    def running_vm_num_lte(self, running_vm_num_lte):
        """Sets the running_vm_num_lte of this ZoneWhereInput.


        :param running_vm_num_lte: The running_vm_num_lte of this ZoneWhereInput.  # noqa: E501
        :type running_vm_num_lte: int
        """

        self._running_vm_num_lte = running_vm_num_lte

    @property
    def running_vm_num_not(self):
        """Gets the running_vm_num_not of this ZoneWhereInput.  # noqa: E501


        :return: The running_vm_num_not of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._running_vm_num_not

    @running_vm_num_not.setter
    def running_vm_num_not(self, running_vm_num_not):
        """Sets the running_vm_num_not of this ZoneWhereInput.


        :param running_vm_num_not: The running_vm_num_not of this ZoneWhereInput.  # noqa: E501
        :type running_vm_num_not: int
        """

        self._running_vm_num_not = running_vm_num_not

    @property
    def running_vm_num_not_in(self):
        """Gets the running_vm_num_not_in of this ZoneWhereInput.  # noqa: E501


        :return: The running_vm_num_not_in of this ZoneWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._running_vm_num_not_in

    @running_vm_num_not_in.setter
    def running_vm_num_not_in(self, running_vm_num_not_in):
        """Sets the running_vm_num_not_in of this ZoneWhereInput.


        :param running_vm_num_not_in: The running_vm_num_not_in of this ZoneWhereInput.  # noqa: E501
        :type running_vm_num_not_in: list[int]
        """

        self._running_vm_num_not_in = running_vm_num_not_in

    @property
    def stopped_vm_num(self):
        """Gets the stopped_vm_num of this ZoneWhereInput.  # noqa: E501


        :return: The stopped_vm_num of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._stopped_vm_num

    @stopped_vm_num.setter
    def stopped_vm_num(self, stopped_vm_num):
        """Sets the stopped_vm_num of this ZoneWhereInput.


        :param stopped_vm_num: The stopped_vm_num of this ZoneWhereInput.  # noqa: E501
        :type stopped_vm_num: int
        """

        self._stopped_vm_num = stopped_vm_num

    @property
    def stopped_vm_num_gt(self):
        """Gets the stopped_vm_num_gt of this ZoneWhereInput.  # noqa: E501


        :return: The stopped_vm_num_gt of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._stopped_vm_num_gt

    @stopped_vm_num_gt.setter
    def stopped_vm_num_gt(self, stopped_vm_num_gt):
        """Sets the stopped_vm_num_gt of this ZoneWhereInput.


        :param stopped_vm_num_gt: The stopped_vm_num_gt of this ZoneWhereInput.  # noqa: E501
        :type stopped_vm_num_gt: int
        """

        self._stopped_vm_num_gt = stopped_vm_num_gt

    @property
    def stopped_vm_num_gte(self):
        """Gets the stopped_vm_num_gte of this ZoneWhereInput.  # noqa: E501


        :return: The stopped_vm_num_gte of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._stopped_vm_num_gte

    @stopped_vm_num_gte.setter
    def stopped_vm_num_gte(self, stopped_vm_num_gte):
        """Sets the stopped_vm_num_gte of this ZoneWhereInput.


        :param stopped_vm_num_gte: The stopped_vm_num_gte of this ZoneWhereInput.  # noqa: E501
        :type stopped_vm_num_gte: int
        """

        self._stopped_vm_num_gte = stopped_vm_num_gte

    @property
    def stopped_vm_num_in(self):
        """Gets the stopped_vm_num_in of this ZoneWhereInput.  # noqa: E501


        :return: The stopped_vm_num_in of this ZoneWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._stopped_vm_num_in

    @stopped_vm_num_in.setter
    def stopped_vm_num_in(self, stopped_vm_num_in):
        """Sets the stopped_vm_num_in of this ZoneWhereInput.


        :param stopped_vm_num_in: The stopped_vm_num_in of this ZoneWhereInput.  # noqa: E501
        :type stopped_vm_num_in: list[int]
        """

        self._stopped_vm_num_in = stopped_vm_num_in

    @property
    def stopped_vm_num_lt(self):
        """Gets the stopped_vm_num_lt of this ZoneWhereInput.  # noqa: E501


        :return: The stopped_vm_num_lt of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._stopped_vm_num_lt

    @stopped_vm_num_lt.setter
    def stopped_vm_num_lt(self, stopped_vm_num_lt):
        """Sets the stopped_vm_num_lt of this ZoneWhereInput.


        :param stopped_vm_num_lt: The stopped_vm_num_lt of this ZoneWhereInput.  # noqa: E501
        :type stopped_vm_num_lt: int
        """

        self._stopped_vm_num_lt = stopped_vm_num_lt

    @property
    def stopped_vm_num_lte(self):
        """Gets the stopped_vm_num_lte of this ZoneWhereInput.  # noqa: E501


        :return: The stopped_vm_num_lte of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._stopped_vm_num_lte

    @stopped_vm_num_lte.setter
    def stopped_vm_num_lte(self, stopped_vm_num_lte):
        """Sets the stopped_vm_num_lte of this ZoneWhereInput.


        :param stopped_vm_num_lte: The stopped_vm_num_lte of this ZoneWhereInput.  # noqa: E501
        :type stopped_vm_num_lte: int
        """

        self._stopped_vm_num_lte = stopped_vm_num_lte

    @property
    def stopped_vm_num_not(self):
        """Gets the stopped_vm_num_not of this ZoneWhereInput.  # noqa: E501


        :return: The stopped_vm_num_not of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._stopped_vm_num_not

    @stopped_vm_num_not.setter
    def stopped_vm_num_not(self, stopped_vm_num_not):
        """Sets the stopped_vm_num_not of this ZoneWhereInput.


        :param stopped_vm_num_not: The stopped_vm_num_not of this ZoneWhereInput.  # noqa: E501
        :type stopped_vm_num_not: int
        """

        self._stopped_vm_num_not = stopped_vm_num_not

    @property
    def stopped_vm_num_not_in(self):
        """Gets the stopped_vm_num_not_in of this ZoneWhereInput.  # noqa: E501


        :return: The stopped_vm_num_not_in of this ZoneWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._stopped_vm_num_not_in

    @stopped_vm_num_not_in.setter
    def stopped_vm_num_not_in(self, stopped_vm_num_not_in):
        """Sets the stopped_vm_num_not_in of this ZoneWhereInput.


        :param stopped_vm_num_not_in: The stopped_vm_num_not_in of this ZoneWhereInput.  # noqa: E501
        :type stopped_vm_num_not_in: list[int]
        """

        self._stopped_vm_num_not_in = stopped_vm_num_not_in

    @property
    def suspended_vm_num(self):
        """Gets the suspended_vm_num of this ZoneWhereInput.  # noqa: E501


        :return: The suspended_vm_num of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._suspended_vm_num

    @suspended_vm_num.setter
    def suspended_vm_num(self, suspended_vm_num):
        """Sets the suspended_vm_num of this ZoneWhereInput.


        :param suspended_vm_num: The suspended_vm_num of this ZoneWhereInput.  # noqa: E501
        :type suspended_vm_num: int
        """

        self._suspended_vm_num = suspended_vm_num

    @property
    def suspended_vm_num_gt(self):
        """Gets the suspended_vm_num_gt of this ZoneWhereInput.  # noqa: E501


        :return: The suspended_vm_num_gt of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._suspended_vm_num_gt

    @suspended_vm_num_gt.setter
    def suspended_vm_num_gt(self, suspended_vm_num_gt):
        """Sets the suspended_vm_num_gt of this ZoneWhereInput.


        :param suspended_vm_num_gt: The suspended_vm_num_gt of this ZoneWhereInput.  # noqa: E501
        :type suspended_vm_num_gt: int
        """

        self._suspended_vm_num_gt = suspended_vm_num_gt

    @property
    def suspended_vm_num_gte(self):
        """Gets the suspended_vm_num_gte of this ZoneWhereInput.  # noqa: E501


        :return: The suspended_vm_num_gte of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._suspended_vm_num_gte

    @suspended_vm_num_gte.setter
    def suspended_vm_num_gte(self, suspended_vm_num_gte):
        """Sets the suspended_vm_num_gte of this ZoneWhereInput.


        :param suspended_vm_num_gte: The suspended_vm_num_gte of this ZoneWhereInput.  # noqa: E501
        :type suspended_vm_num_gte: int
        """

        self._suspended_vm_num_gte = suspended_vm_num_gte

    @property
    def suspended_vm_num_in(self):
        """Gets the suspended_vm_num_in of this ZoneWhereInput.  # noqa: E501


        :return: The suspended_vm_num_in of this ZoneWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._suspended_vm_num_in

    @suspended_vm_num_in.setter
    def suspended_vm_num_in(self, suspended_vm_num_in):
        """Sets the suspended_vm_num_in of this ZoneWhereInput.


        :param suspended_vm_num_in: The suspended_vm_num_in of this ZoneWhereInput.  # noqa: E501
        :type suspended_vm_num_in: list[int]
        """

        self._suspended_vm_num_in = suspended_vm_num_in

    @property
    def suspended_vm_num_lt(self):
        """Gets the suspended_vm_num_lt of this ZoneWhereInput.  # noqa: E501


        :return: The suspended_vm_num_lt of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._suspended_vm_num_lt

    @suspended_vm_num_lt.setter
    def suspended_vm_num_lt(self, suspended_vm_num_lt):
        """Sets the suspended_vm_num_lt of this ZoneWhereInput.


        :param suspended_vm_num_lt: The suspended_vm_num_lt of this ZoneWhereInput.  # noqa: E501
        :type suspended_vm_num_lt: int
        """

        self._suspended_vm_num_lt = suspended_vm_num_lt

    @property
    def suspended_vm_num_lte(self):
        """Gets the suspended_vm_num_lte of this ZoneWhereInput.  # noqa: E501


        :return: The suspended_vm_num_lte of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._suspended_vm_num_lte

    @suspended_vm_num_lte.setter
    def suspended_vm_num_lte(self, suspended_vm_num_lte):
        """Sets the suspended_vm_num_lte of this ZoneWhereInput.


        :param suspended_vm_num_lte: The suspended_vm_num_lte of this ZoneWhereInput.  # noqa: E501
        :type suspended_vm_num_lte: int
        """

        self._suspended_vm_num_lte = suspended_vm_num_lte

    @property
    def suspended_vm_num_not(self):
        """Gets the suspended_vm_num_not of this ZoneWhereInput.  # noqa: E501


        :return: The suspended_vm_num_not of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._suspended_vm_num_not

    @suspended_vm_num_not.setter
    def suspended_vm_num_not(self, suspended_vm_num_not):
        """Sets the suspended_vm_num_not of this ZoneWhereInput.


        :param suspended_vm_num_not: The suspended_vm_num_not of this ZoneWhereInput.  # noqa: E501
        :type suspended_vm_num_not: int
        """

        self._suspended_vm_num_not = suspended_vm_num_not

    @property
    def suspended_vm_num_not_in(self):
        """Gets the suspended_vm_num_not_in of this ZoneWhereInput.  # noqa: E501


        :return: The suspended_vm_num_not_in of this ZoneWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._suspended_vm_num_not_in

    @suspended_vm_num_not_in.setter
    def suspended_vm_num_not_in(self, suspended_vm_num_not_in):
        """Sets the suspended_vm_num_not_in of this ZoneWhereInput.


        :param suspended_vm_num_not_in: The suspended_vm_num_not_in of this ZoneWhereInput.  # noqa: E501
        :type suspended_vm_num_not_in: list[int]
        """

        self._suspended_vm_num_not_in = suspended_vm_num_not_in

    @property
    def total_cache_capacity(self):
        """Gets the total_cache_capacity of this ZoneWhereInput.  # noqa: E501


        :return: The total_cache_capacity of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cache_capacity

    @total_cache_capacity.setter
    def total_cache_capacity(self, total_cache_capacity):
        """Sets the total_cache_capacity of this ZoneWhereInput.


        :param total_cache_capacity: The total_cache_capacity of this ZoneWhereInput.  # noqa: E501
        :type total_cache_capacity: int
        """

        self._total_cache_capacity = total_cache_capacity

    @property
    def total_cache_capacity_gt(self):
        """Gets the total_cache_capacity_gt of this ZoneWhereInput.  # noqa: E501


        :return: The total_cache_capacity_gt of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cache_capacity_gt

    @total_cache_capacity_gt.setter
    def total_cache_capacity_gt(self, total_cache_capacity_gt):
        """Sets the total_cache_capacity_gt of this ZoneWhereInput.


        :param total_cache_capacity_gt: The total_cache_capacity_gt of this ZoneWhereInput.  # noqa: E501
        :type total_cache_capacity_gt: int
        """

        self._total_cache_capacity_gt = total_cache_capacity_gt

    @property
    def total_cache_capacity_gte(self):
        """Gets the total_cache_capacity_gte of this ZoneWhereInput.  # noqa: E501


        :return: The total_cache_capacity_gte of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cache_capacity_gte

    @total_cache_capacity_gte.setter
    def total_cache_capacity_gte(self, total_cache_capacity_gte):
        """Sets the total_cache_capacity_gte of this ZoneWhereInput.


        :param total_cache_capacity_gte: The total_cache_capacity_gte of this ZoneWhereInput.  # noqa: E501
        :type total_cache_capacity_gte: int
        """

        self._total_cache_capacity_gte = total_cache_capacity_gte

    @property
    def total_cache_capacity_in(self):
        """Gets the total_cache_capacity_in of this ZoneWhereInput.  # noqa: E501


        :return: The total_cache_capacity_in of this ZoneWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._total_cache_capacity_in

    @total_cache_capacity_in.setter
    def total_cache_capacity_in(self, total_cache_capacity_in):
        """Sets the total_cache_capacity_in of this ZoneWhereInput.


        :param total_cache_capacity_in: The total_cache_capacity_in of this ZoneWhereInput.  # noqa: E501
        :type total_cache_capacity_in: list[int]
        """

        self._total_cache_capacity_in = total_cache_capacity_in

    @property
    def total_cache_capacity_lt(self):
        """Gets the total_cache_capacity_lt of this ZoneWhereInput.  # noqa: E501


        :return: The total_cache_capacity_lt of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cache_capacity_lt

    @total_cache_capacity_lt.setter
    def total_cache_capacity_lt(self, total_cache_capacity_lt):
        """Sets the total_cache_capacity_lt of this ZoneWhereInput.


        :param total_cache_capacity_lt: The total_cache_capacity_lt of this ZoneWhereInput.  # noqa: E501
        :type total_cache_capacity_lt: int
        """

        self._total_cache_capacity_lt = total_cache_capacity_lt

    @property
    def total_cache_capacity_lte(self):
        """Gets the total_cache_capacity_lte of this ZoneWhereInput.  # noqa: E501


        :return: The total_cache_capacity_lte of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cache_capacity_lte

    @total_cache_capacity_lte.setter
    def total_cache_capacity_lte(self, total_cache_capacity_lte):
        """Sets the total_cache_capacity_lte of this ZoneWhereInput.


        :param total_cache_capacity_lte: The total_cache_capacity_lte of this ZoneWhereInput.  # noqa: E501
        :type total_cache_capacity_lte: int
        """

        self._total_cache_capacity_lte = total_cache_capacity_lte

    @property
    def total_cache_capacity_not(self):
        """Gets the total_cache_capacity_not of this ZoneWhereInput.  # noqa: E501


        :return: The total_cache_capacity_not of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cache_capacity_not

    @total_cache_capacity_not.setter
    def total_cache_capacity_not(self, total_cache_capacity_not):
        """Sets the total_cache_capacity_not of this ZoneWhereInput.


        :param total_cache_capacity_not: The total_cache_capacity_not of this ZoneWhereInput.  # noqa: E501
        :type total_cache_capacity_not: int
        """

        self._total_cache_capacity_not = total_cache_capacity_not

    @property
    def total_cache_capacity_not_in(self):
        """Gets the total_cache_capacity_not_in of this ZoneWhereInput.  # noqa: E501


        :return: The total_cache_capacity_not_in of this ZoneWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._total_cache_capacity_not_in

    @total_cache_capacity_not_in.setter
    def total_cache_capacity_not_in(self, total_cache_capacity_not_in):
        """Sets the total_cache_capacity_not_in of this ZoneWhereInput.


        :param total_cache_capacity_not_in: The total_cache_capacity_not_in of this ZoneWhereInput.  # noqa: E501
        :type total_cache_capacity_not_in: list[int]
        """

        self._total_cache_capacity_not_in = total_cache_capacity_not_in

    @property
    def total_cpu_cores(self):
        """Gets the total_cpu_cores of this ZoneWhereInput.  # noqa: E501


        :return: The total_cpu_cores of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cpu_cores

    @total_cpu_cores.setter
    def total_cpu_cores(self, total_cpu_cores):
        """Sets the total_cpu_cores of this ZoneWhereInput.


        :param total_cpu_cores: The total_cpu_cores of this ZoneWhereInput.  # noqa: E501
        :type total_cpu_cores: int
        """

        self._total_cpu_cores = total_cpu_cores

    @property
    def total_cpu_cores_gt(self):
        """Gets the total_cpu_cores_gt of this ZoneWhereInput.  # noqa: E501


        :return: The total_cpu_cores_gt of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cpu_cores_gt

    @total_cpu_cores_gt.setter
    def total_cpu_cores_gt(self, total_cpu_cores_gt):
        """Sets the total_cpu_cores_gt of this ZoneWhereInput.


        :param total_cpu_cores_gt: The total_cpu_cores_gt of this ZoneWhereInput.  # noqa: E501
        :type total_cpu_cores_gt: int
        """

        self._total_cpu_cores_gt = total_cpu_cores_gt

    @property
    def total_cpu_cores_gte(self):
        """Gets the total_cpu_cores_gte of this ZoneWhereInput.  # noqa: E501


        :return: The total_cpu_cores_gte of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cpu_cores_gte

    @total_cpu_cores_gte.setter
    def total_cpu_cores_gte(self, total_cpu_cores_gte):
        """Sets the total_cpu_cores_gte of this ZoneWhereInput.


        :param total_cpu_cores_gte: The total_cpu_cores_gte of this ZoneWhereInput.  # noqa: E501
        :type total_cpu_cores_gte: int
        """

        self._total_cpu_cores_gte = total_cpu_cores_gte

    @property
    def total_cpu_cores_in(self):
        """Gets the total_cpu_cores_in of this ZoneWhereInput.  # noqa: E501


        :return: The total_cpu_cores_in of this ZoneWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._total_cpu_cores_in

    @total_cpu_cores_in.setter
    def total_cpu_cores_in(self, total_cpu_cores_in):
        """Sets the total_cpu_cores_in of this ZoneWhereInput.


        :param total_cpu_cores_in: The total_cpu_cores_in of this ZoneWhereInput.  # noqa: E501
        :type total_cpu_cores_in: list[int]
        """

        self._total_cpu_cores_in = total_cpu_cores_in

    @property
    def total_cpu_cores_lt(self):
        """Gets the total_cpu_cores_lt of this ZoneWhereInput.  # noqa: E501


        :return: The total_cpu_cores_lt of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cpu_cores_lt

    @total_cpu_cores_lt.setter
    def total_cpu_cores_lt(self, total_cpu_cores_lt):
        """Sets the total_cpu_cores_lt of this ZoneWhereInput.


        :param total_cpu_cores_lt: The total_cpu_cores_lt of this ZoneWhereInput.  # noqa: E501
        :type total_cpu_cores_lt: int
        """

        self._total_cpu_cores_lt = total_cpu_cores_lt

    @property
    def total_cpu_cores_lte(self):
        """Gets the total_cpu_cores_lte of this ZoneWhereInput.  # noqa: E501


        :return: The total_cpu_cores_lte of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cpu_cores_lte

    @total_cpu_cores_lte.setter
    def total_cpu_cores_lte(self, total_cpu_cores_lte):
        """Sets the total_cpu_cores_lte of this ZoneWhereInput.


        :param total_cpu_cores_lte: The total_cpu_cores_lte of this ZoneWhereInput.  # noqa: E501
        :type total_cpu_cores_lte: int
        """

        self._total_cpu_cores_lte = total_cpu_cores_lte

    @property
    def total_cpu_cores_not(self):
        """Gets the total_cpu_cores_not of this ZoneWhereInput.  # noqa: E501


        :return: The total_cpu_cores_not of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cpu_cores_not

    @total_cpu_cores_not.setter
    def total_cpu_cores_not(self, total_cpu_cores_not):
        """Sets the total_cpu_cores_not of this ZoneWhereInput.


        :param total_cpu_cores_not: The total_cpu_cores_not of this ZoneWhereInput.  # noqa: E501
        :type total_cpu_cores_not: int
        """

        self._total_cpu_cores_not = total_cpu_cores_not

    @property
    def total_cpu_cores_not_in(self):
        """Gets the total_cpu_cores_not_in of this ZoneWhereInput.  # noqa: E501


        :return: The total_cpu_cores_not_in of this ZoneWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._total_cpu_cores_not_in

    @total_cpu_cores_not_in.setter
    def total_cpu_cores_not_in(self, total_cpu_cores_not_in):
        """Sets the total_cpu_cores_not_in of this ZoneWhereInput.


        :param total_cpu_cores_not_in: The total_cpu_cores_not_in of this ZoneWhereInput.  # noqa: E501
        :type total_cpu_cores_not_in: list[int]
        """

        self._total_cpu_cores_not_in = total_cpu_cores_not_in

    @property
    def total_cpu_hz(self):
        """Gets the total_cpu_hz of this ZoneWhereInput.  # noqa: E501


        :return: The total_cpu_hz of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cpu_hz

    @total_cpu_hz.setter
    def total_cpu_hz(self, total_cpu_hz):
        """Sets the total_cpu_hz of this ZoneWhereInput.


        :param total_cpu_hz: The total_cpu_hz of this ZoneWhereInput.  # noqa: E501
        :type total_cpu_hz: int
        """

        self._total_cpu_hz = total_cpu_hz

    @property
    def total_cpu_hz_gt(self):
        """Gets the total_cpu_hz_gt of this ZoneWhereInput.  # noqa: E501


        :return: The total_cpu_hz_gt of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cpu_hz_gt

    @total_cpu_hz_gt.setter
    def total_cpu_hz_gt(self, total_cpu_hz_gt):
        """Sets the total_cpu_hz_gt of this ZoneWhereInput.


        :param total_cpu_hz_gt: The total_cpu_hz_gt of this ZoneWhereInput.  # noqa: E501
        :type total_cpu_hz_gt: int
        """

        self._total_cpu_hz_gt = total_cpu_hz_gt

    @property
    def total_cpu_hz_gte(self):
        """Gets the total_cpu_hz_gte of this ZoneWhereInput.  # noqa: E501


        :return: The total_cpu_hz_gte of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cpu_hz_gte

    @total_cpu_hz_gte.setter
    def total_cpu_hz_gte(self, total_cpu_hz_gte):
        """Sets the total_cpu_hz_gte of this ZoneWhereInput.


        :param total_cpu_hz_gte: The total_cpu_hz_gte of this ZoneWhereInput.  # noqa: E501
        :type total_cpu_hz_gte: int
        """

        self._total_cpu_hz_gte = total_cpu_hz_gte

    @property
    def total_cpu_hz_in(self):
        """Gets the total_cpu_hz_in of this ZoneWhereInput.  # noqa: E501


        :return: The total_cpu_hz_in of this ZoneWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._total_cpu_hz_in

    @total_cpu_hz_in.setter
    def total_cpu_hz_in(self, total_cpu_hz_in):
        """Sets the total_cpu_hz_in of this ZoneWhereInput.


        :param total_cpu_hz_in: The total_cpu_hz_in of this ZoneWhereInput.  # noqa: E501
        :type total_cpu_hz_in: list[int]
        """

        self._total_cpu_hz_in = total_cpu_hz_in

    @property
    def total_cpu_hz_lt(self):
        """Gets the total_cpu_hz_lt of this ZoneWhereInput.  # noqa: E501


        :return: The total_cpu_hz_lt of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cpu_hz_lt

    @total_cpu_hz_lt.setter
    def total_cpu_hz_lt(self, total_cpu_hz_lt):
        """Sets the total_cpu_hz_lt of this ZoneWhereInput.


        :param total_cpu_hz_lt: The total_cpu_hz_lt of this ZoneWhereInput.  # noqa: E501
        :type total_cpu_hz_lt: int
        """

        self._total_cpu_hz_lt = total_cpu_hz_lt

    @property
    def total_cpu_hz_lte(self):
        """Gets the total_cpu_hz_lte of this ZoneWhereInput.  # noqa: E501


        :return: The total_cpu_hz_lte of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cpu_hz_lte

    @total_cpu_hz_lte.setter
    def total_cpu_hz_lte(self, total_cpu_hz_lte):
        """Sets the total_cpu_hz_lte of this ZoneWhereInput.


        :param total_cpu_hz_lte: The total_cpu_hz_lte of this ZoneWhereInput.  # noqa: E501
        :type total_cpu_hz_lte: int
        """

        self._total_cpu_hz_lte = total_cpu_hz_lte

    @property
    def total_cpu_hz_not(self):
        """Gets the total_cpu_hz_not of this ZoneWhereInput.  # noqa: E501


        :return: The total_cpu_hz_not of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_cpu_hz_not

    @total_cpu_hz_not.setter
    def total_cpu_hz_not(self, total_cpu_hz_not):
        """Sets the total_cpu_hz_not of this ZoneWhereInput.


        :param total_cpu_hz_not: The total_cpu_hz_not of this ZoneWhereInput.  # noqa: E501
        :type total_cpu_hz_not: int
        """

        self._total_cpu_hz_not = total_cpu_hz_not

    @property
    def total_cpu_hz_not_in(self):
        """Gets the total_cpu_hz_not_in of this ZoneWhereInput.  # noqa: E501


        :return: The total_cpu_hz_not_in of this ZoneWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._total_cpu_hz_not_in

    @total_cpu_hz_not_in.setter
    def total_cpu_hz_not_in(self, total_cpu_hz_not_in):
        """Sets the total_cpu_hz_not_in of this ZoneWhereInput.


        :param total_cpu_hz_not_in: The total_cpu_hz_not_in of this ZoneWhereInput.  # noqa: E501
        :type total_cpu_hz_not_in: list[int]
        """

        self._total_cpu_hz_not_in = total_cpu_hz_not_in

    @property
    def total_data_capacity(self):
        """Gets the total_data_capacity of this ZoneWhereInput.  # noqa: E501


        :return: The total_data_capacity of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_data_capacity

    @total_data_capacity.setter
    def total_data_capacity(self, total_data_capacity):
        """Sets the total_data_capacity of this ZoneWhereInput.


        :param total_data_capacity: The total_data_capacity of this ZoneWhereInput.  # noqa: E501
        :type total_data_capacity: int
        """

        self._total_data_capacity = total_data_capacity

    @property
    def total_data_capacity_gt(self):
        """Gets the total_data_capacity_gt of this ZoneWhereInput.  # noqa: E501


        :return: The total_data_capacity_gt of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_data_capacity_gt

    @total_data_capacity_gt.setter
    def total_data_capacity_gt(self, total_data_capacity_gt):
        """Sets the total_data_capacity_gt of this ZoneWhereInput.


        :param total_data_capacity_gt: The total_data_capacity_gt of this ZoneWhereInput.  # noqa: E501
        :type total_data_capacity_gt: int
        """

        self._total_data_capacity_gt = total_data_capacity_gt

    @property
    def total_data_capacity_gte(self):
        """Gets the total_data_capacity_gte of this ZoneWhereInput.  # noqa: E501


        :return: The total_data_capacity_gte of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_data_capacity_gte

    @total_data_capacity_gte.setter
    def total_data_capacity_gte(self, total_data_capacity_gte):
        """Sets the total_data_capacity_gte of this ZoneWhereInput.


        :param total_data_capacity_gte: The total_data_capacity_gte of this ZoneWhereInput.  # noqa: E501
        :type total_data_capacity_gte: int
        """

        self._total_data_capacity_gte = total_data_capacity_gte

    @property
    def total_data_capacity_in(self):
        """Gets the total_data_capacity_in of this ZoneWhereInput.  # noqa: E501


        :return: The total_data_capacity_in of this ZoneWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._total_data_capacity_in

    @total_data_capacity_in.setter
    def total_data_capacity_in(self, total_data_capacity_in):
        """Sets the total_data_capacity_in of this ZoneWhereInput.


        :param total_data_capacity_in: The total_data_capacity_in of this ZoneWhereInput.  # noqa: E501
        :type total_data_capacity_in: list[int]
        """

        self._total_data_capacity_in = total_data_capacity_in

    @property
    def total_data_capacity_lt(self):
        """Gets the total_data_capacity_lt of this ZoneWhereInput.  # noqa: E501


        :return: The total_data_capacity_lt of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_data_capacity_lt

    @total_data_capacity_lt.setter
    def total_data_capacity_lt(self, total_data_capacity_lt):
        """Sets the total_data_capacity_lt of this ZoneWhereInput.


        :param total_data_capacity_lt: The total_data_capacity_lt of this ZoneWhereInput.  # noqa: E501
        :type total_data_capacity_lt: int
        """

        self._total_data_capacity_lt = total_data_capacity_lt

    @property
    def total_data_capacity_lte(self):
        """Gets the total_data_capacity_lte of this ZoneWhereInput.  # noqa: E501


        :return: The total_data_capacity_lte of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_data_capacity_lte

    @total_data_capacity_lte.setter
    def total_data_capacity_lte(self, total_data_capacity_lte):
        """Sets the total_data_capacity_lte of this ZoneWhereInput.


        :param total_data_capacity_lte: The total_data_capacity_lte of this ZoneWhereInput.  # noqa: E501
        :type total_data_capacity_lte: int
        """

        self._total_data_capacity_lte = total_data_capacity_lte

    @property
    def total_data_capacity_not(self):
        """Gets the total_data_capacity_not of this ZoneWhereInput.  # noqa: E501


        :return: The total_data_capacity_not of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_data_capacity_not

    @total_data_capacity_not.setter
    def total_data_capacity_not(self, total_data_capacity_not):
        """Sets the total_data_capacity_not of this ZoneWhereInput.


        :param total_data_capacity_not: The total_data_capacity_not of this ZoneWhereInput.  # noqa: E501
        :type total_data_capacity_not: int
        """

        self._total_data_capacity_not = total_data_capacity_not

    @property
    def total_data_capacity_not_in(self):
        """Gets the total_data_capacity_not_in of this ZoneWhereInput.  # noqa: E501


        :return: The total_data_capacity_not_in of this ZoneWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._total_data_capacity_not_in

    @total_data_capacity_not_in.setter
    def total_data_capacity_not_in(self, total_data_capacity_not_in):
        """Sets the total_data_capacity_not_in of this ZoneWhereInput.


        :param total_data_capacity_not_in: The total_data_capacity_not_in of this ZoneWhereInput.  # noqa: E501
        :type total_data_capacity_not_in: list[int]
        """

        self._total_data_capacity_not_in = total_data_capacity_not_in

    @property
    def total_memory_bytes(self):
        """Gets the total_memory_bytes of this ZoneWhereInput.  # noqa: E501


        :return: The total_memory_bytes of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_memory_bytes

    @total_memory_bytes.setter
    def total_memory_bytes(self, total_memory_bytes):
        """Sets the total_memory_bytes of this ZoneWhereInput.


        :param total_memory_bytes: The total_memory_bytes of this ZoneWhereInput.  # noqa: E501
        :type total_memory_bytes: int
        """

        self._total_memory_bytes = total_memory_bytes

    @property
    def total_memory_bytes_gt(self):
        """Gets the total_memory_bytes_gt of this ZoneWhereInput.  # noqa: E501


        :return: The total_memory_bytes_gt of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_memory_bytes_gt

    @total_memory_bytes_gt.setter
    def total_memory_bytes_gt(self, total_memory_bytes_gt):
        """Sets the total_memory_bytes_gt of this ZoneWhereInput.


        :param total_memory_bytes_gt: The total_memory_bytes_gt of this ZoneWhereInput.  # noqa: E501
        :type total_memory_bytes_gt: int
        """

        self._total_memory_bytes_gt = total_memory_bytes_gt

    @property
    def total_memory_bytes_gte(self):
        """Gets the total_memory_bytes_gte of this ZoneWhereInput.  # noqa: E501


        :return: The total_memory_bytes_gte of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_memory_bytes_gte

    @total_memory_bytes_gte.setter
    def total_memory_bytes_gte(self, total_memory_bytes_gte):
        """Sets the total_memory_bytes_gte of this ZoneWhereInput.


        :param total_memory_bytes_gte: The total_memory_bytes_gte of this ZoneWhereInput.  # noqa: E501
        :type total_memory_bytes_gte: int
        """

        self._total_memory_bytes_gte = total_memory_bytes_gte

    @property
    def total_memory_bytes_in(self):
        """Gets the total_memory_bytes_in of this ZoneWhereInput.  # noqa: E501


        :return: The total_memory_bytes_in of this ZoneWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._total_memory_bytes_in

    @total_memory_bytes_in.setter
    def total_memory_bytes_in(self, total_memory_bytes_in):
        """Sets the total_memory_bytes_in of this ZoneWhereInput.


        :param total_memory_bytes_in: The total_memory_bytes_in of this ZoneWhereInput.  # noqa: E501
        :type total_memory_bytes_in: list[int]
        """

        self._total_memory_bytes_in = total_memory_bytes_in

    @property
    def total_memory_bytes_lt(self):
        """Gets the total_memory_bytes_lt of this ZoneWhereInput.  # noqa: E501


        :return: The total_memory_bytes_lt of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_memory_bytes_lt

    @total_memory_bytes_lt.setter
    def total_memory_bytes_lt(self, total_memory_bytes_lt):
        """Sets the total_memory_bytes_lt of this ZoneWhereInput.


        :param total_memory_bytes_lt: The total_memory_bytes_lt of this ZoneWhereInput.  # noqa: E501
        :type total_memory_bytes_lt: int
        """

        self._total_memory_bytes_lt = total_memory_bytes_lt

    @property
    def total_memory_bytes_lte(self):
        """Gets the total_memory_bytes_lte of this ZoneWhereInput.  # noqa: E501


        :return: The total_memory_bytes_lte of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_memory_bytes_lte

    @total_memory_bytes_lte.setter
    def total_memory_bytes_lte(self, total_memory_bytes_lte):
        """Sets the total_memory_bytes_lte of this ZoneWhereInput.


        :param total_memory_bytes_lte: The total_memory_bytes_lte of this ZoneWhereInput.  # noqa: E501
        :type total_memory_bytes_lte: int
        """

        self._total_memory_bytes_lte = total_memory_bytes_lte

    @property
    def total_memory_bytes_not(self):
        """Gets the total_memory_bytes_not of this ZoneWhereInput.  # noqa: E501


        :return: The total_memory_bytes_not of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_memory_bytes_not

    @total_memory_bytes_not.setter
    def total_memory_bytes_not(self, total_memory_bytes_not):
        """Sets the total_memory_bytes_not of this ZoneWhereInput.


        :param total_memory_bytes_not: The total_memory_bytes_not of this ZoneWhereInput.  # noqa: E501
        :type total_memory_bytes_not: int
        """

        self._total_memory_bytes_not = total_memory_bytes_not

    @property
    def total_memory_bytes_not_in(self):
        """Gets the total_memory_bytes_not_in of this ZoneWhereInput.  # noqa: E501


        :return: The total_memory_bytes_not_in of this ZoneWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._total_memory_bytes_not_in

    @total_memory_bytes_not_in.setter
    def total_memory_bytes_not_in(self, total_memory_bytes_not_in):
        """Sets the total_memory_bytes_not_in of this ZoneWhereInput.


        :param total_memory_bytes_not_in: The total_memory_bytes_not_in of this ZoneWhereInput.  # noqa: E501
        :type total_memory_bytes_not_in: list[int]
        """

        self._total_memory_bytes_not_in = total_memory_bytes_not_in

    @property
    def used_data_space(self):
        """Gets the used_data_space of this ZoneWhereInput.  # noqa: E501


        :return: The used_data_space of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._used_data_space

    @used_data_space.setter
    def used_data_space(self, used_data_space):
        """Sets the used_data_space of this ZoneWhereInput.


        :param used_data_space: The used_data_space of this ZoneWhereInput.  # noqa: E501
        :type used_data_space: int
        """

        self._used_data_space = used_data_space

    @property
    def used_data_space_gt(self):
        """Gets the used_data_space_gt of this ZoneWhereInput.  # noqa: E501


        :return: The used_data_space_gt of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._used_data_space_gt

    @used_data_space_gt.setter
    def used_data_space_gt(self, used_data_space_gt):
        """Sets the used_data_space_gt of this ZoneWhereInput.


        :param used_data_space_gt: The used_data_space_gt of this ZoneWhereInput.  # noqa: E501
        :type used_data_space_gt: int
        """

        self._used_data_space_gt = used_data_space_gt

    @property
    def used_data_space_gte(self):
        """Gets the used_data_space_gte of this ZoneWhereInput.  # noqa: E501


        :return: The used_data_space_gte of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._used_data_space_gte

    @used_data_space_gte.setter
    def used_data_space_gte(self, used_data_space_gte):
        """Sets the used_data_space_gte of this ZoneWhereInput.


        :param used_data_space_gte: The used_data_space_gte of this ZoneWhereInput.  # noqa: E501
        :type used_data_space_gte: int
        """

        self._used_data_space_gte = used_data_space_gte

    @property
    def used_data_space_in(self):
        """Gets the used_data_space_in of this ZoneWhereInput.  # noqa: E501


        :return: The used_data_space_in of this ZoneWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._used_data_space_in

    @used_data_space_in.setter
    def used_data_space_in(self, used_data_space_in):
        """Sets the used_data_space_in of this ZoneWhereInput.


        :param used_data_space_in: The used_data_space_in of this ZoneWhereInput.  # noqa: E501
        :type used_data_space_in: list[int]
        """

        self._used_data_space_in = used_data_space_in

    @property
    def used_data_space_lt(self):
        """Gets the used_data_space_lt of this ZoneWhereInput.  # noqa: E501


        :return: The used_data_space_lt of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._used_data_space_lt

    @used_data_space_lt.setter
    def used_data_space_lt(self, used_data_space_lt):
        """Sets the used_data_space_lt of this ZoneWhereInput.


        :param used_data_space_lt: The used_data_space_lt of this ZoneWhereInput.  # noqa: E501
        :type used_data_space_lt: int
        """

        self._used_data_space_lt = used_data_space_lt

    @property
    def used_data_space_lte(self):
        """Gets the used_data_space_lte of this ZoneWhereInput.  # noqa: E501


        :return: The used_data_space_lte of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._used_data_space_lte

    @used_data_space_lte.setter
    def used_data_space_lte(self, used_data_space_lte):
        """Sets the used_data_space_lte of this ZoneWhereInput.


        :param used_data_space_lte: The used_data_space_lte of this ZoneWhereInput.  # noqa: E501
        :type used_data_space_lte: int
        """

        self._used_data_space_lte = used_data_space_lte

    @property
    def used_data_space_not(self):
        """Gets the used_data_space_not of this ZoneWhereInput.  # noqa: E501


        :return: The used_data_space_not of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._used_data_space_not

    @used_data_space_not.setter
    def used_data_space_not(self, used_data_space_not):
        """Sets the used_data_space_not of this ZoneWhereInput.


        :param used_data_space_not: The used_data_space_not of this ZoneWhereInput.  # noqa: E501
        :type used_data_space_not: int
        """

        self._used_data_space_not = used_data_space_not

    @property
    def used_data_space_not_in(self):
        """Gets the used_data_space_not_in of this ZoneWhereInput.  # noqa: E501


        :return: The used_data_space_not_in of this ZoneWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._used_data_space_not_in

    @used_data_space_not_in.setter
    def used_data_space_not_in(self, used_data_space_not_in):
        """Sets the used_data_space_not_in of this ZoneWhereInput.


        :param used_data_space_not_in: The used_data_space_not_in of this ZoneWhereInput.  # noqa: E501
        :type used_data_space_not_in: list[int]
        """

        self._used_data_space_not_in = used_data_space_not_in

    @property
    def valid_data_space(self):
        """Gets the valid_data_space of this ZoneWhereInput.  # noqa: E501


        :return: The valid_data_space of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_data_space

    @valid_data_space.setter
    def valid_data_space(self, valid_data_space):
        """Sets the valid_data_space of this ZoneWhereInput.


        :param valid_data_space: The valid_data_space of this ZoneWhereInput.  # noqa: E501
        :type valid_data_space: int
        """

        self._valid_data_space = valid_data_space

    @property
    def valid_data_space_gt(self):
        """Gets the valid_data_space_gt of this ZoneWhereInput.  # noqa: E501


        :return: The valid_data_space_gt of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_data_space_gt

    @valid_data_space_gt.setter
    def valid_data_space_gt(self, valid_data_space_gt):
        """Sets the valid_data_space_gt of this ZoneWhereInput.


        :param valid_data_space_gt: The valid_data_space_gt of this ZoneWhereInput.  # noqa: E501
        :type valid_data_space_gt: int
        """

        self._valid_data_space_gt = valid_data_space_gt

    @property
    def valid_data_space_gte(self):
        """Gets the valid_data_space_gte of this ZoneWhereInput.  # noqa: E501


        :return: The valid_data_space_gte of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_data_space_gte

    @valid_data_space_gte.setter
    def valid_data_space_gte(self, valid_data_space_gte):
        """Sets the valid_data_space_gte of this ZoneWhereInput.


        :param valid_data_space_gte: The valid_data_space_gte of this ZoneWhereInput.  # noqa: E501
        :type valid_data_space_gte: int
        """

        self._valid_data_space_gte = valid_data_space_gte

    @property
    def valid_data_space_in(self):
        """Gets the valid_data_space_in of this ZoneWhereInput.  # noqa: E501


        :return: The valid_data_space_in of this ZoneWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._valid_data_space_in

    @valid_data_space_in.setter
    def valid_data_space_in(self, valid_data_space_in):
        """Sets the valid_data_space_in of this ZoneWhereInput.


        :param valid_data_space_in: The valid_data_space_in of this ZoneWhereInput.  # noqa: E501
        :type valid_data_space_in: list[int]
        """

        self._valid_data_space_in = valid_data_space_in

    @property
    def valid_data_space_lt(self):
        """Gets the valid_data_space_lt of this ZoneWhereInput.  # noqa: E501


        :return: The valid_data_space_lt of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_data_space_lt

    @valid_data_space_lt.setter
    def valid_data_space_lt(self, valid_data_space_lt):
        """Sets the valid_data_space_lt of this ZoneWhereInput.


        :param valid_data_space_lt: The valid_data_space_lt of this ZoneWhereInput.  # noqa: E501
        :type valid_data_space_lt: int
        """

        self._valid_data_space_lt = valid_data_space_lt

    @property
    def valid_data_space_lte(self):
        """Gets the valid_data_space_lte of this ZoneWhereInput.  # noqa: E501


        :return: The valid_data_space_lte of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_data_space_lte

    @valid_data_space_lte.setter
    def valid_data_space_lte(self, valid_data_space_lte):
        """Sets the valid_data_space_lte of this ZoneWhereInput.


        :param valid_data_space_lte: The valid_data_space_lte of this ZoneWhereInput.  # noqa: E501
        :type valid_data_space_lte: int
        """

        self._valid_data_space_lte = valid_data_space_lte

    @property
    def valid_data_space_not(self):
        """Gets the valid_data_space_not of this ZoneWhereInput.  # noqa: E501


        :return: The valid_data_space_not of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_data_space_not

    @valid_data_space_not.setter
    def valid_data_space_not(self, valid_data_space_not):
        """Sets the valid_data_space_not of this ZoneWhereInput.


        :param valid_data_space_not: The valid_data_space_not of this ZoneWhereInput.  # noqa: E501
        :type valid_data_space_not: int
        """

        self._valid_data_space_not = valid_data_space_not

    @property
    def valid_data_space_not_in(self):
        """Gets the valid_data_space_not_in of this ZoneWhereInput.  # noqa: E501


        :return: The valid_data_space_not_in of this ZoneWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._valid_data_space_not_in

    @valid_data_space_not_in.setter
    def valid_data_space_not_in(self, valid_data_space_not_in):
        """Sets the valid_data_space_not_in of this ZoneWhereInput.


        :param valid_data_space_not_in: The valid_data_space_not_in of this ZoneWhereInput.  # noqa: E501
        :type valid_data_space_not_in: list[int]
        """

        self._valid_data_space_not_in = valid_data_space_not_in

    @property
    def vm_num(self):
        """Gets the vm_num of this ZoneWhereInput.  # noqa: E501


        :return: The vm_num of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._vm_num

    @vm_num.setter
    def vm_num(self, vm_num):
        """Sets the vm_num of this ZoneWhereInput.


        :param vm_num: The vm_num of this ZoneWhereInput.  # noqa: E501
        :type vm_num: int
        """

        self._vm_num = vm_num

    @property
    def vm_num_gt(self):
        """Gets the vm_num_gt of this ZoneWhereInput.  # noqa: E501


        :return: The vm_num_gt of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._vm_num_gt

    @vm_num_gt.setter
    def vm_num_gt(self, vm_num_gt):
        """Sets the vm_num_gt of this ZoneWhereInput.


        :param vm_num_gt: The vm_num_gt of this ZoneWhereInput.  # noqa: E501
        :type vm_num_gt: int
        """

        self._vm_num_gt = vm_num_gt

    @property
    def vm_num_gte(self):
        """Gets the vm_num_gte of this ZoneWhereInput.  # noqa: E501


        :return: The vm_num_gte of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._vm_num_gte

    @vm_num_gte.setter
    def vm_num_gte(self, vm_num_gte):
        """Sets the vm_num_gte of this ZoneWhereInput.


        :param vm_num_gte: The vm_num_gte of this ZoneWhereInput.  # noqa: E501
        :type vm_num_gte: int
        """

        self._vm_num_gte = vm_num_gte

    @property
    def vm_num_in(self):
        """Gets the vm_num_in of this ZoneWhereInput.  # noqa: E501


        :return: The vm_num_in of this ZoneWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._vm_num_in

    @vm_num_in.setter
    def vm_num_in(self, vm_num_in):
        """Sets the vm_num_in of this ZoneWhereInput.


        :param vm_num_in: The vm_num_in of this ZoneWhereInput.  # noqa: E501
        :type vm_num_in: list[int]
        """

        self._vm_num_in = vm_num_in

    @property
    def vm_num_lt(self):
        """Gets the vm_num_lt of this ZoneWhereInput.  # noqa: E501


        :return: The vm_num_lt of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._vm_num_lt

    @vm_num_lt.setter
    def vm_num_lt(self, vm_num_lt):
        """Sets the vm_num_lt of this ZoneWhereInput.


        :param vm_num_lt: The vm_num_lt of this ZoneWhereInput.  # noqa: E501
        :type vm_num_lt: int
        """

        self._vm_num_lt = vm_num_lt

    @property
    def vm_num_lte(self):
        """Gets the vm_num_lte of this ZoneWhereInput.  # noqa: E501


        :return: The vm_num_lte of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._vm_num_lte

    @vm_num_lte.setter
    def vm_num_lte(self, vm_num_lte):
        """Sets the vm_num_lte of this ZoneWhereInput.


        :param vm_num_lte: The vm_num_lte of this ZoneWhereInput.  # noqa: E501
        :type vm_num_lte: int
        """

        self._vm_num_lte = vm_num_lte

    @property
    def vm_num_not(self):
        """Gets the vm_num_not of this ZoneWhereInput.  # noqa: E501


        :return: The vm_num_not of this ZoneWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._vm_num_not

    @vm_num_not.setter
    def vm_num_not(self, vm_num_not):
        """Sets the vm_num_not of this ZoneWhereInput.


        :param vm_num_not: The vm_num_not of this ZoneWhereInput.  # noqa: E501
        :type vm_num_not: int
        """

        self._vm_num_not = vm_num_not

    @property
    def vm_num_not_in(self):
        """Gets the vm_num_not_in of this ZoneWhereInput.  # noqa: E501


        :return: The vm_num_not_in of this ZoneWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._vm_num_not_in

    @vm_num_not_in.setter
    def vm_num_not_in(self, vm_num_not_in):
        """Sets the vm_num_not_in of this ZoneWhereInput.


        :param vm_num_not_in: The vm_num_not_in of this ZoneWhereInput.  # noqa: E501
        :type vm_num_not_in: list[int]
        """

        self._vm_num_not_in = vm_num_not_in

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ZoneWhereInput):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ZoneWhereInput):
            return True

        return self.to_dict() != other.to_dict()
