"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WatchfulAspect = void 0;
const apigw = require("@aws-cdk/aws-apigateway");
const dynamodb = require("@aws-cdk/aws-dynamodb");
const ecs_patterns = require("@aws-cdk/aws-ecs-patterns");
const lambda = require("@aws-cdk/aws-lambda");
const rds = require("@aws-cdk/aws-rds");
/**
 * A CDK aspect that can automatically watch all resources within a scope.
 */
class WatchfulAspect {
    /**
     * Defines a watchful aspect
     * @param watchful The watchful to add those resources to
     * @param props Options
     */
    constructor(watchful, props = {}) {
        this.watchful = watchful;
        this.props = props;
    }
    visit(node) {
        const watchApiGateway = this.props.apiGateway === undefined ? true : this.props.apiGateway;
        const watchDynamo = this.props.dynamodb === undefined ? true : this.props.dynamodb;
        const watchLambda = this.props.lambda === undefined ? true : this.props.lambda;
        const watchRdsAuroraCluster = this.props.rdsaurora === undefined ? true : this.props.rdsaurora;
        const watchFargateEcs = this.props.fargateecs === undefined ? true : this.props.fargateecs;
        const watchEc2Ecs = this.props.ec2ecs === undefined ? true : this.props.ec2ecs;
        if (watchApiGateway && node instanceof apigw.RestApi) {
            this.watchful.watchApiGateway(node.node.path, node);
        }
        if (watchDynamo && node instanceof dynamodb.Table) {
            this.watchful.watchDynamoTable(node.node.path, node);
        }
        if (watchLambda && node instanceof lambda.Function) {
            this.watchful.watchLambdaFunction(node.node.path, node);
        }
        if (watchRdsAuroraCluster && node instanceof rds.DatabaseCluster) {
            this.watchful.watchRdsAuroraCluster(node.node.path, node);
        }
        if (watchFargateEcs && node instanceof ecs_patterns.ApplicationLoadBalancedFargateService) {
            this.watchful.watchFargateEcs(node.node.path, node.service, node.targetGroup);
        }
        if (watchEc2Ecs && node instanceof ecs_patterns.ApplicationLoadBalancedEc2Service) {
            this.watchful.watchEc2Ecs(node.node.path, node.service, node.targetGroup);
        }
    }
}
exports.WatchfulAspect = WatchfulAspect;
//# sourceMappingURL=data:application/json;base64,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