import * as dynamodb from '@aws-cdk/aws-dynamodb';
import { Construct } from '@aws-cdk/core';
import { IWatchful } from './api';
export interface WatchDynamoTableOptions {
    /**
     * Threshold for read capacity alarm (percentage)
     * @default 80
     */
    readonly readCapacityThresholdPercent?: number;
    /**
     * Threshold for read capacity alarm (percentage)
     * @default 80
     */
    readonly writeCapacityThresholdPercent?: number;
}
export interface WatchDynamoTableProps extends WatchDynamoTableOptions {
    readonly title: string;
    readonly watchful: IWatchful;
    readonly table: dynamodb.Table;
}
export declare class WatchDynamoTable extends Construct {
    private readonly watchful;
    constructor(scope: Construct, id: string, props: WatchDynamoTableProps);
    private createDynamoCapacityGraph;
    private createDynamoCapacityAlarm;
}
