import * as rds from '@aws-cdk/aws-rds';
import * as cdk from '@aws-cdk/core';
import { IWatchful } from './api';
export interface WatchRdsAuroraOptions {
    /**
       * Threshold for the Cpu Maximum utilization
       *
       * @default 80
       */
    readonly cpuMaximumThresholdPercent?: number;
    /**
     * Threshold for the Maximum Db Connections.
     *
     * @default - 0.
     */
    readonly dbConnectionsMaximumThreshold?: number;
    /**
     * Threshold for the Maximum Db ReplicaLag.
     *
     * @default - 0.
     */
    readonly dbReplicaLagMaximumThreshold?: number;
    /**
     * Threshold for the Maximum Db Throughput.
     *
     * @default - 0.
     */
    readonly dbThroughputMaximumThreshold?: number;
    /**
     * Threshold for the Minimum Db Buffer Cache.
     *
     * @default - 0.
     */
    readonly dbBufferCacheMinimumThreshold?: number;
}
export interface WatchRdsAuroraProps extends WatchRdsAuroraOptions {
    readonly title: string;
    readonly watchful: IWatchful;
    readonly cluster: rds.DatabaseCluster;
}
export declare class WatchRdsAurora extends cdk.Construct {
    private readonly watchful;
    private readonly cluster;
    constructor(scope: cdk.Construct, id: string, props: WatchRdsAuroraProps);
    private createCpuUtilizationMonitor;
    private createDbConnectionsMonitor;
    private createDbReplicaLagMonitor;
    private createDbBufferCacheMonitor;
    private createDbDmlThroughputMonitor;
}
