import * as apigw from '@aws-cdk/aws-apigateway';
import * as cloudwatch from '@aws-cdk/aws-cloudwatch';
import * as dynamodb from '@aws-cdk/aws-dynamodb';
import * as ecs from '@aws-cdk/aws-ecs';
import { ApplicationTargetGroup } from '@aws-cdk/aws-elasticloadbalancingv2';
import * as lambda from '@aws-cdk/aws-lambda';
import * as rds from '@aws-cdk/aws-rds';
import * as sns from '@aws-cdk/aws-sns';
import * as sqs from '@aws-cdk/aws-sqs';
import { Construct } from '@aws-cdk/core';
import { IWatchful, SectionOptions } from './api';
import { WatchApiGatewayOptions, WatchApiGateway } from './api-gateway';
import { WatchfulAspectProps } from './aspect';
import { WatchDynamoTableOptions, WatchDynamoTable } from './dynamodb';
import { WatchEcsServiceOptions, WatchEcsService } from './ecs';
import { WatchLambdaFunctionOptions, WatchLambdaFunction } from './lambda';
import { WatchRdsAuroraOptions, WatchRdsAurora } from './rds-aurora';
export interface WatchfulProps {
    readonly alarmEmail?: string;
    readonly alarmSqs?: sqs.IQueue;
    readonly alarmSns?: sns.ITopic;
}
export declare class Watchful extends Construct implements IWatchful {
    private readonly dash;
    private readonly alarmTopic?;
    constructor(scope: Construct, id: string, props?: WatchfulProps);
    addWidgets(...widgets: cloudwatch.IWidget[]): void;
    addAlarm(alarm: cloudwatch.Alarm): void;
    addSection(title: string, options?: SectionOptions): void;
    watchScope(scope: Construct, options?: WatchfulAspectProps): void;
    watchDynamoTable(title: string, table: dynamodb.Table, options?: WatchDynamoTableOptions): WatchDynamoTable;
    watchApiGateway(title: string, restApi: apigw.RestApi, options?: WatchApiGatewayOptions): WatchApiGateway;
    watchLambdaFunction(title: string, fn: lambda.Function, options?: WatchLambdaFunctionOptions): WatchLambdaFunction;
    watchRdsAuroraCluster(title: string, cluster: rds.DatabaseCluster, options?: WatchRdsAuroraOptions): WatchRdsAurora;
    watchFargateEcs(title: string, fargateService: ecs.FargateService, targetGroup: ApplicationTargetGroup, options?: WatchEcsServiceOptions): WatchEcsService;
    watchEc2Ecs(title: string, ec2Service: ecs.Ec2Service, targetGroup: ApplicationTargetGroup, options?: WatchEcsServiceOptions): WatchEcsService;
}
