We welcome contributions to the ada-verona package! If you find a bug, have a feature request, or want to contribute code, please follow these steps:

- Create an Issue: Before starting work on a new feature or bug, please create an issue in the GitHub repository to discuss your plans. This helps us coordinate contributions and avoid duplicate work.

- Fork the Repository: Create a personal copy of the repository on GitHub.

- Create a Branch: Create a new branch for your feature or bug fix.

- Make Changes: Implement your changes in the codebase.

- **Test Your Changes**: Ensure that your changes do not break existing functionality and that new features work as intended and if necessary add additional unittests.
  
- **Perform Full Pipeline Integration Tests**: Eventhough we will review your PR we do assume you to have performed extensive tests of the workings of your code.
  
- **Quality**: We are holding ourself to a high standard to ensure this code is sustainable and available to a large group without hassle, hold yourself to this too. 

- Commit Your Changes: Write clear and concise commit messages describing your changes.

- Push to Your Fork: Push your changes to your forked repository.

- Create a Pull Request: Open a pull request against the main repository, describing your changes and why they are needed.
  
- **Submitting your PR**: When your pull request is ready add the following details to the description:
    1. What is the purpose of the PR and what issue is addressed.
    2. What exactly was changed in this PR. 
    3. How did you test the changes.

- Review Process: Your pull request will be reviewed by at least one of the maintainers. They may request changes or provide feedback.

