"""
    GAMS Engine

    With GAMS Engine you can register and solve GAMS models. It has a namespace management system, so you can restrict your users to certain models.  # noqa: E501

    The version of the OpenAPI document: latest
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from gams.engine.api_client import ApiClient, Endpoint as _Endpoint
from gams.engine.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from gams.engine.model.bad_input import BadInput
from gams.engine.model.forwarded_token_response import ForwardedTokenResponse
from gams.engine.model.identity_provider import IdentityProvider
from gams.engine.model.identity_provider_ldap import IdentityProviderLdap
from gams.engine.model.identity_provider_oauth2_with_secret import IdentityProviderOauth2WithSecret
from gams.engine.model.identity_provider_oidc_with_secret import IdentityProviderOidcWithSecret
from gams.engine.model.message import Message
from gams.engine.model.model_auth_token import ModelAuthToken
from gams.engine.model.not_found import NotFound
from gams.engine.model.token_forward_error import TokenForwardError


class AuthApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_jwt_token_endpoint = _Endpoint(
            settings={
                'response_type': (ModelAuthToken,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/auth/',
                'operation_id': 'create_jwt_token',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'expires_in',
                    'scope',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'expires_in',
                ]
            },
            root_map={
                'validations': {
                    ('expires_in',): {

                        'inclusive_maximum': 16070400,
                        'inclusive_minimum': 60,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'expires_in':
                        (int,),
                    'scope':
                        (str,),
                },
                'attribute_map': {
                    'expires_in': 'expires_in',
                    'scope': 'scope',
                },
                'location_map': {
                    'expires_in': 'form',
                    'scope': 'form',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.create_jwt_token_json_endpoint = _Endpoint(
            settings={
                'response_type': (ModelAuthToken,),
                'auth': [],
                'endpoint_path': '/auth/login',
                'operation_id': 'create_jwt_token_json',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'username',
                    'password',
                    'grant_type',
                    'scope',
                    'expires_in',
                    'access_scopes',
                ],
                'required': [
                    'username',
                    'password',
                ],
                'nullable': [
                ],
                'enum': [
                    'grant_type',
                    'access_scopes',
                ],
                'validation': [
                    'expires_in',
                ]
            },
            root_map={
                'validations': {
                    ('expires_in',): {

                        'inclusive_maximum': 16070400,
                        'inclusive_minimum': 60,
                    },
                },
                'allowed_values': {
                    ('grant_type',): {

                        "PASSWORD": "password"
                    },
                    ('access_scopes',): {

                    },
                },
                'openapi_types': {
                    'username':
                        (str,),
                    'password':
                        (str,),
                    'grant_type':
                        (str,),
                    'scope':
                        (str,),
                    'expires_in':
                        (int,),
                    'access_scopes':
                        ([str],),
                },
                'attribute_map': {
                    'username': 'username',
                    'password': 'password',
                    'grant_type': 'grant_type',
                    'scope': 'scope',
                    'expires_in': 'expires_in',
                    'access_scopes': 'access_scopes',
                },
                'location_map': {
                    'username': 'form',
                    'password': 'form',
                    'grant_type': 'form',
                    'scope': 'form',
                    'expires_in': 'form',
                    'access_scopes': 'form',
                },
                'collection_format_map': {
                    'access_scopes': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.create_ldap_identity_provider_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/auth/ldap-providers',
                'operation_id': 'create_ldap_identity_provider',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                    'label',
                    'hidden',
                    'host',
                    'port',
                    'uid',
                    'encryption',
                    'base',
                    'user_filter',
                    'bind_dn',
                    'password',
                    'verify_certificates',
                    'active_directory',
                ],
                'required': [
                    'name',
                    'label',
                    'hidden',
                    'host',
                    'port',
                    'uid',
                    'encryption',
                    'base',
                    'user_filter',
                ],
                'nullable': [
                ],
                'enum': [
                    'encryption',
                ],
                'validation': [
                    'name',
                    'label',
                    'host',
                    'port',
                    'uid',
                    'base',
                    'user_filter',
                    'bind_dn',
                    'password',
                ]
            },
            root_map={
                'validations': {
                    ('name',): {

                        'regex': {
                            'pattern': r'^[w-]{3,32}$/',  # noqa: E501
                        },
                    },
                    ('label',): {

                        'regex': {
                            'pattern': r'^[w\-][\w\- ]{1,30}[\w\-]$/',  # noqa: E501
                        },
                    },
                    ('host',): {
                        'max_length': 255,
                        'min_length': 1,
                    },
                    ('port',): {

                        'inclusive_maximum': 65535,
                        'inclusive_minimum': 1,
                    },
                    ('uid',): {
                        'max_length': 255,
                        'min_length': 1,
                    },
                    ('base',): {
                        'max_length': 255,
                        'min_length': 1,
                    },
                    ('user_filter',): {
                        'max_length': 255,
                        'min_length': 1,
                    },
                    ('bind_dn',): {
                        'max_length': 255,
                        'min_length': 1,
                    },
                    ('password',): {
                        'max_length': 255,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('encryption',): {

                        "START_TLS": "start_tls",
                        "SIMPLE_TLS": "simple_tls",
                        "PLAIN": "plain"
                    },
                },
                'openapi_types': {
                    'name':
                        (str,),
                    'label':
                        (str,),
                    'hidden':
                        (bool,),
                    'host':
                        (str,),
                    'port':
                        (int,),
                    'uid':
                        (str,),
                    'encryption':
                        (str,),
                    'base':
                        (str,),
                    'user_filter':
                        (str,),
                    'bind_dn':
                        (str,),
                    'password':
                        (str,),
                    'verify_certificates':
                        (bool,),
                    'active_directory':
                        (bool,),
                },
                'attribute_map': {
                    'name': 'name',
                    'label': 'label',
                    'hidden': 'hidden',
                    'host': 'host',
                    'port': 'port',
                    'uid': 'uid',
                    'encryption': 'encryption',
                    'base': 'base',
                    'user_filter': 'user_filter',
                    'bind_dn': 'bind_dn',
                    'password': 'password',
                    'verify_certificates': 'verify_certificates',
                    'active_directory': 'active_directory',
                },
                'location_map': {
                    'name': 'form',
                    'label': 'form',
                    'hidden': 'form',
                    'host': 'form',
                    'port': 'form',
                    'uid': 'form',
                    'encryption': 'form',
                    'base': 'form',
                    'user_filter': 'form',
                    'bind_dn': 'form',
                    'password': 'form',
                    'verify_certificates': 'form',
                    'active_directory': 'form',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.create_o_auth2_identity_provider_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/auth/oauth2-providers',
                'operation_id': 'create_o_auth2_identity_provider',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                    'label',
                    'hidden',
                    'web_ui_client_id',
                    'issuer',
                    'web_ui_client_secret',
                    'device_client_id',
                    'override_audience',
                    'use_oidc_discover',
                    'use_oauth2_auth_server_metadata',
                    'authorization_endpoint',
                    'token_endpoint',
                    'jwks_uri',
                    'response_types_supported',
                    'grant_types_supported',
                    'end_session_endpoint',
                    'device_authorization_endpoint',
                    'request_scope_readonly',
                    'request_scope_namespaces',
                    'request_scope_jobs',
                    'request_scope_users',
                    'request_scope_hypercube',
                    'request_scope_cleanup',
                    'request_scope_licenses',
                    'request_scope_usage',
                    'request_scope_auth',
                    'request_scope_configuration',
                ],
                'required': [
                    'name',
                    'label',
                    'hidden',
                    'web_ui_client_id',
                    'issuer',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'name',
                    'label',
                    'web_ui_client_id',
                    'web_ui_client_secret',
                    'device_client_id',
                    'override_audience',
                    'response_types_supported',
                    'grant_types_supported',
                    'request_scope_readonly',
                    'request_scope_namespaces',
                    'request_scope_jobs',
                    'request_scope_users',
                    'request_scope_hypercube',
                    'request_scope_cleanup',
                    'request_scope_licenses',
                    'request_scope_usage',
                    'request_scope_auth',
                    'request_scope_configuration',
                ]
            },
            root_map={
                'validations': {
                    ('name',): {

                        'regex': {
                            'pattern': r'^[w-]{3,32}$/',  # noqa: E501
                        },
                    },
                    ('label',): {

                        'regex': {
                            'pattern': r'^[w\-][\w\- ]{1,30}[\w\-]$/',  # noqa: E501
                        },
                    },
                    ('web_ui_client_id',): {
                        'max_length': 255,
                        'min_length': 1,
                    },
                    ('web_ui_client_secret',): {
                        'max_length': 128,
                        'min_length': 1,
                    },
                    ('device_client_id',): {
                        'max_length': 255,
                        'min_length': 1,
                    },
                    ('override_audience',): {
                        'max_length': 255,
                        'min_length': 1,
                    },
                    ('response_types_supported',): {

                    },
                    ('grant_types_supported',): {

                    },
                    ('request_scope_readonly',): {
                        'max_length': 255,
                        'min_length': 1,
                    },
                    ('request_scope_namespaces',): {
                        'max_length': 255,
                        'min_length': 1,
                    },
                    ('request_scope_jobs',): {
                        'max_length': 255,
                        'min_length': 1,
                    },
                    ('request_scope_users',): {
                        'max_length': 255,
                        'min_length': 1,
                    },
                    ('request_scope_hypercube',): {
                        'max_length': 255,
                        'min_length': 1,
                    },
                    ('request_scope_cleanup',): {
                        'max_length': 255,
                        'min_length': 1,
                    },
                    ('request_scope_licenses',): {
                        'max_length': 255,
                        'min_length': 1,
                    },
                    ('request_scope_usage',): {
                        'max_length': 255,
                        'min_length': 1,
                    },
                    ('request_scope_auth',): {
                        'max_length': 255,
                        'min_length': 1,
                    },
                    ('request_scope_configuration',): {
                        'max_length': 255,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name':
                        (str,),
                    'label':
                        (str,),
                    'hidden':
                        (bool,),
                    'web_ui_client_id':
                        (str,),
                    'issuer':
                        (str,),
                    'web_ui_client_secret':
                        (str,),
                    'device_client_id':
                        (str,),
                    'override_audience':
                        (str,),
                    'use_oidc_discover':
                        (bool,),
                    'use_oauth2_auth_server_metadata':
                        (bool,),
                    'authorization_endpoint':
                        (str,),
                    'token_endpoint':
                        (str,),
                    'jwks_uri':
                        (str,),
                    'response_types_supported':
                        ([str],),
                    'grant_types_supported':
                        ([str],),
                    'end_session_endpoint':
                        (str,),
                    'device_authorization_endpoint':
                        (str,),
                    'request_scope_readonly':
                        (str,),
                    'request_scope_namespaces':
                        (str,),
                    'request_scope_jobs':
                        (str,),
                    'request_scope_users':
                        (str,),
                    'request_scope_hypercube':
                        (str,),
                    'request_scope_cleanup':
                        (str,),
                    'request_scope_licenses':
                        (str,),
                    'request_scope_usage':
                        (str,),
                    'request_scope_auth':
                        (str,),
                    'request_scope_configuration':
                        (str,),
                },
                'attribute_map': {
                    'name': 'name',
                    'label': 'label',
                    'hidden': 'hidden',
                    'web_ui_client_id': 'web_ui_client_id',
                    'issuer': 'issuer',
                    'web_ui_client_secret': 'web_ui_client_secret',
                    'device_client_id': 'device_client_id',
                    'override_audience': 'override_audience',
                    'use_oidc_discover': 'use_oidc_discover',
                    'use_oauth2_auth_server_metadata': 'use_oauth2_auth_server_metadata',
                    'authorization_endpoint': 'authorization_endpoint',
                    'token_endpoint': 'token_endpoint',
                    'jwks_uri': 'jwks_uri',
                    'response_types_supported': 'response_types_supported',
                    'grant_types_supported': 'grant_types_supported',
                    'end_session_endpoint': 'end_session_endpoint',
                    'device_authorization_endpoint': 'device_authorization_endpoint',
                    'request_scope_readonly': 'request_scope_READONLY',
                    'request_scope_namespaces': 'request_scope_NAMESPACES',
                    'request_scope_jobs': 'request_scope_JOBS',
                    'request_scope_users': 'request_scope_USERS',
                    'request_scope_hypercube': 'request_scope_HYPERCUBE',
                    'request_scope_cleanup': 'request_scope_CLEANUP',
                    'request_scope_licenses': 'request_scope_LICENSES',
                    'request_scope_usage': 'request_scope_USAGE',
                    'request_scope_auth': 'request_scope_AUTH',
                    'request_scope_configuration': 'request_scope_CONFIGURATION',
                },
                'location_map': {
                    'name': 'form',
                    'label': 'form',
                    'hidden': 'form',
                    'web_ui_client_id': 'form',
                    'issuer': 'form',
                    'web_ui_client_secret': 'form',
                    'device_client_id': 'form',
                    'override_audience': 'form',
                    'use_oidc_discover': 'form',
                    'use_oauth2_auth_server_metadata': 'form',
                    'authorization_endpoint': 'form',
                    'token_endpoint': 'form',
                    'jwks_uri': 'form',
                    'response_types_supported': 'form',
                    'grant_types_supported': 'form',
                    'end_session_endpoint': 'form',
                    'device_authorization_endpoint': 'form',
                    'request_scope_readonly': 'form',
                    'request_scope_namespaces': 'form',
                    'request_scope_jobs': 'form',
                    'request_scope_users': 'form',
                    'request_scope_hypercube': 'form',
                    'request_scope_cleanup': 'form',
                    'request_scope_licenses': 'form',
                    'request_scope_usage': 'form',
                    'request_scope_auth': 'form',
                    'request_scope_configuration': 'form',
                },
                'collection_format_map': {
                    'response_types_supported': 'csv',
                    'grant_types_supported': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.create_oidc_identity_provider_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/auth/oidc-providers',
                'operation_id': 'create_oidc_identity_provider',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                    'label',
                    'hidden',
                    'web_ui_client_id',
                    'issuer',
                    'scopes',
                    'web_ui_client_secret',
                    'device_client_id',
                    'device_client_secret',
                    'extra_client_ids',
                    'use_oidc_discover',
                    'authorization_endpoint',
                    'token_endpoint',
                    'jwks_uri',
                    'end_session_endpoint',
                    'device_authorization_endpoint',
                ],
                'required': [
                    'name',
                    'label',
                    'hidden',
                    'web_ui_client_id',
                    'issuer',
                    'scopes',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'name',
                    'label',
                    'web_ui_client_id',
                    'scopes',
                    'web_ui_client_secret',
                    'device_client_id',
                    'device_client_secret',
                    'extra_client_ids',
                ]
            },
            root_map={
                'validations': {
                    ('name',): {

                        'regex': {
                            'pattern': r'^[w-]{3,32}$/',  # noqa: E501
                        },
                    },
                    ('label',): {

                        'regex': {
                            'pattern': r'^[w\-][\w\- ]{1,30}[\w\-]$/',  # noqa: E501
                        },
                    },
                    ('web_ui_client_id',): {
                        'max_length': 255,
                        'min_length': 1,
                    },
                    ('scopes',): {

                    },
                    ('web_ui_client_secret',): {
                        'max_length': 128,
                        'min_length': 1,
                    },
                    ('device_client_id',): {
                        'max_length': 255,
                        'min_length': 1,
                    },
                    ('device_client_secret',): {
                        'max_length': 128,
                        'min_length': 1,
                    },
                    ('extra_client_ids',): {

                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name':
                        (str,),
                    'label':
                        (str,),
                    'hidden':
                        (bool,),
                    'web_ui_client_id':
                        (str,),
                    'issuer':
                        (str,),
                    'scopes':
                        ([str],),
                    'web_ui_client_secret':
                        (str,),
                    'device_client_id':
                        (str,),
                    'device_client_secret':
                        (str,),
                    'extra_client_ids':
                        ([str],),
                    'use_oidc_discover':
                        (bool,),
                    'authorization_endpoint':
                        (str,),
                    'token_endpoint':
                        (str,),
                    'jwks_uri':
                        (str,),
                    'end_session_endpoint':
                        (str,),
                    'device_authorization_endpoint':
                        (str,),
                },
                'attribute_map': {
                    'name': 'name',
                    'label': 'label',
                    'hidden': 'hidden',
                    'web_ui_client_id': 'web_ui_client_id',
                    'issuer': 'issuer',
                    'scopes': 'scopes',
                    'web_ui_client_secret': 'web_ui_client_secret',
                    'device_client_id': 'device_client_id',
                    'device_client_secret': 'device_client_secret',
                    'extra_client_ids': 'extra_client_ids',
                    'use_oidc_discover': 'use_oidc_discover',
                    'authorization_endpoint': 'authorization_endpoint',
                    'token_endpoint': 'token_endpoint',
                    'jwks_uri': 'jwks_uri',
                    'end_session_endpoint': 'end_session_endpoint',
                    'device_authorization_endpoint': 'device_authorization_endpoint',
                },
                'location_map': {
                    'name': 'form',
                    'label': 'form',
                    'hidden': 'form',
                    'web_ui_client_id': 'form',
                    'issuer': 'form',
                    'scopes': 'form',
                    'web_ui_client_secret': 'form',
                    'device_client_id': 'form',
                    'device_client_secret': 'form',
                    'extra_client_ids': 'form',
                    'use_oidc_discover': 'form',
                    'authorization_endpoint': 'form',
                    'token_endpoint': 'form',
                    'jwks_uri': 'form',
                    'end_session_endpoint': 'form',
                    'device_authorization_endpoint': 'form',
                },
                'collection_format_map': {
                    'scopes': 'csv',
                    'extra_client_ids': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.delete_identity_provider_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/auth/providers',
                'operation_id': 'delete_identity_provider',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                ],
                'required': [
                    'name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'name',
                ]
            },
            root_map={
                'validations': {
                    ('name',): {

                        'regex': {
                            'pattern': r'^[w-]{3,32}$/',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name':
                        (str,),
                },
                'attribute_map': {
                    'name': 'name',
                },
                'location_map': {
                    'name': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_o_auth2_token_on_behalf_endpoint = _Endpoint(
            settings={
                'response_type': (ForwardedTokenResponse,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/auth/oauth2-token',
                'operation_id': 'fetch_o_auth2_token_on_behalf',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'identity_provider_name',
                    'grant_type',
                    'code',
                    'code_verifier',
                    'redirect_uri',
                    'device_code',
                ],
                'required': [
                    'identity_provider_name',
                ],
                'nullable': [
                ],
                'enum': [
                    'grant_type',
                ],
                'validation': [
                    'identity_provider_name',
                    'code',
                    'code_verifier',
                    'device_code',
                ]
            },
            root_map={
                'validations': {
                    ('identity_provider_name',): {

                        'regex': {
                            'pattern': r'^[w-]{3,32}$/',  # noqa: E501
                        },
                    },
                    ('code',): {
                        'max_length': 512,
                        'min_length': 1,
                    },
                    ('code_verifier',): {
                        'max_length': 128,
                        'min_length': 43,
                    },
                    ('device_code',): {
                        'max_length': 512,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('grant_type',): {

                        "AUTHORIZATION_CODE": "authorization_code",
                        "URN:IETF:PARAMS:OAUTH:GRANT-TYPE:DEVICE_CODE": "urn:ietf:params:oauth:grant-type:device_code"
                    },
                },
                'openapi_types': {
                    'identity_provider_name':
                        (str,),
                    'grant_type':
                        (str,),
                    'code':
                        (str,),
                    'code_verifier':
                        (str,),
                    'redirect_uri':
                        (str,),
                    'device_code':
                        (str,),
                },
                'attribute_map': {
                    'identity_provider_name': 'identity_provider_name',
                    'grant_type': 'grant_type',
                    'code': 'code',
                    'code_verifier': 'code_verifier',
                    'redirect_uri': 'redirect_uri',
                    'device_code': 'device_code',
                },
                'location_map': {
                    'identity_provider_name': 'form',
                    'grant_type': 'query',
                    'code': 'form',
                    'code_verifier': 'form',
                    'redirect_uri': 'form',
                    'device_code': 'form',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.invalidate_jwt_tokens_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/auth/logout',
                'operation_id': 'invalidate_jwt_tokens',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_all_identity_providers_endpoint = _Endpoint(
            settings={
                'response_type': ([IdentityProvider],),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/auth/providers/all',
                'operation_id': 'list_all_identity_providers',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_identity_providers_endpoint = _Endpoint(
            settings={
                'response_type': ([IdentityProvider],),
                'auth': [],
                'endpoint_path': '/auth/providers',
                'operation_id': 'list_identity_providers',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name':
                        (str,),
                },
                'attribute_map': {
                    'name': 'name',
                },
                'location_map': {
                    'name': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_ldap_identity_providers_endpoint = _Endpoint(
            settings={
                'response_type': (IdentityProviderLdap,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/auth/ldap-providers',
                'operation_id': 'list_ldap_identity_providers',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                    'x_fields',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name':
                        (str,),
                    'x_fields':
                        (str,),
                },
                'attribute_map': {
                    'name': 'name',
                    'x_fields': 'X-Fields',
                },
                'location_map': {
                    'name': 'query',
                    'x_fields': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_o_auth2_identity_providers_endpoint = _Endpoint(
            settings={
                'response_type': ([IdentityProviderOauth2WithSecret],),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/auth/oauth2-providers',
                'operation_id': 'list_o_auth2_identity_providers',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                    'x_fields',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name':
                        (str,),
                    'x_fields':
                        (str,),
                },
                'attribute_map': {
                    'name': 'name',
                    'x_fields': 'X-Fields',
                },
                'location_map': {
                    'name': 'query',
                    'x_fields': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_oidc_identity_providers_endpoint = _Endpoint(
            settings={
                'response_type': ([IdentityProviderOidcWithSecret],),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/auth/oidc-providers',
                'operation_id': 'list_oidc_identity_providers',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                    'x_fields',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name':
                        (str,),
                    'x_fields':
                        (str,),
                },
                'attribute_map': {
                    'name': 'name',
                    'x_fields': 'X-Fields',
                },
                'location_map': {
                    'name': 'query',
                    'x_fields': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.login_with_ldap_endpoint = _Endpoint(
            settings={
                'response_type': (ModelAuthToken,),
                'auth': [],
                'endpoint_path': '/auth/ldap-providers/{provider_name}/login',
                'operation_id': 'login_with_ldap',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'provider_name',
                    'username',
                    'password',
                    'grant_type',
                    'scope',
                    'expires_in',
                    'access_scopes',
                ],
                'required': [
                    'provider_name',
                    'username',
                    'password',
                ],
                'nullable': [
                ],
                'enum': [
                    'grant_type',
                    'access_scopes',
                ],
                'validation': [
                    'expires_in',
                ]
            },
            root_map={
                'validations': {
                    ('expires_in',): {

                        'inclusive_maximum': 16070400,
                        'inclusive_minimum': 60,
                    },
                },
                'allowed_values': {
                    ('grant_type',): {

                        "PASSWORD": "password"
                    },
                    ('access_scopes',): {

                    },
                },
                'openapi_types': {
                    'provider_name':
                        (str,),
                    'username':
                        (str,),
                    'password':
                        (str,),
                    'grant_type':
                        (str,),
                    'scope':
                        (str,),
                    'expires_in':
                        (int,),
                    'access_scopes':
                        ([str],),
                },
                'attribute_map': {
                    'provider_name': 'provider_name',
                    'username': 'username',
                    'password': 'password',
                    'grant_type': 'grant_type',
                    'scope': 'scope',
                    'expires_in': 'expires_in',
                    'access_scopes': 'access_scopes',
                },
                'location_map': {
                    'provider_name': 'path',
                    'username': 'form',
                    'password': 'form',
                    'grant_type': 'form',
                    'scope': 'form',
                    'expires_in': 'form',
                    'access_scopes': 'form',
                },
                'collection_format_map': {
                    'access_scopes': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.login_with_oidc_endpoint = _Endpoint(
            settings={
                'response_type': (ModelAuthToken,),
                'auth': [],
                'endpoint_path': '/auth/oidc-providers/login',
                'operation_id': 'login_with_oidc',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'id_token',
                    'scope',
                    'expires_in',
                ],
                'required': [
                    'id_token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id_token',
                    'expires_in',
                ]
            },
            root_map={
                'validations': {
                    ('id_token',): {
                        'max_length': 2048,
                        'min_length': 80,
                    },
                    ('expires_in',): {

                        'inclusive_maximum': 16070400,
                        'inclusive_minimum': 60,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id_token':
                        (str,),
                    'scope':
                        (str,),
                    'expires_in':
                        (int,),
                },
                'attribute_map': {
                    'id_token': 'id_token',
                    'scope': 'scope',
                    'expires_in': 'expires_in',
                },
                'location_map': {
                    'id_token': 'form',
                    'scope': 'form',
                    'expires_in': 'form',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.update_ldap_identity_provider_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/auth/ldap-providers',
                'operation_id': 'update_ldap_identity_provider',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                    'label',
                    'hidden',
                    'host',
                    'port',
                    'uid',
                    'encryption',
                    'base',
                    'user_filter',
                    'bind_dn',
                    'password',
                    'verify_certificates',
                    'active_directory',
                ],
                'required': [
                    'name',
                    'label',
                    'hidden',
                    'host',
                    'port',
                    'uid',
                    'encryption',
                    'base',
                    'user_filter',
                ],
                'nullable': [
                ],
                'enum': [
                    'encryption',
                ],
                'validation': [
                    'name',
                    'label',
                    'host',
                    'port',
                    'uid',
                    'base',
                    'user_filter',
                    'bind_dn',
                    'password',
                ]
            },
            root_map={
                'validations': {
                    ('name',): {

                        'regex': {
                            'pattern': r'^[w-]{3,32}$/',  # noqa: E501
                        },
                    },
                    ('label',): {

                        'regex': {
                            'pattern': r'^[w\-][\w\- ]{1,30}[\w\-]$/',  # noqa: E501
                        },
                    },
                    ('host',): {
                        'max_length': 255,
                        'min_length': 1,
                    },
                    ('port',): {

                        'inclusive_maximum': 65535,
                        'inclusive_minimum': 1,
                    },
                    ('uid',): {
                        'max_length': 255,
                        'min_length': 1,
                    },
                    ('base',): {
                        'max_length': 255,
                        'min_length': 1,
                    },
                    ('user_filter',): {
                        'max_length': 255,
                        'min_length': 1,
                    },
                    ('bind_dn',): {
                        'max_length': 255,
                        'min_length': 1,
                    },
                    ('password',): {
                        'max_length': 255,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('encryption',): {

                        "START_TLS": "start_tls",
                        "SIMPLE_TLS": "simple_tls",
                        "PLAIN": "plain"
                    },
                },
                'openapi_types': {
                    'name':
                        (str,),
                    'label':
                        (str,),
                    'hidden':
                        (bool,),
                    'host':
                        (str,),
                    'port':
                        (int,),
                    'uid':
                        (str,),
                    'encryption':
                        (str,),
                    'base':
                        (str,),
                    'user_filter':
                        (str,),
                    'bind_dn':
                        (str,),
                    'password':
                        (str,),
                    'verify_certificates':
                        (bool,),
                    'active_directory':
                        (bool,),
                },
                'attribute_map': {
                    'name': 'name',
                    'label': 'label',
                    'hidden': 'hidden',
                    'host': 'host',
                    'port': 'port',
                    'uid': 'uid',
                    'encryption': 'encryption',
                    'base': 'base',
                    'user_filter': 'user_filter',
                    'bind_dn': 'bind_dn',
                    'password': 'password',
                    'verify_certificates': 'verify_certificates',
                    'active_directory': 'active_directory',
                },
                'location_map': {
                    'name': 'form',
                    'label': 'form',
                    'hidden': 'form',
                    'host': 'form',
                    'port': 'form',
                    'uid': 'form',
                    'encryption': 'form',
                    'base': 'form',
                    'user_filter': 'form',
                    'bind_dn': 'form',
                    'password': 'form',
                    'verify_certificates': 'form',
                    'active_directory': 'form',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.update_o_auth2_identity_provider_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/auth/oauth2-providers',
                'operation_id': 'update_o_auth2_identity_provider',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                    'label',
                    'hidden',
                    'web_ui_client_id',
                    'issuer',
                    'web_ui_client_secret',
                    'device_client_id',
                    'override_audience',
                    'use_oidc_discover',
                    'use_oauth2_auth_server_metadata',
                    'authorization_endpoint',
                    'token_endpoint',
                    'jwks_uri',
                    'response_types_supported',
                    'grant_types_supported',
                    'end_session_endpoint',
                    'device_authorization_endpoint',
                    'request_scope_readonly',
                    'request_scope_namespaces',
                    'request_scope_jobs',
                    'request_scope_users',
                    'request_scope_hypercube',
                    'request_scope_cleanup',
                    'request_scope_licenses',
                    'request_scope_usage',
                    'request_scope_auth',
                    'request_scope_configuration',
                ],
                'required': [
                    'name',
                    'label',
                    'hidden',
                    'web_ui_client_id',
                    'issuer',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'name',
                    'label',
                    'web_ui_client_id',
                    'web_ui_client_secret',
                    'device_client_id',
                    'override_audience',
                    'response_types_supported',
                    'grant_types_supported',
                    'request_scope_readonly',
                    'request_scope_namespaces',
                    'request_scope_jobs',
                    'request_scope_users',
                    'request_scope_hypercube',
                    'request_scope_cleanup',
                    'request_scope_licenses',
                    'request_scope_usage',
                    'request_scope_auth',
                    'request_scope_configuration',
                ]
            },
            root_map={
                'validations': {
                    ('name',): {

                        'regex': {
                            'pattern': r'^[w-]{3,32}$/',  # noqa: E501
                        },
                    },
                    ('label',): {

                        'regex': {
                            'pattern': r'^[w\-][\w\- ]{1,30}[\w\-]$/',  # noqa: E501
                        },
                    },
                    ('web_ui_client_id',): {
                        'max_length': 255,
                        'min_length': 1,
                    },
                    ('web_ui_client_secret',): {
                        'max_length': 128,
                        'min_length': 1,
                    },
                    ('device_client_id',): {
                        'max_length': 255,
                        'min_length': 1,
                    },
                    ('override_audience',): {
                        'max_length': 255,
                        'min_length': 1,
                    },
                    ('response_types_supported',): {

                    },
                    ('grant_types_supported',): {

                    },
                    ('request_scope_readonly',): {
                        'max_length': 255,
                        'min_length': 1,
                    },
                    ('request_scope_namespaces',): {
                        'max_length': 255,
                        'min_length': 1,
                    },
                    ('request_scope_jobs',): {
                        'max_length': 255,
                        'min_length': 1,
                    },
                    ('request_scope_users',): {
                        'max_length': 255,
                        'min_length': 1,
                    },
                    ('request_scope_hypercube',): {
                        'max_length': 255,
                        'min_length': 1,
                    },
                    ('request_scope_cleanup',): {
                        'max_length': 255,
                        'min_length': 1,
                    },
                    ('request_scope_licenses',): {
                        'max_length': 255,
                        'min_length': 1,
                    },
                    ('request_scope_usage',): {
                        'max_length': 255,
                        'min_length': 1,
                    },
                    ('request_scope_auth',): {
                        'max_length': 255,
                        'min_length': 1,
                    },
                    ('request_scope_configuration',): {
                        'max_length': 255,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name':
                        (str,),
                    'label':
                        (str,),
                    'hidden':
                        (bool,),
                    'web_ui_client_id':
                        (str,),
                    'issuer':
                        (str,),
                    'web_ui_client_secret':
                        (str,),
                    'device_client_id':
                        (str,),
                    'override_audience':
                        (str,),
                    'use_oidc_discover':
                        (bool,),
                    'use_oauth2_auth_server_metadata':
                        (bool,),
                    'authorization_endpoint':
                        (str,),
                    'token_endpoint':
                        (str,),
                    'jwks_uri':
                        (str,),
                    'response_types_supported':
                        ([str],),
                    'grant_types_supported':
                        ([str],),
                    'end_session_endpoint':
                        (str,),
                    'device_authorization_endpoint':
                        (str,),
                    'request_scope_readonly':
                        (str,),
                    'request_scope_namespaces':
                        (str,),
                    'request_scope_jobs':
                        (str,),
                    'request_scope_users':
                        (str,),
                    'request_scope_hypercube':
                        (str,),
                    'request_scope_cleanup':
                        (str,),
                    'request_scope_licenses':
                        (str,),
                    'request_scope_usage':
                        (str,),
                    'request_scope_auth':
                        (str,),
                    'request_scope_configuration':
                        (str,),
                },
                'attribute_map': {
                    'name': 'name',
                    'label': 'label',
                    'hidden': 'hidden',
                    'web_ui_client_id': 'web_ui_client_id',
                    'issuer': 'issuer',
                    'web_ui_client_secret': 'web_ui_client_secret',
                    'device_client_id': 'device_client_id',
                    'override_audience': 'override_audience',
                    'use_oidc_discover': 'use_oidc_discover',
                    'use_oauth2_auth_server_metadata': 'use_oauth2_auth_server_metadata',
                    'authorization_endpoint': 'authorization_endpoint',
                    'token_endpoint': 'token_endpoint',
                    'jwks_uri': 'jwks_uri',
                    'response_types_supported': 'response_types_supported',
                    'grant_types_supported': 'grant_types_supported',
                    'end_session_endpoint': 'end_session_endpoint',
                    'device_authorization_endpoint': 'device_authorization_endpoint',
                    'request_scope_readonly': 'request_scope_READONLY',
                    'request_scope_namespaces': 'request_scope_NAMESPACES',
                    'request_scope_jobs': 'request_scope_JOBS',
                    'request_scope_users': 'request_scope_USERS',
                    'request_scope_hypercube': 'request_scope_HYPERCUBE',
                    'request_scope_cleanup': 'request_scope_CLEANUP',
                    'request_scope_licenses': 'request_scope_LICENSES',
                    'request_scope_usage': 'request_scope_USAGE',
                    'request_scope_auth': 'request_scope_AUTH',
                    'request_scope_configuration': 'request_scope_CONFIGURATION',
                },
                'location_map': {
                    'name': 'form',
                    'label': 'form',
                    'hidden': 'form',
                    'web_ui_client_id': 'form',
                    'issuer': 'form',
                    'web_ui_client_secret': 'form',
                    'device_client_id': 'form',
                    'override_audience': 'form',
                    'use_oidc_discover': 'form',
                    'use_oauth2_auth_server_metadata': 'form',
                    'authorization_endpoint': 'form',
                    'token_endpoint': 'form',
                    'jwks_uri': 'form',
                    'response_types_supported': 'form',
                    'grant_types_supported': 'form',
                    'end_session_endpoint': 'form',
                    'device_authorization_endpoint': 'form',
                    'request_scope_readonly': 'form',
                    'request_scope_namespaces': 'form',
                    'request_scope_jobs': 'form',
                    'request_scope_users': 'form',
                    'request_scope_hypercube': 'form',
                    'request_scope_cleanup': 'form',
                    'request_scope_licenses': 'form',
                    'request_scope_usage': 'form',
                    'request_scope_auth': 'form',
                    'request_scope_configuration': 'form',
                },
                'collection_format_map': {
                    'response_types_supported': 'csv',
                    'grant_types_supported': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.update_oidc_identity_provider_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/auth/oidc-providers',
                'operation_id': 'update_oidc_identity_provider',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                    'label',
                    'hidden',
                    'web_ui_client_id',
                    'issuer',
                    'scopes',
                    'web_ui_client_secret',
                    'device_client_id',
                    'device_client_secret',
                    'extra_client_ids',
                    'use_oidc_discover',
                    'authorization_endpoint',
                    'token_endpoint',
                    'jwks_uri',
                    'end_session_endpoint',
                    'device_authorization_endpoint',
                ],
                'required': [
                    'name',
                    'label',
                    'hidden',
                    'web_ui_client_id',
                    'issuer',
                    'scopes',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'name',
                    'label',
                    'web_ui_client_id',
                    'scopes',
                    'web_ui_client_secret',
                    'device_client_id',
                    'device_client_secret',
                    'extra_client_ids',
                ]
            },
            root_map={
                'validations': {
                    ('name',): {

                        'regex': {
                            'pattern': r'^[w-]{3,32}$/',  # noqa: E501
                        },
                    },
                    ('label',): {

                        'regex': {
                            'pattern': r'^[w\-][\w\- ]{1,30}[\w\-]$/',  # noqa: E501
                        },
                    },
                    ('web_ui_client_id',): {
                        'max_length': 255,
                        'min_length': 1,
                    },
                    ('scopes',): {

                    },
                    ('web_ui_client_secret',): {
                        'max_length': 128,
                        'min_length': 1,
                    },
                    ('device_client_id',): {
                        'max_length': 255,
                        'min_length': 1,
                    },
                    ('device_client_secret',): {
                        'max_length': 128,
                        'min_length': 1,
                    },
                    ('extra_client_ids',): {

                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name':
                        (str,),
                    'label':
                        (str,),
                    'hidden':
                        (bool,),
                    'web_ui_client_id':
                        (str,),
                    'issuer':
                        (str,),
                    'scopes':
                        ([str],),
                    'web_ui_client_secret':
                        (str,),
                    'device_client_id':
                        (str,),
                    'device_client_secret':
                        (str,),
                    'extra_client_ids':
                        ([str],),
                    'use_oidc_discover':
                        (bool,),
                    'authorization_endpoint':
                        (str,),
                    'token_endpoint':
                        (str,),
                    'jwks_uri':
                        (str,),
                    'end_session_endpoint':
                        (str,),
                    'device_authorization_endpoint':
                        (str,),
                },
                'attribute_map': {
                    'name': 'name',
                    'label': 'label',
                    'hidden': 'hidden',
                    'web_ui_client_id': 'web_ui_client_id',
                    'issuer': 'issuer',
                    'scopes': 'scopes',
                    'web_ui_client_secret': 'web_ui_client_secret',
                    'device_client_id': 'device_client_id',
                    'device_client_secret': 'device_client_secret',
                    'extra_client_ids': 'extra_client_ids',
                    'use_oidc_discover': 'use_oidc_discover',
                    'authorization_endpoint': 'authorization_endpoint',
                    'token_endpoint': 'token_endpoint',
                    'jwks_uri': 'jwks_uri',
                    'end_session_endpoint': 'end_session_endpoint',
                    'device_authorization_endpoint': 'device_authorization_endpoint',
                },
                'location_map': {
                    'name': 'form',
                    'label': 'form',
                    'hidden': 'form',
                    'web_ui_client_id': 'form',
                    'issuer': 'form',
                    'scopes': 'form',
                    'web_ui_client_secret': 'form',
                    'device_client_id': 'form',
                    'device_client_secret': 'form',
                    'extra_client_ids': 'form',
                    'use_oidc_discover': 'form',
                    'authorization_endpoint': 'form',
                    'token_endpoint': 'form',
                    'jwks_uri': 'form',
                    'end_session_endpoint': 'form',
                    'device_authorization_endpoint': 'form',
                },
                'collection_format_map': {
                    'scopes': 'csv',
                    'extra_client_ids': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )

    def create_jwt_token(
        self,
        **kwargs
    ):
        """Creates a JSON Web Token(JWT) for authentication (username and password in request header via Basic auth)  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_jwt_token(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            expires_in (int): Time (in seconds) when the token expires.. [optional] if omitted the server will use the default value of 14400
            scope (str): Access scopes space-separated. Available scopes: READONLY NAMESPACES JOBS USERS HYPERCUBE CLEANUP LICENSES USAGE AUTH CONFIGURATION. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ModelAuthToken
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.create_jwt_token_endpoint.call_with_http_info(**kwargs)

    def create_jwt_token_json(
        self,
        username,
        password,
        **kwargs
    ):
        """Creates a JSON Web Token(JWT) for authentication (username and password in request body)  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_jwt_token_json(username, password, async_req=True)
        >>> result = thread.get()

        Args:
            username (str):
            password (str):

        Keyword Args:
            grant_type (str): [optional] if omitted the server will use the default value of "password"
            scope (str): Access scopes space-separated. Available scopes: READONLY NAMESPACES JOBS USERS HYPERCUBE CLEANUP LICENSES USAGE AUTH CONFIGURATION. [optional]
            expires_in (int): Time (in seconds) when the token expires.. [optional] if omitted the server will use the default value of 14400
            access_scopes ([str]): Deprecated, please use `scope` instead. Access scopes. Possible values: READONLY NAMESPACES JOBS USERS HYPERCUBE CLEANUP LICENSES USAGE AUTH CONFIGURATION. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ModelAuthToken
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['username'] = \
            username
        kwargs['password'] = \
            password
        return self.create_jwt_token_json_endpoint.call_with_http_info(**kwargs)

    def create_ldap_identity_provider(
        self,
        name,
        label,
        hidden,
        host,
        port,
        uid,
        encryption,
        base,
        user_filter,
        **kwargs
    ):
        """Creates an identity provider of type LDAP  # noqa: E501

        Fields are visible through the API after creation only via an admin account. Requires admin role. Timeout value for communication is 10 seconds  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_ldap_identity_provider(name, label, hidden, host, port, uid, encryption, base, user_filter, async_req=True)
        >>> result = thread.get()

        Args:
            name (str): A unique string to identify the identity provider
            label (str): Suggested login tab name
            hidden (bool): Should the identity provider be listed when all identity providers are listed?
            host (str): Host of the LDAP server excluding protocol and port
            port (int): Port of the LDAP server. Examples: 389 and 636(for simple_tls)
            uid (str): The LDAP attribute that is used as username. Examples: \\\"sAMAccountName\\\" for Active Directory, \\\"uid\\\" for OpenLDAP. This will be appended to user_filter with an \\\"&\\\" clause.
            encryption (str): Encryption method
            base (str): DN of the base where users are located. Example for OpenLDAP: \\\"ou=users,dc=example,dc=com\\\"
            user_filter (str): LDAP user filter. Format can be found in RFC4515. Examples:\\\"(objectClass=User)\\\" or \\\"(memberOf=cn=gams-engine,ou=groups,dc=example,dc=com)\\\" or \\\"&((objectClass=User),(employeeType=developer))\\\"

        Keyword Args:
            bind_dn (str): The full DN of the user who is used for binding. Example for OpenLDAP: \\\"uid=admin,ou=users,dc=example,dc=org\\\". Example for Active Directory: \\\"EXAMPLE\\\\\\\\admin\\\". [optional]
            password (str): The password of the user who is used for binding. [optional]
            verify_certificates (bool): [optional] if omitted the server will use the default value of True
            active_directory (bool): Is LDAP server an Active Directory LDAP server. For AD, NTLMv2 authentication is used. [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['name'] = \
            name
        kwargs['label'] = \
            label
        kwargs['hidden'] = \
            hidden
        kwargs['host'] = \
            host
        kwargs['port'] = \
            port
        kwargs['uid'] = \
            uid
        kwargs['encryption'] = \
            encryption
        kwargs['base'] = \
            base
        kwargs['user_filter'] = \
            user_filter
        return self.create_ldap_identity_provider_endpoint.call_with_http_info(**kwargs)

    def create_o_auth2_identity_provider(
        self,
        name,
        label,
        hidden,
        web_ui_client_id,
        issuer,
        **kwargs
    ):
        """Creates an identity provider of type OAuth2  # noqa: E501

        The access token provided by the identity provider must be a valid JWT token. Opaque tokens are not supported. Requires admin role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_o_auth2_identity_provider(name, label, hidden, web_ui_client_id, issuer, async_req=True)
        >>> result = thread.get()

        Args:
            name (str): A unique string to identify the identity provider.
            label (str): Suggested login button string
            hidden (bool): Should the identity provider be listed when identity providers are listed. Client secrets are never displayed whether the identity provider is hidden or not.
            web_ui_client_id (str): OAuth 2.0 client id that should be used by Engine UI while logging in
            issuer (str): URL using the https scheme with no query or fragment component that the OP asserts as its Issuer Identifier.

        Keyword Args:
            web_ui_client_secret (str): OAuth 2.0 client secret that should be used by Engine UI while logging in. We recommend using a public OAuth 2.0 client and not specifying a secret, as Engine UI is a single-page application and cannot store client secrets. However, if this is not possible, you can use a slightly modified version of the Authorization Code Flow and have the API send token requests with the secret on your behalf.. [optional]
            device_client_id (str): OAuth 2.0 client ID, which should be used by clients that do not have browser access. The client must be a public client.. [optional]
            override_audience (str): By default, JWT tokens are expected to have audience claim matching the hostname in the configuration. To change expected audience for this provider, you can provide override_audience. Please try to avoid this. Instead, set the hostname properly in the Engine configuration and in the authorization server.. [optional]
            use_oidc_discover (bool): Should OpenID Connect Discovery be used. Fetches information from issuer URL appended with /.well-known/openid-configuration. [optional] if omitted the server will use the default value of False
            use_oauth2_auth_server_metadata (bool): Should OAuth 2.0 Authorization Server Metadata be used.Fetches information from issuer URL appended with /.well-known/oauth-authorization-server. [optional] if omitted the server will use the default value of False
            authorization_endpoint (str): Required unless discovery is used. URL of the OP's OAuth 2.0 Authorization Endpoint.. [optional]
            token_endpoint (str): URL of the OP's OAuth 2.0 Token Endpoint (ignored if discovery is used).. [optional]
            jwks_uri (str): Required unless discovery is used. URL of the OP's JSON Web Key Set document.. [optional]
            response_types_supported ([str]): Required unless discovery is used. Array containing a list of the OAuth 2.0 response_type values that this OP supports.. [optional]
            grant_types_supported ([str]): Array containing a list of the OAuth 2.0 Grant Type values that this OP supports (ignored if discovery is used).. [optional]
            end_session_endpoint (str): URL at the OP to which an RP can perform a redirect to request that the End-User be logged out at the OP. [optional]
            device_authorization_endpoint (str): URL of the authorization server's device authorization endpoint. [optional]
            request_scope_readonly (str): Scope that the client should request from the OP to get 'READONLY' scope. [optional] if omitted the server will use the default value of "READONLY"
            request_scope_namespaces (str): Scope that the client should request from the OP to get 'NAMESPACES' scope. [optional] if omitted the server will use the default value of "NAMESPACES"
            request_scope_jobs (str): Scope that the client should request from the OP to get 'JOBS' scope. [optional] if omitted the server will use the default value of "JOBS"
            request_scope_users (str): Scope that the client should request from the OP to get 'USERS' scope. [optional] if omitted the server will use the default value of "USERS"
            request_scope_hypercube (str): Scope that the client should request from the OP to get 'HYPERCUBE' scope. [optional] if omitted the server will use the default value of "HYPERCUBE"
            request_scope_cleanup (str): Scope that the client should request from the OP to get 'CLEANUP' scope. [optional] if omitted the server will use the default value of "CLEANUP"
            request_scope_licenses (str): Scope that the client should request from the OP to get 'LICENSES' scope. [optional] if omitted the server will use the default value of "LICENSES"
            request_scope_usage (str): Scope that the client should request from the OP to get 'USAGE' scope. [optional] if omitted the server will use the default value of "USAGE"
            request_scope_auth (str): Scope that the client should request from the OP to get 'AUTH' scope. [optional] if omitted the server will use the default value of "AUTH"
            request_scope_configuration (str): Scope that the client should request from the OP to get 'CONFIGURATION' scope. [optional] if omitted the server will use the default value of "CONFIGURATION"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['name'] = \
            name
        kwargs['label'] = \
            label
        kwargs['hidden'] = \
            hidden
        kwargs['web_ui_client_id'] = \
            web_ui_client_id
        kwargs['issuer'] = \
            issuer
        return self.create_o_auth2_identity_provider_endpoint.call_with_http_info(**kwargs)

    def create_oidc_identity_provider(
        self,
        name,
        label,
        hidden,
        web_ui_client_id,
        issuer,
        scopes,
        **kwargs
    ):
        """Creates an identity provider of type OIDC  # noqa: E501

        The id token provided by the identity provider must be a valid JWT token where the audience matches the web_ui_client_id, the device_client_id or any of the extra_client_ids. Requires admin role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_oidc_identity_provider(name, label, hidden, web_ui_client_id, issuer, scopes, async_req=True)
        >>> result = thread.get()

        Args:
            name (str): A unique string to identify the identity provider.
            label (str): Suggested login button string
            hidden (bool): Should the identity provider be listed when identity providers are listed. Client secrets are never displayed whether the identity provider is hidden or not.
            web_ui_client_id (str): OAuth 2.0 client id that should be used by Engine UI while logging in
            issuer (str): URL using the https scheme with no query or fragment component that the OP asserts as its Issuer Identifier.
            scopes ([str]): The scopes that will be requested from the OP

        Keyword Args:
            web_ui_client_secret (str): OAuth 2.0 client secret that should be used by Engine UI while logging in. We recommend using a public OAuth 2.0 client and not specifying a secret, as Engine UI is a single-page application and cannot store client secrets. However, if this is not possible, you can use a slightly modified version of the Authorization Code Flow and have the API send token requests with the secret on your behalf.. [optional]
            device_client_id (str): OAuth 2.0 client ID, which should be used by clients that do not have browser access.. [optional]
            device_client_secret (str): OAuth 2.0 client secret that should be used by devices while logging in. We recommend using a public OAuth 2.0 client and not specifying a secret.  However, if this is not possible, you can use a slightly modified version of the Device Code Flow and have the API send token requests with the secret on your behalf.. [optional]
            extra_client_ids ([str]): Array of extra OAuth 2.0 client IDs from which the API accepts ID tokens. [optional]
            use_oidc_discover (bool): Should OpenID Connect Discovery be used. Fetches information from issuer URL appended with /.well-known/openid-configuration. [optional] if omitted the server will use the default value of False
            authorization_endpoint (str): Required unless discovery is used. URL of the OP's OAuth 2.0 Authorization Endpoint.. [optional]
            token_endpoint (str): URL of the OP's OAuth 2.0 Token Endpoint (ignored if discovery is used).. [optional]
            jwks_uri (str): Required unless discovery is used. URL of the OP's JSON Web Key Set document.. [optional]
            end_session_endpoint (str): URL at the OP to which an RP can perform a redirect to request that the End-User be logged out at the OP. [optional]
            device_authorization_endpoint (str): URL of the authorization server's device authorization endpoint. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['name'] = \
            name
        kwargs['label'] = \
            label
        kwargs['hidden'] = \
            hidden
        kwargs['web_ui_client_id'] = \
            web_ui_client_id
        kwargs['issuer'] = \
            issuer
        kwargs['scopes'] = \
            scopes
        return self.create_oidc_identity_provider_endpoint.call_with_http_info(**kwargs)

    def delete_identity_provider(
        self,
        name,
        **kwargs
    ):
        """Deletes the identity provider with the specified name  # noqa: E501

        Unused invitations that use this identity provider are considered invalid. Users using this identity provider can no longer sign in, and their identity provider must be updated before they can sign in again. All JWT tokens signed by this identity provider are considered invalid. Requires admin role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_identity_provider(name, async_req=True)
        >>> result = thread.get()

        Args:
            name (str): Unique identifier of the identity provider.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['name'] = \
            name
        return self.delete_identity_provider_endpoint.call_with_http_info(**kwargs)

    def fetch_o_auth2_token_on_behalf(
        self,
        identity_provider_name,
        **kwargs
    ):
        """Sends a request on your behalf to the OAuth provider token endpoint with the client secret  # noqa: E501

        This endpoint is only for \"Authorization Code Flow\" and \"Device Code Flow\" flow. It works only with OAuth 2.0/OIDC providers with a client secret. It is not recommended to use this endpoint if you can register a public client. Token forwarding for Device Code Flow is only allowed for OIDC clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_o_auth2_token_on_behalf(identity_provider_name, async_req=True)
        >>> result = thread.get()

        Args:
            identity_provider_name (str): Unique identifier of the identity provider.

        Keyword Args:
            grant_type (str): Grant type of the forwarded request. [optional] if omitted the server will use the default value of "authorization_code"
            code (str): Code from the OAuth2 Server, required for authorization code flow. [optional]
            code_verifier (str): PKCE code verifier, required for authorization code flow. [optional]
            redirect_uri (str): Redirection URI used when initiating the request, required for authorization code flow. [optional]
            device_code (str): The device verification code, required for device flow. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ForwardedTokenResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['identity_provider_name'] = \
            identity_provider_name
        return self.fetch_o_auth2_token_on_behalf_endpoint.call_with_http_info(**kwargs)

    def invalidate_jwt_tokens(
        self,
        **kwargs
    ):
        """Invalidates all of your JSON Web Tokens(JWTs)  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.invalidate_jwt_tokens(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.invalidate_jwt_tokens_endpoint.call_with_http_info(**kwargs)

    def list_all_identity_providers(
        self,
        **kwargs
    ):
        """Lists the all identity providers supported by Engine  # noqa: E501

        Requires admin role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_all_identity_providers(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [IdentityProvider]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.list_all_identity_providers_endpoint.call_with_http_info(**kwargs)

    def list_identity_providers(
        self,
        **kwargs
    ):
        """Lists the visible identity providers that are supported by Engine  # noqa: E501

        If the name is specified, the identity provider is displayed, regardless of whether it is hidden or not.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_identity_providers(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            name (str): Name of the identity provider to display. If not specified, all visible identity providers are listed. To display a hidden identity provider, its name must be specified. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [IdentityProvider]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.list_identity_providers_endpoint.call_with_http_info(**kwargs)

    def list_ldap_identity_providers(
        self,
        **kwargs
    ):
        """Lists the LDAP providers  # noqa: E501

        Requires admin role. `name` field can be used to display only the desired LDAP provider. By default all fields are listed, you can use `X-Fields` to filter the fields. For example, X-Fields: name, label, host, port  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_ldap_identity_providers(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            name (str): Name of a LDAP provider to show. [optional]
            x_fields (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            IdentityProviderLdap
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.list_ldap_identity_providers_endpoint.call_with_http_info(**kwargs)

    def list_o_auth2_identity_providers(
        self,
        **kwargs
    ):
        """Lists the OAuth2 providers  # noqa: E501

        Requires admin role, as it displays client secrets. `name` field can be used to display only the desired OAuth2 provider. By default all fields are listed, you can use `X-Fields` to filter the fields. For example, X-Fields: name, label, scopes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_o_auth2_identity_providers(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            name (str): Name of a OAuth2 provider to show. [optional]
            x_fields (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [IdentityProviderOauth2WithSecret]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.list_o_auth2_identity_providers_endpoint.call_with_http_info(**kwargs)

    def list_oidc_identity_providers(
        self,
        **kwargs
    ):
        """Lists the OIDC providers  # noqa: E501

        Requires admin role, as it displays client secrets. `name` field can be used to display only the desired OIDC provider. By default all fields are listed, you can use `X-Fields` to filter the fields. For example, X-Fields: name, label, uid  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_oidc_identity_providers(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            name (str): Name of a OIDC provider to show. [optional]
            x_fields (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [IdentityProviderOidcWithSecret]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.list_oidc_identity_providers_endpoint.call_with_http_info(**kwargs)

    def login_with_ldap(
        self,
        provider_name,
        username,
        password,
        **kwargs
    ):
        """Creates a JSON Web Token(JWT) for authentication (username and password in request body)  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.login_with_ldap(provider_name, username, password, async_req=True)
        >>> result = thread.get()

        Args:
            provider_name (str):
            username (str): LDAP Username
            password (str): LDAP Password

        Keyword Args:
            grant_type (str): [optional] if omitted the server will use the default value of "password"
            scope (str): Access scopes space-separated. Available scopes: READONLY NAMESPACES JOBS USERS HYPERCUBE CLEANUP LICENSES USAGE AUTH CONFIGURATION. [optional]
            expires_in (int): Time (in seconds) when the token expires.. [optional] if omitted the server will use the default value of 14400
            access_scopes ([str]): Deprecated, please use `scope` instead. Access scopes. Possible values: READONLY NAMESPACES JOBS USERS HYPERCUBE CLEANUP LICENSES USAGE AUTH CONFIGURATION. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ModelAuthToken
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['provider_name'] = \
            provider_name
        kwargs['username'] = \
            username
        kwargs['password'] = \
            password
        return self.login_with_ldap_endpoint.call_with_http_info(**kwargs)

    def login_with_oidc(
        self,
        id_token,
        **kwargs
    ):
        """Creates a JSON Web Token(JWT) for authentication in exchange for a valid ID token from your OIDC identity provider  # noqa: E501

        An ID token can only be used once to get an access token.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.login_with_oidc(id_token, async_req=True)
        >>> result = thread.get()

        Args:
            id_token (str): ID Token of the user

        Keyword Args:
            scope (str): Access scopes space-separated. Available scopes: READONLY NAMESPACES JOBS USERS HYPERCUBE CLEANUP LICENSES USAGE AUTH CONFIGURATION. [optional]
            expires_in (int): Time (in seconds) when the token expires.. [optional] if omitted the server will use the default value of 14400
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ModelAuthToken
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['id_token'] = \
            id_token
        return self.login_with_oidc_endpoint.call_with_http_info(**kwargs)

    def update_ldap_identity_provider(
        self,
        name,
        label,
        hidden,
        host,
        port,
        uid,
        encryption,
        base,
        user_filter,
        **kwargs
    ):
        """Updates the identity provider of type LDAP with the specified name  # noqa: E501

        Requires admin role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_ldap_identity_provider(name, label, hidden, host, port, uid, encryption, base, user_filter, async_req=True)
        >>> result = thread.get()

        Args:
            name (str): Unique identifier of the identity provider.
            label (str): Suggested login tab name
            hidden (bool): Should the identity provider be listed when all identity providers are listed?
            host (str): Host of the LDAP server excluding protocol and port
            port (int): Port of the LDAP server. Examples: 389 and 636(for simple_tls)
            uid (str): The LDAP attribute that is used as username. Examples: \\\"sAMAccountName\\\" for Active Directory, \\\"uid\\\" for OpenLDAP. This will be appended to user_filter with an \\\"&\\\" clause.
            encryption (str): Encryption method
            base (str): DN of the base where users are located. Example for OpenLDAP: \\\"ou=users,dc=example,dc=com\\\"
            user_filter (str): LDAP user filter. Format can be found in RFC4515. Examples:\\\"(objectClass=User)\\\" or \\\"(memberOf=cn=gams-engine,ou=groups,dc=example,dc=com)\\\" or \\\"&((objectClass=User),(employeeType=developer))\\\"

        Keyword Args:
            bind_dn (str): The full DN of the user who is used for binding. Example for OpenLDAP: \\\"uid=admin,ou=users,dc=example,dc=org\\\". Example for Active Directory: \\\"EXAMPLE\\\\\\\\admin\\\". [optional]
            password (str): The password of the user who is used for binding. [optional]
            verify_certificates (bool): [optional] if omitted the server will use the default value of True
            active_directory (bool): Is LDAP server an Active Directory LDAP server. For AD, NTLMv2 authentication is used. [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['name'] = \
            name
        kwargs['label'] = \
            label
        kwargs['hidden'] = \
            hidden
        kwargs['host'] = \
            host
        kwargs['port'] = \
            port
        kwargs['uid'] = \
            uid
        kwargs['encryption'] = \
            encryption
        kwargs['base'] = \
            base
        kwargs['user_filter'] = \
            user_filter
        return self.update_ldap_identity_provider_endpoint.call_with_http_info(**kwargs)

    def update_o_auth2_identity_provider(
        self,
        name,
        label,
        hidden,
        web_ui_client_id,
        issuer,
        **kwargs
    ):
        """Updates the identity provider of type OAuth2 with the specified name  # noqa: E501

        Requires admin role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_o_auth2_identity_provider(name, label, hidden, web_ui_client_id, issuer, async_req=True)
        >>> result = thread.get()

        Args:
            name (str): Unique identifier of the identity provider.
            label (str): Suggested login button string
            hidden (bool): Should the identity provider be listed when identity providers are listed. Client secrets are never displayed whether the identity provider is hidden or not.
            web_ui_client_id (str): OAuth 2.0 client id that should be used by Engine UI while logging in
            issuer (str): URL using the https scheme with no query or fragment component that the OP asserts as its Issuer Identifier.

        Keyword Args:
            web_ui_client_secret (str): OAuth 2.0 client secret that should be used by Engine UI while logging in. We recommend using a public OAuth 2.0 client and not specifying a secret, as Engine UI is a single-page application and cannot store client secrets. However, if this is not possible, you can use a slightly modified version of the Authorization Code Flow and have the API send token requests with the secret on your behalf.. [optional]
            device_client_id (str): OAuth 2.0 client ID, which should be used by clients that do not have browser access. The client must be a public client.. [optional]
            override_audience (str): By default, JWT tokens are expected to have audience claim matching the hostname in the configuration. To change expected audience for this provider, you can provide override_audience. Please try to avoid this. Instead, set the hostname properly in the Engine configuration and in the authorization server.. [optional]
            use_oidc_discover (bool): Should OpenID Connect Discovery be used. Fetches information from issuer URL appended with /.well-known/openid-configuration. [optional] if omitted the server will use the default value of False
            use_oauth2_auth_server_metadata (bool): Should OAuth 2.0 Authorization Server Metadata be used.Fetches information from issuer URL appended with /.well-known/oauth-authorization-server. [optional] if omitted the server will use the default value of False
            authorization_endpoint (str): Required unless discovery is used. URL of the OP's OAuth 2.0 Authorization Endpoint.. [optional]
            token_endpoint (str): URL of the OP's OAuth 2.0 Token Endpoint (ignored if discovery is used).. [optional]
            jwks_uri (str): Required unless discovery is used. URL of the OP's JSON Web Key Set document.. [optional]
            response_types_supported ([str]): Required unless discovery is used. Array containing a list of the OAuth 2.0 response_type values that this OP supports.. [optional]
            grant_types_supported ([str]): Array containing a list of the OAuth 2.0 Grant Type values that this OP supports (ignored if discovery is used).. [optional]
            end_session_endpoint (str): URL at the OP to which an RP can perform a redirect to request that the End-User be logged out at the OP. [optional]
            device_authorization_endpoint (str): URL of the authorization server's device authorization endpoint. [optional]
            request_scope_readonly (str): Scope that the client should request from the OP to get 'READONLY' scope. [optional] if omitted the server will use the default value of "READONLY"
            request_scope_namespaces (str): Scope that the client should request from the OP to get 'NAMESPACES' scope. [optional] if omitted the server will use the default value of "NAMESPACES"
            request_scope_jobs (str): Scope that the client should request from the OP to get 'JOBS' scope. [optional] if omitted the server will use the default value of "JOBS"
            request_scope_users (str): Scope that the client should request from the OP to get 'USERS' scope. [optional] if omitted the server will use the default value of "USERS"
            request_scope_hypercube (str): Scope that the client should request from the OP to get 'HYPERCUBE' scope. [optional] if omitted the server will use the default value of "HYPERCUBE"
            request_scope_cleanup (str): Scope that the client should request from the OP to get 'CLEANUP' scope. [optional] if omitted the server will use the default value of "CLEANUP"
            request_scope_licenses (str): Scope that the client should request from the OP to get 'LICENSES' scope. [optional] if omitted the server will use the default value of "LICENSES"
            request_scope_usage (str): Scope that the client should request from the OP to get 'USAGE' scope. [optional] if omitted the server will use the default value of "USAGE"
            request_scope_auth (str): Scope that the client should request from the OP to get 'AUTH' scope. [optional] if omitted the server will use the default value of "AUTH"
            request_scope_configuration (str): Scope that the client should request from the OP to get 'CONFIGURATION' scope. [optional] if omitted the server will use the default value of "CONFIGURATION"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['name'] = \
            name
        kwargs['label'] = \
            label
        kwargs['hidden'] = \
            hidden
        kwargs['web_ui_client_id'] = \
            web_ui_client_id
        kwargs['issuer'] = \
            issuer
        return self.update_o_auth2_identity_provider_endpoint.call_with_http_info(**kwargs)

    def update_oidc_identity_provider(
        self,
        name,
        label,
        hidden,
        web_ui_client_id,
        issuer,
        scopes,
        **kwargs
    ):
        """Updates the identity provider of type OIDC with the specified name  # noqa: E501

        Requires admin role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_oidc_identity_provider(name, label, hidden, web_ui_client_id, issuer, scopes, async_req=True)
        >>> result = thread.get()

        Args:
            name (str): Unique identifier of the identity provider.
            label (str): Suggested login button string
            hidden (bool): Should the identity provider be listed when identity providers are listed. Client secrets are never displayed whether the identity provider is hidden or not.
            web_ui_client_id (str): OAuth 2.0 client id that should be used by Engine UI while logging in
            issuer (str): URL using the https scheme with no query or fragment component that the OP asserts as its Issuer Identifier.
            scopes ([str]): The scopes that will be requested from the OP

        Keyword Args:
            web_ui_client_secret (str): OAuth 2.0 client secret that should be used by Engine UI while logging in. We recommend using a public OAuth 2.0 client and not specifying a secret, as Engine UI is a single-page application and cannot store client secrets. However, if this is not possible, you can use a slightly modified version of the Authorization Code Flow and have the API send token requests with the secret on your behalf.. [optional]
            device_client_id (str): OAuth 2.0 client ID, which should be used by clients that do not have browser access.. [optional]
            device_client_secret (str): OAuth 2.0 client secret that should be used by devices while logging in. We recommend using a public OAuth 2.0 client and not specifying a secret.  However, if this is not possible, you can use a slightly modified version of the Device Code Flow and have the API send token requests with the secret on your behalf.. [optional]
            extra_client_ids ([str]): Array of extra OAuth 2.0 client IDs from which the API accepts ID tokens. [optional]
            use_oidc_discover (bool): Should OpenID Connect Discovery be used. Fetches information from issuer URL appended with /.well-known/openid-configuration. [optional] if omitted the server will use the default value of False
            authorization_endpoint (str): Required unless discovery is used. URL of the OP's OAuth 2.0 Authorization Endpoint.. [optional]
            token_endpoint (str): URL of the OP's OAuth 2.0 Token Endpoint (ignored if discovery is used).. [optional]
            jwks_uri (str): Required unless discovery is used. URL of the OP's JSON Web Key Set document.. [optional]
            end_session_endpoint (str): URL at the OP to which an RP can perform a redirect to request that the End-User be logged out at the OP. [optional]
            device_authorization_endpoint (str): URL of the authorization server's device authorization endpoint. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['name'] = \
            name
        kwargs['label'] = \
            label
        kwargs['hidden'] = \
            hidden
        kwargs['web_ui_client_id'] = \
            web_ui_client_id
        kwargs['issuer'] = \
            issuer
        kwargs['scopes'] = \
            scopes
        return self.update_oidc_identity_provider_endpoint.call_with_http_info(**kwargs)

