"""
    GAMS Engine

    With GAMS Engine you can register and solve GAMS models. It has a namespace management system, so you can restrict your users to certain models.  # noqa: E501

    The version of the OpenAPI document: latest
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from gams.engine.api_client import ApiClient, Endpoint as _Endpoint
from gams.engine.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from gams.engine.model.hypercube_page import HypercubePage
from gams.engine.model.hypercube_token import HypercubeToken
from gams.engine.model.message import Message
from gams.engine.model.quota_exceeded import QuotaExceeded


class HypercubeApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_hypercube_endpoint = _Endpoint(
            settings={
                'response_type': (HypercubeToken,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/hypercube/',
                'operation_id': 'create_hypercube',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'model',
                    'namespace',
                    'hypercube_file',
                    'run',
                    'inex_string',
                    'arguments',
                    'dep_tokens',
                    'labels',
                    'tag',
                    'access_groups',
                    'stdout_filename',
                    'model_data',
                    'data',
                    'inex_file',
                ],
                'required': [
                    'model',
                    'namespace',
                    'hypercube_file',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'model':
                        (str,),
                    'namespace':
                        (str,),
                    'hypercube_file':
                        (file_type,),
                    'run':
                        (str,),
                    'inex_string':
                        (str,),
                    'arguments':
                        ([str],),
                    'dep_tokens':
                        ([str],),
                    'labels':
                        ([str],),
                    'tag':
                        (str,),
                    'access_groups':
                        ([str],),
                    'stdout_filename':
                        (str,),
                    'model_data':
                        (file_type,),
                    'data':
                        (file_type,),
                    'inex_file':
                        (file_type,),
                },
                'attribute_map': {
                    'model': 'model',
                    'namespace': 'namespace',
                    'hypercube_file': 'hypercube_file',
                    'run': 'run',
                    'inex_string': 'inex_string',
                    'arguments': 'arguments',
                    'dep_tokens': 'dep_tokens',
                    'labels': 'labels',
                    'tag': 'tag',
                    'access_groups': 'access_groups',
                    'stdout_filename': 'stdout_filename',
                    'model_data': 'model_data',
                    'data': 'data',
                    'inex_file': 'inex_file',
                },
                'location_map': {
                    'model': 'query',
                    'namespace': 'query',
                    'hypercube_file': 'form',
                    'run': 'query',
                    'inex_string': 'query',
                    'arguments': 'query',
                    'dep_tokens': 'query',
                    'labels': 'query',
                    'tag': 'query',
                    'access_groups': 'query',
                    'stdout_filename': 'query',
                    'model_data': 'form',
                    'data': 'form',
                    'inex_file': 'form',
                },
                'collection_format_map': {
                    'arguments': 'multi',
                    'dep_tokens': 'multi',
                    'labels': 'multi',
                    'access_groups': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.delete_hypercube_zip_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/hypercube/{hypercube_token}/result',
                'operation_id': 'delete_hypercube_zip',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'hypercube_token',
                ],
                'required': [
                    'hypercube_token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hypercube_token':
                        (str,),
                },
                'attribute_map': {
                    'hypercube_token': 'hypercube_token',
                },
                'location_map': {
                    'hypercube_token': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_hypercube_zip_endpoint = _Endpoint(
            settings={
                'response_type': (file_type,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/hypercube/{hypercube_token}/result',
                'operation_id': 'get_hypercube_zip',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'hypercube_token',
                ],
                'required': [
                    'hypercube_token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hypercube_token':
                        (str,),
                },
                'attribute_map': {
                    'hypercube_token': 'hypercube_token',
                },
                'location_map': {
                    'hypercube_token': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/zip'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_hypercube_zip_info_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/hypercube/{hypercube_token}/result',
                'operation_id': 'get_hypercube_zip_info',
                'http_method': 'HEAD',
                'servers': None,
            },
            params_map={
                'all': [
                    'hypercube_token',
                ],
                'required': [
                    'hypercube_token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hypercube_token':
                        (str,),
                },
                'attribute_map': {
                    'hypercube_token': 'hypercube_token',
                },
                'location_map': {
                    'hypercube_token': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.kill_hypercube_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/hypercube/{hypercube_token}',
                'operation_id': 'kill_hypercube',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'hypercube_token',
                    'hard_kill',
                ],
                'required': [
                    'hypercube_token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hypercube_token':
                        (str,),
                    'hard_kill':
                        (bool,),
                },
                'attribute_map': {
                    'hypercube_token': 'hypercube_token',
                    'hard_kill': 'hard_kill',
                },
                'location_map': {
                    'hypercube_token': 'path',
                    'hard_kill': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_hypercubes_endpoint = _Endpoint(
            settings={
                'response_type': (HypercubePage,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/hypercube/',
                'operation_id': 'list_hypercubes',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'hypercube_token',
                    'everyone',
                    'page',
                    'per_page',
                    'x_fields',
                    'order_by',
                    'order_asc',
                    'show_only_active',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'order_by',
                ],
                'validation': [
                    'page',
                    'per_page',
                ]
            },
            root_map={
                'validations': {
                    ('page',): {

                        'inclusive_maximum': 2147483647,
                        'inclusive_minimum': 1,
                    },
                    ('per_page',): {

                        'inclusive_maximum': 2147483647,
                        'inclusive_minimum': 0,
                    },
                },
                'allowed_values': {
                    ('order_by',): {

                        "MODEL": "model",
                        "NAMESPACE": "namespace",
                        "FINISHED": "finished",
                        "JOB_COUNT": "job_count",
                        "SUBMITTED_AT": "submitted_at",
                        "USER": "user"
                    },
                },
                'openapi_types': {
                    'hypercube_token':
                        (str,),
                    'everyone':
                        (bool,),
                    'page':
                        (int,),
                    'per_page':
                        (int,),
                    'x_fields':
                        (str,),
                    'order_by':
                        (str,),
                    'order_asc':
                        (bool,),
                    'show_only_active':
                        (bool,),
                },
                'attribute_map': {
                    'hypercube_token': 'hypercube_token',
                    'everyone': 'everyone',
                    'page': 'page',
                    'per_page': 'per_page',
                    'x_fields': 'X-Fields',
                    'order_by': 'order_by',
                    'order_asc': 'order_asc',
                    'show_only_active': 'show_only_active',
                },
                'location_map': {
                    'hypercube_token': 'query',
                    'everyone': 'query',
                    'page': 'query',
                    'per_page': 'query',
                    'x_fields': 'header',
                    'order_by': 'query',
                    'order_asc': 'query',
                    'show_only_active': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_hypercube_access_groups_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/hypercube/{hypercube_token}/access-groups',
                'operation_id': 'update_hypercube_access_groups',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'hypercube_token',
                    'access_groups',
                ],
                'required': [
                    'hypercube_token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hypercube_token':
                        (str,),
                    'access_groups':
                        ([str],),
                },
                'attribute_map': {
                    'hypercube_token': 'hypercube_token',
                    'access_groups': 'access_groups',
                },
                'location_map': {
                    'hypercube_token': 'path',
                    'access_groups': 'query',
                },
                'collection_format_map': {
                    'access_groups': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_hypercube_tag_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/hypercube/{hypercube_token}/tag',
                'operation_id': 'update_hypercube_tag',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'hypercube_token',
                    'tag',
                ],
                'required': [
                    'hypercube_token',
                    'tag',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'tag',
                ]
            },
            root_map={
                'validations': {
                    ('tag',): {

                        'regex': {
                            'pattern': r'^.{0,255}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hypercube_token':
                        (str,),
                    'tag':
                        (str,),
                },
                'attribute_map': {
                    'hypercube_token': 'hypercube_token',
                    'tag': 'tag',
                },
                'location_map': {
                    'hypercube_token': 'path',
                    'tag': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def create_hypercube(
        self,
        model,
        namespace,
        hypercube_file,
        **kwargs
    ):
        """Posts a Hypercube job  # noqa: E501

        If the model is a registered model, execute permission for the namespace is required. If model is a temporary model execute and write permission for the namespace is required. When the disk or volume quota reaches 80%, quota_warning is included in the response.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_hypercube(model, namespace, hypercube_file, async_req=True)
        >>> result = thread.get()

        Args:
            model (str): Name of the model
            namespace (str): Namespace containing(or will contain) the model
            hypercube_file (file_type): Hypercube description file

        Keyword Args:
            run (str): Name of the main gms file with its extension. Will use model + '.gms' if not provided.. [optional]
            inex_string (str): Optional JSON string to filter the contents of the result zip file (inex_file takes precedence if specified). [optional]
            arguments ([str]): Arguments that will be passed to GAMS call. [optional]
            dep_tokens ([str]): Tokens of jobs on which this job depends. The order defines the order in which the results of dependent jobs are extracted.. [optional]
            labels ([str]): Labels that will be attached to the job in key=value. Currently supported labels are: cpu_request, memory_request, workspace_request, node_selectors, tolerations, instance. [optional]
            tag (str): Human-readable tag to assign to job (at most 255 characters). [optional]
            access_groups ([str]): Labels of user groups that should be able to access this job.. [optional]
            stdout_filename (str): [optional]
            model_data (file_type): Zip file containing model files, if model is not registered. [optional]
            data (file_type): File containing data in zip. [optional]
            inex_file (file_type): Optional JSON file to filter the contents of the result zip file. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            HypercubeToken
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['model'] = \
            model
        kwargs['namespace'] = \
            namespace
        kwargs['hypercube_file'] = \
            hypercube_file
        return self.create_hypercube_endpoint.call_with_http_info(**kwargs)

    def delete_hypercube_zip(
        self,
        hypercube_token,
        **kwargs
    ):
        """Deletes the results of the Hypercube job  # noqa: E501

        Job must belong to the logged in user, an invitee of the logged in user, or logged in user must have admin role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_hypercube_zip(hypercube_token, async_req=True)
        >>> result = thread.get()

        Args:
            hypercube_token (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['hypercube_token'] = \
            hypercube_token
        return self.delete_hypercube_zip_endpoint.call_with_http_info(**kwargs)

    def get_hypercube_zip(
        self,
        hypercube_token,
        **kwargs
    ):
        """Downloads Hypercube job result  # noqa: E501

        The job must belong to the logged in user, an invitee of the logged in user, or logged in user must have admin role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_hypercube_zip(hypercube_token, async_req=True)
        >>> result = thread.get()

        Args:
            hypercube_token (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            file_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['hypercube_token'] = \
            hypercube_token
        return self.get_hypercube_zip_endpoint.call_with_http_info(**kwargs)

    def get_hypercube_zip_info(
        self,
        hypercube_token,
        **kwargs
    ):
        """Gets md5 hash and file size information of Hypercube job result  # noqa: E501

        The job must belong to the logged in user, an invitee of the logged in user, or the logged in user must have admin role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_hypercube_zip_info(hypercube_token, async_req=True)
        >>> result = thread.get()

        Args:
            hypercube_token (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['hypercube_token'] = \
            hypercube_token
        return self.get_hypercube_zip_info_endpoint.call_with_http_info(**kwargs)

    def kill_hypercube(
        self,
        hypercube_token,
        **kwargs
    ):
        """Terminates the unfinished jobs that belong to a Hypercube job  # noqa: E501

        Job must belong to the logged in user, an invitee of the logged in user, or the logged in user must have admin role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.kill_hypercube(hypercube_token, async_req=True)
        >>> result = thread.get()

        Args:
            hypercube_token (str):

        Keyword Args:
            hard_kill (bool): Sends SIGKILL if true, SIGINT otherwise. [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['hypercube_token'] = \
            hypercube_token
        return self.kill_hypercube_endpoint.call_with_http_info(**kwargs)

    def list_hypercubes(
        self,
        **kwargs
    ):
        """Lists the Hypercube jobs sent by the user unless `everyone` flag is set  # noqa: E501

        If user has admin role and `everyone` flag is set, all Hypercube jobs are listed. If user is not inviter or admin and `everyone` flag is set, all visible Hypercube jobs (Hypercube jobs that were assigned to a user group that user is member of) are listed. If user is inviter and 'everyone' flag is set, Hypercube jobs of all invitees will be listed additionally.  If `page` is not one and there are no elements at that page, throws 404. Due to performance issues the fields `result_exists`, `dep_tokens`, `labels` and `access_groups` are only provided for queries for a single Hypercube job.  If `show_only_active` flag is set it only shows hypercube jobs that are not finished. `labels.resource_warning`, `labels.instance`, `labels.multiplier`, `access_groups` and `tag` fields are hidden by default for compatibility reasons, please use X-Fields header to get it. For example: X-Fields: \\*, labels{\\*}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_hypercubes(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            hypercube_token (str): Hypercube token to filter. [optional]
            everyone (bool): Can be set by admin/inviter; shows Hypercube submissions of everyone/invitees. [optional]
            page (int): [optional] if omitted the server will use the default value of 1
            per_page (int): [optional] if omitted the server will use the default value of 0
            x_fields (str): [optional]
            order_by (str): [optional] if omitted the server will use the default value of "submitted_at"
            order_asc (bool): [optional] if omitted the server will use the default value of False
            show_only_active (bool): [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            HypercubePage
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.list_hypercubes_endpoint.call_with_http_info(**kwargs)

    def update_hypercube_access_groups(
        self,
        hypercube_token,
        **kwargs
    ):
        """Update access groups that can access a Hypercube job  # noqa: E501

        Can be queried via listHypercubes endpoint.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_hypercube_access_groups(hypercube_token, async_req=True)
        >>> result = thread.get()

        Args:
            hypercube_token (str):

        Keyword Args:
            access_groups ([str]): Labels of user groups that should be able to access this job.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['hypercube_token'] = \
            hypercube_token
        return self.update_hypercube_access_groups_endpoint.call_with_http_info(**kwargs)

    def update_hypercube_tag(
        self,
        hypercube_token,
        tag,
        **kwargs
    ):
        """Update human-readable tag of a Hypercube job  # noqa: E501

        Stored in `tag` field. Can be queried via listHypercubes endpoint.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_hypercube_tag(hypercube_token, tag, async_req=True)
        >>> result = thread.get()

        Args:
            hypercube_token (str):
            tag (str): Human-readable tag to assign to job (at most 255 characters)

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['hypercube_token'] = \
            hypercube_token
        kwargs['tag'] = \
            tag
        return self.update_hypercube_tag_endpoint.call_with_http_info(**kwargs)

