# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CseEntityNormalizationConfigurationArgs', 'CseEntityNormalizationConfiguration']

@pulumi.input_type
class CseEntityNormalizationConfigurationArgs:
    def __init__(__self__, *,
                 aws_normalization_enabled: pulumi.Input[bool],
                 domain_mappings: pulumi.Input[Sequence[pulumi.Input['CseEntityNormalizationConfigurationDomainMappingArgs']]],
                 fqdn_normalization_enabled: pulumi.Input[bool],
                 normalize_hostnames: pulumi.Input[bool],
                 normalize_usernames: pulumi.Input[bool],
                 windows_normalization_enabled: pulumi.Input[bool],
                 default_normalized_domain: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a CseEntityNormalizationConfiguration resource.
        :param pulumi.Input[bool] aws_normalization_enabled: Normalize AWS ARN and Usernames.
        :param pulumi.Input[Sequence[pulumi.Input['CseEntityNormalizationConfigurationDomainMappingArgs']]] domain_mappings: Secondary domains.
        :param pulumi.Input[bool] fqdn_normalization_enabled: Normalize names in the form user@somedomain.net or hostname.somedomain.net
        :param pulumi.Input[bool] normalize_hostnames: If hostname normalization is enabled.
        :param pulumi.Input[bool] normalize_usernames: If username normalization is enabled.
               
               - The following attributes are exported:
               
               - `ID` - The internal ID of the entity normalization configuration.
        :param pulumi.Input[bool] windows_normalization_enabled: Normalize active directory domains username and hostname formats.
        :param pulumi.Input[str] default_normalized_domain: When normalization is configured, at least one domain must be configured and a "Normalized Default Domain" must be provided.
        """
        pulumi.set(__self__, "aws_normalization_enabled", aws_normalization_enabled)
        pulumi.set(__self__, "domain_mappings", domain_mappings)
        pulumi.set(__self__, "fqdn_normalization_enabled", fqdn_normalization_enabled)
        pulumi.set(__self__, "normalize_hostnames", normalize_hostnames)
        pulumi.set(__self__, "normalize_usernames", normalize_usernames)
        pulumi.set(__self__, "windows_normalization_enabled", windows_normalization_enabled)
        if default_normalized_domain is not None:
            pulumi.set(__self__, "default_normalized_domain", default_normalized_domain)

    @property
    @pulumi.getter(name="awsNormalizationEnabled")
    def aws_normalization_enabled(self) -> pulumi.Input[bool]:
        """
        Normalize AWS ARN and Usernames.
        """
        return pulumi.get(self, "aws_normalization_enabled")

    @aws_normalization_enabled.setter
    def aws_normalization_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "aws_normalization_enabled", value)

    @property
    @pulumi.getter(name="domainMappings")
    def domain_mappings(self) -> pulumi.Input[Sequence[pulumi.Input['CseEntityNormalizationConfigurationDomainMappingArgs']]]:
        """
        Secondary domains.
        """
        return pulumi.get(self, "domain_mappings")

    @domain_mappings.setter
    def domain_mappings(self, value: pulumi.Input[Sequence[pulumi.Input['CseEntityNormalizationConfigurationDomainMappingArgs']]]):
        pulumi.set(self, "domain_mappings", value)

    @property
    @pulumi.getter(name="fqdnNormalizationEnabled")
    def fqdn_normalization_enabled(self) -> pulumi.Input[bool]:
        """
        Normalize names in the form user@somedomain.net or hostname.somedomain.net
        """
        return pulumi.get(self, "fqdn_normalization_enabled")

    @fqdn_normalization_enabled.setter
    def fqdn_normalization_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "fqdn_normalization_enabled", value)

    @property
    @pulumi.getter(name="normalizeHostnames")
    def normalize_hostnames(self) -> pulumi.Input[bool]:
        """
        If hostname normalization is enabled.
        """
        return pulumi.get(self, "normalize_hostnames")

    @normalize_hostnames.setter
    def normalize_hostnames(self, value: pulumi.Input[bool]):
        pulumi.set(self, "normalize_hostnames", value)

    @property
    @pulumi.getter(name="normalizeUsernames")
    def normalize_usernames(self) -> pulumi.Input[bool]:
        """
        If username normalization is enabled.

        - The following attributes are exported:

        - `ID` - The internal ID of the entity normalization configuration.
        """
        return pulumi.get(self, "normalize_usernames")

    @normalize_usernames.setter
    def normalize_usernames(self, value: pulumi.Input[bool]):
        pulumi.set(self, "normalize_usernames", value)

    @property
    @pulumi.getter(name="windowsNormalizationEnabled")
    def windows_normalization_enabled(self) -> pulumi.Input[bool]:
        """
        Normalize active directory domains username and hostname formats.
        """
        return pulumi.get(self, "windows_normalization_enabled")

    @windows_normalization_enabled.setter
    def windows_normalization_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "windows_normalization_enabled", value)

    @property
    @pulumi.getter(name="defaultNormalizedDomain")
    def default_normalized_domain(self) -> Optional[pulumi.Input[str]]:
        """
        When normalization is configured, at least one domain must be configured and a "Normalized Default Domain" must be provided.
        """
        return pulumi.get(self, "default_normalized_domain")

    @default_normalized_domain.setter
    def default_normalized_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_normalized_domain", value)


@pulumi.input_type
class _CseEntityNormalizationConfigurationState:
    def __init__(__self__, *,
                 aws_normalization_enabled: Optional[pulumi.Input[bool]] = None,
                 default_normalized_domain: Optional[pulumi.Input[str]] = None,
                 domain_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['CseEntityNormalizationConfigurationDomainMappingArgs']]]] = None,
                 fqdn_normalization_enabled: Optional[pulumi.Input[bool]] = None,
                 normalize_hostnames: Optional[pulumi.Input[bool]] = None,
                 normalize_usernames: Optional[pulumi.Input[bool]] = None,
                 windows_normalization_enabled: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering CseEntityNormalizationConfiguration resources.
        :param pulumi.Input[bool] aws_normalization_enabled: Normalize AWS ARN and Usernames.
        :param pulumi.Input[str] default_normalized_domain: When normalization is configured, at least one domain must be configured and a "Normalized Default Domain" must be provided.
        :param pulumi.Input[Sequence[pulumi.Input['CseEntityNormalizationConfigurationDomainMappingArgs']]] domain_mappings: Secondary domains.
        :param pulumi.Input[bool] fqdn_normalization_enabled: Normalize names in the form user@somedomain.net or hostname.somedomain.net
        :param pulumi.Input[bool] normalize_hostnames: If hostname normalization is enabled.
        :param pulumi.Input[bool] normalize_usernames: If username normalization is enabled.
               
               - The following attributes are exported:
               
               - `ID` - The internal ID of the entity normalization configuration.
        :param pulumi.Input[bool] windows_normalization_enabled: Normalize active directory domains username and hostname formats.
        """
        if aws_normalization_enabled is not None:
            pulumi.set(__self__, "aws_normalization_enabled", aws_normalization_enabled)
        if default_normalized_domain is not None:
            pulumi.set(__self__, "default_normalized_domain", default_normalized_domain)
        if domain_mappings is not None:
            pulumi.set(__self__, "domain_mappings", domain_mappings)
        if fqdn_normalization_enabled is not None:
            pulumi.set(__self__, "fqdn_normalization_enabled", fqdn_normalization_enabled)
        if normalize_hostnames is not None:
            pulumi.set(__self__, "normalize_hostnames", normalize_hostnames)
        if normalize_usernames is not None:
            pulumi.set(__self__, "normalize_usernames", normalize_usernames)
        if windows_normalization_enabled is not None:
            pulumi.set(__self__, "windows_normalization_enabled", windows_normalization_enabled)

    @property
    @pulumi.getter(name="awsNormalizationEnabled")
    def aws_normalization_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Normalize AWS ARN and Usernames.
        """
        return pulumi.get(self, "aws_normalization_enabled")

    @aws_normalization_enabled.setter
    def aws_normalization_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "aws_normalization_enabled", value)

    @property
    @pulumi.getter(name="defaultNormalizedDomain")
    def default_normalized_domain(self) -> Optional[pulumi.Input[str]]:
        """
        When normalization is configured, at least one domain must be configured and a "Normalized Default Domain" must be provided.
        """
        return pulumi.get(self, "default_normalized_domain")

    @default_normalized_domain.setter
    def default_normalized_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_normalized_domain", value)

    @property
    @pulumi.getter(name="domainMappings")
    def domain_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CseEntityNormalizationConfigurationDomainMappingArgs']]]]:
        """
        Secondary domains.
        """
        return pulumi.get(self, "domain_mappings")

    @domain_mappings.setter
    def domain_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CseEntityNormalizationConfigurationDomainMappingArgs']]]]):
        pulumi.set(self, "domain_mappings", value)

    @property
    @pulumi.getter(name="fqdnNormalizationEnabled")
    def fqdn_normalization_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Normalize names in the form user@somedomain.net or hostname.somedomain.net
        """
        return pulumi.get(self, "fqdn_normalization_enabled")

    @fqdn_normalization_enabled.setter
    def fqdn_normalization_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "fqdn_normalization_enabled", value)

    @property
    @pulumi.getter(name="normalizeHostnames")
    def normalize_hostnames(self) -> Optional[pulumi.Input[bool]]:
        """
        If hostname normalization is enabled.
        """
        return pulumi.get(self, "normalize_hostnames")

    @normalize_hostnames.setter
    def normalize_hostnames(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "normalize_hostnames", value)

    @property
    @pulumi.getter(name="normalizeUsernames")
    def normalize_usernames(self) -> Optional[pulumi.Input[bool]]:
        """
        If username normalization is enabled.

        - The following attributes are exported:

        - `ID` - The internal ID of the entity normalization configuration.
        """
        return pulumi.get(self, "normalize_usernames")

    @normalize_usernames.setter
    def normalize_usernames(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "normalize_usernames", value)

    @property
    @pulumi.getter(name="windowsNormalizationEnabled")
    def windows_normalization_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Normalize active directory domains username and hostname formats.
        """
        return pulumi.get(self, "windows_normalization_enabled")

    @windows_normalization_enabled.setter
    def windows_normalization_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "windows_normalization_enabled", value)


class CseEntityNormalizationConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_normalization_enabled: Optional[pulumi.Input[bool]] = None,
                 default_normalized_domain: Optional[pulumi.Input[str]] = None,
                 domain_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CseEntityNormalizationConfigurationDomainMappingArgs']]]]] = None,
                 fqdn_normalization_enabled: Optional[pulumi.Input[bool]] = None,
                 normalize_hostnames: Optional[pulumi.Input[bool]] = None,
                 normalize_usernames: Optional[pulumi.Input[bool]] = None,
                 windows_normalization_enabled: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Provides the Sumologic CSE Entity Normalization Configuration for the whole organization. There can be only one configuration per organization.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sumologic as sumologic

        entity_normalization_configuration = sumologic.CseEntityNormalizationConfiguration("entity_normalization_configuration",
            windows_normalization_enabled=True,
            fqdn_normalization_enabled=True,
            aws_normalization_enabled=True,
            default_normalized_domain="domain.com",
            normalize_hostnames=True,
            normalize_usernames=True,
            domain_mappings=[sumologic.CseEntityNormalizationConfigurationDomainMappingArgs(
                normalized_domain="normalized.domain",
                raw_domain="raw.domain",
            )])
        ```

        ## Import

        Entity Normalization Configuration can be imported using the id `cse-entity-normalization-configuration`:

        hcl

        ```sh
        $ pulumi import sumologic:index/cseEntityNormalizationConfiguration:CseEntityNormalizationConfiguration entity_normalization_configuration cse-entity-normalization-configuration
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] aws_normalization_enabled: Normalize AWS ARN and Usernames.
        :param pulumi.Input[str] default_normalized_domain: When normalization is configured, at least one domain must be configured and a "Normalized Default Domain" must be provided.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CseEntityNormalizationConfigurationDomainMappingArgs']]]] domain_mappings: Secondary domains.
        :param pulumi.Input[bool] fqdn_normalization_enabled: Normalize names in the form user@somedomain.net or hostname.somedomain.net
        :param pulumi.Input[bool] normalize_hostnames: If hostname normalization is enabled.
        :param pulumi.Input[bool] normalize_usernames: If username normalization is enabled.
               
               - The following attributes are exported:
               
               - `ID` - The internal ID of the entity normalization configuration.
        :param pulumi.Input[bool] windows_normalization_enabled: Normalize active directory domains username and hostname formats.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CseEntityNormalizationConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides the Sumologic CSE Entity Normalization Configuration for the whole organization. There can be only one configuration per organization.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sumologic as sumologic

        entity_normalization_configuration = sumologic.CseEntityNormalizationConfiguration("entity_normalization_configuration",
            windows_normalization_enabled=True,
            fqdn_normalization_enabled=True,
            aws_normalization_enabled=True,
            default_normalized_domain="domain.com",
            normalize_hostnames=True,
            normalize_usernames=True,
            domain_mappings=[sumologic.CseEntityNormalizationConfigurationDomainMappingArgs(
                normalized_domain="normalized.domain",
                raw_domain="raw.domain",
            )])
        ```

        ## Import

        Entity Normalization Configuration can be imported using the id `cse-entity-normalization-configuration`:

        hcl

        ```sh
        $ pulumi import sumologic:index/cseEntityNormalizationConfiguration:CseEntityNormalizationConfiguration entity_normalization_configuration cse-entity-normalization-configuration
        ```

        :param str resource_name: The name of the resource.
        :param CseEntityNormalizationConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CseEntityNormalizationConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_normalization_enabled: Optional[pulumi.Input[bool]] = None,
                 default_normalized_domain: Optional[pulumi.Input[str]] = None,
                 domain_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CseEntityNormalizationConfigurationDomainMappingArgs']]]]] = None,
                 fqdn_normalization_enabled: Optional[pulumi.Input[bool]] = None,
                 normalize_hostnames: Optional[pulumi.Input[bool]] = None,
                 normalize_usernames: Optional[pulumi.Input[bool]] = None,
                 windows_normalization_enabled: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CseEntityNormalizationConfigurationArgs.__new__(CseEntityNormalizationConfigurationArgs)

            if aws_normalization_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'aws_normalization_enabled'")
            __props__.__dict__["aws_normalization_enabled"] = aws_normalization_enabled
            __props__.__dict__["default_normalized_domain"] = default_normalized_domain
            if domain_mappings is None and not opts.urn:
                raise TypeError("Missing required property 'domain_mappings'")
            __props__.__dict__["domain_mappings"] = domain_mappings
            if fqdn_normalization_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'fqdn_normalization_enabled'")
            __props__.__dict__["fqdn_normalization_enabled"] = fqdn_normalization_enabled
            if normalize_hostnames is None and not opts.urn:
                raise TypeError("Missing required property 'normalize_hostnames'")
            __props__.__dict__["normalize_hostnames"] = normalize_hostnames
            if normalize_usernames is None and not opts.urn:
                raise TypeError("Missing required property 'normalize_usernames'")
            __props__.__dict__["normalize_usernames"] = normalize_usernames
            if windows_normalization_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'windows_normalization_enabled'")
            __props__.__dict__["windows_normalization_enabled"] = windows_normalization_enabled
        super(CseEntityNormalizationConfiguration, __self__).__init__(
            'sumologic:index/cseEntityNormalizationConfiguration:CseEntityNormalizationConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aws_normalization_enabled: Optional[pulumi.Input[bool]] = None,
            default_normalized_domain: Optional[pulumi.Input[str]] = None,
            domain_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CseEntityNormalizationConfigurationDomainMappingArgs']]]]] = None,
            fqdn_normalization_enabled: Optional[pulumi.Input[bool]] = None,
            normalize_hostnames: Optional[pulumi.Input[bool]] = None,
            normalize_usernames: Optional[pulumi.Input[bool]] = None,
            windows_normalization_enabled: Optional[pulumi.Input[bool]] = None) -> 'CseEntityNormalizationConfiguration':
        """
        Get an existing CseEntityNormalizationConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] aws_normalization_enabled: Normalize AWS ARN and Usernames.
        :param pulumi.Input[str] default_normalized_domain: When normalization is configured, at least one domain must be configured and a "Normalized Default Domain" must be provided.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CseEntityNormalizationConfigurationDomainMappingArgs']]]] domain_mappings: Secondary domains.
        :param pulumi.Input[bool] fqdn_normalization_enabled: Normalize names in the form user@somedomain.net or hostname.somedomain.net
        :param pulumi.Input[bool] normalize_hostnames: If hostname normalization is enabled.
        :param pulumi.Input[bool] normalize_usernames: If username normalization is enabled.
               
               - The following attributes are exported:
               
               - `ID` - The internal ID of the entity normalization configuration.
        :param pulumi.Input[bool] windows_normalization_enabled: Normalize active directory domains username and hostname formats.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CseEntityNormalizationConfigurationState.__new__(_CseEntityNormalizationConfigurationState)

        __props__.__dict__["aws_normalization_enabled"] = aws_normalization_enabled
        __props__.__dict__["default_normalized_domain"] = default_normalized_domain
        __props__.__dict__["domain_mappings"] = domain_mappings
        __props__.__dict__["fqdn_normalization_enabled"] = fqdn_normalization_enabled
        __props__.__dict__["normalize_hostnames"] = normalize_hostnames
        __props__.__dict__["normalize_usernames"] = normalize_usernames
        __props__.__dict__["windows_normalization_enabled"] = windows_normalization_enabled
        return CseEntityNormalizationConfiguration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="awsNormalizationEnabled")
    def aws_normalization_enabled(self) -> pulumi.Output[bool]:
        """
        Normalize AWS ARN and Usernames.
        """
        return pulumi.get(self, "aws_normalization_enabled")

    @property
    @pulumi.getter(name="defaultNormalizedDomain")
    def default_normalized_domain(self) -> pulumi.Output[Optional[str]]:
        """
        When normalization is configured, at least one domain must be configured and a "Normalized Default Domain" must be provided.
        """
        return pulumi.get(self, "default_normalized_domain")

    @property
    @pulumi.getter(name="domainMappings")
    def domain_mappings(self) -> pulumi.Output[Sequence['outputs.CseEntityNormalizationConfigurationDomainMapping']]:
        """
        Secondary domains.
        """
        return pulumi.get(self, "domain_mappings")

    @property
    @pulumi.getter(name="fqdnNormalizationEnabled")
    def fqdn_normalization_enabled(self) -> pulumi.Output[bool]:
        """
        Normalize names in the form user@somedomain.net or hostname.somedomain.net
        """
        return pulumi.get(self, "fqdn_normalization_enabled")

    @property
    @pulumi.getter(name="normalizeHostnames")
    def normalize_hostnames(self) -> pulumi.Output[bool]:
        """
        If hostname normalization is enabled.
        """
        return pulumi.get(self, "normalize_hostnames")

    @property
    @pulumi.getter(name="normalizeUsernames")
    def normalize_usernames(self) -> pulumi.Output[bool]:
        """
        If username normalization is enabled.

        - The following attributes are exported:

        - `ID` - The internal ID of the entity normalization configuration.
        """
        return pulumi.get(self, "normalize_usernames")

    @property
    @pulumi.getter(name="windowsNormalizationEnabled")
    def windows_normalization_enabled(self) -> pulumi.Output[bool]:
        """
        Normalize active directory domains username and hostname formats.
        """
        return pulumi.get(self, "windows_normalization_enabled")

