# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CseFirstSeenRuleArgs', 'CseFirstSeenRule']

@pulumi.input_type
class CseFirstSeenRuleArgs:
    def __init__(__self__, *,
                 baseline_type: pulumi.Input[str],
                 baseline_window_size: pulumi.Input[str],
                 description_expression: pulumi.Input[str],
                 enabled: pulumi.Input[bool],
                 entity_selectors: pulumi.Input[Sequence[pulumi.Input['CseFirstSeenRuleEntitySelectorArgs']]],
                 filter_expression: pulumi.Input[str],
                 name_expression: pulumi.Input[str],
                 retention_window_size: pulumi.Input[str],
                 severity: pulumi.Input[int],
                 value_fields: pulumi.Input[Sequence[pulumi.Input[str]]],
                 group_by_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 is_prototype: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 summary_expression: Optional[pulumi.Input[str]] = None,
                 suppression_window_size: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a CseFirstSeenRule resource.
        :param pulumi.Input[str] baseline_type: The baseline type. Current acceptable values are GLOBAL or PER_ENTITY
        :param pulumi.Input[str] baseline_window_size: The baseline window size in milliseconds
        :param pulumi.Input[str] description_expression: The description of the generated Signals
        :param pulumi.Input[bool] enabled: Whether the rule should generate Signals
        :param pulumi.Input[Sequence[pulumi.Input['CseFirstSeenRuleEntitySelectorArgs']]] entity_selectors: The entities to generate Signals on
               + `entityType` - (Required) The type of the entity to generate the Signal on
        :param pulumi.Input[str] filter_expression: The expression for which records to match on
        :param pulumi.Input[str] name_expression: The name of the generated Signals
        :param pulumi.Input[str] retention_window_size: The retention window size in milliseconds
        :param pulumi.Input[int] severity: The severity of the generated Signals
        :param pulumi.Input[Sequence[pulumi.Input[str]]] value_fields: The value fields
        :param pulumi.Input[Sequence[pulumi.Input[str]]] group_by_fields: A list of fields to group records by
        :param pulumi.Input[bool] is_prototype: Whether the generated Signals should be prototype Signals
        :param pulumi.Input[str] name: The name of the Rule
        :param pulumi.Input[str] summary_expression: The summary of the generated Signals
        :param pulumi.Input[int] suppression_window_size: For how long to suppress Signal generation, in milliseconds. Must be greater than 0 and less than the global limit of 7 days.
               
               The following attributes are exported:
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags of the generated Signals
        """
        pulumi.set(__self__, "baseline_type", baseline_type)
        pulumi.set(__self__, "baseline_window_size", baseline_window_size)
        pulumi.set(__self__, "description_expression", description_expression)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "entity_selectors", entity_selectors)
        pulumi.set(__self__, "filter_expression", filter_expression)
        pulumi.set(__self__, "name_expression", name_expression)
        pulumi.set(__self__, "retention_window_size", retention_window_size)
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "value_fields", value_fields)
        if group_by_fields is not None:
            pulumi.set(__self__, "group_by_fields", group_by_fields)
        if is_prototype is not None:
            pulumi.set(__self__, "is_prototype", is_prototype)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if summary_expression is not None:
            pulumi.set(__self__, "summary_expression", summary_expression)
        if suppression_window_size is not None:
            pulumi.set(__self__, "suppression_window_size", suppression_window_size)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="baselineType")
    def baseline_type(self) -> pulumi.Input[str]:
        """
        The baseline type. Current acceptable values are GLOBAL or PER_ENTITY
        """
        return pulumi.get(self, "baseline_type")

    @baseline_type.setter
    def baseline_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "baseline_type", value)

    @property
    @pulumi.getter(name="baselineWindowSize")
    def baseline_window_size(self) -> pulumi.Input[str]:
        """
        The baseline window size in milliseconds
        """
        return pulumi.get(self, "baseline_window_size")

    @baseline_window_size.setter
    def baseline_window_size(self, value: pulumi.Input[str]):
        pulumi.set(self, "baseline_window_size", value)

    @property
    @pulumi.getter(name="descriptionExpression")
    def description_expression(self) -> pulumi.Input[str]:
        """
        The description of the generated Signals
        """
        return pulumi.get(self, "description_expression")

    @description_expression.setter
    def description_expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "description_expression", value)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Whether the rule should generate Signals
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="entitySelectors")
    def entity_selectors(self) -> pulumi.Input[Sequence[pulumi.Input['CseFirstSeenRuleEntitySelectorArgs']]]:
        """
        The entities to generate Signals on
        + `entityType` - (Required) The type of the entity to generate the Signal on
        """
        return pulumi.get(self, "entity_selectors")

    @entity_selectors.setter
    def entity_selectors(self, value: pulumi.Input[Sequence[pulumi.Input['CseFirstSeenRuleEntitySelectorArgs']]]):
        pulumi.set(self, "entity_selectors", value)

    @property
    @pulumi.getter(name="filterExpression")
    def filter_expression(self) -> pulumi.Input[str]:
        """
        The expression for which records to match on
        """
        return pulumi.get(self, "filter_expression")

    @filter_expression.setter
    def filter_expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "filter_expression", value)

    @property
    @pulumi.getter(name="nameExpression")
    def name_expression(self) -> pulumi.Input[str]:
        """
        The name of the generated Signals
        """
        return pulumi.get(self, "name_expression")

    @name_expression.setter
    def name_expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "name_expression", value)

    @property
    @pulumi.getter(name="retentionWindowSize")
    def retention_window_size(self) -> pulumi.Input[str]:
        """
        The retention window size in milliseconds
        """
        return pulumi.get(self, "retention_window_size")

    @retention_window_size.setter
    def retention_window_size(self, value: pulumi.Input[str]):
        pulumi.set(self, "retention_window_size", value)

    @property
    @pulumi.getter
    def severity(self) -> pulumi.Input[int]:
        """
        The severity of the generated Signals
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: pulumi.Input[int]):
        pulumi.set(self, "severity", value)

    @property
    @pulumi.getter(name="valueFields")
    def value_fields(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The value fields
        """
        return pulumi.get(self, "value_fields")

    @value_fields.setter
    def value_fields(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "value_fields", value)

    @property
    @pulumi.getter(name="groupByFields")
    def group_by_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of fields to group records by
        """
        return pulumi.get(self, "group_by_fields")

    @group_by_fields.setter
    def group_by_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "group_by_fields", value)

    @property
    @pulumi.getter(name="isPrototype")
    def is_prototype(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the generated Signals should be prototype Signals
        """
        return pulumi.get(self, "is_prototype")

    @is_prototype.setter
    def is_prototype(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_prototype", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Rule
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="summaryExpression")
    def summary_expression(self) -> Optional[pulumi.Input[str]]:
        """
        The summary of the generated Signals
        """
        return pulumi.get(self, "summary_expression")

    @summary_expression.setter
    def summary_expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "summary_expression", value)

    @property
    @pulumi.getter(name="suppressionWindowSize")
    def suppression_window_size(self) -> Optional[pulumi.Input[int]]:
        """
        For how long to suppress Signal generation, in milliseconds. Must be greater than 0 and less than the global limit of 7 days.

        The following attributes are exported:
        """
        return pulumi.get(self, "suppression_window_size")

    @suppression_window_size.setter
    def suppression_window_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "suppression_window_size", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The tags of the generated Signals
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _CseFirstSeenRuleState:
    def __init__(__self__, *,
                 baseline_type: Optional[pulumi.Input[str]] = None,
                 baseline_window_size: Optional[pulumi.Input[str]] = None,
                 description_expression: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 entity_selectors: Optional[pulumi.Input[Sequence[pulumi.Input['CseFirstSeenRuleEntitySelectorArgs']]]] = None,
                 filter_expression: Optional[pulumi.Input[str]] = None,
                 group_by_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 is_prototype: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_expression: Optional[pulumi.Input[str]] = None,
                 retention_window_size: Optional[pulumi.Input[str]] = None,
                 severity: Optional[pulumi.Input[int]] = None,
                 summary_expression: Optional[pulumi.Input[str]] = None,
                 suppression_window_size: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 value_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering CseFirstSeenRule resources.
        :param pulumi.Input[str] baseline_type: The baseline type. Current acceptable values are GLOBAL or PER_ENTITY
        :param pulumi.Input[str] baseline_window_size: The baseline window size in milliseconds
        :param pulumi.Input[str] description_expression: The description of the generated Signals
        :param pulumi.Input[bool] enabled: Whether the rule should generate Signals
        :param pulumi.Input[Sequence[pulumi.Input['CseFirstSeenRuleEntitySelectorArgs']]] entity_selectors: The entities to generate Signals on
               + `entityType` - (Required) The type of the entity to generate the Signal on
        :param pulumi.Input[str] filter_expression: The expression for which records to match on
        :param pulumi.Input[Sequence[pulumi.Input[str]]] group_by_fields: A list of fields to group records by
        :param pulumi.Input[bool] is_prototype: Whether the generated Signals should be prototype Signals
        :param pulumi.Input[str] name: The name of the Rule
        :param pulumi.Input[str] name_expression: The name of the generated Signals
        :param pulumi.Input[str] retention_window_size: The retention window size in milliseconds
        :param pulumi.Input[int] severity: The severity of the generated Signals
        :param pulumi.Input[str] summary_expression: The summary of the generated Signals
        :param pulumi.Input[int] suppression_window_size: For how long to suppress Signal generation, in milliseconds. Must be greater than 0 and less than the global limit of 7 days.
               
               The following attributes are exported:
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags of the generated Signals
        :param pulumi.Input[Sequence[pulumi.Input[str]]] value_fields: The value fields
        """
        if baseline_type is not None:
            pulumi.set(__self__, "baseline_type", baseline_type)
        if baseline_window_size is not None:
            pulumi.set(__self__, "baseline_window_size", baseline_window_size)
        if description_expression is not None:
            pulumi.set(__self__, "description_expression", description_expression)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if entity_selectors is not None:
            pulumi.set(__self__, "entity_selectors", entity_selectors)
        if filter_expression is not None:
            pulumi.set(__self__, "filter_expression", filter_expression)
        if group_by_fields is not None:
            pulumi.set(__self__, "group_by_fields", group_by_fields)
        if is_prototype is not None:
            pulumi.set(__self__, "is_prototype", is_prototype)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_expression is not None:
            pulumi.set(__self__, "name_expression", name_expression)
        if retention_window_size is not None:
            pulumi.set(__self__, "retention_window_size", retention_window_size)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if summary_expression is not None:
            pulumi.set(__self__, "summary_expression", summary_expression)
        if suppression_window_size is not None:
            pulumi.set(__self__, "suppression_window_size", suppression_window_size)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if value_fields is not None:
            pulumi.set(__self__, "value_fields", value_fields)

    @property
    @pulumi.getter(name="baselineType")
    def baseline_type(self) -> Optional[pulumi.Input[str]]:
        """
        The baseline type. Current acceptable values are GLOBAL or PER_ENTITY
        """
        return pulumi.get(self, "baseline_type")

    @baseline_type.setter
    def baseline_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "baseline_type", value)

    @property
    @pulumi.getter(name="baselineWindowSize")
    def baseline_window_size(self) -> Optional[pulumi.Input[str]]:
        """
        The baseline window size in milliseconds
        """
        return pulumi.get(self, "baseline_window_size")

    @baseline_window_size.setter
    def baseline_window_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "baseline_window_size", value)

    @property
    @pulumi.getter(name="descriptionExpression")
    def description_expression(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the generated Signals
        """
        return pulumi.get(self, "description_expression")

    @description_expression.setter
    def description_expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description_expression", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the rule should generate Signals
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="entitySelectors")
    def entity_selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CseFirstSeenRuleEntitySelectorArgs']]]]:
        """
        The entities to generate Signals on
        + `entityType` - (Required) The type of the entity to generate the Signal on
        """
        return pulumi.get(self, "entity_selectors")

    @entity_selectors.setter
    def entity_selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CseFirstSeenRuleEntitySelectorArgs']]]]):
        pulumi.set(self, "entity_selectors", value)

    @property
    @pulumi.getter(name="filterExpression")
    def filter_expression(self) -> Optional[pulumi.Input[str]]:
        """
        The expression for which records to match on
        """
        return pulumi.get(self, "filter_expression")

    @filter_expression.setter
    def filter_expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filter_expression", value)

    @property
    @pulumi.getter(name="groupByFields")
    def group_by_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of fields to group records by
        """
        return pulumi.get(self, "group_by_fields")

    @group_by_fields.setter
    def group_by_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "group_by_fields", value)

    @property
    @pulumi.getter(name="isPrototype")
    def is_prototype(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the generated Signals should be prototype Signals
        """
        return pulumi.get(self, "is_prototype")

    @is_prototype.setter
    def is_prototype(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_prototype", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Rule
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nameExpression")
    def name_expression(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the generated Signals
        """
        return pulumi.get(self, "name_expression")

    @name_expression.setter
    def name_expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_expression", value)

    @property
    @pulumi.getter(name="retentionWindowSize")
    def retention_window_size(self) -> Optional[pulumi.Input[str]]:
        """
        The retention window size in milliseconds
        """
        return pulumi.get(self, "retention_window_size")

    @retention_window_size.setter
    def retention_window_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "retention_window_size", value)

    @property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[int]]:
        """
        The severity of the generated Signals
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "severity", value)

    @property
    @pulumi.getter(name="summaryExpression")
    def summary_expression(self) -> Optional[pulumi.Input[str]]:
        """
        The summary of the generated Signals
        """
        return pulumi.get(self, "summary_expression")

    @summary_expression.setter
    def summary_expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "summary_expression", value)

    @property
    @pulumi.getter(name="suppressionWindowSize")
    def suppression_window_size(self) -> Optional[pulumi.Input[int]]:
        """
        For how long to suppress Signal generation, in milliseconds. Must be greater than 0 and less than the global limit of 7 days.

        The following attributes are exported:
        """
        return pulumi.get(self, "suppression_window_size")

    @suppression_window_size.setter
    def suppression_window_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "suppression_window_size", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The tags of the generated Signals
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="valueFields")
    def value_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The value fields
        """
        return pulumi.get(self, "value_fields")

    @value_fields.setter
    def value_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "value_fields", value)


class CseFirstSeenRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 baseline_type: Optional[pulumi.Input[str]] = None,
                 baseline_window_size: Optional[pulumi.Input[str]] = None,
                 description_expression: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 entity_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CseFirstSeenRuleEntitySelectorArgs']]]]] = None,
                 filter_expression: Optional[pulumi.Input[str]] = None,
                 group_by_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 is_prototype: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_expression: Optional[pulumi.Input[str]] = None,
                 retention_window_size: Optional[pulumi.Input[str]] = None,
                 severity: Optional[pulumi.Input[int]] = None,
                 summary_expression: Optional[pulumi.Input[str]] = None,
                 suppression_window_size: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 value_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Provides a Sumo Logic CSE [First Seen Rule](https://help.sumologic.com/docs/cse/rules/write-first-seen-rule/).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sumologic as sumologic

        first_seen_rule = sumologic.CseFirstSeenRule("first_seen_rule",
            baseline_type="PER_ENTITY",
            baseline_window_size="35000",
            description_expression="First User Login - {{ user_username }}",
            enabled=True,
            entity_selectors=[
                sumologic.CseFirstSeenRuleEntitySelectorArgs(
                    entity_type="_username",
                    expression="user_username",
                ),
                sumologic.CseFirstSeenRuleEntitySelectorArgs(
                    entity_type="_hostname",
                    expression="dstDevice_hostname",
                ),
            ],
            filter_expression="objectType=\\"Network\\"",
            group_by_fields=["user_username"],
            is_prototype=False,
            name="First User Login",
            name_expression="First User Login - {{ user_username }}",
            retention_window_size="86400000",
            severity=1,
            value_fields=["dstDevice_hostname"],
            suppression_window_size=2100000)
        ```

        ## Import

        First Seen Rules can be imported using the field id, e.g.:

        hcl

        ```sh
        $ pulumi import sumologic:index/cseFirstSeenRule:CseFirstSeenRule first_seen_rule id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] baseline_type: The baseline type. Current acceptable values are GLOBAL or PER_ENTITY
        :param pulumi.Input[str] baseline_window_size: The baseline window size in milliseconds
        :param pulumi.Input[str] description_expression: The description of the generated Signals
        :param pulumi.Input[bool] enabled: Whether the rule should generate Signals
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CseFirstSeenRuleEntitySelectorArgs']]]] entity_selectors: The entities to generate Signals on
               + `entityType` - (Required) The type of the entity to generate the Signal on
        :param pulumi.Input[str] filter_expression: The expression for which records to match on
        :param pulumi.Input[Sequence[pulumi.Input[str]]] group_by_fields: A list of fields to group records by
        :param pulumi.Input[bool] is_prototype: Whether the generated Signals should be prototype Signals
        :param pulumi.Input[str] name: The name of the Rule
        :param pulumi.Input[str] name_expression: The name of the generated Signals
        :param pulumi.Input[str] retention_window_size: The retention window size in milliseconds
        :param pulumi.Input[int] severity: The severity of the generated Signals
        :param pulumi.Input[str] summary_expression: The summary of the generated Signals
        :param pulumi.Input[int] suppression_window_size: For how long to suppress Signal generation, in milliseconds. Must be greater than 0 and less than the global limit of 7 days.
               
               The following attributes are exported:
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags of the generated Signals
        :param pulumi.Input[Sequence[pulumi.Input[str]]] value_fields: The value fields
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CseFirstSeenRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Sumo Logic CSE [First Seen Rule](https://help.sumologic.com/docs/cse/rules/write-first-seen-rule/).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sumologic as sumologic

        first_seen_rule = sumologic.CseFirstSeenRule("first_seen_rule",
            baseline_type="PER_ENTITY",
            baseline_window_size="35000",
            description_expression="First User Login - {{ user_username }}",
            enabled=True,
            entity_selectors=[
                sumologic.CseFirstSeenRuleEntitySelectorArgs(
                    entity_type="_username",
                    expression="user_username",
                ),
                sumologic.CseFirstSeenRuleEntitySelectorArgs(
                    entity_type="_hostname",
                    expression="dstDevice_hostname",
                ),
            ],
            filter_expression="objectType=\\"Network\\"",
            group_by_fields=["user_username"],
            is_prototype=False,
            name="First User Login",
            name_expression="First User Login - {{ user_username }}",
            retention_window_size="86400000",
            severity=1,
            value_fields=["dstDevice_hostname"],
            suppression_window_size=2100000)
        ```

        ## Import

        First Seen Rules can be imported using the field id, e.g.:

        hcl

        ```sh
        $ pulumi import sumologic:index/cseFirstSeenRule:CseFirstSeenRule first_seen_rule id
        ```

        :param str resource_name: The name of the resource.
        :param CseFirstSeenRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CseFirstSeenRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 baseline_type: Optional[pulumi.Input[str]] = None,
                 baseline_window_size: Optional[pulumi.Input[str]] = None,
                 description_expression: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 entity_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CseFirstSeenRuleEntitySelectorArgs']]]]] = None,
                 filter_expression: Optional[pulumi.Input[str]] = None,
                 group_by_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 is_prototype: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_expression: Optional[pulumi.Input[str]] = None,
                 retention_window_size: Optional[pulumi.Input[str]] = None,
                 severity: Optional[pulumi.Input[int]] = None,
                 summary_expression: Optional[pulumi.Input[str]] = None,
                 suppression_window_size: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 value_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CseFirstSeenRuleArgs.__new__(CseFirstSeenRuleArgs)

            if baseline_type is None and not opts.urn:
                raise TypeError("Missing required property 'baseline_type'")
            __props__.__dict__["baseline_type"] = baseline_type
            if baseline_window_size is None and not opts.urn:
                raise TypeError("Missing required property 'baseline_window_size'")
            __props__.__dict__["baseline_window_size"] = baseline_window_size
            if description_expression is None and not opts.urn:
                raise TypeError("Missing required property 'description_expression'")
            __props__.__dict__["description_expression"] = description_expression
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            if entity_selectors is None and not opts.urn:
                raise TypeError("Missing required property 'entity_selectors'")
            __props__.__dict__["entity_selectors"] = entity_selectors
            if filter_expression is None and not opts.urn:
                raise TypeError("Missing required property 'filter_expression'")
            __props__.__dict__["filter_expression"] = filter_expression
            __props__.__dict__["group_by_fields"] = group_by_fields
            __props__.__dict__["is_prototype"] = is_prototype
            __props__.__dict__["name"] = name
            if name_expression is None and not opts.urn:
                raise TypeError("Missing required property 'name_expression'")
            __props__.__dict__["name_expression"] = name_expression
            if retention_window_size is None and not opts.urn:
                raise TypeError("Missing required property 'retention_window_size'")
            __props__.__dict__["retention_window_size"] = retention_window_size
            if severity is None and not opts.urn:
                raise TypeError("Missing required property 'severity'")
            __props__.__dict__["severity"] = severity
            __props__.__dict__["summary_expression"] = summary_expression
            __props__.__dict__["suppression_window_size"] = suppression_window_size
            __props__.__dict__["tags"] = tags
            if value_fields is None and not opts.urn:
                raise TypeError("Missing required property 'value_fields'")
            __props__.__dict__["value_fields"] = value_fields
        super(CseFirstSeenRule, __self__).__init__(
            'sumologic:index/cseFirstSeenRule:CseFirstSeenRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            baseline_type: Optional[pulumi.Input[str]] = None,
            baseline_window_size: Optional[pulumi.Input[str]] = None,
            description_expression: Optional[pulumi.Input[str]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            entity_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CseFirstSeenRuleEntitySelectorArgs']]]]] = None,
            filter_expression: Optional[pulumi.Input[str]] = None,
            group_by_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            is_prototype: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            name_expression: Optional[pulumi.Input[str]] = None,
            retention_window_size: Optional[pulumi.Input[str]] = None,
            severity: Optional[pulumi.Input[int]] = None,
            summary_expression: Optional[pulumi.Input[str]] = None,
            suppression_window_size: Optional[pulumi.Input[int]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            value_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'CseFirstSeenRule':
        """
        Get an existing CseFirstSeenRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] baseline_type: The baseline type. Current acceptable values are GLOBAL or PER_ENTITY
        :param pulumi.Input[str] baseline_window_size: The baseline window size in milliseconds
        :param pulumi.Input[str] description_expression: The description of the generated Signals
        :param pulumi.Input[bool] enabled: Whether the rule should generate Signals
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CseFirstSeenRuleEntitySelectorArgs']]]] entity_selectors: The entities to generate Signals on
               + `entityType` - (Required) The type of the entity to generate the Signal on
        :param pulumi.Input[str] filter_expression: The expression for which records to match on
        :param pulumi.Input[Sequence[pulumi.Input[str]]] group_by_fields: A list of fields to group records by
        :param pulumi.Input[bool] is_prototype: Whether the generated Signals should be prototype Signals
        :param pulumi.Input[str] name: The name of the Rule
        :param pulumi.Input[str] name_expression: The name of the generated Signals
        :param pulumi.Input[str] retention_window_size: The retention window size in milliseconds
        :param pulumi.Input[int] severity: The severity of the generated Signals
        :param pulumi.Input[str] summary_expression: The summary of the generated Signals
        :param pulumi.Input[int] suppression_window_size: For how long to suppress Signal generation, in milliseconds. Must be greater than 0 and less than the global limit of 7 days.
               
               The following attributes are exported:
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags of the generated Signals
        :param pulumi.Input[Sequence[pulumi.Input[str]]] value_fields: The value fields
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CseFirstSeenRuleState.__new__(_CseFirstSeenRuleState)

        __props__.__dict__["baseline_type"] = baseline_type
        __props__.__dict__["baseline_window_size"] = baseline_window_size
        __props__.__dict__["description_expression"] = description_expression
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["entity_selectors"] = entity_selectors
        __props__.__dict__["filter_expression"] = filter_expression
        __props__.__dict__["group_by_fields"] = group_by_fields
        __props__.__dict__["is_prototype"] = is_prototype
        __props__.__dict__["name"] = name
        __props__.__dict__["name_expression"] = name_expression
        __props__.__dict__["retention_window_size"] = retention_window_size
        __props__.__dict__["severity"] = severity
        __props__.__dict__["summary_expression"] = summary_expression
        __props__.__dict__["suppression_window_size"] = suppression_window_size
        __props__.__dict__["tags"] = tags
        __props__.__dict__["value_fields"] = value_fields
        return CseFirstSeenRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="baselineType")
    def baseline_type(self) -> pulumi.Output[str]:
        """
        The baseline type. Current acceptable values are GLOBAL or PER_ENTITY
        """
        return pulumi.get(self, "baseline_type")

    @property
    @pulumi.getter(name="baselineWindowSize")
    def baseline_window_size(self) -> pulumi.Output[str]:
        """
        The baseline window size in milliseconds
        """
        return pulumi.get(self, "baseline_window_size")

    @property
    @pulumi.getter(name="descriptionExpression")
    def description_expression(self) -> pulumi.Output[str]:
        """
        The description of the generated Signals
        """
        return pulumi.get(self, "description_expression")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[bool]:
        """
        Whether the rule should generate Signals
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="entitySelectors")
    def entity_selectors(self) -> pulumi.Output[Sequence['outputs.CseFirstSeenRuleEntitySelector']]:
        """
        The entities to generate Signals on
        + `entityType` - (Required) The type of the entity to generate the Signal on
        """
        return pulumi.get(self, "entity_selectors")

    @property
    @pulumi.getter(name="filterExpression")
    def filter_expression(self) -> pulumi.Output[str]:
        """
        The expression for which records to match on
        """
        return pulumi.get(self, "filter_expression")

    @property
    @pulumi.getter(name="groupByFields")
    def group_by_fields(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of fields to group records by
        """
        return pulumi.get(self, "group_by_fields")

    @property
    @pulumi.getter(name="isPrototype")
    def is_prototype(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the generated Signals should be prototype Signals
        """
        return pulumi.get(self, "is_prototype")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Rule
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nameExpression")
    def name_expression(self) -> pulumi.Output[str]:
        """
        The name of the generated Signals
        """
        return pulumi.get(self, "name_expression")

    @property
    @pulumi.getter(name="retentionWindowSize")
    def retention_window_size(self) -> pulumi.Output[str]:
        """
        The retention window size in milliseconds
        """
        return pulumi.get(self, "retention_window_size")

    @property
    @pulumi.getter
    def severity(self) -> pulumi.Output[int]:
        """
        The severity of the generated Signals
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter(name="summaryExpression")
    def summary_expression(self) -> pulumi.Output[Optional[str]]:
        """
        The summary of the generated Signals
        """
        return pulumi.get(self, "summary_expression")

    @property
    @pulumi.getter(name="suppressionWindowSize")
    def suppression_window_size(self) -> pulumi.Output[Optional[int]]:
        """
        For how long to suppress Signal generation, in milliseconds. Must be greater than 0 and less than the global limit of 7 days.

        The following attributes are exported:
        """
        return pulumi.get(self, "suppression_window_size")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The tags of the generated Signals
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="valueFields")
    def value_fields(self) -> pulumi.Output[Sequence[str]]:
        """
        The value fields
        """
        return pulumi.get(self, "value_fields")

