# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['CseInsightsResolutionArgs', 'CseInsightsResolution']

@pulumi.input_type
class CseInsightsResolutionArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parent: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a CseInsightsResolution resource.
        :param pulumi.Input[str] description: The description of the insights resolution.
        :param pulumi.Input[str] name: The name of the insights resolution.
        :param pulumi.Input[str] parent: The name of the built-in parent insights resolution. Supported values: "Resolved", "False Positive", "No Action", "Duplicate"
               
               
               The following attributes are exported:
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the insights resolution.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the insights resolution.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the built-in parent insights resolution. Supported values: "Resolved", "False Positive", "No Action", "Duplicate"


        The following attributes are exported:
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent", value)


@pulumi.input_type
class _CseInsightsResolutionState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parent: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering CseInsightsResolution resources.
        :param pulumi.Input[str] description: The description of the insights resolution.
        :param pulumi.Input[str] name: The name of the insights resolution.
        :param pulumi.Input[str] parent: The name of the built-in parent insights resolution. Supported values: "Resolved", "False Positive", "No Action", "Duplicate"
               
               
               The following attributes are exported:
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the insights resolution.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the insights resolution.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the built-in parent insights resolution. Supported values: "Resolved", "False Positive", "No Action", "Duplicate"


        The following attributes are exported:
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent", value)


class CseInsightsResolution(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parent: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Sumologic CSE Insights Resolution. When an insight gets closed, a resolution indicates why it got closed.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sumologic as sumologic

        insights_resolution = sumologic.CseInsightsResolution("insights_resolution",
            name="New Name",
            description="New description",
            parent="No Action")
        ```

        ## Import

        Insights Resolution can be imported using the field id, e.g.:

        hcl

        ```sh
        $ pulumi import sumologic:index/cseInsightsResolution:CseInsightsResolution insights_resolution id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the insights resolution.
        :param pulumi.Input[str] name: The name of the insights resolution.
        :param pulumi.Input[str] parent: The name of the built-in parent insights resolution. Supported values: "Resolved", "False Positive", "No Action", "Duplicate"
               
               
               The following attributes are exported:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[CseInsightsResolutionArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Sumologic CSE Insights Resolution. When an insight gets closed, a resolution indicates why it got closed.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sumologic as sumologic

        insights_resolution = sumologic.CseInsightsResolution("insights_resolution",
            name="New Name",
            description="New description",
            parent="No Action")
        ```

        ## Import

        Insights Resolution can be imported using the field id, e.g.:

        hcl

        ```sh
        $ pulumi import sumologic:index/cseInsightsResolution:CseInsightsResolution insights_resolution id
        ```

        :param str resource_name: The name of the resource.
        :param CseInsightsResolutionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CseInsightsResolutionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parent: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CseInsightsResolutionArgs.__new__(CseInsightsResolutionArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["parent"] = parent
        super(CseInsightsResolution, __self__).__init__(
            'sumologic:index/cseInsightsResolution:CseInsightsResolution',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            parent: Optional[pulumi.Input[str]] = None) -> 'CseInsightsResolution':
        """
        Get an existing CseInsightsResolution resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the insights resolution.
        :param pulumi.Input[str] name: The name of the insights resolution.
        :param pulumi.Input[str] parent: The name of the built-in parent insights resolution. Supported values: "Resolved", "False Positive", "No Action", "Duplicate"
               
               
               The following attributes are exported:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CseInsightsResolutionState.__new__(_CseInsightsResolutionState)

        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["parent"] = parent
        return CseInsightsResolution(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the insights resolution.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the insights resolution.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parent(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the built-in parent insights resolution. Supported values: "Resolved", "False Positive", "No Action", "Duplicate"


        The following attributes are exported:
        """
        return pulumi.get(self, "parent")

