# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetRoleV2Result',
    'AwaitableGetRoleV2Result',
    'get_role_v2',
    'get_role_v2_output',
]

@pulumi.output_type
class GetRoleV2Result:
    """
    A collection of values returned by getRoleV2.
    """
    def __init__(__self__, audit_data_filter=None, capabilities=None, description=None, id=None, log_analytics_filter=None, name=None, security_data_filter=None, selected_views=None, selection_type=None):
        if audit_data_filter and not isinstance(audit_data_filter, str):
            raise TypeError("Expected argument 'audit_data_filter' to be a str")
        pulumi.set(__self__, "audit_data_filter", audit_data_filter)
        if capabilities and not isinstance(capabilities, list):
            raise TypeError("Expected argument 'capabilities' to be a list")
        pulumi.set(__self__, "capabilities", capabilities)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if log_analytics_filter and not isinstance(log_analytics_filter, str):
            raise TypeError("Expected argument 'log_analytics_filter' to be a str")
        pulumi.set(__self__, "log_analytics_filter", log_analytics_filter)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if security_data_filter and not isinstance(security_data_filter, str):
            raise TypeError("Expected argument 'security_data_filter' to be a str")
        pulumi.set(__self__, "security_data_filter", security_data_filter)
        if selected_views and not isinstance(selected_views, list):
            raise TypeError("Expected argument 'selected_views' to be a list")
        pulumi.set(__self__, "selected_views", selected_views)
        if selection_type and not isinstance(selection_type, str):
            raise TypeError("Expected argument 'selection_type' to be a str")
        pulumi.set(__self__, "selection_type", selection_type)

    @property
    @pulumi.getter(name="auditDataFilter")
    def audit_data_filter(self) -> str:
        return pulumi.get(self, "audit_data_filter")

    @property
    @pulumi.getter
    def capabilities(self) -> Sequence[str]:
        return pulumi.get(self, "capabilities")

    @property
    @pulumi.getter
    def description(self) -> str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="logAnalyticsFilter")
    def log_analytics_filter(self) -> str:
        return pulumi.get(self, "log_analytics_filter")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="securityDataFilter")
    def security_data_filter(self) -> str:
        return pulumi.get(self, "security_data_filter")

    @property
    @pulumi.getter(name="selectedViews")
    def selected_views(self) -> Sequence['outputs.GetRoleV2SelectedViewResult']:
        return pulumi.get(self, "selected_views")

    @property
    @pulumi.getter(name="selectionType")
    def selection_type(self) -> str:
        return pulumi.get(self, "selection_type")


class AwaitableGetRoleV2Result(GetRoleV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRoleV2Result(
            audit_data_filter=self.audit_data_filter,
            capabilities=self.capabilities,
            description=self.description,
            id=self.id,
            log_analytics_filter=self.log_analytics_filter,
            name=self.name,
            security_data_filter=self.security_data_filter,
            selected_views=self.selected_views,
            selection_type=self.selection_type)


def get_role_v2(id: Optional[str] = None,
                name: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRoleV2Result:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_sumologic as sumologic

    this = sumologic.get_role_v2(name="MyRole")
    ```

    ```python
    import pulumi
    import pulumi_sumologic as sumologic

    that = sumologic.get_role_v2(id="1234567890")
    ```

    A role can be looked up by either `id` or `name`. One of those attributes needs to be specified.

    If both `id` and `name` have been specified, `id` takes precedence.

    ## Attributes reference

    The following attributes are exported:

    - `id` - The internal ID of the role. This can be used to create users having that role.
    - `name` - The name of the role.
    - `description` - The description of the role.
    - `capabilities` - The list of capabilities associated with the role.
    - `selected_views` - List of views with specific view level filters in accordance to the selectionType chosen.
    - `audit_data_filter` - The search filter which would be applied on partitions which belong to Audit Data product area. Help Doc : (https://help.sumologic.com/docs/manage/security/audit-index/).
    - `security_data_filter` - The search filter which would be applied on partitions which belong to Security Data product area.
    - `log_analytics_filter` - The search filter which would be applied on partitions which belong to Log Analytics product area.
    - `selection_type` - Describes the Permission Construct for the list of views in "selectedViews" parameter.
    ### Values in selection type are :
      - `All` selectionType would allow access to all views in the org.
      - `Allow` selectionType would allow access to specific views mentioned in "selectedViews" parameter.
      - `Deny` selectionType would deny access to specific views mentioned in "selectedViews" parameter.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sumologic:index/getRoleV2:getRoleV2', __args__, opts=opts, typ=GetRoleV2Result).value

    return AwaitableGetRoleV2Result(
        audit_data_filter=pulumi.get(__ret__, 'audit_data_filter'),
        capabilities=pulumi.get(__ret__, 'capabilities'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        log_analytics_filter=pulumi.get(__ret__, 'log_analytics_filter'),
        name=pulumi.get(__ret__, 'name'),
        security_data_filter=pulumi.get(__ret__, 'security_data_filter'),
        selected_views=pulumi.get(__ret__, 'selected_views'),
        selection_type=pulumi.get(__ret__, 'selection_type'))


@_utilities.lift_output_func(get_role_v2)
def get_role_v2_output(id: Optional[pulumi.Input[Optional[str]]] = None,
                       name: Optional[pulumi.Input[Optional[str]]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRoleV2Result]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_sumologic as sumologic

    this = sumologic.get_role_v2(name="MyRole")
    ```

    ```python
    import pulumi
    import pulumi_sumologic as sumologic

    that = sumologic.get_role_v2(id="1234567890")
    ```

    A role can be looked up by either `id` or `name`. One of those attributes needs to be specified.

    If both `id` and `name` have been specified, `id` takes precedence.

    ## Attributes reference

    The following attributes are exported:

    - `id` - The internal ID of the role. This can be used to create users having that role.
    - `name` - The name of the role.
    - `description` - The description of the role.
    - `capabilities` - The list of capabilities associated with the role.
    - `selected_views` - List of views with specific view level filters in accordance to the selectionType chosen.
    - `audit_data_filter` - The search filter which would be applied on partitions which belong to Audit Data product area. Help Doc : (https://help.sumologic.com/docs/manage/security/audit-index/).
    - `security_data_filter` - The search filter which would be applied on partitions which belong to Security Data product area.
    - `log_analytics_filter` - The search filter which would be applied on partitions which belong to Log Analytics product area.
    - `selection_type` - Describes the Permission Construct for the list of views in "selectedViews" parameter.
    ### Values in selection type are :
      - `All` selectionType would allow access to all views in the org.
      - `Allow` selectionType would allow access to specific views mentioned in "selectedViews" parameter.
      - `Deny` selectionType would deny access to specific views mentioned in "selectedViews" parameter.
    """
    ...
