# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetUserResult',
    'AwaitableGetUserResult',
    'get_user',
    'get_user_output',
]

@pulumi.output_type
class GetUserResult:
    """
    A collection of values returned by getUser.
    """
    def __init__(__self__, email=None, first_name=None, id=None, is_active=None, last_name=None, role_ids=None):
        if email and not isinstance(email, str):
            raise TypeError("Expected argument 'email' to be a str")
        pulumi.set(__self__, "email", email)
        if first_name and not isinstance(first_name, str):
            raise TypeError("Expected argument 'first_name' to be a str")
        pulumi.set(__self__, "first_name", first_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_active and not isinstance(is_active, bool):
            raise TypeError("Expected argument 'is_active' to be a bool")
        pulumi.set(__self__, "is_active", is_active)
        if last_name and not isinstance(last_name, str):
            raise TypeError("Expected argument 'last_name' to be a str")
        pulumi.set(__self__, "last_name", last_name)
        if role_ids and not isinstance(role_ids, list):
            raise TypeError("Expected argument 'role_ids' to be a list")
        pulumi.set(__self__, "role_ids", role_ids)

    @property
    @pulumi.getter
    def email(self) -> str:
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> str:
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isActive")
    def is_active(self) -> bool:
        return pulumi.get(self, "is_active")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> str:
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter(name="roleIds")
    def role_ids(self) -> Sequence[str]:
        return pulumi.get(self, "role_ids")


class AwaitableGetUserResult(GetUserResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserResult(
            email=self.email,
            first_name=self.first_name,
            id=self.id,
            is_active=self.is_active,
            last_name=self.last_name,
            role_ids=self.role_ids)


def get_user(email: Optional[str] = None,
             id: Optional[str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_sumologic as sumologic

    this = sumologic.get_user(id="1234567890")
    ```

    ```python
    import pulumi
    import pulumi_sumologic as sumologic

    that = sumologic.get_user(email="user@example.com")
    ```

    A user can be looked up by either `id` or `email`. One of those attributes needs to be specified.

    If both `id` and `email` have been specified, `id` takes precedence.

    ## Attributes reference

    The following attributes are exported:

    - `id` - The internal ID of the user.
    - `email` - (Required) Email of the user.
    - `first_name` - (Required) First name of the user.
    - `last_name` - (Required) Last name of the user.
    - `is_active` - (Required) This has the value true if the user is active and false if they have been deactivated.
    - `role_ids` - (Required) List of roleIds associated with the user.
    """
    __args__ = dict()
    __args__['email'] = email
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sumologic:index/getUser:getUser', __args__, opts=opts, typ=GetUserResult).value

    return AwaitableGetUserResult(
        email=pulumi.get(__ret__, 'email'),
        first_name=pulumi.get(__ret__, 'first_name'),
        id=pulumi.get(__ret__, 'id'),
        is_active=pulumi.get(__ret__, 'is_active'),
        last_name=pulumi.get(__ret__, 'last_name'),
        role_ids=pulumi.get(__ret__, 'role_ids'))


@_utilities.lift_output_func(get_user)
def get_user_output(email: Optional[pulumi.Input[Optional[str]]] = None,
                    id: Optional[pulumi.Input[Optional[str]]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetUserResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_sumologic as sumologic

    this = sumologic.get_user(id="1234567890")
    ```

    ```python
    import pulumi
    import pulumi_sumologic as sumologic

    that = sumologic.get_user(email="user@example.com")
    ```

    A user can be looked up by either `id` or `email`. One of those attributes needs to be specified.

    If both `id` and `email` have been specified, `id` takes precedence.

    ## Attributes reference

    The following attributes are exported:

    - `id` - The internal ID of the user.
    - `email` - (Required) Email of the user.
    - `first_name` - (Required) First name of the user.
    - `last_name` - (Required) Last name of the user.
    - `is_active` - (Required) This has the value true if the user is active and false if they have been deactivated.
    - `role_ids` - (Required) List of roleIds associated with the user.
    """
    ...
