# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['PartitionArgs', 'Partition']

@pulumi.input_type
class PartitionArgs:
    def __init__(__self__, *,
                 analytics_tier: Optional[pulumi.Input[str]] = None,
                 is_compliant: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 reduce_retention_period_immediately: Optional[pulumi.Input[bool]] = None,
                 retention_period: Optional[pulumi.Input[int]] = None,
                 routing_expression: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Partition resource.
        :param pulumi.Input[str] analytics_tier: The cloud flex analytics tier for your data; only relevant if your account has basic analytics enabled. If no value is supplied, partition will be created in continuous tier. Other possible values are : "frequent" and "infrequent".
        :param pulumi.Input[bool] is_compliant: Whether the partition is compliant or not. Mark a partition as compliant if it contains data used for compliance or audit purpose. Retention for a compliant partition can only be increased and cannot be reduced after the partition is marked compliant. A partition once marked compliant, cannot be marked non-compliant later.
        :param pulumi.Input[str] name: The name of the partition.
        :param pulumi.Input[bool] reduce_retention_period_immediately: This is required on update if the newly specified retention period is less than the existing retention period. In such a situation, a value of true says that data between the existing retention period and the new retention period should be deleted immediately; if false, such data will be deleted after seven days. This property is optional and ignored if the specified retentionPeriod is greater than or equal to the current retention period.
        :param pulumi.Input[int] retention_period: The number of days to retain data in the partition, or -1 to use the default value for your account. Only relevant if your account has variable retention enabled.
        :param pulumi.Input[str] routing_expression: The query that defines the data to be included in the partition.
        """
        if analytics_tier is not None:
            pulumi.set(__self__, "analytics_tier", analytics_tier)
        if is_compliant is not None:
            pulumi.set(__self__, "is_compliant", is_compliant)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if reduce_retention_period_immediately is not None:
            pulumi.set(__self__, "reduce_retention_period_immediately", reduce_retention_period_immediately)
        if retention_period is not None:
            pulumi.set(__self__, "retention_period", retention_period)
        if routing_expression is not None:
            pulumi.set(__self__, "routing_expression", routing_expression)

    @property
    @pulumi.getter(name="analyticsTier")
    def analytics_tier(self) -> Optional[pulumi.Input[str]]:
        """
        The cloud flex analytics tier for your data; only relevant if your account has basic analytics enabled. If no value is supplied, partition will be created in continuous tier. Other possible values are : "frequent" and "infrequent".
        """
        return pulumi.get(self, "analytics_tier")

    @analytics_tier.setter
    def analytics_tier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "analytics_tier", value)

    @property
    @pulumi.getter(name="isCompliant")
    def is_compliant(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the partition is compliant or not. Mark a partition as compliant if it contains data used for compliance or audit purpose. Retention for a compliant partition can only be increased and cannot be reduced after the partition is marked compliant. A partition once marked compliant, cannot be marked non-compliant later.
        """
        return pulumi.get(self, "is_compliant")

    @is_compliant.setter
    def is_compliant(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_compliant", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the partition.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="reduceRetentionPeriodImmediately")
    def reduce_retention_period_immediately(self) -> Optional[pulumi.Input[bool]]:
        """
        This is required on update if the newly specified retention period is less than the existing retention period. In such a situation, a value of true says that data between the existing retention period and the new retention period should be deleted immediately; if false, such data will be deleted after seven days. This property is optional and ignored if the specified retentionPeriod is greater than or equal to the current retention period.
        """
        return pulumi.get(self, "reduce_retention_period_immediately")

    @reduce_retention_period_immediately.setter
    def reduce_retention_period_immediately(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reduce_retention_period_immediately", value)

    @property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> Optional[pulumi.Input[int]]:
        """
        The number of days to retain data in the partition, or -1 to use the default value for your account. Only relevant if your account has variable retention enabled.
        """
        return pulumi.get(self, "retention_period")

    @retention_period.setter
    def retention_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retention_period", value)

    @property
    @pulumi.getter(name="routingExpression")
    def routing_expression(self) -> Optional[pulumi.Input[str]]:
        """
        The query that defines the data to be included in the partition.
        """
        return pulumi.get(self, "routing_expression")

    @routing_expression.setter
    def routing_expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "routing_expression", value)


@pulumi.input_type
class _PartitionState:
    def __init__(__self__, *,
                 analytics_tier: Optional[pulumi.Input[str]] = None,
                 data_forwarding_id: Optional[pulumi.Input[str]] = None,
                 index_type: Optional[pulumi.Input[str]] = None,
                 is_active: Optional[pulumi.Input[bool]] = None,
                 is_compliant: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 reduce_retention_period_immediately: Optional[pulumi.Input[bool]] = None,
                 retention_period: Optional[pulumi.Input[int]] = None,
                 routing_expression: Optional[pulumi.Input[str]] = None,
                 total_bytes: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering Partition resources.
        :param pulumi.Input[str] analytics_tier: The cloud flex analytics tier for your data; only relevant if your account has basic analytics enabled. If no value is supplied, partition will be created in continuous tier. Other possible values are : "frequent" and "infrequent".
        :param pulumi.Input[bool] is_compliant: Whether the partition is compliant or not. Mark a partition as compliant if it contains data used for compliance or audit purpose. Retention for a compliant partition can only be increased and cannot be reduced after the partition is marked compliant. A partition once marked compliant, cannot be marked non-compliant later.
        :param pulumi.Input[str] name: The name of the partition.
        :param pulumi.Input[bool] reduce_retention_period_immediately: This is required on update if the newly specified retention period is less than the existing retention period. In such a situation, a value of true says that data between the existing retention period and the new retention period should be deleted immediately; if false, such data will be deleted after seven days. This property is optional and ignored if the specified retentionPeriod is greater than or equal to the current retention period.
        :param pulumi.Input[int] retention_period: The number of days to retain data in the partition, or -1 to use the default value for your account. Only relevant if your account has variable retention enabled.
        :param pulumi.Input[str] routing_expression: The query that defines the data to be included in the partition.
        """
        if analytics_tier is not None:
            pulumi.set(__self__, "analytics_tier", analytics_tier)
        if data_forwarding_id is not None:
            pulumi.set(__self__, "data_forwarding_id", data_forwarding_id)
        if index_type is not None:
            pulumi.set(__self__, "index_type", index_type)
        if is_active is not None:
            pulumi.set(__self__, "is_active", is_active)
        if is_compliant is not None:
            pulumi.set(__self__, "is_compliant", is_compliant)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if reduce_retention_period_immediately is not None:
            pulumi.set(__self__, "reduce_retention_period_immediately", reduce_retention_period_immediately)
        if retention_period is not None:
            pulumi.set(__self__, "retention_period", retention_period)
        if routing_expression is not None:
            pulumi.set(__self__, "routing_expression", routing_expression)
        if total_bytes is not None:
            pulumi.set(__self__, "total_bytes", total_bytes)

    @property
    @pulumi.getter(name="analyticsTier")
    def analytics_tier(self) -> Optional[pulumi.Input[str]]:
        """
        The cloud flex analytics tier for your data; only relevant if your account has basic analytics enabled. If no value is supplied, partition will be created in continuous tier. Other possible values are : "frequent" and "infrequent".
        """
        return pulumi.get(self, "analytics_tier")

    @analytics_tier.setter
    def analytics_tier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "analytics_tier", value)

    @property
    @pulumi.getter(name="dataForwardingId")
    def data_forwarding_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "data_forwarding_id")

    @data_forwarding_id.setter
    def data_forwarding_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_forwarding_id", value)

    @property
    @pulumi.getter(name="indexType")
    def index_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "index_type")

    @index_type.setter
    def index_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "index_type", value)

    @property
    @pulumi.getter(name="isActive")
    def is_active(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "is_active")

    @is_active.setter
    def is_active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_active", value)

    @property
    @pulumi.getter(name="isCompliant")
    def is_compliant(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the partition is compliant or not. Mark a partition as compliant if it contains data used for compliance or audit purpose. Retention for a compliant partition can only be increased and cannot be reduced after the partition is marked compliant. A partition once marked compliant, cannot be marked non-compliant later.
        """
        return pulumi.get(self, "is_compliant")

    @is_compliant.setter
    def is_compliant(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_compliant", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the partition.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="reduceRetentionPeriodImmediately")
    def reduce_retention_period_immediately(self) -> Optional[pulumi.Input[bool]]:
        """
        This is required on update if the newly specified retention period is less than the existing retention period. In such a situation, a value of true says that data between the existing retention period and the new retention period should be deleted immediately; if false, such data will be deleted after seven days. This property is optional and ignored if the specified retentionPeriod is greater than or equal to the current retention period.
        """
        return pulumi.get(self, "reduce_retention_period_immediately")

    @reduce_retention_period_immediately.setter
    def reduce_retention_period_immediately(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reduce_retention_period_immediately", value)

    @property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> Optional[pulumi.Input[int]]:
        """
        The number of days to retain data in the partition, or -1 to use the default value for your account. Only relevant if your account has variable retention enabled.
        """
        return pulumi.get(self, "retention_period")

    @retention_period.setter
    def retention_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retention_period", value)

    @property
    @pulumi.getter(name="routingExpression")
    def routing_expression(self) -> Optional[pulumi.Input[str]]:
        """
        The query that defines the data to be included in the partition.
        """
        return pulumi.get(self, "routing_expression")

    @routing_expression.setter
    def routing_expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "routing_expression", value)

    @property
    @pulumi.getter(name="totalBytes")
    def total_bytes(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "total_bytes")

    @total_bytes.setter
    def total_bytes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "total_bytes", value)


class Partition(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 analytics_tier: Optional[pulumi.Input[str]] = None,
                 is_compliant: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 reduce_retention_period_immediately: Optional[pulumi.Input[bool]] = None,
                 retention_period: Optional[pulumi.Input[int]] = None,
                 routing_expression: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a [Sumologic Partition](https://help.sumologic.com/docs/manage/partitions-data-tiers/).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sumologic as sumologic

        example_partition = sumologic.Partition("examplePartition",
            name="examplePartition",
            routing_expression="_sourcecategory=*/IAC",
            analytics_tier="continuous",
            is_compliant=False)
        ```

        ## Attributes reference

        The following attributes are exported:

        - `id` - Unique identifier for the partition.

        ## Import

        Partitions can can be imported using the id. The list of partitions and their ids can be obtained using the Sumologic [partions api][2].

        hcl

        ```sh
        $ pulumi import sumologic:index/partition:Partition partition 1234567890
        ```

        [1]: https://help.sumologic.com/docs/manage/partitions-data-tiers/

        [2]: https://api.sumologic.com/docs/#operation/listPartitions

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] analytics_tier: The cloud flex analytics tier for your data; only relevant if your account has basic analytics enabled. If no value is supplied, partition will be created in continuous tier. Other possible values are : "frequent" and "infrequent".
        :param pulumi.Input[bool] is_compliant: Whether the partition is compliant or not. Mark a partition as compliant if it contains data used for compliance or audit purpose. Retention for a compliant partition can only be increased and cannot be reduced after the partition is marked compliant. A partition once marked compliant, cannot be marked non-compliant later.
        :param pulumi.Input[str] name: The name of the partition.
        :param pulumi.Input[bool] reduce_retention_period_immediately: This is required on update if the newly specified retention period is less than the existing retention period. In such a situation, a value of true says that data between the existing retention period and the new retention period should be deleted immediately; if false, such data will be deleted after seven days. This property is optional and ignored if the specified retentionPeriod is greater than or equal to the current retention period.
        :param pulumi.Input[int] retention_period: The number of days to retain data in the partition, or -1 to use the default value for your account. Only relevant if your account has variable retention enabled.
        :param pulumi.Input[str] routing_expression: The query that defines the data to be included in the partition.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[PartitionArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a [Sumologic Partition](https://help.sumologic.com/docs/manage/partitions-data-tiers/).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sumologic as sumologic

        example_partition = sumologic.Partition("examplePartition",
            name="examplePartition",
            routing_expression="_sourcecategory=*/IAC",
            analytics_tier="continuous",
            is_compliant=False)
        ```

        ## Attributes reference

        The following attributes are exported:

        - `id` - Unique identifier for the partition.

        ## Import

        Partitions can can be imported using the id. The list of partitions and their ids can be obtained using the Sumologic [partions api][2].

        hcl

        ```sh
        $ pulumi import sumologic:index/partition:Partition partition 1234567890
        ```

        [1]: https://help.sumologic.com/docs/manage/partitions-data-tiers/

        [2]: https://api.sumologic.com/docs/#operation/listPartitions

        :param str resource_name: The name of the resource.
        :param PartitionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PartitionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 analytics_tier: Optional[pulumi.Input[str]] = None,
                 is_compliant: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 reduce_retention_period_immediately: Optional[pulumi.Input[bool]] = None,
                 retention_period: Optional[pulumi.Input[int]] = None,
                 routing_expression: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PartitionArgs.__new__(PartitionArgs)

            __props__.__dict__["analytics_tier"] = analytics_tier
            __props__.__dict__["is_compliant"] = is_compliant
            __props__.__dict__["name"] = name
            __props__.__dict__["reduce_retention_period_immediately"] = reduce_retention_period_immediately
            __props__.__dict__["retention_period"] = retention_period
            __props__.__dict__["routing_expression"] = routing_expression
            __props__.__dict__["data_forwarding_id"] = None
            __props__.__dict__["index_type"] = None
            __props__.__dict__["is_active"] = None
            __props__.__dict__["total_bytes"] = None
        super(Partition, __self__).__init__(
            'sumologic:index/partition:Partition',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            analytics_tier: Optional[pulumi.Input[str]] = None,
            data_forwarding_id: Optional[pulumi.Input[str]] = None,
            index_type: Optional[pulumi.Input[str]] = None,
            is_active: Optional[pulumi.Input[bool]] = None,
            is_compliant: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            reduce_retention_period_immediately: Optional[pulumi.Input[bool]] = None,
            retention_period: Optional[pulumi.Input[int]] = None,
            routing_expression: Optional[pulumi.Input[str]] = None,
            total_bytes: Optional[pulumi.Input[int]] = None) -> 'Partition':
        """
        Get an existing Partition resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] analytics_tier: The cloud flex analytics tier for your data; only relevant if your account has basic analytics enabled. If no value is supplied, partition will be created in continuous tier. Other possible values are : "frequent" and "infrequent".
        :param pulumi.Input[bool] is_compliant: Whether the partition is compliant or not. Mark a partition as compliant if it contains data used for compliance or audit purpose. Retention for a compliant partition can only be increased and cannot be reduced after the partition is marked compliant. A partition once marked compliant, cannot be marked non-compliant later.
        :param pulumi.Input[str] name: The name of the partition.
        :param pulumi.Input[bool] reduce_retention_period_immediately: This is required on update if the newly specified retention period is less than the existing retention period. In such a situation, a value of true says that data between the existing retention period and the new retention period should be deleted immediately; if false, such data will be deleted after seven days. This property is optional and ignored if the specified retentionPeriod is greater than or equal to the current retention period.
        :param pulumi.Input[int] retention_period: The number of days to retain data in the partition, or -1 to use the default value for your account. Only relevant if your account has variable retention enabled.
        :param pulumi.Input[str] routing_expression: The query that defines the data to be included in the partition.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PartitionState.__new__(_PartitionState)

        __props__.__dict__["analytics_tier"] = analytics_tier
        __props__.__dict__["data_forwarding_id"] = data_forwarding_id
        __props__.__dict__["index_type"] = index_type
        __props__.__dict__["is_active"] = is_active
        __props__.__dict__["is_compliant"] = is_compliant
        __props__.__dict__["name"] = name
        __props__.__dict__["reduce_retention_period_immediately"] = reduce_retention_period_immediately
        __props__.__dict__["retention_period"] = retention_period
        __props__.__dict__["routing_expression"] = routing_expression
        __props__.__dict__["total_bytes"] = total_bytes
        return Partition(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="analyticsTier")
    def analytics_tier(self) -> pulumi.Output[Optional[str]]:
        """
        The cloud flex analytics tier for your data; only relevant if your account has basic analytics enabled. If no value is supplied, partition will be created in continuous tier. Other possible values are : "frequent" and "infrequent".
        """
        return pulumi.get(self, "analytics_tier")

    @property
    @pulumi.getter(name="dataForwardingId")
    def data_forwarding_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "data_forwarding_id")

    @property
    @pulumi.getter(name="indexType")
    def index_type(self) -> pulumi.Output[str]:
        return pulumi.get(self, "index_type")

    @property
    @pulumi.getter(name="isActive")
    def is_active(self) -> pulumi.Output[bool]:
        return pulumi.get(self, "is_active")

    @property
    @pulumi.getter(name="isCompliant")
    def is_compliant(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the partition is compliant or not. Mark a partition as compliant if it contains data used for compliance or audit purpose. Retention for a compliant partition can only be increased and cannot be reduced after the partition is marked compliant. A partition once marked compliant, cannot be marked non-compliant later.
        """
        return pulumi.get(self, "is_compliant")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the partition.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="reduceRetentionPeriodImmediately")
    def reduce_retention_period_immediately(self) -> pulumi.Output[Optional[bool]]:
        """
        This is required on update if the newly specified retention period is less than the existing retention period. In such a situation, a value of true says that data between the existing retention period and the new retention period should be deleted immediately; if false, such data will be deleted after seven days. This property is optional and ignored if the specified retentionPeriod is greater than or equal to the current retention period.
        """
        return pulumi.get(self, "reduce_retention_period_immediately")

    @property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> pulumi.Output[Optional[int]]:
        """
        The number of days to retain data in the partition, or -1 to use the default value for your account. Only relevant if your account has variable retention enabled.
        """
        return pulumi.get(self, "retention_period")

    @property
    @pulumi.getter(name="routingExpression")
    def routing_expression(self) -> pulumi.Output[Optional[str]]:
        """
        The query that defines the data to be included in the partition.
        """
        return pulumi.get(self, "routing_expression")

    @property
    @pulumi.getter(name="totalBytes")
    def total_bytes(self) -> pulumi.Output[int]:
        return pulumi.get(self, "total_bytes")

