# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PoliciesArgs', 'Policies']

@pulumi.input_type
class PoliciesArgs:
    def __init__(__self__, *,
                 audit: pulumi.Input[bool],
                 data_access_level: pulumi.Input[bool],
                 max_user_session_timeout: pulumi.Input[str],
                 search_audit: pulumi.Input[bool],
                 share_dashboards_outside_organization: pulumi.Input[bool],
                 user_concurrent_sessions_limit: pulumi.Input['PoliciesUserConcurrentSessionsLimitArgs']):
        """
        The set of arguments for constructing a Policies resource.
        :param pulumi.Input[bool] audit: Whether the [Audit Policy](https://help.sumologic.com/Manage/Security/Audit-Index) is enabled.
        :param pulumi.Input[bool] data_access_level: Whether the [Data Access Level Policy](https://help.sumologic.com/Manage/Security/Data_Access_Level_for_Shared_Dashboards) is enabled.
        :param pulumi.Input[str] max_user_session_timeout: The [maximum web session timeout](https://help.sumologic.com/Manage/Security/Set_a_Maximum_Web_Session_Timeout) users are able to configure within their user preferences.
        :param pulumi.Input[bool] search_audit: Whether the [Search Audit Policy](https://help.sumologic.com/Manage/Security/Search_Audit_Index) is enabled.
        :param pulumi.Input[bool] share_dashboards_outside_organization: Whether the [Share a Dashboard Outside Organization Policy](https://help.sumologic.com/Visualizations-and-Alerts/Dashboards/Share_Dashboards/Share_a_Dashboard_Outside_Your_Org) is enabled.
        :param pulumi.Input['PoliciesUserConcurrentSessionsLimitArgs'] user_concurrent_sessions_limit: The [User Concurrent Sessions Limit Policy](https://help.sumologic.com/Manage/Security/Set_a_Limit_for_User_Concurrent_Sessions). See user_concurrent_sessions_limit schema for details.
        """
        pulumi.set(__self__, "audit", audit)
        pulumi.set(__self__, "data_access_level", data_access_level)
        pulumi.set(__self__, "max_user_session_timeout", max_user_session_timeout)
        pulumi.set(__self__, "search_audit", search_audit)
        pulumi.set(__self__, "share_dashboards_outside_organization", share_dashboards_outside_organization)
        pulumi.set(__self__, "user_concurrent_sessions_limit", user_concurrent_sessions_limit)

    @property
    @pulumi.getter
    def audit(self) -> pulumi.Input[bool]:
        """
        Whether the [Audit Policy](https://help.sumologic.com/Manage/Security/Audit-Index) is enabled.
        """
        return pulumi.get(self, "audit")

    @audit.setter
    def audit(self, value: pulumi.Input[bool]):
        pulumi.set(self, "audit", value)

    @property
    @pulumi.getter(name="dataAccessLevel")
    def data_access_level(self) -> pulumi.Input[bool]:
        """
        Whether the [Data Access Level Policy](https://help.sumologic.com/Manage/Security/Data_Access_Level_for_Shared_Dashboards) is enabled.
        """
        return pulumi.get(self, "data_access_level")

    @data_access_level.setter
    def data_access_level(self, value: pulumi.Input[bool]):
        pulumi.set(self, "data_access_level", value)

    @property
    @pulumi.getter(name="maxUserSessionTimeout")
    def max_user_session_timeout(self) -> pulumi.Input[str]:
        """
        The [maximum web session timeout](https://help.sumologic.com/Manage/Security/Set_a_Maximum_Web_Session_Timeout) users are able to configure within their user preferences.
        """
        return pulumi.get(self, "max_user_session_timeout")

    @max_user_session_timeout.setter
    def max_user_session_timeout(self, value: pulumi.Input[str]):
        pulumi.set(self, "max_user_session_timeout", value)

    @property
    @pulumi.getter(name="searchAudit")
    def search_audit(self) -> pulumi.Input[bool]:
        """
        Whether the [Search Audit Policy](https://help.sumologic.com/Manage/Security/Search_Audit_Index) is enabled.
        """
        return pulumi.get(self, "search_audit")

    @search_audit.setter
    def search_audit(self, value: pulumi.Input[bool]):
        pulumi.set(self, "search_audit", value)

    @property
    @pulumi.getter(name="shareDashboardsOutsideOrganization")
    def share_dashboards_outside_organization(self) -> pulumi.Input[bool]:
        """
        Whether the [Share a Dashboard Outside Organization Policy](https://help.sumologic.com/Visualizations-and-Alerts/Dashboards/Share_Dashboards/Share_a_Dashboard_Outside_Your_Org) is enabled.
        """
        return pulumi.get(self, "share_dashboards_outside_organization")

    @share_dashboards_outside_organization.setter
    def share_dashboards_outside_organization(self, value: pulumi.Input[bool]):
        pulumi.set(self, "share_dashboards_outside_organization", value)

    @property
    @pulumi.getter(name="userConcurrentSessionsLimit")
    def user_concurrent_sessions_limit(self) -> pulumi.Input['PoliciesUserConcurrentSessionsLimitArgs']:
        """
        The [User Concurrent Sessions Limit Policy](https://help.sumologic.com/Manage/Security/Set_a_Limit_for_User_Concurrent_Sessions). See user_concurrent_sessions_limit schema for details.
        """
        return pulumi.get(self, "user_concurrent_sessions_limit")

    @user_concurrent_sessions_limit.setter
    def user_concurrent_sessions_limit(self, value: pulumi.Input['PoliciesUserConcurrentSessionsLimitArgs']):
        pulumi.set(self, "user_concurrent_sessions_limit", value)


@pulumi.input_type
class _PoliciesState:
    def __init__(__self__, *,
                 audit: Optional[pulumi.Input[bool]] = None,
                 data_access_level: Optional[pulumi.Input[bool]] = None,
                 max_user_session_timeout: Optional[pulumi.Input[str]] = None,
                 search_audit: Optional[pulumi.Input[bool]] = None,
                 share_dashboards_outside_organization: Optional[pulumi.Input[bool]] = None,
                 user_concurrent_sessions_limit: Optional[pulumi.Input['PoliciesUserConcurrentSessionsLimitArgs']] = None):
        """
        Input properties used for looking up and filtering Policies resources.
        :param pulumi.Input[bool] audit: Whether the [Audit Policy](https://help.sumologic.com/Manage/Security/Audit-Index) is enabled.
        :param pulumi.Input[bool] data_access_level: Whether the [Data Access Level Policy](https://help.sumologic.com/Manage/Security/Data_Access_Level_for_Shared_Dashboards) is enabled.
        :param pulumi.Input[str] max_user_session_timeout: The [maximum web session timeout](https://help.sumologic.com/Manage/Security/Set_a_Maximum_Web_Session_Timeout) users are able to configure within their user preferences.
        :param pulumi.Input[bool] search_audit: Whether the [Search Audit Policy](https://help.sumologic.com/Manage/Security/Search_Audit_Index) is enabled.
        :param pulumi.Input[bool] share_dashboards_outside_organization: Whether the [Share a Dashboard Outside Organization Policy](https://help.sumologic.com/Visualizations-and-Alerts/Dashboards/Share_Dashboards/Share_a_Dashboard_Outside_Your_Org) is enabled.
        :param pulumi.Input['PoliciesUserConcurrentSessionsLimitArgs'] user_concurrent_sessions_limit: The [User Concurrent Sessions Limit Policy](https://help.sumologic.com/Manage/Security/Set_a_Limit_for_User_Concurrent_Sessions). See user_concurrent_sessions_limit schema for details.
        """
        if audit is not None:
            pulumi.set(__self__, "audit", audit)
        if data_access_level is not None:
            pulumi.set(__self__, "data_access_level", data_access_level)
        if max_user_session_timeout is not None:
            pulumi.set(__self__, "max_user_session_timeout", max_user_session_timeout)
        if search_audit is not None:
            pulumi.set(__self__, "search_audit", search_audit)
        if share_dashboards_outside_organization is not None:
            pulumi.set(__self__, "share_dashboards_outside_organization", share_dashboards_outside_organization)
        if user_concurrent_sessions_limit is not None:
            pulumi.set(__self__, "user_concurrent_sessions_limit", user_concurrent_sessions_limit)

    @property
    @pulumi.getter
    def audit(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the [Audit Policy](https://help.sumologic.com/Manage/Security/Audit-Index) is enabled.
        """
        return pulumi.get(self, "audit")

    @audit.setter
    def audit(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "audit", value)

    @property
    @pulumi.getter(name="dataAccessLevel")
    def data_access_level(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the [Data Access Level Policy](https://help.sumologic.com/Manage/Security/Data_Access_Level_for_Shared_Dashboards) is enabled.
        """
        return pulumi.get(self, "data_access_level")

    @data_access_level.setter
    def data_access_level(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "data_access_level", value)

    @property
    @pulumi.getter(name="maxUserSessionTimeout")
    def max_user_session_timeout(self) -> Optional[pulumi.Input[str]]:
        """
        The [maximum web session timeout](https://help.sumologic.com/Manage/Security/Set_a_Maximum_Web_Session_Timeout) users are able to configure within their user preferences.
        """
        return pulumi.get(self, "max_user_session_timeout")

    @max_user_session_timeout.setter
    def max_user_session_timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_user_session_timeout", value)

    @property
    @pulumi.getter(name="searchAudit")
    def search_audit(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the [Search Audit Policy](https://help.sumologic.com/Manage/Security/Search_Audit_Index) is enabled.
        """
        return pulumi.get(self, "search_audit")

    @search_audit.setter
    def search_audit(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "search_audit", value)

    @property
    @pulumi.getter(name="shareDashboardsOutsideOrganization")
    def share_dashboards_outside_organization(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the [Share a Dashboard Outside Organization Policy](https://help.sumologic.com/Visualizations-and-Alerts/Dashboards/Share_Dashboards/Share_a_Dashboard_Outside_Your_Org) is enabled.
        """
        return pulumi.get(self, "share_dashboards_outside_organization")

    @share_dashboards_outside_organization.setter
    def share_dashboards_outside_organization(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "share_dashboards_outside_organization", value)

    @property
    @pulumi.getter(name="userConcurrentSessionsLimit")
    def user_concurrent_sessions_limit(self) -> Optional[pulumi.Input['PoliciesUserConcurrentSessionsLimitArgs']]:
        """
        The [User Concurrent Sessions Limit Policy](https://help.sumologic.com/Manage/Security/Set_a_Limit_for_User_Concurrent_Sessions). See user_concurrent_sessions_limit schema for details.
        """
        return pulumi.get(self, "user_concurrent_sessions_limit")

    @user_concurrent_sessions_limit.setter
    def user_concurrent_sessions_limit(self, value: Optional[pulumi.Input['PoliciesUserConcurrentSessionsLimitArgs']]):
        pulumi.set(self, "user_concurrent_sessions_limit", value)


class Policies(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audit: Optional[pulumi.Input[bool]] = None,
                 data_access_level: Optional[pulumi.Input[bool]] = None,
                 max_user_session_timeout: Optional[pulumi.Input[str]] = None,
                 search_audit: Optional[pulumi.Input[bool]] = None,
                 share_dashboards_outside_organization: Optional[pulumi.Input[bool]] = None,
                 user_concurrent_sessions_limit: Optional[pulumi.Input[pulumi.InputType['PoliciesUserConcurrentSessionsLimitArgs']]] = None,
                 __props__=None):
        """
        Sets the Sumologic Policies. Since each policy is global for the entire organization, please ensure that only a single
        instance of this resource is defined. The behavior for defining more than one policies resource is undefined.

        The following policies are supported:
        - [Audit Policy](https://help.sumologic.com/Manage/Security/Audit-Index)
        - [Data Access Level Policy](https://help.sumologic.com/Manage/Security/Data_Access_Level_for_Shared_Dashboards)
        - [Maximum Web Session Timeout Policy](https://help.sumologic.com/Manage/Security/Set_a_Maximum_Web_Session_Timeout)
        - [Search Audit Policy](https://help.sumologic.com/Manage/Security/Search_Audit_Index)
        - [Share a Dashboard Outside Organization Policy](https://help.sumologic.com/Visualizations-and-Alerts/Dashboards/Share_Dashboards/Share_a_Dashboard_Outside_Your_Org)
        - [User Concurrent Sessions Limit Policy](https://help.sumologic.com/Manage/Security/Set_a_Limit_for_User_Concurrent_Sessions)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sumologic as sumologic

        example_policies = sumologic.Policies("example_policies",
            audit=False,
            data_access_level=False,
            max_user_session_timeout="7d",
            search_audit=False,
            share_dashboards_outside_organization=False,
            user_concurrent_sessions_limit=sumologic.PoliciesUserConcurrentSessionsLimitArgs(
                enabled=False,
                max_concurrent_sessions=100,
            ))
        ```

        ## Import

        Policies can be imported using the id `org-policies`.

        hcl

        ```sh
        $ pulumi import sumologic:index/policies:Policies example_policies org-policies
        ```

        [1]: https://help.sumologic.com/Manage/Security/Audit-Index

        [2]: https://help.sumologic.com/Manage/Security/Data_Access_Level_for_Shared_Dashboards

        [3]: https://help.sumologic.com/Manage/Security/Set_a_Maximum_Web_Session_Timeout

        [4]: https://help.sumologic.com/Manage/Security/Search_Audit_Index

        [5]: https://help.sumologic.com/Visualizations-and-Alerts/Dashboards/Share_Dashboards/Share_a_Dashboard_Outside_Your_Org

        [6]: https://help.sumologic.com/Manage/Security/Set_a_Limit_for_User_Concurrent_Sessions

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] audit: Whether the [Audit Policy](https://help.sumologic.com/Manage/Security/Audit-Index) is enabled.
        :param pulumi.Input[bool] data_access_level: Whether the [Data Access Level Policy](https://help.sumologic.com/Manage/Security/Data_Access_Level_for_Shared_Dashboards) is enabled.
        :param pulumi.Input[str] max_user_session_timeout: The [maximum web session timeout](https://help.sumologic.com/Manage/Security/Set_a_Maximum_Web_Session_Timeout) users are able to configure within their user preferences.
        :param pulumi.Input[bool] search_audit: Whether the [Search Audit Policy](https://help.sumologic.com/Manage/Security/Search_Audit_Index) is enabled.
        :param pulumi.Input[bool] share_dashboards_outside_organization: Whether the [Share a Dashboard Outside Organization Policy](https://help.sumologic.com/Visualizations-and-Alerts/Dashboards/Share_Dashboards/Share_a_Dashboard_Outside_Your_Org) is enabled.
        :param pulumi.Input[pulumi.InputType['PoliciesUserConcurrentSessionsLimitArgs']] user_concurrent_sessions_limit: The [User Concurrent Sessions Limit Policy](https://help.sumologic.com/Manage/Security/Set_a_Limit_for_User_Concurrent_Sessions). See user_concurrent_sessions_limit schema for details.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PoliciesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Sets the Sumologic Policies. Since each policy is global for the entire organization, please ensure that only a single
        instance of this resource is defined. The behavior for defining more than one policies resource is undefined.

        The following policies are supported:
        - [Audit Policy](https://help.sumologic.com/Manage/Security/Audit-Index)
        - [Data Access Level Policy](https://help.sumologic.com/Manage/Security/Data_Access_Level_for_Shared_Dashboards)
        - [Maximum Web Session Timeout Policy](https://help.sumologic.com/Manage/Security/Set_a_Maximum_Web_Session_Timeout)
        - [Search Audit Policy](https://help.sumologic.com/Manage/Security/Search_Audit_Index)
        - [Share a Dashboard Outside Organization Policy](https://help.sumologic.com/Visualizations-and-Alerts/Dashboards/Share_Dashboards/Share_a_Dashboard_Outside_Your_Org)
        - [User Concurrent Sessions Limit Policy](https://help.sumologic.com/Manage/Security/Set_a_Limit_for_User_Concurrent_Sessions)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sumologic as sumologic

        example_policies = sumologic.Policies("example_policies",
            audit=False,
            data_access_level=False,
            max_user_session_timeout="7d",
            search_audit=False,
            share_dashboards_outside_organization=False,
            user_concurrent_sessions_limit=sumologic.PoliciesUserConcurrentSessionsLimitArgs(
                enabled=False,
                max_concurrent_sessions=100,
            ))
        ```

        ## Import

        Policies can be imported using the id `org-policies`.

        hcl

        ```sh
        $ pulumi import sumologic:index/policies:Policies example_policies org-policies
        ```

        [1]: https://help.sumologic.com/Manage/Security/Audit-Index

        [2]: https://help.sumologic.com/Manage/Security/Data_Access_Level_for_Shared_Dashboards

        [3]: https://help.sumologic.com/Manage/Security/Set_a_Maximum_Web_Session_Timeout

        [4]: https://help.sumologic.com/Manage/Security/Search_Audit_Index

        [5]: https://help.sumologic.com/Visualizations-and-Alerts/Dashboards/Share_Dashboards/Share_a_Dashboard_Outside_Your_Org

        [6]: https://help.sumologic.com/Manage/Security/Set_a_Limit_for_User_Concurrent_Sessions

        :param str resource_name: The name of the resource.
        :param PoliciesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PoliciesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audit: Optional[pulumi.Input[bool]] = None,
                 data_access_level: Optional[pulumi.Input[bool]] = None,
                 max_user_session_timeout: Optional[pulumi.Input[str]] = None,
                 search_audit: Optional[pulumi.Input[bool]] = None,
                 share_dashboards_outside_organization: Optional[pulumi.Input[bool]] = None,
                 user_concurrent_sessions_limit: Optional[pulumi.Input[pulumi.InputType['PoliciesUserConcurrentSessionsLimitArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PoliciesArgs.__new__(PoliciesArgs)

            if audit is None and not opts.urn:
                raise TypeError("Missing required property 'audit'")
            __props__.__dict__["audit"] = audit
            if data_access_level is None and not opts.urn:
                raise TypeError("Missing required property 'data_access_level'")
            __props__.__dict__["data_access_level"] = data_access_level
            if max_user_session_timeout is None and not opts.urn:
                raise TypeError("Missing required property 'max_user_session_timeout'")
            __props__.__dict__["max_user_session_timeout"] = max_user_session_timeout
            if search_audit is None and not opts.urn:
                raise TypeError("Missing required property 'search_audit'")
            __props__.__dict__["search_audit"] = search_audit
            if share_dashboards_outside_organization is None and not opts.urn:
                raise TypeError("Missing required property 'share_dashboards_outside_organization'")
            __props__.__dict__["share_dashboards_outside_organization"] = share_dashboards_outside_organization
            if user_concurrent_sessions_limit is None and not opts.urn:
                raise TypeError("Missing required property 'user_concurrent_sessions_limit'")
            __props__.__dict__["user_concurrent_sessions_limit"] = user_concurrent_sessions_limit
        super(Policies, __self__).__init__(
            'sumologic:index/policies:Policies',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            audit: Optional[pulumi.Input[bool]] = None,
            data_access_level: Optional[pulumi.Input[bool]] = None,
            max_user_session_timeout: Optional[pulumi.Input[str]] = None,
            search_audit: Optional[pulumi.Input[bool]] = None,
            share_dashboards_outside_organization: Optional[pulumi.Input[bool]] = None,
            user_concurrent_sessions_limit: Optional[pulumi.Input[pulumi.InputType['PoliciesUserConcurrentSessionsLimitArgs']]] = None) -> 'Policies':
        """
        Get an existing Policies resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] audit: Whether the [Audit Policy](https://help.sumologic.com/Manage/Security/Audit-Index) is enabled.
        :param pulumi.Input[bool] data_access_level: Whether the [Data Access Level Policy](https://help.sumologic.com/Manage/Security/Data_Access_Level_for_Shared_Dashboards) is enabled.
        :param pulumi.Input[str] max_user_session_timeout: The [maximum web session timeout](https://help.sumologic.com/Manage/Security/Set_a_Maximum_Web_Session_Timeout) users are able to configure within their user preferences.
        :param pulumi.Input[bool] search_audit: Whether the [Search Audit Policy](https://help.sumologic.com/Manage/Security/Search_Audit_Index) is enabled.
        :param pulumi.Input[bool] share_dashboards_outside_organization: Whether the [Share a Dashboard Outside Organization Policy](https://help.sumologic.com/Visualizations-and-Alerts/Dashboards/Share_Dashboards/Share_a_Dashboard_Outside_Your_Org) is enabled.
        :param pulumi.Input[pulumi.InputType['PoliciesUserConcurrentSessionsLimitArgs']] user_concurrent_sessions_limit: The [User Concurrent Sessions Limit Policy](https://help.sumologic.com/Manage/Security/Set_a_Limit_for_User_Concurrent_Sessions). See user_concurrent_sessions_limit schema for details.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PoliciesState.__new__(_PoliciesState)

        __props__.__dict__["audit"] = audit
        __props__.__dict__["data_access_level"] = data_access_level
        __props__.__dict__["max_user_session_timeout"] = max_user_session_timeout
        __props__.__dict__["search_audit"] = search_audit
        __props__.__dict__["share_dashboards_outside_organization"] = share_dashboards_outside_organization
        __props__.__dict__["user_concurrent_sessions_limit"] = user_concurrent_sessions_limit
        return Policies(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def audit(self) -> pulumi.Output[bool]:
        """
        Whether the [Audit Policy](https://help.sumologic.com/Manage/Security/Audit-Index) is enabled.
        """
        return pulumi.get(self, "audit")

    @property
    @pulumi.getter(name="dataAccessLevel")
    def data_access_level(self) -> pulumi.Output[bool]:
        """
        Whether the [Data Access Level Policy](https://help.sumologic.com/Manage/Security/Data_Access_Level_for_Shared_Dashboards) is enabled.
        """
        return pulumi.get(self, "data_access_level")

    @property
    @pulumi.getter(name="maxUserSessionTimeout")
    def max_user_session_timeout(self) -> pulumi.Output[str]:
        """
        The [maximum web session timeout](https://help.sumologic.com/Manage/Security/Set_a_Maximum_Web_Session_Timeout) users are able to configure within their user preferences.
        """
        return pulumi.get(self, "max_user_session_timeout")

    @property
    @pulumi.getter(name="searchAudit")
    def search_audit(self) -> pulumi.Output[bool]:
        """
        Whether the [Search Audit Policy](https://help.sumologic.com/Manage/Security/Search_Audit_Index) is enabled.
        """
        return pulumi.get(self, "search_audit")

    @property
    @pulumi.getter(name="shareDashboardsOutsideOrganization")
    def share_dashboards_outside_organization(self) -> pulumi.Output[bool]:
        """
        Whether the [Share a Dashboard Outside Organization Policy](https://help.sumologic.com/Visualizations-and-Alerts/Dashboards/Share_Dashboards/Share_a_Dashboard_Outside_Your_Org) is enabled.
        """
        return pulumi.get(self, "share_dashboards_outside_organization")

    @property
    @pulumi.getter(name="userConcurrentSessionsLimit")
    def user_concurrent_sessions_limit(self) -> pulumi.Output['outputs.PoliciesUserConcurrentSessionsLimit']:
        """
        The [User Concurrent Sessions Limit Policy](https://help.sumologic.com/Manage/Security/Set_a_Limit_for_User_Concurrent_Sessions). See user_concurrent_sessions_limit schema for details.
        """
        return pulumi.get(self, "user_concurrent_sessions_limit")

