# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RoleV2Args', 'RoleV2']

@pulumi.input_type
class RoleV2Args:
    def __init__(__self__, *,
                 audit_data_filter: Optional[pulumi.Input[str]] = None,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 log_analytics_filter: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 security_data_filter: Optional[pulumi.Input[str]] = None,
                 selected_views: Optional[pulumi.Input[Sequence[pulumi.Input['RoleV2SelectedViewArgs']]]] = None,
                 selection_type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a RoleV2 resource.
        :param pulumi.Input[str] audit_data_filter: A search filter which would be applied on partitions which belong to Audit Data product area. Help Doc : (https://help.sumologic.com/docs/manage/security/audit-index/).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] capabilities: List of [capabilities](https://help.sumologic.com/docs/manage/users-roles/roles/role-capabilities/) associated with this role.
        :param pulumi.Input[str] description: Description of the role.
        :param pulumi.Input[str] log_analytics_filter: A search filter which would be applied on partitions which belong to Log Analytics product area.
        :param pulumi.Input[str] name: Name of the role.
        :param pulumi.Input[str] security_data_filter: A search filter which would be applied on partitions which belong to Security Data product area.
        :param pulumi.Input[Sequence[pulumi.Input['RoleV2SelectedViewArgs']]] selected_views: List of views with specific view level filters in accordance to the selectionType chosen.
        :param pulumi.Input[str] selection_type: Describes the Permission Construct for the list of views in "selectedViews" parameter.
        """
        if audit_data_filter is not None:
            pulumi.set(__self__, "audit_data_filter", audit_data_filter)
        if capabilities is not None:
            pulumi.set(__self__, "capabilities", capabilities)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if log_analytics_filter is not None:
            pulumi.set(__self__, "log_analytics_filter", log_analytics_filter)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if security_data_filter is not None:
            pulumi.set(__self__, "security_data_filter", security_data_filter)
        if selected_views is not None:
            pulumi.set(__self__, "selected_views", selected_views)
        if selection_type is not None:
            pulumi.set(__self__, "selection_type", selection_type)

    @property
    @pulumi.getter(name="auditDataFilter")
    def audit_data_filter(self) -> Optional[pulumi.Input[str]]:
        """
        A search filter which would be applied on partitions which belong to Audit Data product area. Help Doc : (https://help.sumologic.com/docs/manage/security/audit-index/).
        """
        return pulumi.get(self, "audit_data_filter")

    @audit_data_filter.setter
    def audit_data_filter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "audit_data_filter", value)

    @property
    @pulumi.getter
    def capabilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of [capabilities](https://help.sumologic.com/docs/manage/users-roles/roles/role-capabilities/) associated with this role.
        """
        return pulumi.get(self, "capabilities")

    @capabilities.setter
    def capabilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "capabilities", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the role.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="logAnalyticsFilter")
    def log_analytics_filter(self) -> Optional[pulumi.Input[str]]:
        """
        A search filter which would be applied on partitions which belong to Log Analytics product area.
        """
        return pulumi.get(self, "log_analytics_filter")

    @log_analytics_filter.setter
    def log_analytics_filter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_analytics_filter", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the role.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="securityDataFilter")
    def security_data_filter(self) -> Optional[pulumi.Input[str]]:
        """
        A search filter which would be applied on partitions which belong to Security Data product area.
        """
        return pulumi.get(self, "security_data_filter")

    @security_data_filter.setter
    def security_data_filter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_data_filter", value)

    @property
    @pulumi.getter(name="selectedViews")
    def selected_views(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RoleV2SelectedViewArgs']]]]:
        """
        List of views with specific view level filters in accordance to the selectionType chosen.
        """
        return pulumi.get(self, "selected_views")

    @selected_views.setter
    def selected_views(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RoleV2SelectedViewArgs']]]]):
        pulumi.set(self, "selected_views", value)

    @property
    @pulumi.getter(name="selectionType")
    def selection_type(self) -> Optional[pulumi.Input[str]]:
        """
        Describes the Permission Construct for the list of views in "selectedViews" parameter.
        """
        return pulumi.get(self, "selection_type")

    @selection_type.setter
    def selection_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "selection_type", value)


@pulumi.input_type
class _RoleV2State:
    def __init__(__self__, *,
                 audit_data_filter: Optional[pulumi.Input[str]] = None,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 log_analytics_filter: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 security_data_filter: Optional[pulumi.Input[str]] = None,
                 selected_views: Optional[pulumi.Input[Sequence[pulumi.Input['RoleV2SelectedViewArgs']]]] = None,
                 selection_type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering RoleV2 resources.
        :param pulumi.Input[str] audit_data_filter: A search filter which would be applied on partitions which belong to Audit Data product area. Help Doc : (https://help.sumologic.com/docs/manage/security/audit-index/).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] capabilities: List of [capabilities](https://help.sumologic.com/docs/manage/users-roles/roles/role-capabilities/) associated with this role.
        :param pulumi.Input[str] description: Description of the role.
        :param pulumi.Input[str] log_analytics_filter: A search filter which would be applied on partitions which belong to Log Analytics product area.
        :param pulumi.Input[str] name: Name of the role.
        :param pulumi.Input[str] security_data_filter: A search filter which would be applied on partitions which belong to Security Data product area.
        :param pulumi.Input[Sequence[pulumi.Input['RoleV2SelectedViewArgs']]] selected_views: List of views with specific view level filters in accordance to the selectionType chosen.
        :param pulumi.Input[str] selection_type: Describes the Permission Construct for the list of views in "selectedViews" parameter.
        """
        if audit_data_filter is not None:
            pulumi.set(__self__, "audit_data_filter", audit_data_filter)
        if capabilities is not None:
            pulumi.set(__self__, "capabilities", capabilities)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if log_analytics_filter is not None:
            pulumi.set(__self__, "log_analytics_filter", log_analytics_filter)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if security_data_filter is not None:
            pulumi.set(__self__, "security_data_filter", security_data_filter)
        if selected_views is not None:
            pulumi.set(__self__, "selected_views", selected_views)
        if selection_type is not None:
            pulumi.set(__self__, "selection_type", selection_type)

    @property
    @pulumi.getter(name="auditDataFilter")
    def audit_data_filter(self) -> Optional[pulumi.Input[str]]:
        """
        A search filter which would be applied on partitions which belong to Audit Data product area. Help Doc : (https://help.sumologic.com/docs/manage/security/audit-index/).
        """
        return pulumi.get(self, "audit_data_filter")

    @audit_data_filter.setter
    def audit_data_filter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "audit_data_filter", value)

    @property
    @pulumi.getter
    def capabilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of [capabilities](https://help.sumologic.com/docs/manage/users-roles/roles/role-capabilities/) associated with this role.
        """
        return pulumi.get(self, "capabilities")

    @capabilities.setter
    def capabilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "capabilities", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the role.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="logAnalyticsFilter")
    def log_analytics_filter(self) -> Optional[pulumi.Input[str]]:
        """
        A search filter which would be applied on partitions which belong to Log Analytics product area.
        """
        return pulumi.get(self, "log_analytics_filter")

    @log_analytics_filter.setter
    def log_analytics_filter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_analytics_filter", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the role.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="securityDataFilter")
    def security_data_filter(self) -> Optional[pulumi.Input[str]]:
        """
        A search filter which would be applied on partitions which belong to Security Data product area.
        """
        return pulumi.get(self, "security_data_filter")

    @security_data_filter.setter
    def security_data_filter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_data_filter", value)

    @property
    @pulumi.getter(name="selectedViews")
    def selected_views(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RoleV2SelectedViewArgs']]]]:
        """
        List of views with specific view level filters in accordance to the selectionType chosen.
        """
        return pulumi.get(self, "selected_views")

    @selected_views.setter
    def selected_views(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RoleV2SelectedViewArgs']]]]):
        pulumi.set(self, "selected_views", value)

    @property
    @pulumi.getter(name="selectionType")
    def selection_type(self) -> Optional[pulumi.Input[str]]:
        """
        Describes the Permission Construct for the list of views in "selectedViews" parameter.
        """
        return pulumi.get(self, "selection_type")

    @selection_type.setter
    def selection_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "selection_type", value)


class RoleV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audit_data_filter: Optional[pulumi.Input[str]] = None,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 log_analytics_filter: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 security_data_filter: Optional[pulumi.Input[str]] = None,
                 selected_views: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RoleV2SelectedViewArgs']]]]] = None,
                 selection_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provider to manage Sumologic Role v2

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] audit_data_filter: A search filter which would be applied on partitions which belong to Audit Data product area. Help Doc : (https://help.sumologic.com/docs/manage/security/audit-index/).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] capabilities: List of [capabilities](https://help.sumologic.com/docs/manage/users-roles/roles/role-capabilities/) associated with this role.
        :param pulumi.Input[str] description: Description of the role.
        :param pulumi.Input[str] log_analytics_filter: A search filter which would be applied on partitions which belong to Log Analytics product area.
        :param pulumi.Input[str] name: Name of the role.
        :param pulumi.Input[str] security_data_filter: A search filter which would be applied on partitions which belong to Security Data product area.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RoleV2SelectedViewArgs']]]] selected_views: List of views with specific view level filters in accordance to the selectionType chosen.
        :param pulumi.Input[str] selection_type: Describes the Permission Construct for the list of views in "selectedViews" parameter.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[RoleV2Args] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provider to manage Sumologic Role v2

        :param str resource_name: The name of the resource.
        :param RoleV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RoleV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audit_data_filter: Optional[pulumi.Input[str]] = None,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 log_analytics_filter: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 security_data_filter: Optional[pulumi.Input[str]] = None,
                 selected_views: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RoleV2SelectedViewArgs']]]]] = None,
                 selection_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RoleV2Args.__new__(RoleV2Args)

            __props__.__dict__["audit_data_filter"] = audit_data_filter
            __props__.__dict__["capabilities"] = capabilities
            __props__.__dict__["description"] = description
            __props__.__dict__["log_analytics_filter"] = log_analytics_filter
            __props__.__dict__["name"] = name
            __props__.__dict__["security_data_filter"] = security_data_filter
            __props__.__dict__["selected_views"] = selected_views
            __props__.__dict__["selection_type"] = selection_type
        super(RoleV2, __self__).__init__(
            'sumologic:index/roleV2:RoleV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            audit_data_filter: Optional[pulumi.Input[str]] = None,
            capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            log_analytics_filter: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            security_data_filter: Optional[pulumi.Input[str]] = None,
            selected_views: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RoleV2SelectedViewArgs']]]]] = None,
            selection_type: Optional[pulumi.Input[str]] = None) -> 'RoleV2':
        """
        Get an existing RoleV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] audit_data_filter: A search filter which would be applied on partitions which belong to Audit Data product area. Help Doc : (https://help.sumologic.com/docs/manage/security/audit-index/).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] capabilities: List of [capabilities](https://help.sumologic.com/docs/manage/users-roles/roles/role-capabilities/) associated with this role.
        :param pulumi.Input[str] description: Description of the role.
        :param pulumi.Input[str] log_analytics_filter: A search filter which would be applied on partitions which belong to Log Analytics product area.
        :param pulumi.Input[str] name: Name of the role.
        :param pulumi.Input[str] security_data_filter: A search filter which would be applied on partitions which belong to Security Data product area.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RoleV2SelectedViewArgs']]]] selected_views: List of views with specific view level filters in accordance to the selectionType chosen.
        :param pulumi.Input[str] selection_type: Describes the Permission Construct for the list of views in "selectedViews" parameter.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RoleV2State.__new__(_RoleV2State)

        __props__.__dict__["audit_data_filter"] = audit_data_filter
        __props__.__dict__["capabilities"] = capabilities
        __props__.__dict__["description"] = description
        __props__.__dict__["log_analytics_filter"] = log_analytics_filter
        __props__.__dict__["name"] = name
        __props__.__dict__["security_data_filter"] = security_data_filter
        __props__.__dict__["selected_views"] = selected_views
        __props__.__dict__["selection_type"] = selection_type
        return RoleV2(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="auditDataFilter")
    def audit_data_filter(self) -> pulumi.Output[Optional[str]]:
        """
        A search filter which would be applied on partitions which belong to Audit Data product area. Help Doc : (https://help.sumologic.com/docs/manage/security/audit-index/).
        """
        return pulumi.get(self, "audit_data_filter")

    @property
    @pulumi.getter
    def capabilities(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of [capabilities](https://help.sumologic.com/docs/manage/users-roles/roles/role-capabilities/) associated with this role.
        """
        return pulumi.get(self, "capabilities")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the role.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="logAnalyticsFilter")
    def log_analytics_filter(self) -> pulumi.Output[Optional[str]]:
        """
        A search filter which would be applied on partitions which belong to Log Analytics product area.
        """
        return pulumi.get(self, "log_analytics_filter")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the role.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="securityDataFilter")
    def security_data_filter(self) -> pulumi.Output[Optional[str]]:
        """
        A search filter which would be applied on partitions which belong to Security Data product area.
        """
        return pulumi.get(self, "security_data_filter")

    @property
    @pulumi.getter(name="selectedViews")
    def selected_views(self) -> pulumi.Output[Optional[Sequence['outputs.RoleV2SelectedView']]]:
        """
        List of views with specific view level filters in accordance to the selectionType chosen.
        """
        return pulumi.get(self, "selected_views")

    @property
    @pulumi.getter(name="selectionType")
    def selection_type(self) -> pulumi.Output[Optional[str]]:
        """
        Describes the Permission Construct for the list of views in "selectedViews" parameter.
        """
        return pulumi.get(self, "selection_type")

