# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SamlConfigurationArgs', 'SamlConfiguration']

@pulumi.input_type
class SamlConfigurationArgs:
    def __init__(__self__, *,
                 configuration_name: pulumi.Input[str],
                 issuer: pulumi.Input[str],
                 x509cert1: pulumi.Input[str],
                 authn_request_url: Optional[pulumi.Input[str]] = None,
                 debug_mode: Optional[pulumi.Input[bool]] = None,
                 disable_requested_authn_context: Optional[pulumi.Input[bool]] = None,
                 email_attribute: Optional[pulumi.Input[str]] = None,
                 is_redirect_binding: Optional[pulumi.Input[bool]] = None,
                 logout_enabled: Optional[pulumi.Input[bool]] = None,
                 logout_url: Optional[pulumi.Input[str]] = None,
                 on_demand_provisioning_enabled: Optional[pulumi.Input['SamlConfigurationOnDemandProvisioningEnabledArgs']] = None,
                 roles_attribute: Optional[pulumi.Input[str]] = None,
                 sign_authn_request: Optional[pulumi.Input[bool]] = None,
                 sp_initiated_login_enabled: Optional[pulumi.Input[bool]] = None,
                 sp_initiated_login_path: Optional[pulumi.Input[str]] = None,
                 x509cert2: Optional[pulumi.Input[str]] = None,
                 x509cert3: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SamlConfiguration resource.
        :param pulumi.Input[str] configuration_name: Name of the SSO policy or another name used to describe the policy internally.
        :param pulumi.Input[str] issuer: The unique URL assigned to the organization by the SAML Identity Provider.
        :param pulumi.Input[str] x509cert1: The certificate is used to verify the signature in SAML assertions.
        :param pulumi.Input[str] authn_request_url: The URL that the identity provider has assigned for Sumo Logic to submit SAML authentication requests to the identity provider. Defaults to "".
        :param pulumi.Input[bool] debug_mode: True if additional details are included when a user fails to sign in. Defaults to false.
        :param pulumi.Input[bool] disable_requested_authn_context: True if Sumo Logic will include the RequestedAuthnContext element of the SAML AuthnRequests it sends to the identity provider. Defaults to false.
        :param pulumi.Input[str] email_attribute: The email address of the new user account. Defaults to "".
        :param pulumi.Input[bool] is_redirect_binding: True if the SAML binding is of HTTP Redirect type. Defaults to false.
        :param pulumi.Input[bool] logout_enabled: True if users are redirected to a URL after signing out of Sumo Logic. Defaults to false.
        :param pulumi.Input[str] logout_url: The URL that users will be redirected to after signing out of Sumo Logic. Defaults to "".
        :param pulumi.Input['SamlConfigurationOnDemandProvisioningEnabledArgs'] on_demand_provisioning_enabled: The configuration for on-demand provisioning. See on_demand_provisioning_enabled schema for details.
        :param pulumi.Input[str] roles_attribute: The role that Sumo Logic will assign to users when they sign in. Defaults to "".
        :param pulumi.Input[bool] sign_authn_request: True if Sumo Logic will send signed Authn requests to the identity provider. Defaults to false.
        :param pulumi.Input[bool] sp_initiated_login_enabled: True if Sumo Logic redirects users to your identity provider with a SAML AuthnRequest when signing in. Defaults to false.
        :param pulumi.Input[str] sp_initiated_login_path: The identifier used to generate a unique URL for user login. Defaults to "".
        :param pulumi.Input[str] x509cert2: The backup certificate used to verify the signature in SAML assertions when x509cert1 expires. Defaults to "".
        :param pulumi.Input[str] x509cert3: The backup certificate used to verify the signature in SAML assertions when x509cert1 expires and x509cert2 is empty. Defaults to "".
        """
        pulumi.set(__self__, "configuration_name", configuration_name)
        pulumi.set(__self__, "issuer", issuer)
        pulumi.set(__self__, "x509cert1", x509cert1)
        if authn_request_url is not None:
            pulumi.set(__self__, "authn_request_url", authn_request_url)
        if debug_mode is not None:
            pulumi.set(__self__, "debug_mode", debug_mode)
        if disable_requested_authn_context is not None:
            pulumi.set(__self__, "disable_requested_authn_context", disable_requested_authn_context)
        if email_attribute is not None:
            pulumi.set(__self__, "email_attribute", email_attribute)
        if is_redirect_binding is not None:
            pulumi.set(__self__, "is_redirect_binding", is_redirect_binding)
        if logout_enabled is not None:
            pulumi.set(__self__, "logout_enabled", logout_enabled)
        if logout_url is not None:
            pulumi.set(__self__, "logout_url", logout_url)
        if on_demand_provisioning_enabled is not None:
            pulumi.set(__self__, "on_demand_provisioning_enabled", on_demand_provisioning_enabled)
        if roles_attribute is not None:
            pulumi.set(__self__, "roles_attribute", roles_attribute)
        if sign_authn_request is not None:
            pulumi.set(__self__, "sign_authn_request", sign_authn_request)
        if sp_initiated_login_enabled is not None:
            pulumi.set(__self__, "sp_initiated_login_enabled", sp_initiated_login_enabled)
        if sp_initiated_login_path is not None:
            pulumi.set(__self__, "sp_initiated_login_path", sp_initiated_login_path)
        if x509cert2 is not None:
            pulumi.set(__self__, "x509cert2", x509cert2)
        if x509cert3 is not None:
            pulumi.set(__self__, "x509cert3", x509cert3)

    @property
    @pulumi.getter(name="configurationName")
    def configuration_name(self) -> pulumi.Input[str]:
        """
        Name of the SSO policy or another name used to describe the policy internally.
        """
        return pulumi.get(self, "configuration_name")

    @configuration_name.setter
    def configuration_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "configuration_name", value)

    @property
    @pulumi.getter
    def issuer(self) -> pulumi.Input[str]:
        """
        The unique URL assigned to the organization by the SAML Identity Provider.
        """
        return pulumi.get(self, "issuer")

    @issuer.setter
    def issuer(self, value: pulumi.Input[str]):
        pulumi.set(self, "issuer", value)

    @property
    @pulumi.getter
    def x509cert1(self) -> pulumi.Input[str]:
        """
        The certificate is used to verify the signature in SAML assertions.
        """
        return pulumi.get(self, "x509cert1")

    @x509cert1.setter
    def x509cert1(self, value: pulumi.Input[str]):
        pulumi.set(self, "x509cert1", value)

    @property
    @pulumi.getter(name="authnRequestUrl")
    def authn_request_url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL that the identity provider has assigned for Sumo Logic to submit SAML authentication requests to the identity provider. Defaults to "".
        """
        return pulumi.get(self, "authn_request_url")

    @authn_request_url.setter
    def authn_request_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authn_request_url", value)

    @property
    @pulumi.getter(name="debugMode")
    def debug_mode(self) -> Optional[pulumi.Input[bool]]:
        """
        True if additional details are included when a user fails to sign in. Defaults to false.
        """
        return pulumi.get(self, "debug_mode")

    @debug_mode.setter
    def debug_mode(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "debug_mode", value)

    @property
    @pulumi.getter(name="disableRequestedAuthnContext")
    def disable_requested_authn_context(self) -> Optional[pulumi.Input[bool]]:
        """
        True if Sumo Logic will include the RequestedAuthnContext element of the SAML AuthnRequests it sends to the identity provider. Defaults to false.
        """
        return pulumi.get(self, "disable_requested_authn_context")

    @disable_requested_authn_context.setter
    def disable_requested_authn_context(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_requested_authn_context", value)

    @property
    @pulumi.getter(name="emailAttribute")
    def email_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        The email address of the new user account. Defaults to "".
        """
        return pulumi.get(self, "email_attribute")

    @email_attribute.setter
    def email_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email_attribute", value)

    @property
    @pulumi.getter(name="isRedirectBinding")
    def is_redirect_binding(self) -> Optional[pulumi.Input[bool]]:
        """
        True if the SAML binding is of HTTP Redirect type. Defaults to false.
        """
        return pulumi.get(self, "is_redirect_binding")

    @is_redirect_binding.setter
    def is_redirect_binding(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_redirect_binding", value)

    @property
    @pulumi.getter(name="logoutEnabled")
    def logout_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        True if users are redirected to a URL after signing out of Sumo Logic. Defaults to false.
        """
        return pulumi.get(self, "logout_enabled")

    @logout_enabled.setter
    def logout_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "logout_enabled", value)

    @property
    @pulumi.getter(name="logoutUrl")
    def logout_url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL that users will be redirected to after signing out of Sumo Logic. Defaults to "".
        """
        return pulumi.get(self, "logout_url")

    @logout_url.setter
    def logout_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logout_url", value)

    @property
    @pulumi.getter(name="onDemandProvisioningEnabled")
    def on_demand_provisioning_enabled(self) -> Optional[pulumi.Input['SamlConfigurationOnDemandProvisioningEnabledArgs']]:
        """
        The configuration for on-demand provisioning. See on_demand_provisioning_enabled schema for details.
        """
        return pulumi.get(self, "on_demand_provisioning_enabled")

    @on_demand_provisioning_enabled.setter
    def on_demand_provisioning_enabled(self, value: Optional[pulumi.Input['SamlConfigurationOnDemandProvisioningEnabledArgs']]):
        pulumi.set(self, "on_demand_provisioning_enabled", value)

    @property
    @pulumi.getter(name="rolesAttribute")
    def roles_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        The role that Sumo Logic will assign to users when they sign in. Defaults to "".
        """
        return pulumi.get(self, "roles_attribute")

    @roles_attribute.setter
    def roles_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "roles_attribute", value)

    @property
    @pulumi.getter(name="signAuthnRequest")
    def sign_authn_request(self) -> Optional[pulumi.Input[bool]]:
        """
        True if Sumo Logic will send signed Authn requests to the identity provider. Defaults to false.
        """
        return pulumi.get(self, "sign_authn_request")

    @sign_authn_request.setter
    def sign_authn_request(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sign_authn_request", value)

    @property
    @pulumi.getter(name="spInitiatedLoginEnabled")
    def sp_initiated_login_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        True if Sumo Logic redirects users to your identity provider with a SAML AuthnRequest when signing in. Defaults to false.
        """
        return pulumi.get(self, "sp_initiated_login_enabled")

    @sp_initiated_login_enabled.setter
    def sp_initiated_login_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sp_initiated_login_enabled", value)

    @property
    @pulumi.getter(name="spInitiatedLoginPath")
    def sp_initiated_login_path(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier used to generate a unique URL for user login. Defaults to "".
        """
        return pulumi.get(self, "sp_initiated_login_path")

    @sp_initiated_login_path.setter
    def sp_initiated_login_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sp_initiated_login_path", value)

    @property
    @pulumi.getter
    def x509cert2(self) -> Optional[pulumi.Input[str]]:
        """
        The backup certificate used to verify the signature in SAML assertions when x509cert1 expires. Defaults to "".
        """
        return pulumi.get(self, "x509cert2")

    @x509cert2.setter
    def x509cert2(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "x509cert2", value)

    @property
    @pulumi.getter
    def x509cert3(self) -> Optional[pulumi.Input[str]]:
        """
        The backup certificate used to verify the signature in SAML assertions when x509cert1 expires and x509cert2 is empty. Defaults to "".
        """
        return pulumi.get(self, "x509cert3")

    @x509cert3.setter
    def x509cert3(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "x509cert3", value)


@pulumi.input_type
class _SamlConfigurationState:
    def __init__(__self__, *,
                 assertion_consumer_url: Optional[pulumi.Input[str]] = None,
                 authn_request_url: Optional[pulumi.Input[str]] = None,
                 certificate: Optional[pulumi.Input[str]] = None,
                 configuration_name: Optional[pulumi.Input[str]] = None,
                 debug_mode: Optional[pulumi.Input[bool]] = None,
                 disable_requested_authn_context: Optional[pulumi.Input[bool]] = None,
                 email_attribute: Optional[pulumi.Input[str]] = None,
                 entity_id: Optional[pulumi.Input[str]] = None,
                 is_redirect_binding: Optional[pulumi.Input[bool]] = None,
                 issuer: Optional[pulumi.Input[str]] = None,
                 logout_enabled: Optional[pulumi.Input[bool]] = None,
                 logout_url: Optional[pulumi.Input[str]] = None,
                 on_demand_provisioning_enabled: Optional[pulumi.Input['SamlConfigurationOnDemandProvisioningEnabledArgs']] = None,
                 roles_attribute: Optional[pulumi.Input[str]] = None,
                 sign_authn_request: Optional[pulumi.Input[bool]] = None,
                 sp_initiated_login_enabled: Optional[pulumi.Input[bool]] = None,
                 sp_initiated_login_path: Optional[pulumi.Input[str]] = None,
                 x509cert1: Optional[pulumi.Input[str]] = None,
                 x509cert2: Optional[pulumi.Input[str]] = None,
                 x509cert3: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SamlConfiguration resources.
        :param pulumi.Input[str] authn_request_url: The URL that the identity provider has assigned for Sumo Logic to submit SAML authentication requests to the identity provider. Defaults to "".
        :param pulumi.Input[str] configuration_name: Name of the SSO policy or another name used to describe the policy internally.
        :param pulumi.Input[bool] debug_mode: True if additional details are included when a user fails to sign in. Defaults to false.
        :param pulumi.Input[bool] disable_requested_authn_context: True if Sumo Logic will include the RequestedAuthnContext element of the SAML AuthnRequests it sends to the identity provider. Defaults to false.
        :param pulumi.Input[str] email_attribute: The email address of the new user account. Defaults to "".
        :param pulumi.Input[bool] is_redirect_binding: True if the SAML binding is of HTTP Redirect type. Defaults to false.
        :param pulumi.Input[str] issuer: The unique URL assigned to the organization by the SAML Identity Provider.
        :param pulumi.Input[bool] logout_enabled: True if users are redirected to a URL after signing out of Sumo Logic. Defaults to false.
        :param pulumi.Input[str] logout_url: The URL that users will be redirected to after signing out of Sumo Logic. Defaults to "".
        :param pulumi.Input['SamlConfigurationOnDemandProvisioningEnabledArgs'] on_demand_provisioning_enabled: The configuration for on-demand provisioning. See on_demand_provisioning_enabled schema for details.
        :param pulumi.Input[str] roles_attribute: The role that Sumo Logic will assign to users when they sign in. Defaults to "".
        :param pulumi.Input[bool] sign_authn_request: True if Sumo Logic will send signed Authn requests to the identity provider. Defaults to false.
        :param pulumi.Input[bool] sp_initiated_login_enabled: True if Sumo Logic redirects users to your identity provider with a SAML AuthnRequest when signing in. Defaults to false.
        :param pulumi.Input[str] sp_initiated_login_path: The identifier used to generate a unique URL for user login. Defaults to "".
        :param pulumi.Input[str] x509cert1: The certificate is used to verify the signature in SAML assertions.
        :param pulumi.Input[str] x509cert2: The backup certificate used to verify the signature in SAML assertions when x509cert1 expires. Defaults to "".
        :param pulumi.Input[str] x509cert3: The backup certificate used to verify the signature in SAML assertions when x509cert1 expires and x509cert2 is empty. Defaults to "".
        """
        if assertion_consumer_url is not None:
            pulumi.set(__self__, "assertion_consumer_url", assertion_consumer_url)
        if authn_request_url is not None:
            pulumi.set(__self__, "authn_request_url", authn_request_url)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if configuration_name is not None:
            pulumi.set(__self__, "configuration_name", configuration_name)
        if debug_mode is not None:
            pulumi.set(__self__, "debug_mode", debug_mode)
        if disable_requested_authn_context is not None:
            pulumi.set(__self__, "disable_requested_authn_context", disable_requested_authn_context)
        if email_attribute is not None:
            pulumi.set(__self__, "email_attribute", email_attribute)
        if entity_id is not None:
            pulumi.set(__self__, "entity_id", entity_id)
        if is_redirect_binding is not None:
            pulumi.set(__self__, "is_redirect_binding", is_redirect_binding)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)
        if logout_enabled is not None:
            pulumi.set(__self__, "logout_enabled", logout_enabled)
        if logout_url is not None:
            pulumi.set(__self__, "logout_url", logout_url)
        if on_demand_provisioning_enabled is not None:
            pulumi.set(__self__, "on_demand_provisioning_enabled", on_demand_provisioning_enabled)
        if roles_attribute is not None:
            pulumi.set(__self__, "roles_attribute", roles_attribute)
        if sign_authn_request is not None:
            pulumi.set(__self__, "sign_authn_request", sign_authn_request)
        if sp_initiated_login_enabled is not None:
            pulumi.set(__self__, "sp_initiated_login_enabled", sp_initiated_login_enabled)
        if sp_initiated_login_path is not None:
            pulumi.set(__self__, "sp_initiated_login_path", sp_initiated_login_path)
        if x509cert1 is not None:
            pulumi.set(__self__, "x509cert1", x509cert1)
        if x509cert2 is not None:
            pulumi.set(__self__, "x509cert2", x509cert2)
        if x509cert3 is not None:
            pulumi.set(__self__, "x509cert3", x509cert3)

    @property
    @pulumi.getter(name="assertionConsumerUrl")
    def assertion_consumer_url(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "assertion_consumer_url")

    @assertion_consumer_url.setter
    def assertion_consumer_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "assertion_consumer_url", value)

    @property
    @pulumi.getter(name="authnRequestUrl")
    def authn_request_url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL that the identity provider has assigned for Sumo Logic to submit SAML authentication requests to the identity provider. Defaults to "".
        """
        return pulumi.get(self, "authn_request_url")

    @authn_request_url.setter
    def authn_request_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authn_request_url", value)

    @property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate", value)

    @property
    @pulumi.getter(name="configurationName")
    def configuration_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the SSO policy or another name used to describe the policy internally.
        """
        return pulumi.get(self, "configuration_name")

    @configuration_name.setter
    def configuration_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configuration_name", value)

    @property
    @pulumi.getter(name="debugMode")
    def debug_mode(self) -> Optional[pulumi.Input[bool]]:
        """
        True if additional details are included when a user fails to sign in. Defaults to false.
        """
        return pulumi.get(self, "debug_mode")

    @debug_mode.setter
    def debug_mode(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "debug_mode", value)

    @property
    @pulumi.getter(name="disableRequestedAuthnContext")
    def disable_requested_authn_context(self) -> Optional[pulumi.Input[bool]]:
        """
        True if Sumo Logic will include the RequestedAuthnContext element of the SAML AuthnRequests it sends to the identity provider. Defaults to false.
        """
        return pulumi.get(self, "disable_requested_authn_context")

    @disable_requested_authn_context.setter
    def disable_requested_authn_context(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_requested_authn_context", value)

    @property
    @pulumi.getter(name="emailAttribute")
    def email_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        The email address of the new user account. Defaults to "".
        """
        return pulumi.get(self, "email_attribute")

    @email_attribute.setter
    def email_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email_attribute", value)

    @property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "entity_id")

    @entity_id.setter
    def entity_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entity_id", value)

    @property
    @pulumi.getter(name="isRedirectBinding")
    def is_redirect_binding(self) -> Optional[pulumi.Input[bool]]:
        """
        True if the SAML binding is of HTTP Redirect type. Defaults to false.
        """
        return pulumi.get(self, "is_redirect_binding")

    @is_redirect_binding.setter
    def is_redirect_binding(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_redirect_binding", value)

    @property
    @pulumi.getter
    def issuer(self) -> Optional[pulumi.Input[str]]:
        """
        The unique URL assigned to the organization by the SAML Identity Provider.
        """
        return pulumi.get(self, "issuer")

    @issuer.setter
    def issuer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issuer", value)

    @property
    @pulumi.getter(name="logoutEnabled")
    def logout_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        True if users are redirected to a URL after signing out of Sumo Logic. Defaults to false.
        """
        return pulumi.get(self, "logout_enabled")

    @logout_enabled.setter
    def logout_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "logout_enabled", value)

    @property
    @pulumi.getter(name="logoutUrl")
    def logout_url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL that users will be redirected to after signing out of Sumo Logic. Defaults to "".
        """
        return pulumi.get(self, "logout_url")

    @logout_url.setter
    def logout_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logout_url", value)

    @property
    @pulumi.getter(name="onDemandProvisioningEnabled")
    def on_demand_provisioning_enabled(self) -> Optional[pulumi.Input['SamlConfigurationOnDemandProvisioningEnabledArgs']]:
        """
        The configuration for on-demand provisioning. See on_demand_provisioning_enabled schema for details.
        """
        return pulumi.get(self, "on_demand_provisioning_enabled")

    @on_demand_provisioning_enabled.setter
    def on_demand_provisioning_enabled(self, value: Optional[pulumi.Input['SamlConfigurationOnDemandProvisioningEnabledArgs']]):
        pulumi.set(self, "on_demand_provisioning_enabled", value)

    @property
    @pulumi.getter(name="rolesAttribute")
    def roles_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        The role that Sumo Logic will assign to users when they sign in. Defaults to "".
        """
        return pulumi.get(self, "roles_attribute")

    @roles_attribute.setter
    def roles_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "roles_attribute", value)

    @property
    @pulumi.getter(name="signAuthnRequest")
    def sign_authn_request(self) -> Optional[pulumi.Input[bool]]:
        """
        True if Sumo Logic will send signed Authn requests to the identity provider. Defaults to false.
        """
        return pulumi.get(self, "sign_authn_request")

    @sign_authn_request.setter
    def sign_authn_request(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sign_authn_request", value)

    @property
    @pulumi.getter(name="spInitiatedLoginEnabled")
    def sp_initiated_login_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        True if Sumo Logic redirects users to your identity provider with a SAML AuthnRequest when signing in. Defaults to false.
        """
        return pulumi.get(self, "sp_initiated_login_enabled")

    @sp_initiated_login_enabled.setter
    def sp_initiated_login_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sp_initiated_login_enabled", value)

    @property
    @pulumi.getter(name="spInitiatedLoginPath")
    def sp_initiated_login_path(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier used to generate a unique URL for user login. Defaults to "".
        """
        return pulumi.get(self, "sp_initiated_login_path")

    @sp_initiated_login_path.setter
    def sp_initiated_login_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sp_initiated_login_path", value)

    @property
    @pulumi.getter
    def x509cert1(self) -> Optional[pulumi.Input[str]]:
        """
        The certificate is used to verify the signature in SAML assertions.
        """
        return pulumi.get(self, "x509cert1")

    @x509cert1.setter
    def x509cert1(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "x509cert1", value)

    @property
    @pulumi.getter
    def x509cert2(self) -> Optional[pulumi.Input[str]]:
        """
        The backup certificate used to verify the signature in SAML assertions when x509cert1 expires. Defaults to "".
        """
        return pulumi.get(self, "x509cert2")

    @x509cert2.setter
    def x509cert2(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "x509cert2", value)

    @property
    @pulumi.getter
    def x509cert3(self) -> Optional[pulumi.Input[str]]:
        """
        The backup certificate used to verify the signature in SAML assertions when x509cert1 expires and x509cert2 is empty. Defaults to "".
        """
        return pulumi.get(self, "x509cert3")

    @x509cert3.setter
    def x509cert3(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "x509cert3", value)


class SamlConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authn_request_url: Optional[pulumi.Input[str]] = None,
                 configuration_name: Optional[pulumi.Input[str]] = None,
                 debug_mode: Optional[pulumi.Input[bool]] = None,
                 disable_requested_authn_context: Optional[pulumi.Input[bool]] = None,
                 email_attribute: Optional[pulumi.Input[str]] = None,
                 is_redirect_binding: Optional[pulumi.Input[bool]] = None,
                 issuer: Optional[pulumi.Input[str]] = None,
                 logout_enabled: Optional[pulumi.Input[bool]] = None,
                 logout_url: Optional[pulumi.Input[str]] = None,
                 on_demand_provisioning_enabled: Optional[pulumi.Input[pulumi.InputType['SamlConfigurationOnDemandProvisioningEnabledArgs']]] = None,
                 roles_attribute: Optional[pulumi.Input[str]] = None,
                 sign_authn_request: Optional[pulumi.Input[bool]] = None,
                 sp_initiated_login_enabled: Optional[pulumi.Input[bool]] = None,
                 sp_initiated_login_path: Optional[pulumi.Input[str]] = None,
                 x509cert1: Optional[pulumi.Input[str]] = None,
                 x509cert2: Optional[pulumi.Input[str]] = None,
                 x509cert3: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a [Sumologic SAML Configuration](https://help.sumologic.com/Manage/Security/SAML/01-Set-Up-SAML-for-Single-Sign-On).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sumologic as sumologic

        example_saml_configuration = sumologic.SamlConfiguration("exampleSamlConfiguration",
            sp_initiated_login_path="",
            configuration_name="SumoLogic",
            issuer="http://www.okta.com/abxcseyuiwelflkdjh",
            sp_initiated_login_enabled=False,
            authn_request_url="",
            x509cert1="string",
            x509cert2="",
            x509cert3="",
            on_demand_provisioning_enabled=sumologic.SamlConfigurationOnDemandProvisioningEnabledArgs(
                first_name_attribute="firstName",
                last_name_attribute="lastName",
                on_demand_provisioning_roles=["Administrator"],
            ),
            roles_attribute="Administrator",
            logout_enabled=False,
            logout_url="",
            email_attribute="",
            debug_mode=False,
            sign_authn_request=False,
            disable_requested_authn_context=False,
            is_redirect_binding=False)
        ```

        ## Attributes reference

        The following attributes are exported:

        - `id` - Unique identifier for the SAML Configuration.
        - `certificate` - Authentication Request Signing Certificate for the user.
        - `assertion_consumer_url` - The URL on Sumo Logic where the IdP will redirect to with its authentication response.
        - `entity_id` - A unique identifier that is the intended audience of the SAML assertion.

        ## Import

        SAML Configuration can be imported using the SAML configuration id, e.g.:

        hcl

        ```sh
        $ pulumi import sumologic:index/samlConfiguration:SamlConfiguration example 00000000454A5979
        ```

        [1]: https://help.sumologic.com/Manage/Security/SAML/01-Set-Up-SAML-for-Single-Sign-On

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] authn_request_url: The URL that the identity provider has assigned for Sumo Logic to submit SAML authentication requests to the identity provider. Defaults to "".
        :param pulumi.Input[str] configuration_name: Name of the SSO policy or another name used to describe the policy internally.
        :param pulumi.Input[bool] debug_mode: True if additional details are included when a user fails to sign in. Defaults to false.
        :param pulumi.Input[bool] disable_requested_authn_context: True if Sumo Logic will include the RequestedAuthnContext element of the SAML AuthnRequests it sends to the identity provider. Defaults to false.
        :param pulumi.Input[str] email_attribute: The email address of the new user account. Defaults to "".
        :param pulumi.Input[bool] is_redirect_binding: True if the SAML binding is of HTTP Redirect type. Defaults to false.
        :param pulumi.Input[str] issuer: The unique URL assigned to the organization by the SAML Identity Provider.
        :param pulumi.Input[bool] logout_enabled: True if users are redirected to a URL after signing out of Sumo Logic. Defaults to false.
        :param pulumi.Input[str] logout_url: The URL that users will be redirected to after signing out of Sumo Logic. Defaults to "".
        :param pulumi.Input[pulumi.InputType['SamlConfigurationOnDemandProvisioningEnabledArgs']] on_demand_provisioning_enabled: The configuration for on-demand provisioning. See on_demand_provisioning_enabled schema for details.
        :param pulumi.Input[str] roles_attribute: The role that Sumo Logic will assign to users when they sign in. Defaults to "".
        :param pulumi.Input[bool] sign_authn_request: True if Sumo Logic will send signed Authn requests to the identity provider. Defaults to false.
        :param pulumi.Input[bool] sp_initiated_login_enabled: True if Sumo Logic redirects users to your identity provider with a SAML AuthnRequest when signing in. Defaults to false.
        :param pulumi.Input[str] sp_initiated_login_path: The identifier used to generate a unique URL for user login. Defaults to "".
        :param pulumi.Input[str] x509cert1: The certificate is used to verify the signature in SAML assertions.
        :param pulumi.Input[str] x509cert2: The backup certificate used to verify the signature in SAML assertions when x509cert1 expires. Defaults to "".
        :param pulumi.Input[str] x509cert3: The backup certificate used to verify the signature in SAML assertions when x509cert1 expires and x509cert2 is empty. Defaults to "".
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SamlConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a [Sumologic SAML Configuration](https://help.sumologic.com/Manage/Security/SAML/01-Set-Up-SAML-for-Single-Sign-On).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sumologic as sumologic

        example_saml_configuration = sumologic.SamlConfiguration("exampleSamlConfiguration",
            sp_initiated_login_path="",
            configuration_name="SumoLogic",
            issuer="http://www.okta.com/abxcseyuiwelflkdjh",
            sp_initiated_login_enabled=False,
            authn_request_url="",
            x509cert1="string",
            x509cert2="",
            x509cert3="",
            on_demand_provisioning_enabled=sumologic.SamlConfigurationOnDemandProvisioningEnabledArgs(
                first_name_attribute="firstName",
                last_name_attribute="lastName",
                on_demand_provisioning_roles=["Administrator"],
            ),
            roles_attribute="Administrator",
            logout_enabled=False,
            logout_url="",
            email_attribute="",
            debug_mode=False,
            sign_authn_request=False,
            disable_requested_authn_context=False,
            is_redirect_binding=False)
        ```

        ## Attributes reference

        The following attributes are exported:

        - `id` - Unique identifier for the SAML Configuration.
        - `certificate` - Authentication Request Signing Certificate for the user.
        - `assertion_consumer_url` - The URL on Sumo Logic where the IdP will redirect to with its authentication response.
        - `entity_id` - A unique identifier that is the intended audience of the SAML assertion.

        ## Import

        SAML Configuration can be imported using the SAML configuration id, e.g.:

        hcl

        ```sh
        $ pulumi import sumologic:index/samlConfiguration:SamlConfiguration example 00000000454A5979
        ```

        [1]: https://help.sumologic.com/Manage/Security/SAML/01-Set-Up-SAML-for-Single-Sign-On

        :param str resource_name: The name of the resource.
        :param SamlConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SamlConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authn_request_url: Optional[pulumi.Input[str]] = None,
                 configuration_name: Optional[pulumi.Input[str]] = None,
                 debug_mode: Optional[pulumi.Input[bool]] = None,
                 disable_requested_authn_context: Optional[pulumi.Input[bool]] = None,
                 email_attribute: Optional[pulumi.Input[str]] = None,
                 is_redirect_binding: Optional[pulumi.Input[bool]] = None,
                 issuer: Optional[pulumi.Input[str]] = None,
                 logout_enabled: Optional[pulumi.Input[bool]] = None,
                 logout_url: Optional[pulumi.Input[str]] = None,
                 on_demand_provisioning_enabled: Optional[pulumi.Input[pulumi.InputType['SamlConfigurationOnDemandProvisioningEnabledArgs']]] = None,
                 roles_attribute: Optional[pulumi.Input[str]] = None,
                 sign_authn_request: Optional[pulumi.Input[bool]] = None,
                 sp_initiated_login_enabled: Optional[pulumi.Input[bool]] = None,
                 sp_initiated_login_path: Optional[pulumi.Input[str]] = None,
                 x509cert1: Optional[pulumi.Input[str]] = None,
                 x509cert2: Optional[pulumi.Input[str]] = None,
                 x509cert3: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SamlConfigurationArgs.__new__(SamlConfigurationArgs)

            __props__.__dict__["authn_request_url"] = authn_request_url
            if configuration_name is None and not opts.urn:
                raise TypeError("Missing required property 'configuration_name'")
            __props__.__dict__["configuration_name"] = configuration_name
            __props__.__dict__["debug_mode"] = debug_mode
            __props__.__dict__["disable_requested_authn_context"] = disable_requested_authn_context
            __props__.__dict__["email_attribute"] = email_attribute
            __props__.__dict__["is_redirect_binding"] = is_redirect_binding
            if issuer is None and not opts.urn:
                raise TypeError("Missing required property 'issuer'")
            __props__.__dict__["issuer"] = issuer
            __props__.__dict__["logout_enabled"] = logout_enabled
            __props__.__dict__["logout_url"] = logout_url
            __props__.__dict__["on_demand_provisioning_enabled"] = on_demand_provisioning_enabled
            __props__.__dict__["roles_attribute"] = roles_attribute
            __props__.__dict__["sign_authn_request"] = sign_authn_request
            __props__.__dict__["sp_initiated_login_enabled"] = sp_initiated_login_enabled
            __props__.__dict__["sp_initiated_login_path"] = sp_initiated_login_path
            if x509cert1 is None and not opts.urn:
                raise TypeError("Missing required property 'x509cert1'")
            __props__.__dict__["x509cert1"] = x509cert1
            __props__.__dict__["x509cert2"] = x509cert2
            __props__.__dict__["x509cert3"] = x509cert3
            __props__.__dict__["assertion_consumer_url"] = None
            __props__.__dict__["certificate"] = None
            __props__.__dict__["entity_id"] = None
        super(SamlConfiguration, __self__).__init__(
            'sumologic:index/samlConfiguration:SamlConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            assertion_consumer_url: Optional[pulumi.Input[str]] = None,
            authn_request_url: Optional[pulumi.Input[str]] = None,
            certificate: Optional[pulumi.Input[str]] = None,
            configuration_name: Optional[pulumi.Input[str]] = None,
            debug_mode: Optional[pulumi.Input[bool]] = None,
            disable_requested_authn_context: Optional[pulumi.Input[bool]] = None,
            email_attribute: Optional[pulumi.Input[str]] = None,
            entity_id: Optional[pulumi.Input[str]] = None,
            is_redirect_binding: Optional[pulumi.Input[bool]] = None,
            issuer: Optional[pulumi.Input[str]] = None,
            logout_enabled: Optional[pulumi.Input[bool]] = None,
            logout_url: Optional[pulumi.Input[str]] = None,
            on_demand_provisioning_enabled: Optional[pulumi.Input[pulumi.InputType['SamlConfigurationOnDemandProvisioningEnabledArgs']]] = None,
            roles_attribute: Optional[pulumi.Input[str]] = None,
            sign_authn_request: Optional[pulumi.Input[bool]] = None,
            sp_initiated_login_enabled: Optional[pulumi.Input[bool]] = None,
            sp_initiated_login_path: Optional[pulumi.Input[str]] = None,
            x509cert1: Optional[pulumi.Input[str]] = None,
            x509cert2: Optional[pulumi.Input[str]] = None,
            x509cert3: Optional[pulumi.Input[str]] = None) -> 'SamlConfiguration':
        """
        Get an existing SamlConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] authn_request_url: The URL that the identity provider has assigned for Sumo Logic to submit SAML authentication requests to the identity provider. Defaults to "".
        :param pulumi.Input[str] configuration_name: Name of the SSO policy or another name used to describe the policy internally.
        :param pulumi.Input[bool] debug_mode: True if additional details are included when a user fails to sign in. Defaults to false.
        :param pulumi.Input[bool] disable_requested_authn_context: True if Sumo Logic will include the RequestedAuthnContext element of the SAML AuthnRequests it sends to the identity provider. Defaults to false.
        :param pulumi.Input[str] email_attribute: The email address of the new user account. Defaults to "".
        :param pulumi.Input[bool] is_redirect_binding: True if the SAML binding is of HTTP Redirect type. Defaults to false.
        :param pulumi.Input[str] issuer: The unique URL assigned to the organization by the SAML Identity Provider.
        :param pulumi.Input[bool] logout_enabled: True if users are redirected to a URL after signing out of Sumo Logic. Defaults to false.
        :param pulumi.Input[str] logout_url: The URL that users will be redirected to after signing out of Sumo Logic. Defaults to "".
        :param pulumi.Input[pulumi.InputType['SamlConfigurationOnDemandProvisioningEnabledArgs']] on_demand_provisioning_enabled: The configuration for on-demand provisioning. See on_demand_provisioning_enabled schema for details.
        :param pulumi.Input[str] roles_attribute: The role that Sumo Logic will assign to users when they sign in. Defaults to "".
        :param pulumi.Input[bool] sign_authn_request: True if Sumo Logic will send signed Authn requests to the identity provider. Defaults to false.
        :param pulumi.Input[bool] sp_initiated_login_enabled: True if Sumo Logic redirects users to your identity provider with a SAML AuthnRequest when signing in. Defaults to false.
        :param pulumi.Input[str] sp_initiated_login_path: The identifier used to generate a unique URL for user login. Defaults to "".
        :param pulumi.Input[str] x509cert1: The certificate is used to verify the signature in SAML assertions.
        :param pulumi.Input[str] x509cert2: The backup certificate used to verify the signature in SAML assertions when x509cert1 expires. Defaults to "".
        :param pulumi.Input[str] x509cert3: The backup certificate used to verify the signature in SAML assertions when x509cert1 expires and x509cert2 is empty. Defaults to "".
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SamlConfigurationState.__new__(_SamlConfigurationState)

        __props__.__dict__["assertion_consumer_url"] = assertion_consumer_url
        __props__.__dict__["authn_request_url"] = authn_request_url
        __props__.__dict__["certificate"] = certificate
        __props__.__dict__["configuration_name"] = configuration_name
        __props__.__dict__["debug_mode"] = debug_mode
        __props__.__dict__["disable_requested_authn_context"] = disable_requested_authn_context
        __props__.__dict__["email_attribute"] = email_attribute
        __props__.__dict__["entity_id"] = entity_id
        __props__.__dict__["is_redirect_binding"] = is_redirect_binding
        __props__.__dict__["issuer"] = issuer
        __props__.__dict__["logout_enabled"] = logout_enabled
        __props__.__dict__["logout_url"] = logout_url
        __props__.__dict__["on_demand_provisioning_enabled"] = on_demand_provisioning_enabled
        __props__.__dict__["roles_attribute"] = roles_attribute
        __props__.__dict__["sign_authn_request"] = sign_authn_request
        __props__.__dict__["sp_initiated_login_enabled"] = sp_initiated_login_enabled
        __props__.__dict__["sp_initiated_login_path"] = sp_initiated_login_path
        __props__.__dict__["x509cert1"] = x509cert1
        __props__.__dict__["x509cert2"] = x509cert2
        __props__.__dict__["x509cert3"] = x509cert3
        return SamlConfiguration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="assertionConsumerUrl")
    def assertion_consumer_url(self) -> pulumi.Output[str]:
        return pulumi.get(self, "assertion_consumer_url")

    @property
    @pulumi.getter(name="authnRequestUrl")
    def authn_request_url(self) -> pulumi.Output[Optional[str]]:
        """
        The URL that the identity provider has assigned for Sumo Logic to submit SAML authentication requests to the identity provider. Defaults to "".
        """
        return pulumi.get(self, "authn_request_url")

    @property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[str]:
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="configurationName")
    def configuration_name(self) -> pulumi.Output[str]:
        """
        Name of the SSO policy or another name used to describe the policy internally.
        """
        return pulumi.get(self, "configuration_name")

    @property
    @pulumi.getter(name="debugMode")
    def debug_mode(self) -> pulumi.Output[Optional[bool]]:
        """
        True if additional details are included when a user fails to sign in. Defaults to false.
        """
        return pulumi.get(self, "debug_mode")

    @property
    @pulumi.getter(name="disableRequestedAuthnContext")
    def disable_requested_authn_context(self) -> pulumi.Output[Optional[bool]]:
        """
        True if Sumo Logic will include the RequestedAuthnContext element of the SAML AuthnRequests it sends to the identity provider. Defaults to false.
        """
        return pulumi.get(self, "disable_requested_authn_context")

    @property
    @pulumi.getter(name="emailAttribute")
    def email_attribute(self) -> pulumi.Output[Optional[str]]:
        """
        The email address of the new user account. Defaults to "".
        """
        return pulumi.get(self, "email_attribute")

    @property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "entity_id")

    @property
    @pulumi.getter(name="isRedirectBinding")
    def is_redirect_binding(self) -> pulumi.Output[Optional[bool]]:
        """
        True if the SAML binding is of HTTP Redirect type. Defaults to false.
        """
        return pulumi.get(self, "is_redirect_binding")

    @property
    @pulumi.getter
    def issuer(self) -> pulumi.Output[str]:
        """
        The unique URL assigned to the organization by the SAML Identity Provider.
        """
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="logoutEnabled")
    def logout_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        True if users are redirected to a URL after signing out of Sumo Logic. Defaults to false.
        """
        return pulumi.get(self, "logout_enabled")

    @property
    @pulumi.getter(name="logoutUrl")
    def logout_url(self) -> pulumi.Output[Optional[str]]:
        """
        The URL that users will be redirected to after signing out of Sumo Logic. Defaults to "".
        """
        return pulumi.get(self, "logout_url")

    @property
    @pulumi.getter(name="onDemandProvisioningEnabled")
    def on_demand_provisioning_enabled(self) -> pulumi.Output[Optional['outputs.SamlConfigurationOnDemandProvisioningEnabled']]:
        """
        The configuration for on-demand provisioning. See on_demand_provisioning_enabled schema for details.
        """
        return pulumi.get(self, "on_demand_provisioning_enabled")

    @property
    @pulumi.getter(name="rolesAttribute")
    def roles_attribute(self) -> pulumi.Output[Optional[str]]:
        """
        The role that Sumo Logic will assign to users when they sign in. Defaults to "".
        """
        return pulumi.get(self, "roles_attribute")

    @property
    @pulumi.getter(name="signAuthnRequest")
    def sign_authn_request(self) -> pulumi.Output[Optional[bool]]:
        """
        True if Sumo Logic will send signed Authn requests to the identity provider. Defaults to false.
        """
        return pulumi.get(self, "sign_authn_request")

    @property
    @pulumi.getter(name="spInitiatedLoginEnabled")
    def sp_initiated_login_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        True if Sumo Logic redirects users to your identity provider with a SAML AuthnRequest when signing in. Defaults to false.
        """
        return pulumi.get(self, "sp_initiated_login_enabled")

    @property
    @pulumi.getter(name="spInitiatedLoginPath")
    def sp_initiated_login_path(self) -> pulumi.Output[Optional[str]]:
        """
        The identifier used to generate a unique URL for user login. Defaults to "".
        """
        return pulumi.get(self, "sp_initiated_login_path")

    @property
    @pulumi.getter
    def x509cert1(self) -> pulumi.Output[str]:
        """
        The certificate is used to verify the signature in SAML assertions.
        """
        return pulumi.get(self, "x509cert1")

    @property
    @pulumi.getter
    def x509cert2(self) -> pulumi.Output[Optional[str]]:
        """
        The backup certificate used to verify the signature in SAML assertions when x509cert1 expires. Defaults to "".
        """
        return pulumi.get(self, "x509cert2")

    @property
    @pulumi.getter
    def x509cert3(self) -> pulumi.Output[Optional[str]]:
        """
        The backup certificate used to verify the signature in SAML assertions when x509cert1 expires and x509cert2 is empty. Defaults to "".
        """
        return pulumi.get(self, "x509cert3")

