"""Core package for the Splurge Exceptions framework.

This package exposes the public exception classes and helpers that form the
core of the Splurge Exceptions project. The package is intentionally small —
it provides semantic exception types and a message formatter for use by
applications and libraries.

Usage example:

    from splurge_exceptions import SplurgeValueError, ErrorMessageFormatter

    exc = SplurgeValueError(error_code="invalid-value", message="Invalid input")
    fmt = ErrorMessageFormatter()
    print(fmt.format_error(exc, include_context=True))

Attributes:
    __version__ (str): Package version string.
    __domains__ (list[str]): Logical domains used by the project.

"""

from splurge_exceptions.core.base import SplurgeError, SplurgeSubclassError
from splurge_exceptions.core.exceptions import (
    SplurgeAttributeError,
    SplurgeFrameworkError,
    SplurgeImportError,
    SplurgeLookupError,
    SplurgeOSError,
    SplurgeRuntimeError,
    SplurgeTypeError,
    SplurgeValueError,
)
from splurge_exceptions.formatting.message import ErrorMessageFormatter

__version__ = "2025.0.1"
__domains__ = ["exceptions", "errors", "handlers"]

__all__ = [
    "SplurgeError",
    "SplurgeSubclassError",
    "SplurgeValueError",
    "SplurgeOSError",
    "SplurgeLookupError",
    "SplurgeRuntimeError",
    "SplurgeTypeError",
    "SplurgeAttributeError",
    "SplurgeImportError",
    "SplurgeFrameworkError",
    "ErrorMessageFormatter",
]
